﻿function hideIESelects() {
    if (tf_isIE) {
        var slc = tf.tbl.getElementsByTagName('select');
        for (var i = 0; i < slc.length; i++)
            slc[i].style.visibility = 'hidden';
    }
}

function showIESelects() {
    if (tf_isIE) {
        var slc = tf.tbl.getElementsByTagName('select');
        for (var i = 0; i < slc.length; i++)
            slc[i].style.visibility = 'visible';
    }
}

var props = {
    filters_row_index: 0,
    sort: true,
    sort_config: {
        sort_types: ['String', 'String', 'Date', 'String', 'String', 'String', 'String', 'String', 'Integer', 'String', 'String']
    },
    remember_grid_values: true,
    alternate_rows: true,
    rows_counter: true,
    rows_counter_text: "Displayed patients: ",
    btn_reset: true,
    btn_reset_text: "Clear",
    btn_text: " > ",
    loader: true,
    loader_text: "Filtering data...",
    loader_html: '<img src="../scripts/TableFilter/loader.gif" alt="" ' +
        'style="vertical-align:middle;" /> Loading...',
    on_show_loader: hideIESelects, //IE only: selects are hidden when loader visible
    on_hide_loader: showIESelects, //IE only: selects are displayed when loader closed
    on_keyup: true,
    col_0: "input",
    col_1: "select",
    col_2: "none",
    col_3: "input",
    col_4: "select",
    col_5: "select",
    col_6: "select",
    col_7: "select",
    col_8: "select",
    col_9: "select",
    col_10: "select",
    display_all_text: "< Show all >",
    custom_slc_options: {
        cols: [10],
        texts: [['Not Generated', 'Generated Successfully', 'Error']],
        values: [['Not Generated', 'Generated Successfully', '!Not Generated && !Generated Successfully']],
        sorts: true
    },
    col_width: ["15%", "85px", "75px", "60px", "10%", "10%", "10%", "70px", "30px", "40px", "10%"],
    base_path: "../scripts/TableFilter/",
    module_path: "../scripts/TableFilter/"
}
var tf = setFilterGrid("patientlist", props);

HideBlankRows(document.getElementById("tableParameters"));

function HideBlankRows(table) {
    for (r = 0; r < table.rows.length; r++) {
        var isBlank = true;
        var row = table.rows[r];
        for (c = 0; c < row.cells.length; c++) {
            var cell = row.cells[c];
            if (cell.nodeName == "TH")
                continue;
            if (cell.innerText != "")
                isBlank = false;
        }
        if (isBlank)
            row.style.display = 'none';
    }
}

function Refresh() {
    var table = document.getElementById("patientlist");
    var dbpms;
    for (r = 0; r < table.rows.length; r++) {
        var row = table.rows[r];
        dbpms += row.id + ";";
    }

    window.external.LoadPatientReportStatus(dbpms);
}

function UpdateTable(refreshPatientListJson) {
    var refreshPatientList = JSON.parse(refreshPatientListJson);
    var table = document.getElementById("patientlist");

    refreshPatientList.forEach(function UpdateRow(refreshPatient) {
        var cell = $(this).find("tr#" + refreshPatient.DocumentBatchPatientMeasureUid).find("td.patient-report-status");
        if (cell.length != 0) {
            if (refreshPatient.PatientReportStatus == "Generated Successfully")
                cell[0].innerHTML = '<a href="#PatientReport?DocumentBatchPatientUid=' + refreshPatient.DocumentBatchPatientUid + '">' + refreshPatient.PatientReportStatus + '</a>'
            else
                cell[0].innerHTML = refreshPatient.PatientReportStatus;
        }
    }, table);
}