SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eCRMessageTracking]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[eCRMessageTracking](
	[eCRUid] [uniqueidentifier] NOT NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[SourceTable] [varchar](100) NULL,
	[RawMessage] [varchar](max) NULL,
	[DateAdded] [datetime] NULL,
	[DateUpdated] [datetime] NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [eCRMessageTracking] ADD  CONSTRAINT [DF_eCRMessageTracking_eCRUid]  DEFAULT (newid()) FOR [eCRUid]
ALTER TABLE [eCRMessageTracking] ADD  CONSTRAINT [DF_eCRMessageTracking_DateAdded]  DEFAULT (getutcdate()) FOR [DateAdded]
ALTER TABLE [eCRMessageTracking] ADD  CONSTRAINT [DF_eCRMessageTracking_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRSDTriggerCodes]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[eRSDTriggerCodes](
	[eRSDUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_eRSDTriggerCodes_eRSDUid]  DEFAULT (newid()),
	[Inactive] [bit] NULL CONSTRAINT [DF_eRSDTriggerCodes_Inactive]  DEFAULT ((0)),
	[RootID] [varchar](40) NULL,
	[Code] [varchar](25) NULL,
	[Display] [varchar](255) NULL,
	[CodeSystem] [varchar](100) NULL,
	[DateAdded] [datetime] NULL CONSTRAINT [DF_eRSDTriggerCodes_DateAdded]  DEFAULT (getutcdate()),
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[VersionID] [smallint] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_eRSDTriggerCodes_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_eRSDTriggerCodes_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[FinancialCenter]') AND name = 'PayToName')
    ALTER TABLE [FinancialCenter] ADD [PayToName] varchar(255) NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'InteliChart' , N'SCHEMA',N'dbo', N'TABLE',N'IcMessageLog', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedLoggingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcMessageLog'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcRelTransacted]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcRelTransacted](
	[IcRelTransactedUid] [uniqueidentifier] NOT NULL,
	[IcTransactedUid] [uniqueidentifier] NOT NULL,
	[ForeignObjectUid] [uniqueidentifier] NOT NULL,
	[ForeignObjectName] [varchar](128) NOT NULL
) ON [PRIMARY]


ALTER TABLE [IcRelTransacted] ADD  CONSTRAINT [DF_IcRelTransacted_IcRelTransactedUid]  DEFAULT (newid()) FOR [IcRelTransactedUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransacted]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransacted](
	[IcTransactedUid] [uniqueidentifier] NOT NULL,
	[InteliChartApiName] [varchar](128) NOT NULL,
	[SuccessfulTransmission] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_IcTransactedUid]  DEFAULT (newid()) FOR [IcTransactedUid]
ALTER TABLE [IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_InteliChartApiName]  DEFAULT ('') FOR [InteliChartApiName]
ALTER TABLE [IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_SuccessfulTransmission]  DEFAULT (getutcdate()) FOR [SuccessfulTransmission]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[JobNotification]') AND name = 'UserDefined')
    ALTER TABLE [JobNotification] ADD [UserDefined] tinyint NOT NULL CONSTRAINT DF_JobNotification_UserDefined DEFAULT ((1)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListEMConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListEMConfiguration](
	[EMConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListEMConfiguration_EMConfigurationUid]  DEFAULT (newid()),
	[Name] [varchar](255) NOT NULL,
	[TypeOfFacility] [smallint] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[ReplacedDate] [datetime] NOT NULL,
	[Configuration] [varchar](max) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'TypeOfFacility', @value=N'<None value="0" /><ServiceFacility value="1" /><Hospital value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEMConfiguration'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListEMServiceSite]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListEMServiceSite](
	[EMServiceSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](10) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ANSICode] [varchar](10) NULL,
	[PlaceOfServiceID] [int] NOT NULL CONSTRAINT [DF_ListEMServiceSite_PlaceOfServiceID]  DEFAULT ((0)),
	[TypeOfServiceID] [int] NOT NULL CONSTRAINT [DF_ListEMServiceSite_TypeOfServiceID]  DEFAULT ((0)),
	[PlaceOfServiceDetailID] [int] NOT NULL CONSTRAINT [DF_ListEMServiceSite_PlaceOfServiceDetailID]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEMServiceSite_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEMServiceSite_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]



END
Truncate Table migtemp_ListEMServiceSite
INSERT [migtemp_ListEMServiceSite]([EMServiceSiteUid],[ExternalID],[Name],[Notes],[ANSICode],[PlaceOfServiceID],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [EMServiceSiteUid],[ExternalID],[Name],[Notes],[ANSICode],[PlaceOfServiceID],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListEMServiceSite]

DROP TABLE [ListEMServiceSite]

exec  sp_rename 'migtemp_ListEMServiceSite', 'ListEMServiceSite'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListFindControlBehavior]') AND name = 'DuplicateDetectionConfig')
    ALTER TABLE [ListFindControlBehavior] ADD [DuplicateDetectionConfig] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMacro]') AND name = 'VisitRequired')
    ALTER TABLE [ListMacro] ADD [VisitRequired] bit NOT NULL CONSTRAINT DF_ListMacro_VisitRequired DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListReport]') AND name = 'LastGenerationDate')
    ALTER TABLE [ListReport] ADD [LastGenerationDate] date NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListReport]') AND name = 'GenerationCount')
    ALTER TABLE [ListReport] ADD [GenerationCount] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListUserSetting]') AND name = 'FHIRClientAddIns')
    ALTER TABLE [ListUserSetting] ADD [FHIRClientAddIns] XML NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientCareManagement]') AND name = 'CareCoordinatorUid')
    ALTER TABLE [PatientCareManagement] ADD [CareCoordinatorUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientCareManagementLog]') AND name = 'DateStarted')
    ALTER TABLE [PatientCareManagementLog] ADD [DateStarted] datetime NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientCareManagementLog]') AND name = 'IsDelete')
    ALTER TABLE [PatientCareManagementLog] ADD [IsDelete] bit NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PracticeSettings]') AND name = 'BillingName')
    ALTER TABLE [PracticeSettings] ADD [BillingName] varchar(100) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Provider]') AND name = 'DrugSearchIncludeInactive')
    ALTER TABLE [Provider] ADD [DrugSearchIncludeInactive] bit NOT NULL CONSTRAINT DF_Provider_DrugSearchIncludeInactive DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPersonIdentitySubject]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPersonIdentitySubject](
	[RelPersonIdentitySubjectUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[SubjectUid] [uniqueidentifier] NOT NULL,
	[Type] [smallint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[VerificationMessage] [varchar](max) NULL,
	[VerificationUrl] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Type', @value=N'<None value ="0"/><Patient value ="1"/><Provider value ="2"/><User value ="3"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPersonIdentitySubject'

ALTER TABLE [RelPersonIdentitySubject] ADD  CONSTRAINT [DF_RelPersonIdentitySubject_RelPersonIdentitySubjectUid]  DEFAULT (newid()) FOR [RelPersonIdentitySubjectUid]
ALTER TABLE [RelPersonIdentitySubject] ADD  CONSTRAINT [DF_RelPersonIdentitySubject_IndentityType]  DEFAULT ((0)) FOR [Type]
ALTER TABLE [RelPersonIdentitySubject] ADD  CONSTRAINT [DF_RelPersonIdentitySubject_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[TransmissionOutbound]') AND name = 'ForeignObjectUid_2')
    ALTER TABLE [TransmissionOutbound] ADD [ForeignObjectUid_2] uniqueidentifier NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[TransmissionOutbound]') AND name = 'ForeignObjectUid_3')
    ALTER TABLE [TransmissionOutbound] ADD [ForeignObjectUid_3] uniqueidentifier NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[TransmissionOutbound]') AND name = 'ForeignObjectName')
    ALTER TABLE [TransmissionOutbound] ADD [ForeignObjectName] varchar(125) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[TransmissionOutbound]') AND name = 'ForeignObjectName_2')
    ALTER TABLE [TransmissionOutbound] ADD [ForeignObjectName_2] varchar(125) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[TransmissionOutbound]') AND name = 'ForeignObjectName_3')
    ALTER TABLE [TransmissionOutbound] ADD [ForeignObjectName_3] varchar(125) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_TypeofVaccineDefault]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_TypeofVaccineDefault](
	[TypeofVaccineDefaultUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_TypeofVaccineDefaultUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_Inactive]  DEFAULT ((0)),
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[ImmzCompletionUid] [uniqueidentifier] NULL,
	[ImmzHistorySourceUid] [uniqueidentifier] NULL,
	[VFCEligibilityUid] [uniqueidentifier] NULL,
	[VaccineDose] [varchar](50) NULL,
	[VaccineUnits] [varchar](60) NULL,
	[VaccineSiteUid] [uniqueidentifier] NULL,
	[VaccineRouteUid] [uniqueidentifier] NULL,
	[VaccineFundingSourceUid] [uniqueidentifier] NULL,
	[VaccineMfrUid] [uniqueidentifier] NULL,
	[VaccineLotNo] [varchar](255) NULL,
	[DateOnVIS] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_DisplayOrder]  DEFAULT ((-1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TypeofVaccineDefault'


END
Truncate Table migtemp_TypeofVaccineDefault
INSERT [migtemp_TypeofVaccineDefault]([TypeofVaccineDefaultUid],[ExternalID],[Inactive],[TypeofVaccineUid],[VFCEligibilityUid],[VaccineDose],[VaccineUnits],[VaccineSiteUid],[VaccineRouteUid],[VaccineFundingSourceUid],[VaccineMfrUid],[VaccineLotNo],[DateOnVIS],[ExpirationDate],[Notes],[DisplayOrder],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [TypeofVaccineDefaultUid],[ExternalID],[Inactive],[TypeofVaccineUid],[VFCEligibilityUid],[VaccineDose],[VaccineUnits],[VaccineSiteUid],[VaccineRouteUid],[VaccineFundingSourceUid],[VaccineMfrUid],[VaccineLotNo],[DateOnVIS],[ExpirationDate],[Notes],[DisplayOrder],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [TypeofVaccineDefault]

DROP TABLE [TypeofVaccineDefault]

exec  sp_rename 'migtemp_TypeofVaccineDefault', 'TypeofVaccineDefault'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_UsageMetric]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_UsageMetric](
	[UsageMetricUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_UsageMetric_UsageMetricUid]  DEFAULT (newid()),
	[SubType] [varchar](250) NOT NULL CONSTRAINT [DF_UsageMetric_SubType]  DEFAULT ('SubType'),
	[MetricValue] [bigint] NOT NULL CONSTRAINT [DF_UsageMetric_MetricValue]  DEFAULT ((0)),
	[CollectionDate] [date] NOT NULL CONSTRAINT [DF_UsageMetric_CollectionDate]  DEFAULT (getdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_UsageMetric_LastModifiedDate]  DEFAULT (getutcdate()),
	[Type] [varchar](250) NOT NULL CONSTRAINT [DF_UsageMetric_Type]  DEFAULT ('Feature Usage')
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table for recording feature usage frequencies.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_UsageMetric'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_UsageMetric'


END
Truncate Table migtemp_UsageMetric
INSERT [migtemp_UsageMetric]([UsageMetricUid],[MetricValue],[CollectionDate],[LastModifiedDate])
SELECT [UsageMetricUid],[MetricValue],[CollectionDate],[LastModifiedDate]
FROM [UsageMetric]

DROP TABLE [UsageMetric]

exec  sp_rename 'migtemp_UsageMetric', 'UsageMetric'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_InsurancePlan]') AND type in (N'U'))
DROP TABLE [IcTransmitted_InsurancePlan]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_ListAppointmentType]') AND type in (N'U'))
DROP TABLE [IcTransmitted_ListAppointmentType]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_ListAppointmentType_Delete]') AND type in (N'U'))
DROP TABLE [IcTransmitted_ListAppointmentType_Delete]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_ListCalendar]') AND type in (N'U'))
DROP TABLE [IcTransmitted_ListCalendar]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_ListServiceSite]') AND type in (N'U'))
DROP TABLE [IcTransmitted_ListServiceSite]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_Patient]') AND type in (N'U'))
DROP TABLE [IcTransmitted_Patient]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_Patient_PracticeSettings]') AND type in (N'U'))
DROP TABLE [IcTransmitted_Patient_PracticeSettings]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_PracticeSettings]') AND type in (N'U'))
DROP TABLE [IcTransmitted_PracticeSettings]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_Provider]') AND type in (N'U'))
DROP TABLE [IcTransmitted_Provider]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_Provider_ListServiceSite]') AND type in (N'U'))
DROP TABLE [IcTransmitted_Provider_ListServiceSite]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_Provider_PracticeSettings]') AND type in (N'U'))
DROP TABLE [IcTransmitted_Provider_PracticeSettings]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IcTransmitted_UserPRM]') AND type in (N'U'))
DROP TABLE [IcTransmitted_UserPRM]
COMMIT TRAN

GO


