
-- #114460 _CDC_Vaccine_Code_Set_Oct_20_2022_Migration.sql
--***CDC VACCINE UPDATES OCT 20 2022 Migration Script***
--Inactivate 225
UPDATE ListCVXCode Set Inactive = '1' WHERE Name = '225'
UPDATE ListCVXCode Set Notes = 'EUA authorized Moderna bivalent booster 2 dose levels: ages 6 yrs thru 11 yrs 0.25mL dose; 12 years and older 0.5mL dose' WHERE Name='229'
UPDATE ListCVXCode Set Notes = 'EUA authorized Pfizer adult bivalent booster ages 12+ yrs, original strain + omicron BA.4/BA.5' WHERE Name='300'
UPDATE ListCVXCode Set Notes = 'EUA authorized (5 yrs through 11 yrs) Pfizer bivalent booster, original strain + omicron BA.4/BA.5' WHERE Name='301'

--SET END DATE FOR NDC11=80631-0100-01
UPDATE VaccineuNitUse SET UseUnitEndDate = '20221031', Inactive='1' WHERE NDC11='80631-0100-01'
UPDATE VaccineuNitUse SET UseUnitEndDate = '20221011', Inactive='1' WHERE NDC11='00006-4963-01'
GO

-- #117917 
UPDATE ListFindControlBehavior SET ServiceAQN = NULL, LastModifiedDate='2022-12-19 13:44:00.000' 
WHERE ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService'
GO

-- #117551 Set end date for Pentacel
Update VaccineUnitUse Set UseUnitEndDate = '20221109', Inactive = '1'
where NDC11 in (
'49281-0560-05',
'49281-0548-58'
)
GO

-- #117846 Update Integration Partner for Appriss to Bamboo (Notes field)
UPDATE ListIntegrationPartner SET Notes = 'PDMP by Bamboo Health' WHERE IntegrationPartnerUid = '39F55A0C-68DA-475F-9755-748A25AD0B31'
GO

-- #117800 .sql
UPDATE ListFindControlBehavior
SET
	SearchColumns = '["ExternalID" ,"FullName"]',
	LastModifiedDate = '2023-01-03 13:03:00'
WHERE Id IN ('InternalProviders', 'ProviderWorklist', 'RxProviders');

UPDATE ListFindControlBehavior
SET
	SearchColumns = '[ "ExternalID", "FormattedInternalName", "Notes" ]',
	LastModifiedDate = '2023-01-03 13:03:00'
WHERE Id = 'ViewProvider';

UPDATE ListFindControlBehavior
SET
	SearchColumns = '["ExternalID" ,"FullName", "ProvFullName"]',
	LastModifiedDate = '2023-01-03 13:03:00'
WHERE Id = 'ViewProviderSupervisor';
GO

-- #117800 .sql
UPDATE ListFindControlBehavior
SET
	SearchColumns = '["ExternalID" ,"FullName"]',
	LastModifiedDate = '2023-01-03 13:03:00'
WHERE Id IN ('InternalProviders', 'ProviderWorklist', 'RxProviders');
UPDATE ListFindControlBehavior
SET
	SearchColumns = '[ "ExternalID", "FormattedInternalName", "Notes" ]',
	LastModifiedDate = '2023-01-03 13:03:00'
WHERE Id = 'ViewProvider';
UPDATE ListFindControlBehavior
SET
	SearchColumns = '["ExternalID" ,"FullName", "ProvFullName"]',
	LastModifiedDate = '2023-01-03 13:03:00'
WHERE Id = 'ViewProviderSupervisor';
UPDATE ListFindControlBehavior
SET
	BeginningWildcard = 1,
	LastModifiedDate = '2023-01-04 09:29:00'
WHERE Id IN ('InternalProviders', 'RxProviders', 'ViewProviderSupervisor');
GO

-- #118202 _Update_ListFindTable_ViewCasesOfPatient_Columns.sql
update ListFindTable Set Columns = '<FindColumn name="" caption=" " visible="true" IsEditable="true" datatype="bool" width="20" />
<FindColumn name="CaseTypeName" caption="Case Type" visible="true" width="100" />
<FindColumn name="CaseName" caption="Case Name" hyperlink="true" visible="true" relwidth="75" width="75" />
<FindColumn name="StartDate" caption="Date Started" datatype="datetime" visible="true" relwidth="90" width="90" />
<FindColumn name="EndDate" caption="Date Ended" datatype="datetime" visible="true" relwidth="90" width="90" />
<FindColumn name="VisitDates" caption="Visit Dates" visible="true" relwidth="100" width="100" />
<FindColumn name="Notes" caption="Notes" visible="true" relwidth="250" width="250" />'
where FindTableUid = 'E8D8F2EC-EF1E-4195-A3C2-FF3D64C3A051'
GO

-- #118732 _CDC_Vaccine_Code_Set_Dec_21_2022 Migration
--Inactivate CVX Codes 140, 144, 166
UPDATE ListCVXCode Set Inactive = 1 WHERE Name in ('140', '144', '166')
--Update CVX Code 204 Notes
Update ListCVXCode SET Notes = 'FDA Approved ERVEBO Vaccine' WHERE Name = '204'
GO

-- #119774 __Migration_Script__CCM_Update_Notes_For_Eligible_Declined_Accepted.sql
update ListPatientCareManagementStatus set Notes = 'Patient''s insurance allows for CCM/CPO billing, patient not yet enrolled.' where Name = 'Eligible'
update ListPatientCareManagementStatus set Notes = 'Patient has declined enrollment.' where Name = 'Declined'
update ListPatientCareManagementStatus set Notes = 'Patient enrolled in CCM/CPO program.' where Name = 'Accepted'
GO

-- #121282 __MIGRATION_SCRIPT__eMEDIX Statements Migrate value from Clearinghouse Pass Phrase to eMEDIX Statement Submitter ID Claim format value type.sql
-- updated 3/20/23 lc  - need this row in ListClaimFormatValueType
IF NOT EXISTS (Select 1 from ListClaimFormatValueType where ClaimFormatValueTypeUid = 'C387C715-07A8-4F6A-8B9B-34A29A4E0B4B')
	INSERT INTO ListClaimFormatValueType (ClaimFormatValueTypeUid, Name, Notes, LastModifiedDate, ClaimFormatValueTypeTypeUid )
	VALUES ('C387C715-07A8-4F6A-8B9B-34A29A4E0B4B', 'eMEDIX Statement Submitter ID', 'For statement files submitted to eMEDIX', '2023-01-30 12:34:56.790', '205448CE-1ABA-4273-B7BD-B4017E789D0C')
-- updated 2/8/23 lc
DECLARE @eMEDIXcLEARINGhOUSE UNIQUEIDENTIFIER = 'D6E113A1-171F-4C35-91E0-01DCCA171B7D'
DECLARE @PassPhrase VarChar(1024) = (SELECT VALUE FROM PlugInSettings WHERE ClaimClearingHouseUid = @eMEDIXcLEARINGhOUSE AND Name = 'PassPhrase')
DECLARE @eMEDIXcLAIMfORMATvALUEtYPE UNIQUEIDENTIFIER = 'C387C715-07A8-4F6A-8B9B-34A29A4E0B4B'
DECLARE @eMEDIXcLAIMfORMATvALUEDeFAULTrOW UNIQUEIDENTIFIER = 'C387C715-07A8-4F6A-8B9B-34A29A4E0B4B'
if @PassPhrase is null return;
IF NOT EXISTS (Select 1 from ClaimFormatValue where ClaimFormatValueTypeUid = @eMEDIXcLAIMfORMATvALUEtYPE and FinancialCenterUid is null)
BEGIN
  Insert Into ClaimFormatValue (ClaimFormatValueUid, FinancialCenterUid, ClaimFormatValueTypeUid, Value) VALUES ('3864AAF4-EC99-4D4A-882C-B429FBF1D00B', NULL,'C387C715-07A8-4F6A-8B9B-34A29A4E0B4B', '')
END
UPDATE ClaimFormatValue SET [VALUE] = @PassPhrase where ClaimFormatValueTypeUid = @eMEDIXcLAIMfORMATvALUEtYPE and FinancialCenterUid is null
GO

-- #120325 _Migration.sql
UPDATE ListFindControlBehavior 
SET 
ColumnsConfig =  '{
"PrimaryKey": "SexualOrientationUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
	"ColumnName": "SexualOrientationUid",
	"ColumnDisplayName": "SexualOrientationUid",
	"Visible": false,
	"CanFilter": false,
	"CanSelect": true,
	"Type": null,
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "ExternalID",
	"ColumnDisplayName": "ID",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 50,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Name",
	"ColumnDisplayName": "Name",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 120,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null,
	"Validation":
	{
	"MaxLength" : 100,
	"MinLength" : 0,
	"IsRequired" : true
	}
},
{
	"ColumnName": "ANSICode",
	"ColumnDisplayName": "ANSI Code",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 60,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Inactive",
	"ColumnDisplayName": "Inactive",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "bool",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Notes",
	"ColumnDisplayName": "Notes",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 250,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "conceptId",
	"ColumnDisplayName": "SNOMED Code",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 120,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "UserDefined",
	"ColumnDisplayName": "UserDefined",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "int",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}
]
}'
WHERE Id in ('ListSexualOrientation')
GO
-- #120325 end

-- #120571 _migration_sync_find_tables.sql
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'F2DFAF83-9A91-40F4-9F35-92D84CAF25DC')
BEGIN
--HealthCareServiceLocation
update ListFindControlBehavior set FindTableUid = 'CE18672F-21CB-4182-AEF0-C64670771E89' where FindControlBehaviorUid = 'F2DFAF83-9A91-40F4-9F35-92D84CAF25DC'
update ListFindControlBehavior set ShowInListEditor = 0 where FindControlBehaviorUid = 'F2DFAF83-9A91-40F4-9F35-92D84CAF25DC'
update ListFindControlBehavior set HasSecurity = 0 where FindControlBehaviorUid = 'F2DFAF83-9A91-40F4-9F35-92D84CAF25DC'
update ListFindControlBehavior set AllowMaintenance = 0 where FindControlBehaviorUid = 'F2DFAF83-9A91-40F4-9F35-92D84CAF25DC'
update ListFindControlBehavior set SecurityGroupUid = null where FindControlBehaviorUid = 'F2DFAF83-9A91-40F4-9F35-92D84CAF25DC'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '4e5cca6a-96db-4e34-8013-6abf94de2de9')
BEGIN
--ListCacheMachine
update ListFindControlBehavior set AuditTableName = 'ListCacheMachine' where FindControlBehaviorUid = '4e5cca6a-96db-4e34-8013-6abf94de2de9'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'abbcd57d-d3d6-4fc1-b43b-cae5e5d895ff')
BEGIN
--ListDisease
update ListFindControlBehavior set AuditTableName = 'ListDisease' where FindControlBehaviorUid = 'abbcd57d-d3d6-4fc1-b43b-cae5e5d895ff'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'ed12f295-5be4-420f-add0-6e0b326adb39')
BEGIN
--ListGender
update ListFindControlBehavior set AuditTableName = 'ListGender' where FindControlBehaviorUid = 'ed12f295-5be4-420f-add0-6e0b326adb39'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '1E7E9D02-DA00-4916-B579-F9339487AE4E')
BEGIN
--ListHistoryGroup
update ListFindControlBehavior set FindTableUid = '37B70BC6-9BAC-483C-8A8C-30ED1279A5F0' where FindControlBehaviorUid = '1E7E9D02-DA00-4916-B579-F9339487AE4E'
update ListFindControlBehavior set HasSecurity = 0 where FindControlBehaviorUid = '1E7E9D02-DA00-4916-B579-F9339487AE4E'
update ListFindControlBehavior set AllowMaintenance = 0 where FindControlBehaviorUid = '1E7E9D02-DA00-4916-B579-F9339487AE4E'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '39481252-5e7d-44c0-8edd-80ee21dd2097')
BEGIN
--ListImmzContraindication
update ListFindControlBehavior set FindTableUid = '1a078b6a-5330-494b-b49b-5a76cb886b40' where FindControlBehaviorUid = '39481252-5e7d-44c0-8edd-80ee21dd2097'
update ListFindControlBehavior set SecurityGroupUid = '05ebd387-4aa2-4c89-9cfe-5ce59c056894' where FindControlBehaviorUid = '39481252-5e7d-44c0-8edd-80ee21dd2097'
update ListFindControlBehavior set AuditTableName = 'ListImmzContraindication' where FindControlBehaviorUid = '39481252-5e7d-44c0-8edd-80ee21dd2097'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '50efd56c-45f0-4e6f-84f8-7ab7593319e3')
BEGIN
-- Name: Immunization Immunity / Id: ListImmzEvidenceOfImmunity   
update ListFindControlBehavior set FindTableUid = 'cad85506-94c1-414d-8e52-1a79f823dfcf' where FindControlBehaviorUid = '50efd56c-45f0-4e6f-84f8-7ab7593319e3'
update ListFindControlBehavior set SecurityGroupUid = '05ebd387-4aa2-4c89-9cfe-5ce59c056894' where FindControlBehaviorUid = '50efd56c-45f0-4e6f-84f8-7ab7593319e3'
update ListFindControlBehavior set AuditTableName = 'ListImmzEvidenceOfImmunity' where FindControlBehaviorUid = '50efd56c-45f0-4e6f-84f8-7ab7593319e3'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'f3f88751-f2fb-4504-be02-465211580bf2')
BEGIN
--ListImmzReaction
update ListFindControlBehavior set FindTableUid = '5af2f81d-62c0-43d3-ac6c-400fc67152b3' where FindControlBehaviorUid = 'f3f88751-f2fb-4504-be02-465211580bf2'
update ListFindControlBehavior set SecurityGroupUid = '05ebd387-4aa2-4c89-9cfe-5ce59c056894' where FindControlBehaviorUid = 'f3f88751-f2fb-4504-be02-465211580bf2'
update ListFindControlBehavior set AuditTableName = 'ListImmzReaction' where FindControlBehaviorUid = 'f3f88751-f2fb-4504-be02-465211580bf2'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'b5f0302a-6c6e-4b74-8021-a6ac916a854c')
BEGIN
--Immunization Special Indications
update ListFindControlBehavior set FindTableUid = '55640563-3532-4591-9c5a-412b83a7e67f' where FindControlBehaviorUid = 'b5f0302a-6c6e-4b74-8021-a6ac916a854c'
update ListFindControlBehavior set SecurityGroupUid = '05ebd387-4aa2-4c89-9cfe-5ce59c056894' where FindControlBehaviorUid = 'b5f0302a-6c6e-4b74-8021-a6ac916a854c'
update ListFindControlBehavior set AuditTableName = 'ListImmzSpecialIndications' where FindControlBehaviorUid = 'b5f0302a-6c6e-4b74-8021-a6ac916a854c'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '8d3bebad-e475-4747-be15-57c390120b92')
BEGIN
--Misc List
update ListFindControlBehavior set FindTableUid = 'a84768bd-706b-4e2b-ad30-f261c4444a60' where FindControlBehaviorUid = '8d3bebad-e475-4747-be15-57c390120b92'
update ListFindControlBehavior set ShowInListEditor = 0 where FindControlBehaviorUid = '8d3bebad-e475-4747-be15-57c390120b92'
update ListFindControlBehavior set AuditTableName = 'ListMisc' where FindControlBehaviorUid = '8d3bebad-e475-4747-be15-57c390120b92'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'cc7bae6c-2b1d-4686-9377-249c4351d8b1')
BEGIN
--Procedure History 
update ListFindControlBehavior set FindTableUid = '79f674ae-23b6-412a-abac-e52e3193a434' where FindControlBehaviorUid = 'cc7bae6c-2b1d-4686-9377-249c4351d8b1'
update ListFindControlBehavior set HasSecurity = 1 where FindControlBehaviorUid = 'cc7bae6c-2b1d-4686-9377-249c4351d8b1'
update ListFindControlBehavior set SecurityGroupUid = '10101010-0000-0000-0000-000000000021' where FindControlBehaviorUid = 'cc7bae6c-2b1d-4686-9377-249c4351d8b1'
update ListFindControlBehavior set AuditTableName = 'ProcedureHistoryTerm' where FindControlBehaviorUid = 'cc7bae6c-2b1d-4686-9377-249c4351d8b1'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'c65ec38d-d225-45f3-85d7-656f9870c7f3')
BEGIN
--Macro Group 
update ListFindControlBehavior set FindTableUid = '8671e56a-9313-4d05-9e71-d1e6347a7a51' where FindControlBehaviorUid = 'c65ec38d-d225-45f3-85d7-656f9870c7f3'
update ListFindControlBehavior set ShowInListEditor = 0  where FindControlBehaviorUid = 'c65ec38d-d225-45f3-85d7-656f9870c7f3'
update ListFindControlBehavior set HasSecurity = 1 where FindControlBehaviorUid = 'c65ec38d-d225-45f3-85d7-656f9870c7f3'
update ListFindControlBehavior set AllowMaintenance = 0 where FindControlBehaviorUid = 'c65ec38d-d225-45f3-85d7-656f9870c7f3'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '49c0583b-4faa-4d29-93dc-4ecde4e80580')
BEGIN
--ViewMacroGroupUser
update ListFindControlBehavior set FindTableUid = 'af9882af-d872-49f7-9e29-ef874aa0625b' where FindControlBehaviorUid = '49c0583b-4faa-4d29-93dc-4ecde4e80580'
update ListFindControlBehavior set ShowInListEditor = 0 where FindControlBehaviorUid = '49c0583b-4faa-4d29-93dc-4ecde4e80580'
update ListFindControlBehavior set HasSecurity = 1 where FindControlBehaviorUid = '49c0583b-4faa-4d29-93dc-4ecde4e80580'
update ListFindControlBehavior set AllowMaintenance = 0 where FindControlBehaviorUid = '49c0583b-4faa-4d29-93dc-4ecde4e80580'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '3191139c-7ef9-4b8b-b6b9-729e8dcf6734')
BEGIN
--ListMessageSubType
update ListFindControlBehavior set AuditTableName = 'ListMessageSubType' where FindControlBehaviorUid = '3191139c-7ef9-4b8b-b6b9-729e8dcf6734'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '4f9d2bb0-40a4-48d5-af8a-b5b8bf90759f')
BEGIN
--ListMessageUrgency
update ListFindControlBehavior set AuditTableName = 'ListMessageUrgency' where FindControlBehaviorUid = '4f9d2bb0-40a4-48d5-af8a-b5b8bf90759f'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '139273d6-edab-49c1-b6b3-1425f4fc4d87')
BEGIN
--ListPrintSet
update ListFindControlBehavior set AuditTableName = 'ListPrintSet' where FindControlBehaviorUid = '139273d6-edab-49c1-b6b3-1425f4fc4d87'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'eb7b41d9-5038-4c6c-b636-f638e7562d04')
BEGIN
--ListRelationship
update ListFindControlBehavior set AuditTableName = 'ListRelationship' where FindControlBehaviorUid = 'eb7b41d9-5038-4c6c-b636-f638e7562d04'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '796301bb-99e7-4bc1-9cab-40e71efc4f3c')
BEGIN
--ListRoom
update ListFindControlBehavior set AuditTableName = 'ListRoom' where FindControlBehaviorUid = '796301bb-99e7-4bc1-9cab-40e71efc4f3c'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'd64e4a20-245c-4642-a9b3-98b99766683b')
BEGIN
--ListTimespan
update ListFindControlBehavior set AuditTableName = 'ListTimespan' where FindControlBehaviorUid = 'd64e4a20-245c-4642-a9b3-98b99766683b'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '65ef6edf-7a33-440c-be3e-033b4c1c1ca8')
BEGIN
--ProcedureHistoryStatus
update ListFindControlBehavior set AuditTableName = 'ProcedureHistoryStatus' where FindControlBehaviorUid = '65ef6edf-7a33-440c-be3e-033b4c1c1ca8'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '8f3cdcdf-a4ed-4881-8696-a11a99e6dae3')
BEGIN
--SO
update ListFindControlBehavior set AuditTableName = 'ListProcedure' where FindControlBehaviorUid = '8f3cdcdf-a4ed-4881-8696-a11a99e6dae3'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'd46c0678-2f27-4dd1-83a5-3df9d5d9031a')
BEGIN
--SP
update ListFindControlBehavior set AuditTableName = 'ListProcedure' where FindControlBehaviorUid = 'd46c0678-2f27-4dd1-83a5-3df9d5d9031a'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '0883eaf3-c6b3-494a-a368-030289be32f4')
BEGIN
--ViewProvider
update ListFindControlBehavior set AuditTableName = 'Provider' where FindControlBehaviorUid = '0883eaf3-c6b3-494a-a368-030289be32f4'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'e6957f49-aa74-42e0-9018-deddb79ece73')
BEGIN
-- Name: Laboratory / Id: ListLaboratory
update ListFindControlBehavior set AuditTableName = 'ListLaboratory' where FindControlBehaviorUid = 'e6957f49-aa74-42e0-9018-deddb79ece73'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'b8325810-13c7-44af-88fb-287a216d18cf')
BEGIN
--document linking folder type
update ListFindControlBehavior set Id = 'DocumentLinkingFolderType' where FindControlBehaviorUid = 'B8325810-13C7-44AF-88FB-287A216D18CF'
update ListFindControlBehavior set AuditTableName = 'DocumentLinkingFolderType' where FindControlBehaviorUid = 'b8325810-13c7-44af-88fb-287a216d18cf'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'F8EAF44B-4CCD-49E2-B529-38F0ADEF952C')
BEGIN
--Hx Relationship
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = 'F8EAF44B-4CCD-49E2-B529-38F0ADEF952C'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '45DBF346-6D89-4C5A-BA28-00F0612C21FF')
BEGIN
--Observation Item
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '45DBF346-6D89-4C5A-BA28-00F0612C21FF'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'B741ECF4-3F6A-4A31-8703-3AA1B323169C')
BEGIN
--VaccineFiltered
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = 'B741ECF4-3F6A-4A31-8703-3AA1B323169C'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '7B5877F9-6959-4F8E-A5A0-095B46B302EE')
BEGIN
--Find Qualified Contact
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '7B5877F9-6959-4F8E-A5A0-095B46B302EE'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '1ACCDCCA-C343-457A-8665-BCB508FD2E1F')
BEGIN
--Find Provider
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '1ACCDCCA-C343-457A-8665-BCB508FD2E1F'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '7fc03cfd-3b20-43b3-b731-8131b2bc8ac7')
BEGIN
--FindProcedureGroupOnly
update ListFindControlBehavior set AuditTableName = 'ListHistoryGroup' where FindControlBehaviorUid = '7fc03cfd-3b20-43b3-b731-8131b2bc8ac7'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'fb11e99a-8b5a-4d8f-8e8a-961b0b1204bc')
BEGIN
--ListAmendmentSource
update ListFindControlBehavior set AuditTableName = 'ListAmendmentSource' where FindControlBehaviorUid = 'fb11e99a-8b5a-4d8f-8e8a-961b0b1204bc'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'a8bc4fcc-9e9b-4ca9-9db3-5d59a791bc9d')
BEGIN
--ListAppointmentStatus
update ListFindControlBehavior set AuditTableName = 'ListAppointmentStatus' where FindControlBehaviorUid = 'a8bc4fcc-9e9b-4ca9-9db3-5d59a791bc9d'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '13c9ded1-d67f-4c08-9552-bb6406eadb72')
BEGIN
--ListAppointmentType
update ListFindControlBehavior set AuditTableName = 'ListAppointmentType' where FindControlBehaviorUid = '13c9ded1-d67f-4c08-9552-bb6406eadb72'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '13fdd12d-1eb3-4a9b-ae4a-c8c1e2a59ed9')
BEGIN
--ListAttachmentType
update ListFindControlBehavior set AuditTableName = 'ListAttachmentType' where FindControlBehaviorUid = '13fdd12d-1eb3-4a9b-ae4a-c8c1e2a59ed9'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'f1dc66bf-e920-4991-a6db-0de718364c78')
BEGIN
--ListCalendar
update ListFindControlBehavior set AuditTableName = 'ListCalendar' where FindControlBehaviorUid = 'f1dc66bf-e920-4991-a6db-0de718364c78'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'a4713d07-d853-4654-ab26-d8de72a6f910')
BEGIN
--ListEduForm
update ListFindControlBehavior set AuditTableName = 'ListEduForm' where FindControlBehaviorUid = 'a4713d07-d853-4654-ab26-d8de72a6f910'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '8ab33b6b-90c3-4c56-9262-ecc7081bee88')
BEGIN
--ListHistorian
update ListFindControlBehavior set AuditTableName = 'ListHistorian' where FindControlBehaviorUid = '8ab33b6b-90c3-4c56-9262-ecc7081bee88'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'f9a01cf1-cc3e-453a-9f46-bd5e698a85e4')
BEGIN
--ListImmzCompletion
update ListFindControlBehavior set AuditTableName = 'ListImmzCompletion' where FindControlBehaviorUid = 'f9a01cf1-cc3e-453a-9f46-bd5e698a85e4'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '45ff8018-b530-429a-a306-71380d8219c4')
BEGIN
--ListImmzHistorySource
update ListFindControlBehavior set AuditTableName = 'ListImmzHistorySource' where FindControlBehaviorUid = '45ff8018-b530-429a-a306-71380d8219c4'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'cb0d0624-3481-4795-8db2-1db4d2316846')
BEGIN
--ListImmzRefusal
update ListFindControlBehavior set AuditTableName = 'ListImmzRefusal' where FindControlBehaviorUid = 'cb0d0624-3481-4795-8db2-1db4d2316846'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'c7b69e74-7c1c-4c85-b3f0-f40dbc330df4')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListMaritalStatus' where FindControlBehaviorUid = 'c7b69e74-7c1c-4c85-b3f0-f40dbc330df4'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'aa2fc291-296f-4827-b250-f984c0f20856')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListMessageType' where FindControlBehaviorUid = 'aa2fc291-296f-4827-b250-f984c0f20856'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '82d755bc-bc3a-4cd1-b379-ecbea30c4655')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListPatientProgram' where FindControlBehaviorUid = '82d755bc-bc3a-4cd1-b379-ecbea30c4655'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'c1e7651c-1d02-481a-bcbe-ba3c855374e2')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListProcedureModifier' where FindControlBehaviorUid = 'c1e7651c-1d02-481a-bcbe-ba3c855374e2'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'cc879da2-ae4c-44cd-b73e-d41f8140f308')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListServiceSite' where FindControlBehaviorUid = 'cc879da2-ae4c-44cd-b73e-d41f8140f308'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '3f93a9a7-d3b3-4d00-80fd-9063f9f46434')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListTypeofVaccine' where FindControlBehaviorUid = '3f93a9a7-d3b3-4d00-80fd-9063f9f46434'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '17831586-9130-4d78-9122-86c432d64b9b')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVaccineAdmin' where FindControlBehaviorUid = '17831586-9130-4d78-9122-86c432d64b9b'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'f1d2eb3f-3d13-4500-aacf-debeb2e1812e')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVaccineFundingSource' where FindControlBehaviorUid = 'f1d2eb3f-3d13-4500-aacf-debeb2e1812e'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '963c5cec-8aee-4106-88c0-3e52a9015da4')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVaccineMfr' where FindControlBehaviorUid = '963c5cec-8aee-4106-88c0-3e52a9015da4'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '8202164c-7ad3-4824-81aa-34c37ab18e04')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVaccineRoute' where FindControlBehaviorUid = '8202164c-7ad3-4824-81aa-34c37ab18e04'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'c8cd035f-5411-40b2-b801-436f354d6662')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVaccineSite' where FindControlBehaviorUid = 'c8cd035f-5411-40b2-b801-436f354d6662'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'b75ad9c9-9728-4c79-ad7e-a1c7eaeadd62')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVFCEligibility' where FindControlBehaviorUid = 'b75ad9c9-9728-4c79-ad7e-a1c7eaeadd62'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'c77fe12b-6a6e-4033-8a6d-ff56eb25db7f')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListWeightConditions' where FindControlBehaviorUid = 'c77fe12b-6a6e-4033-8a6d-ff56eb25db7f'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'fd9801f9-ee73-4826-9318-133d96358705')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListNegationReason' where FindControlBehaviorUid = 'fd9801f9-ee73-4826-9318-133d96358705'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'f7d62b7e-e29d-4175-aa79-61ae23e2f2b8')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ObservationCustomUser' where FindControlBehaviorUid = 'f7d62b7e-e29d-4175-aa79-61ae23e2f2b8'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'c5ec25ad-b3ca-42cb-b938-33a02a00cbc0')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ProblemStatus' where FindControlBehaviorUid = 'c5ec25ad-b3ca-42cb-b938-33a02a00cbc0'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'dded59ea-c2b8-4fb0-be0d-71feb5a7af6d')
BEGIN
update ListFindControlBehavior set AuditTableName = 'ListVaccine' where FindControlBehaviorUid = 'dded59ea-c2b8-4fb0-be0d-71feb5a7af6d'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '7840e6df-c696-4412-85b2-4590415a83b1')
BEGIN
update ListFindControlBehavior set AuditTableName = 'WaitingList' where FindControlBehaviorUid = '7840e6df-c696-4412-85b2-4590415a83b1'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C')
BEGIN
--ListFilter
update ListFindControlBehavior set id = 'ListFilterV2' where FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '22A3DFBA-2339-41CF-ABEF-A97CBF6795DB')
BEGIN
--ViewBookingTime
update ListFindControlBehavior set id = 'ViewBookingTimeV2' where FindControlBehaviorUid = '22A3DFBA-2339-41CF-ABEF-A97CBF6795DB'
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '22A3DFBA-2339-41CF-ABEF-A97CBF6795DB'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'C65EC38D-D225-45F3-85D7-656F9870C7F3')
BEGIN
--ViewMacroGroupUserV2
update ListFindControlBehavior set id = 'ViewMacroGroupUserV2' where FindControlBehaviorUid = 'C65EC38D-D225-45F3-85D7-656F9870C7F3'
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = 'C65EC38D-D225-45F3-85D7-656F9870C7F3'
update ListFindControlBehavior set name ='Macro Group By User' where FindControlBehaviorUid = 'C65EC38D-D225-45F3-85D7-656F9870C7F3'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '49C0583B-4FAA-4D29-93DC-4ECDE4E80580')
BEGIN
--ViewMacroGroupUser_SelectableV2
update ListFindControlBehavior set id = 'ViewMacroGroupUser_SelectableV2' where FindControlBehaviorUid = '49C0583B-4FAA-4D29-93DC-4ECDE4E80580'
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '49C0583B-4FAA-4D29-93DC-4ECDE4E80580'
END

IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A')
BEGIN
--ViewMacroGroupUser_SelectableV2
update ListFindControlBehavior set id = 'ViewFNDConfigurationV2' where FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'
update ListFindControlBehavior set FindTableUid = null where FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'
END

IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5')
BEGIN
delete ListFindTable where FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5'
END

IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32')
BEGIN
delete ListFindTable where FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32'
END
GO

-- #120571 end

-- #121284 __MIGRATION_SCRIPT__eMEDIX Statements  
DECLARE @ClaimClearingHouseEmedixUid uniqueidentifier = 'D6E113A1-171F-4C35-91E0-01DCCA171B7D'
DECLARE @EmedixElectronicStatementsHL7PartnerUid uniqueidentifier = '9695387A-3325-40E4-A8C4-B8B53162C9FA'

if NOT exists (select 1/0 from ListClaimClearingHouse where ClaimClearingHouseUid = @ClaimClearingHouseEmedixUid and Inactive = 0) return;
if NOT exists (select 1/0 from HL7Partner where HL7PartnerUid = @EmedixElectronicStatementsHL7PartnerUid and Inactive = 0) return;

DECLARE @UserName varchar(512), @Password varchar(512), @Server varchar(512), @http varchar(512)
select @Password = Value from PlugInSettings where ClaimClearingHouseUid = @ClaimClearingHouseEmedixUid and name = 'FTPPassword'
select @Server   = Value from PlugInSettings where ClaimClearingHouseUid = @ClaimClearingHouseEmedixUid and name = 'FTPServer'
select @UserName = Value from PlugInSettings where ClaimClearingHouseUid = @ClaimClearingHouseEmedixUid and name = 'FTPUserName'
select @http     = Value from PlugInSettings where ClaimClearingHouseUid = @ClaimClearingHouseEmedixUid and name = 'FTPHTTPS'
DECLARE @Settings varchar(2048) = '<settings WSAuthenticateURL="' + @http +'" WSUsername="' + @UserName + '" WSPassword="' + @Password + '" WSClientId="' + @Server + '"><OutboundConnID /><InboundConnID /><MachineID /><ClientID /><Password /><Username /><MailboxURL /><AprimaURL /></settings>'

UPDATE HL7Partner SET TransmissionSettings = @Settings where HL7PartnerUid = @EmedixElectronicStatementsHL7PartnerUid
GO

-- #121074 _Migration.sql
--CDC Vaccine updates as of Jan 26, 2023 Migration Script
--Update CVX code notes
--197
UPDATE ListCVXCode SET CVXFullVaccineName = 'influenza, high-dose seasonal, quadrivalent, 0.7mL dose, preservative free'
WHERE CVXCodeUid = 'BB2A3F23-F4C3-4B9D-A9DF-1831A58B1979'
--203
UPDATE ListCVXCode SET CVXFullVaccineName = 'meningococcal polysaccharide (groups A, C, Y, W-135) tetanus toxoid conjugate vaccine 0.5mL dose, preservative free'
WHERE CVXCodeUid = '5BF3B9DF-B97F-48F3-86DC-17C1DFB55340'
--205
UPDATE ListCVXCode SET CVXFullVaccineName = 'influenza, seasonal vaccine, quadrivalent, adjuvanted, 0.5mL dose, preservative free'
WHERE CVXCodeUid = '587FDDC6-3ECF-4E16-AFC7-597B9E756744'
--Retire NDC entries in VaccineUnitUse
--20230106 end date
UPDATE VaccineUnitUse SET UseUnitEndDate = '20230106' WHERE NDC11 IN
('49281-0606-58', 
'43528-0003-01',
'49281-0246-58',
'50090-2883-09',
'49281-0589-58',
'50632-0013-01',
'49281-0913-01',
'49281-0215-58',
'49281-0215-88',
'49281-0790-38',
'49281-0790-88',
'49281-0915-58',
'49281-0915-68'
)
--20221231 end date
UPDATE VaccineUnitUse SET UseUnitEndDate = '20221231' WHERE NDC11 IN
('49281-0322-88', 
'49281-0339-78')
--20171020 end date
UPDATE VaccineUnitUse SET UseUnitEndDate = '20171020' WHERE NDC11 IN
('58160-0828-01')
GO

-- #118651
update ListFindControlBehavior 
set ColumnsConfig = '{"PrimaryKey":"CacheMachineUid","PrimaryDisplayName":"Name","InactiveColumnName":null,"Columns":[{"ColumnName":"CacheMachineUid","ColumnDisplayName":"CacheMachineUid","Visible":false,"CanFilter":false,"CanSelect":false,"Type":"string","Width":0,"SortOrder":0,"SortDirection":"Ascending","AdditionalInfoDto":null},{"ColumnName":"Inactive","ColumnDisplayName":"Inactive","Visible":false,"CanFilter":true,"CanSelect":false,"Type":"bool","Width":0,"SortOrder":0,"SortDirection":"Ascending","AdditionalInfoDto":null},{"ColumnName":"ExternalID","ColumnDisplayName":"ID","Visible":true,"CanFilter":true,"CanSelect":true,"Type":"string","Width":50,"SortOrder":0,"SortDirection":"Ascending","AdditionalInfoDto":null},{"ColumnName":"Name","ColumnDisplayName":"Name","Visible":true,"CanFilter":true,"CanSelect":true,"Type":"string","Width":150,"SortOrder":1,"SortDirection":"Ascending","AdditionalInfoDto":null},{"ColumnName":"URL","ColumnDisplayName":"URL","Visible":true,"CanFilter":true,"CanSelect":true,"Type":"string","Width":200,"SortOrder":0,"SortDirection":"Ascending","AdditionalInfoDto":null},{"ColumnName":"Notes","ColumnDisplayName":"Notes","Visible":true,"CanFilter":false,"CanSelect":false,"Type":"string","Width":225,"SortOrder":0,"SortDirection":"Ascending","AdditionalInfoDto":null}]}'
where FindControlBehaviorUid = '4E5CCA6A-96DB-4E34-8013-6ABF94DE2DE9'
GO

-- #109372 
update ListMacro
set ListMacro.VisitRequired = 1
from ListMacro lm
where lm.DataContext = 1 or lm.DataSource = 1 or lm.Goal is not null or exists (select 1 from ListMacroDiagnosis lmd where lmd.MacroUid = lm.MacroUid) or exists (select 1 from ListMacroProcedure lmp where lmp.MacroUid = lm.MacroUid)

update ListMacro
set DataSource = 2, DataContext = 2, VisitRequired = 0, ActionAQN = null
where MacroUid = 'C34C187A-1CF1-421B-80BD-A130DA747B6C'
GO

-- #121337 Migration Script.sql - updated on 02/28/23
-- Migration Script for user story 121337 - E&M 2023: PrePopulate Location Based on ANSI Code
if not exists (select * from ListEMServiceSite where EMServiceSiteUid = 'EE915218-2205-4766-985A-395E1375D76A')
begin
	INSERT INTO [ListEMServiceSite]
			   ([EMServiceSiteUid]
			   ,[ExternalID]
			   ,[Name]
			   ,[Notes]
			   ,[ANSICode]
			   ,[PlaceOfServiceID]
			   ,[Inactive]
			   ,[UserDefined]
			   ,[LastModifiedByUid]
			   ,[LastModifiedDate])
		 VALUES
			   ('EE915218-2205-4766-985A-395E1375D76A' --<EMServiceSiteUid, uniqueidentifier,>
			   ,'2' --<ExternalID, varchar(10),>
			   ,'Telehealth' -- <Name, varchar(255),>
			   ,null --<Notes, varchar,>
			   ,'2'--<ANSICode, varchar(10),>
			   ,9 -- <PlaceOfServiceID, int>
			   ,0 --<Inactive, bit,>
			   ,0 -- <UserDefined, tinyint,>
			   ,null --<LastModifiedByUid, uniqueidentifier,>
			   ,'11/28/2022' -- <LastModifiedDate, datetime,>
			   )
end
go

-- set all notes to null
update ListEMServiceSite set Notes = null
go

-- update type of service for group home
update ListEMServiceSite set PlaceOfServiceID = 8, TypeOfServiceID = 0
	where EMServiceSiteUid = '0D66E6B6-05DC-42C2-9237-02400DB40E41'
go

-- update type of service for office
update ListEMServiceSite set PlaceOfServiceID = 1, TypeOfServiceID = 2
	where EMServiceSiteUid = 'C4B661A2-AAEB-401E-9694-E5F2B2CE55E2'
go

-- update Home and Residence: 12 Default "Established" Detail "None" 
update ListEMServiceSite set Name = 'Home and Residence', PlaceOfServiceID = 7, TypeOfServiceID = 20, Notes = null 
	where EMServiceSiteUid = 'CBDE7571-1CB4-46A4-A8E7-DD75D00486C7'
go

-- update Nursing Facility: 32 Default "Subsequent"
update ListEMServiceSite set PlaceOfServiceID = 6, TypeOfServiceID = 5 
	where EMServiceSiteUid = 'A5FAE35C-5824-48C8-AC4E-C3FB402B72F8'
go

-- update Telehealth: 2 Default "Established Face-to-Face"
update ListEMServiceSite set PlaceOfServiceID = 9, TypeOfServiceID = 25
	where EMServiceSiteUid = 'EE915218-2205-4766-985A-395E1375D76A'
go

-- update Hospital Inpatient & Observation: 21 Default "Subsequent"
update ListEMServiceSite set Name = 'Hospital Inpatient and Observation', PlaceOfServiceID = 2, TypeOfServiceID = 29, Notes = null 
	where EMServiceSiteUid = '47031385-D6C8-4ABC-9685-4EBD098E7BEC'
go

-- update Hospital Inpatient & Observation: 22 Default "Subsequent"
update ListEMServiceSite set Name = 'Hospital Observation', PlaceOfServiceID = 2, TypeOfServiceID = 29, Notes = null 
	where EMServiceSiteUid = 'C2E66565-6C16-4A62-9807-048A1A44A871'
go

-- update Hospital ER: 23 No Default 
update ListEMServiceSite set PlaceOfServiceID = 5
	where EMServiceSiteUid = '0D200FCC-0D4E-4101-B572-4C3D40D32197'
go

-- update Hospital Critical Care: NA (No prepop for this Location)
update ListEMServiceSite set PlaceOfServiceID = 4
	where EMServiceSiteUid = '4894F62B-2E6D-4189-8587-B952992DA406'
go
-- #121337 end

-- #123755
-- ===========================================================
-- User Story: 123755 - User Setting field on Configure Facility
--                      Portal window does not default to 
--                      expected user setting (Default)
--
-- Description: Facility Portal configuration row
--              FacilityPortal.Configuration.UserSetting
--              should default to Default
--
-- Developer: djost 
--
-- History: 2023.02.23 - Script created.
-- =========================================================== 
IF (EXISTS(SELECT * FROM ListProductParameter WHERE ProductParameterUid = 'A3259D51-025B-4EC9-ADDD-A6F00932AB17'))
BEGIN
  UPDATE ListProductParameter
    SET XMLValue = '<!--Facility Portal User Setting--><UserSetting><UserSettingUid>10101010-1111-1000-0000-000000000001</UserSettingUid><Name>Default</Name></UserSetting>'
	WHERE ProductParameterUid = 'A3259D51-025B-4EC9-ADDD-A6F00932AB17'
END
GO

-- #123850
-- ===========================================================
-- Bug: 123850 - ListFindControlBehavior attribute does not
--               match ListFindTable - ListUserSetting
--
-- Description: ListFindControlBehavior.AuditTableName
--              should be ListUserSetting
--
-- Developer: djost 
--
-- History: 2023.02.24 - Script created.
-- =========================================================== 
IF (EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = 'AF204F31-1B93-4BD7-971E-F2A48CB8E75B'))
BEGIN
  UPDATE ListFindControlBehavior
    SET AuditTableName = 'ListUserSetting'
	WHERE FindControlBehaviorUid = 'AF204F31-1B93-4BD7-971E-F2A48CB8E75B'
END
GO

-- #123788 upgrade script.sql
-- update calendar
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "CalendarUid", "PrimaryDisplayName": "Name", "InactiveColumnName": "Inactive", "Columns": [ { "ColumnName": "CalendarUid", "ColumnDisplayName": "CalendarUid", "Visible": false, "CanFilter": false, "CanSelect": true, "Type": null, "Width": 0, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": true, "CanFilter": true, "CanSelect": false, "Type": "string", "Width": 50, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": true, "CanFilter": true, "CanSelect": true, "Type": "string", "Width": 200, "SortOrder": 1, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "250" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": false, "CanFilter": true, "CanSelect": false, "Type": "bool", "Width": 0, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "DefaultProviderUid", "ColumnDisplayName": "DefaultProviderUid", "Visible": false, "CanFilter": false, "CanSelect": true, "Type": null, "Width": 0, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "DisplayInterval", "ColumnDisplayName": "DisplayInterval", "Visible": false, "CanFilter": true, "CanSelect": true, "Type": "string", "Width": 70, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "TimeZone", "ColumnDisplayName": "Time Zone", "Visible": false, "CanFilter": true, "CanSelect": true, "Type": "string", "Width": 70, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null } ] }'
	where id = 'ListCalendar'
GO
-- update appointment type
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "AppointmentTypeUid", "PrimaryDisplayName": "Name", "InactiveColumnName": "Inactive", "Columns": [ { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "175", "SortOrder": "1" }, { "ColumnName": "AppointmentTypeUid", "Visible": "false" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": "false", "CanFilter": "true", "Type": "bool" }, { "ColumnName": "Duration", "ColumnDisplayName": "Duration", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "60" }, { "ColumnName": "Blocking", "ColumnDisplayName": "Blocking", "Visible": "true", "CanFilter": "true", "Type": "bool", "Width": "60" }, { "ColumnName": "GroupVisit", "ColumnDisplayName": "Group Visit", "Visible": "true", "CanFilter": "true", "Type": "bool", "Width": "75" }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "250" } ] }' 
	where id = 'ListAppointmentType'
GO
-- update external patients filter, visit center filter
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "FilterUid", "PrimaryDisplayName": "Name", "Columns": [ { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "125", "SortOrder": 1 }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "250" }, { "ColumnName": "UserPRMUid", "ColumnDisplayName": "UserPRMUid", "Visible": "false", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "125" }, { "ColumnName": "ExternalID", "ColumnDisplayName": "ExternalID", "Visible": "false", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "125" }, { "ColumnName": "Type", "ColumnDisplayName": "Type", "Visible": "false", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "125" } ] }'
	where Id = 'ListFilterV2'
GO
-- update visit tracking room
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "RoomUid", "PrimaryDisplayName": "Name", "InactiveColumnName": "Inactive", "Columns": [ { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "50", "SortOrder": "1" }, { "ColumnName": "ServiceSiteName", "ColumnDisplayName": "Service Site", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "200" }, { "ColumnName": "RoomTypeName", "ColumnDisplayName": "Room Type", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "150" }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "200" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": "false", "CanFilter": "true", "Type": "bool" } ] }'
	where Id = 'ListRoom'
GO
-- update messages
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "FilterUid", "PrimaryDisplayName": "Name", "InactiveColumnName": "Inactive", "Columns": [ { "ColumnName": "FilterUid", "Visible": "false" }, { "ColumnName": "ID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "UserPRMUid", "Visible": "false" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": "false", "CanFilter": "true", "CanSelect": "false", "Type": "bool", "Width": "0", "SortOrder": "0", "SortDirection": "Ascending", "AdditionalInfoDto": "null" }, { "ColumnName": "Type", "ColumnDisplayName": "Type", "Visible": "false", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "200", "SortOrder": "1" }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "200", "SortOrder": "1" }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "250" } ] }'
	where Id = 'ViewUserFilters'
GO
-- update prescription queue provider worklist
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "PersonUid", "PrimaryDisplayName": "FullName", "Columns": [ { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "FullName", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "125" }, { "ColumnName": "Specialty", "Visible": "false" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": "false", "CanFilter": "true", "Type": "bool" } ] }'
	where Id = 'ProviderWorklist'
GO
-- update replication client
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "CacheMachineUid", "PrimaryDisplayName": "Name", "InactiveColumnName": null, "Columns": [ { "ColumnName": "CacheMachineUid", "ColumnDisplayName": "CacheMachineUid", "Visible": false, "CanFilter": false, "CanSelect": false, "Type": "string", "Width": 0, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": false, "CanFilter": true, "CanSelect": false, "Type": "bool", "Width": 0, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": true, "CanFilter": true, "CanSelect": false, "Type": "string", "Width": 50, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": true, "CanFilter": true, "CanSelect": true, "Type": "string", "Width": 150, "SortOrder": 1, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "URL", "ColumnDisplayName": "URL", "Visible": true, "CanFilter": true, "CanSelect": false, "Type": "string", "Width": 200, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": true, "CanFilter": false, "CanSelect": false, "Type": "string", "Width": 225, "SortOrder": 0, "SortDirection": "Ascending", "AdditionalInfoDto": null } ] }'
	where Id = 'ListCacheMachine'
GO
-- update providers 
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "PersonUid", "PrimaryDisplayName": "FormattedInternalName", "Columns": [ { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "FormattedInternalName", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "125" }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "Type": "string", "Width": "125" }, { "ColumnName": "PersonUid", "Visible": "false" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": "false", "CanFilter": "true", "Type": "bool" }, { "ColumnName": "LastName", "ColumnDisplayName": "Notes", "Visible": "false", "SortOrder": "1" } ] }'
	where Id = 'ViewProvider'
GO
-- update waiting list
update ListFindControlBehavior set ColumnsConfig = '{ "PrimaryKey": "WaitingListUid", "PrimaryDisplayName": "Name", "InactiveColumnName": "Inactive", "Columns": [ { "ColumnName": "ExternalID", "ColumnDisplayName": "ID", "Visible": "true", "CanFilter": "true", "CanSelect": "false", "Type": "string", "Width": "50" }, { "ColumnName": "Name", "ColumnDisplayName": "Name", "Visible": "true", "CanFilter": "true", "CanSelect": "true", "Type": "string", "Width": "125", "SortOrder": "1" }, { "ColumnName": "Notes", "ColumnDisplayName": "Notes", "Visible": "true", "CanFilter": "true", "Type": "string", "Width": "250" }, { "ColumnName": "WaitingListUid", "Visible": "false" }, { "ColumnName": "Inactive", "ColumnDisplayName": "Inactive", "Visible": "false", "CanFilter": "true", "Type": "bool", "AdditionalInfoDto": "" } ] }'
	where Id = 'WaitingList'
GO
-- #123788 end
