-- items required for both New Install and Migration
-- 111723 - Homepage migration needs COMPATIBILITY_LEVEL = 130 for OPENJSON
DECLARE @dbname SYSNAME = db_name (), @sql NVARCHAR (MAX), @SQLVersion varchar(24), @Level varchar(4)
SELECT @SQLVersion = CONVERT(varchar(24),SERVERPROPERTY('productversion'))
IF (@SQLVersion like '13%')  -- 2016
	SET  @Level = '130'
ELSE IF (@SQLVersion like '14%')  -- 2017
	SET  @Level = '140'
ELSE IF (@SQLVersion like '15%')  -- 2019
	SET  @Level = '150'
ELSE IF (@SQLVersion like '16%')  -- 2022
	SET  @Level = '160'
SET @sql = N'ALTER DATABASE ' + QUOTENAME(@dbname) + N' SET COMPATIBILITY_LEVEL = '+ @Level +'; ' +
	N'ALTER DATABASE ' + QUOTENAME(@dbname + N'_Attachment') + N' SET COMPATIBILITY_LEVEL = '+ @Level +'; '
exec sp_executesql @sql

-- #92687 Event Driven Delivery: enable Service Broker
SET @sql = N'IF ((Select is_broker_enabled FROM sys.databases WHERE name = ''' + @dbname + N''') = 0)' + CHAR (10) +
	N'ALTER DATABASE ' + QUOTENAME(@dbname) + N' SET NEW_BROKER WITH ROLLBACK IMMEDIATE;'
exec sp_executesql @sql

---  Keep the items above regardless of the version of the db.
