BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[DocumentBatchPatientMeasure]') AND name = 'InNumeratorExclusion')
    ALTER TABLE [DocumentBatchPatientMeasure] ADD [InNumeratorExclusion] int NOT NULL CONSTRAINT DF_Table_1_InNumeratorExclusion DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EDDCleanupStoredProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EDDCleanupStoredProcedure](
	[EDDCleanupStoredProcedureUid] [uniqueidentifier] NOT NULL,
	[AppserverName] [varchar](250) NOT NULL,
	[StoredProcedureName] [varchar](250) NOT NULL,
	[LastModifiedDateUid] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [EDDCleanupStoredProcedure] ADD  CONSTRAINT [DF_EDDCleanupStoredProcedure_EDDCleanupStoredProcedureUid]  DEFAULT (newid()) FOR [EDDCleanupStoredProcedureUid]
ALTER TABLE [EDDCleanupStoredProcedure] ADD  CONSTRAINT [DF_EDDCleanupStoredProcedure_LastModifiedDateUid]  DEFAULT (getutcdate()) FOR [LastModifiedDateUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EDDTableRequest]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EDDTableRequest](
	[EDDTableRequestUid] [uniqueidentifier] NOT NULL,
	[AppserverName] [varchar](250) NOT NULL,
	[Filter] [varchar](max) NULL,
	[ChangeDetected] [bit] NOT NULL,
	[ProfileUid] [uniqueidentifier] NOT NULL,
	[TableModelType] [smallint] NOT NULL,
	[TableName] [varchar](250) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDateUid] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [EDDTableRequest] ADD  CONSTRAINT [DF_EDDTableRequest_EDDTableRequestUid]  DEFAULT (newid()) FOR [EDDTableRequestUid]
ALTER TABLE [EDDTableRequest] ADD  CONSTRAINT [DF_EDDTableRequest_HasDataChange]  DEFAULT ((0)) FOR [ChangeDetected]
ALTER TABLE [EDDTableRequest] ADD  CONSTRAINT [DF_EDDTableRequest_ProfileUid]  DEFAULT (newid()) FOR [ProfileUid]
ALTER TABLE [EDDTableRequest] ADD  CONSTRAINT [DF_EDDTableRequest_TableModelType]  DEFAULT ((0)) FOR [TableModelType]
ALTER TABLE [EDDTableRequest] ADD  CONSTRAINT [DF_EDDTableRequest_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [EDDTableRequest] ADD  CONSTRAINT [DF_EDDTableRequest_LastModifiedDateUid]  DEFAULT (getutcdate()) FOR [LastModifiedDateUid]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[EligibilityRequest]') AND name = 'AppointmentUid')
    ALTER TABLE [EligibilityRequest] ADD [AppointmentUid] uniqueidentifier NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[EligibilityRequest]') AND name = 'ServiceSiteUid')
    ALTER TABLE [EligibilityRequest] ADD [ServiceSiteUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[eRxMedicationHistoryDetail]') AND name = 'StructuredSIGDirection')
    ALTER TABLE [eRxMedicationHistoryDetail] ADD [StructuredSIGDirection] varchar(1200) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ExternalMaterialSource]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ExternalMaterialSource](
	[ExternalMaterialSourceUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ExternalMaterialSource_ExternalMaterialSourceUid]  DEFAULT (newid()),
	[ExternalMaterialSourceCategoryUid] [uniqueidentifier] NULL,
	[Name] [varchar](500) NOT NULL,
	[URL] [varchar](max) NOT NULL,
	[PublishedDate] [date] NULL,
	[AdditionalData] [varchar](max) NULL,
	[Version] [varchar](20) NULL,
	[BuildNumber] [int] NULL,
	[Inactive] [bit] NULL CONSTRAINT [DF_ExternalMaterialSource_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_ExternalMaterialSource_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ExternalMaterialSource_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ExternalMaterialSourceCategory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ExternalMaterialSourceCategory](
	[ExternalMaterialSourceCategoryUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_ExternalMaterialSourceTypeUid]  DEFAULT (newid()),
	[CategoryName] [varchar](500) NOT NULL,
	[IsTrackable] [bit] NOT NULL CONSTRAINT [DF_ExternalMaterialSourceCategory_IsTrackable]  DEFAULT ((0)),
	[AdditionalData] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ExternalMaterialSourceCategory_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ExternalMaterialSourceCategory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcMessageLog]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcMessageLog](
	[IcMessageLogUid] [uniqueidentifier] NOT NULL,
	[MessageObjectId] [uniqueidentifier] NULL,
	[SuccesfullyTransmitted] [bit] NOT NULL,
	[SentDateTime] [datetime] NOT NULL,
	[RawSend] [varchar](max) NOT NULL,
	[RepliedDateTime] [datetime] NULL,
	[HttpStatusCode] [int] NULL,
	[RawReturn] [varchar](max) NULL,
	[WebApiDirectory] [varchar](100) NULL,
	[MessageCategory] [varchar](100) NULL,
	[MessageName] [varchar](100) NULL,
	[CallsLeftPerMinute] [int] NULL,
	[DiagnosticMessage] [varchar](max) NULL
) ON [PRIMARY]


ALTER TABLE [IcMessageLog] ADD  CONSTRAINT [DF_IcMessageLog_IcMessageLogUid]  DEFAULT (newid()) FOR [IcMessageLogUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_InsurancePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_InsurancePlan](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_InsurancePlan'

ALTER TABLE [IcTransmitted_InsurancePlan] ADD  CONSTRAINT [DF_IcTransmitted__InsurancePlan_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_InsurancePlan] ADD  CONSTRAINT [DF_IcTransmitted_InsurancePlan_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_ListAppointmentType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_ListAppointmentType](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[AppointmentTypeUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_ListAppointmentType'

ALTER TABLE [IcTransmitted_ListAppointmentType] ADD  CONSTRAINT [DF_IcTransmitted_ListAppointmentType_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_ListAppointmentType] ADD  CONSTRAINT [DF_IcTransmitted_ListAppointmentType_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_ListAppointmentType_Delete]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_ListAppointmentType_Delete](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[AppointmentTypeUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NULL
) ON [PRIMARY]


ALTER TABLE [IcTransmitted_ListAppointmentType_Delete] ADD  CONSTRAINT [DF_IcTransmitted_ListAppointmentType_Delete_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_ListCalendar]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_ListCalendar](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[CalendarUid] [uniqueidentifier] NOT NULL,
	[IsSchedulable] [bit] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_ListCalendar'

ALTER TABLE [IcTransmitted_ListCalendar] ADD  CONSTRAINT [DF_IcTransmitted_ListCalendar_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_ListCalendar] ADD  CONSTRAINT [DF_IcTransmitted_ListCalendar_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_ListServiceSite]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_ListServiceSite](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_ListServiceSite'

ALTER TABLE [IcTransmitted_ListServiceSite] ADD  CONSTRAINT [DF_IcTransmitted_ListServiceSite_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_ListServiceSite] ADD  CONSTRAINT [DF_IcTransmitted_ListServiceSite_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_Patient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_Patient](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL,
	[LastReviewDateUTC] [datetime] NOT NULL,
	[PayLoad] [varchar](max) NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_Patient'

ALTER TABLE [IcTransmitted_Patient] ADD  CONSTRAINT [DF_IcTransmitted_Patient_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_PracticeSettings]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_PracticeSettings](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL,
	[LastReviewDateUTC] [datetime] NOT NULL,
	[PayLoad] [varchar](max) NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_PracticeSettings'

ALTER TABLE [IcTransmitted_PracticeSettings] ADD  CONSTRAINT [DF_IcTransmitted_PracticeSettings_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_Provider]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_Provider](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_Provider'

ALTER TABLE [IcTransmitted_Provider] ADD  CONSTRAINT [DF_IcTransmitted_Provider_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_Provider] ADD  CONSTRAINT [DF_IcTransmitted_Provider_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_Provider_ListServiceSite]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_Provider_ListServiceSite](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_Provider_ListServiceSite'

ALTER TABLE [IcTransmitted_Provider_ListServiceSite] ADD  CONSTRAINT [DF_IcTransmitted_Provider_ListServiceSite_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_Provider_ListServiceSite] ADD  CONSTRAINT [DF_IcTransmitted_Provider_ListServiceSite_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_Provider_PracticeSettings]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_Provider_PracticeSettings](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_Provider_PracticeSettings'

ALTER TABLE [IcTransmitted_Provider_PracticeSettings] ADD  CONSTRAINT [DF_IcTransmitted_Provider_PracticeSettings_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_Provider_PracticeSettings] ADD  CONSTRAINT [DF_IcTransmitted_Provider_PracticeSettings_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_UserPRM]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_UserPRM](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_UserPRM'

ALTER TABLE [IcTransmitted_UserPRM] ADD  CONSTRAINT [DF_IcTransmitted_UserPRM_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_UserPRM] ADD  CONSTRAINT [DF_IcTransmitted_UserPRM_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[InsuranceCarrier]') AND name = 'Eligibility_ListClaimFormatUid')
    ALTER TABLE [InsuranceCarrier] ADD [Eligibility_ListClaimFormatUid] uniqueidentifier NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[InsuranceCarrier]') AND name = 'EligibleCCM_CPO')
    ALTER TABLE [InsuranceCarrier] ADD [EligibleCCM_CPO] bit NOT NULL CONSTRAINT DF_InsuranceCarrier_EligibleCCM_CPO DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListAppointmentType]') AND name = 'LOINCUid')
    ALTER TABLE [ListAppointmentType] ADD [LOINCUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListAttachmentType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListAttachmentType](
	[AttachmentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAttachmentType_AttachmentTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[NeedReview] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_NeedReview]  DEFAULT ((0)),
	[DisplayOnOPS] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_DisplayOnOPS]  DEFAULT ((0)),
	[DisplayTypeID] [smallint] NULL CONSTRAINT [DF_ListAttachmentType_DisplayTypeID]  DEFAULT ((0)),
	[Color] [int] NOT NULL CONSTRAINT [DF_ListAttachmentType_Color]  DEFAULT ((0)),
	[ShowInFNC] [bit] NULL CONSTRAINT [DF_ListAttachmentType_ShowInFNC]  DEFAULT ((0)),
	[ShowInPatientPortal] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_ShowInPatientPortal]  DEFAULT ((0)),
	[SummaryOfCare] [bit] NULL CONSTRAINT [DF_ListAttachmentType_SummaryOfCare]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAttachmentType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAttachmentType_UserDefined]  DEFAULT ((1)),
	[LOINCUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'image unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'AttachmentTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'image type: lab, photo, x-ray' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'comment of the image type' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'need physician to review' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'NeedReview'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Display on OPS ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'DisplayOnOPS'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Show in FNC slider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'ShowInFNC'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This column is ''true'' when the attachment type is a ''Summary of Care'' or ''Transition of Care'' attachment.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'SummaryOfCare'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'DisplayTypeID', @value=N'<Attachment value="0" />
<Result value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Attachment types' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAttachmentType'


END
Truncate Table migtemp_ListAttachmentType
INSERT [migtemp_ListAttachmentType]([AttachmentTypeUid],[ExternalID],[Inactive],[Name],[Notes],[NeedReview],[DisplayOnOPS],[DisplayTypeID],[Color],[ShowInFNC],[SummaryOfCare],[SnomedConceptID],[DescriptionUid],[LastModifiedDate],[LastModifiedByUid],[MessageSubTypeUid],[UserDefined])
SELECT [AttachmentTypeUid],[ExternalID],[Inactive],[Name],[Notes],[NeedReview],[DisplayOnOPS],[DisplayTypeID],[Color],[ShowInFNC],[SummaryOfCare],[SnomedConceptID],[DescriptionUid],[LastModifiedDate],[LastModifiedByUid],[MessageSubTypeUid],[UserDefined]
FROM [ListAttachmentType]

DROP TABLE [ListAttachmentType]

exec  sp_rename 'migtemp_ListAttachmentType', 'ListAttachmentType'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListClinicalNoteType]') AND name = 'LOINCUid')
    ALTER TABLE [ListClinicalNoteType] ADD [LOINCUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListFindControlBehavior]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListFindControlBehavior](
	[FindControlBehaviorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFindControlBehavior_ListFindControlBehaviorUid]  DEFAULT (newid()),
	[ExternalId] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[SecurityGroupUid] [uniqueidentifier] NULL,
	[Id] [varchar](50) NULL,
	[ColumnsConfig] [varchar](max) NULL,
	[SearchColumns] [varchar](max) NULL,
	[RequiredSearchParameters] [varchar](max) NULL,
	[MinimumSearchCharacters] [int] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_MinimumSearchCharacters]  DEFAULT ((3)),
	[MaxRows] [int] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_MaxRows]  DEFAULT ((-1)),
	[ShowInListEditor] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_ShowInListEditor]  DEFAULT ((1)),
	[BusinessObject] [varchar](max) NULL,
	[EditBusinessObject] [varchar](255) NULL,
	[FindTableUid] [uniqueidentifier] NULL,
	[Prepopulate] [smallint] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_PrepopulateFind]  DEFAULT ((0)),
	[HasSecurity] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_HasSecurity]  DEFAULT ((0)),
	[AllowMaintenance] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_AllowMaintenance]  DEFAULT ((1)),
	[AllowNew] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_AllowNew]  DEFAULT ((1)),
	[AllowDelete] [smallint] NOT NULL CONSTRAINT [DF_LListFindControlBehavior_AllowDelete]  DEFAULT ((2)),
	[BeginningWildcard] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_BeginningWildcard]  DEFAULT ((0)),
	[EndingWildcard] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_EndingWildcard]  DEFAULT ((1)),
	[ServiceAQN] [varchar](max) NULL,
	[EndPoint] [varchar](max) NULL,
	[AuditTableName] [varchar](50) NULL,
	[AllowedTokenType] [smallint] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_AllowedTokenType]  DEFAULT ((96)),
	[Notes] [varchar](max) NULL,
	[AddInUid] [uniqueidentifier] NULL,
	[LicenseCode] [varchar](50) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JSON object descripting the column UI configuration.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'ColumnsConfig'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JSON object descripting the search columns (database column name).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'SearchColumns'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JSON object descripting the required search columns.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'RequiredSearchParameters'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The minimum characters to type before executing the search. If zero the search must be forced.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'MinimumSearchCharacters'
EXEC sys.sp_addextendedproperty @name=N'AllowDelete', @value=N'<None value="0" />
<Delete value="1" />
<Merge value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior'
EXEC sys.sp_addextendedproperty @name=N'Prepopulate', @value=N'<None value="0" />
<All value="1" />
<MFU_Frequency value="2" />
<MRU value="3" />
<MFU_Alpha value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFindControlBehavior'


END
Truncate Table migtemp_ListFindControlBehavior
INSERT [migtemp_ListFindControlBehavior]([FindControlBehaviorUid],[ExternalId],[Name],[Id],[ColumnsConfig],[SearchColumns],[RequiredSearchParameters],[MinimumSearchCharacters],[MaxRows],[BusinessObject],[FindTableUid],[Prepopulate],[HasSecurity],[AllowMaintenance],[AllowNew],[AllowDelete],[BeginningWildcard],[EndingWildcard],[ServiceAQN],[EndPoint],[AuditTableName],[AllowedTokenType],[Notes],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid])
SELECT [FindControlBehaviorUid],[ExternalId],[Name],[Id],[ColumnsConfig],[SearchColumns],[RequiredSearchParameters],[MinimumSearchCharacters],[MaxRows],[BusinessObject],[FindTableUid],[Prepopulate],[HasSecurity],[AllowMaintenance],[AllowNew],[AllowDelete],[BeginningWildcard],[EndingWildcard],[ServiceAQN],[EndPoint],[AuditTableName],[AllowedTokenType],[Notes],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid]
FROM [ListFindControlBehavior]

DROP TABLE [ListFindControlBehavior]

exec  sp_rename 'migtemp_ListFindControlBehavior', 'ListFindControlBehavior'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListGroupUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListGroupUIConfiguration](
	[GroupUIConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_GroupUIConfigurationUid]  DEFAULT (newid()),
	[DataTypeId] [smallint] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_DataTypeId]  DEFAULT ((0)),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[RestrictedToPersonUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'DataTypeId', @value=N'<Unassigned value="0" /><Homepage value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListGroupUIConfiguration'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMisc]') AND name = 'ExternalID')
    ALTER TABLE [ListMisc] ADD [ExternalID] varchar(25) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMisc]') AND name = 'Inactive')
    ALTER TABLE [ListMisc] ADD [Inactive] bit NOT NULL CONSTRAINT DF_ListMisc_Inactive DEFAULT ((0)) 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMisc]') AND name = 'Notes')
    ALTER TABLE [ListMisc] ADD [Notes] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListProcedure' AND COLUMN_NAME = 'ShortDescription')
ALTER TABLE [ListProcedure]  ALTER COLUMN [ShortDescription] varchar(750) NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListProcedure' AND COLUMN_NAME = 'LongDescription')
ALTER TABLE [ListProcedure]  ALTER COLUMN [LongDescription] varchar(4000) NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPronoun]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPronoun](
	[PronounUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPronoun_PronounUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPronoun_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPronoun_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPronoun_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListPronoun', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Pronouns' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListPronoun'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListPronoun'


END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Cat1_DocumentType' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Cat1_DocumentType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'RuleMeasureUid'))
EXEC sys.sp_dropextendedproperty @name=N'oldname' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'RuleMeasureUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_XSLT'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_XSLT'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_Validation'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_Validation'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_XSL'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_XSL'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_Configuration'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_Configuration'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_XSLT'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_XSLT'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_Validation'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_Validation'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_XSL'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_XSL'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_Configuration'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_Configuration'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Inactive'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Cat1_DocumentType' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Cat1_DocumentType', @value=N'<CCR value="1"/><C32 value="2" /><CCDA value="3" /><CMS value="4" /><EHR value="5" /><USCDI value="6" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'RuleMeasureUid'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ListRuleMeasureUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'RuleMeasureUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_XSLT'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category1 XSLT transformation ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_XSLT'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_Validation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 1 Validation Document' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_Validation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_XSL'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 1 XSL Style Sheet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_XSL'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat1_Configuration'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 1 Data Configuration XML' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat1_Configuration'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_XSLT'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 3 XSLT transformation ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_XSLT'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_Validation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 3 Validation Document' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_Validation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_XSL'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 3 XSL Style Sheet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_XSL'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Cat3_Configuration'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Category 3 Data Configuration XML' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Cat3_Configuration'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListRuleMeasure', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListRuleMeasure', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListTileConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListTileConfiguration](
	[TileConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListTileConfiguration_TileConfigurationUid]  DEFAULT (newid()),
	[UIConfigurationUid] [uniqueidentifier] NOT NULL,
	[TileTypeUid] [uniqueidentifier] NOT NULL,
	[Data] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListTileConfiguration_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTileConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTileConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTileConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListTileType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListTileType](
	[TileTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListTileType_TileTypeUid]  DEFAULT (newid()),
	[Name] [varchar](256) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTileType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTileType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTileType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DataTypeId' , N'SCHEMA',N'dbo', N'TABLE',N'ListUIConfiguration', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DataTypeId' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIConfiguration'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DataTypeId' , N'SCHEMA',N'dbo', N'TABLE',N'ListUIConfiguration', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DataTypeId', @value=N'<Unassigned value="0" /><FND value="1" /><Homepage value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIConfiguration'
GO
BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListUserSetting]') AND name = 'HomepageConfigurationUid')
    ALTER TABLE [ListUserSetting] ADD [HomepageConfigurationUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ObservationValue]') AND name = 'MetricPercentile1')
    ALTER TABLE [ObservationValue] ADD [MetricPercentile1] decimal(9) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ObservationValue]') AND name = 'MetricPercentile2')
    ALTER TABLE [ObservationValue] ADD [MetricPercentile2] decimal(9) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Patient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Patient](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Patient_Inactive]  DEFAULT ((0)),
	[MedicalRecordNumber] [varchar](25) NULL,
	[PatientClassUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[DepartmentUid] [uniqueidentifier] NULL,
	[ReleaseInformation] [bit] NOT NULL CONSTRAINT [DF_Patient_ReleaseInformation]  DEFAULT ((0)),
	[ReleaseDate] [date] NULL,
	[SignatureOnFile] [bit] NOT NULL CONSTRAINT [DF_Patient_SignatureOnFile]  DEFAULT ((0)),
	[SignatureSourceUid] [uniqueidentifier] NULL,
	[AssignmentOfBenefitsUid] [uniqueidentifier] NULL,
	[PrivacyPolicyAcceptanceUid] [uniqueidentifier] NULL,
	[StudentStatusUid] [uniqueidentifier] NULL,
	[SchoolName] [varchar](50) NULL,
	[ResidenceTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[eRXHPatientConsent] [bit] NOT NULL CONSTRAINT [DF_Patient_eRXHPatientConsent]  DEFAULT ((0)),
	[ScannedChartDate] [date] NULL,
	[UserDefinedXml] [xml] NULL,
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ActXStatus] [bit] NOT NULL CONSTRAINT [DF_Patient_ActXStatus]  DEFAULT ((0)),
	[ActXStatusCheckedDate] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Patient_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[BirthXml] [xml] NULL,
	[PatientStory] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medical record number.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient', @level2type=N'COLUMN',@level2name=N'MedicalRecordNumber'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Default clinical service site.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient', @level2type=N'COLUMN',@level2name=N'ServiceSiteUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patients.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient'
EXEC sys.sp_addextendedproperty @name=N'Replication.UpcastToParentTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient'


END
Truncate Table migtemp_Patient
INSERT [migtemp_Patient]([PersonUid],[Inactive],[MedicalRecordNumber],[PatientClassUid],[ProviderUid],[ServiceSiteUid],[DepartmentUid],[ReleaseInformation],[ReleaseDate],[SignatureOnFile],[SignatureSourceUid],[AssignmentOfBenefitsUid],[PrivacyPolicyAcceptanceUid],[StudentStatusUid],[SchoolName],[ResidenceTypeUid],[ExternalID],[eRXHPatientConsent],[ScannedChartDate],[UserDefinedXml],[ReferralSrcUid],[SupervisingProviderUid],[ImmzReminderRecallUid],[ActXStatus],[ActXStatusCheckedDate],[LastModifiedDate],[LastModifiedByUid],[BirthXml],[PatientStory])
SELECT [PersonUid],[Inactive],[MedicalRecordNumber],[PatientClassUid],[ProviderUid],[ServiceSiteUid],[DepartmentUid],[ReleaseInformation],(SELECT dbo.ConvertTimeByTimezone(ReleaseDate, (SELECT TOP 1 StringValue FROM ListProductParameter WHERE ParameterName = 'TimeZoneString'))),[SignatureOnFile],[SignatureSourceUid],[AssignmentOfBenefitsUid],[PrivacyPolicyAcceptanceUid],[StudentStatusUid],[SchoolName],[ResidenceTypeUid],[ExternalID],[eRXHPatientConsent],(SELECT dbo.ConvertTimeByTimezone(ScannedChartDate, (SELECT TOP 1 StringValue FROM ListProductParameter WHERE ParameterName = 'TimeZoneString'))),CONVERT(nvarchar(max), [UserDefinedXml]),[ReferralSrcUid],[SupervisingProviderUid],[ImmzReminderRecallUid],[ActXStatus],[ActXStatusCheckedDate],[LastModifiedDate],[LastModifiedByUid],CONVERT(nvarchar(max), [BirthXml]),[PatientStory]
FROM [Patient]

DROP TABLE [Patient]

exec  sp_rename 'migtemp_Patient', 'Patient'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PatientCP_GoalHistory' AND COLUMN_NAME = 'Name')
ALTER TABLE [PatientCP_GoalHistory]  ALTER COLUMN [Name] varchar(max) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PatientProcedureHistory' AND COLUMN_NAME = 'ShortDescription')
ALTER TABLE [PatientProcedureHistory]  ALTER COLUMN [ShortDescription] varchar(750) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Person]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Person](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Person_PersonUid]  DEFAULT (newid()),
	[PatientCenterUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Person_Inactive]  DEFAULT ((0)),
	[Prefix] [varchar](25) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NOT NULL,
	[Suffix] [varchar](50) NULL,
	[PronounUid] [uniqueidentifier] NULL,
	[Address1] [xml](CONTENT [dbo].[Address]) NULL,
	[BadAddress1] [bit] NULL CONSTRAINT [DF_Person_BadAddress1]  DEFAULT ((0)),
	[Address2] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[LanguageUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[Hispanic] [bit] NOT NULL CONSTRAINT [DF_Person_Hispanic]  DEFAULT ((0)),
	[Birthdate] [date] NULL,
	[BirthTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[Deathdate] [date] NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[SocialSecurityNumber] [varchar](11) NULL,
	[DriverLicenseNumber] [varchar](25) NULL,
	[DriverLicenseState] [varchar](3) NULL,
	[DriverLicenseAttachmentUid] [uniqueidentifier] NULL,
	[PhotoAttachmentUid] [uniqueidentifier] NULL,
	[LivesWithPersonUid] [uniqueidentifier] NULL,
	[MaritalStatusUid] [uniqueidentifier] NULL,
	[DominantHandUid] [uniqueidentifier] NULL,
	[PreferredContactMethod] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Person_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Person_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MaidenName] [varchar](50) NULL,
	[NotificationMethodUid] [uniqueidentifier] NULL,
	[EmailDirect] [varchar](200) NULL,
	[BirthPlace] [xml](CONTENT [dbo].[Address]) NULL,
	[Computed_Address1_Address1] [varchar](100) NULL,
	[Computed_Address1_Address2] [varchar](100) NULL,
	[Computed_Address1_City] [varchar](35) NULL,
	[Computed_Address1_State] [varchar](3) NULL,
	[Computed_Address1_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[MotherMaidenName] [varchar](50) NULL,
	[MotherMaidenFirstName] [varchar](50) NULL,
	[IdentityVerification] [xml] NULL,
	[LastIdentityVerificationTransaction] [varchar](max) NULL,
	[TranslatorRequired] [bit] NULL CONSTRAINT [DF_Person_TranslatorRequired]  DEFAULT ((0)),
	[SexualOrientationUid] [uniqueidentifier] NULL,
	[GenderIdentityUid] [uniqueidentifier] NULL,
	[SendSms] [bit] NOT NULL CONSTRAINT [DF__Person_Sms]  DEFAULT ((0)),
	[SendEmail] [bit] NOT NULL CONSTRAINT [DF_Person_Email]  DEFAULT ((0)),
	[NoEmailAddressProvided] [bit] NOT NULL CONSTRAINT [DF_Person_NoEmailAddressProvided]  DEFAULT ((0)),
	[Email1MessagingAllowed] [bit] NULL,
	[Email2MessagingAllowed] [bit] NULL,
	[Phone1MessagingAllowed] [bit] NULL,
	[Phone2MessagingAllowed] [bit] NULL,
	[Phone3MessagingAllowed] [bit] NULL,
	[Phone4MessagingAllowed] [bit] NULL,
	[BirthGenderUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email address used to transmit data (CCDs, CCDAs, etc) using the Direct Method' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'EmailDirect'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address1'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address2'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_City'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_State'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Zip'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Replication.ObjectCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{FK_Patient_Person,!FK_PersonRawUnencrypted_Photo}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'


END
Truncate Table migtemp_Person
INSERT [migtemp_Person]([PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],[Address1],[BadAddress1],[Address2],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],[BirthPlace],[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[MotherMaidenFirstName],[IdentityVerification],[LastIdentityVerificationTransaction],[TranslatorRequired],[SexualOrientationUid],[GenderIdentityUid],[SendSms],[SendEmail],[NoEmailAddressProvided],[Email1MessagingAllowed],[Email2MessagingAllowed],[Phone1MessagingAllowed],[Phone2MessagingAllowed],[Phone3MessagingAllowed],[Phone4MessagingAllowed])
SELECT [PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],CONVERT(nvarchar(max), [Address1]),[BadAddress1],CONVERT(nvarchar(max), [Address2]),CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],CONVERT(nvarchar(max), [BirthPlace]),[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[MotherMaidenFirstName],CONVERT(nvarchar(max), [IdentityVerification]),[LastIdentityVerificationTransaction],[TranslatorRequired],[SexualOrientationUid],[GenderIdentityUid],[SendSms],[SendEmail],[NoEmailAddressProvided],[Email1MessagingAllowed],[Email2MessagingAllowed],[Phone1MessagingAllowed],[Phone2MessagingAllowed],[Phone3MessagingAllowed],[Phone4MessagingAllowed]
FROM [Person]

DROP TABLE [Person]

exec  sp_rename 'migtemp_Person', 'Person'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelExternalMaterialSourceUserPRM]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelExternalMaterialSourceUserPRM](
	[RelExternalMaterialSourceUserPRMUid] [uniqueidentifier] NOT NULL,
	[ExternalMaterialSourceUid] [uniqueidentifier] NOT NULL,
	[UserPRMUid] [uniqueidentifier] NOT NULL,
	[AdditionalData] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [RelExternalMaterialSourceUserPRM] ADD  CONSTRAINT [DF_RelExternalMaterialSourceUserPRM_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelFormTitleUserSetting]') AND name = 'LastModifiedDate')
    ALTER TABLE [RelFormTitleUserSetting] ADD [LastModifiedDate] datetime NOT NULL CONSTRAINT DF_RelFormTitleUserSetting_LastModifiedDate DEFAULT (getutcdate()) 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelFormTitleUserSetting]') AND name = 'LastModifiedByUid')
    ALTER TABLE [RelFormTitleUserSetting] ADD [LastModifiedByUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelUIConfigurationGroupUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelUIConfigurationGroupUIConfiguration](
	[RelUIConfigurationGroupUIConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelHompageConfigurationUIConfiguration_RelHomepageConfigurationUIConfigurationUid]  DEFAULT (newid()),
	[GroupUIConfigurationUid] [uniqueidentifier] NOT NULL,
	[UIConfigurationUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelHompageConfigurationUIConfiguration_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelHompageConfigurationUIConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHompageConfigurationUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelUIConfigurationUserSetting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelUIConfigurationUserSetting](
	[RelUIConfigurationUserSettingUid] [uniqueidentifier] NOT NULL,
	[UIConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserSettingUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelUIConfigurationUserSetting] ADD  CONSTRAINT [DF_Table_1_RelUIConfigurationListUserSettingUid]  DEFAULT (newid()) FOR [RelUIConfigurationUserSettingUid]
ALTER TABLE [RelUIConfigurationUserSetting] ADD  CONSTRAINT [DF_RelUIConfigurationUserSetting_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [RelUIConfigurationUserSetting] ADD  CONSTRAINT [DF_RelUIConfigurationUserSetting_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelUserPRMGroupUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelUserPRMGroupUIConfiguration](
	[RelUserPRMGroupUIConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[GroupUIConfigurationUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelUserPRMGroupUIConfiguration] ADD  CONSTRAINT [DF_RelUserPRMGroupUIConfiguration_RelUserPRMGroupUIConfigurationUid]  DEFAULT (newid()) FOR [RelUserPRMGroupUIConfigurationUid]
ALTER TABLE [RelUserPRMGroupUIConfiguration] ADD  CONSTRAINT [DF_RelUserPRMGroupUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CompletionStatus' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'CompletionStatus' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'OnDemand' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'OnDemand' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CompletionStatus' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CompletionStatus', @value=N'<None value="0" /><Printed value="1" /><PortalOnly value="2" /><Etactics value="3" /><PracticeInsight value="4" /><ClearGage value="5" /><Emedix value="6" /><Excluded value="99" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Individual responsible-party statements in a statement batch' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'OnDemand' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'OnDemand', @value=N'<None value="0" /><All value="1" /><MainAccountOnly value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'Translation' AND COLUMN_NAME = 'Spanish')
ALTER TABLE [Translation]  ALTER COLUMN [Spanish] varchar(max) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UsageMetric]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[UsageMetric](
	[UsageMetricUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_UsageMetric_UsageMetricUid]  DEFAULT (newid()),
	[Name] [varchar](250) NOT NULL,
	[MetricValue] [bigint] NOT NULL CONSTRAINT [DF_UsageMetric_MetricValue]  DEFAULT ((0)),
	[CollectionDate] [date] NOT NULL CONSTRAINT [DF_UsageMetric_CollectionDate]  DEFAULT (getdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_UsageMetric_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table for recording feature usage frequencies.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UsageMetric'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UsageMetric'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[UserPRM]') AND name = 'LogonCount')
    ALTER TABLE [UserPRM] ADD [LogonCount] int NOT NULL CONSTRAINT DF_UserPRM_LogonCount DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserTileConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[UserTileConfiguration](
	[UserTileConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_UserTileConfiguration_UserTileConfigurationUid]  DEFAULT (newid()),
	[TileConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[Data] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_UserTileConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_UserTileConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_UserTileConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VisitAddendum]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[VisitAddendum](
	[VisitAddendumUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[AttachmentGroupUid] [uniqueidentifier] NULL,
	[IsFailure] [bit] NOT NULL,
	[AddendumDate] [datetime] NOT NULL,
	[GenerateDocument] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [VisitAddendum] ADD  CONSTRAINT [DF_VisitAddendum_VisitAddendumUid]  DEFAULT (newid()) FOR [VisitAddendumUid]
ALTER TABLE [VisitAddendum] ADD  CONSTRAINT [DF_VisitAddendum_IsFailure]  DEFAULT ((0)) FOR [IsFailure]
ALTER TABLE [VisitAddendum] ADD  CONSTRAINT [DF_VisitAddendum_GenerateDocument]  DEFAULT ((0)) FOR [GenerateDocument]
ALTER TABLE [VisitAddendum] ADD  CONSTRAINT [DF_VisitAddendum_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'VisitProcedure' AND COLUMN_NAME = 'Name')
ALTER TABLE [VisitProcedure]  ALTER COLUMN [Name] varchar(800) NULL 
COMMIT TRAN
GO


