//grunt-shell and grunt-exec don't work with latest.// Hate to do this, but I guess I have to.
module.exports = function(grunt){
    'use strict';

    grunt.loadNpmTasks('grunt-contrib-clean');
    grunt.loadNpmTasks('grunt-contrib-copy');
    grunt.loadNpmTasks('grunt-contrib-less');

    grunt.loadTasks('lib/');

    grunt.registerTask('default', ['dist']);

    // Project configuration.
    grunt.initConfig({
        clean: {
            options: {
                force: true
            },
            dist: ['dist']
        },
        copy: {
            images: {
                cwd: 'src/images/',
                dest: 'dist/stylesheets/ap-images/images/',
                expand: true,
                src: '**'
            },
            fonts: {
                cwd: 'src/fonts/',
                dest: 'dist/fonts/',
                expand: true,
                src: '**'
            },
            bootstrapFonts: {
                cwd: 'bower_components/bootstrap/dist/fonts/',
                dest: 'dist/stylesheets/bootstrap/fonts/',
                expand: true,
                src: '**'
            },
            bootstrapJs: {
                cwd: 'bower_components/bootstrap/dist/js/',
                dest: 'dist/stylesheets/bootstrap/js/',
                expand: true,
                src: '**'
            }
        },

        /* jshint ignore:start */
        imagestoless: {
            all: {
                options: {
                    nameSizeDelims: '-',
                    otherDelims: 'x.'
                },
                files: {
                    'src/less/images/icons.less.lesstemplate': 'src/images/responsive/*'
                }
            }
        },
        /* jshint ignore:end */


        less: {
            compileBootstrapCore: {
                options: {
                    strictMath: true,
                    sourceMap: true,
                    outputSourceFiles: true,
                    sourceMapURL: 'bootstrap.css.map',
                    sourceMapFilename: 'dist/stylesheets/bootstrap/css/bootstrap.css.map'
                },
                files: {
                    'dist/stylesheets/bootstrap/css/bootstrap.css': 'src/less/bootstrap/bootstrap.less'
                }
            },
            compileBootstrapTheme: {
                options: {
                    strictMath: true,
                    sourceMap: true,
                    outputSourceFiles: true,
                    sourceMapURL: 'bootstrap.theme.css.map',
                    sourceMapFilename: 'dist/stylesheets/bootstrap/css/bootstrap.theme.css.map'
                },
                files: {
                    'dist/stylesheets/bootstrap/css/bootstrap.theme.css': 'src/less/bootstrap/theme.less'
                }
            },
            compileImages: {
                options: {
                    strictMath: true,
                    sourceMap: true,
                    outputSourceFiles: true,
                    sourceMapURL: 'ap-images.css.map',
                    sourceMapFilename: 'dist/stylesheets/ap-images/css/ap-images.css.map'
                },
                files: {
                    'dist/stylesheets/ap-images/css/ap-images.css': 'src/less/images/main.less'
                }
            },
            minify: {
                options: {
                    cleancss: true,
                    report: 'min'
                },
                files: {
                    'dist/stylesheets/bootstrap/css/bootstrap.min.css': 'dist/stylesheets/bootstrap/css/bootstrap.css',
                    'dist/stylesheets/bootstrap/css/bootstrap.theme.min.css': 'dist/stylesheets/bootstrap/css/bootstrap.theme.css'
                }
            }
        }

    });

    grunt.registerTask('dist', ['clean:dist', 'imagestoless', 'less', 'copy']);
};
