﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <html>
      <head>
        <title>Session List</title>
        <link href="ActivityMonitor.css" type="text/css" rel="stylesheet"/>
        <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE" />
        <script src="ClientScripts.js" type="text/javascript"></script>
      </head>
      <body>
        <center>
          <h2>Session List</h2>
        </center>
        <table width="100%">
          <thead>
            <tr>
              <td width="50%">
                Name
              </td>
              <td width="20%">
                Class
              </td>
              <td width="15%">
                Alive
              </td>
              <td width="15%">
                Disposed
              </td>
            </tr>
          </thead>
          <tbody>
            <xsl:for-each select="objectcontexts/objectcontext">
              <tr>
                <xsl:if test="position() mod 2 = 0">
                  <xsl:attribute name="class">oddrow</xsl:attribute>
                </xsl:if>
                <xsl:if test="position() mod 2 = 1">
                  <xsl:attribute name="class">evenrow</xsl:attribute>
                </xsl:if>
                <td>
                  <xsl:attribute name="title">
                    <xsl:value-of select="."/>
                  </xsl:attribute>
                  <xsl:value-of select="@name" />
                </td>
                <td>
                  <xsl:value-of select="@classname" />
                </td>
                <TD valign="top">
                  <xsl:value-of select="@isalive" />
                </TD>
                <TD valign="top">
                  <xsl:value-of select="@isdisposed" />
                </TD>
              </tr>
            </xsl:for-each>
          </tbody>
        </table>
        <xsl:for-each select="objectcontexts">
          <B>
            Total ObjectContexts: <xsl:value-of select="@count" />
          </B>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>