<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs">
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
  <xsl:template match="/">
    <xsl:variable name="var1" select="'Sub Component'"/>
    <xsl:variable name="var2" select="'Element'"/>
    <ADTA08>
      <PID>
        <xsl:attribute name="Type">
          <xsl:value-of select="'Segment'"/>
        </xsl:attribute>
        <PID.1>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.1>
        <xsl:for-each select="PPMDResults">
          <PID.2>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@id)"/>
          </PID.2>
        </xsl:for-each>
        <xsl:for-each select="PPMDResults">
          <PID.3>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@id)"/>
          </PID.3>
        </xsl:for-each>
        <xsl:for-each select="PPMDResults">
          <PID.4>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@chart)"/>
          </PID.4>
        </xsl:for-each>
        <PID.5>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <xsl:for-each select="PPMDResults">
            <PID.5.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="substring-before(string(Results/patientlist/patient/@name), ',')"/>
            </PID.5.1>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PID.5.2>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="substring-after(string(Results/patientlist/patient/@name), ',')"/>
            </PID.5.2>
          </xsl:for-each>
          <PID.5.3>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.5.3>
          <PID.5.4>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.5.4>
          <PID.5.5>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.5.5>
        </PID.5>
        <PID.6>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <PID.6.1>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.6.1>
          <PID.6.2>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.6.2>
        </PID.6>
        <PID.7>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.7>
        <xsl:for-each select="PPMDResults">
          <PID.8>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@sex)"/>
          </PID.8>
        </xsl:for-each>
        <PID.9>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.9>
        <PID.10>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.10>
        <PID.11>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <xsl:for-each select="PPMDResults">
            <PID.11.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/address/@address1)"/>
            </PID.11.1>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PID.11.2>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/address/@address2)"/>
            </PID.11.2>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PID.11.3>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/address/@city)"/>
            </PID.11.3>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PID.11.4>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/address/@state)"/>
            </PID.11.4>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PID.11.5>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/address/@zip)"/>
            </PID.11.5>
          </xsl:for-each>
          <PID.11.6>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.11.6>
        </PID.11>
        <PID.12>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.12>
        <PID.13>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <xsl:for-each select="PPMDResults">
            <PID.13.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/contactinfo/@homephone)"/>
            </PID.13.1>
          </xsl:for-each>
          <PID.13.2>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.13.2>
          <PID.13.3>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.13.3>
          <xsl:for-each select="PPMDResults">
            <PID.13.4>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/contactinfo/@email)"/>
            </PID.13.4>
          </xsl:for-each>
        </PID.13>
        <PID.14>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <xsl:for-each select="PPMDResults">
            <PID.14.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/contactinfo/@officephone)"/>
            </PID.14.1>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PID.14.2>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/patientlist/patient/contactinfo/@officeext)"/>
            </PID.14.2>
          </xsl:for-each>
        </PID.14>
        <PID.15>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <PID.15.1>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.15.1>
          <PID.15.2>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PID.15.2>
        </PID.15>
        <xsl:for-each select="PPMDResults">
          <PID.16>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@maritalstatus)"/>
          </PID.16>
        </xsl:for-each>
        <PID.17>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.17>
        <PID.18>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.18>
        <xsl:for-each select="PPMDResults">
          <PID.19>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@ssn)"/>
          </PID.19>
        </xsl:for-each>
        <PID.20>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.20>
        <PID.21>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.21>
        <PID.22>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.22>
        <xsl:for-each select="PPMDResults">
          <PID.23>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(Results/patientlist/patient/@dob)"/>
          </PID.23>
        </xsl:for-each>
        <PID.24>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.24>
        <PID.25>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.25>
        <PID.26>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.26>
        <PID.27>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.27>
        <PID.28>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.28>
        <PID.29>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PID.29>
      </PID>
      <PV1>
        <xsl:attribute name="Type">
          <xsl:value-of select="'Segment'"/>
        </xsl:attribute>
        <PV1.1>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PV1.1>
        <PV1.2>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PV1.2>
        <PV1.3>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <PV1.3.1>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.3.1>
          <PV1.3.2>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.3.2>
          <PV1.3.3>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.3.3>
          <PV1.3.4>
            <xsl:attribute name="Type">
              <xsl:value-of select="'Composite Element'"/>
            </xsl:attribute>
            <PV1.3.4.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </PV1.3.4.1>
          </PV1.3.4>
        </PV1.3>
        <PV1.4>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PV1.4>
        <PV1.5>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PV1.5>
        <PV1.6>
          <xsl:attribute name="Type">
            <xsl:value-of select="$var2"/>
          </xsl:attribute>
        </PV1.6>
        <PV1.7>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Composite Element'"/>
          </xsl:attribute>
          <xsl:for-each select="PPMDResults">
            <PV1.7.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(Results/profilelist/profile/@code)"/>
            </PV1.7.1>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PV1.7.2>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="substring-before(string(Results/profilelist/profile/@name), ',')"/>
            </PV1.7.2>
          </xsl:for-each>
          <xsl:for-each select="PPMDResults">
            <PV1.7.3>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="substring-after(string(Results/profilelist/profile/@name), ',')"/>
            </PV1.7.3>
          </xsl:for-each>
          <PV1.7.4>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.7.4>
          <PV1.7.5>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.7.5>
          <PV1.7.6>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.7.6>
          <PV1.7.7>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.7.7>
          <PV1.7.8>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var1"/>
            </xsl:attribute>
          </PV1.7.8>
          <PV1.7.9>
            <xsl:attribute name="Type">
              <xsl:value-of select="'Composite Element'"/>
            </xsl:attribute>
            <PV1.7.9.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </PV1.7.9.1>
          </PV1.7.9>
        </PV1.7>
      </PV1>
      <xsl:variable name="var_RespID" select="string(//Results/patientlist/patient/@respparty)"/>
      <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty">
        <xsl:variable name="var1_Respid" select="@id"/>
        <xsl:if test ="string($var_RespID) = string($var1_Respid)">
          <GT1>
            <xsl:attribute name="Type">
              <xsl:value-of select="'Segment'"/>
            </xsl:attribute>
            <GT1.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.1>
            <GT1.2>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(@id)"/>
            </GT1.2>
            <GT1.11.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(//Results/patientlist/patient/@hipaarelationship)"/>
            </GT1.11.1>
            <GT1.3>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <GT1.3.1>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="substring-before(string(@name), ',')"/>
              </GT1.3.1>
              <GT1.3.2>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="substring-after(string(@name), ',')"/>
              </GT1.3.2>
              <GT1.3.3>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.3.3>
              <GT1.3.4>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.3.4>
              <GT1.3.5>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.3.5>
            </GT1.3>
            <GT1.4>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.4>
            <GT1.5>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <GT1.5.1>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="string(address/@address1)"/>
              </GT1.5.1>
              <GT1.5.2>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="string(address/@address2)"/>
              </GT1.5.2>
              <GT1.5.3>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="string(address/@city)"/>
              </GT1.5.3>
              <GT1.5.4>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="string(address/@state)"/>
              </GT1.5.4>
              <GT1.5.5>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
                <xsl:value-of select="string(address/@zip)"/>
              </GT1.5.5>
              <GT1.5.6>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.5.6>
            </GT1.5>
            <GT1.6>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty/contactinfo">
                <GT1.6.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@homephone)"/>
                </GT1.6.1>
              </xsl:for-each>
            </GT1.6>
            <GT1.7>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty/contactinfo">
                <GT1.7.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@officephone)"/>
                </GT1.7.1>
              </xsl:for-each>
              <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty/contactinfo">
                <GT1.7.2>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@officeext)"/>
                </GT1.7.2>
              </xsl:for-each>
              <GT1.7.3>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.7.3>
              <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty/contactinfo">
                <GT1.7.4>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@email)"/>
                </GT1.7.4>
              </xsl:for-each>
            </GT1.7>
            <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty">
              <xsl:variable name="var3_select_dob" select="@dob"/>
              <xsl:if test="string(boolean($var3_select_dob)) != 'false'">
                <GT1.8>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var2"/>
                  </xsl:attribute>
                  <xsl:value-of select="string($var3_select_dob)"/>
                </GT1.8>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty">
              <xsl:variable name="var4_select_sex" select="@sex"/>
              <xsl:if test="string(boolean($var4_select_sex)) != 'false'">
                <GT1.9>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var2"/>
                  </xsl:attribute>
                  <xsl:value-of select="string($var4_select_sex)"/>
                </GT1.9>
              </xsl:if>
            </xsl:for-each>
            <GT1.10>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.10>
            <GT1.11>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.11>
            <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty">
              <xsl:variable name="var5_select_ssn" select="@ssn"/>
              <xsl:if test="string(boolean($var5_select_ssn)) != 'false'">
                <GT1.12>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var2"/>
                  </xsl:attribute>
                  <xsl:value-of select="string($var5_select_ssn)"/>
                </GT1.12>
              </xsl:if>
            </xsl:for-each>
            <GT1.13>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.13>
            <GT1.14>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.14>
            <GT1.15>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.15>
            <GT1.16>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.16>
            <GT1.17>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <GT1.17.1>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.17.1>
              <GT1.17.2>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.17.2>
              <GT1.17.3>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.17.3>
              <GT1.17.4>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.17.4>
              <GT1.17.5>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.17.5>
              <GT1.17.6>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.17.6>
            </GT1.17>
            <GT1.18>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <GT1.18.1>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.18.1>
            </GT1.18>
            <GT1.19>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.19>
            <GT1.20>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.20>
            <GT1.21>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.21>
            <GT1.22>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.22>
            <GT1.23>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.23>
            <GT1.24>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.24>
            <GT1.25>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.25>
            <GT1.26>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.26>
            <GT1.27>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.27>
            <GT1.28>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.28>
            <GT1.29>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.29>
            <GT1.30>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.30>
            <GT1.31>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.31>
            <GT1.32>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.32>
            <GT1.33>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.33>
            <GT1.34>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.34>
            <GT1.35>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.35>
            <GT1.36>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.36>
            <GT1.37>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.37>
            <GT1.38>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.38>
            <GT1.39>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.39>
            <GT1.40>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.40>
            <GT1.41>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.41>
            <GT1.42>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.42>
            <GT1.43>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.43>
            <GT1.44>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.44>
            <GT1.45>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.45>
            <GT1.46>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.46>
            <GT1.47>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.47>
            <GT1.48>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.48>
            <GT1.49>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.49>
            <GT1.50>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var2"/>
              </xsl:attribute>
            </GT1.50>
            <GT1.51>
              <xsl:attribute name="Type">
                <xsl:value-of select="'Composite Element'"/>
              </xsl:attribute>
              <GT1.51.1>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.51.1>
              <GT1.51.2>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.51.2>
              <GT1.51.3>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var1"/>
                </xsl:attribute>
              </GT1.51.3>
            </GT1.51>
          </GT1>
        </xsl:if>
      </xsl:for-each>
      <xsl:for-each select="PPMDResults/Results/patientlist/patient/insplanlist/insplan">
        <IN1>
          <xsl:attribute name="Type">
            <xsl:value-of select="'Segment'"/>
          </xsl:attribute>
          <IN1.1>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
          </IN1.1>
          <IN1.2>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <IN1.2.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
              <xsl:value-of select="string(@id)"/>
            </IN1.2.1>
            <xsl:variable name="var_CarrierID" select="@carrier"/>
            <xsl:for-each select="//PPMDResults/Results/carrierlist/carrier">
              <xsl:variable name="var1_carid" select="@id"/>
              <xsl:if test ="string($var1_carid) = string($var_CarrierID)">
                <IN1.2.2>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@name)"/>
                </IN1.2.2>
              </xsl:if>
            </xsl:for-each>
          </IN1.2>
          <xsl:variable name="var_carrierId" select="@carrier"/>
          <IN1.3>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string($var_carrierId)"/>
          </IN1.3>
          <xsl:for-each select="//PPMDResults/Results/carrierlist/carrier">
            <xsl:variable name="var1_carrierId" select="@id"/>
            <xsl:if test ="string($var_carrierId) = string($var1_carrierId)">
              <IN1.4>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
                <xsl:value-of select="string(@name)"/>
              </IN1.4>
              <IN1.5>
                <xsl:attribute name="Type">
                  <xsl:value-of select="'Composite Element'"/>
                </xsl:attribute>

                <IN1.5.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@address1)"/>
                </IN1.5.1>


                <IN1.5.2>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@address2)"/>
                </IN1.5.2>


                <IN1.5.3>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@city)"/>
                </IN1.5.3>


                <IN1.5.4>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@state)"/>
                </IN1.5.4>


                <IN1.5.5>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@zip)"/>
                </IN1.5.5>

                <IN1.5.6>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                </IN1.5.6>
              </IN1.5>

              <IN1.6>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
                <xsl:value-of select="string(contactinfo/@name)"/>
              </IN1.6>

              <IN1.7>
                <xsl:attribute name="Type">
                  <xsl:value-of select="'Composite Element'"/>
                </xsl:attribute>
                <IN1.7.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(contactinfo/@officephone)"/>
                </IN1.7.1>
              </IN1.7>
          <IN1.8>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@grpnum)"/>
          </IN1.8>

          <IN1.9>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
          </IN1.9>
          <IN1.10>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@code)"/>
          </IN1.10>
          <IN1.11>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@name)"/>
          </IN1.11>
            </xsl:if>
          </xsl:for-each>
          <IN1.12>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@begindate)"/>
          </IN1.12>
          <IN1.13>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@enddate)"/>
          </IN1.13>

          <IN1.14>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
          </IN1.14>
          <IN1.15>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
          </IN1.15>
          <xsl:variable name="var_subscriber" select="@subscriber"/>
          <xsl:for-each select="//PPMDResults/Results/resppartylist/respparty">
            <xsl:variable name="var1_subscriber" select="@id"/>
            <xsl:if test ="string($var_subscriber) = string($var1_subscriber)">
              <IN1.16>
                <xsl:attribute name="Type">
                  <xsl:value-of select="'Composite Element'"/>
                </xsl:attribute>

                <IN1.16.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="substring-before(string(@name), ',')"/>
                </IN1.16.1>


                <IN1.16.2>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="substring-after(string(@name), ',')"/>
                </IN1.16.2>


                <IN1.16.3>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                </IN1.16.3>

                <IN1.16.4>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                </IN1.16.4>
                <IN1.16.5>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                </IN1.16.5>

                <IN1.16.6>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@ssn)"/>
                </IN1.16.6>

              </IN1.16>

              <IN1.18>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
                <xsl:value-of select="string(@dob)"/>
              </IN1.18>

              <IN1.19>
                <xsl:attribute name="Type">
                  <xsl:value-of select="'Composite Element'"/>
                </xsl:attribute>

                <IN1.19.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@address1)"/>
                </IN1.19.1>


                <IN1.19.2>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@address2)"/>
                </IN1.19.2>


                <IN1.19.3>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@city)"/>
                </IN1.19.3>


                <IN1.19.4>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@state)"/>
                </IN1.19.4>


                <IN1.19.5>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@zip)"/>
                </IN1.19.5>

                <IN1.19.6>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(address/@countrycode)"/>
                </IN1.19.6>
              </IN1.19>
              <IN1.20>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.20>
              <IN1.21>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.21>

              <IN1.23>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.23>
              <IN1.24>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.24>
              <IN1.25>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.25>
              <IN1.26>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.26>
              <IN1.27>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.27>
              <IN1.28>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.28>
              <IN1.29>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.29>
              <IN1.30>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.30>
              <IN1.31>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.31>
              <IN1.32>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.32>
              <IN1.33>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.33>
              <IN1.34>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.34>
              <IN1.35>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.35>

              <IN1.37>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.37>
              <IN1.38>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.38>
              <IN1.39>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.39>
              <IN1.40>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.40>
              <IN1.41>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
              </IN1.41>
              <IN1.42>
                <xsl:attribute name="Type">
                  <xsl:value-of select="'Composite Element'"/>
                </xsl:attribute>

                <IN1.42.1>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                  <xsl:value-of select="string(@employer)"/>
                </IN1.42.1>

                <IN1.42.2>
                  <xsl:attribute name="Type">
                    <xsl:value-of select="$var1"/>
                  </xsl:attribute>
                </IN1.42.2>
              </IN1.42>

              <IN1.43>
                <xsl:attribute name="Type">
                  <xsl:value-of select="$var2"/>
                </xsl:attribute>
                <xsl:value-of select="string(@sex)"/>
              </IN1.43>
            </xsl:if>
          </xsl:for-each>

          <IN1.17>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@hipaarelationship)"/>
          </IN1.17>
          <IN1.22>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@sequence)"/>
          </IN1.22>
          <IN1.36>
            <xsl:attribute name="Type">
              <xsl:value-of select="$var2"/>
            </xsl:attribute>
            <xsl:value-of select="string(@subscribernum)"/>
          </IN1.36>
          <IN1.44>
            <xsl:attribute name="Type">
              <xsl:value-of select="'Composite Element'"/>
            </xsl:attribute>
            <IN1.44.1>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </IN1.44.1>
            <IN1.44.2>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </IN1.44.2>
            <IN1.44.3>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </IN1.44.3>
            <IN1.44.4>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </IN1.44.4>
            <IN1.44.5>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </IN1.44.5>
            <IN1.44.6>
              <xsl:attribute name="Type">
                <xsl:value-of select="$var1"/>
              </xsl:attribute>
            </IN1.44.6>
          </IN1.44>
        </IN1>
      </xsl:for-each>
    </ADTA08>
  </xsl:template>
</xsl:stylesheet>