/*
This script can be used to fix the following error.

The INSERT statement conflicted with the FOREIGN KEY constraint "FK_RelCacheMachineMessage_Message". 
The conflict occurred in database "SalesDemo", table "dbo.Message", column 'MessageUid'.

*/

IF EXISTS (
			SELECT TOP 1 *
			FROM sys.tables AS st
				INNER JOIN sys.columns AS sc ON st.object_id = sc.object_id
			WHERE st.name = 'ReplicationFilter' AND sc.name IN ('ObjectUid')
		   )
BEGIN
	DECLARE @nvcSql NVARCHAR (MAX)
	
	SET @nvcSql =
	N'
	PRINT ''Delete obsolete Appointment in replication filter table.''
	BEGIN
		WITH cteAppointment AS
		(
			SELECT ReplicationFilterUid,
				ObjectUid AS AppointmentUid
			FROM ReplicationFilter
			WHERE TableName = ''Appointment''
		),
		cteFilterToDelete AS
		(
			SELECT t.ReplicationFilterUid
			FROM cteAppointment AS t
				LEFT OUTER JOIN Appointment AS t1 ON t.AppointmentUid = t1.AppointmentUid
			WHERE t1.AppointmentUid IS NULL	
		)
		DELETE t1
		FROM cteFilterToDelete AS t
			INNER JOIN ReplicationFilter AS t1 ON t.ReplicationFilterUid = t1.ReplicationFilterUid
	END	

	PRINT ''Delete obsolete Message in replication filter table.''
	BEGIN
		WITH cteMessage AS
		(
			SELECT ReplicationFilterUid,
				ObjectUid AS MessageUid
			FROM ReplicationFilter
			WHERE TableName = ''Message''
		),
		cteFilterToDelete AS
		(
			SELECT t.ReplicationFilterUid
			FROM cteMessage AS t
				LEFT OUTER JOIN Message AS t1 ON t.MessageUid = t1.MessageUid
			WHERE t1.MessageUid IS NULL	
		)
		DELETE t1
		FROM cteFilterToDelete AS t
			INNER JOIN ReplicationFilter AS t1 ON t.ReplicationFilterUid = t1.ReplicationFilterUid	
	END

	PRINT ''Delete obsolete Patient in replication filter table.''
	BEGIN
		WITH ctePatient AS
		(
			SELECT ReplicationFilterUid,
				ObjectUid AS PersonUid
			FROM ReplicationFilter
			WHERE TableName = ''Patient''
		),
		cteFilterToDelete AS
		(
			SELECT t.ReplicationFilterUid
			FROM ctePatient AS t
				LEFT OUTER JOIN Patient AS t1 ON t.PersonUid = t1.PersonUid
			WHERE t1.PersonUid IS NULL	
		)
		DELETE t1
		FROM cteFilterToDelete AS t
			INNER JOIN ReplicationFilter AS t1 ON t.ReplicationFilterUid = t1.ReplicationFilterUid	
	END
	'
	EXEC sp_executesql @nvcSql
END
GO

IF EXISTS (
			SELECT TOP 1 *
			FROM sys.tables AS st
				INNER JOIN sys.columns AS sc ON st.object_id = sc.object_id
			WHERE st.name = 'ReplicationQueue' AND sc.name IN ('ObjectUid')
		   )
BEGIN
	DECLARE @nvcSql NVARCHAR (MAX)
	
	SET @nvcSql =
	N'
	PRINT ''Delete obsolete Appointment in replication queue table.''
	BEGIN
		WITH cteAppointment AS
		(
			SELECT ReplicationQueueUid,
				ObjectUid AS AppointmentUid
			FROM ReplicationQueue
			WHERE TableName = ''Appointment''
		),
		cteFilterToDelete AS
		(
			SELECT t.ReplicationQueueUid
			FROM cteAppointment AS t
				LEFT OUTER JOIN Appointment AS t1 ON t.AppointmentUid = t1.AppointmentUid
			WHERE t1.AppointmentUid IS NULL	
		)
		DELETE t1
		FROM cteFilterToDelete AS t
			INNER JOIN ReplicationQueue AS t1 ON t.ReplicationQueueUid = t1.ReplicationQueueUid
	END	

	PRINT ''Delete obsolete Message in replication queue table.''
	BEGIN
		WITH cteMessage AS
		(
			SELECT ReplicationQueueUid,
				ObjectUid AS MessageUid
			FROM ReplicationQueue
			WHERE TableName = ''Message''
		),
		cteFilterToDelete AS
		(
			SELECT t.ReplicationQueueUid
			FROM cteMessage AS t
				LEFT OUTER JOIN Message AS t1 ON t.MessageUid = t1.MessageUid
			WHERE t1.MessageUid IS NULL	
		)
		DELETE t1
		FROM cteFilterToDelete AS t
			INNER JOIN ReplicationQueue AS t1 ON t.ReplicationQueueUid = t1.ReplicationQueueUid	
	END

	PRINT ''Delete obsolete Patient in replication queue table.''
	BEGIN
		WITH ctePatient AS
		(
			SELECT ReplicationQueueUid,
				ObjectUid AS PersonUid
			FROM ReplicationQueue
			WHERE TableName = ''Patient''
		),
		cteFilterToDelete AS
		(
			SELECT t.ReplicationQueueUid
			FROM ctePatient AS t
				LEFT OUTER JOIN Patient AS t1 ON t.PersonUid = t1.PersonUid
			WHERE t1.PersonUid IS NULL	
		)
		DELETE t1
		FROM cteFilterToDelete AS t
			INNER JOIN ReplicationQueue AS t1 ON t.ReplicationQueueUid = t1.ReplicationQueueUid	
	END
	'
	EXEC sp_executesql @nvcSql
END
GO