IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyAlternativesNDC]') AND name = N'IX_FormularyAlternativesNDC_medid')
CREATE UNIQUE CLUSTERED INDEX [IX_FormularyAlternativesNDC_medid] ON [dbo].[FormularyAlternativesNDC]
(
	[FormularyAlternativesOrgUid] ASC,
	[medid] ASC,
	[Alternative_medid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayNDC]') AND name = N'IX_FormularyCopayNDC_medid')
CREATE UNIQUE CLUSTERED INDEX [IX_FormularyCopayNDC_medid] ON [dbo].[FormularyCopayNDC]
(
	[FormularyCopayOrgUid] ASC,
	[medid] ASC,
	[PharmacyType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopaySummary]') AND name = N'IX_FormularyCopaySummary_FormularyStatusType')
CREATE UNIQUE CLUSTERED INDEX [IX_FormularyCopaySummary_FormularyStatusType] ON [dbo].[FormularyCopaySummary]
(
	[FormularyCopayOrgUid] ASC,
	[FormularyProdFormuStatUid] ASC,
	[ProductType] ASC,
	[PharmacyType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCoverageNDC]') AND name = N'IX_FormularyCoverageNDC_medid')
CREATE CLUSTERED INDEX [IX_FormularyCoverageNDC_medid] ON [dbo].[FormularyCoverageNDC]
(
	[FormularyCoverageOrgUid] ASC,
	[medid] ASC,
	[CoverageListType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCoverageSummary]') AND name = N'IX_FormularyCoverageSummary_CoverageListType')
CREATE CLUSTERED INDEX [IX_FormularyCoverageSummary_CoverageListType] ON [dbo].[FormularyCoverageSummary]
(
	[FormularyCoverageOrgUid] ASC,
	[CoverageListType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyProductNDC]') AND name = N'IX_FormularyProductNDC_medid')
CREATE UNIQUE CLUSTERED INDEX [IX_FormularyProductNDC_medid] ON [dbo].[FormularyProductNDC]
(
	[FormularyIdentifierUid] ASC,
	[medid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyTextMessage]') AND name = N'IX_Team')
ALTER TABLE [dbo].[FormularyTextMessage] ADD  CONSTRAINT [IX_Team] UNIQUE CLUSTERED 
(
	[FormularyCoverageOrgUid] ASC,
	[TextMessageShort] ASC,
	[TextMessageLong] ASC,
	[TextMessageType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyAlternativesNDCQueue]') AND name = N'IX_ImportFormularyAlternativesNDCQueue_medid')
CREATE UNIQUE CLUSTERED INDEX [IX_ImportFormularyAlternativesNDCQueue_medid] ON [dbo].[ImportFormularyAlternativesNDCQueue]
(
	[FormularyAlternativesOrgUid] ASC,
	[medid] ASC,
	[Alternative_medid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCopayNDCQueue]') AND name = N'IX_ImportFormularyCopayNDCQueue_medid')
CREATE UNIQUE CLUSTERED INDEX [IX_ImportFormularyCopayNDCQueue_medid] ON [dbo].[ImportFormularyCopayNDCQueue]
(
	[FormularyCopayOrgUid] ASC,
	[medid] ASC,
	[PharmacyType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCopaySummaryQueue]') AND name = N'IX_ImportFormularyCopaySummaryQueue_FormularyStatusType')
CREATE UNIQUE CLUSTERED INDEX [IX_ImportFormularyCopaySummaryQueue_FormularyStatusType] ON [dbo].[ImportFormularyCopaySummaryQueue]
(
	[FormularyCopayOrgUid] ASC,
	[FormularyProdFormuStatUid] ASC,
	[ProductType] ASC,
	[PharmacyType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCoverageNDCQueue]') AND name = N'IX_ImportFormularyCoverageNDCQueue_medid')
CREATE CLUSTERED INDEX [IX_ImportFormularyCoverageNDCQueue_medid] ON [dbo].[ImportFormularyCoverageNDCQueue]
(
	[FormularyCoverageOrgUid] ASC,
	[medid] ASC,
	[CoverageListType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCoverageSummaryQueue]') AND name = N'IX_ImportFormularyCoverageSummaryQueue_CoverageListType')
CREATE CLUSTERED INDEX [IX_ImportFormularyCoverageSummaryQueue_CoverageListType] ON [dbo].[ImportFormularyCoverageSummaryQueue]
(
	[FormularyCoverageOrgUid] ASC,
	[CoverageListType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyProductNDCQueue]') AND name = N'IX_ImportFormularyProductNDCQueue_medid')
CREATE UNIQUE CLUSTERED INDEX [IX_ImportFormularyProductNDCQueue_medid] ON [dbo].[ImportFormularyProductNDCQueue]
(
	[FormularyIdentifierUid] ASC,
	[medid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyTextMessageQueue]') AND name = N'IX_ImportFormularyTextMessageQueue_Team')
ALTER TABLE [dbo].[ImportFormularyTextMessageQueue] ADD  CONSTRAINT [IX_ImportFormularyTextMessageQueue_Team] UNIQUE CLUSTERED 
(
	[FormularyCoverageOrgUid] ASC,
	[TextMessageShort] ASC,
	[TextMessageLong] ASC,
	[TextMessageType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxFormularyDownload]') AND name = N'IX_eRxFormularyDownload')
CREATE UNIQUE NONCLUSTERED INDEX [IX_eRxFormularyDownload] ON [dbo].[eRxFormularyDownload]
(
	[PayorID] ASC,
	[ListType] ASC,
	[ListTypeID] ASC
)
INCLUDE ( 	[LastDownloadedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxFormularyDownload]') AND name = N'IX_eRxFormularyDownload_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_eRxFormularyDownload_LastModifiedDate] ON [dbo].[eRxFormularyDownload]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[eRxFormularyDownloadUid],
	[PayorID],
	[ListType],
	[ListTypeID],
	[LastDownloadedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxFormularyDownload]') AND name = N'IX_eRxFormularyDownload_ListType')
CREATE NONCLUSTERED INDEX [IX_eRxFormularyDownload_ListType] ON [dbo].[eRxFormularyDownload]
(
	[ListType] ASC
)
INCLUDE ( 	[eRxFormularyDownloadUid],
	[PayorID],
	[ListTypeID],
	[LastDownloadedDate],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyAlternativesNDC]') AND name = N'IDX_FormularyAlternativesNDC_FormularyAlternativesNDCUid')
CREATE NONCLUSTERED INDEX [IDX_FormularyAlternativesNDC_FormularyAlternativesNDCUid] ON [dbo].[FormularyAlternativesNDC]
(
	[FormularyAlternativesNDCUid] ASC
)
INCLUDE ( 	[FormularyAlternativesOrgUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyAlternativesNDC]') AND name = N'IDX_FormularyAlternativesNDC_LastModifiedDate_FormularyAlternativesNDCUid')
CREATE NONCLUSTERED INDEX [IDX_FormularyAlternativesNDC_LastModifiedDate_FormularyAlternativesNDCUid] ON [dbo].[FormularyAlternativesNDC]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyAlternativesNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyAlternativesOrg]') AND name = N'IX_PayorID_AlternativesID')
CREATE NONCLUSTERED INDEX [IX_PayorID_AlternativesID] ON [dbo].[FormularyAlternativesOrg]
(
	[PayorID] ASC,
	[AlternativesID] ASC
)
INCLUDE ( 	[FormularyAlternativesOrgUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayNDC]') AND name = N'IDX_FormularyCopayNDC_FormularyCopayNDCUid_FormularyCopayOrgUid_medid_PharmacyType')
CREATE NONCLUSTERED INDEX [IDX_FormularyCopayNDC_FormularyCopayNDCUid_FormularyCopayOrgUid_medid_PharmacyType] ON [dbo].[FormularyCopayNDC]
(
	[FormularyCopayNDCUid] ASC,
	[FormularyCopayOrgUid] ASC,
	[medid] ASC,
	[PharmacyType] ASC
)
INCLUDE ( 	[NDC],
	[FlatCopayAmount],
	[MaximumCopayTier],
	[ListEffectiveDate],
	[LastModifiedDate],
	[LastModifiedByUid],
	[PercentCopayRate],
	[FirstCopayTerm],
	[MinimumCopay],
	[MaximumCopay],
	[DaysSupplyPerCopay],
	[CopayTier]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayNDC]') AND name = N'IDX_FormularyCopayNDC_LastModifiedDate_FormularyCopayNDCUid')
CREATE NONCLUSTERED INDEX [IDX_FormularyCopayNDC_LastModifiedDate_FormularyCopayNDCUid] ON [dbo].[FormularyCopayNDC]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyCopayNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayOrg]') AND name = N'IX_PayorID_CopayID')
CREATE NONCLUSTERED INDEX [IX_PayorID_CopayID] ON [dbo].[FormularyCopayOrg]
(
	[PayorID] ASC,
	[CopayID] ASC,
	[CopayListID] ASC
)
INCLUDE ( 	[FormularyCopayOrgUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCoverageNDC]') AND name = N'IDX_FormularyCoverageNDC_LastModifiedDate_FormularyCoverageNDCUid')
CREATE NONCLUSTERED INDEX [IDX_FormularyCoverageNDC_LastModifiedDate_FormularyCoverageNDCUid] ON [dbo].[FormularyCoverageNDC]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyCoverageNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCoverageOrg]') AND name = N'IX_PayorID_CoverageID')
CREATE NONCLUSTERED INDEX [IX_PayorID_CoverageID] ON [dbo].[FormularyCoverageOrg]
(
	[PayorID] ASC,
	[CoverageID] ASC,
	[CoverageListID] ASC
)
INCLUDE ( 	[FormularyCoverageOrgUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyOrg]') AND name = N'FormularyIdentifierUid')
CREATE NONCLUSTERED INDEX [FormularyIdentifierUid] ON [dbo].[FormularyOrg]
(
	[FormularyIdentifierUid] ASC
)
INCLUDE ( 	[UnlistedBrandFormularyStatusUid],
	[UnlistedGenericFormularyStatusUid],
	[UnlistedBrandOTCFormularyStatusUid],
	[UnlistedGenericOTCFormularyStatusUid],
	[UnlistedSuppliesFormularyStatusUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyOrg]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[FormularyOrg]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyOrg]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[FormularyOrg]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyOrg]') AND name = N'IX_PayorID_FormularyID')
CREATE NONCLUSTERED INDEX [IX_PayorID_FormularyID] ON [dbo].[FormularyOrg]
(
	[PayorID] ASC,
	[FormularyID] ASC
)
INCLUDE ( 	[FormularyOrgUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyProductNDC]') AND name = N'IDX_FormularyProductNDC_FormularyProductNDCUid_FormularyIdentifierUid_medid')
CREATE NONCLUSTERED INDEX [IDX_FormularyProductNDC_FormularyProductNDCUid_FormularyIdentifierUid_medid] ON [dbo].[FormularyProductNDC]
(
	[FormularyProductNDCUid] ASC,
	[FormularyIdentifierUid] ASC,
	[medid] ASC
)
INCLUDE ( 	[NDC],
	[FormularyProdFormuStatUid],
	[FormularyProdCostIndexUid],
	[ListEffectiveDate],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormularyProductNDC]') AND name = N'IDX_FormularyProductNDC_LastModifiedDate_FormularyProductNDCUid')
CREATE NONCLUSTERED INDEX [IDX_FormularyProductNDC_LastModifiedDate_FormularyProductNDCUid] ON [dbo].[FormularyProductNDC]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyProductNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyAlternativesNDCQueue]') AND name = N'IDX_ImportFormularyAlternativesNDCQueue_FormularyAlternativesNDCUid')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyAlternativesNDCQueue_FormularyAlternativesNDCUid] ON [dbo].[ImportFormularyAlternativesNDCQueue]
(
	[FormularyAlternativesNDCUid] ASC
)
INCLUDE ( 	[FormularyAlternativesOrgUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyAlternativesNDCQueue]') AND name = N'IDX_ImportFormularyAlternativesNDCQueue_LastModifiedDate_FormularyAlternativesNDCUid')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyAlternativesNDCQueue_LastModifiedDate_FormularyAlternativesNDCUid] ON [dbo].[ImportFormularyAlternativesNDCQueue]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyAlternativesNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCopayNDCQueue]') AND name = N'IDX_ImportFormularyCopayNDCQueue_FormularyCopayNDCUid_FormularyCopayOrgUid_medid_PharmacyType')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyCopayNDCQueue_FormularyCopayNDCUid_FormularyCopayOrgUid_medid_PharmacyType] ON [dbo].[ImportFormularyCopayNDCQueue]
(
	[FormularyCopayNDCUid] ASC,
	[FormularyCopayOrgUid] ASC,
	[medid] ASC,
	[PharmacyType] ASC
)
INCLUDE ( 	[NDC],
	[FlatCopayAmount],
	[MaximumCopayTier],
	[ListEffectiveDate],
	[LastModifiedDate],
	[LastModifiedByUid],
	[PercentCopayRate],
	[FirstCopayTerm],
	[MinimumCopay],
	[MaximumCopay],
	[DaysSupplyPerCopay],
	[CopayTier]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCopayNDCQueue]') AND name = N'IDX_ImportFormularyCopayNDCQueue_LastModifiedDate_FormularyCopayNDCUid')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyCopayNDCQueue_LastModifiedDate_FormularyCopayNDCUid] ON [dbo].[ImportFormularyCopayNDCQueue]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyCopayNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyCoverageNDCQueue]') AND name = N'IDX_ImportFormularyCoverageNDCQueue_LastModifiedDate_FormularyCoverageNDCUid')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyCoverageNDCQueue_LastModifiedDate_FormularyCoverageNDCUid] ON [dbo].[ImportFormularyCoverageNDCQueue]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyCoverageNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyProductNDCQueue]') AND name = N'IDX_ImportFormularyProductNDCQueue_FormularyProductNDCUid_FormularyIdentifierUid_medid')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyProductNDCQueue_FormularyProductNDCUid_FormularyIdentifierUid_medid] ON [dbo].[ImportFormularyProductNDCQueue]
(
	[FormularyProductNDCUid] ASC,
	[FormularyIdentifierUid] ASC,
	[medid] ASC
)
INCLUDE ( 	[NDC],
	[FormularyProdFormuStatUid],
	[FormularyProdCostIndexUid],
	[ListEffectiveDate],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImportFormularyProductNDCQueue]') AND name = N'IDX_ImportFormularyProductNDCQueue_LastModifiedDate_FormularyProductNDCUid')
CREATE NONCLUSTERED INDEX [IDX_ImportFormularyProductNDCQueue_LastModifiedDate_FormularyProductNDCUid] ON [dbo].[ImportFormularyProductNDCQueue]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FormularyProductNDCUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormularyIdentifier]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListFormularyIdentifier]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormularyIdentifier]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListFormularyIdentifier]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormularyProdCostIndex]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListFormularyProdCostIndex]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormularyProdCostIndex]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListFormularyProdCostIndex]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormularyProdFormuStat]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListFormularyProdFormuStat]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormularyProdFormuStat]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListFormularyProdFormuStat]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

