ALTER TABLE RawAttachment NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[AttachmentContent] = newdata.[AttachmentContent]
, olddata.[InkImage] = newdata.[InkImage]
FROM migtemp_RawAttachment AS newdata
INNER JOIN RawAttachment AS olddata ON
newdata.AttachmentUid = olddata.AttachmentUid
GO
INSERT RawAttachment
SELECT newdata.*
FROM migtemp_RawAttachment AS newdata
LEFT JOIN RawAttachment AS olddata ON
newdata.AttachmentUid = olddata.AttachmentUid
WHERE
olddata.AttachmentUid IS NULL
GO
DROP TABLE migtemp_RawAttachment
GO
ALTER TABLE RawAttachment WITH CHECK CHECK CONSTRAINT ALL
GO

