SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RebuildIndexes_Attachment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RebuildIndexes_Attachment] AS' 
END
GO
ALTER PROC [dbo].[RebuildIndexes_Attachment]
  @WhatOp smallint = -1,
  @GrowthByPercent int = null
AS
BEGIN
  SET NOCOUNT ON;
  PRINT 'RebuildIndexes ' + DB_NAME ()

-- rebuild indexes
  IF (@WhatOp & 2) <> 0
  BEGIN
    PRINT 'Rebuild indexes'
    DECLARE @ObjectName sysname,
            @IndexName sysname,
            @PartitionCount bigint,
            @PartitionNumber bigint,
            @FragmentationInPercent float,
            @ObjectId int,
            @IndexId int,
            @SQL varchar (8000)

    DECLARE partitions CURSOR FAST_FORWARD 
    FOR 
      WITH cteIndexPhysicalStats (ObjectId, IndexId, PartitionNo, FragInPercent) AS
      (
        SELECT object_id, index_id, partition_number, avg_fragmentation_in_percent
        FROM sys.dm_db_index_physical_stats (DB_ID(), NULL, NULL , NULL, 'LIMITED')
        WHERE avg_fragmentation_in_percent > 10.0 AND index_id > 0 -- excluding heap.
      )
      SELECT QUOTENAME (DB_NAME ()) + '.' + QUOTENAME (sc.Name) + '.' + QUOTENAME (so.Name) AS ObjectName,
        QUOTENAME (si.name) AS IndexName, 
        (SELECT COUNT (*) FROM sys.partitions WHERE object_id = ips.ObjectId AND index_id = ips.IndexId) AS PartitionCount,
        ips.PartitionNo, ips.FragInPercent, ips.ObjectId, ips.IndexId
      FROM cteIndexPhysicalStats AS ips
        INNER JOIN sys.objects AS so ON ips.ObjectId = so.object_id
        INNER JOIN sys.schemas AS sc ON so.schema_id = sc.schema_id
        INNER JOIN sys.indexes AS si ON so.object_id = si.object_id AND ips.IndexId = si.index_id
      ORDER BY so.Name, si.Name

    OPEN partitions

    FETCH NEXT
    FROM partitions
    INTO @ObjectName, @IndexName, @PartitionCount, @PartitionNumber, @FragmentationInPercent,
        @ObjectId, @IndexId

    WHILE 0 = @@FETCH_STATUS
    BEGIN
      IF @FragmentationInPercent < 30.0
      BEGIN
        SELECT @SQL = 'ALTER INDEX ' + @IndexName + ' ON ' + @ObjectName + ' REORGANIZE';
        IF @PartitionCount > 1
            SELECT @SQL = @SQL + ' PARTITION=' + CONVERT (CHAR, @PartitionNumber);
        EXEC (@SQL);
      END

      IF @FragmentationInPercent >= 30.0
      BEGIN
        SELECT @SQL = 'ALTER INDEX ' + @IndexName +' ON ' + @ObjectName + ' REBUILD';
        IF @PartitionCount > 1
            SELECT @SQL = @SQL + ' PARTITION=' + CONVERT (CHAR, @PartitionNumber);
        EXEC (@SQL);
      END
      PRINT 'Executed ' + @SQL;
      FETCH NEXT
      FROM partitions
      INTO @ObjectName, @IndexName, @PartitionCount, @PartitionNumber, @FragmentationInPercent,
          @ObjectId, @IndexId
    END
    CLOSE partitions
    DEALLOCATE partitions
  END

  -- set auto grow
  IF (@WhatOp & 4) <> 0 AND @GrowthByPercent IS NOT NULL
  BEGIN
    PRINT 'Ajust auto grow'
		CREATE TABLE #tmpspc 
    (
      Fileid int,
      FileGroup int,
      TotalExtents int,
      UsedExtents int,
      Name sysname,
      FileName sysname
    )
		INSERT #tmpspc EXEC ('dbcc showfilestats WITH NO_INFOMSGS')

    DECLARE @LogicalDBName sysname,
            @IsOffline BIT,
            @IsReadOnly BIT,
            @IsMediaReadOnly BIT,
            @IsPercentGrowth BIT,
            @AvailableSpace float,
            @Size float,
            @AvailableSpaceInPercent float,
            @ActualGrowthByPercent decimal

    DECLARE dbfiles CURSOR FAST_FORWARD FOR
    SELECT
      s.name AS [LogicalDBName],
      CAST(case s.state when 6 then 1 else 0 end AS bit) AS [IsOffline],
      s.is_read_only,
      s.is_media_read_only,
      s.is_percent_growth,
      (tspc.TotalExtents - tspc.UsedExtents)*convert(float,64) AS [AvailableSpace],
      s.size * CONVERT(float,8) AS [Size]
    FROM
      sys.filegroups AS g
      INNER JOIN sys.master_files AS s ON (s.type = 0 and s.database_id = db_id() AND
        (s.drop_lsn IS NULL)) AND (s.data_space_id=g.data_space_id)
      INNER JOIN #tmpspc tspc ON tspc.Fileid = s.file_id
    ORDER BY  [LogicalDBName] ASC

    OPEN dbfiles
    FETCH NEXT
    FROM dbfiles
    INTO 
      @LogicalDBName,
      @IsOffline,
      @IsReadOnly,
      @IsMediaReadOnly,
      @IsPercentGrowth,
      @AvailableSpace,
      @Size
    WHILE 0 = @@FETCH_STATUS
    BEGIN
      IF @IsOffline = 0 AND @IsReadOnly = 0 AND @IsMediaReadOnly = 0 AND @IsPercentGrowth <> 0
      BEGIN
        SET @AvailableSpaceInPercent = (@AvailableSpace / @Size) * 100.0
        SET @ActualGrowthByPercent = @GrowthByPercent - @AvailableSpaceInPercent
        IF @ActualGrowthByPercent > 0
        BEGIN
          PRINT DB_NAME () + ', available space in percent=' + CAST (@AvailableSpaceInPercent AS varchar (128)) +
            '% growth by percent=' + CAST (@ActualGrowthByPercent AS varchar (128))
          SET @SQL = 'ALTER DATABASE [' + DB_NAME () + '] MODIFY FILE ( NAME = N''' + @LogicalDBName +
            ''', FILEGROWTH = ' + CAST (@ActualGrowthByPercent AS VARCHAR (32)) + '%)'
          EXEC (@SQL)
        END
      END  
    
      FETCH NEXT
      FROM dbfiles
      INTO 
        @LogicalDBName,
        @IsOffline,
        @IsReadOnly,
        @IsMediaReadOnly,
        @IsPercentGrowth,
        @AvailableSpace,
        @Size
    END
    CLOSE dbfiles
    DEALLOCATE dbfiles
    DROP TABLE #tmpspc
  END
  
-- Recompile Stored Procedures, View, Functions
	IF (@WhatOp & 1) <> 0
	BEGIN
		PRINT 'There are no Procs or Views here in Attachments, so skip recompile.'
	END

  
END


GO

