-- #118975 feature-softserve _Migration.sql 
--**********************************************************************************************************
--Migration script for #118975 to update ListGender & ListRelationship entries in ListFindControlBehavior
--**********************************************************************************************************
--update for ListRelationship entry
UPDATE ListFindControlBehavior 
SET ColumnsConfig=  '{
    "PrimaryKey": "RelationshipUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
           "ColumnName": "Name",
           "ColumnDisplayName": "Name",
           "Visible": true,
           "CanFilter": true,
           "CanSelect": true,
           "Type": "string",
           "Width": 125,
           "SortOrder": "1"
        }, {
           "ColumnName": "ExternalID",
           "ColumnDisplayName": "ID",
           "Visible": true,
           "CanFilter": true,
           "CanSelect": true,
           "Type": "string",
           "Width": 50,
           "SortOrder": 0,
           "SortDirection": "Ascending",
           "AdditionalInfoDto": null
        }, {
           "ColumnName": "ANSICode",
           "ColumnDisplayName": "ANSI Code",
           "Visible": true,
           "CanFilter": true,
           "CanSelect": true,
           "Type": "string",
           "Width": 125
        }, {
           "ColumnName": "Notes",
           "ColumnDisplayName": "Notes",
           "Visible": true,
           "CanFilter": true,
           "CanSelect": true,
           "Type": "string",
           "Width": 250,
           "SortOrder": 0,
           "SortDirection": "Ascending",
           "AdditionalInfoDto": null
        }, {
           "ColumnName": "RelationshipUid",
           "Visible": false
        }, {
           "ColumnName": "Inactive",
           "ColumnDisplayName": "Inactive",
           "Visible": false,
           "CanFilter": true,
           "Type": "bool",
           "AdditionalInfoDto": ""
        }, {
           "ColumnName": "UserDefined",
           "ColumnDisplayName": "UserDefined",
           "Visible": false,
           "CanFilter": true,
           "Type": "int"
        }
    ]
}', 
ServiceAQN = 'FrameworkBO.Server.FindControl.FcAnsiListService', 
SearchColumns = '["ExternalID" ,"Name", "Notes"]'
WHERE FindControlBehaviorUid = 'EB7B41D9-5038-4C6C-B636-F638E7562D04';

--update for ListGender entry
UPDATE ListFindControlBehavior 
SET ColumnsConfig=  '{
"PrimaryKey": "GenderUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [{
        "ColumnName": "Name",
        "ColumnDisplayName": "Name",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 125
    }, {
        "ColumnName": "ExternalID",
        "ColumnDisplayName": "ID",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "ANSICode",
        "ColumnDisplayName": "ANSI Code",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 125
    }, {
        "ColumnName": "Notes",
        "ColumnDisplayName": "Notes",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 250,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "GenderUid",
        "Visible": false
    }, {
        "ColumnName": "Inactive",
        "ColumnDisplayName": "Inactive",
        "Visible": false,
        "CanFilter": true,
        "Type": "bool",
        "AdditionalInfoDto": ""
    }, {
        "ColumnName": "UserDefined",
        "ColumnDisplayName": "UserDefined",
        "Visible": false,
        "CanFilter": true,
        "Type": "int"
    }
]
}', ServiceAQN = 'FrameworkBO.Server.FindControl.FcAnsiListService'
WHERE FindControlBehaviorUid = 'ED12F295-5BE4-420F-ADD0-6E0B326ADB39';
-- #118975 end

-- #120325 _Migration.sql
UPDATE ListFindControlBehavior 
SET 
ColumnsConfig =  '{
"PrimaryKey": "SexualOrientationUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
	"ColumnName": "SexualOrientationUid",
	"ColumnDisplayName": "SexualOrientationUid",
	"Visible": false,
	"CanFilter": false,
	"CanSelect": true,
	"Type": null,
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "ExternalID",
	"ColumnDisplayName": "ID",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 50,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Name",
	"ColumnDisplayName": "Name",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 120,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null,
	"Validation":
	{
	"MaxLength" : 100,
	"MinLength" : 0,
	"IsRequired" : true
	}
},
{
	"ColumnName": "ANSICode",
	"ColumnDisplayName": "ANSI Code",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 60,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Inactive",
	"ColumnDisplayName": "Inactive",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "bool",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Notes",
	"ColumnDisplayName": "Notes",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 250,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "conceptId",
	"ColumnDisplayName": "SNOMED Code",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 120,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "UserDefined",
	"ColumnDisplayName": "UserDefined",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "int",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}
]
}'
WHERE Id in ('ListSexualOrientation')
GO
-- #120325 end

-- #121386 _Migration.sql
UPDATE ListFindControlBehavior 
SET ColumnsConfig=  '{
    "PrimaryKey": "RelationshipUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "RelationshipUid",
            "ColumnDisplayName": "RelationshipUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": true,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE FindControlBehaviorUid = 'EB7B41D9-5038-4C6C-B636-F638E7562D04';

UPDATE ListFindControlBehavior 
SET ColumnsConfig=  '{
    "PrimaryKey": "GenderUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "GenderUid",
            "ColumnDisplayName": "GenderUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": true,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE FindControlBehaviorUid = 'ED12F295-5BE4-420F-ADD0-6E0B326ADB39';
GO
-- #121386 end

-- #119967 _Migration.sql
UPDATE ListFindControlBehavior
SET
ColumnsConfig = '{
    "PrimaryKey": "ZipUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "ZipUid",
            "ColumnDisplayName": "ZipUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "ZIP Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AreaCode",
            "ColumnDisplayName": "Area Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "bool",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
where FindControlBehaviorUid = '54273EE9-E7E6-42F9-9157-B945E1836E42';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "PhoneTypeUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PhoneTypeUid",
            "ColumnDisplayName": "PhoneTypeUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SmsEnabledDefault",
            "ColumnDisplayName": "Text Enabled",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE FindControlBehaviorUid = 'AF94EA2F-CD06-4EDA-8F70-1A664CB5D5F8';
GO
-- #119967 end

-- #122772 _Migration.sql 
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "GenderUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "GenderUid",
            "ColumnDisplayName": "GenderUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null,
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null,

        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListGender';


UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "GenderIdentityUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "GenderIdentityUid",
            "ColumnDisplayName": "GenderIdentityUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "conceptId",
            "ColumnDisplayName": "SNOMED Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListGenderIdentity';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "MaritalStatusUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": 30
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "true",
            "Type": "string",
            "Width": 125,
            "SortOrder": 1
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "false",
            "Type": "string",
            "Width": 125,
            "SortOrder": 1
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": "125"
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": "false",
            "CanFilter": "true",
            "Type": "bool"
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
	]
}'
WHERE Id = 'ListMaritalStatus';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "PhoneTypeUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PhoneTypeUid",
            "ColumnDisplayName": "PhoneTypeUid",
            "Visible": false,
            "CanFilter": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SmsEnabledDefault",
            "ColumnDisplayName": "Text Enabled",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListPhoneType';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 65,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null

        }, {
			"ColumnName": "ICD10Date",
			"ColumnDisplayName": "ICD-10",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": false,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewInsuranceCarrier';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "PronounUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PronounUid",
            "ColumnDisplayName": "PronounUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListPronoun'

update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "EthnicityUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
	{
		"ColumnName": "EthnicityUid",
		"ColumnDisplayName": "EthnicityUid",
		"Visible": false
	},
	{
		"ColumnName": "ExternalID",
		"ColumnDisplayName": "ID",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "string",
		"Width": 50,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "Name",
		"ColumnDisplayName": "Name",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": true,
		"Type": "string",
		"Width": 120,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "ANSICode",
		"ColumnDisplayName": "ANSI Code",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "string",
		"Width": 60,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "Inactive",
		"ColumnDisplayName": "Inactive",
		"Visible": false,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "bool",
		"Width": 0,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "Notes",
		"ColumnDisplayName": "Notes",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "string",
		"Width": 250,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "UserDefined",
		"ColumnDisplayName": "UserDefined",
		"Visible": false,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "int",
		"Width": 0,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	}
]
}' 
where Id = 'ListEthnicity'

update ListFindControlBehavior
set ColumnsConfig = '
{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
		{
			"ColumnName": "UserDefined",
			"ColumnDisplayName": "UserDefined",
			"Visible": false,
			"CanFilter": true,
			"CanSelect": false,
			"Type": "int",
			"Width": 0,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
        {
            "ColumnName": "Internal",
            "ColumnDisplayName": "Internal",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
where Id = 'ViewCorporation'

UPDATE ListFindControlBehavior  
set ColumnsConfig = '
{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
		{
			"ColumnName": "UserDefined",
			"ColumnDisplayName": "UserDefined",
			"Visible": false,
			"CanFilter": true,
			"CanSelect": false,
			"Type": "int",
			"Width": 0,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
        {
            "ColumnName": "Internal",
            "ColumnDisplayName": "Internal",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE  Id = 'ViewInternalCorporation'

update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey":"AmendmentSourceUid",
"PrimaryDisplayName":"Name",
"InactiveColumnName":"Inactive",
"Columns":
[
{
"ColumnName":"ExternalID",
"ColumnDisplayName":"ID",
"Visible":"true",
"CanFilter":"true",
"Type":"string",
"Width":"30"
},
{
"ColumnName":"Name",
"ColumnDisplayName":"Name",
"Visible":"true",
"CanFilter":"true",
"CanSelect":"true",
"Type":"string",
"Width":"125",
"SortOrder":"1"
},
{
"ColumnName":"Notes",
"ColumnDisplayName":"Notes",
"Visible":"true",
"CanFilter":"true",
"Type":"string",
"Width":"125"
},
{
"ColumnName":"Inactive",
"ColumnDisplayName":"Inactive",
"Visible":"false",
"CanFilter":"true",
"Type":"bool"
}
]
}'
where Id = 'ListAmendmentSource'

update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "EmploymentStatusUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
	"ColumnName": "EmploymentStatusUid",
	"ColumnDisplayName": "EmploymentStatusUid",
	"Visible": false
},
{
	"ColumnName": "ExternalID",
	"ColumnDisplayName": "ID",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 50,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Name",
	"ColumnDisplayName": "Name",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 80,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "ANSICode",
	"ColumnDisplayName": "ANSI Code",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 60,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Inactive",
	"ColumnDisplayName": "Inactive",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "bool",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Notes",
	"ColumnDisplayName": "Notes",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 100,
	"SortOrder": 0,
	"SortDirection": "Ascending",
    "AdditionalInfoDto": null
},
{
	"ColumnName": "UserDefined",
	"ColumnDisplayName": "UserDefined",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "int",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}
]

}'
where Id = 'ListEmploymentStatus'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
    "PrimaryKey": "RaceUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "RaceUid",
            "ColumnDisplayName": "RaceUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListRace'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
    "PrimaryKey": "RelationshipUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "RelationshipUid",
            "ColumnDisplayName": "RelationshipUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListRelationship'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
    "PrimaryKey": "SexualOrientationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "SexualOrientationUid",
            "ColumnDisplayName": "SexualOrientationUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null,
        },
        {
            "ColumnName": "conceptId",
            "ColumnDisplayName": "SNOMED Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListSexualOrientation'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
"PrimaryKey": "ZipUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
     {
        "ColumnName": "ZipUid",
        "ColumnDisplayName": "ZipUid",
        "Visible": false,
        "CanFilter": false,
        "CanSelect": false
      },
      {
        "ColumnName": "ExternalID",
        "ColumnDisplayName": "ID",
        "Visible": false,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "Name",
        "ColumnDisplayName": "ZIP Code",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 60,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "City",
        "ColumnDisplayName": "City",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 120,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "State",
        "ColumnDisplayName": "State",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 60,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "AreaCode",
        "ColumnDisplayName": "Area Code",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "Notes",
        "ColumnDisplayName": "Notes",
        "Visible": true,
        "CanFilter": false,
        "CanSelect": false,
        "Type": "bool",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "Inactive",
        "ColumnDisplayName": "Inactive",
        "Visible": false,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "bool",
        "Width": 0,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "UserDefined",
        "ColumnDisplayName": "UserDefined",
        "Visible": false,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "int",
        "Width": 0,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      }
]
}'
WHERE Id = 'ListZip'
GO
-- #122772 end

-- #125159 _Migration.sql
UPDATE ListFindControlBehavior  
set ColumnsConfig = '
{
    "PrimaryKey": "OccupationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "OccupationUid",
            "ColumnDisplayName": "OccupationUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "OccupationCode",
            "ColumnDisplayName": "Occupation Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE  Id = 'ListOccupation'
GO
-- #125159 end

-- #125393_Migration.sql updated 3/16/23
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
"PrimaryKey": "LanguageUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "LanguageUid",
    "ColumnDisplayName": "LanguageUid",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ExternalID",
    "ColumnDisplayName": "ID",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Code",
    "ColumnDisplayName": "Code",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
	"Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "UserDefined",
    "ColumnDisplayName": "UserDefined",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "int",
    "AdditionalInfoDto": null
  }
]
}'
where Name = 'Language'
GO
-- #125393 end

-- #125134_Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "GenderUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "GenderUid",
            "ColumnDisplayName": "GenderUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null,
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null,
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListGender';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "GenderIdentityUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "GenderIdentityUid",
            "ColumnDisplayName": "GenderIdentityUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "conceptId",
            "ColumnDisplayName": "SNOMED Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListGenderIdentity';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "MaritalStatusUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": 30
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "true",
            "Type": "string",
            "Width": 125,
            "SortOrder": 1
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "false",
            "Type": "string",
            "Width": 125,
            "SortOrder": 1
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": "125"
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": "false",
            "CanFilter": "true",
            "Type": "bool"
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
	]
}'
WHERE Id = 'ListMaritalStatus';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "PronounUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PronounUid",
            "ColumnDisplayName": "PronounUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListPronoun'

Update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "EthnicityUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
	{
		"ColumnName": "EthnicityUid",
		"ColumnDisplayName": "EthnicityUid",
		"Visible": false
	},
	{
		"ColumnName": "ExternalID",
		"ColumnDisplayName": "ID",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "string",
		"Width": 50,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "Name",
		"ColumnDisplayName": "Name",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": true,
		"Type": "string",
		"Width": 120,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "ANSICode",
		"ColumnDisplayName": "ANSI Code",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "string",
		"Width": 60,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "Inactive",
		"ColumnDisplayName": "Inactive",
		"Visible": false,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "bool",
		"Width": 0,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "Notes",
		"ColumnDisplayName": "Notes",
		"Visible": true,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "string",
		"Width": 250,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	},
	{
		"ColumnName": "UserDefined",
		"ColumnDisplayName": "UserDefined",
		"Visible": false,
		"CanFilter": true,
		"CanSelect": false,
		"Type": "int",
		"Width": 0,
		"SortOrder": 0,
		"SortDirection": "Ascending",
		"AdditionalInfoDto": null
	}
]
}' 
where Id = 'ListEthnicity'

update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "EmploymentStatusUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
	"ColumnName": "EmploymentStatusUid",
	"ColumnDisplayName": "EmploymentStatusUid",
	"Visible": false
},
{
	"ColumnName": "ExternalID",
	"ColumnDisplayName": "ID",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 50,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Name",
	"ColumnDisplayName": "Name",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 80,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "ANSICode",
	"ColumnDisplayName": "ANSI Code",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 60,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Inactive",
	"ColumnDisplayName": "Inactive",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "bool",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
},
{
	"ColumnName": "Notes",
	"ColumnDisplayName": "Notes",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 100,
	"SortOrder": 0,
	"SortDirection": "Ascending",
    "AdditionalInfoDto": null
},
{
	"ColumnName": "UserDefined",
	"ColumnDisplayName": "UserDefined",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "int",
	"Width": 0,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}
]
}'
where Id = 'ListEmploymentStatus'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
    "PrimaryKey": "RaceUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "RaceUid",
            "ColumnDisplayName": "RaceUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListRace'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
    "PrimaryKey": "RelationshipUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "RelationshipUid",
            "ColumnDisplayName": "RelationshipUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListRelationship'

UPDATE ListFindControlBehavior SET ColumnsConfig = 
'{
    "PrimaryKey": "SexualOrientationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "SexualOrientationUid",
            "ColumnDisplayName": "SexualOrientationUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ANSICode",
            "ColumnDisplayName": "ANSI Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null,
        },
        {
            "ColumnName": "conceptId",
            "ColumnDisplayName": "SNOMED Code",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ListSexualOrientation'

UPDATE ListFindControlBehavior  
set ColumnsConfig = '
{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE  Id = 'ViewInternalCorporation'
GO
-- #125134 end

-- #120866_Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "InsurancePlanUid",
    "PrimaryDisplayName": "PayerPlanName",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "InsurancePlanUid",
            "ColumnDisplayName": "InsurancePlanUid",
            "Visible": false
        },
        {
            "ColumnName": "InsuranceCarrierUid",
            "ColumnDisplayName": "InsuranceCarrierUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerName",
            "ColumnDisplayName": "Payer Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanName",
            "ColumnDisplayName": "Plan Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerPlanName",
            "ColumnDisplayName": "Payer/Plan Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 160,
            "SortOrder": 1,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress1",
            "ColumnDisplayName": "Address1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress2",
            "ColumnDisplayName": "Address2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanCity",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanState",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanZip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
where Name = 'Insurance Plan'
GO
-- #120866 end


-- #125577_Migration.sql
update ListFindControlBehavior
set ColumnsConfig = '
{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Internal",
            "ColumnDisplayName": "Internal",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
where Id = 'ViewCorporation'
GO
-- #125577 end

-- #120795_Migration.sql
-- replaced by #132058

-- #120795 end

-- #123877 _Migration.sql
UPDATE ListFindControlBehavior
SET ServiceAQN ='FrameworkBO.Server.FindControl.FcFeeScheduleService'
WHERE FindControlBehaviorUid = '98E6A6DC-6595-4DAB-85AC-E534C7A8FBBE';
GO

-- #126355 _Migration.sql
Update ListFindControlBehavior 
set ServiceAQN = 'FrameworkBO.Server.FindControl.FcListFormattingTemplateService',
ColumnsConfig = '{
"PrimaryKey":"FormattingTemplateUid","PrimaryDisplayName":"Name","InactiveColumnName":"Inactive", 
"Columns":[
{"ColumnName":"ExternalID","ColumnDisplayName":"ID","Visible":false,"CanFilter":true,"Type":"string","Width":"50"},
{"ColumnName":"Name","ColumnDisplayName":"Name","Visible":true,"CanFilter":true,"CanSelect":true,"Type":"string","Width":"120","SortOrder":"1"},
{"ColumnName":"FormattingTemplateUid","Visible":false},
{"ColumnName":"Inactive","ColumnDisplayName":"Inactive","Visible":false,"CanFilter":true,"Type":"bool"},
{"ColumnName":"RootObjectType","ColumnDisplayName":"Origin For Content","Visible":true,"CanFilter":true,"Type":"string","Width":"50"},
{"ColumnName":"Notes","ColumnDisplayName":"Notes","Visible":false,"CanFilter":true,"Type":"string","Width":"250"}]}'
where Name = 'Formatting Model'
GO

-- #127673 _Migration.sql
UPDATE ListFindControlBehavior 
SET 
ColumnsConfig = 
'{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Internal",
            "ColumnDisplayName": "Internal",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewCorporation'

UPDATE ListFindControlBehavior 
SET 
ColumnsConfig = 
'{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id ='ViewInternalCorporation'

UPDATE ListFindControlBehavior 
SET 
ColumnsConfig = 
'{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 65,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null

        }, {
			"ColumnName": "ICD10Date",
			"ColumnDisplayName": "ICD-10",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": false,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id ='ViewInsuranceCarrier'

UPDATE ListFindControlBehavior 
SET 
ColumnsConfig = 
'{
"PrimaryKey": "ZipUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
     {
        "ColumnName": "ZipUid",
        "ColumnDisplayName": "ZipUid",
        "Visible": false,
        "CanFilter": false,
        "CanSelect": false
      },
      {
        "ColumnName": "ExternalID",
        "ColumnDisplayName": "ID",
        "Visible": false,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "Name",
        "ColumnDisplayName": "ZIP Code",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 60,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "City",
        "ColumnDisplayName": "City",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 120,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "State",
        "ColumnDisplayName": "State",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 60,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "AreaCode",
        "ColumnDisplayName": "Area Code",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "Notes",
        "ColumnDisplayName": "Notes",
        "Visible": true,
        "CanFilter": false,
        "CanSelect": false,
        "Type": "bool",
        "Width": 50,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "Inactive",
        "ColumnDisplayName": "Inactive",
        "Visible": false,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "bool",
        "Width": 0,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      },
      {
        "ColumnName": "UserDefined",
        "ColumnDisplayName": "UserDefined",
        "Visible": false,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "int",
        "Width": 0,
        "SortOrder": 0,
        "SortDirection": "Ascending"
      }
]
}'
WHERE Id ='ListZip'
GO
-- #127673 end

-- #126338_Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "PatientConditionUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PatientConditionUid",
            "ColumnDisplayName": "PatientConditionUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Color",
            "ColumnDisplayName": "Color",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE FindControlBehaviorUid = '2348AAF8-6EA5-4712-A3D8-6190CA0C9577';
GO
-- #126338 end

-- #121428 Pharmacy.sql
update ListFindControlBehavior 
set 
ColumnsConfig = '{ 
"PrimaryKey": "PharmacyUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "PharmacyUid",
    "ColumnDisplayName": "PharmacyUid",
    "Visible": false,
  },
  {
    "ColumnName": "MasterPharmacyUid",
    "ColumnDisplayName": "MasterPharmacyUid",
    "Visible": false,
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseName",
    "ColumnDisplayName": "Clearinghouse",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 80,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 75,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 35,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 65,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PhoneNumber1",
    "ColumnDisplayName": "PhoneNumber",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "CrossStreet",
    "ColumnDisplayName": "CrossStreet",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "IsFaxOnly",
    "ColumnDisplayName": "Fax Only",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "MailOrderEnabledNull",
    "ColumnDisplayName": "Mail Order",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "SpecialtyIDCode",
    "ColumnDisplayName": "Type",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ServiceLevelCode",
    "ColumnDisplayName": "Service Level Code",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "UserDefined",
    "ColumnDisplayName": "UserDefined",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "int",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}'
where Name = 'Pharmacy'
GO
-- #121428 end

-- #127804 _Migration.sql
UPDATE ListFindControlBehavior 
SET 
ColumnsConfig = 
'{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 65,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null

        }, {
			"ColumnName": "ICD10Date",
			"ColumnDisplayName": "ICD-10",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": false,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id ='ViewInsuranceCarrier'

UPDATE ListFindControlBehavior 
SET 
ColumnsConfig = 
'{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id ='ViewInternalCorporation'
GO
-- #127804 end

-- #128987 _Migration_PharmacyName.sql
update ListFindControlBehavior 
set 
ColumnsConfig = '{ 
"PrimaryKey": "PharmacyUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
  {
    "ColumnName": "PharmacyUid",
    "ColumnDisplayName": "PharmacyUid",
    "Visible": false,
  },
  {
    "ColumnName": "MasterPharmacyUid",
    "ColumnDisplayName": "MasterPharmacyUid",
    "Visible": false,
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseName",
    "ColumnDisplayName": "Clearinghouse",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 10,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 15,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PhoneNumber1",
    "ColumnDisplayName": "PhoneNumber",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 25,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "CrossStreet",
    "ColumnDisplayName": "CrossStreet",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "IsFaxOnly",
    "ColumnDisplayName": "Fax Only",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 20,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "MailOrderEnabledNull",
    "ColumnDisplayName": "Mail Order",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 20,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "SpecialtyIDCode",
    "ColumnDisplayName": "Type",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ServiceLevelCode",
    "ColumnDisplayName": "Service Level Code",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "UserDefined",
    "ColumnDisplayName": "UserDefined",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "int",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}'
where Name = 'Pharmacy'
GO
-- #128987 end

-- #127234 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig ='{
    "PrimaryKey": "LaboratoryUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "LaboratoryUid",
            "ColumnDisplayName": "LaboratoryUid",
            "Visible": false,
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
', SearchColumns = '["ExternalID" ,"Name", "Notes"]', EditBusinessObject = 'ListLaboratory', ServiceAQN = 'FrameworkBO.Server.FindControl.FcLaboratoryService'
WHERE FindControlBehaviorUid = 'E6957F49-AA74-42E0-9018-DEDDB79ECE73';
GO
-- #127234 end

-- #127241_Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "PersonUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PersonUid",
            "ColumnDisplayName": "PersonUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FormattedInternalName",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FirstName",
            "ColumnDisplayName": "First Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "LastName",
            "ColumnDisplayName": "Last Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsActiveUser",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1Ln1",
            "ColumnDisplayName": "Address1",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1Ln2",
            "ColumnDisplayName": "Address2",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City1",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State1",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip1",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneNumber",
            "ColumnDisplayName": "Primary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneType",
            "ColumnDisplayName": "Primary Phone Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneNumber",
            "ColumnDisplayName": "Secondary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneType",
            "ColumnDisplayName": "Secondary Phone Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1",
            "ColumnDisplayName": "Phone1",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone2",
            "ColumnDisplayName": "Phone2",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone3",
            "ColumnDisplayName": "Phone3",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone4",
            "ColumnDisplayName": "Phone4",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ClinicCenter",
            "ColumnDisplayName": "Care Team",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ClinicCenterUid",
            "ColumnDisplayName": "ClinicCenterUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Specialty",
            "ColumnDisplayName": "Specialty",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SpecialtyUid",
            "ColumnDisplayName": "SpecialtyUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsAprimaDataExchangeProvider",
            "ColumnDisplayName": "IsAprimaDataExchangeProvider",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AprimaDataExchangeProviderRegistrationUid",
            "ColumnDisplayName": "AprimaDataExchangeProviderRegistrationUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "EmailDirect",
            "ColumnDisplayName": "Direct Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
', ServiceAQN = 'FrameworkBO.Server.FindControl.FcProviderService', EditBusinessObject = 'Provider', BeginningWildcard = 0, AuditTableName = 'Provider'
WHERE FindControlBehaviorUid = '0883EAF3-C6B3-494A-A368-030289BE32F4';
GO
-- #127241 end

-- #129410 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "PersonUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PersonUid",
            "ColumnDisplayName": "PersonUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FormattedInternalName",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FirstName",
            "ColumnDisplayName": "First Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "LastName",
            "ColumnDisplayName": "Last Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsActiveUser",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1Ln1",
            "ColumnDisplayName": "Address 1",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1Ln2",
            "ColumnDisplayName": "Address 2",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City1",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State1",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip1",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneNumber",
            "ColumnDisplayName": "Primary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneType",
            "ColumnDisplayName": "Primary Phone Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneNumber",
            "ColumnDisplayName": "Secondary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneType",
            "ColumnDisplayName": "Secondary Phone Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1",
            "ColumnDisplayName": "Phone1",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone2",
            "ColumnDisplayName": "Phone2",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone3",
            "ColumnDisplayName": "Phone3",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone4",
            "ColumnDisplayName": "Phone4",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ClinicCenter",
            "ColumnDisplayName": "Care Team",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ClinicCenterUid",
            "ColumnDisplayName": "ClinicCenterUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Specialty",
            "ColumnDisplayName": "Specialty",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SpecialtyUid",
            "ColumnDisplayName": "SpecialtyUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsAprimaDataExchangeProvider",
            "ColumnDisplayName": "IsAprimaDataExchangeProvider",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AprimaDataExchangeProviderRegistrationUid",
            "ColumnDisplayName": "AprimaDataExchangeProviderRegistrationUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "EmailDirect",
            "ColumnDisplayName": "Direct Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
'
WHERE FindControlBehaviorUid = '0883EAF3-C6B3-494A-A368-030289BE32F4';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "InsurancePlanUid",
    "PrimaryDisplayName": "PayerPlanName",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "InsurancePlanUid",
            "ColumnDisplayName": "InsurancePlanUid",
            "Visible": false
        }, {
            "ColumnName": "InsuranceCarrierUid",
            "ColumnDisplayName": "InsuranceCarrierUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PayerName",
            "ColumnDisplayName": "Payer Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PlanName",
            "ColumnDisplayName": "Plan Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PayerPlanName",
            "ColumnDisplayName": "Payer/Plan Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 160,
            "SortOrder": 1,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PlanAddress1",
            "ColumnDisplayName": "Address 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PlanAddress2",
            "ColumnDisplayName": "Address 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PlanCity",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PlanState",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PlanZip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
'
WHERE FindControlBehaviorUid = '8955FB78-98F0-4BB7-8334-D0B471A339A2';
GO
-- #129410 end

-- #129416_Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '
{
    "PrimaryKey": "PersonUid",
    "PrimaryDisplayName": "FormattedInternalName",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PersonUid",
            "ColumnDisplayName": "PersonUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FormattedInternalName",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FirstName",
            "ColumnDisplayName": "First Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "LastName",
            "ColumnDisplayName": "Last Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsActiveUser",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1Ln1",
            "ColumnDisplayName": "Address 1",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1Ln2",
            "ColumnDisplayName": "Address 2",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City1",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State1",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip1",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneNumber",
            "ColumnDisplayName": "Primary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneType",
            "ColumnDisplayName": "Primary Phone Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneNumber",
            "ColumnDisplayName": "Secondary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneType",
            "ColumnDisplayName": "Secondary Phone Type",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1",
            "ColumnDisplayName": "Phone1",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone2",
            "ColumnDisplayName": "Phone2",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone3",
            "ColumnDisplayName": "Phone3",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Phone4",
            "ColumnDisplayName": "Phone4",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ClinicCenter",
            "ColumnDisplayName": "Care Team",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ClinicCenterUid",
            "ColumnDisplayName": "ClinicCenterUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Specialty",
            "ColumnDisplayName": "Specialty",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SpecialtyUid",
            "ColumnDisplayName": "SpecialtyUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsAprimaDataExchangeProvider",
            "ColumnDisplayName": "IsAprimaDataExchangeProvider",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AprimaDataExchangeProviderRegistrationUid",
            "ColumnDisplayName": "AprimaDataExchangeProviderRegistrationUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "EmailDirect",
            "ColumnDisplayName": "Direct Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
'
WHERE FindControlBehaviorUid = '0883EAF3-C6B3-494A-A368-030289BE32F4';
GO
-- #129416 end

-- #124230_Migration.sql
Update ListFindControlBehavior
set 
ServiceAQN = 'FrameworkBO.Server.FindControl.FcInsuranceCarrierService'
where name = 'Insurance Payer'
GO

-- #129895_Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "ClaimClearingHouseUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ClaimClearingHouseUid",
            "ColumnDisplayName": "ClaimClearingHouseUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 125,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false
        },
        {
            "ColumnName": "ClearingHouseType",
            "ColumnDisplayName": "ClearingHouseType",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE FindControlBehaviorUid = '474C1C8B-5F37-4924-8D85-61A49FBBC431';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "ClaimFormatUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ClaimFormatUid",
            "ColumnDisplayName": "ClaimFormatUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false
        }
    ]
}' WHERE FindControlBehaviorUid = 'C9E0FBEA-7B5C-41DD-906C-E4F70204A4BC';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "ClaimStatusPayerUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ClaimStatusPayerUid",
            "ColumnDisplayName": "ClaimStatusPayerUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 120,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 300,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE FindControlBehaviorUid = '2D8CE691-63BB-40C5-A698-D2C829557DF0';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "ClaimClearingHouseUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ClaimClearingHouseUid",
            "ColumnDisplayName": "ClaimClearingHouseUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 125,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false
        },
        {
            "ColumnName": "ClearingHouseType",
            "ColumnDisplayName": "ClearingHouseType",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE FindControlBehaviorUid = 'F1474A18-A31C-4824-B20A-5B376687BE47';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "ElectronicPayerUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ElectronicPayerUid",
            "ColumnDisplayName": "ElectronicPayerUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerOrgID",
            "ColumnDisplayName": "Clearinghouse Payer ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "clearinghousename",
            "ColumnDisplayName": "Clearinghouse Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 125,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false
        }
    ]
}' WHERE FindControlBehaviorUid = '46E3559D-6629-4B0A-A014-2E873C5E9259';
GO
-- #129895 end

-- #129389 ServiceSite.sql
delete from ListFindControlBehavior where FindControlBehaviorUid = '229a0554-4743-4800-9cdd-e92dbf683bfa'

UPDATE ListFindControlBehavior SET 
UserDefined = 0,
Inactive = 0,
SecurityGroupUid = '2EA2B900-6D9A-42B9-A0FC-E08C37B3E483',
SearchColumns = '["ExternalID","Name"]',
FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84',
BusinessObject = 'ListServiceSite',
Id = 'ListServiceSite',
ShowInListEditor = 1,
Prepopulate = 1,
HasSecurity = 1,
AllowMaintenance = 1,
AllowNew = 1,
AllowDelete = 2,
BeginningWildcard = 0,
MaxRows = 100,
AuditTableName = 'ListServiceSite',
ColumnsConfig = 
'{
  "PrimaryKey": "ServiceSiteUid",
  "PrimaryDisplayName": "Name",
  "InactiveColumnName": "Inactive",
  "Columns": [
    {
      "ColumnName": "ServiceSiteUid",
      "ColumnDisplayName": "Name",
      "Visible": false
    },
    {
      "ColumnName": "FinancialCenterUid",
      "ColumnDisplayName": "FinancialCenterUid",
      "Visible": false
    },
    {
      "ColumnName": "ServiceSiteTypeUid",
      "ColumnDisplayName": "ServiceSiteTypeUid",
      "Visible": false
    },
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ID",
      "Visible": true,
      "CanFilter": true,
      "CanSelect": false,
      "Type": "string",
      "Width": 30,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "Name",
      "ColumnDisplayName": "Name",
      "Visible": true,
      "CanFilter": true,
      "CanSelect": true,
      "Type": "string",
      "Width": 50,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "InternalSite",
      "ColumnDisplayName": "InternalSite",
      "Visible": true,
      "CanFilter": true,
      "CanSelect": false,
      "Type": "bool",
      "Width": 50,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "Notes",
      "ColumnDisplayName": "Notes",
      "Visible": true,
      "CanFilter": false,
      "CanSelect": false,
      "Type": "string",
      "Width": 50,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "Inactive",
      "ColumnDisplayName": "Inactive",
      "Visible": false,
      "AdditionalInfoDto": null
    }
  ]
}',
ServiceAQN = 'FrameworkBO.Server.FindControl.FcServiceSiteService'
WHERE FindControlBehaviorUid = 'cc879da2-ae4c-44cd-b73e-d41f8140f308';
GO
-- #129389 end

-- #128957 _Migration.sql
UPDATE ListFindControlBehavior
SET ServiceAQN = 'FrameworkBO.Server.FindControl.FcPatientConditionService',
ColumnsConfig = '{
    "PrimaryKey": "PatientConditionUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PatientConditionUid",
            "ColumnDisplayName": "PatientConditionUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Color",
            "ColumnDisplayName": "Color",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
'
WHERE FindControlBehaviorUid = '2348AAF8-6EA5-4712-A3D8-6190CA0C9577';
GO
-- #128957 end

-- #127337 _Migration.sql
update ListFindControlBehavior set ColumnsConfig = 
'
{
    "PrimaryKey": "ProcedureUid",
    "PrimaryDisplayName": "IDDescription",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Code",
            "ColumnDisplayName": "Code",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ShortDescription",
            "ColumnDisplayName": "Description",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "IDDescription",
            "ColumnDisplayName": "Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ProcedureUid",
            "ColumnDisplayName": "ProcedureUid",
            "Visible": false
        },
        {
            "ColumnName": "ViewFindProcedureUid",
            "ColumnDisplayName": "ViewFindProcedureUid",
            "Visible": false
        },
        {
            "ColumnName": "ProcedureCodeTypeUid",
            "ColumnDisplayName": "ProcedureCodeTypeUid",
            "Visible": false
        },
        {
            "ColumnName": "ProcedureCodeTypeName",
            "ColumnDisplayName": "Procedure Code Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "RevenueCode",
            "ColumnDisplayName": "RevCd",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true
        },
        {
            "ColumnName": "LongDescription",
            "ColumnDisplayName": "Long Description",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 300,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "AddInStatus",
            "ColumnDisplayName": "AddIn Status",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' where Name = 'Procedure Code'
GO
-- #127337 end

-- #130477 _Migration.sql
Update ListFindControlBehavior set 
MinimumSearchCharacters = 3,
ColumnsConfig = '{"PrimaryKey":"FormattingTemplateUid","PrimaryDisplayName":"Name","InactiveColumnName":"Inactive","Columns":[{"ColumnName":"ExternalID","ColumnDisplayName":"ID","Visible":false,"CanFilter":true,"Type":"string","Width":"50"},{"ColumnName":"Name","ColumnDisplayName":"Name","Visible":true,"CanFilter":true,"CanSelect":true,"Type":"string","Width":"120","SortOrder":"0"},{"ColumnName":"FormattingTemplateUid","Visible":false},{"ColumnName":"Inactive","ColumnDisplayName":"Inactive","Visible":false,"CanFilter":true,"Type":"bool"},{"ColumnName":"RootObjectType","ColumnDisplayName":"Origin For Content","Visible":true,"CanFilter":true,"Type":"string","Width":"50"},{"ColumnName":"Notes","ColumnDisplayName":"Notes","Visible":false,"CanFilter":true,"Type":"string","Width":"250"}]}'
where Name = 'Formatting Model'
GO

-- #130478 _Migration.sql
UPDATE ListFindControlBehavior
SET MinimumSearchCharacters = 3
WHERE FindControlBehaviorUid = '0883EAF3-C6B3-494A-A368-030289BE32F4';

UPDATE ListFindControlBehavior
SET MinimumSearchCharacters = 3
WHERE FindControlBehaviorUid = 'E6957F49-AA74-42E0-9018-DEDDB79ECE73';
GO

-- #130938 ServiceSite.sql
UPDATE ListFindControlBehavior SET 
MinimumSearchCharacters = 3,
ColumnsConfig = 
'{
  "PrimaryKey": "ServiceSiteUid",
  "PrimaryDisplayName": "Name",
  "InactiveColumnName": "Inactive",
  "Columns": [
    {
      "ColumnName": "ServiceSiteUid",
      "ColumnDisplayName": "Name",
      "Visible": false
    },
    {
      "ColumnName": "FinancialCenterUid",
      "ColumnDisplayName": "FinancialCenterUid",
      "Visible": false
    },
    {
      "ColumnName": "ServiceSiteTypeUid",
      "ColumnDisplayName": "ServiceSiteTypeUid",
      "Visible": false
    },
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ID",
      "Visible": true,
      "CanFilter": true,
      "CanSelect": false,
      "Type": "string",
      "Width": 30,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "Name",
      "ColumnDisplayName": "Name",
      "Visible": true,
      "CanFilter": true,
      "CanSelect": true,
      "Type": "string",
      "Width": 50,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "InternalSite",
      "ColumnDisplayName": "Internal",
      "Visible": true,
      "CanFilter": true,
      "CanSelect": false,
      "Type": "bool",
      "Width": 50,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "Notes",
      "ColumnDisplayName": "Notes",
      "Visible": true,
      "CanFilter": false,
      "CanSelect": false,
      "Type": "string",
      "Width": 50,
      "SortOrder": 0,
      "SortDirection": "Ascending",
      "AdditionalInfoDto": null
    },
    {
      "ColumnName": "Inactive",
      "ColumnDisplayName": "Inactive",
      "Visible": false,
      "AdditionalInfoDto": null
    }
  ]
}'
WHERE FindControlBehaviorUid = 'cc879da2-ae4c-44cd-b73e-d41f8140f308';
GO
-- #130938 end

-- #131063 _Migration.sql
Update ListFindControlBehavior
SET BeginningWildcard = 1, LastModifiedDate = '2023-01-04 09:29:00.000'
WHERE Name = 'Rx Providers';
GO

-- #128029 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CreditTypeUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CreditTypeUid",
            "ColumnDisplayName": "CreditTypeUid",
            "Visible": false,
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "TransactionTypeUid",
            "ColumnDisplayName": "TransactionTypeUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "UserDefined",
            "ColumnDisplayName": "UserDefined",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "int",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE FindControlBehaviorUid = '1BA7A3F6-D491-4491-8BB6-A468805BFFEB';
GO
-- #128029 end

-- #131767 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig ='{
    "PrimaryKey": "MHRuleDeclineReasonUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "MHRuleDeclineReasonUid",
            "ColumnDisplayName": "MHRuleDeclineReasonUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Decline Reason",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 250,
            "SortOrder": 1,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true
        }
    ]
}'
WHERE FindControlBehaviorUid = '6500D522-3807-456C-BAA2-FACFF3904591';
GO
-- #131767 end

-- #129933  Pharmacy&MasterPharmacy#129933.sql
UPDATE ListFindControlBehavior SET 
ColumnsConfig = 
'{ 
"PrimaryKey": "PharmacyUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "PharmacyUid",
    "ColumnDisplayName": "PharmacyUid",
    "Visible": false,
  },
  {
    "ColumnName": "MasterPharmacyUid",
    "ColumnDisplayName": "MasterPharmacyUid",
    "Visible": false,
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseName",
    "ColumnDisplayName": "Clearinghouse",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 10,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 15,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PhoneNumber1",
    "ColumnDisplayName": "Phone Number",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 25,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "CrossStreet",
    "ColumnDisplayName": "Cross Street",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "IsFaxOnly",
    "ColumnDisplayName": "Fax Only",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 20,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "MailOrderEnabledNull",
    "ColumnDisplayName": "Mail Order",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 20,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "SpecialtyIDCode",
    "ColumnDisplayName": "Type",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ServiceLevelCode",
    "ColumnDisplayName": "Service Level Code",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 30,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "UserDefined",
    "ColumnDisplayName": "UserDefined",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "int",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}'
WHERE FindControlBehaviorUid = '30a4a3c3-4116-40f3-87a2-30f072f4245f';

UPDATE ListFindControlBehavior SET 
ColumnsConfig = 
'{
"PrimaryKey": "MasterPharmacyUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "MasterPharmacyUid",
    "ColumnDisplayName": "MasterPharmacyUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ExternalID",
    "ColumnDisplayName": "ID",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "SortOrder": 0,
	"Width": 70,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseName",
    "ColumnDisplayName": "Clearinghouse",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseUid",
    "ColumnDisplayName": "PharmacyClearinghouseUid",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 75,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 35,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 65,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "CrossStreet",
    "ColumnDisplayName": "Cross Street",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "IsFaxOnly",
    "ColumnDisplayName": "Fax Only",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "MailOrderEnabled",
    "ColumnDisplayName": "Mail Order",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "SpecialtyIDCode",
    "ColumnDisplayName": "Type",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ServiceLevelCode",
    "ColumnDisplayName": "Service Level Code",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "int",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 125,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}'
WHERE FindControlBehaviorUid = '5ad9e9c3-5c4f-4f26-a2a6-b0f881584210';
GO
-- #129933 end

-- #128051 _Migration.sql
UPDATE ListFindControlBehavior 
SET
SecurityGroupUid = lft.SecurityGroupUid,
ShowInListEditor    =    lft.ShowInListEditor,
Prepopulate    =    lft.Prepopulate,
HasSecurity    =    lft.HasSecurity,
AllowMaintenance    =    lft.AllowMaintenance,
AllowDelete    =    lft.AllowDelete,
AllowNew    =    lft.AllowNew,
BeginningWildcard    =    lft.BeginningWildcard,
BusinessObject    =    lft.BusinessObject,
EditBusinessObject    =    lft.EditBusinessObject,
MaxRows    =    lft.MaxRows,
Notes    =    lft.Notes,
Inactive    =    lft.Inactive,
UserDefined    =    lft.UserDefined,
AuditTableName    =    lft.AuditTableName,
AddInUid    =    lft.AddInUid,
LicenseCode    =    lft.LicenseCode    
FROM ListFindTable lft
WHERE lft.FindTableUid = ListFindControlBehavior.FindTableUid
AND ListFindControlBehavior.FindControlBehaviorUid = '82D755BC-BC3A-4CD1-B379-ECBEA30C4655';

UPDATE ListFindControlBehavior
SET ServiceAQN ='FrameworkBO.Server.FindControl.FcPatientProgramService', MinimumSearchCharacters = 3, 
ColumnsConfig ='{
    "PrimaryKey": "PatientProgramUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PatientProgramUid",
            "ColumnDisplayName": "PatientProgramUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ToolbarText",
            "ColumnDisplayName": "Toolbar Text",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Color",
            "ColumnDisplayName": "Color",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE FindControlBehaviorUid = '82D755BC-BC3A-4CD1-B379-ECBEA30C4655';
GO
-- #128051 end

-- #132058 _Migration.sql
UPDATE ListFindControlBehavior
SET ServiceAQN = 'FrameworkBO.Server.FindControl.FcLabBillCodeService'
WHERE FindControlBehaviorUid = 'DC86B5EE-6D85-4172-A0D8-C0A78DBC4F55';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "PharmacyUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PharmacyUid",
            "ColumnDisplayName": "PharmacyUid",
            "Visible": false,
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PharmacyClearinghouseName",
            "ColumnDisplayName": "Clearinghouse",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 15,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber1",
            "ColumnDisplayName": "Phone Number",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "CrossStreet",
            "ColumnDisplayName": "Cross Street",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsFaxOnly",
            "ColumnDisplayName": "Fax Only",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 20,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "MailOrderEnabled",
            "ColumnDisplayName": "Mail Order",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 20,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SpecialtyIDCode",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ServiceLevelCode",
            "ColumnDisplayName": "Service Level Code",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
'
WHERE FindControlBehaviorUid = '30A4A3C3-4116-40F3-87A2-30F072F4245F';

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "InsurancePayerContactUid",
    "PrimaryDisplayName": "FullName",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "InsurancePayerContactUid",
            "ColumnDisplayName": "InsurancePayerContactUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": true,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FullName",
            "ColumnDisplayName": "Full Name",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "InsurancePayer",
            "ColumnDisplayName": "Insurance Payer",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "InsurancePlan",
            "ColumnDisplayName": "Insurance Plan",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "xml"
        }, {
            "ColumnName": "Phone1.PhoneNumber",
            "ColumnDisplayName": "Phone 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneType",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "xml",
        }, {
            "ColumnName": "Phone2.PhoneNumber",
            "ColumnDisplayName": "Phone 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneType",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Email1",
            "ColumnDisplayName": "Email 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Email2",
            "ColumnDisplayName": "Email 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}
'
WHERE FindControlBehaviorUid = '8C4B3AE6-3911-446F-810B-912E00664A67';
GO
-- #132058 end

-- #132965 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "InsurancePlanUid",
    "PrimaryDisplayName": "PayerPlanName",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "InsurancePlanUid",
            "ColumnDisplayName": "InsurancePlanUid",
            "Visible": false
        },
        {
            "ColumnName": "InsuranceCarrierUid",
            "ColumnDisplayName": "InsuranceCarrierUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerName",
            "ColumnDisplayName": "Payer Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanName",
            "ColumnDisplayName": "Plan Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerPlanName",
            "ColumnDisplayName": "Payer/Plan Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 150,
            "SortOrder": 1,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress1",
            "ColumnDisplayName": "Address 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress2",
            "ColumnDisplayName": "Address 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanCity",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanState",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanZip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE Name = 'Insurance Plan'

GO

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
			"Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 65,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ICD10Date",
            "ColumnDisplayName": "ICD-10",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE Name = 'Insurance Payer'
GO
-- #132965 end

-- #128044 _Migration.sql
UPDATE ListFindControlBehavior
SET ServiceAQN ='FrameworkBO.Server.FindControl.FcGenericCodeService'
WHERE FindControlBehaviorUid = '8E265CC0-2040-4FB7-8F4B-10A2274FE5D7';
GO
-- #128044 _Migration_2.sql
UPDATE ListFindControlBehavior
SET ServiceAQN ='FrameworkBO.Server.FindControl.FcIndustryService'
WHERE FindControlBehaviorUid = '8E265CC0-2040-4FB7-8F4B-10A2274FE5D7';
GO


-- #128960 _Migration.sql
--ViewCorporation	
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Internal",
            "ColumnDisplayName": "Internal",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewCorporation';

--ViewEmployer
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "InsuranceName",
            "ColumnDisplayName": "Insurance",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 125,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 250,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewEmployer';

--ViewInsuranceCarrier	
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null

        }, {
			"ColumnName": "ICD10Date",
			"ColumnDisplayName": "ICD-10",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": false,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewInsuranceCarrier';

--ViewPayerPlan	
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "InsurancePlanUid",
    "PrimaryDisplayName": "PayerPlanName",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "InsurancePlanUid",
            "ColumnDisplayName": "InsurancePlanUid",
            "Visible": false
        },
        {
            "ColumnName": "InsuranceCarrierUid",
            "ColumnDisplayName": "InsuranceCarrierUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerName",
            "ColumnDisplayName": "Payer Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanName",
            "ColumnDisplayName": "Plan Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerPlanName",
            "ColumnDisplayName": "Payer/Plan Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 160,
            "SortOrder": 1,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress1",
            "ColumnDisplayName": "Address 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress2",
            "ColumnDisplayName": "Address 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanCity",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanState",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanZip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewPayerPlan';


--ViewInternalCorporation
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName" : "CorporationUid",
            "Visible" : false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName" : "ID",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 25,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName" : "Name",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Address1",
            "ColumnDisplayName" : "Address",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "City",
            "ColumnDisplayName" : "City",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "State",
            "ColumnDisplayName" : "State",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 3,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Zip",
            "ColumnDisplayName" : "ZIP",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName" : "Primary Phone",
            "Visible" : true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewInternalCorporation';

--ViewMasterPharmacy
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
"PrimaryKey": "MasterPharmacyUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "MasterPharmacyUid",
    "ColumnDisplayName": "MasterPharmacyUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ExternalID",
    "ColumnDisplayName": "ID",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "SortOrder": 0,
	"Width": 70,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseName",
    "ColumnDisplayName": "Clearinghouse",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PharmacyClearinghouseUid",
    "ColumnDisplayName": "PharmacyClearinghouseUid",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 75,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 35,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 80,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "CrossStreet",
    "ColumnDisplayName": "Cross Street",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "IsFaxOnly",
    "ColumnDisplayName": "Fax Only",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "MailOrderEnabled",
    "ColumnDisplayName": "Mail Order",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 40,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "SpecialtyIDCode",
    "ColumnDisplayName": "Type",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ServiceLevelCode",
    "ColumnDisplayName": "Service Level Code",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "int",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "bool",
    "Width": 0,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 125,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}'
WHERE Id = 'ViewMasterPharmacy';

--ViewMedicalServicesProvider
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
"PrimaryKey": "CorporationUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "CorporationUid",
    "ColumnDisplayName": "CorporationUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ExternalID",
    "ColumnDisplayName": "ID",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
	"Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
	"Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "MedicalServicesTypeName",
    "ColumnDisplayName": "Type",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 80,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PhoneNumber",
    "ColumnDisplayName": "Phone",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 160,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PhoneNumberFax",
    "ColumnDisplayName": "Fax",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 160,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "AdditionalInfoDto": null
  },
]
}'
WHERE Id = 'ViewMedicalServicesProvider';

--ViewPharmacy
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "PharmacyUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "PharmacyUid",
            "ColumnDisplayName": "PharmacyUid",
            "Visible": false,
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PharmacyClearinghouseName",
            "ColumnDisplayName": "Clearinghouse",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 10,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber1",
            "ColumnDisplayName": "Phone Number",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "CrossStreet",
            "ColumnDisplayName": "Cross Street",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "IsFaxOnly",
            "ColumnDisplayName": "Fax Only",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 20,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "MailOrderEnabled",
            "ColumnDisplayName": "Mail Order",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 20,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SpecialtyIDCode",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ServiceLevelCode",
            "ColumnDisplayName": "Service Level Code",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewPharmacy';

--ViewResponsibleParty
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "AccountResponsiblePartyUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "AccountResponsiblePartyUid",
            "ColumnDisplayName": "AccountResponsiblePartyUid",
            "Visible": false
        }, {
            "ColumnName": "ResponsiblePartyUid",
            "ColumnDisplayName": "ResponsiblePartyUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AkaName",
            "ColumnDisplayName": "AKA Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FirstName",
            "ColumnDisplayName": "First Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "LastName",
            "ColumnDisplayName": "Last Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Birthdate",
            "ColumnDisplayName": "Birth Date",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "date",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AkaFirstName",
            "ColumnDisplayName": "AKA First Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AkaLastName",
            "ColumnDisplayName": "AKA Last Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SocialSecurityNumber",
            "ColumnDisplayName": "SSN",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Primary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address 1",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address2",
            "ColumnDisplayName": "Address 2",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Type",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewResponsibleParty';
GO
-- #128960 end

-- #134885 _Migration.sql
--ViewInsuranceCarrier	
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null

        }, {
			"ColumnName": "ICD10Date",
			"ColumnDisplayName": "ICD-10",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": false,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Id = 'ViewInsuranceCarrier';
GO
-- #134885 end

-- #135325 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "InsurancePayerContactUid",
    "PrimaryDisplayName": "FullName",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "InsurancePayerContactUid",
            "ColumnDisplayName": "InsurancePayerContactUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FullName",
            "ColumnDisplayName": "Full Name",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "InsurancePayer",
            "ColumnDisplayName": "Insurance Payer",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "InsurancePlan",
            "ColumnDisplayName": "Insurance Plan",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "xml"
        }, {
            "ColumnName": "Phone1.PhoneNumber",
            "ColumnDisplayName": "Phone 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone1.PhoneType",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "xml",
        }, {
            "ColumnName": "Phone2.PhoneNumber",
            "ColumnDisplayName": "Phone 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Phone2.PhoneType",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Email1",
            "ColumnDisplayName": "Email 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Email2",
            "ColumnDisplayName": "Email 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE FindControlBehaviorUid = '8C4B3AE6-3911-446F-810B-912E00664A67';
GO
-- #135325 end

-- #135422 _Migration.sql
--ViewClearinghouseInactive
Update  ListFindControlBehavior
set ColumnsConfig=
'{
    "PrimaryKey": "ElectronicPayerUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "ElectronicPayerUid",
            "ColumnDisplayName": "ElectronicPayerUid",
            "Visible": false
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerOrgID",
            "ColumnDisplayName": "Clearinghouse Payer ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "clearinghousename",
            "ColumnDisplayName": "Clearinghouse Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 150,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
		{
            "ColumnName": "ClaimClearingHouseUid",
            "ColumnDisplayName": "ClaimClearingHouseUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 125,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false
        }
    ]
}'
where id= 'ViewClearinghouseInactive'
GO
-- #135422 end

-- #135859 _Migration.sql
UPDATE ListFindControlBehavior
SET ColumnsConfig = '  {
    "PrimaryKey": "InsurancePlanUid",
    "PrimaryDisplayName": "PayerPlanName",
    "InactiveColumnName": "Inactive",
    "Columns": [
        {
            "ColumnName": "InsurancePlanUid",
            "ColumnDisplayName": "InsurancePlanUid",
            "Visible": false
        },
        {
            "ColumnName": "InsuranceCarrierUid",
            "ColumnDisplayName": "InsuranceCarrierUid",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": null,
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
		{
            "ColumnName": "PayerName",
            "ColumnDisplayName": "Payer Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanName",
            "ColumnDisplayName": "Plan Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PayerPlanName",
            "ColumnDisplayName": "Payer/Plan Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "Width": 160,
            "SortOrder": 1,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress1",
            "ColumnDisplayName": "Address 1",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanAddress2",
            "ColumnDisplayName": "Address 2",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanCity",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanState",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 40,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PlanZip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "Width": 0,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}'
WHERE Name = 'Insurance Plan'

GO

UPDATE ListFindControlBehavior
SET ColumnsConfig = '{
    "PrimaryKey": "CorporationUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
            "Visible": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
		    "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": true,
            "Type": "string",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 75,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 35,
            "SortOrder": 0,
            "SortDirection": "Ascending"
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Phone",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 70,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null

        }, {
			"ColumnName": "ICD10Date",
			"ColumnDisplayName": "ICD-10",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": false,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }
    ]
}' WHERE Name = 'Insurance Payer'
GO
-- #135859 end

-- #128046 _Migration.sql
Update ListFindControlBehavior
Set ColumnsConfig = '{
"PrimaryKey": "LabBillCodeUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "LabBillCodeUid",
    "ColumnDisplayName": "Name",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ExternalID",
    "ColumnDisplayName": "ID",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
	"Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Name",
    "ColumnDisplayName": "Bill Code",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "InsurancePayer",
    "ColumnDisplayName": "Insurance Payer",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "LabPartner",
    "ColumnDisplayName": "Lab Partner",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "AdditionalInfoDto": null
  },
]
}',
ValidationConfig =
'{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 50
        }, {
            "ColumnName": "Name",
            "MaxLength": 100
        }, {
            "ColumnName": "InsurancePayer",
            "MaxLength": 100
        }, {
            "ColumnName": "LabPartner",
            "MaxLength": 50
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}'
 where Id = 'ListLabBillCode'
GO
-- #128046 end

-- #135785 _Migration.sql
Update ListFindControlBehavior
set ValidationConfig =
'{
    "ColumnsValidation": [{
            "ColumnName": "Notes",
            "MaxLength": 65535
        }, {
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 100
        }, {
            "ColumnName": "PrimaryContact",
            "MaxLength": 50
        }, {
            "ColumnName": "SecondaryContact",
            "MaxLength": 50
        }, {
            "ColumnName": "Email1",
            "MaxLength": 100
        }, {
            "ColumnName": "Email2",
            "MaxLength": 100
        }, {
            "ColumnName": "Address1",
            "MaxLength": 100,
        }, {
            "ColumnName": "Address2",
            "MaxLength": 100
        }, {
            "ColumnName": "City",
            "MaxLength": 35
        }, {
            "ColumnName": "State",
            "MaxLength": 3
        }, {
            "ColumnName": "Zip",
            "MaxLength": 10
        }, {
            "ColumnName": "Country",
            "MaxLength": 25
        }, {
            "ColumnName": "CountyName",
            "MaxLength": 25
        }, {
            "ColumnName": "CountyCode",
            "MaxLength": 10
        }, {
            "ColumnName": "Phone1.PhoneNumber",
            "MaxLength": 80,
            "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
        }, {
            "ColumnName": "Phone1.PhoneType",
            "MaxLength": 50
        }, {
            "ColumnName": "Phone2.PhoneNumber",
            "MaxLength": 80,
            "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
        }, {
            "ColumnName": "Phone2.PhoneType",
            "MaxLength": 50
        }, {
            "ColumnName": "Phone3.PhoneNumber",
            "MaxLength": 80,
            "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
        }, {
            "ColumnName": "Phone3.PhoneType",
            "MaxLength": 50
        }, {
            "ColumnName": "Phone4.PhoneNumber",
            "MaxLength": 80,
            "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
        }, {
            "ColumnName": "Phone4.PhoneType",
            "MaxLength": 50
        }, {
            "ColumnName": "InsurancePayerContactUid"
        }, {
            "ColumnName": "InsurancePlanUid"
        }
    ]
}'
where Id = 'ViewEmployer'
GO
-- #135785 end

-- #136447 _Migration.sql
Update ListFindControlBehavior
set SearchColumns = '["Name"]'
where id = 'ChcViewSFInsuranceCarrier';

Update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "PersonUid",
"PrimaryDisplayName": "FullName",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "PersonUid",
    "ColumnDisplayName": "PersonUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "FullName",
    "ColumnDisplayName": "Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "AkaName",
    "ColumnDisplayName": "AKA Name",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Birthdate",
    "ColumnDisplayName": "Birth Date",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "SocialSecurityNumber",
    "ColumnDisplayName": "SSN",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PhoneNumber",
    "ColumnDisplayName": "Primary Phone",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 160,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 80,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}',
SearchColumns = '["FullName"]'
where id = 'ViewFindFacilityPerson';


Update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "PersonUid",
"PrimaryDisplayName": "UserName",
"InactiveColumnName": "",
"Columns": [
{
    "ColumnName": "PersonUid",
    "ColumnDisplayName": "PersonUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "UserName",
    "ColumnDisplayName": "User Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "FullName",
    "ColumnDisplayName": "Full Name",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}',
SearchColumns = '["UserName"]',
SecurityGroupUid = null
where id = 'ViewPersonWeb'
GO
-- #136447 end

-- #136199 _Migration.sql
Update ListFindControlBehavior
set ColumnsConfig = '{
"PrimaryKey": "PersonUid",
"PrimaryDisplayName": "UserName",
"InactiveColumnName": "",
"Columns": [
{
    "ColumnName": "PersonUid",
    "ColumnDisplayName": "PersonUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "UserName",
    "ColumnDisplayName": "User Name",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "FullName",
    "ColumnDisplayName": "Full Name",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "PatientWebAccess",
    "ColumnDisplayName": "Patient Web Access",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
	"Width": 20,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  }
]
}',
MaxRows = 100
where Id = 'ViewPersonWeb'
GO
-- #136199 end

-- #136881_Migration.sql
update ListFindControlBehavior
Set MinimumSearchCharacters = 3
where Id = 'ListMaritalStatus'
GO

-- #139534_Migration.sql
update ListFindControlBehavior
Set ColumnsConfig = '{
"PrimaryKey": "LabBillCodeUid",
"PrimaryDisplayName": "BillCode",
"InactiveColumnName": "Inactive",
"Columns": [
{
    "ColumnName": "LabBillCodeUid",
    "ColumnDisplayName": "LabBillCodeUid",
    "Visible": false,
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "ExternalID",
    "ColumnDisplayName": "ID",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
	"Width": 50,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "BillCode",
    "ColumnDisplayName": "Bill Code",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "InsurancePayer",
    "ColumnDisplayName": "Insurance Payer",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "LabPartner",
    "ColumnDisplayName": "Lab Partner",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": true,
    "Type": "string",
	"Width": 120,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Notes",
    "ColumnDisplayName": "Notes",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 200,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
  },
  {
    "ColumnName": "Inactive",
    "ColumnDisplayName": "Inactive",
    "Visible": false,
    "AdditionalInfoDto": null
  }
]
}'
 where Id = 'ListLabBillCode'
GO
-- #139534 end

-- #132121_Migration.sql
update ListFindControlBehavior
set ValidationConfig =
'{
"ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 50
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}'
where id = 'ListPayerTypologySource'
GO

-- #141195_Migration.sql
 Update [ListFindControlBehavior]
 set ServiceAqn ='FrameworkBO.Server.FindControl.FcGenericListService'
 where Id = 'ListPayerTypologySource'
GO

-- #141542_Migration.sql
 Update [ListFindControlBehavior]
 set AllowNew = 0
 where Id = 'ListPayerTypologySource'
GO

-- #141710_Migration.sql
Update ListFindControlBehavior
set ColumnsConfig = 
'{
"PrimaryKey": "CorporationUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [{
        "ColumnName": "CorporationUid",
        "ColumnDisplayName": "CorporationUid",
        "Visible": false
    }, {
        "ColumnName": "Name",
        "ColumnDisplayName": "Name",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": true,
        "Type": "string",
        "Width": 100,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "Address1",
        "ColumnDisplayName": "Address",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 200,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "City",
        "ColumnDisplayName": "City",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 75,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "State",
        "ColumnDisplayName": "State",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 35,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "Zip",
        "ColumnDisplayName": "ZIP",
        "Visible": true,
        "CanFilter": true,
        "CanSelect": false,
        "Type": "string",
        "Width": 80,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }, {
        "ColumnName": "PhoneNumber1",
        "ColumnDisplayName": "Phone",
        "Visible": true,
        "CanFilter": false,
        "CanSelect": false,
        "Type": "string",
        "Width": 160,
        "SortOrder": 0,
        "SortDirection": "Ascending",
        "AdditionalInfoDto": null
    }
]
}'
where id = 'ChcViewSFInsuranceCarrier'


Update ListFindControlBehavior
set ColumnsConfig =
'{
"PrimaryKey": "ViewPrimaryKeyUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
"Columns": [
{
	"ColumnName": "ViewPrimaryKeyUid",
	"ColumnDisplayName": "ViewPrimaryKeyUid",
	"Visible": false
}, {
	"ColumnName": "ExternalID",
	"ColumnDisplayName": "ID",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "string",
	"Width": 50,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}, {
	"ColumnName": "Name",
	"ColumnDisplayName": "Name",
	"Visible": true,
	"CanFilter": true,
	"CanSelect": true,
	"Type": "string",
	"Width": 200,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}, {
    "ColumnName": "Birthdate",
    "ColumnDisplayName": "Birth Date",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "date",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
    "ColumnName": "SocialSecurityNumber",
    "ColumnDisplayName": "SSN",
    "Visible": true,
    "CanFilter": true,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
	"ColumnName": "PhoneNumber1",
	"ColumnDisplayName": "Primary Phone",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 160,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
    "ColumnName": "Address1",
    "ColumnDisplayName": "Address1",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
    "ColumnName": "Address2",
    "ColumnDisplayName": "Address2",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 100,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
    "ColumnName": "City",
    "ColumnDisplayName": "City",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 65,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
    "ColumnName": "State",
    "ColumnDisplayName": "State",
    "Visible": false,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 70,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
    "ColumnName": "Zip",
    "ColumnDisplayName": "ZIP",
    "Visible": true,
    "CanFilter": false,
    "CanSelect": false,
    "Type": "string",
    "Width": 80,
    "SortOrder": 0,
    "SortDirection": "Ascending",
    "AdditionalInfoDto": null
}, {
	"ColumnName": "Inactive",
	"ColumnDisplayName": "Inactive",
	"Visible": false,
	"CanFilter": true,
	"CanSelect": false,
	"Type": "bool",
	"Width": 50,
	"SortOrder": 0,
	"SortDirection": "Ascending",
	"AdditionalInfoDto": null
}]}'
where id = 'ViewPersonCorporation'
GO
-- #141710 end

-- #128061_Migration.sql
delete from ListFindControlBehavior where id in ('ViewPersonCorporation')
GO

-- #141777_Migration.sql
update ListFindControlBehavior
set ValidationConfig ='{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 255
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}'
where id ='ListPayerTypologySource' 
GO

-- #142027_Migration.sql
update ListFindTable
set AllowNew =0 where Id = 'ListPayerTypologySource'
GO

-- #142068 migration for validation that missed.sql
Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 50
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}' where Id = 'ListAmendmentSource'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 50
        }, {
            "ColumnName": "ANSICode",
            "MaxLength": 10
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}' where Id = 'ListGender'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 100
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}' where Id = 'ListLaboratory'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 50
        }, {
            "ColumnName": "ANSICode",
            "MaxLength": 10
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}' where Id = 'ListMaritalStatus'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 100
        }, {
            "ColumnName": "ToolbarText",
            "MaxLength": 10
        }, {
            "ColumnName": "Color",
            "RegExp": "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$"
        }
    ]
}' where Id = 'ListPatientProgram'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 50
        }, {
            "ColumnName": "ANSICode",
            "MaxLength": 10
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}' where Id = 'ListRelationship'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "Name",
            "MaxLength": 50
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }
    ]
}' where Id = 'ListServiceSite'

Update [ListFindControlBehavior] Set ValidationConfig = '{
    "ColumnsValidation": [{
            "ColumnName": "ExternalID",
            "MaxLength": 25
        }, {
            "ColumnName": "FormattedInternalName",
            "MaxLength": 250
        }, {
            "ColumnName": "FirstName",
            "MaxLength": 50
        }, {
            "ColumnName": "LastName",
            "MaxLength": 50
        }, {
            "ColumnName": "Address1Ln1",
            "MaxLength": 100
        }, {
            "ColumnName": "Address1Ln2",
            "MaxLength": 100
        }, {
            "ColumnName": "City1",
            "MaxLength": 35
        }, {
            "ColumnName": "State1",
            "MaxLength": 3
        }, {
            "ColumnName": "Zip1",
            "MaxLength": 10
        }, {
            "ColumnName": "Notes",
            "MaxLength": 65535
        }, {
            "ColumnName": "EmailDirect",
            "MaxLength": 255
        }
    ]
}' where Id = 'ViewProvider'
GO 
-- #142068 end

-- #132138 #ResponsibleParty_Migration.sql
--ViewResponsibleParty
update ListFindControlBehavior 
set ColumnsConfig =
'{
    "PrimaryKey": "AccountResponsiblePartyUid",
    "PrimaryDisplayName": "Name",
    "InactiveColumnName": "Inactive",
    "Columns": [{
            "ColumnName": "AccountResponsiblePartyUid",
            "ColumnDisplayName": "AccountResponsiblePartyUid",
            "Visible": false
        }, {
            "ColumnName": "ResponsiblePartyUid",
            "ColumnDisplayName": "ResponsiblePartyUid",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false
        }, {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 50,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": true,
            "Type": "string",
            "Width": 200,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AkaName",
            "ColumnDisplayName": "AKA Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "FirstName",
            "ColumnDisplayName": "First Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "LastName",
            "ColumnDisplayName": "Last Name",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Birthdate",
            "ColumnDisplayName": "Birth Date",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "date",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AkaFirstName",
            "ColumnDisplayName": "AKA First Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "AkaLastName",
            "ColumnDisplayName": "AKA Last Name",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "SocialSecurityNumber",
            "ColumnDisplayName": "SSN",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "PhoneNumber",
            "ColumnDisplayName": "Primary Phone",
            "Visible": true,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 160,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address1",
            "ColumnDisplayName": "Address 1",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Address2",
            "ColumnDisplayName": "Address 2",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 100,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "City",
            "ColumnDisplayName": "City",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 60,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "State",
            "ColumnDisplayName": "State",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 30,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Zip",
            "ColumnDisplayName": "ZIP",
            "Visible": false,
            "CanFilter": true,
            "CanSelect": false,
            "Type": "string",
            "Width": 80,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Type",
            "ColumnDisplayName": "Type",
            "Visible": true,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "string",
            "Width": 90,
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": false,
            "CanFilter": false,
            "CanSelect": false,
            "Type": "bool",
            "SortOrder": 0,
            "SortDirection": "Ascending",
            "AdditionalInfoDto": null
        }, {
            "ColumnName": "CorporationUid",
            "ColumnDisplayName": "CorporationUid",
			"CanSelect": false,
			"Visible": false 
		}, {
            "ColumnName": "PersonUid",
            "ColumnDisplayName": "PersonUid",
			"CanSelect": false,
			"Visible": false }
    ]
}
',
ValidationConfig = 
'{"ColumnsValidation": [{
        "ColumnName": "ExternalID",
        "MaxLength": 25
    }, {
        "ColumnName": "Name",
        "MaxLength": 100
    }, {
        "ColumnName": "Corporation.PrimaryContact",
        "MaxLength": 50
    }, {
        "ColumnName": "Corporation.SecondaryContact",
        "MaxLength": 50
    }, {
        "ColumnName": "Corporation.Email1",
        "MaxLength": 100
    }, {
        "ColumnName": "Corporation.Email2",
        "MaxLength": 100 
    }, {
        "ColumnName": "Corporation.Line1",
        "MaxLength": 100,
    }, {
        "ColumnName": "Corporation.Line2",
        "MaxLength": 100
    }, {
        "ColumnName": "Corporation.City",
        "MaxLength": 35
    }, {
        "ColumnName": "Corporation.State",
        "MaxLength": 3
    }, {
        "ColumnName": "Corporation.Zip",
        "MaxLength": 10
    }, {
        "ColumnName": "Corporation.Country",
        "MaxLength": 25
    }, {
        "ColumnName": "Corporation.CountyName",
        "MaxLength": 25
    }, {
        "ColumnName": "Corporation.CountyCode",
        "MaxLength": 10
    }, {
        "ColumnName": "Corporation.Phone1.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Corporation.Phone1.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Corporation.Phone2.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Corporation.Phone2.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Corporation.Phone3.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Corporation.Phone3.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Corporation.Phone4.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Corporation.Phone4.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Corporation.CorpNotes",
        "MaxLength": 65535
    }, {
        "ColumnName": "Person.Prefix",
        "MaxLength": 25
    }, {
        "ColumnName": "Person.Sufix",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.AkaName",
        "MaxLength": 102
    }, {
        "ColumnName": "Person.FirstName",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.LastName",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.AkaFirstName",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.AkaLastName",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.SocialSecurityNumber",
        "MaxLength": 11
    }, {
        "ColumnName": "Person.Phone1.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Person.Phone1.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.Phone2.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Person.Phone2.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.Phone3.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Person.Phone3.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.Phone4.PhoneNumber",
        "MaxLength": 80,
        "RegExp": "^(([0-9]{3}-[0-9]{4})|((\\([0-9]{3}\\)[0-9]{3}-[0-9]{4})( x[0-9]{1,7})?))$"
    }, {
        "ColumnName": "Person.Phone4.PhoneType",
        "MaxLength": 50
    }, {
        "ColumnName": "Person.Address1.Line1",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.Address1.Line2",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.Address1.City",
        "MaxLength": 35
    }, {
        "ColumnName": "Person.Address1.State",
        "MaxLength": 3
    }, {
        "ColumnName": "Person.Address1.Zip",
        "MaxLength": 10
    }, {
        "ColumnName": "Person.Address1.Country",
        "MaxLength": 25
    }, {
        "ColumnName": "Person.Address1.CountyName",
        "MaxLength": 25
    }, {
        "ColumnName": "Person.Address1.CountyCode",
        "MaxLength": 10
    }, {
        "ColumnName": "Person.Address2.Line1",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.Address2.Line2",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.Address2.City",
        "MaxLength": 35
    }, {
        "ColumnName": "Person.Address2.State",
        "MaxLength": 3
    }, {
        "ColumnName": "Person.Address2.Zip",
        "MaxLength": 10
    }, {
        "ColumnName": "Person.Address2.Country",
        "MaxLength": 25
    }, {
        "ColumnName": "Person.Address2.CountyName",
        "MaxLength": 25
    }, {
        "ColumnName": "Person.Address2.CountyCode",
        "MaxLength": 10
    }, {
        "ColumnName": "Person.Email1",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.Email2",
        "MaxLength": 100
    }, {
        "ColumnName": "Person.Type",
        "MaxLength": 11
    }
]}
'
where id in ('ViewResponsibleParty')
GO
-- #132138 end