-- needed for #134561 _PatientReferralTracking_MIGRATION.sql
IF NOT EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '6CF840A5-ABC3-4DD3-A736-66688744BE8B')
BEGIN
	INSERT ListUserDefinedControlGroup (UserDefinedControlGroupUid, ExternalID, Name, Notes, Immunization, Inactive, UserDefined, RDLDesigner, LastModifiedByUid, LastModifiedDate)
	values ('6CF840A5-ABC3-4DD3-A736-66688744BE8B', null, 'Patient Referral Tracking Report', null, 0, 0, 0, 0, null, '2023-03-07 00:00:00.000')
END
GO



-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- disable these triggers before updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] DISABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] DISABLE TRIGGER [BlockReportUpdates]
GO
-- #60294 Keep this at the top

-- #123865 Patient Aging MIGRATION.sql
-- updated 3/22/23
UPDATE ListReport 
SET Name = 'Patient Aging'
	,Modifier = 5 
WHERE ReportUid = '6A544119-CA00-4D3A-AC39-098C700E8C0C' -- Patient Aging
GO
-- Modifiy Patient Aging Detail ReportDefinition 
UPDATE ListReportRdl 
SET ReportFormat = 'Detail'
WHERE ReportRdlUid = 'AD3134C0-1C2E-4BC2-95C6-ECBFF2907419' -- Patient Aging Detail
GO
-- Should already have been done in pre-migration
UPDATE ListReportRdl 
SET ReportFormat = 'Summary'
	,ReportUid = '6A544119-CA00-4D3A-AC39-098C700E8C0C' -- Patient Aging
WHERE ReportRdlUid = 'C32A9E49-6440-4AF0-B73D-6CD417CA62CE' -- Patient Aging Summary
GO

-- #124504 Update ListUserDefinedControl PatientbyDiagnosisOrMedication.sql
--20230330 zfernandez story 124504 Update gender label for report : Patients by Diagnosis or Medication
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '36880FF3-775E-4F45-A057-91A6ECA7C823')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlUid = '36880FF3-775E-4F45-A057-91A6ECA7C823'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'36880FF3-775E-4F45-A057-91A6ECA7C823'
	,'PatientGender'
	,NULL
	,NULL
	,0
	,'Include Patient Sex'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>PatientGender</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>and</Conjunction>
			<EntryNameInFindTable>Gender</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ListGender</FindTableName>
			<Required>FALSE</Required>
		</Control>
	</UserDefinedControls>'
	,'81D5D7B3-5E43-4762-B5C2-75664C547B7C'
	,12
	,0
	,0
	,NULL
	,'2023-03-30'
)
GO
-- #124504 end

-- #124512 _birthday list_MIGRATION.sql
UPDATE ListUserDefinedControl
Set Label='Sex'
where UserDefinedControlUid='880F3516-167E-4968-8920-94FF18ABD9EE';
GO

-- #104934 Update ListUserDefinedControl ClinicalDecisionSupportResponse.sql
--20230327 zfernandez story 104934 Clinical Decision Support Response Report - Enhancements
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = '7E491006-CCB4-4251-B492-62A48A2505CD')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = '7E491006-CCB4-4251-B492-62A48A2505CD'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'DBAA52BE-BCC0-4C43-8633-B9125FBEF40F'
	,'TF'
	,NULL
	,NULL
	,0
	,'Record Dates'
	,'DF87D0D5-BF48-49FB-ABBC-CB75CC29EB64'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>TIMESPAN</ControlType>
			<Name>TF</Name>
			<Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
		</Control>
	</UserDefinedControls>'
	,'7E491006-CCB4-4251-B492-62A48A2505CD'
	,0
	,0
	,0
	,NULL
	,'2023-03-27'
)

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'C27BA187-3304-42E6-92A9-58CD990D6629'
	,'Rule'
	,NULL
	,NULL
	,0
	,'Rules'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>RuleUid</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>and</Conjunction>
			<EntryNameInFindTable>Health Maintenance Rule</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ListHMRule</FindTableName>
		</Control>
	</UserDefinedControls>'
	,'7E491006-CCB4-4251-B492-62A48A2505CD'
	,1
	,0
	,0
	,NULL
	,'2023-03-27'
)

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'DBB10004-EFFA-4D67-B9C5-0FDD2261FA09'
	,'UserUID'
	,NULL
	,NULL
	,0
	,'Users'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>UserUid</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>none</Conjunction>
			<EntryNameInFindTable>User</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ViewFindUser</FindTableName>
		</Control>
	</UserDefinedControls>'
	,'7E491006-CCB4-4251-B492-62A48A2505CD'
	,2
	,0
	,0
	,NULL
	,'2023-03-27'
)
GO
-- #104934 end

-- #126443 _timespan update.sql
UPDATE listuserdefinedcontrol 
set ControlProperties='<UserDefinedControls>
  <Control>
    <ControlType>TIMESPAN</ControlType>
    <Name>FileDate</Name>
    <Uid>00000000-0000-0000-0000-000000000000</Uid>
    <Required>FALSE</Required>
  </Control>
</UserDefinedControls>'
where UserDefinedControlUid='B2872979-0884-4BFE-B05F-37AADDEBF50E'
GO

-- #127432 _controls update_MIGRATION.sql
UPDATE ListUserDefinedControl
Set ControlProperties='<UserDefinedControls>
  <Control>
    <ControlType>FIND</ControlType>
    <Name>OtherObservationItemUid</Name>
    <SelectType>Multi</SelectType>
    <Conjunction>and</Conjunction>
    <EntryNameInFindTable>Observation Item</EntryNameInFindTable>
    <ColumnName>Name</ColumnName>
    <ControlContextKey>Name</ControlContextKey>
    <FindTableName>FindVitalsObservation</FindTableName>
    <Required>FALSE</Required>
  </Control>
</UserDefinedControls>'
WHERE UserDefinedControlUid='E5036D20-838F-4811-85FD-7C3CDFAC60B3'; -- Other Observations

UPDATE ListUserDefinedControl
Set SortOrder=8
where UserDefinedControlUid='DB222B28-A1BD-43B4-ADF6-97758578FEBB'; -- A1C Observations

UPDATE ListUserDefinedControl
Set SortOrder=9
where UserDefinedControlUid='C6822360-603A-4D1A-9B57-26C52093CB2E'; -- LDL Observations

UPDATE ListUserDefinedControl
Set SortOrder=10
where UserDefinedControlUid='FA861D61-B5B6-49D1-A4E5-49F25377E26A'; -- Cholesterol Observations
GO

-- #124558 Update ListUserDefinedControl PatientExportList_Report.sql
--20230419 zfernandez story 124558 Update gender label for report : Patient Export List
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9D5A2E4E-CE4E-4455-911C-9B0739BEA12D')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlUid = '9D5A2E4E-CE4E-4455-911C-9B0739BEA12D'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'9D5A2E4E-CE4E-4455-911C-9B0739BEA12D'
	,'GenderUID'
	,NULL
	,NULL
	,0
	,'Patient Sexes'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>GenderUID</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>and</Conjunction>
			<EntryNameInFindTable>Gender</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ListGender</FindTableName>
			<Required>FALSE</Required>
		</Control>
	</UserDefinedControls>'
	,'C8B18698-1300-4AA4-B1F2-66E094689FEE'
	,8
	,0
	,0
	,NULL
	,'2023-04-19'
)
GO

-- #125170 Update ListUserDefinedControl PatientsbyHistoryAnswerGroup.sql
--20230420 zfernandez story 125170 Update gender label for report : Patients by History Answer Group
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2548CF01-F676-4E1D-A750-812C52856878')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlUid = '2548CF01-F676-4E1D-A750-812C52856878'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'2548CF01-F676-4E1D-A750-812C52856878'
	,'GenderUid'
	,NULL
	,NULL
	,0
	,'Sex'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>GenderUid</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>and</Conjunction>
			<EntryNameInFindTable>Gender</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ListGender</FindTableName>
		</Control>
	</UserDefinedControls>'
	,'938C2483-1C02-4ECE-8C9F-382AF4EC46B5'
	,1
	,0
	,0
	,NULL
	,'2023-04-20'
)
GO
-- #125170 end

-- #125169 Update ListUserDefinedControl PatientsandLabValues.sql
--20230420 zfernandez story 125169 Update gender label for report : Patients and Lab Values
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'B9F9CE50-FB8D-45B9-B4FF-CE48D5A9F45B')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'B9F9CE50-FB8D-45B9-B4FF-CE48D5A9F45B'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'B9F9CE50-FB8D-45B9-B4FF-CE48D5A9F45B'
	,'PatientGenderUid'
	,NULL
	,NULL
	,0
	,'Sex'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>PatientGenderUid</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>and</Conjunction>
			<EntryNameInFindTable>Gender</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ListGender</FindTableName>
		</Control>
	</UserDefinedControls>'
	,'22AE1967-E8E1-4F47-870D-241C2FE4F766'
	,1
	,0
	,0
	,NULL
	,'2023-04-20'
)
GO
-- #125169 end

-- #125168 Update ListUserDefinedControl PatientsandDrug.sql
--20230420 zfernandez story 125168 Update gender label for report : Patients and Drug
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '370BC768-BEBD-44BD-95FF-193516B84402')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlUid = '370BC768-BEBD-44BD-95FF-193516B84402'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'370BC768-BEBD-44BD-95FF-193516B84402'
	,'GenderUid'
	,NULL
	,NULL
	,0
	,'Sexes'
	,'8A957D7C-8B86-4A67-8336-B830C30FD123'
	,'<?xml version="1.0" encoding="utf-8"?>
	<UserDefinedControls>
		<Control>
			<ControlType>FIND</ControlType>
			<Name>GenderUid</Name>
			<SelectType>Multi</SelectType>
			<Conjunction>and</Conjunction>
			<EntryNameInFindTable>Gender</EntryNameInFindTable>
			<ColumnName>Name</ColumnName>
			<ControlContextKey>Name</ControlContextKey>
			<FindTableName>ListGender</FindTableName>
			<Required>FALSE</Required>
		</Control>
	</UserDefinedControls>'
	,'1ED77F37-1024-40D3-8E83-D22FE811DDD7'
	,8
	,0
	,0
	,NULL
	,'2023-04-20'
)
GO
-- #125168 end

-- #125165 _patients and bp MIGRATION.sql
update ListUserDefinedControl
set label = 'Sexes'
where UserDefinedControlUid='5121EF2C-B483-4216-A4E6-CED7CB04C322';
GO

-- #123869 Update ListUserDefinedControl ResponsiblePartyAging.sql
--20230501 zfernandez story 123869 report enhancement: combine Responsible Party aging detail and summary report, add excel format as well
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'F744E27D-91E4-47CA-8DA7-4E25B44603E8')
BEGIN
	DELETE FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'F744E27D-91E4-47CA-8DA7-4E25B44603E8'
END
GO

INSERT INTO ListUserDefinedControl
(
	UserDefinedControlUid
	,Name
	,ExternalID
	,Notes
	,Inactive
	,Label
	,ControlTypeUid
	,ControlProperties
	,UserDefinedControlGroupUid
	,SortOrder
	,UserDefined
	,RDLDesigner
	,LastModifiedByUid
	,LastModifiedDate
)
VALUES
(
	'F744E27D-91E4-47CA-8DA7-4E25B44603E8'
	,'ReportFormat'
	,NULL
	,NULL
	,0
	,'Report Format'
	,'8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
	,'<UserDefinedControls>
		<Controls>
			<Control>
				<ControlType>RADIOBUTTON</ControlType>
				<Name>ReportFormat</Name>
				<ButtonLabel>Detail</ButtonLabel>
				<ButtonValue>Detail</ButtonValue>
				<Default>true</Default>
			</Control>
			<Control>
				<ControlType>RADIOBUTTON</ControlType>
				<Name>ReportFormat</Name>
				<ButtonLabel>Summary</ButtonLabel>
				<ButtonValue>Summary</ButtonValue>
				<Default>false</Default>
			</Control>
			<Control>
				<ControlType>RADIOBUTTON</ControlType>
				<Name>ReportFormat</Name>
				<ButtonLabel>Excel</ButtonLabel>
				<ButtonValue>Excel</ButtonValue>
				<Default>false</Default>
			</Control>
		</Controls>
	</UserDefinedControls>'
	,'4213C1B9-A418-4DD7-879E-95FF8AC334F7'
	,19
	,0
	,0
	,NULL
	,'2023-05-03'
)
GO
-- #123869 end

-- #120374 _LabOrderStatus_MIGRATION.sql
IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '20a16a76-b583-4432-a354-e8cfc2f91e83')
BEGIN
DELETE FROM ListUserDefinedControl where UserDefinedControlGroupUid = '20a16a76-b583-4432-a354-e8cfc2f91e83';
END
GO

UPDATE ListUserDefinedControlGroup 
SET LastModifiedByUid=null
,LastModifiedDate='2023-05-26 00:00:00.000'
,UserDefined=0
where UserDefinedControlGroupUid = '20A16A76-B583-4432-A354-E8CFC2F91E83';


IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'c93f9d2f-1e6e-45b7-8faa-d1563382a904') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c93f9d2f-1e6e-45b7-8faa-d1563382a904','OrderDate',0,'Date','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>OrderDate</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid></Control></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',0,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '657a6374-b0ea-4024-8673-7c72d5bfeb02') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('657a6374-b0ea-4024-8673-7c72d5bfeb02','DateOption',0,'Date Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Order Date</ButtonLabel><ButtonValue>OrderDate</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Result Date</ButtonLabel><ButtonValue>ResultDate</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',1,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '90ded945-ae25-492a-a570-a0a9711764ff') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('90ded945-ae25-492a-a570-a0a9711764ff','ProviderUid',0,'Provider','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName></Control></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',2,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '0859cc74-2733-4275-abdc-9634426514a5') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('0859cc74-2733-4275-abdc-9634426514a5','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',3,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ffe2d82a-a409-4c4b-bee1-f492f337535f') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ffe2d82a-a409-4c4b-bee1-f492f337535f','ServiceSiteUid',0,'Service Site','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName></Control></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',4,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b9afccaf-4c69-4baa-9fca-360e3f618bb1') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b9afccaf-4c69-4baa-9fca-360e3f618bb1','Status',0,'Result Status','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>Status</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>ResultStatus</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ResultStatus</FindTableName></Control></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',5,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9227976a-cf07-46ac-be10-4669fdd6c1ea') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('9227976a-cf07-46ac-be10-4669fdd6c1ea','LaboratoryUid',0,'Laboratory','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>LaboratoryUid</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Laboratory</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListLaboratory</FindTableName></Control></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',6,0,0,'5/25/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'acad404e-bd6d-45d3-bf0c-6ed79eb2e798') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('acad404e-bd6d-45d3-bf0c-6ed79eb2e798','ProcedureUid',0,'Procedure','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName></Control></UserDefinedControls>','20a16a76-b583-4432-a354-e8cfc2f91e83',7,0,0,'5/25/2023 7:00:00 PM')
END
GO
-- #120374 end

-- #120382 _migration.sql
UPDATE listuserdefinedcontrol 
SET label='Visit Dates'
,LastModifiedDate='2023-05-30 00:00:00.000'
where userdefinedcontroluid='196BABC8-ADDF-405F-A50E-9A40311A8C18'

UPDATE listuserdefinedcontrol 
SET label='Providers'
,LastModifiedDate='2023-05-30 00:00:00.000'
where userdefinedcontroluid='316D1E39-884C-43EE-9289-09782ACFD1E8' 

UPDATE listuserdefinedcontrol 
SET label='Laboratories'
,LastModifiedDate='2023-05-30 00:00:00.000'
where userdefinedcontroluid='8FE84B92-6A0A-4742-8F7E-39C9856894F7' 

UPDATE listuserdefinedcontrol 
SET label='Statuses'
,LastModifiedDate='2023-05-30 00:00:00.000'
where userdefinedcontroluid='79F98669-9979-44A8-9444-CB3BF609DE32' ;
GO

-- #121015 Clinical Decision Support Summary MIGRATION.sql
--Clinical Decision Support Summary
--kculberth 121015 report enhancement: clinical decision support summary
--ListUserDefinedControl migration
UPDATE ListUserDefinedControl
SET SortOrder = 0
	,Label = 'Rules'
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023/06/26 00:00:00 AM'
WHERE UserDefinedControlUid = 'f8734023-2a2a-4b54-a775-789095cc99ee' --Rules

UPDATE ListUserDefinedControl
SET SortOrder = 1
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023/06/26 00:00:00 AM'
WHERE UserDefinedControlUid = 'c7a795f3-7c24-4568-add8-4d1417eb3113' --TYPE

UPDATE ListUserDefinedControl
SET SortOrder = 3
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023/06/26 00:00:00 AM'
WHERE UserDefinedControlUid = '5AF23E4D-4841-466B-BF8C-9F45637156DD' --Patient Statuses

UPDATE ListUserDefinedControl
SET SortOrder = 4
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023/06/26 00:00:00 AM'
WHERE UserDefinedControlUid = 'D5E4213B-58F8-4086-AD85-A8893E878AA8' --Patient Conditions

UPDATE ListUserDefinedControl
SET SortOrder = 6
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023/06/26 00:00:00 AM'
WHERE UserDefinedControlUid = '8FB97C3F-9F5B-4B83-ADEB-6BA370ACE760' --Sort By

UPDATE ListUserDefinedControl
SET SortOrder = 7
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023/06/26 00:00:00 AM'
WHERE UserDefinedControlUid = 'F9787C47-639A-4892-A50C-AFE64B7F7B48' --Report Format
GO
-- #121015 end

-- #134561 _PatientReferralTracking_MIGRATION.sql
--Relabling Date Parameter
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9e2ffab1-7a1b-4e95-9d80-e897034dd399')
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlUid = '9e2ffab1-7a1b-4e95-9d80-e897034dd399'
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9e2ffab1-7a1b-4e95-9d80-e897034dd399')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('9e2ffab1-7a1b-4e95-9d80-e897034dd399','PatientReferralTracking',0,'Referral Creation Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?>
  <UserDefinedControls>
   <Control>
    <ControlType>TIMESPAN</ControlType>
    <Name>PatientReferralTracking</Name>
    <Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
    <Required>TRUE</Required>
   </Control>
  </UserDefinedControls>','6cf840a5-abc3-4dd3-a736-66688744be8b',0,0,0,'7/4/2023 7:00:00 PM')
END
GO
--Updating the sortby logic
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '85ca0f46-4436-442f-a3ab-bde6e36d76e2')
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlUid = '85ca0f46-4436-442f-a3ab-bde6e36d76e2'
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '85ca0f46-4436-442f-a3ab-bde6e36d76e2')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('85ca0f46-4436-442f-a3ab-bde6e36d76e2','SortBy',0,'Sort By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>SortBy</Name><ButtonLabel>Patient</ButtonLabel><ButtonValue>Patient</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>SortBy</Name><ButtonLabel>Refer To Provider</ButtonLabel><ButtonValue>Refer To Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>SortBy</Name><ButtonLabel>Medical Services Provider</ButtonLabel><ButtonValue>Medical Services Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','6cf840a5-abc3-4dd3-a736-66688744be8b',5,0,0,'7/4/2023 7:00:00 PM')
END
GO
GO
-- #134561 end

-- #138537 _ProcedureProductivityIncludingPatientLiability_MIGRATION.sql
IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = 'FF460F4A-3B0F-4326-8D5D-B74079BC2C79')
BEGIN
DELETE FROM listuserdefinedcontrol 	where UserDefinedControlGroupUid='FF460F4A-3B0F-4326-8D5D-B74079BC2C79'
END
GO

----
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ff69b57c-ef11-4794-83b6-a7fa27e24db8') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ff69b57c-ef11-4794-83b6-a7fa27e24db8','PPIPLGL',0,'Charge Posting Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PPIPLGL</Name><Uid>00000000-0000-0000-0000-000000000000</Uid></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',0,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '7e18133c-ba1b-4e32-89be-bcf9d8afa729') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('7e18133c-ba1b-4e32-89be-bcf9d8afa729','PPIPL',0,'Charge Service Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PPIPL</Name><Uid>00000000-0000-0000-0000-000000000000</Uid></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',1,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '91e2d9c9-073c-4f8a-9dfb-f70a629c39f0') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('91e2d9c9-073c-4f8a-9dfb-f70a629c39f0','providerUids',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>providerUids</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',2,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ee47970a-10d8-49f5-b4f9-38bb8090c978') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ee47970a-10d8-49f5-b4f9-38bb8090c978','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',3,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ef38be3e-88c9-41f4-8c87-d7e5f166ccf1') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ef38be3e-88c9-41f4-8c87-d7e5f166ccf1','financialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>financialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',4,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b04744af-e661-4d3a-91a5-ad3a9aae072d') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b04744af-e661-4d3a-91a5-ad3a9aae072d','serviceSite',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>serviceSite</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',5,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ddd6f3dc-f222-48ca-ba7f-cae51b390622') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ddd6f3dc-f222-48ca-ba7f-cae51b390622','ProcedureGroupUid',0,'Procedure Groups','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>@ProcedureGroupUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedureGroup</FindTableName></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',6,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'f7423db6-b718-4fc1-bd39-523c4a33dae6') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('f7423db6-b718-4fc1-bd39-523c4a33dae6','CPTCodeRange',0,'CPT Code Range','23d953d7-7438-48d0-9fd1-c950130cb558','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>CPTCodeRange</Name><DefaultText></DefaultText><MaxLength>50</MaxLength><MultiLine>false</MultiLine></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',7,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'd79e4660-2870-435f-892f-b99f2d1410b0') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('d79e4660-2870-435f-892f-b99f2d1410b0','ShowSummary',0,'Summary','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>ShowSummary</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',8,0,0,'8/9/2023 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b811f0ad-bd6a-433c-b4bb-cfd3b4a3b068') -- 9
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b811f0ad-bd6a-433c-b4bb-cfd3b4a3b068','sortorder',0,'Sort by','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>sortorder</Name><ButtonLabel>Service Site</ButtonLabel><ButtonValue>S</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>sortorder</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>P</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>','ff460f4a-3b0f-4326-8d5d-b74079bc2c79',9,0,0,'8/9/2023 7:00:00 PM')
END
GO
-- #138537 end

-- #130089 Update Migration.sql
--20230818 zfernandez story 130089 New Report -Care Management Supporting Details
UPDATE ListUserDefinedControl
SET ControlProperties = '<UserDefinedControls>
			<Controls>
				<Control>
					<ControlType>RADIOBUTTON</ControlType>
					<Name>GroupBy</Name>
					<ButtonLabel>Patient</ButtonLabel>
					<ButtonValue>Patient</ButtonValue>
					<Default>true</Default>
				</Control>
				<Control>
					<ControlType>RADIOBUTTON</ControlType>
					<Name>GroupBy</Name>
					<ButtonLabel>Care Provider</ButtonLabel>
					<ButtonValue>CareProvider</ButtonValue>
					<Default>false</Default>
				</Control>
			</Controls>
		</UserDefinedControls>'
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023-08-18'
WHERE UserDefinedControlUid = '3ECE5B8B-E325-4B1D-9DFF-EFB00B42A6D7'

--20230818 zfernandez story 130089 New Report -Care Management Supporting Details
UPDATE ListUserDefinedControlGroup
SET Name = 'Care Management Supporting Details'
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023-08-18'
WHERE UserDefinedControlGroupUid = '33FC0353-7B77-497B-AF13-8C4B455F1B63'

-- added this section 20230825 lc
--20230824 zfernandez story 130089 New Report -Care Management Supporting Details
UPDATE ListUserDefinedControl
SET Label = 'Approval Status'
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023-08-24'
WHERE UserDefinedControlUid = 'FF5E965A-A8AA-41FD-944A-990112A3E813'
GO
-- #130089 end

-- #139278 Update ListUserDefinedControl Superbill.sql
--20230905 zfernandez bug 139278 Superbill Report does not respect date filter and is rendering ALL superbills in the system
UPDATE ListUserDefinedControl
SET Name = 'ServiceDate'
	,LastModifiedByUid = NULL
	,LastModifiedDate = '2023-09-05'
WHERE UserDefinedControlUid = '4CC5F5F0-F6D4-4927-BBA7-1C89BC04D4C0'
GO

-- #135907 _Migration for updates.sql
--135907_PRE Migration for delete.sql
DELETE FROM ListUserDefinedControl
WHERE UserDefinedControlUid='990F1C96-FCF9-40E9-8ECB-2136182307B3' --Include Account and Payer Information

UPDATE ListUserDefinedControl
Set SortOrder='10'
WHERE UserDefinedControlUid='7AD79D9A-BEF4-412C-89F9-94568D2C2D7C' -- Sort by

UPDATE ListUserDefinedControl
Set SortOrder='11'
WHERE UserDefinedControlUid='706B7D99-EA56-4B1E-B6A6-C54C2F85EAEE' -- From Time

UPDATE ListUserDefinedControl
Set SortOrder='12'
WHERE UserDefinedControlUid='CAB13F88-78AA-449D-A1D2-B2E78AB41F3C' -- From Time Option

UPDATE ListUserDefinedControl
Set SortOrder='13'
WHERE UserDefinedControlUid='9D2817D3-7A6A-4293-9C32-FA7DC3391AF1' -- To Time

UPDATE ListUserDefinedControl
Set SortOrder='14'
WHERE UserDefinedControlUid='AE8D9AEF-BACF-4AA5-BDA9-7B4BE886DD3C' -- To Time Option
GO
-- #135907 end

-- #147649 _ActiveWriteOffByStatementCount_MIGRATION.sql
UPDATE ListUserDefinedControl
SET Label='Minimum Number of Statements'
WHERE UserDefinedControlUid='157F7418-6D22-40CE-AD59-60616C61EA56'
GO

-- #134622 _ServiceDetail_MIGRATION.sql
IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '60d8f49b-e425-4287-90fd-56806be090ff')
BEGIN
DELETE FROM ListUserDefinedControl where UserDefinedControlGroupUid = '60d8f49b-e425-4287-90fd-56806be090ff'
END
GO

IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '60d8f49b-e425-4287-90fd-56806be090ff')
BEGIN
UPDATE ListUserDefinedControlGroup 
set LastModifiedByUid=null 
,LastModifiedDate='2023-12-01 00:00:00.000'
,UserDefined=0
where UserDefinedControlGroupUid='60D8F49B-E425-4287-90FD-56806BE090FF';
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'eaaf0afe-c0cc-4672-8144-1553710d9ebe') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('eaaf0afe-c0cc-4672-8144-1553710d9ebe','SDR',0,'Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>SDR</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',0,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '4c0c1443-a2da-46cb-af3f-1ec59d29dfce') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('4c0c1443-a2da-46cb-af3f-1ec59d29dfce','DateOption',0,'Date Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>Service Date</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting Date</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',1,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'c25ce369-9a22-47cc-a937-680cf84761c2') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c25ce369-9a22-47cc-a937-680cf84761c2','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ClaimingProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',2,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '06146170-1eb5-41b1-a248-3cbf3f96dfb2') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('06146170-1eb5-41b1-a248-3cbf3f96dfb2','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',3,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'bcbbcbb2-5e26-47eb-a28d-6a95fae9ff91') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('bcbbcbb2-5e26-47eb-a28d-6a95fae9ff91','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',4,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '988c71b2-5828-4f7d-b5cc-5cdecf7794a3') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('988c71b2-5828-4f7d-b5cc-5cdecf7794a3','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',5,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3f8e2291-0519-41d2-8537-d5c5d120f8bc') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('3f8e2291-0519-41d2-8537-d5c5d120f8bc','PatientUID',0,'Patients','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PatientUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindPatient</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',6,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'e295cece-05a9-4ecc-ad11-55cdc332ce49') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e295cece-05a9-4ecc-ad11-55cdc332ce49','Procedure',0,'Procedures','8a957d7c-8b86-4a67-8336-b830c30fd123','<UserDefinedControls><Control><ControlType>FIND</ControlType><Name>Procedure</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',7,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '24974c4d-7ae5-4fc8-bd3d-782236b7c83a') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('24974c4d-7ae5-4fc8-bd3d-782236b7c83a','CPTCodeRange',0,'Procedure Code Range','23d953d7-7438-48d0-9fd1-c950130cb558','<UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>CPTCodeRange</Name><DefaultText /><MaxLength /><MultiLine>false</MultiLine><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',8,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '1977a553-8eb0-49c5-a9af-c2cc293235a9') -- 9
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('1977a553-8eb0-49c5-a9af-c2cc293235a9','PInsuranceUID',0,'Primary Insurance Payers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PInsuraceUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Corporation</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewCorporation</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',9,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'c7609f26-7e9e-40d4-8347-9a983704c15b') -- 10
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c7609f26-7e9e-40d4-8347-9a983704c15b','CInsuranceUID',0,'Current Primary Insurance Payers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CInsuranceUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Corporation</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewCorporation</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',10,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '97f7bfdb-19e2-4420-9f26-fcd37d14dfa6') -- 11
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('97f7bfdb-19e2-4420-9f26-fcd37d14dfa6','Orderby',0,'Order by','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Orderby</Name><ButtonLabel>Patient Name</ButtonLabel><ButtonValue>Patient</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Orderby</Name><ButtonLabel>Primary Insurance Payer</ButtonLabel><ButtonValue>PInsurance</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Orderby</Name><ButtonLabel>Current Primary Insurance Payer</ButtonLabel><ButtonValue>CInsurance</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Orderby</Name><ButtonLabel>DOS Start Date</ButtonLabel><ButtonValue>Date</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',11,0,0,'12/1/2023 11:23:29 AM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b10913f9-3a03-4895-b0e2-ada405bac7c9') -- 12
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b10913f9-3a03-4895-b0e2-ada405bac7c9','ReportFormat',0,'Report Format','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Report</ButtonLabel><ButtonValue>Report</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Excel</ButtonLabel><ButtonValue>Excel</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','60d8f49b-e425-4287-90fd-56806be090ff',12,0,0,'12/1/2023 11:23:29 AM')
END
GO
-- #134622 end

-- #149167 _ServiceDetail_MIGRATION.sql
UPDATE ListUserDefinedControl
set Label='Current Insurance Payers'
where UserDefinedControlUid='C7609F26-7E9E-40D4-8347-9A983704C15B'

UPDATE ListUserDefinedControl
set ControlProperties='<UserDefinedControls>
  <Controls>
    <Control>
      <ControlType>RADIOBUTTON</ControlType>
      <Name>Orderby</Name>
      <ButtonLabel>Patient Name</ButtonLabel>
      <ButtonValue>Patient</ButtonValue>
      <Default>true</Default>
    </Control>
    <Control>
      <ControlType>RADIOBUTTON</ControlType>
      <Name>Orderby</Name>
      <ButtonLabel>Primary Insurance Payer</ButtonLabel>
      <ButtonValue>PInsurance</ButtonValue>
      <Default>false</Default>
    </Control>
    <Control>
      <ControlType>RADIOBUTTON</ControlType>
      <Name>Orderby</Name>
      <ButtonLabel>Current Insurance Payer</ButtonLabel>
      <ButtonValue>CInsurance</ButtonValue>
      <Default>false</Default>
    </Control>
    <Control>
      <ControlType>RADIOBUTTON</ControlType>
      <Name>Orderby</Name>
      <ButtonLabel>DOS Start Date</ButtonLabel>
      <ButtonValue>Date</ButtonValue>
      <Default>false</Default>
    </Control>
  </Controls>
</UserDefinedControls>'
where UserDefinedControlUid='97F7BFDB-19E2-4420-9F26-FCD37D14DFA6'
GO

-- #148292 _PatientsByAge_MIGRATION.sql
UPDATE ListUserDefinedControl
SET Label='Providers'
where UserDefinedControlUid='C349E277-EC3A-4028-8A38-D63BB3373322'; -- Visit Providers
GO

-- #159327 _Migration.sql
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'aa2c1f7c-dfe4-4fd8-be5c-3799918708cf')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('aa2c1f7c-dfe4-4fd8-be5c-3799918708cf','UserUid',0,'User / User Group','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>User</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>User and User Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindUserAndUserGroup</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','20397fc3-eabc-42f1-af4d-462b21166fb5',1,0,0,'4/4/2024 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '572d82ff-8d55-4366-b330-821a26857de8')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('572d82ff-8d55-4366-b330-821a26857de8','securityuid',0,'Security / Security Group','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>security</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Security Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListSecurityGroup</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','20397fc3-eabc-42f1-af4d-462b21166fb5',2,0,0,'4/4/2024 7:00:00 PM')
END
GO




--------------------------------------------------------------------------------
-- #60294 Keep this at the bottom
-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- enable these triggers after updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] ENABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] ENABLE TRIGGER [BlockReportUpdates]
GO
-- #60294 Keep this at the bottom