DECLARE @dbname SYSNAME,
		@sql NVARCHAR (MAX)
SET @dbname = db_name ()

-- Disable change tracking on table
DECLARE @tableName SYSNAME,
		@is_change_tracking_on BIT

DECLARE CTE_CSR CURSOR FAST_FORWARD LOCAL FOR
SELECT st.name,
	CASE WHEN EXISTS (	SELECT TOP 1 *
						FROM sys.change_tracking_tables
						WHERE object_id = st.object_id
				     ) THEN 1
		 ELSE 0
	END AS is_change_tracking_on
FROM sys.tables AS st
OPEN CTE_CSR
FETCH NEXT FROM CTE_CSR INTO @tableName, @is_change_tracking_on
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @is_change_tracking_on = 1
	BEGIN
		SET @sql =
			N'ALTER TABLE ' + QUOTENAME(@dbname) + N'..' + QUOTENAME(@tableName) + CHAR (10) +
			N'DISABLE CHANGE_TRACKING;'
		EXEC sp_executesql @sql
	END
	FETCH NEXT FROM CTE_CSR INTO @tableName, @is_change_tracking_on
END
CLOSE CTE_CSR
DEALLOCATE CTE_CSR


-- Disable change tracking for db
SET @sql = 
	--N'ALTER DATABASE ' + @dbname + CHAR (10) +
	--N'SET READ_COMMITTED_SNAPSHOT ON;' + CHAR (10) +
	N'IF EXISTS ( SELECT *' + CHAR (10) +
	N'			  FROM sys.change_tracking_databases AS ctdb' + CHAR (10) +
	N'					INNER JOIN sys.databases as db ON ctdb.database_id = db.database_id' + CHAR (10) +
	N'			  WHERE db.name = @pdbname' + CHAR (10) +
	N'			)' + CHAR (10) +
	N'BEGIN' + CHAR (10) +
	N'	ALTER DATABASE ' +  QUOTENAME(@dbname) + CHAR (10) +
	N'	SET CHANGE_TRACKING = OFF' + CHAR (10) +	
	N'END;' + CHAR (10) +
	N'IF EXISTS (	SELECT *' + CHAR (10) +
	N'				FROM sys.databases' + CHAR (10) +
	N'				WHERE name = @pdbname AND snapshot_isolation_state <> 0' + CHAR (10) +
	N'			)' + CHAR (10) +
	N'BEGIN' + CHAR (10) +
	N'ALTER DATABASE ' +  QUOTENAME(@dbname) + CHAR (10) +
	N'SET ALLOW_SNAPSHOT_ISOLATION OFF;' + CHAR (10) +
	N'END;'

EXEC sp_executesql @sql, N'@pdbname sysname',
	@pdbname = @dbname