IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'Existing_Active_Medications' AND ss.name = N'dbo')
CREATE TYPE [dbo].[Existing_Active_Medications] AS TABLE(
	[MedicationName] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[MEDID] [int] NULL,
	[GCN_SEQNO] [int] NULL,
	[ROUTED_MED_ID] [int] NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'ExistingAllergies' AND ss.name = N'dbo')
CREATE TYPE [dbo].[ExistingAllergies] AS TABLE(
	[DAM_CONCEPT_ID_TYP] [int] NULL,
	[DAM_CONCEPT_ID] [int] NULL,
	[AllergenName] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'ExistingAllergyHIC_SEQN' AND ss.name = N'dbo')
CREATE TYPE [dbo].[ExistingAllergyHIC_SEQN] AS TABLE(
	[HIC_SEQN] [int] NULL,
	[AllergenName] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[InactiveIngredient] [bit] NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'ExistingDisease' AND ss.name = N'dbo')
CREATE TYPE [dbo].[ExistingDisease] AS TABLE(
	[ICD_Code] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[DiseaseDesc] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ActReason' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ActReason] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[system] [varchar](500) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[code] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[display] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='POPHLTH' OR [code]='ERTREAT' OR [code]='BTG' OR [code]='ETREAT' OR [code]='COC' OR [code]='CLINTRL' OR [code]='TREAT' OR [code]='THREAT' OR [code]='DISASTER' OR [code]='PUBHLTH' OR [code]='SUPNWK' OR [code]='PWATRNY' OR [code]='FAMRQT' OR [code]='PATRQT' OR [code]='TRANSRCH' OR [code]='POARCH' OR [code]='DSRCH' OR [code]='PRECLINTRCH' OR [code]='CLINTRCHPC' OR [code]='CLINTRCHNPC' OR [code]='CLINTRCH' OR [code]='BIORCH' OR [code]='HRESCH' OR [code]='REMITADV' OR [code]='MILDCRG' OR [code]='ENROLLM' OR [code]='ELIGVER' OR [code]='ELIGDTRM' OR [code]='COVERAGE' OR [code]='COVAUTH' OR [code]='CLMATTCH' OR [code]='HPAYMT' OR [code]='TRAIN' OR [code]='HTEST' OR [code]='SYSDEV' OR [code]='RECORDMGT' OR [code]='PERFMSR' OR [code]='PATSFTY' OR [code]='PATADMIN' OR [code]='MILCDM' OR [code]='MEMADMIN' OR [code]='METAMGT' OR [code]='LABELING' OR [code]='HSYSADMIN' OR [code]='HQUALIMP' OR [code]='HPRGRP' OR [code]='HOUTCOMS' OR [code]='HLEGAL' OR [code]='HDM' OR [code]='HDIRECT' OR [code]='HDECD' OR [code]='HCOMPL' OR [code]='HACCRED' OR [code]='GOV' OR [code]='FRAUD' OR [code]='DONAT' OR [code]='CAREMGT' OR [code]='HOPERAT' OR [code]='HMARKT'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Address' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Address] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[fullAddress] [varchar](500) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[line1] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[line2] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[city] [varchar](35) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[state] [varchar](3) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[postalCode] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([state]='AA' OR [state]='AP' OR [state]='AE' OR [state]='WY' OR [state]='WI' OR [state]='WV' OR [state]='WA' OR [state]='VA' OR [state]='VI' OR [state]='VT' OR [state]='UT' OR [state]='TX' OR [state]='TN' OR [state]='SD' OR [state]='SC' OR [state]='RI' OR [state]='PR' OR [state]='PA' OR [state]='PW' OR [state]='OR' OR [state]='OK' OR [state]='OH' OR [state]='MP' OR [state]='ND' OR [state]='NC' OR [state]='NY' OR [state]='NM' OR [state]='NJ' OR [state]='NH' OR [state]='NV' OR [state]='NE' OR [state]='MT' OR [state]='MO' OR [state]='MS' OR [state]='MN' OR [state]='MI' OR [state]='MA' OR [state]='MD' OR [state]='MH' OR [state]='ME' OR [state]='LA' OR [state]='KY' OR [state]='KS' OR [state]='IA' OR [state]='IN' OR [state]='IL' OR [state]='ID' OR [state]='HI' OR [state]='GU' OR [state]='GA' OR [state]='FL' OR [state]='FM' OR [state]='DC' OR [state]='DE' OR [state]='CT' OR [state]='CO' OR [state]='CA' OR [state]='AR' OR [state]='AZ' OR [state]='AS' OR [state]='AK' OR [state]='AL'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_AllergyIntoleranceReaction' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_AllergyIntoleranceReaction] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[manifestationSystem] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[manifestationCode] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[manifestationDisplay] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[description] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[onset] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[severity] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[exposureRoute] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([exposureRoute]='461657851000087101' OR [exposureRoute]='180677251000087104' OR [exposureRoute]='1611000175109' OR [exposureRoute]='718329006' OR [exposureRoute]='714743009' OR [exposureRoute]='711378007' OR [exposureRoute]='711360002' OR [exposureRoute]='697971008' OR [exposureRoute]='448598008' OR [exposureRoute]='448492006' OR [exposureRoute]='448491004' OR [exposureRoute]='448077001' OR [exposureRoute]='447964005' OR [exposureRoute]='447694001' OR [exposureRoute]='447229005' OR [exposureRoute]='447227007' OR [exposureRoute]='447122006' OR [exposureRoute]='447121004' OR [exposureRoute]='447081004' OR [exposureRoute]='447080003' OR [exposureRoute]='447052000' OR [exposureRoute]='447026006' OR [exposureRoute]='446540005' OR [exposureRoute]='446442000' OR [exposureRoute]='446435000' OR [exposureRoute]='446407004' OR [exposureRoute]='446105004' OR [exposureRoute]='445941009' OR [exposureRoute]='445913005' OR [exposureRoute]='445771006' OR [exposureRoute]='445769006' OR [exposureRoute]='445768003' OR [exposureRoute]='445767008' OR [exposureRoute]='445756007' OR [exposureRoute]='445755006' OR [exposureRoute]='445754005' OR [exposureRoute]='445752009' OR [exposureRoute]='429817007' OR [exposureRoute]='428191002' OR [exposureRoute]='420719007' OR [exposureRoute]='420287000' OR [exposureRoute]='420254004' OR [exposureRoute]='420218003' OR [exposureRoute]='420204005' OR [exposureRoute]='420201002' OR [exposureRoute]='420185003' OR [exposureRoute]='420168000' OR [exposureRoute]='420163009' OR [exposureRoute]='420047004' OR [exposureRoute]='419993007' OR [exposureRoute]='419954003' OR [exposureRoute]='419894000' OR [exposureRoute]='419874009' OR [exposureRoute]='419810008' OR [exposureRoute]='419778001' OR [exposureRoute]='419762003' OR [exposureRoute]='419684008' OR [exposureRoute]='419631009' OR [exposureRoute]='419601003' OR [exposureRoute]='419396008' OR [exposureRoute]='419320008' OR [exposureRoute]='419243002' OR [exposureRoute]='419231003' OR [exposureRoute]='419165009' OR [exposureRoute]='419021003' OR [exposureRoute]='418987007' OR [exposureRoute]='418947002' OR [exposureRoute]='418892005' OR [exposureRoute]='418887008' OR [exposureRoute]='418877009' OR [exposureRoute]='418851001' OR [exposureRoute]='418821007' OR [exposureRoute]='418813001' OR [exposureRoute]='418743005' OR [exposureRoute]='418730005' OR [exposureRoute]='418722009' OR [exposureRoute]='418664002' OR [exposureRoute]='418608002' OR [exposureRoute]='418586008' OR [exposureRoute]='418511008' OR [exposureRoute]='418441008' OR [exposureRoute]='418418000' OR [exposureRoute]='418401004' OR [exposureRoute]='418331006' OR [exposureRoute]='418321004' OR [exposureRoute]='418287000' OR [exposureRoute]='418204005' OR [exposureRoute]='418162004' OR [exposureRoute]='418136008' OR [exposureRoute]='418133000' OR [exposureRoute]='418114005' OR [exposureRoute]='418091004' OR [exposureRoute]='417989007' OR [exposureRoute]='417985001' OR [exposureRoute]='417950001' OR [exposureRoute]='417255000' OR [exposureRoute]='417070009' OR [exposureRoute]='416174007' OR [exposureRoute]='404820008' OR [exposureRoute]='404819002' OR [exposureRoute]='404818005' OR [exposureRoute]='404815008' OR [exposureRoute]='372476004' OR [exposureRoute]='372475000' OR [exposureRoute]='372474001' OR [exposureRoute]='372473007' OR [exposureRoute]='372471009' OR [exposureRoute]='372470005' OR [exposureRoute]='372469009' OR [exposureRoute]='372468001' OR [exposureRoute]='372467006' OR [exposureRoute]='372466002' OR [exposureRoute]='372465003' OR [exposureRoute]='372464004' OR [exposureRoute]='372463005' OR [exposureRoute]='372461007' OR [exposureRoute]='372460008' OR [exposureRoute]='372459003' OR [exposureRoute]='372458006' OR [exposureRoute]='372457001' OR [exposureRoute]='372454008' OR [exposureRoute]='372453002' OR [exposureRoute]='372452007' OR [exposureRoute]='372451000' OR [exposureRoute]='372450004' OR [exposureRoute]='372449004' OR [exposureRoute]='127492001' OR [exposureRoute]='127491008' OR [exposureRoute]='127490009' OR [exposureRoute]='90028008' OR [exposureRoute]='78421000' OR [exposureRoute]='72607000' OR [exposureRoute]='62226000' OR [exposureRoute]='60213007' OR [exposureRoute]='58100008' OR [exposureRoute]='54485002' OR [exposureRoute]='54471007' OR [exposureRoute]='47625008' OR [exposureRoute]='46713006' OR [exposureRoute]='45890007' OR [exposureRoute]='38239002' OR [exposureRoute]='37839007' OR [exposureRoute]='37737002' OR [exposureRoute]='37161004' OR [exposureRoute]='34206005' OR [exposureRoute]='26643006' OR [exposureRoute]='16857009' OR [exposureRoute]='12130007' OR [exposureRoute]='10547007' OR [exposureRoute]='6064005')),
	CHECK (([severity]='severe' OR [severity]='moderate' OR [severity]='mild'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_AllergyIntoleranceResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_AllergyIntoleranceResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[clinicalStatus] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[verificationStatus] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[type] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[category] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[criticality] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[onsetType] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[onsetValue] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[recordedDate] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[lastOccurrence] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([category]='biologic' OR [category]='environment' OR [category]='medication' OR [category]='food')),
	CHECK (([clinicalStatus]=' resolved' OR [clinicalStatus]='inactive' OR [clinicalStatus]='active')),
	CHECK (([criticality]='unable-to-assess' OR [criticality]='high' OR [criticality]='low')),
	CHECK (([verificationStatus]='entered-in-error' OR [verificationStatus]='refuted' OR [verificationStatus]='confirmed' OR [verificationStatus]='unconfirmed')),
	CHECK (([type]='intolerance' OR [type]='allergy'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Annotation' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Annotation] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[time] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[text] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_BinaryResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_BinaryResource] AS TABLE(
	[id] [uniqueidentifier] NULL,
	[contentType] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[data] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_CarePlanActivity' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_CarePlanActivity] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[kind] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[code] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[codeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReason] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReasonDisplay] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[doNotPerform] [bit] NULL,
	[location] [uniqueidentifier] NULL,
	[scheduledStart] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[scheduledEnd] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[scheduledString] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[dailyAmount] [int] NULL,
	[quantity] [int] NULL,
	[description] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([status]='entered-in-error' OR [status]='unknown' OR [status]='stopped' OR [status]='cancelled' OR [status]='completed' OR [status]='on-hold' OR [status]='in-progress' OR [status]='scheduled' OR [status]='not-started')),
	CHECK (([kind]='VisionPrescription' OR [kind]='ServiceRequest' OR [kind]='Task' OR [kind]='NutritionOrder' OR [kind]='MedicationRequest' OR [kind]='DeviceRequest' OR [kind]='CommunicationRequest	' OR [kind]='Appointment'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_CarePlanResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_CarePlanResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[intent] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[title] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[description] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[createdDate] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([intent]='option' OR [intent]='order' OR [intent]='plan' OR [intent]='proposal')),
	CHECK (([status]='entered-in-error' OR [status]='inactive' OR [status]='suspended' OR [status]='active' OR [status]='proposed'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_CareTeamContained' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_CareTeamContained] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[resourceType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[id] [uniqueidentifier] NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_CareTeamParticipant' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_CareTeamParticipant] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[roleCode] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[roleDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[roleSystem] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([roleCode]='' OR [roleCode]='_UnderwriterParticipationFunction' OR [roleCode]='_SponsorParticipationFunction' OR [roleCode]='_PayorParticipationFunction' OR [roleCode]='_OverriderParticipationFunction' OR [roleCode]='_CoverageParticipationFunction' OR [roleCode]='_ConsenterParticipationFunction' OR [roleCode]='_AuthorizedReceiverParticipationFunction' OR [roleCode]='_AuthorizedParticipationFunction' OR [roleCode]='UNDERWRTNG' OR [roleCode]='UMGT' OR [roleCode]='TASST' OR [roleCode]='SUBCTRT' OR [roleCode]='SUBCON' OR [roleCode]='SNRS' OR [roleCode]='SELFINRD' OR [roleCode]='SASST' OR [roleCode]='RNDPHYS' OR [roleCode]='REVIEWER' OR [roleCode]='RETROCES' OR [roleCode]='REINS' OR [roleCode]='PROVMGT' OR [roleCode]='PROMSK' OR [roleCode]='PRISURG' OR [roleCode]='PRCON' OR [roleCode]='POACON' OR [roleCode]='PCP' OR [roleCode]='PAYORCNTR' OR [roleCode]='NASST' OR [roleCode]='MDWF' OR [roleCode]='MCMGT' OR [roleCode]='GRDCON' OR [roleCode]='FULINRD' OR [roleCode]='FFSMGT' OR [roleCode]='FASST' OR [roleCode]='ENROLL' OR [roleCode]='DISPHYS' OR [roleCode]='COMPOSER' OR [roleCode]='CLMADJ' OR [roleCode]='AUWA' OR [roleCode]='AUTM' OR [roleCode]='AULR' OR [roleCode]='AUEMROV' OR [roleCode]='AUCOV' OR [roleCode]='AUCG' OR [roleCode]='ATTPHYS' OR [roleCode]='ASSEMBLER' OR [roleCode]='ANRS' OR [roleCode]='ANEST' OR [roleCode]='ADMPHYS' OR [roleCode]='9371000175105' OR [roleCode]='90655003' OR [roleCode]='90201008' OR [roleCode]='897187007' OR [roleCode]='88189002' OR [roleCode]='878787005' OR [roleCode]='878786001' OR [roleCode]='878785002' OR [roleCode]='8724009' OR [roleCode]='85733003' OR [roleCode]='840584008' OR [roleCode]='840583002' OR [roleCode]='83685006' OR [roleCode]='83273008' OR [roleCode]='82296001' OR [roleCode]='81464008' OR [roleCode]='80933006' OR [roleCode]='80584001' OR [roleCode]='80546007' OR [roleCode]='80409005' OR [roleCode]='79918004' OR [roleCode]='79898004' OR [roleCode]='789543004' OR [roleCode]='78729002' OR [roleCode]='78703002' OR [roleCode]='769038007' OR [roleCode]='76899008' OR [roleCode]='768839008' OR [roleCode]='768837005' OR [roleCode]='768836001' OR [roleCode]='768834003' OR [roleCode]='768833009' OR [roleCode]='768832004' OR [roleCode]='768829002' OR [roleCode]='768828005' OR [roleCode]='768827000' OR [roleCode]='768826009' OR [roleCode]='768825008' OR [roleCode]='768822006' OR [roleCode]='768821004' OR [roleCode]='768820003' OR [roleCode]='768819009' OR [roleCode]='768818001' OR [roleCode]='768817006' OR [roleCode]='768816002' OR [roleCode]='768815003' OR [roleCode]='768734005' OR [roleCode]='768733004' OR [roleCode]='768732009' OR [roleCode]='768731002' OR [roleCode]='768730001' OR [roleCode]='763292005' OR [roleCode]='76231001' OR [roleCode]='76166008' OR [roleCode]='75271001' OR [roleCode]='734294007' OR [roleCode]='734293001' OR [roleCode]='73265009' OR [roleCode]='721943002' OR [roleCode]='721942007' OR [roleCode]='721941000' OR [roleCode]='721940004' OR [roleCode]='721939001' OR [roleCode]='721938009' OR [roleCode]='721937004' OR [roleCode]='721936008' OR [roleCode]='720503005' OR [roleCode]='71838004' OR [roleCode]='69280009' OR [roleCode]='68950000' OR [roleCode]='68867008' OR [roleCode]='6868009' OR [roleCode]='6816002' OR [roleCode]='66862007' OR [roleCode]='66476003' OR [roleCode]='65803006' OR [roleCode]='64220005' OR [roleCode]='63098009' OR [roleCode]='62247001' OR [roleCode]='61894003' OR [roleCode]='61345009' OR [roleCode]='61246008' OR [roleCode]='61207006' OR [roleCode]='60008001' OR [roleCode]='59944000' OR [roleCode]='59317003' OR [roleCode]='59169001' OR [roleCode]='59058001' OR [roleCode]='57654006' OR [roleCode]='56545009' OR [roleCode]='56542007' OR [roleCode]='56466003' OR [roleCode]='56397003' OR [roleCode]='54503009' OR [roleCode]='53564008' OR [roleCode]='5275007' OR [roleCode]='5191000124109' OR [roleCode]='50149000' OR [roleCode]='49993003' OR [roleCode]='49203003' OR [roleCode]='48740002' OR [roleCode]='48639005' OR [roleCode]='471302004' OR [roleCode]='46255001' OR [roleCode]='45956004' OR [roleCode]='457151000124109' OR [roleCode]='457141000124107' OR [roleCode]='45544007' OR [roleCode]='45440000' OR [roleCode]='453231000124104' OR [roleCode]='453121000124107' OR [roleCode]='453111000124104' OR [roleCode]='453101000124102' OR [roleCode]='453091000124108' OR [roleCode]='453081000124105' OR [roleCode]='453071000124107' OR [roleCode]='453061000124100' OR [roleCode]='450044741000087104' OR [roleCode]='449161006' OR [roleCode]='446701002' OR [roleCode]='44652006' OR [roleCode]='446050000' OR [roleCode]='445531000124104' OR [roleCode]='445521000124102' OR [roleCode]='445451001' OR [roleCode]='445313000' OR [roleCode]='444912007' OR [roleCode]='443090005' OR [roleCode]='442867008' OR [roleCode]='442251000124100' OR [roleCode]='440051000124108' OR [roleCode]='43702002' OR [roleCode]='432100008' OR [roleCode]='429577009' OR [roleCode]='428024001' OR [roleCode]='422234006' OR [roleCode]='422140007' OR [roleCode]='421841007' OR [roleCode]='420678001' OR [roleCode]='420409002' OR [roleCode]='420158005' OR [roleCode]='41904004' OR [roleCode]='416800000' OR [roleCode]='41672002' OR [roleCode]='4162009' OR [roleCode]='416160000' OR [roleCode]='416035002' OR [roleCode]='416034003' OR [roleCode]='415506007' OR [roleCode]='415075003' OR [roleCode]='413854007' OR [roleCode]='409975003' OR [roleCode]='409974004' OR [roleCode]='408799001' OR [roleCode]='408798009' OR [roleCode]='407543004' OR [roleCode]='407542009' OR [roleCode]='40570005' OR [roleCode]='405685006' OR [roleCode]='405684005' OR [roleCode]='405623001' OR [roleCode]='405279007' OR [roleCode]='405278004' OR [roleCode]='405277009' OR [roleCode]='404940000' OR [roleCode]='40204001' OR [roleCode]='40127002' OR [roleCode]='398238009' OR [roleCode]='398130009' OR [roleCode]='3981000175106' OR [roleCode]='397908005' OR [roleCode]='397903001' OR [roleCode]='397897005' OR [roleCode]='39677007' OR [roleCode]='394618009' OR [roleCode]='394572006' OR [roleCode]='387619007' OR [roleCode]='3842006' OR [roleCode]='37504001' OR [roleCode]='373864002' OR [roleCode]='372102007' OR [roleCode]='37154003' OR [roleCode]='36682004' OR [roleCode]='3430008' OR [roleCode]='312485001' OR [roleCode]='311441001' OR [roleCode]='310512001' OR [roleCode]='310194009' OR [roleCode]='310193003' OR [roleCode]='310192008' OR [roleCode]='310191001' OR [roleCode]='310190000' OR [roleCode]='310189009' OR [roleCode]='310188001' OR [roleCode]='310187006' OR [roleCode]='310186002' OR [roleCode]='310185003' OR [roleCode]='310184004' OR [roleCode]='310182000' OR [roleCode]='310181007' OR [roleCode]='310180008' OR [roleCode]='310179005' OR [roleCode]='310178002' OR [roleCode]='310177007' OR [roleCode]='310176003' OR [roleCode]='310175004' OR [roleCode]='310174000' OR [roleCode]='310173006' OR [roleCode]='310172001' OR [roleCode]='310171008' OR [roleCode]='310170009' OR [roleCode]='309460000' OR [roleCode]='309459005' OR [roleCode]='309457007' OR [roleCode]='309455004' OR [roleCode]='309454000' OR [roleCode]='309453006' OR [roleCode]='309452001' OR [roleCode]='309450009' OR [roleCode]='309446002' OR [roleCode]='309445003' OR [roleCode]='309444004' OR [roleCode]='309443005' OR [roleCode]='309442000' OR [roleCode]='309441007' OR [roleCode]='309440008' OR [roleCode]='309439006' OR [roleCode]='309437008' OR [roleCode]='309436004' OR [roleCode]='309435000' OR [roleCode]='309434001' OR [roleCode]='309429000' OR [roleCode]='309428008' OR [roleCode]='309427003' OR [roleCode]='309423004' OR [roleCode]='309422009' OR [roleCode]='309421002' OR [roleCode]='309420001' OR [roleCode]='309419007' OR [roleCode]='309418004' OR [roleCode]='309417009' OR [roleCode]='309416000' OR [roleCode]='309415001' OR [roleCode]='309414002' OR [roleCode]='309413008' OR [roleCode]='309412003' OR [roleCode]='309411005' OR [roleCode]='309410006' OR [roleCode]='309409001' OR [roleCode]='309404006' OR [roleCode]='309403000' OR [roleCode]='309402005' OR [roleCode]='309401003' OR [roleCode]='309400002' OR [roleCode]='309399009' OR [roleCode]='309398001' OR [roleCode]='309397006' OR [roleCode]='309396002' OR [roleCode]='309395003' OR [roleCode]='309394004' OR [roleCode]='309393005' OR [roleCode]='309392000' OR [roleCode]='309391007' OR [roleCode]='309390008' OR [roleCode]='309389004' OR [roleCode]='309388007' OR [roleCode]='309386006' OR [roleCode]='309385005' OR [roleCode]='309384009' OR [roleCode]='309383003' OR [roleCode]='309382008' OR [roleCode]='309381001' OR [roleCode]='309380000' OR [roleCode]='309379003' OR [roleCode]='309378006' OR [roleCode]='309377001' OR [roleCode]='309376005' OR [roleCode]='309375009' OR [roleCode]='309374008' OR [roleCode]='309373002' OR [roleCode]='309372007' OR [roleCode]='309371000' OR [roleCode]='309369000' OR [roleCode]='309368008' OR [roleCode]='309367003' OR [roleCode]='309366007' OR [roleCode]='309364005' OR [roleCode]='309363004' OR [roleCode]='309362009' OR [roleCode]='309361002' OR [roleCode]='309360001' OR [roleCode]='309359006' OR [roleCode]='309358003' OR [roleCode]='309357008' OR [roleCode]='309356004' OR [roleCode]='309355000' OR [roleCode]='309354001' OR [roleCode]='309353007' OR [roleCode]='309352002' OR [roleCode]='309351009' OR [roleCode]='309350005' OR [roleCode]='309349005' OR [roleCode]='309348002' OR [roleCode]='309347007' OR [roleCode]='309346003' OR [roleCode]='309345004' OR [roleCode]='309343006' OR [roleCode]='309342001' OR [roleCode]='309341008' OR [roleCode]='309340009' OR [roleCode]='309339007' OR [roleCode]='309338004' OR [roleCode]='309337009' OR [roleCode]='309336000' OR [roleCode]='309335001' OR [roleCode]='309334002' OR [roleCode]='309333008' OR [roleCode]='309332003' OR [roleCode]='309331005' OR [roleCode]='309330006' OR [roleCode]='309329001' OR [roleCode]='309328009' OR [roleCode]='309327004' OR [roleCode]='309326008' OR [roleCode]='309324006' OR [roleCode]='309323000' OR [roleCode]='309322005' OR [roleCode]='309296004' OR [roleCode]='309295000' OR [roleCode]='309294001' OR [roleCode]='308002005' OR [roleCode]='307988006' OR [roleCode]='304292004' OR [roleCode]='304291006' OR [roleCode]='303134001' OR [roleCode]='303133007' OR [roleCode]='303129000' OR [roleCode]='303124005' OR [roleCode]='302211009' OR [roleCode]='28544002' OR [roleCode]='28411006' OR [roleCode]='283875005' OR [roleCode]='28229004' OR [roleCode]='265939002' OR [roleCode]='265937000' OR [roleCode]='26369006' OR [roleCode]='26091000087104' OR [roleCode]='26071000087103' OR [roleCode]='26042002' OR [roleCode]='26031000087100' OR [roleCode]='25961008' OR [roleCode]='25941000087102' OR [roleCode]='24590004' OR [roleCode]='24430003' OR [roleCode]='23278007' OR [roleCode]='22983004' OR [roleCode]='22731001' OR [roleCode]='225727002' OR [roleCode]='225726006' OR [roleCode]='225725005' OR [roleCode]='22515006' OR [roleCode]='224936003' OR [roleCode]='224626008' OR [roleCode]='224625007' OR [roleCode]='224624006' OR [roleCode]='224623000' OR [roleCode]='224622005' OR [roleCode]='224621003' OR [roleCode]='224620002' OR [roleCode]='224615002' OR [roleCode]='224614003' OR [roleCode]='224610007' OR [roleCode]='224609002' OR [roleCode]='224608005' OR [roleCode]='224607000' OR [roleCode]='224606009' OR [roleCode]='224605008' OR [roleCode]='224604007' OR [roleCode]='224603001' OR [roleCode]='224602006' OR [roleCode]='224601004' OR [roleCode]='224600003' OR [roleCode]='224599001' OR [roleCode]='224598009' OR [roleCode]='224597004' OR [roleCode]='224596008' OR [roleCode]='224595007' OR [roleCode]='224594006' OR [roleCode]='224593000' OR [roleCode]='224592005' OR [roleCode]='224591003' OR [roleCode]='224590002' OR [roleCode]='224589006' OR [roleCode]='224588003' OR [roleCode]='224587008' OR [roleCode]='224586004' OR [roleCode]='224585000' OR [roleCode]='224584001' OR [roleCode]='224583007' OR [roleCode]='224581009' OR [roleCode]='224580005' OR [roleCode]='224579007' OR [roleCode]='224578004' OR [roleCode]='224577009' OR [roleCode]='224576000' OR [roleCode]='224575001' OR [roleCode]='224574002' OR [roleCode]='224573008' OR [roleCode]='224572003' OR [roleCode]='224571005' OR [roleCode]='224570006' OR [roleCode]='224569005' OR [roleCode]='224567007' OR [roleCode]='224566003' OR [roleCode]='224565004' OR [roleCode]='224564000' OR [roleCode]='224563006' OR [roleCode]='224562001' OR [roleCode]='224560009' OR [roleCode]='224559004' OR [roleCode]='224558007' OR [roleCode]='224557002' OR [roleCode]='224556006' OR [roleCode]='224555005' OR [roleCode]='224554009' OR [roleCode]='224552008' OR [roleCode]='224551001' OR [roleCode]='224550000' OR [roleCode]='224549000' OR [roleCode]='224548008' OR [roleCode]='224547003' OR [roleCode]='224546007' OR [roleCode]='224545006' OR [roleCode]='224544005' OR [roleCode]='224543004' OR [roleCode]='224542009' OR [roleCode]='224541002' OR [roleCode]='224540001' OR [roleCode]='224538006' OR [roleCode]='224537001' OR [roleCode]='224536005' OR [roleCode]='224535009' OR [roleCode]='224534008' OR [roleCode]='224533002' OR [roleCode]='224532007' OR [roleCode]='224531000' OR [roleCode]='224530004' OR [roleCode]='224529009' OR [roleCode]='21450003' OR [roleCode]='21365001' OR [roleCode]='20145008' OR [roleCode]='19244007' OR [roleCode]='18850004' OR [roleCode]='18803008' OR [roleCode]='17561000' OR [roleCode]='160008000' OR [roleCode]='159972006' OR [roleCode]='159174008' OR [roleCode]='159148002' OR [roleCode]='159141008' OR [roleCode]='159041005' OR [roleCode]='159040006' OR [roleCode]='159039009' OR [roleCode]='159038001' OR [roleCode]='159037006' OR [roleCode]='159036002' OR [roleCode]='159035003' OR [roleCode]='159034004' OR [roleCode]='159033005' OR [roleCode]='159028006' OR [roleCode]='159027001' OR [roleCode]='159026005' OR [roleCode]='159025009' OR [roleCode]='159022007' OR [roleCode]='159021000' OR [roleCode]='159019005' OR [roleCode]='159018002' OR [roleCode]='159017007' OR [roleCode]='159016003' OR [roleCode]='159014000' OR [roleCode]='159012001' OR [roleCode]='159011008' OR [roleCode]='159010009' OR [roleCode]='159007002' OR [roleCode]='159006006' OR [roleCode]='159005005' OR [roleCode]='159004009' OR [roleCode]='159003003' OR [roleCode]='159002008' OR [roleCode]='159001001' OR [roleCode]='158999002' OR [roleCode]='158998005' OR [roleCode]='158997000' OR [roleCode]='158996009' OR [roleCode]='158995008' OR [roleCode]='158994007' OR [roleCode]='158993001' OR [roleCode]='158992006' OR [roleCode]='158990003' OR [roleCode]='158989007' OR [roleCode]='158988004' OR [roleCode]='158987009' OR [roleCode]='158986000' OR [roleCode]='158985001' OR [roleCode]='158984002' OR [roleCode]='158983008' OR [roleCode]='158980006' OR [roleCode]='158979008' OR [roleCode]='158978000' OR [roleCode]='158977005' OR [roleCode]='158975002' OR [roleCode]='158974003' OR [roleCode]='158973009' OR [roleCode]='158972004' OR [roleCode]='158971006' OR [roleCode]='158969006' OR [roleCode]='158968003' OR [roleCode]='158967008' OR [roleCode]='158966004' OR [roleCode]='158965000' OR [roleCode]='14698002' OR [roleCode]='14613005' OR [roleCode]='1421009' OR [roleCode]='13580004' OR [roleCode]='133932002' OR [roleCode]='1271000175101' OR [roleCode]='11935004' OR [roleCode]='119246008' OR [roleCode]='11911009' OR [roleCode]='1186914001' OR [roleCode]='1186716007' OR [roleCode]='1172950003' OR [roleCode]='11661002' OR [roleCode]='116154003' OR [roleCode]='11015003' OR [roleCode]='106330007' OR [roleCode]='106311007' OR [roleCode]='106310008' OR [roleCode]='106296000' OR [roleCode]='106294002' OR [roleCode]='106293008' OR [roleCode]='106292003' OR [roleCode]='106291005' OR [roleCode]='106289002'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_CareTeamResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_CareTeamResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[name] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([status]='entered-in-error' OR [status]='inactive' OR [status]='suspended' OR [status]='active' OR [status]='proposed'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Coding' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Coding] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[codeSet] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[code] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[codeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([codeSet]='NDC' OR [codeSet]='RxNorm' OR [codeSet]='GMDN' OR [codeSet]='CVX' OR [codeSet]='CPT' OR [codeSet]='HCPCS' OR [codeSet]='ICD9' OR [codeSet]='ICD10' OR [codeSet]='LOINC' OR [codeSet]='SnomedCT'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ConditionResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ConditionResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[clinicalStatus] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[verificationStatus] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[category] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[severity] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[onsetDateTime] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[abatementDateTime] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[recordedDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([category]='16100001' OR [category]='health-concern' OR [category]='encounter-diagnosis' OR [category]='problem-list-item')),
	CHECK (([clinicalStatus]='resolved' OR [clinicalStatus]='remission' OR [clinicalStatus]='inactive' OR [clinicalStatus]='relapse' OR [clinicalStatus]='recurrence' OR [clinicalStatus]='active')),
	CHECK (([severity]='255604002' OR [severity]='6736007' OR [severity]='24484000')),
	CHECK (([verificationStatus]='entered-in-error' OR [verificationStatus]='refuted' OR [verificationStatus]='confirmed' OR [verificationStatus]='differential' OR [verificationStatus]='provisional' OR [verificationStatus]='unconfirmed'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Contact' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Contact] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[fullName] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[family] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[given] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[middle] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[prefix] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[suffix] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[relationship] [varchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([relationship]='U ' OR [relationship]='S' OR [relationship]='N' OR [relationship]='I' OR [relationship]='F' OR [relationship]='E' OR [relationship]='C'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DeviceName' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DeviceName] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[name] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[type] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([type]='other' OR [type]='model-name' OR [type]='manufacturer-name' OR [type]='patient-reported-name' OR [type]='user-friendly-name' OR [type]='udi-label-name'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DeviceResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DeviceResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[udiCarrierDeviceIdentifier] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[udiCarrierIssuer] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[udiCarrierJurisdiction] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[udiCarrierAIDC] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[udiCarrierHRF] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[udiCarrierEntryType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[distinctIdentifier] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[manufacturer] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[manufactureDate] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[expirationDate] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[lotNumber] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[serialNumber] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[modelNumber] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[partNumber] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[url] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([status]='unknown' OR [status]='entered-in-error' OR [status]='inactive' OR [status]='active')),
	CHECK (([udiCarrierEntryType]='unknown' OR [udiCarrierEntryType]='self-reported' OR [udiCarrierEntryType]='card' OR [udiCarrierEntryType]='manual' OR [udiCarrierEntryType]='rfid' OR [udiCarrierEntryType]='barcode'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DeviceStatusReason' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DeviceStatusReason] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[code] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[codeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='off' OR [code]='hw-discon' OR [code]='transduc-discon' OR [code]='not-ready' OR [code]='offline' OR [code]='standby' OR [code]='paused' OR [code]='online'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DiagnosticReportCategory' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DiagnosticReportCategory] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[categoryCode] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[categoryCodeDisplay] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([categoryCode]='XRC' OR [categoryCode]='VUS' OR [categoryCode]='VR' OR [categoryCode]='TX' OR [categoryCode]='SR' OR [categoryCode]='SP' OR [categoryCode]='RX' OR [categoryCode]='RUS' OR [categoryCode]='RT' OR [categoryCode]='RC' OR [categoryCode]='RAD' OR [categoryCode]='PT' OR [categoryCode]='PHY' OR [categoryCode]='PHR' OR [categoryCode]='PF' OR [categoryCode]='OUS' OR [categoryCode]='OTH' OR [categoryCode]='OT' OR [categoryCode]='OSL' OR [categoryCode]='NRS' OR [categoryCode]='NMS' OR [categoryCode]='NMR' OR [categoryCode]='MYC' OR [categoryCode]='MCB' OR [categoryCode]='MB' OR [categoryCode]='LAB' OR [categoryCode]='IMM' OR [categoryCode]='ICU' OR [categoryCode]='HM' OR [categoryCode]='GE' OR [categoryCode]='EN' OR [categoryCode]='EC' OR [categoryCode]='CUS' OR [categoryCode]='CTH' OR [categoryCode]='CT' OR [categoryCode]='CP' OR [categoryCode]='CH' OR [categoryCode]='CG' OR [categoryCode]='BLB' OR [categoryCode]='BG' OR [categoryCode]='AU' OR [categoryCode]='LP2839-6' OR [categoryCode]='LP29708-2' OR [categoryCode]='LP29684-5'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DiagnosticReportPresentedForm' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DiagnosticReportPresentedForm] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[contentType] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[language] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[data] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[url] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[size] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[hash] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[title] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[creationDate] [datetimeoffset](7) NULL,
	CHECK (([language]='zh-TW' OR [language]='zh-SG' OR [language]='zh-HK' OR [language]='zh-CN' OR [language]='zh' OR [language]='te' OR [language]='sv-SE' OR [language]='sv' OR [language]='sr-RS' OR [language]='sr' OR [language]='ru-RU' OR [language]='ru' OR [language]='pt-BR' OR [language]='pt' OR [language]='pl' OR [language]='pa' OR [language]='no-NO' OR [language]='no' OR [language]='nl-NL' OR [language]='nl-BE' OR [language]='nl' OR [language]='ko' OR [language]='ja' OR [language]='it-IT' OR [language]='it-CH' OR [language]='it' OR [language]='hr' OR [language]='hi' OR [language]='fy-NL' OR [language]='fy' OR [language]='fr-FR' OR [language]='fr-CH' OR [language]='fr-BE' OR [language]='fr' OR [language]='fi' OR [language]='es-UY' OR [language]='es-ES' OR [language]='es-AR' OR [language]='es' OR [language]='en-US' OR [language]='en-SG' OR [language]='en-NZ' OR [language]='en-IN' OR [language]='en-GB' OR [language]='en-CA' OR [language]='en-AU' OR [language]='en' OR [language]='el' OR [language]='de-DE' OR [language]='de-CH' OR [language]='de-AT' OR [language]='de' OR [language]='da' OR [language]='cs' OR [language]='bn' OR [language]='ar'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DiagnosticReportResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DiagnosticReportResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[resourceSubType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[effectiveDateTime] [varchar](30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[issuedDateTime] [datetimeoffset](7) NULL,
	[conclusion] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([status]='unknown' OR [status]='entered-in-error' OR [status]='cancelled' OR [status]='appended' OR [status]='corrected' OR [status]='amended' OR [status]='final' OR [status]='preliminary' OR [status]='partial' OR [status]='registered'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DocumentReferenceContent' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DocumentReferenceContent] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[contentType] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[language] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[data] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[url] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[size] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[hash] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[title] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[creation] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[format] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([format]='urn:hl7-org:sdwg:ccda-nonXMLBody:2.1' OR [format]='urn:hl7-org:sdwg:ccda-structuredBody:2.1' OR [format]='urn:hl7-org:sdwg:ccda-nonXMLBody:1.1' OR [format]='urn:hl7-org:sdwg:ccda-structuredBody:1.1' OR [format]='urn:ihe:pharm:pml:2013' OR [format]='urn:ihe:pharm:dis:2010' OR [format]='urn:ihe:pharm:padv:2010' OR [format]='urn:ihe:pharm:pre:2010' OR [format]='urn:ihe:pat:apsr:cancer:larynx:2010' OR [format]='urn:ihe:pat:apsr:cancer:salivary_gland:2010' OR [format]='urn:ihe:pat:apsr:cancer:pharynx:2010' OR [format]='urn:ihe:pat:apsr:cancer:lip_oral_cavity:2010' OR [format]='urn:ihe:pat:apsr:cancer:urinary_bladder:2010' OR [format]='urn:ihe:pat:apsr:cancer:testis:2010' OR [format]='urn:ihe:pat:apsr:cancer:pancreas:2010' OR [format]='urn:ihe:pat:apsr:cancer:liver:2010' OR [format]='urn:ihe:pat:apsr:cancer:stomach:2010' OR [format]='urn:ihe:pat:apsr:cancer:esophagus:2010' OR [format]='urn:ihe:pat:apsr:cancer:ovary:2010' OR [format]='urn:ihe:pat:apsr:cancer:endometrium:2010' OR [format]='urn:ihe:pat:apsr:cancer:cervix:2010' OR [format]='urn:ihe:pat:apsr:cancer:kidney:2010' OR [format]='urn:ihe:pat:apsr:cancer:skin:2010' OR [format]='urn:ihe:pat:apsr:cancer:lung:2010' OR [format]='urn:ihe:pat:apsr:cancer:thyroid:2010' OR [format]='urn:ihe:pat:apsr:cancer:prostate:2010' OR [format]='urn:ihe:pat:apsr:cancer:colon:2010' OR [format]='urn:ihe:pat:apsr:cancer:breast:2010' OR [format]='urn:ihe:pat:apsr:cancer:all:2010' OR [format]='urn:ihe:pat:apsr:all:2010' OR [format]='urn:ihe:dent:CDA:ImagingReportStructuredHeadings:2013' OR [format]='urn:ihe:dent:PDF' OR [format]='urn:ihe:dent:TEXT' OR [format]='urn:ihe:card:EPRC-IE:2014' OR [format]='urn:ihe:card:CRC:2012' OR [format]='urn:ihe:card:imaging:2011' OR [format]='urn:ihe:rad:CDA:ImagingReportStructuredHeadings:2013' OR [format]='urn:ihe:rad:PDF' OR [format]='urn:ihe:rad:TEXT' OR [format]='urn:ihe:lab:xd-lab:2008' OR [format]='urn:ihe:iti:xds:2017:mimeTypeSufficient' OR [format]='urn:ihe:iti:appc:2016:consent' OR [format]='urn:ihe:iti:dsg:enveloping:2014' OR [format]='urn:ihe:iti:dsg:detached:2014' OR [format]='urn:ihe:iti:xdw:2011:workflowDoc' OR [format]='urn:ihe:iti:xds-sd:text:2008' OR [format]='urn:ihe:iti:xds-sd:pdf:2008' OR [format]='urn:ihe:iti:bppc-sd:2007' OR [format]='urn:ihe:iti:bppc:2007' OR [format]='urn:ihe:pcc:ript:2017' OR [format]='urn:ihe:pcc:its:2011' OR [format]='urn:ihe:pcc:ets:2011' OR [format]='urn:ihe:pcc:trs:2011' OR [format]='urn:ihe:pcc:ppvs:2010' OR [format]='urn:ihe:pcc:nds:2010' OR [format]='urn:ihe:pcc:mds:2009' OR [format]='urn:ihe:pcc:lds:2009' OR [format]='urn:ihe:pcc:ldhp:2009' OR [format]='urn:ihe:pcc:hp:2008' OR [format]='urn:ihe:pcc:edpn:2007' OR [format]='urn:ihe:pcc:ctn:2007' OR [format]='urn:ihe:pcc:nn:2007' OR [format]='urn:ihe:pcc:tn:2007' OR [format]='urn:ihe:pcc:ic:2008' OR [format]='urn:ihe:pcc:cm:2008' OR [format]='urn:ihe:pcc:crc:2008' OR [format]='urn:ihe:pcc:apr:edu:2008' OR [format]='urn:ihe:pcc:apr:lab:2008' OR [format]='urn:ihe:pcc:apr:handp:2008' OR [format]='urn:ihe:pcc:edes:2007' OR [format]='urn:ihe:pcc:edr:2007' OR [format]='urn:ihe:pcc:xds-ms:2007' OR [format]='urn:ihe:pcc:aps:2007' OR [format]='urn:ihe:pcc:xphr:2007')),
	CHECK (([language]='zh-TW' OR [language]='zh-SG' OR [language]='zh-HK' OR [language]='zh-CN' OR [language]='zh' OR [language]='te' OR [language]='sv-SE' OR [language]='sv' OR [language]='sr-RS' OR [language]='sr' OR [language]='ru-RU' OR [language]='ru' OR [language]='pt-BR' OR [language]='pt' OR [language]='pl' OR [language]='pa' OR [language]='no-NO' OR [language]='no' OR [language]='nl-NL' OR [language]='nl-BE' OR [language]='nl' OR [language]='ko' OR [language]='ja' OR [language]='it-IT' OR [language]='it-CH' OR [language]='it' OR [language]='hr' OR [language]='hi' OR [language]='fy-NL' OR [language]='fy' OR [language]='fr-FR' OR [language]='fr-CH' OR [language]='fr-BE' OR [language]='fr' OR [language]='fi' OR [language]='es-UY' OR [language]='es-ES' OR [language]='es-AR' OR [language]='es' OR [language]='en-US' OR [language]='en-SG' OR [language]='en-NZ' OR [language]='en-IN' OR [language]='en-GB' OR [language]='en-CA' OR [language]='en-AU' OR [language]='en' OR [language]='el' OR [language]='de-DE' OR [language]='de-CH' OR [language]='de-AT' OR [language]='de' OR [language]='da' OR [language]='cs' OR [language]='bn' OR [language]='ar'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_DocumentResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_DocumentResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[docStatus] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[type] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[date] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[description] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[eventCode] [varchar](150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[eventDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[facilityType] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[practiceSettingCode] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[practiceSettingDisplay] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([docStatus]='entered-in-error' OR [docStatus]='amended' OR [docStatus]='final' OR [docStatus]='preliminary')),
	CHECK (([eventCode]='PRA' OR [eventCode]='DOSEIND' OR [eventCode]='DEDUCT' OR [eventCode]='COPAY' OR [eventCode]='_HL7DefinedActCodes' OR [eventCode]='_ActBillableServiceCode' OR [eventCode]='_ActProcedureCode' OR [eventCode]='WRKCOMP' OR [eventCode]='SUBSIDFFS' OR [eventCode]='TRSTMECOBS' OR [eventCode]='TRSTLOAOBS' OR [eventCode]='TRSTFWKOBS' OR [eventCode]='TRSTCERTOBS' OR [eventCode]='TRSTAGREOBS' OR [eventCode]='TRSTACCRDOBS' OR [eventCode]='SECTRSTOBS' OR [eventCode]='SECINTSTOBS' OR [eventCode]='SECINTPRVRBOBS' OR [eventCode]='SECINTPRVABOBS' OR [eventCode]='SECINTPRVOBS' OR [eventCode]='SECINTCONOBS' OR [eventCode]='SECDATINTOBS' OR [eventCode]='SECALTINTOBS' OR [eventCode]='SECINTOBS' OR [eventCode]='SECCONOBS' OR [eventCode]='SECCLASSOBS' OR [eventCode]='SECCATOBS' OR [eventCode]='SECOBS' OR [eventCode]='PRLMN' OR [eventCode]='F' OR [eventCode]='DRUGPRG' OR [eventCode]='VLI' OR [eventCode]='T' OR [eventCode]='SUPPLEMENT' OR [eventCode]='SCH' OR [eventCode]='RD' OR [eventCode]='PAR' OR [eventCode]='PAF' OR [eventCode]='NF' OR [eventCode]='N' OR [eventCode]='LS' OR [eventCode]='LQ' OR [eventCode]='LP' OR [eventCode]='LF' OR [eventCode]='GF' OR [eventCode]='FORMULA' OR [eventCode]='FAST' OR [eventCode]='DM' OR [eventCode]='BR' OR [eventCode]='DIET' OR [eventCode]='C' OR [eventCode]='POLY' OR [eventCode]='POINT' OR [eventCode]='ELLIPSE' OR [eventCode]='CIRCLE' OR [eventCode]='_ROIOverlayShape' OR [eventCode]='FDASIZE' OR [eventCode]='FDASHAPE' OR [eventCode]='FDASCORING' OR [eventCode]='FDALOGO' OR [eventCode]='FDAIMPRINTCD' OR [eventCode]='FDACOLOR' OR [eventCode]='FDACOATING' OR [eventCode]='_FDALabelData' OR [eventCode]='SEV' OR [eventCode]='NAINT' OR [eventCode]='FNAINT' OR [eventCode]='FINT' OR [eventCode]='ENAINT' OR [eventCode]='EINT' OR [eventCode]='DNAINT' OR [eventCode]='DINT' OR [eventCode]='FALG' OR [eventCode]='EALG' OR [eventCode]='DALG' OR [eventCode]='ALG' OR [eventCode]='OINT' OR [eventCode]='KSUBT' OR [eventCode]='KSUBJ' OR [eventCode]='PATPREFALT' OR [eventCode]='PATPREF' OR [eventCode]='HISTORIC' OR [eventCode]='TOOSOON' OR [eventCode]='TOOLATE' OR [eventCode]='HELD' OR [eventCode]='MINFREQ' OR [eventCode]='INTERVAL' OR [eventCode]='TIMING' OR [eventCode]='NOTEQUIVTHER' OR [eventCode]='NOTEQUIVGEN' OR [eventCode]='NOTEQUIV' OR [eventCode]='NOTACTN' OR [eventCode]='FULFIL' OR [eventCode]='ALLDONE' OR [eventCode]='_SupplyDetectedIssueCode' OR [eventCode]='STRTLATE' OR [eventCode]='ENDLATE' OR [eventCode]='_TimingDetectedIssueCode' OR [eventCode]='ALRTSTRTLATE' OR [eventCode]='ALRTENDLATE' OR [eventCode]='TIME' OR [eventCode]='DACT' OR [eventCode]='PREVINEF' OR [eventCode]='NONRX' OR [eventCode]='NHP' OR [eventCode]='DRG' OR [eventCode]='TPROD' OR [eventCode]='FOOD' OR [eventCode]='_InteractionDetectedIssueCode' OR [eventCode]='_AppropriatenessDetectedIssueCode' OR [eventCode]='_AdministrationDetectedIssueCode' OR [eventCode]='_ActSuppliedItemDetectedIssueCode' OR [eventCode]='OBSOLETE' OR [eventCode]='KEY206' OR [eventCode]='_ActAdministrativeRuleDetectedIssueCode' OR [eventCode]='MINOCCURS' OR [eventCode]='MAXOCCURS' OR [eventCode]='REP_RANGE' OR [eventCode]='NOPERSIST' OR [eventCode]='NODUPS' OR [eventCode]='MISSMAND' OR [eventCode]='MISSCOND' OR [eventCode]='LEN_SHORT' OR [eventCode]='LEN_LONG' OR [eventCode]='LEN_RANGE' OR [eventCode]='ILLEGAL' OR [eventCode]='FORMAT' OR [eventCode]='CODE_DEPREC' OR [eventCode]='CODE_INVAL' OR [eventCode]='BUS' OR [eventCode]='RINT' OR [eventCode]='RAR' OR [eventCode]='RALG' OR [eventCode]='RREACT' OR [eventCode]='INT' OR [eventCode]='ALGY' OR [eventCode]='REACT' OR [eventCode]='LAB' OR [eventCode]='GEND' OR [eventCode]='GEN' OR [eventCode]='CREACT' OR [eventCode]='WGHT' OR [eventCode]='PREG' OR [eventCode]='LACT' OR [eventCode]='HGHT' OR [eventCode]='COND' OR [eventCode]='PEALRT' OR [eventCode]='GEALRT' OR [eventCode]='ADALRT' OR [eventCode]='AGE' OR [eventCode]='OBSA' OR [eventCode]='MDOSE' OR [eventCode]='DOSELINDW' OR [eventCode]='DOSELINDSA' OR [eventCode]='DOSELIND' OR [eventCode]='DOSELINDA' OR [eventCode]='DOSEL' OR [eventCode]='DOSEIVLIND' OR [eventCode]='DOSEIVL' OR [eventCode]='DOSEHINDW' OR [eventCode]='DOSEHINDSA' OR [eventCode]='DOSEHIND' OR [eventCode]='DOSEHINDA' OR [eventCode]='DOSEH' OR [eventCode]='DOSEDURLIND' OR [eventCode]='DOSEDURL' OR [eventCode]='DOSEDURHIND' OR [eventCode]='DOSEDURH' OR [eventCode]='DOSEDUR' OR [eventCode]='DOSECOND' OR [eventCode]='DOSE' OR [eventCode]='PLYPHRM' OR [eventCode]='PLYDOC' OR [eventCode]='FRAUD' OR [eventCode]='ABUSE' OR [eventCode]='DUPTHPGEN' OR [eventCode]='DUPTHPCLS' OR [eventCode]='DUPTHPY' OR [eventCode]='COMPLY' OR [eventCode]='KEY205' OR [eventCode]='KEY204' OR [eventCode]='VALIDAT' OR [eventCode]='SUPPRESSED' OR [eventCode]='NAT' OR [eventCode]='_ActAdministrativeAuthorizationDetectedIssueCode' OR [eventCode]='_ActAdministrativeDetectedIssueCode' OR [eventCode]='ISSUE' OR [eventCode]='HHOBS' OR [eventCode]='GISTIER' OR [eventCode]='NOI' OR [eventCode]='INTDX' OR [eventCode]='DISDX' OR [eventCode]='ADMDX' OR [eventCode]='DX' OR [eventCode]='CTMO' OR [eventCode]='CRIT' OR [eventCode]='CDIO' OR [eventCode]='CASESER' OR [eventCode]='ASSERTION' OR [eventCode]='ADVERSE_REACTION' OR [eventCode]='PREFSTRENGTH' OR [eventCode]='_PreferenceObservationType' OR [eventCode]='NUMEX' OR [eventCode]='NUMER' OR [eventCode]='MSRPOPLEX' OR [eventCode]='MSRPOPL' OR [eventCode]='MSROBS' OR [eventCode]='IPPOP' OR [eventCode]='IPOP' OR [eventCode]='DENOM' OR [eventCode]='DENEXCEP' OR [eventCode]='DENEX' OR [eventCode]='_PopulationInclusionObservationType' OR [eventCode]='TEACHER' OR [eventCode]='SCHLDIV' OR [eventCode]='SCHL' OR [eventCode]='GRADE' OR [eventCode]='CLSSRM' OR [eventCode]='_PatientImmunizationRelatedObservationType' OR [eventCode]='RHYTHM' OR [eventCode]='REPRESENTATIVE_BEAT' OR [eventCode]='_ECGObservationSeriesType' OR [eventCode]='_ObservationSeriesType' OR [eventCode]='TIME_RELATIVE' OR [eventCode]='TIME_ABSOLUTE' OR [eventCode]='_ObservationSequenceType' OR [eventCode]='USE' OR [eventCode]='TRANF' OR [eventCode]='STRAT' OR [eventCode]='SDE' OR [eventCode]='REF' OR [eventCode]='RAT' OR [eventCode]='MSRTYPE' OR [eventCode]='MSRTP' OR [eventCode]='MSRTOPIC' OR [eventCode]='MSRSET' OR [eventCode]='MSRSCORE' OR [eventCode]='MSRRPTTIME' OR [eventCode]='MSRRPTR' OR [eventCode]='MSRJUR' OR [eventCode]='MSRIMPROV' OR [eventCode]='MSRAGG' OR [eventCode]='MSRADJ' OR [eventCode]='MSD' OR [eventCode]='MEDT' OR [eventCode]='KEY' OR [eventCode]='ITMCNT' OR [eventCode]='IDUR' OR [eventCode]='GUIDE' OR [eventCode]='FINALDT' OR [eventCode]='DISC' OR [eventCode]='DEF' OR [eventCode]='CRS' OR [eventCode]='COPY' OR [eventCode]='CMPMSRSCRWGHT' OR [eventCode]='CMPMSRMTH' OR [eventCode]='AGGREGATE' OR [eventCode]='_ObservationQualityMeasureAttribute' OR [eventCode]='WATTRNS' OR [eventCode]='VECTRNS' OR [eventCode]='TRNSFTRNS' OR [eventCode]='SEXTRNS' OR [eventCode]='PLACTRNS' OR [eventCode]='PARTRNS' OR [eventCode]='NOSTRNS' OR [eventCode]='LACTTRNS' OR [eventCode]='INDTRNS' OR [eventCode]='HUMHUMTRNS' OR [eventCode]='FOODTRNS' OR [eventCode]='FOMTRNS' OR [eventCode]='FECTRNS' OR [eventCode]='ENVTRNS' OR [eventCode]='DERMTRNS' OR [eventCode]='BLDTRNS' OR [eventCode]='BDYFLDTRNS' OR [eventCode]='ANHUMTRNS' OR [eventCode]='ANANTRNS' OR [eventCode]='AIRTRNS' OR [eventCode]='_CaseTransmissionMode' OR [eventCode]='_ObservationIssueTriggerCodedObservationType' OR [eventCode]='SPLSYMBOL' OR [eventCode]='SPLSIZE' OR [eventCode]='SPLSHAPE' OR [eventCode]='SPLSCORING' OR [eventCode]='SPLIMPRINT' OR [eventCode]='SPLIMAGE' OR [eventCode]='SPLCOLOR' OR [eventCode]='SPLCOATING' OR [eventCode]='REP_HALF_LIFE' OR [eventCode]='_MedicationObservationType' OR [eventCode]='30972-4' OR [eventCode]='30525-0' OR [eventCode]='29553-5' OR [eventCode]='21612-7' OR [eventCode]='21611-9' OR [eventCode]='_LOINCObservationActContextAgeType' OR [eventCode]='VAC_PROBLEM' OR [eventCode]='PAT_ADV_EVNT' OR [eventCode]='_IndividualCaseSafetyReportType' OR [eventCode]='OBSANTV' OR [eventCode]='OBSANTC' OR [eventCode]='_ImmunizationObservationType' OR [eventCode]='GENE' OR [eventCode]='_GeneticObservationType' OR [eventCode]='ANNMED' OR [eventCode]='ANNLAB' OR [eventCode]='ANNIMM' OR [eventCode]='ANNGEN' OR [eventCode]='ANNDI' OR [eventCode]='_ActPatientAnnotationType' OR [eventCode]='_AnnotationType' OR [eventCode]='INITIAL' OR [eventCode]='CURRENT' OR [eventCode]='CONSUMPTION' OR [eventCode]='AVAILABLE' OR [eventCode]='VOLUME' OR [eventCode]='LIPEMIA' OR [eventCode]='ICTERUS' OR [eventCode]='HEMOLYSIS' OR [eventCode]='FIBRIN' OR [eventCode]='INTFR' OR [eventCode]='EVNFCTS' OR [eventCode]='RERUN' OR [eventCode]='PRE' OR [eventCode]='AUTO-LOW' OR [eventCode]='AUTO-HIGH' OR [eventCode]='DILUTION' OR [eventCode]='ARTBLD' OR [eventCode]='_ActSpecObsCode' OR [eventCode]='_ObservationType' OR [eventCode]='PUBTRN' OR [eventCode]='PRVTRN' OR [eventCode]='LAWENF' OR [eventCode]='AMBHELO' OR [eventCode]='AMBGRND' OR [eventCode]='AMBAIR' OR [eventCode]='AMBT' OR [eventCode]='AFOOT' OR [eventCode]='_ActPatientTransportationModeCode' OR [eventCode]='_ActTransportationModeCode' OR [eventCode]='FALLRISK' OR [eventCode]='RISKASSESS' OR [eventCode]='WELLREMLE' OR [eventCode]='REMLE' OR [eventCode]='RADREPREV' OR [eventCode]='PROBLISTREV' OR [eventCode]='PATREPREV' OR [eventCode]='OREV' OR [eventCode]='MARWLREV' OR [eventCode]='MLREV' OR [eventCode]='MICROSENSRREV' OR [eventCode]='MICROORGRREV' OR [eventCode]='MICRORREV' OR [eventCode]='LABRREV' OR [eventCode]='IMMLE' OR [eventCode]='DIAGLISTREV' OR [eventCode]='DISCHSUMREV' OR [eventCode]='CLINNOTEREV' OR [eventCode]='CDSREV' OR [eventCode]='ALLERLE' OR [eventCode]='PATINFO' OR [eventCode]='WELLREMLREV' OR [eventCode]='REMLREV' OR [eventCode]='IMMLREV' OR [eventCode]='RADREPE' OR [eventCode]='PROBLISTE' OR [eventCode]='PATREPE' OR [eventCode]='PATEDUE' OR [eventCode]='DISCHSUME' OR [eventCode]='DISCHINSTE' OR [eventCode]='DIAGLISTE' OR [eventCode]='CLINNOTEE' OR [eventCode]='ALLERLREV' OR [eventCode]='PATDOC' OR [eventCode]='MEDOE' OR [eventCode]='LABOE' OR [eventCode]='OE' OR [eventCode]='_ActTaskCode' OR [eventCode]='INITIMMUNIZ' OR [eventCode]='BOOSTER' OR [eventCode]='IMMUNIZ' OR [eventCode]='FD' OR [eventCode]='DRUG' OR [eventCode]='_ActSubstanceAdministrationCode' OR [eventCode]='UFIL' OR [eventCode]='RECA' OR [eventCode]='NEUT' OR [eventCode]='LDLP' OR [eventCode]='FILT' OR [eventCode]='DEFB' OR [eventCode]='ALK' OR [eventCode]='ACID' OR [eventCode]='_ActSpecimenTreatmentCode' OR [eventCode]='STRAN' OR [eventCode]='SSTOR' OR [eventCode]='SREC' OR [eventCode]='_ActSpecimenTransportCode' OR [eventCode]='SALE' OR [eventCode]='TRANSFER' OR [eventCode]='RENT' OR [eventCode]='LOAN' OR [eventCode]='_ActProductAcquisitionCode' OR [eventCode]='ORC' OR [eventCode]='NOVIP' OR [eventCode]='NOREUSE' OR [eventCode]='NORELINK' OR [eventCode]='NORDSCLW' OR [eventCode]='NORDSCLCDS' OR [eventCode]='NORDSCLCD' OR [eventCode]='NOPERSISTP' OR [eventCode]='NOPAT' OR [eventCode]='NOORGPOL' OR [eventCode]='NOMOU' OR [eventCode]='NOLIST' OR [eventCode]='NOINTEGRATE' OR [eventCode]='NODSCLCDS' OR [eventCode]='NODSCLCD' OR [eventCode]='NOCOLLECT' OR [eventCode]='NOAUTH' OR [eventCode]='RefrainPolicy' OR [eventCode]='UPGRDLABEL' OR [eventCode]='REDACT' OR [eventCode]='PSEUD' OR [eventCode]='PRIVMARK' OR [eventCode]='PERSISTLABEL' OR [eventCode]='MINEC' OR [eventCode]='MASK' OR [eventCode]='LABEL' OR [eventCode]='HUAPRV' OR [eventCode]='ENCRYPTU' OR [eventCode]='ENCRYPTT' OR [eventCode]='ENCRYPTR' OR [eventCode]='ENCRYPT' OR [eventCode]='DRIVLABEL' OR [eventCode]='DOWNGRDLABEL' OR [eventCode]='DELAU' OR [eventCode]='DEID' OR [eventCode]='DECLASSIFYLABEL' OR [eventCode]='CPLYPOL' OR [eventCode]='CPLYOSP' OR [eventCode]='CPLYOPP' OR [eventCode]='CPLYJPP' OR [eventCode]='CPLYCD' OR [eventCode]='CPLYCC' OR [eventCode]='AUDTR' OR [eventCode]='AUDIT' OR [eventCode]='AOD' OR [eventCode]='ANONY' OR [eventCode]='ObligationPolicy' OR [eventCode]='DELEPOL' OR [eventCode]='ACCESSCONSCHEME' OR [eventCode]='AUTHPOL' OR [eventCode]='SecurityPolicy' OR [eventCode]='COVPOL' OR [eventCode]='TRSTMEC' OR [eventCode]='TRSTFWK' OR [eventCode]='TRSTCERT' OR [eventCode]='TRSTASSUR' OR [eventCode]='TRSTAGRE' OR [eventCode]='TRSTACCRD' OR [eventCode]='ActTrustPolicyType' OR [eventCode]='RMGTCOMPT' OR [eventCode]='RESCOMPT' OR [eventCode]='PACOMPT' OR [eventCode]='LRCOMPT' OR [eventCode]='HRCOMPT' OR [eventCode]='FMCOMPT' OR [eventCode]='CTCOMPT' OR [eventCode]='ACOCOMPT' OR [eventCode]='COMPT' OR [eventCode]='PRS' OR [eventCode]='PHY' OR [eventCode]='PDS' OR [eventCode]='EMP' OR [eventCode]='DRGIS' OR [eventCode]='DIA' OR [eventCode]='CEL' OR [eventCode]='ADOL' OR [eventCode]='SSP' OR [eventCode]='LOCIS' OR [eventCode]='EMPL' OR [eventCode]='B' OR [eventCode]='_RoleInformationSensitivityPolicy' OR [eventCode]='REL' OR [eventCode]='RACE' OR [eventCode]='MARST' OR [eventCode]='LIVARG' OR [eventCode]='GENDER' OR [eventCode]='DOB' OR [eventCode]='DEMO' OR [eventCode]='_EntitySensitivityPolicyType' OR [eventCode]='SICKLE' OR [eventCode]='VIO' OR [eventCode]='TBOO' OR [eventCode]='STD' OR [eventCode]='OPIOIDUD' OR [eventCode]='ETHUD' OR [eventCode]='SUD' OR [eventCode]='PSYTHPN' OR [eventCode]='PSY' OR [eventCode]='MH' OR [eventCode]='EMOTDIS' OR [eventCode]='DVD' OR [eventCode]='COGN' OR [eventCode]='BH' OR [eventCode]='SPI' OR [eventCode]='SEX' OR [eventCode]='SDV' OR [eventCode]='SCA' OR [eventCode]='MST' OR [eventCode]='HIV' OR [eventCode]='GDIS' OR [eventCode]='ETH' OR [eventCode]='_ActInformationSensitivityPolicy' OR [eventCode]='_InformationSensitivityPolicy' OR [eventCode]='Title38Section7332' OR [eventCode]='HIPAASelfPay' OR [eventCode]='HIPAAPsyNotes' OR [eventCode]='HIPAANOPP' OR [eventCode]='CommonRule' OR [eventCode]='42CFRPart2' OR [eventCode]='_ActUSPrivacyLaw' OR [eventCode]='_ActPrivacyLaw' OR [eventCode]='OPTOUTE' OR [eventCode]='OPTOUT' OR [eventCode]='OPTINR' OR [eventCode]='OPTIN' OR [eventCode]='NOPP' OR [eventCode]='NOCONSENT' OR [eventCode]='IMPLIEDD' OR [eventCode]='IMPLIED' OR [eventCode]='GRANTORCHOICE' OR [eventCode]='EMRGONLY' OR [eventCode]='_ActConsentDirective' OR [eventCode]='_ActPrivacyPolicy' OR [eventCode]='_ActPolicyType' OR [eventCode]='UDE' OR [eventCode]='TBS' OR [eventCode]='TB' OR [eventCode]='RFS' OR [eventCode]='RFPS' OR [eventCode]='RFP' OR [eventCode]='RFFS' OR [eventCode]='RFF' OR [eventCode]='RFCS' OR [eventCode]='RFC' OR [eventCode]='UD' OR [eventCode]='RF' OR [eventCode]='MS' OR [eventCode]='FS' OR [eventCode]='TF' OR [eventCode]='FFSS' OR [eventCode]='FFP' OR [eventCode]='FFC' OR [eventCode]='FF' OR [eventCode]='SO' OR [eventCode]='EM' OR [eventCode]='DF' OR [eventCode]='_ActPharmacySupplyType' OR [eventCode]='NON' OR [eventCode]='DDP' OR [eventCode]='CHK' OR [eventCode]='ACH' OR [eventCode]='_ActPaymentCode' OR [eventCode]='VFPAPER' OR [eventCode]='_ActObservationVerificationType' OR [eventCode]='IND05' OR [eventCode]='IND04' OR [eventCode]='IND03' OR [eventCode]='IND02' OR [eventCode]='IND01' OR [eventCode]='_ActNonObservationIndicationCode' OR [eventCode]='SAC' OR [eventCode]='SA' OR [eventCode]='RX' OR [eventCode]='OTC' OR [eventCode]='LU' OR [eventCode]='INV' OR [eventCode]='CTLSUB' OR [eventCode]='_ActMonitoringProtocolCode' OR [eventCode]='HISTMEDLIST' OR [eventCode]='DISCMEDLIST' OR [eventCode]='CURMEDLIST' OR [eventCode]='MEDLIST' OR [eventCode]='PRN' OR [eventCode]='ONET' OR [eventCode]='CHRON' OR [eventCode]='ACU' OR [eventCode]='_ActMedicationTherapyDurationWorkingListCode' OR [eventCode]='_ActTherapyDurationWorkingListCode' OR [eventCode]='GOALLIST' OR [eventCode]='RISKLIST' OR [eventCode]='PROBLIST' OR [eventCode]='INTOLIST' OR [eventCode]='CONDLIST' OR [eventCode]='CARELIST' OR [eventCode]='_ActObservationLis' OR [eventCode]='_ActListCode' OR [eventCode]='VERBAUTH' OR [eventCode]='UNRELAT' OR [eventCode]='REPSERV' OR [eventCode]='REFNR' OR [eventCode]='PYRDELAY' OR [eventCode]='PIE' OR [eventCode]='PAPER' OR [eventCode]='ORTHO' OR [eventCode]='OOJ' OR [eventCode]='MANUAL' OR [eventCode]='LATE' OR [eventCode]='GFTH' OR [eventCode]='FAX' OR [eventCode]='EFORM' OR [eventCode]='COVGE' OR [eventCode]='_ActInvoiceOverrideCode' OR [eventCode]='SBPDELCT' OR [eventCode]='SBPDELAT' OR [eventCode]='SBNFELCT' OR [eventCode]='SBNFELAT' OR [eventCode]='SBBLELCT' OR [eventCode]='SBBLELAT' OR [eventCode]='_InvoiceElementSubmitted' OR [eventCode]='PDPPSPMNCT' OR [eventCode]='PDPPSPMNAT' OR [eventCode]='PDPPSPELCT' OR [eventCode]='PDPPSPELAT' OR [eventCode]='PDPPPPMNCT' OR [eventCode]='PDPPPPMNAT' OR [eventCode]='PDPPPPELCT' OR [eventCode]='PDPPPPELAT' OR [eventCode]='PDNPSPMNCT' OR [eventCode]='PDNPSPMNAT' OR [eventCode]='PDNPSPELCT' OR [eventCode]='PDNPSPELAT' OR [eventCode]='PDNPPPMNCT' OR [eventCode]='PDNPPPMNAT' OR [eventCode]='PDNPPPELCT' OR [eventCode]='PDNPPPELAT' OR [eventCode]='PDNFSPMNCT' OR [eventCode]='PDNFSPMNAT' OR [eventCode]='PDNFSPELCT' OR [eventCode]='PDNFSPELAT' OR [eventCode]='PDNFPPMNCT' OR [eventCode]='PDNFPPMNAT' OR [eventCode]='PDNFPPELCT' OR [eventCode]='PDNFPPELAT' OR [eventCode]='_InvoiceElementPaid' OR [eventCode]='ADRFSPMNCT' OR [eventCode]='ADRFSPMNAT' OR [eventCode]='ADRFSPELCT' OR [eventCode]='ADRFSPELAT' OR [eventCode]='ADRFPPMNCT' OR [eventCode]='ADRFPPMNAT' OR [eventCode]='ADRFPPELCT' OR [eventCode]='ADRFPPELAT' OR [eventCode]='ADPPSPMNCT' OR [eventCode]='ADPPSPMNAT' OR [eventCode]='ADPPSPELCT' OR [eventCode]='ADPPSPELAT' OR [eventCode]='ADPPPPMNCT' OR [eventCode]='ADPPPPMNAT' OR [eventCode]='ADPPPPELCT' OR [eventCode]='ADPPPPELAT' OR [eventCode]='ADNPSPMNCT' OR [eventCode]='ADNPSPMNAT' OR [eventCode]='ADNPSPELCT' OR [eventCode]='ADNPSPELAT' OR [eventCode]='ADNPPPMNCT' OR [eventCode]='ADNPPPMNAT' OR [eventCode]='ADNPPPELCT' OR [eventCode]='ADNPPPELAT' OR [eventCode]='ADNFSPMNCT' OR [eventCode]='ADNFSPMNAT' OR [eventCode]='ADNFSPELCT' OR [eventCode]='ADNFSPELAT' OR [eventCode]='ADNFPPMNCT' OR [eventCode]='ADNFPPMNAT' OR [eventCode]='ADNFPPELCT' OR [eventCode]='ADNFPPELAT' OR [eventCode]='_InvoiceElementAdjudicated' OR [eventCode]='_ActInvoiceElementSummaryCode' OR [eventCode]='VRXINV' OR [eventCode]='SBFINV' OR [eventCode]='RXDINV' OR [eventCode]='RXCINV' OR [eventCode]='PAINV' OR [eventCode]='OHSINV' OR [eventCode]='FININV' OR [eventCode]='CSPINV' OR [eventCode]='CSINV' OR [eventCode]='CPINV' OR [eventCode]='_ActInvoiceRootGroupCode' OR [eventCode]='PRDING' OR [eventCode]='LENSING' OR [eventCode]='FRAMEING' OR [eventCode]='DRUGING' OR [eventCode]='CPNDSUPING' OR [eventCode]='CPNDINDING' OR [eventCode]='CPNDDRGING' OR [eventCode]='_ActInvoiceInterGroupCode' OR [eventCode]='_ActInvoiceGroupCode' OR [eventCode]='_ActInvoiceDetailClinicalServiceCode' OR [eventCode]='W' OR [eventCode]='SP' OR [eventCode]='S' OR [eventCode]='P' OR [eventCode]='I' OR [eventCode]='_HL7AccommodationCode' OR [eventCode]='_ActEncounterAccommodationCode' OR [eventCode]='_ActInvoiceDetailPreferredAccommodationCode' OR [eventCode]='PST' OR [eventCode]='HST' OR [eventCode]='FST' OR [eventCode]='_ActInvoiceDetailTaxCode' OR [eventCode]='URGENT' OR [eventCode]='TRAVEL' OR [eventCode]='RESTOCK' OR [eventCode]='PERMBNS' OR [eventCode]='PERFEE' OR [eventCode]='MISSAPT' OR [eventCode]='MARKUP' OR [eventCode]='FRSTFEE' OR [eventCode]='FNLFEE' OR [eventCode]='FFSTOP' OR [eventCode]='ESA' OR [eventCode]='DSC' OR [eventCode]='CANCAPT' OR [eventCode]='_ActInvoiceDetailGenericProviderCode' OR [eventCode]='OOO' OR [eventCode]='ISOL' OR [eventCode]='AFTHRS' OR [eventCode]='_ActInvoiceDetailGenericModifierCode' OR [eventCode]='COINS' OR [eventCode]='SPEND' OR [eventCode]='PAY' OR [eventCode]='DEDUCTIBLE' OR [eventCode]='COPAYMENT' OR [eventCode]='COIN' OR [eventCode]='_ActInvoiceDetailGenericAdjudicatorCode' OR [eventCode]='_ActInvoiceDetailGenericCode' OR [eventCode]='UPC' OR [eventCode]='GTIN' OR [eventCode]='_ActInvoiceDetailDrugProductCode' OR [eventCode]='UNSPSC' OR [eventCode]='_ActInvoiceDetailClinicalProductCode' OR [eventCode]='_ActInvoiceDetailCode' OR [eventCode]='SENDAPP' OR [eventCode]='PAYOR' OR [eventCode]='PAYEE' OR [eventCode]='INVTYPE' OR [eventCode]='_ActInvoiceAdjudicationPaymentSummaryCode' OR [eventCode]='TRAN' OR [eventCode]='RETRO' OR [eventCode]='RECOV' OR [eventCode]='PROA' OR [eventCode]='PPRD' OR [eventCode]='PINV' OR [eventCode]='INVOICE' OR [eventCode]='GARN' OR [eventCode]='EPYMT' OR [eventCode]='EDU' OR [eventCode]='CFWD' OR [eventCode]='BONUS' OR [eventCode]='ALEC' OR [eventCode]='_ActInvoiceAdjudicationPaymentGroupCode' OR [eventCode]='_ActInvoiceAdjudicationPaymentCode' OR [eventCode]='_ActInvoiceElementCode' OR [eventCode]='RXCAT' OR [eventCode]='PSVCCAT' OR [eventCode]='MENCAT' OR [eventCode]='MEDCCAT' OR [eventCode]='LABCAT' OR [eventCode]='IMMUCAT' OR [eventCode]='DICAT' OR [eventCode]='DEMOCAT' OR [eventCode]='COBSCAT' OR [eventCode]='ARCAT' OR [eventCode]='ALLGCAT' OR [eventCode]='ALLCAT' OR [eventCode]='_ActInformationCategoryCode' OR [eventCode]='INFREG' OR [eventCode]='INFPWR' OR [eventCode]='INFEMER' OR [eventCode]='INFDNG' OR [eventCode]='INFCRT' OR [eventCode]='INFCON' OR [eventCode]='INFAUT' OR [eventCode]='_ActInformationAccessContextCode' OR [eventCode]='ACSUBSTAB' OR [eventCode]='ACPSERV' OR [eventCode]='ACPROV' OR [eventCode]='ACPOLPRG' OR [eventCode]='ACOBS' OR [eventCode]='ACMEN' OR [eventCode]='ACMEDC' OR [eventCode]='ACMED' OR [eventCode]='ACLAB' OR [eventCode]='ACIMMUN' OR [eventCode]='ACDI' OR [eventCode]='ACDEMO' OR [eventCode]='ACCONS' OR [eventCode]='ACALLG' OR [eventCode]='ACALL' OR [eventCode]='ACADR' OR [eventCode]='_ActInformationAccessCode' OR [eventCode]='WPA' OR [eventCode]='SPT' OR [eventCode]='SCHOOL' OR [eventCode]='MVA' OR [eventCode]='_ActIncidentCode' OR [eventCode]='REV' OR [eventCode]='CHRG' OR [eventCode]='_ActFinancialTransactionCode' OR [eventCode]='WORK2' OR [eventCode]='TRAVINT' OR [eventCode]='SUBSTNCE' OR [eventCode]='SOCIAL2' OR [eventCode]='SCHOOL2' OR [eventCode]='PTNTCARE' OR [eventCode]='PLACE' OR [eventCode]='LTRMCARE' OR [eventCode]='INTIMATE' OR [eventCode]='INMATE' OR [eventCode]='HOUSEHLD' OR [eventCode]='HOSPVSTR' OR [eventCode]='HOSPPTNT' OR [eventCode]='HOMECARE' OR [eventCode]='HLTHCARE' OR [eventCode]='CONVEYNC' OR [eventCode]='CHLDCARE' OR [eventCode]='_ActExposureCode' OR [eventCode]='9' OR [eventCode]='13' OR [eventCode]='12' OR [eventCode]='11' OR [eventCode]='10' OR [eventCode]='8' OR [eventCode]='20' OR [eventCode]='18' OR [eventCode]='17' OR [eventCode]='16' OR [eventCode]='15' OR [eventCode]='14' OR [eventCode]='7' OR [eventCode]='6' OR [eventCode]='5' OR [eventCode]='4' OR [eventCode]='3' OR [eventCode]='23' OR [eventCode]='22' OR [eventCode]='2' OR [eventCode]='19' OR [eventCode]='1' OR [eventCode]='21' OR [eventCode]='EMAUTH' OR [eventCode]='_AuthorizationIssueManagementCode' OR [eventCode]='_ActAdministrativeDetectedIssueManagementCode' OR [eventCode]='_ActDetectedIssueManagementCode' OR [eventCode]='VET' OR [eventCode]='SOCIAL' OR [eventCode]='RETIRE' OR [eventCode]='MILITARY' OR [eventCode]='IND' OR [eventCode]='HIRISK' OR [eventCode]='GOVEMP' OR [eventCode]='EAP' OR [eventCode]='CRIME' OR [eventCode]='CHAR' OR [eventCode]='_ActProgramTypeCode' OR [eventCode]='UMBRL' OR [eventCode]='SURPL' OR [eventCode]='REI' OR [eventCode]='PNC' OR [eventCode]='ULIFE' OR [eventCode]='TLIFE' OR [eventCode]='ANNU' OR [eventCode]='LIFE' OR [eventCode]='FLEXP' OR [eventCode]='EWB' OR [eventCode]='DIS' OR [eventCode]='VISPOL' OR [eventCode]='SUBPOL' OR [eventCode]='MENTPOL' OR [eventCode]='PPO' OR [eventCode]='HMO' OR [eventCode]='POS' OR [eventCode]='MCPOL' OR [eventCode]='LTC' OR [eventCode]='HIP' OR [eventCode]='DRUGPOL' OR [eventCode]='DISEASE' OR [eventCode]='DENTAL' OR [eventCode]='_ActHealthInsuranceTypeCode' OR [eventCode]='_ActInsuranceTypeCode' OR [eventCode]='WCBPOL' OR [eventCode]='SUBSUPP' OR [eventCode]='SUBSIDMC' OR [eventCode]='SUBSIDIZ' OR [eventCode]='SUBPRG' OR [eventCode]='SAFNET' OR [eventCode]='MENTPRG' OR [eventCode]='MANDPOL' OR [eventCode]='HIVAIDS' OR [eventCode]='ENDRENAL' OR [eventCode]='CANPRG' OR [eventCode]='DISEASEPRG' OR [eventCode]='DENTPRG' OR [eventCode]='PUBLICPOL' OR [eventCode]='UNINSMOT' OR [eventCode]='COL' OR [eventCode]='AUTOPOL' OR [eventCode]='HSAPOL' OR [eventCode]='EHCPOL' OR [eventCode]='_ActInsurancePolicyCode' OR [eventCode]='_ActCoverageTypeCode' OR [eventCode]='_ActCoveredPartyLimitCode' OR [eventCode]='COVMX' OR [eventCode]='UNITQTY' OR [eventCode]='UNITPRICE' OR [eventCode]='PRDMX' OR [eventCode]='NETAMT' OR [eventCode]='LFEMX' OR [eventCode]='COVPRD' OR [eventCode]='_ActCoverageQuantityLimitCode' OR [eventCode]='_ActCoverageLimitCode' OR [eventCode]='NELG' OR [eventCode]='ELG' OR [eventCode]='_ActCoverageEligibilityConfirmationCode' OR [eventCode]='NAUTH' OR [eventCode]='AUTH' OR [eventCode]='_ActCoverageAuthorizationConfirmationCode' OR [eventCode]='_ActCoverageConfirmationCode' OR [eventCode]='REFLEX' OR [eventCode]='ENDC' OR [eventCode]='AUTO' OR [eventCode]='_ActControlVariable' OR [eventCode]='X' OR [eventCode]='R' OR [eventCode]='O' OR [eventCode]='M' OR [eventCode]='L' OR [eventCode]='IP' OR [eventCode]='ID' OR [eventCode]='_ActContainerRegistrationCode' OR [eventCode]='RSREID' OR [eventCode]='RSDID' OR [eventCode]='RESEARCH' OR [eventCode]='IRDSCL' OR [eventCode]='INFASO' OR [eventCode]='INFAO' OR [eventCode]='INFA' OR [eventCode]='IDSCL' OR [eventCode]='ICOL' OR [eventCode]='_ActConsentType' OR [eventCode]='XRAY' OR [eventCode]='WIATTCH' OR [eventCode]='MODEL' OR [eventCode]='LABRESULTS' OR [eventCode]='IMG' OR [eventCode]='HEALTHREC' OR [eventCode]='DOCUMENT' OR [eventCode]='AUTOATTCH' OR [eventCode]='_ActClaimAttachmentCategoryCode' OR [eventCode]='SURG' OR [eventCode]='PSYCH' OR [eventCode]='PHYRHB' OR [eventCode]='PHAR' OR [eventCode]='PED' OR [eventCode]='PALL' OR [eventCode]='ONC' OR [eventCode]='OBS' OR [eventCode]='MED' OR [eventCode]='GENRL' OR [eventCode]='DRGRHB' OR [eventCode]='DNTL' OR [eventCode]='CHR' OR [eventCode]='CARD' OR [eventCode]='ALC' OR [eventCode]='_ActMedicalServiceCode' OR [eventCode]='VR' OR [eventCode]='SS' OR [eventCode]='PRENC' OR [eventCode]='OBSENC' OR [eventCode]='NONAC' OR [eventCode]='ACUTE' OR [eventCode]='IMP' OR [eventCode]='HH' OR [eventCode]='FLD' OR [eventCode]='EMER' OR [eventCode]='AMB' OR [eventCode]='_ActEncounterCode' OR [eventCode]='CWOH' OR [eventCode]='CWMA' OR [eventCode]='CVDC' OR [eventCode]='CTBU' OR [eventCode]='CSPT' OR [eventCode]='CSLD' OR [eventCode]='CSIC' OR [eventCode]='CSDM' OR [eventCode]='CPST' OR [eventCode]='CPND' OR [eventCode]='CPAD' OR [eventCode]='CORT' OR [eventCode]='COPD' OR [eventCode]='CONC' OR [eventCode]='COJR' OR [eventCode]='CMSC' OR [eventCode]='CMIH' OR [eventCode]='CHYP' OR [eventCode]='CHRO' OR [eventCode]='CHFC' OR [eventCode]='CFEL' OR [eventCode]='CEPI' OR [eventCode]='CDIA' OR [eventCode]='CDGD' OR [eventCode]='CDEP' OR [eventCode]='CCAR' OR [eventCode]='CCAD' OR [eventCode]='CBAR' OR [eventCode]='CAST' OR [eventCode]='CAMI' OR [eventCode]='CACS' OR [eventCode]='AOSC' OR [eventCode]='ALTC' OR [eventCode]='AHOC' OR [eventCode]='ACHC' OR [eventCode]='ACAC' OR [eventCode]='ABHC' OR [eventCode]='AAMC' OR [eventCode]='AALC' OR [eventCode]='_ActCredentialedCareProvisionProgramCode' OR [eventCode]='LGPC' OR [eventCode]='CVSC' OR [eventCode]='CURC' OR [eventCode]='CTSC' OR [eventCode]='CSUC' OR [eventCode]='CRPC' OR [eventCode]='CROC' OR [eventCode]='CPYC' OR [eventCode]='CPSC' OR [eventCode]='CPRC' OR [eventCode]='CPHC' OR [eventCode]='CPGC' OR [eventCode]='CPEC' OR [eventCode]='COTC' OR [eventCode]='COSC' OR [eventCode]='COPC' OR [eventCode]='COMC' OR [eventCode]='COGC' OR [eventCode]='CNSC' OR [eventCode]='CNQC' OR [eventCode]='CNMC' OR [eventCode]='CNEC' OR [eventCode]='CMGC' OR [eventCode]='CIMC' OR [eventCode]='CFPC' OR [eventCode]='CEMC' OR [eventCode]='CDRC' OR [eventCode]='CDEC' OR [eventCode]='CCSC' OR [eventCode]='CCPC' OR [eventCode]='CCGC' OR [eventCode]='CCCC' OR [eventCode]='CBGC' OR [eventCode]='CAPC' OR [eventCode]='CANC' OR [eventCode]='CAMC' OR [eventCode]='CAIC' OR [eventCode]='CACC' OR [eventCode]='_ActCredentialedCareProvisionPersonCode' OR [eventCode]='_ActCredentialedCareCode' OR [eventCode]='_ActCareProvisionCode' OR [eventCode]='ROIPS' OR [eventCode]='ROIFS' OR [eventCode]='_ActBoundedROICode' OR [eventCode]='TFS' OR [eventCode]='FFCS' OR [eventCode]='FFPS' OR [eventCode]='FFS' OR [eventCode]='SESS' OR [eventCode]='ROST' OR [eventCode]='FINBILL' OR [eventCode]='CONTF' OR [eventCode]='CAP' OR [eventCode]='BLK' OR [eventCode]='_ActBillingArrangementCode' OR [eventCode]='HCPCSA' OR [eventCode]='CPTM' OR [eventCode]='_ActBillableModifierCode' OR [eventCode]='FORM' OR [eventCode]='DISPLAY' OR [eventCode]='_ActAdjudicationResultActionCode' OR [eventCode]='AS' OR [eventCode]='AR' OR [eventCode]='ANF' OR [eventCode]='AA' OR [eventCode]='YEAR' OR [eventCode]='WEEK' OR [eventCode]='PROV' OR [eventCode]='PERIOD' OR [eventCode]='MONTH' OR [eventCode]='LOC' OR [eventCode]='DAY' OR [eventCode]='CONT' OR [eventCode]='_ActAdjudicationGroupCode' OR [eventCode]='_ActAdjudicationCode' OR [eventCode]='PBILLACCT' OR [eventCode]='V' OR [eventCode]='MC' OR [eventCode]='DV' OR [eventCode]='DN' OR [eventCode]='AE' OR [eventCode]='CC' OR [eventCode]='CASH' OR [eventCode]='ACCTRECEIVABLE' OR [eventCode]='_ActAccountCode')),
	CHECK (([facilityType]='394777002' OR [facilityType]='272501009' OR [facilityType]='419955002' OR [facilityType]='310205006' OR [facilityType]='413817003' OR [facilityType]='413456002' OR [facilityType]='59374000' OR [facilityType]='2081004' OR [facilityType]='901005' OR [facilityType]='409519008' OR [facilityType]='11424001' OR [facilityType]='35971002' OR [facilityType]='81234003' OR [facilityType]='46224007' OR [facilityType]='20078004' OR [facilityType]='25681007' OR [facilityType]='77931003' OR [facilityType]='39913001' OR [facilityType]='309898008' OR [facilityType]='6827000' OR [facilityType]='72311000' OR [facilityType]='1773006' OR [facilityType]='51563005' OR [facilityType]='45899008' OR [facilityType]='41844007' OR [facilityType]='91154008' OR [facilityType]='10531005' OR [facilityType]='275576008' OR [facilityType]='309900005' OR [facilityType]='405607001' OR [facilityType]='394759007' OR [facilityType]='83891005' OR [facilityType]='39350007' OR [facilityType]='19602009' OR [facilityType]='33022008' OR [facilityType]='79491001' OR [facilityType]='50569004' OR [facilityType]='331006' OR [facilityType]='57159002' OR [facilityType]='37546005' OR [facilityType]='5584006' OR [facilityType]='3729002' OR [facilityType]='36293008' OR [facilityType]='23392004' OR [facilityType]='78001009' OR [facilityType]='78088001' OR [facilityType]='89972002' OR [facilityType]='56189001' OR [facilityType]='38238005' OR [facilityType]='14866005' OR [facilityType]='2849009' OR [facilityType]='360966004' OR [facilityType]='56293002' OR [facilityType]='22549003' OR [facilityType]='1814000' OR [facilityType]='90484001' OR [facilityType]='58482006' OR [facilityType]='31628002' OR [facilityType]='73644007' OR [facilityType]='37550003' OR [facilityType]='10206005' OR [facilityType]='360957003' OR [facilityType]='52668009' OR [facilityType]='69362002' OR [facilityType]='73770003' OR [facilityType]='418518002' OR [facilityType]='45618002' OR [facilityType]='42665001' OR [facilityType]='284546000' OR [facilityType]='48311003' OR [facilityType]='36125001' OR [facilityType]='80522000' OR [facilityType]='62480006' OR [facilityType]='224687002' OR [facilityType]='4322002' OR [facilityType]='32074000' OR [facilityType]='79993009' OR [facilityType]='225732001' OR [facilityType]='82242000')),
	CHECK (([practiceSettingCode]='394732004' OR [practiceSettingCode]='394733009' OR [practiceSettingCode]='394612005' OR [practiceSettingCode]='419043006' OR [practiceSettingCode]='408448007' OR [practiceSettingCode]='409967009' OR [practiceSettingCode]='394590007' OR [practiceSettingCode]='394576009' OR [practiceSettingCode]='419321007' OR [practiceSettingCode]='408463005' OR [practiceSettingCode]='394801008' OR [practiceSettingCode]='408477008' OR [practiceSettingCode]='394611003' OR [practiceSettingCode]='394610002' OR [practiceSettingCode]='408474001' OR [practiceSettingCode]='394609007' OR [practiceSettingCode]='394604002' OR [practiceSettingCode]='418018006' OR [practiceSettingCode]='394608004' OR [practiceSettingCode]='408449004' OR [practiceSettingCode]='394606000' OR [practiceSettingCode]='408460008' OR [practiceSettingCode]='408460008' OR [practiceSettingCode]='408461007' OR [practiceSettingCode]='394608004' OR [practiceSettingCode]='394605001' OR [practiceSettingCode]='408465003' OR [practiceSettingCode]='408441001' OR [practiceSettingCode]='408464004' OR [practiceSettingCode]='408471009' OR [practiceSettingCode]='408466002' OR [practiceSettingCode]='408469009' OR [practiceSettingCode]='408476004' OR [practiceSettingCode]='408450004' OR [practiceSettingCode]='394810000' OR [practiceSettingCode]='408447002' OR [practiceSettingCode]='394602003' OR [practiceSettingCode]='408455009' OR [practiceSettingCode]='394914008' OR [practiceSettingCode]='419815003' OR [practiceSettingCode]='418112009' OR [practiceSettingCode]='408440000' OR [practiceSettingCode]='394913002' OR [practiceSettingCode]='394587001' OR [practiceSettingCode]='409968004' OR [practiceSettingCode]='420112009' OR [practiceSettingCode]='394539006' OR [practiceSettingCode]='419472004' OR [practiceSettingCode]='419170002' OR [practiceSettingCode]='419983000' OR [practiceSettingCode]='418002000' OR [practiceSettingCode]='419365004' OR [practiceSettingCode]='418862001' OR [practiceSettingCode]='418535003' OR [practiceSettingCode]='418652005' OR [practiceSettingCode]='420208008' OR [practiceSettingCode]='418058008' OR [practiceSettingCode]='419610006' OR [practiceSettingCode]='394607009' OR [practiceSettingCode]='408459003' OR [practiceSettingCode]='394588006' OR [practiceSettingCode]='394806003' OR [practiceSettingCode]='394882004' OR [practiceSettingCode]='418960008' OR [practiceSettingCode]='416304004' OR [practiceSettingCode]='394594003' OR [practiceSettingCode]='422191005' OR [practiceSettingCode]='394821009' OR [practiceSettingCode]='394585009' OR [practiceSettingCode]='408470005' OR [practiceSettingCode]='394649004' OR [practiceSettingCode]='394599008' OR [practiceSettingCode]='394591006' OR [practiceSettingCode]='394589003' OR [practiceSettingCode]='410001006' OR [practiceSettingCode]='394813003' OR [practiceSettingCode]='394593009' OR [practiceSettingCode]='408468001' OR [practiceSettingCode]='419192003' OR [practiceSettingCode]='394807007' OR [practiceSettingCode]='394598000' OR [practiceSettingCode]='394597005' OR [practiceSettingCode]='408472002' OR [practiceSettingCode]='394916005' OR [practiceSettingCode]='394586005' OR [practiceSettingCode]='408446006' OR [practiceSettingCode]='394811001' OR [practiceSettingCode]='394808002' OR [practiceSettingCode]='394814009' OR [practiceSettingCode]='394915009' OR [practiceSettingCode]='394802001' OR [practiceSettingCode]='408443003' OR [practiceSettingCode]='394584008' OR [practiceSettingCode]='419772000' OR [practiceSettingCode]='394583002' OR [practiceSettingCode]='410005002' OR [practiceSettingCode]='408475000' OR [practiceSettingCode]='394582007' OR [practiceSettingCode]='408444009' OR [practiceSettingCode]='394812008' OR [practiceSettingCode]='408478003' OR [practiceSettingCode]='394581000' OR [practiceSettingCode]='394601005' OR [practiceSettingCode]='394600006' OR [practiceSettingCode]='394592004' OR [practiceSettingCode]='394809005' OR [practiceSettingCode]='408454008' OR [practiceSettingCode]='408480009' OR [practiceSettingCode]='394803006' OR [practiceSettingCode]='394580004' OR [practiceSettingCode]='394804000' OR [practiceSettingCode]='394579002' OR [practiceSettingCode]='408462000' OR [practiceSettingCode]='421661004' OR [practiceSettingCode]='394578005' OR [practiceSettingCode]='394577000' OR [practiceSettingCode]='408467006')),
	CHECK (([status]='entered-in-error' OR [status]='superseded' OR [status]='current'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_EncounterDiagnosis' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_EncounterDiagnosis] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[id] [uniqueidentifier] NULL,
	[use] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[rank] [smallint] NULL,
	CHECK (([use]='billing' OR [use]='post-op' OR [use]='pre-op' OR [use]='CM' OR [use]='CC' OR [use]='DD' OR [use]='AD'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_EncounterParticipants' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_EncounterParticipants] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [uniqueidentifier] NULL,
	[type] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([type]='emergency' OR [type]='translator' OR [type]='PART' OR [type]='PPRF' OR [type]='SPRF' OR [type]='REF' OR [type]='ESC' OR [type]='DIS' OR [type]='CON' OR [type]='CALLBCK' OR [type]='ATND' OR [type]='ADM'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_EncounterReason' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_EncounterReason] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[reasonCode] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[reasonCodeDisplay] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([reasonCode]='215079006' OR [reasonCode]='215078003' OR [reasonCode]='215077008' OR [reasonCode]='215076004' OR [reasonCode]='215075000' OR [reasonCode]='215074001' OR [reasonCode]='215073007' OR [reasonCode]='215072002' OR [reasonCode]='215071009' OR [reasonCode]='215068001' OR [reasonCode]='215067006' OR [reasonCode]='215066002' OR [reasonCode]='215064004' OR [reasonCode]='215063005' OR [reasonCode]='215062000' OR [reasonCode]='215061007' OR [reasonCode]='215060008' OR [reasonCode]='215059003' OR [reasonCode]='215056005' OR [reasonCode]='215055009' OR [reasonCode]='215054008' OR [reasonCode]='215053002' OR [reasonCode]='215051000' OR [reasonCode]='215050004' OR [reasonCode]='215049004' OR [reasonCode]='215048007' OR [reasonCode]='215045005' OR [reasonCode]='215044009' OR [reasonCode]='215043003' OR [reasonCode]='215042008' OR [reasonCode]='215041001' OR [reasonCode]='215040000' OR [reasonCode]='215039002' OR [reasonCode]='215038005' OR [reasonCode]='215037000' OR [reasonCode]='215034007' OR [reasonCode]='215033001' OR [reasonCode]='215032006' OR [reasonCode]='215031004' OR [reasonCode]='215030003' OR [reasonCode]='215029008' OR [reasonCode]='215028000' OR [reasonCode]='215027005' OR [reasonCode]='215026001' OR [reasonCode]='215023009' OR [reasonCode]='215022004' OR [reasonCode]='215021006' OR [reasonCode]='215020007' OR [reasonCode]='215019001' OR [reasonCode]='215018009' OR [reasonCode]='215017004' OR [reasonCode]='215016008' OR [reasonCode]='215015007' OR [reasonCode]='215011003' OR [reasonCode]='215010002' OR [reasonCode]='215009007' OR [reasonCode]='215008004' OR [reasonCode]='215007009' OR [reasonCode]='215006000' OR [reasonCode]='215005001' OR [reasonCode]='215004002' OR [reasonCode]='215003008' OR [reasonCode]='215000006' OR [reasonCode]='214997008' OR [reasonCode]='214996004' OR [reasonCode]='214995000' OR [reasonCode]='214994001' OR [reasonCode]='214992002' OR [reasonCode]='214989001' OR [reasonCode]='214987004' OR [reasonCode]='214985007' OR [reasonCode]='214984006' OR [reasonCode]='214983000' OR [reasonCode]='214982005' OR [reasonCode]='214981003' OR [reasonCode]='214978008' OR [reasonCode]='214977003' OR [reasonCode]='214975006' OR [reasonCode]='214974005' OR [reasonCode]='214972009' OR [reasonCode]='214971002' OR [reasonCode]='214970001' OR [reasonCode]='214944002' OR [reasonCode]='214943008' OR [reasonCode]='214942003' OR [reasonCode]='214941005' OR [reasonCode]='214940006' OR [reasonCode]='214939009' OR [reasonCode]='214938001' OR [reasonCode]='214937006' OR [reasonCode]='214936002' OR [reasonCode]='214933005' OR [reasonCode]='214931007' OR [reasonCode]='214930008' OR [reasonCode]='214929003' OR [reasonCode]='214928006' OR [reasonCode]='214927001' OR [reasonCode]='214926005' OR [reasonCode]='214925009' OR [reasonCode]='214922007' OR [reasonCode]='214921000' OR [reasonCode]='214919005' OR [reasonCode]='214918002' OR [reasonCode]='214917007' OR [reasonCode]='214916003' OR [reasonCode]='214915004' OR [reasonCode]='214914000' OR [reasonCode]='214886007' OR [reasonCode]='214885006' OR [reasonCode]='214884005' OR [reasonCode]='214883004' OR [reasonCode]='214882009' OR [reasonCode]='214881002' OR [reasonCode]='214880001' OR [reasonCode]='214879004' OR [reasonCode]='214878007' OR [reasonCode]='214875005' OR [reasonCode]='214874009' OR [reasonCode]='214873003' OR [reasonCode]='214872008' OR [reasonCode]='214871001' OR [reasonCode]='214870000' OR [reasonCode]='214869001' OR [reasonCode]='214868009' OR [reasonCode]='214867004' OR [reasonCode]='214853008' OR [reasonCode]='214852003' OR [reasonCode]='214851005' OR [reasonCode]='214850006' OR [reasonCode]='214849006' OR [reasonCode]='214848003' OR [reasonCode]='214847008' OR [reasonCode]='214846004' OR [reasonCode]='214845000' OR [reasonCode]='214842002' OR [reasonCode]='214841009' OR [reasonCode]='214840005' OR [reasonCode]='214839008' OR [reasonCode]='214838000' OR [reasonCode]='214837005' OR [reasonCode]='214836001' OR [reasonCode]='214835002' OR [reasonCode]='214834003' OR [reasonCode]='214796005' OR [reasonCode]='214795009' OR [reasonCode]='214794008' OR [reasonCode]='214793002' OR [reasonCode]='214792007' OR [reasonCode]='214791000' OR [reasonCode]='214790004' OR [reasonCode]='214788000' OR [reasonCode]='214784003' OR [reasonCode]='214783009' OR [reasonCode]='214782004' OR [reasonCode]='214781006' OR [reasonCode]='214780007' OR [reasonCode]='214779009' OR [reasonCode]='214778001' OR [reasonCode]='214777006' OR [reasonCode]='214774004' OR [reasonCode]='214773005' OR [reasonCode]='214772000' OR [reasonCode]='214771007' OR [reasonCode]='214770008' OR [reasonCode]='214769007' OR [reasonCode]='214768004' OR [reasonCode]='214767009' OR [reasonCode]='214766000' OR [reasonCode]='214763008' OR [reasonCode]='214762003' OR [reasonCode]='214761005' OR [reasonCode]='214760006' OR [reasonCode]='214759001' OR [reasonCode]='214758009' OR [reasonCode]='214757004' OR [reasonCode]='214756008' OR [reasonCode]='214755007' OR [reasonCode]='214752005' OR [reasonCode]='214751003' OR [reasonCode]='214750002' OR [reasonCode]='214749002' OR [reasonCode]='214748005' OR [reasonCode]='214747000' OR [reasonCode]='214746009' OR [reasonCode]='214745008' OR [reasonCode]='214744007' OR [reasonCode]='214741004' OR [reasonCode]='214740003' OR [reasonCode]='214738008' OR [reasonCode]='214737003' OR [reasonCode]='214736007' OR [reasonCode]='214735006' OR [reasonCode]='214734005' OR [reasonCode]='214733004' OR [reasonCode]='214730001' OR [reasonCode]='214729006' OR [reasonCode]='214728003' OR [reasonCode]='214727008' OR [reasonCode]='214726004' OR [reasonCode]='214725000' OR [reasonCode]='214724001' OR [reasonCode]='214722002' OR [reasonCode]='214705004' OR [reasonCode]='214704000' OR [reasonCode]='214703006' OR [reasonCode]='214702001' OR [reasonCode]='214699008' OR [reasonCode]='214698000' OR [reasonCode]='214695002' OR [reasonCode]='214694003' OR [reasonCode]='214693009' OR [reasonCode]='214692004' OR [reasonCode]='214691006' OR [reasonCode]='214690007' OR [reasonCode]='214689003' OR [reasonCode]='214688006' OR [reasonCode]='214687001' OR [reasonCode]='214683002' OR [reasonCode]='214682007' OR [reasonCode]='214681000' OR [reasonCode]='214680004' OR [reasonCode]='214678005' OR [reasonCode]='214676009' OR [reasonCode]='214673001' OR [reasonCode]='214672006' OR [reasonCode]='214671004' OR [reasonCode]='214670003' OR [reasonCode]='214669004' OR [reasonCode]='214668007' OR [reasonCode]='214667002' OR [reasonCode]='214666006' OR [reasonCode]='214665005' OR [reasonCode]='214662008' OR [reasonCode]='214661001' OR [reasonCode]='214659005' OR [reasonCode]='214658002' OR [reasonCode]='214657007' OR [reasonCode]='214656003' OR [reasonCode]='214654000' OR [reasonCode]='214653006' OR [reasonCode]='214650009' OR [reasonCode]='214649009' OR [reasonCode]='214648001' OR [reasonCode]='214647006' OR [reasonCode]='214646002' OR [reasonCode]='214645003' OR [reasonCode]='214644004' OR [reasonCode]='214643005' OR [reasonCode]='214642000' OR [reasonCode]='214641007' OR [reasonCode]='214640008' OR [reasonCode]='214613008' OR [reasonCode]='214611005' OR [reasonCode]='214610006' OR [reasonCode]='214609001' OR [reasonCode]='214607004' OR [reasonCode]='214606008' OR [reasonCode]='214605007' OR [reasonCode]='214604006' OR [reasonCode]='214601003' OR [reasonCode]='214599000' OR [reasonCode]='214598008' OR [reasonCode]='214597003' OR [reasonCode]='214596007' OR [reasonCode]='214595006' OR [reasonCode]='214594005' OR [reasonCode]='214593004' OR [reasonCode]='214592009' OR [reasonCode]='214589005' OR [reasonCode]='214588002' OR [reasonCode]='214587007' OR [reasonCode]='214586003' OR [reasonCode]='214585004' OR [reasonCode]='214584000' OR [reasonCode]='214582001' OR [reasonCode]='214581008' OR [reasonCode]='214578003' OR [reasonCode]='214577008' OR [reasonCode]='214576004' OR [reasonCode]='214575000' OR [reasonCode]='214574001' OR [reasonCode]='214573007' OR [reasonCode]='214572002' OR [reasonCode]='214571009' OR [reasonCode]='214570005' OR [reasonCode]='214566002' OR [reasonCode]='214565003' OR [reasonCode]='214564004' OR [reasonCode]='214563005' OR [reasonCode]='214562000' OR [reasonCode]='214561007' OR [reasonCode]='214560008' OR [reasonCode]='214559003' OR [reasonCode]='214556005' OR [reasonCode]='214555009' OR [reasonCode]='214553002' OR [reasonCode]='214552007' OR [reasonCode]='214551000' OR [reasonCode]='214550004' OR [reasonCode]='214549004' OR [reasonCode]='214548007' OR [reasonCode]='214545005' OR [reasonCode]='214544009' OR [reasonCode]='214543003' OR [reasonCode]='214542008' OR [reasonCode]='214541001' OR [reasonCode]='214540000' OR [reasonCode]='214539002' OR [reasonCode]='214538005' OR [reasonCode]='214537000' OR [reasonCode]='214534007' OR [reasonCode]='214533001' OR [reasonCode]='214532006' OR [reasonCode]='214531004' OR [reasonCode]='214530003' OR [reasonCode]='214529008' OR [reasonCode]='214528000' OR [reasonCode]='214527005' OR [reasonCode]='214526001' OR [reasonCode]='214523009' OR [reasonCode]='214521006' OR [reasonCode]='214520007' OR [reasonCode]='214518009' OR [reasonCode]='214517004' OR [reasonCode]='214516008' OR [reasonCode]='214515007' OR [reasonCode]='214477005' OR [reasonCode]='214476001' OR [reasonCode]='214475002' OR [reasonCode]='214474003' OR [reasonCode]='214473009' OR [reasonCode]='214472004' OR [reasonCode]='214471006' OR [reasonCode]='214469006' OR [reasonCode]='214466004' OR [reasonCode]='214465000' OR [reasonCode]='214464001' OR [reasonCode]='214462002' OR [reasonCode]='214460005' OR [reasonCode]='214459000' OR [reasonCode]='214458008' OR [reasonCode]='214455006' OR [reasonCode]='214454005' OR [reasonCode]='214453004' OR [reasonCode]='214452009' OR [reasonCode]='214451002' OR [reasonCode]='214450001' OR [reasonCode]='214449001' OR [reasonCode]='214448009' OR [reasonCode]='214447004' OR [reasonCode]='214444006' OR [reasonCode]='214443000' OR [reasonCode]='214442005' OR [reasonCode]='214441003' OR [reasonCode]='214440002' OR [reasonCode]='214439004' OR [reasonCode]='214438007' OR [reasonCode]='214437002' OR [reasonCode]='214436006' OR [reasonCode]='214435005' OR [reasonCode]='214420009' OR [reasonCode]='214419003' OR [reasonCode]='214418006' OR [reasonCode]='214417001' OR [reasonCode]='214416005' OR [reasonCode]='214415009' OR [reasonCode]='214414008' OR [reasonCode]='214413002' OR [reasonCode]='214412007' OR [reasonCode]='214409009' OR [reasonCode]='214408001' OR [reasonCode]='214407006' OR [reasonCode]='214406002' OR [reasonCode]='214405003' OR [reasonCode]='214403005' OR [reasonCode]='214402000' OR [reasonCode]='214401007' OR [reasonCode]='214400008' OR [reasonCode]='214397004' OR [reasonCode]='214396008' OR [reasonCode]='214395007' OR [reasonCode]='214394006' OR [reasonCode]='214393000' OR [reasonCode]='214392005' OR [reasonCode]='214391003' OR [reasonCode]='214390002' OR [reasonCode]='214389006' OR [reasonCode]='214386004' OR [reasonCode]='214385000' OR [reasonCode]='214384001' OR [reasonCode]='214381009' OR [reasonCode]='214380005' OR [reasonCode]='214379007' OR [reasonCode]='214378004' OR [reasonCode]='214374002' OR [reasonCode]='214373008' OR [reasonCode]='214372003' OR [reasonCode]='214371005' OR [reasonCode]='214370006' OR [reasonCode]='214369005' OR [reasonCode]='214368002' OR [reasonCode]='214367007' OR [reasonCode]='214364000' OR [reasonCode]='214363006' OR [reasonCode]='214362001' OR [reasonCode]='214361008' OR [reasonCode]='214360009' OR [reasonCode]='214359004' OR [reasonCode]='214358007' OR [reasonCode]='214357002' OR [reasonCode]='214356006' OR [reasonCode]='214353003' OR [reasonCode]='214352008' OR [reasonCode]='214350000' OR [reasonCode]='214349000' OR [reasonCode]='214348008' OR [reasonCode]='214347003' OR [reasonCode]='214346007' OR [reasonCode]='214345006' OR [reasonCode]='214344005' OR [reasonCode]='214330004' OR [reasonCode]='214329009' OR [reasonCode]='214328001' OR [reasonCode]='214327006' OR [reasonCode]='214326002' OR [reasonCode]='214325003' OR [reasonCode]='214324004' OR [reasonCode]='214323005' OR [reasonCode]='214322000' OR [reasonCode]='214319002' OR [reasonCode]='214318005' OR [reasonCode]='214317000' OR [reasonCode]='214316009' OR [reasonCode]='214315008' OR [reasonCode]='214314007' OR [reasonCode]='214313001' OR [reasonCode]='214312006' OR [reasonCode]='214311004' OR [reasonCode]='214308000' OR [reasonCode]='214307005' OR [reasonCode]='214306001' OR [reasonCode]='214305002' OR [reasonCode]='214304003' OR [reasonCode]='214301006' OR [reasonCode]='214300007' OR [reasonCode]='214299004' OR [reasonCode]='214296006' OR [reasonCode]='214295005' OR [reasonCode]='214294009' OR [reasonCode]='214293003' OR [reasonCode]='214292008' OR [reasonCode]='214291001' OR [reasonCode]='214289009' OR [reasonCode]='214288001' OR [reasonCode]='214287006' OR [reasonCode]='214284004' OR [reasonCode]='214282000' OR [reasonCode]='214281007' OR [reasonCode]='214280008' OR [reasonCode]='214279005' OR [reasonCode]='214278002' OR [reasonCode]='214277007' OR [reasonCode]='214276003' OR [reasonCode]='214273006' OR [reasonCode]='214272001' OR [reasonCode]='214271008' OR [reasonCode]='214270009' OR [reasonCode]='214269008' OR [reasonCode]='214267005' OR [reasonCode]='214266001' OR [reasonCode]='214265002' OR [reasonCode]='214260007' OR [reasonCode]='214259002' OR [reasonCode]='214258005' OR [reasonCode]='214257000' OR [reasonCode]='214256009' OR [reasonCode]='214255008' OR [reasonCode]='214254007' OR [reasonCode]='214253001' OR [reasonCode]='214237004' OR [reasonCode]='214236008' OR [reasonCode]='214235007' OR [reasonCode]='214234006' OR [reasonCode]='214233000' OR [reasonCode]='214232005' OR [reasonCode]='214231003' OR [reasonCode]='214230002' OR [reasonCode]='214227009' OR [reasonCode]='214225001' OR [reasonCode]='214224002' OR [reasonCode]='214223008' OR [reasonCode]='214222003' OR [reasonCode]='214221005' OR [reasonCode]='214220006' OR [reasonCode]='214219000' OR [reasonCode]='214218008' OR [reasonCode]='214215006' OR [reasonCode]='214213004' OR [reasonCode]='214212009' OR [reasonCode]='214211002' OR [reasonCode]='214210001' OR [reasonCode]='214209006' OR [reasonCode]='214208003' OR [reasonCode]='214207008' OR [reasonCode]='214206004' OR [reasonCode]='214191005' OR [reasonCode]='214190006' OR [reasonCode]='214189002' OR [reasonCode]='214188005' OR [reasonCode]='214186009' OR [reasonCode]='214185008' OR [reasonCode]='214184007' OR [reasonCode]='214183001' OR [reasonCode]='214180003' OR [reasonCode]='214179001' OR [reasonCode]='214177004' OR [reasonCode]='214176008' OR [reasonCode]='214175007' OR [reasonCode]='214174006' OR [reasonCode]='214172005' OR [reasonCode]='214171003' OR [reasonCode]='214168006' OR [reasonCode]='214166005' OR [reasonCode]='214165009' OR [reasonCode]='214164008' OR [reasonCode]='214162007' OR [reasonCode]='214161000' OR [reasonCode]='214160004' OR [reasonCode]='214156002' OR [reasonCode]='214155003' OR [reasonCode]='214154004' OR [reasonCode]='214151007' OR [reasonCode]='214150008' OR [reasonCode]='214149008' OR [reasonCode]='214135004' OR [reasonCode]='214134000' OR [reasonCode]='214132001' OR [reasonCode]='214131008' OR [reasonCode]='214129004' OR [reasonCode]='214128007' OR [reasonCode]='214127002' OR [reasonCode]='214126006' OR [reasonCode]='214124009' OR [reasonCode]='214123003' OR [reasonCode]='214121001' OR [reasonCode]='214120000' OR [reasonCode]='214119006' OR [reasonCode]='214118003' OR [reasonCode]='214116004' OR [reasonCode]='214115000' OR [reasonCode]='214113007' OR [reasonCode]='214112002' OR [reasonCode]='214111009' OR [reasonCode]='214110005' OR [reasonCode]='214109000' OR [reasonCode]='214108008' OR [reasonCode]='214107003' OR [reasonCode]='214106007' OR [reasonCode]='214104005' OR [reasonCode]='214102009' OR [reasonCode]='214101002' OR [reasonCode]='214100001' OR [reasonCode]='214099009' OR [reasonCode]='214098001' OR [reasonCode]='214096002' OR [reasonCode]='214095003' OR [reasonCode]='214092000' OR [reasonCode]='214090008' OR [reasonCode]='214089004' OR [reasonCode]='214086006' OR [reasonCode]='214085005' OR [reasonCode]='214082008' OR [reasonCode]='214081001' OR [reasonCode]='214080000' OR [reasonCode]='214056004' OR [reasonCode]='214032003' OR [reasonCode]='214031005' OR [reasonCode]='213998008' OR [reasonCode]='213997003' OR [reasonCode]='213996007' OR [reasonCode]='213995006' OR [reasonCode]='213993004' OR [reasonCode]='213990001' OR [reasonCode]='213989005' OR [reasonCode]='213988002' OR [reasonCode]='213987007' OR [reasonCode]='213986003' OR [reasonCode]='213983006' OR [reasonCode]='213982001' OR [reasonCode]='213981008' OR [reasonCode]='213980009' OR [reasonCode]='213976004' OR [reasonCode]='213975000' OR [reasonCode]='213974001' OR [reasonCode]='213963005' OR [reasonCode]='213962000' OR [reasonCode]='213961007' OR [reasonCode]='213960008' OR [reasonCode]='213959003' OR [reasonCode]='213956005' OR [reasonCode]='213955009' OR [reasonCode]='213954008' OR [reasonCode]='213953002' OR [reasonCode]='213952007' OR [reasonCode]='213949004' OR [reasonCode]='213948007' OR [reasonCode]='213947002' OR [reasonCode]='213946006' OR [reasonCode]='213945005' OR [reasonCode]='213942008' OR [reasonCode]='213941001' OR [reasonCode]='213940000' OR [reasonCode]='213939002' OR [reasonCode]='213938005' OR [reasonCode]='213937000' OR [reasonCode]='213927005' OR [reasonCode]='213926001' OR [reasonCode]='213925002' OR [reasonCode]='213922004' OR [reasonCode]='213920007' OR [reasonCode]='213919001' OR [reasonCode]='213918009' OR [reasonCode]='213917004' OR [reasonCode]='213914006' OR [reasonCode]='213913000' OR [reasonCode]='213912005' OR [reasonCode]='213911003' OR [reasonCode]='213901005' OR [reasonCode]='213900006' OR [reasonCode]='213899001' OR [reasonCode]='213898009' OR [reasonCode]='213897004' OR [reasonCode]='213894006' OR [reasonCode]='213893000' OR [reasonCode]='213890002' OR [reasonCode]='213889006' OR [reasonCode]='213886004' OR [reasonCode]='213885000' OR [reasonCode]='213884001' OR [reasonCode]='213883007' OR [reasonCode]='213882002' OR [reasonCode]='213881009' OR [reasonCode]='213871005' OR [reasonCode]='213870006' OR [reasonCode]='213869005' OR [reasonCode]='213867007' OR [reasonCode]='213864000' OR [reasonCode]='213863006' OR [reasonCode]='213862001' OR [reasonCode]='213861008' OR [reasonCode]='213860009' OR [reasonCode]='213859004' OR [reasonCode]='213835009' OR [reasonCode]='213834008' OR [reasonCode]='213833002' OR [reasonCode]='213831000' OR [reasonCode]='213827006' OR [reasonCode]='213826002' OR [reasonCode]='213825003' OR [reasonCode]='213824004' OR [reasonCode]='213823005' OR [reasonCode]='213820008' OR [reasonCode]='213819002' OR [reasonCode]='213818005' OR [reasonCode]='213817000' OR [reasonCode]='213816009' OR [reasonCode]='213813001' OR [reasonCode]='213812006' OR [reasonCode]='213811004' OR [reasonCode]='213810003' OR [reasonCode]='213809008' OR [reasonCode]='213806001' OR [reasonCode]='213805002' OR [reasonCode]='213804003' OR [reasonCode]='213803009' OR [reasonCode]='213802004' OR [reasonCode]='213799008' OR [reasonCode]='213798000' OR [reasonCode]='213797005' OR [reasonCode]='213796001' OR [reasonCode]='213795002' OR [reasonCode]='213783002' OR [reasonCode]='213782007' OR [reasonCode]='213781000' OR [reasonCode]='213780004' OR [reasonCode]='213779002' OR [reasonCode]='213776009' OR [reasonCode]='213775008' OR [reasonCode]='213774007' OR [reasonCode]='213773001' OR [reasonCode]='213772006' OR [reasonCode]='213771004' OR [reasonCode]='213770003' OR [reasonCode]='213017001' OR [reasonCode]='213007006' OR [reasonCode]='213004004' OR [reasonCode]='212979001' OR [reasonCode]='212976008' OR [reasonCode]='206259008' OR [reasonCode]='206258000' OR [reasonCode]='200156003' OR [reasonCode]='200155004' OR [reasonCode]='199608004' OR [reasonCode]='199607009' OR [reasonCode]='170475009' OR [reasonCode]='161151009' OR [reasonCode]='160966001' OR [reasonCode]='160965002' OR [reasonCode]='160964003' OR [reasonCode]='160963009' OR [reasonCode]='160962004' OR [reasonCode]='160961006' OR [reasonCode]='160960007' OR [reasonCode]='160958005' OR [reasonCode]='160957000' OR [reasonCode]='160956009' OR [reasonCode]='135868008' OR [reasonCode]='135829001' OR [reasonCode]='129674006' OR [reasonCode]='122866006' OR [reasonCode]='115965002' OR [reasonCode]='115964003' OR [reasonCode]='111942003' OR [reasonCode]='111056004' OR [reasonCode]='105447004' OR [reasonCode]='105446008' OR [reasonCode]='105445007' OR [reasonCode]='105444006' OR [reasonCode]='105443000' OR [reasonCode]='105442005' OR [reasonCode]='105441003' OR [reasonCode]='102446000' OR [reasonCode]='102445001' OR [reasonCode]='102444002' OR [reasonCode]='102443008' OR [reasonCode]='102442003' OR [reasonCode]='102441005' OR [reasonCode]='102440006' OR [reasonCode]='102439009' OR [reasonCode]='102437006' OR [reasonCode]='102436002' OR [reasonCode]='102435003' OR [reasonCode]='102434004' OR [reasonCode]='102433005' OR [reasonCode]='102432000' OR [reasonCode]='102431007' OR [reasonCode]='102430008' OR [reasonCode]='102429003' OR [reasonCode]='102428006' OR [reasonCode]='102427001' OR [reasonCode]='102426005' OR [reasonCode]='102425009' OR [reasonCode]='102424008' OR [reasonCode]='102423002' OR [reasonCode]='102422007' OR [reasonCode]='102421000' OR [reasonCode]='102420004' OR [reasonCode]='102418002' OR [reasonCode]='102417007' OR [reasonCode]='102416003' OR [reasonCode]='102415004' OR [reasonCode]='102414000' OR [reasonCode]='102413006' OR [reasonCode]='102412001' OR [reasonCode]='102411008' OR [reasonCode]='102410009' OR [reasonCode]='102406006' OR [reasonCode]='95922009' OR [reasonCode]='95921002' OR [reasonCode]='95920001' OR [reasonCode]='95875007' OR [reasonCode]='95871003' OR [reasonCode]='95866005' OR [reasonCode]='91519006' OR [reasonCode]='90978007' OR [reasonCode]='90757003' OR [reasonCode]='90639005' OR [reasonCode]='90619006' OR [reasonCode]='90569008' OR [reasonCode]='90097005' OR [reasonCode]='90049009' OR [reasonCode]='88817006' OR [reasonCode]='88644004' OR [reasonCode]='88051009' OR [reasonCode]='87309006' OR [reasonCode]='87281005' OR [reasonCode]='86591008' OR [reasonCode]='85261005' OR [reasonCode]='84829006' OR [reasonCode]='84768009' OR [reasonCode]='84026000' OR [reasonCode]='83468000' OR [reasonCode]='83208000' OR [reasonCode]='82947003' OR [reasonCode]='82621005' OR [reasonCode]='82612009' OR [reasonCode]='82313006' OR [reasonCode]='82145005' OR [reasonCode]='81840004' OR [reasonCode]='80580005' OR [reasonCode]='80295006' OR [reasonCode]='79867001' OR [reasonCode]='79835004' OR [reasonCode]='79573009' OR [reasonCode]='78857004' OR [reasonCode]='78672002' OR [reasonCode]='78583002' OR [reasonCode]='78427001' OR [reasonCode]='78387000' OR [reasonCode]='78361000' OR [reasonCode]='78331008' OR [reasonCode]='78078002' OR [reasonCode]='78070009' OR [reasonCode]='77993003' OR [reasonCode]='77740007' OR [reasonCode]='77588008' OR [reasonCode]='77105004' OR [reasonCode]='75941004' OR [reasonCode]='75354000' OR [reasonCode]='74683002' OR [reasonCode]='74660000' OR [reasonCode]='74601003' OR [reasonCode]='74541001' OR [reasonCode]='74509007' OR [reasonCode]='74376000' OR [reasonCode]='74332007' OR [reasonCode]='74148000' OR [reasonCode]='74105006' OR [reasonCode]='72738009' OR [reasonCode]='71893005' OR [reasonCode]='70579001' OR [reasonCode]='70167006' OR [reasonCode]='70055007' OR [reasonCode]='69165005' OR [reasonCode]='69129000' OR [reasonCode]='68274007' OR [reasonCode]='68062003' OR [reasonCode]='68023007' OR [reasonCode]='67916006' OR [reasonCode]='67786008' OR [reasonCode]='67622000' OR [reasonCode]='67313008' OR [reasonCode]='67292001' OR [reasonCode]='67223001' OR [reasonCode]='66466001' OR [reasonCode]='66411002' OR [reasonCode]='66360006' OR [reasonCode]='65819004' OR [reasonCode]='65037004' OR [reasonCode]='63409001' OR [reasonCode]='63148005' OR [reasonCode]='62475002' OR [reasonCode]='60594001' OR [reasonCode]='60257006' OR [reasonCode]='59510000' OR [reasonCode]='59283008' OR [reasonCode]='59262002' OR [reasonCode]='58908002' OR [reasonCode]='58538004' OR [reasonCode]='57741007' OR [reasonCode]='57701003' OR [reasonCode]='57371001' OR [reasonCode]='57135007' OR [reasonCode]='56962005' OR [reasonCode]='56307009' OR [reasonCode]='56102008' OR [reasonCode]='55566008' OR [reasonCode]='55554002' OR [reasonCode]='55225009' OR [reasonCode]='54719000' OR [reasonCode]='54670004' OR [reasonCode]='53846008' OR [reasonCode]='53559009' OR [reasonCode]='52684005' OR [reasonCode]='52136000' OR [reasonCode]='51709005' OR [reasonCode]='51347003' OR [reasonCode]='50514002' OR [reasonCode]='50363002' OR [reasonCode]='50109008' OR [reasonCode]='50105002' OR [reasonCode]='50084004' OR [reasonCode]='50032005' OR [reasonCode]='49905000' OR [reasonCode]='49713007' OR [reasonCode]='49380000' OR [reasonCode]='49250007' OR [reasonCode]='49215004' OR [reasonCode]='49113003' OR [reasonCode]='49061008' OR [reasonCode]='48981002' OR [reasonCode]='48071004' OR [reasonCode]='48015001' OR [reasonCode]='47235009' OR [reasonCode]='47193005' OR [reasonCode]='47044002' OR [reasonCode]='46851004' OR [reasonCode]='45477008' OR [reasonCode]='45224000' OR [reasonCode]='45216005' OR [reasonCode]='44633000' OR [reasonCode]='44301001' OR [reasonCode]='44188002' OR [reasonCode]='44174001' OR [reasonCode]='43682008' OR [reasonCode]='42310008' OR [reasonCode]='41411008' OR [reasonCode]='41358001' OR [reasonCode]='40947009' OR [reasonCode]='40785002' OR [reasonCode]='40537000' OR [reasonCode]='40358007' OR [reasonCode]='40104005' OR [reasonCode]='39826003' OR [reasonCode]='39399006' OR [reasonCode]='39379000' OR [reasonCode]='39262008' OR [reasonCode]='39109007' OR [reasonCode]='38605008' OR [reasonCode]='37933009' OR [reasonCode]='37806009' OR [reasonCode]='37383006' OR [reasonCode]='37169002' OR [reasonCode]='36882002' OR [reasonCode]='36153001' OR [reasonCode]='35468003' OR [reasonCode]='35314007' OR [reasonCode]='35149008' OR [reasonCode]='34468006' OR [reasonCode]='33036003' OR [reasonCode]='32175001' OR [reasonCode]='31868001' OR [reasonCode]='29444006' OR [reasonCode]='28631002' OR [reasonCode]='28064001' OR [reasonCode]='27935005' OR [reasonCode]='27792001' OR [reasonCode]='26878008' OR [reasonCode]='26636000' OR [reasonCode]='25692008' OR [reasonCode]='25455001' OR [reasonCode]='25318002' OR [reasonCode]='24780005' OR [reasonCode]='24454008' OR [reasonCode]='23791009' OR [reasonCode]='23776007' OR [reasonCode]='23546003' OR [reasonCode]='23361001' OR [reasonCode]='23321002' OR [reasonCode]='23233009' OR [reasonCode]='22439003' OR [reasonCode]='21902005' OR [reasonCode]='20974000' OR [reasonCode]='20936008' OR [reasonCode]='20902002' OR [reasonCode]='20757006' OR [reasonCode]='19349004' OR [reasonCode]='19224001' OR [reasonCode]='18893004' OR [reasonCode]='18870005' OR [reasonCode]='18055005' OR [reasonCode]='17982002' OR [reasonCode]='17886000' OR [reasonCode]='17766007' OR [reasonCode]='17542004' OR [reasonCode]='16983000' OR [reasonCode]='16445007' OR [reasonCode]='15654006' OR [reasonCode]='15355001' OR [reasonCode]='15185003' OR [reasonCode]='14047009' OR [reasonCode]='14035003' OR [reasonCode]='13935005' OR [reasonCode]='13711007' OR [reasonCode]='13278006' OR [reasonCode]='13234002' OR [reasonCode]='12994004' OR [reasonCode]='11385001' OR [reasonCode]='10598001' OR [reasonCode]='10588007' OR [reasonCode]='9855000' OR [reasonCode]='8766005' OR [reasonCode]='7878000' OR [reasonCode]='7420003' OR [reasonCode]='6476001' OR [reasonCode]='6300007' OR [reasonCode]='5941001' OR [reasonCode]='5866003' OR [reasonCode]='5331006' OR [reasonCode]='5236003' OR [reasonCode]='5193003' OR [reasonCode]='5062002' OR [reasonCode]='4521008' OR [reasonCode]='3974003' OR [reasonCode]='2617007' OR [reasonCode]='1912002' OR [reasonCode]='1762004' OR [reasonCode]='1428003' OR [reasonCode]='1210002' OR [reasonCode]='891003' OR [reasonCode]='168465006' OR [reasonCode]='168462009' OR [reasonCode]='168451009' OR [reasonCode]='168446003' OR [reasonCode]='168441008' OR [reasonCode]='168438004' OR [reasonCode]='168437009' OR [reasonCode]='168436000' OR [reasonCode]='168435001' OR [reasonCode]='168434002' OR [reasonCode]='168433008' OR [reasonCode]='168432003' OR [reasonCode]='168431005' OR [reasonCode]='168430006' OR [reasonCode]='168429001' OR [reasonCode]='168428009' OR [reasonCode]='168396003' OR [reasonCode]='168395004' OR [reasonCode]='168375005' OR [reasonCode]='168374009' OR [reasonCode]='168373003' OR [reasonCode]='168372008' OR [reasonCode]='168369001' OR [reasonCode]='168364006' OR [reasonCode]='168359007' OR [reasonCode]='168354002' OR [reasonCode]='168353008' OR [reasonCode]='168352003' OR [reasonCode]='168345000' OR [reasonCode]='168342002' OR [reasonCode]='168339008' OR [reasonCode]='168338000' OR [reasonCode]='168337005' OR [reasonCode]='168336001' OR [reasonCode]='168332004' OR [reasonCode]='168331006' OR [reasonCode]='168330007' OR [reasonCode]='168321004' OR [reasonCode]='168316002' OR [reasonCode]='168315003' OR [reasonCode]='168314004' OR [reasonCode]='168313005' OR [reasonCode]='168312000' OR [reasonCode]='168308006' OR [reasonCode]='168307001' OR [reasonCode]='168306005' OR [reasonCode]='168305009' OR [reasonCode]='168302007' OR [reasonCode]='168287000' OR [reasonCode]='168286009' OR [reasonCode]='168221001' OR [reasonCode]='168215000' OR [reasonCode]='168196006' OR [reasonCode]='168195005' OR [reasonCode]='168173006' OR [reasonCode]='168123008' OR [reasonCode]='168085001' OR [reasonCode]='168033003' OR [reasonCode]='168009009' OR [reasonCode]='167984002' OR [reasonCode]='167946008' OR [reasonCode]='167909009' OR [reasonCode]='167861005' OR [reasonCode]='167854006' OR [reasonCode]='167822002' OR [reasonCode]='167760002' OR [reasonCode]='167728005' OR [reasonCode]='167702007' OR [reasonCode]='167701000' OR [reasonCode]='167666002' OR [reasonCode]='167595002' OR [reasonCode]='167594003' OR [reasonCode]='167331008' OR [reasonCode]='167322008' OR [reasonCode]='167317008' OR [reasonCode]='167306007' OR [reasonCode]='167296002' OR [reasonCode]='167286006' OR [reasonCode]='167272007' OR [reasonCode]='167260001' OR [reasonCode]='167253007' OR [reasonCode]='167223000' OR [reasonCode]='167220002' OR [reasonCode]='167219008' OR [reasonCode]='167056009' OR [reasonCode]='167007008' OR [reasonCode]='166813006' OR [reasonCode]='166684009' OR [reasonCode]='166660001' OR [reasonCode]='166557002' OR [reasonCode]='166314008' OR [reasonCode]='165928001' OR [reasonCode]='165824000' OR [reasonCode]='165819003' OR [reasonCode]='165814008' OR [reasonCode]='165803005' OR [reasonCode]='165790008' OR [reasonCode]='165768008' OR [reasonCode]='165766007' OR [reasonCode]='165762009' OR [reasonCode]='165761002' OR [reasonCode]='165742001' OR [reasonCode]='165395000' OR [reasonCode]='165394001' OR [reasonCode]='165393007' OR [reasonCode]='165378008' OR [reasonCode]='165377003' OR [reasonCode]='165376007' OR [reasonCode]='165375006' OR [reasonCode]='165374005' OR [reasonCode]='165373004' OR [reasonCode]='165372009' OR [reasonCode]='165358000' OR [reasonCode]='165357005' OR [reasonCode]='165356001' OR [reasonCode]='165355002' OR [reasonCode]='165353009' OR [reasonCode]='165352004' OR [reasonCode]='165351006' OR [reasonCode]='165350007' OR [reasonCode]='165349007' OR [reasonCode]='165348004' OR [reasonCode]='165346000' OR [reasonCode]='165343008' OR [reasonCode]='165342003' OR [reasonCode]='165340006' OR [reasonCode]='165339009' OR [reasonCode]='165337006' OR [reasonCode]='165336002' OR [reasonCode]='165335003' OR [reasonCode]='165334004' OR [reasonCode]='165333005' OR [reasonCode]='165332000' OR [reasonCode]='165331007' OR [reasonCode]='165330008' OR [reasonCode]='165278005' OR [reasonCode]='165146006' OR [reasonCode]='165139002' OR [reasonCode]='165138005' OR [reasonCode]='165137000' OR [reasonCode]='165122004' OR [reasonCode]='165121006' OR [reasonCode]='165104002' OR [reasonCode]='165081006' OR [reasonCode]='165080007' OR [reasonCode]='165074004' OR [reasonCode]='165073005' OR [reasonCode]='165068004' OR [reasonCode]='165035006' OR [reasonCode]='165034005' OR [reasonCode]='165026004' OR [reasonCode]='165025000' OR [reasonCode]='165017002' OR [reasonCode]='165016006' OR [reasonCode]='165008002' OR [reasonCode]='165007007' OR [reasonCode]='164997006' OR [reasonCode]='164996002' OR [reasonCode]='164985005' OR [reasonCode]='164984009' OR [reasonCode]='164978006' OR [reasonCode]='164977001' OR [reasonCode]='164964005' OR [reasonCode]='164963004' OR [reasonCode]='164853006' OR [reasonCode]='164846002' OR [reasonCode]='164832002' OR [reasonCode]='164831009' OR [reasonCode]='164824005' OR [reasonCode]='164823004' OR [reasonCode]='164810006' OR [reasonCode]='164808009' OR [reasonCode]='164796008' OR [reasonCode]='164795007' OR [reasonCode]='164787008' OR [reasonCode]='164786004' OR [reasonCode]='164777009' OR [reasonCode]='164776000' OR [reasonCode]='164767007' OR [reasonCode]='164766003' OR [reasonCode]='164747003' OR [reasonCode]='164746007' OR [reasonCode]='164726002' OR [reasonCode]='164725003' OR [reasonCode]='164719002' OR [reasonCode]='164715008' OR [reasonCode]='164713001' OR [reasonCode]='164695000' OR [reasonCode]='164689001' OR [reasonCode]='164682005' OR [reasonCode]='164618002' OR [reasonCode]='164598006' OR [reasonCode]='164588000' OR [reasonCode]='164574004' OR [reasonCode]='164558009' OR [reasonCode]='164549002' OR [reasonCode]='164525000' OR [reasonCode]='164507007' OR [reasonCode]='164503006' OR [reasonCode]='164445005' OR [reasonCode]='164415007' OR [reasonCode]='164406000' OR [reasonCode]='164400006' OR [reasonCode]='164396006' OR [reasonCode]='164390000' OR [reasonCode]='164384004' OR [reasonCode]='164380008' OR [reasonCode]='164377007' OR [reasonCode]='164376003' OR [reasonCode]='164372001' OR [reasonCode]='164366001' OR [reasonCode]='164362004' OR [reasonCode]='164355008' OR [reasonCode]='164348006' OR [reasonCode]='164344008' OR [reasonCode]='164340004' OR [reasonCode]='164336008' OR [reasonCode]='164333000' OR [reasonCode]='164332005' OR [reasonCode]='164329007' OR [reasonCode]='164321005' OR [reasonCode]='164286000' OR [reasonCode]='164273009' OR [reasonCode]='164220009' OR [reasonCode]='164212007' OR [reasonCode]='164183004' OR [reasonCode]='164176006' OR [reasonCode]='164163000' OR [reasonCode]='164140005' OR [reasonCode]='164073000' OR [reasonCode]='164041006' OR [reasonCode]='164016004' OR [reasonCode]='163918007' OR [reasonCode]='163915005' OR [reasonCode]='163913003' OR [reasonCode]='163909005' OR [reasonCode]='163904000' OR [reasonCode]='163900009' OR [reasonCode]='163846005' OR [reasonCode]='163773004' OR [reasonCode]='163772009' OR [reasonCode]='163764007' OR [reasonCode]='163763001' OR [reasonCode]='163757005' OR [reasonCode]='163731007' OR [reasonCode]='163663006' OR [reasonCode]='163657002' OR [reasonCode]='163631000' OR [reasonCode]='163628001' OR [reasonCode]='163599009' OR [reasonCode]='163589004' OR [reasonCode]='163582008' OR [reasonCode]='163581001' OR [reasonCode]='163560001' OR [reasonCode]='163557008' OR [reasonCode]='163543006' OR [reasonCode]='163536000' OR [reasonCode]='163492003' OR [reasonCode]='163466005' OR [reasonCode]='163458001' OR [reasonCode]='163423003' OR [reasonCode]='163375008' OR [reasonCode]='163361001' OR [reasonCode]='163355004' OR [reasonCode]='163354000' OR [reasonCode]='163348001' OR [reasonCode]='163347006' OR [reasonCode]='163316000' OR [reasonCode]='163310006' OR [reasonCode]='163279004' OR [reasonCode]='163271001' OR [reasonCode]='163266008' OR [reasonCode]='163253008' OR [reasonCode]='163249006' OR [reasonCode]='163237005' OR [reasonCode]='163225008' OR [reasonCode]='163213005' OR [reasonCode]='163207001' OR [reasonCode]='163198005' OR [reasonCode]='163142005' OR [reasonCode]='163128002' OR [reasonCode]='163127007' OR [reasonCode]='163088002' OR [reasonCode]='163084000' OR [reasonCode]='163068001' OR [reasonCode]='163048007' OR [reasonCode]='163047002' OR [reasonCode]='163046006' OR [reasonCode]='163045005' OR [reasonCode]='162980001' OR [reasonCode]='162979004' OR [reasonCode]='162972008' OR [reasonCode]='162971001' OR [reasonCode]='162963000' OR [reasonCode]='162882008' OR [reasonCode]='162881001' OR [reasonCode]='162838004' OR [reasonCode]='162811006' OR [reasonCode]='162784002' OR [reasonCode]='162780006' OR [reasonCode]='162675007' OR [reasonCode]='162674006' OR [reasonCode]='162655003' OR [reasonCode]='162654004' OR [reasonCode]='162653005' OR [reasonCode]='162651007' OR [reasonCode]='162650008' OR [reasonCode]='162649008' OR [reasonCode]='162596006' OR [reasonCode]='162594009' OR [reasonCode]='162593003' OR [reasonCode]='162592008' OR [reasonCode]='162591001' OR [reasonCode]='162573006' OR [reasonCode]='162572001' OR [reasonCode]='162467007' OR [reasonCode]='162406001' OR [reasonCode]='162395006' OR [reasonCode]='162388002' OR [reasonCode]='162387007' OR [reasonCode]='162379006' OR [reasonCode]='162376004' OR [reasonCode]='162372002' OR [reasonCode]='162368001' OR [reasonCode]='162364004' OR [reasonCode]='162363005' OR [reasonCode]='162358006' OR [reasonCode]='162357001' OR [reasonCode]='162350004' OR [reasonCode]='162342008' OR [reasonCode]='162298006' OR [reasonCode]='162293002' OR [reasonCode]='162275003' OR [reasonCode]='162271007' OR [reasonCode]='162264002' OR [reasonCode]='162261005' OR [reasonCode]='162260006' OR [reasonCode]='162258009' OR [reasonCode]='162241004' OR [reasonCode]='162235006' OR [reasonCode]='162185007' OR [reasonCode]='162162006' OR [reasonCode]='162161004' OR [reasonCode]='162158000' OR [reasonCode]='162157005' OR [reasonCode]='162154003' OR [reasonCode]='162139009' OR [reasonCode]='162111008' OR [reasonCode]='162104009' OR [reasonCode]='162086005' OR [reasonCode]='162085009' OR [reasonCode]='162075008' OR [reasonCode]='162069004' OR [reasonCode]='162062008' OR [reasonCode]='162057007' OR [reasonCode]='162056003' OR [reasonCode]='162037008' OR [reasonCode]='162023004' OR [reasonCode]='162019007' OR [reasonCode]='162010006' OR [reasonCode]='162005007' OR [reasonCode]='162001003' OR [reasonCode]='161980004' OR [reasonCode]='161971004' OR [reasonCode]='161966006' OR [reasonCode]='161962008' OR [reasonCode]='161954000' OR [reasonCode]='161953006' OR [reasonCode]='161938003' OR [reasonCode]='161928008' OR [reasonCode]='161927003' OR [reasonCode]='161922009' OR [reasonCode]='161915001' OR [reasonCode]='161890006' OR [reasonCode]='161886009' OR [reasonCode]='161881004' OR [reasonCode]='161869003' OR [reasonCode]='161851007' OR [reasonCode]='161813007' OR [reasonCode]='161811009' OR [reasonCode]='161810005' OR [reasonCode]='161809000' OR [reasonCode]='161808008' OR [reasonCode]='161807003' OR [reasonCode]='161806007' OR [reasonCode]='161805006' OR [reasonCode]='161804005' OR [reasonCode]='161803004' OR [reasonCode]='161800001' OR [reasonCode]='161798008' OR [reasonCode]='161797003' OR [reasonCode]='161796007' OR [reasonCode]='161794005' OR [reasonCode]='161792009' OR [reasonCode]='161788002' OR [reasonCode]='161787007' OR [reasonCode]='161786003' OR [reasonCode]='161783006' OR [reasonCode]='161782001' OR [reasonCode]='161781008' OR [reasonCode]='161780009' OR [reasonCode]='161779006' OR [reasonCode]='161775000' OR [reasonCode]='161774001' OR [reasonCode]='161773007' OR [reasonCode]='161772002' OR [reasonCode]='161769009' OR [reasonCode]='161768001' OR [reasonCode]='161767006' OR [reasonCode]='161765003' OR [reasonCode]='161763005' OR [reasonCode]='161755009' OR [reasonCode]='161752007' OR [reasonCode]='161751000' OR [reasonCode]='161750004' OR [reasonCode]='161749004' OR [reasonCode]='161748007' OR [reasonCode]='161747002' OR [reasonCode]='161745005' OR [reasonCode]='161744009' OR [reasonCode]='161743003' OR [reasonCode]='161701005' OR [reasonCode]='161700006' OR [reasonCode]='161697007' OR [reasonCode]='161696003' OR [reasonCode]='161694000' OR [reasonCode]='161693006' OR [reasonCode]='161692001' OR [reasonCode]='161689000' OR [reasonCode]='161687003' OR [reasonCode]='161686007' OR [reasonCode]='161685006' OR [reasonCode]='161682009' OR [reasonCode]='161681002' OR [reasonCode]='161680001' OR [reasonCode]='161679004' OR [reasonCode]='161678007' OR [reasonCode]='161677002' OR [reasonCode]='161676006' OR [reasonCode]='161675005' OR [reasonCode]='161674009' OR [reasonCode]='161672008' OR [reasonCode]='161671001' OR [reasonCode]='161670000' OR [reasonCode]='161669001' OR [reasonCode]='161668009' OR [reasonCode]='161667004' OR [reasonCode]='161666008' OR [reasonCode]='161665007' OR [reasonCode]='161664006' OR [reasonCode]='161663000' OR [reasonCode]='161660002' OR [reasonCode]='161659007' OR [reasonCode]='161656000' OR [reasonCode]='161653008' OR [reasonCode]='161652003' OR [reasonCode]='161651005' OR [reasonCode]='161650006' OR [reasonCode]='161649006' OR [reasonCode]='161648003' OR [reasonCode]='161647008' OR [reasonCode]='161646004' OR [reasonCode]='161638000' OR [reasonCode]='161637005' OR [reasonCode]='161636001' OR [reasonCode]='161635002' OR [reasonCode]='161633009' OR [reasonCode]='161632004' OR [reasonCode]='161627000' OR [reasonCode]='161626009' OR [reasonCode]='161625008' OR [reasonCode]='161624007' OR [reasonCode]='161622006' OR [reasonCode]='161621004' OR [reasonCode]='161619009' OR [reasonCode]='161618001' OR [reasonCode]='161617006' OR [reasonCode]='161616002' OR [reasonCode]='161615003' OR [reasonCode]='161614004' OR [reasonCode]='161611007' OR [reasonCode]='161589007' OR [reasonCode]='161587009' OR [reasonCode]='161586000' OR [reasonCode]='161584002' OR [reasonCode]='161583008' OR [reasonCode]='161582003' OR [reasonCode]='161581005' OR [reasonCode]='161580006' OR [reasonCode]='161579008' OR [reasonCode]='161577005' OR [reasonCode]='161576001' OR [reasonCode]='161575002' OR [reasonCode]='161574003' OR [reasonCode]='161573009' OR [reasonCode]='161572004' OR [reasonCode]='161570007' OR [reasonCode]='161568003' OR [reasonCode]='161567008' OR [reasonCode]='161563007' OR [reasonCode]='161562002' OR [reasonCode]='161561009' OR [reasonCode]='161560005' OR [reasonCode]='161558008' OR [reasonCode]='161556007' OR [reasonCode]='161555006' OR [reasonCode]='161554005' OR [reasonCode]='161551002' OR [reasonCode]='161550001' OR [reasonCode]='161549001' OR [reasonCode]='161548009' OR [reasonCode]='161547004' OR [reasonCode]='161546008' OR [reasonCode]='161542005' OR [reasonCode]='161541003' OR [reasonCode]='161539004' OR [reasonCode]='161538007' OR [reasonCode]='161536006' OR [reasonCode]='161535005' OR [reasonCode]='161533003' OR [reasonCode]='161532008' OR [reasonCode]='161528002' OR [reasonCode]='161527007' OR [reasonCode]='161525004' OR [reasonCode]='161524000' OR [reasonCode]='161523006' OR [reasonCode]='161515009' OR [reasonCode]='161514008' OR [reasonCode]='161513002' OR [reasonCode]='161512007' OR [reasonCode]='161511000' OR [reasonCode]='161509009' OR [reasonCode]='161508001' OR [reasonCode]='161505003' OR [reasonCode]='161504004' OR [reasonCode]='161503005' OR [reasonCode]='161502000' OR [reasonCode]='161501007' OR [reasonCode]='161500008' OR [reasonCode]='161497002' OR [reasonCode]='161496006' OR [reasonCode]='161494009' OR [reasonCode]='161491001' OR [reasonCode]='161490000' OR [reasonCode]='161489009' OR [reasonCode]='161488001' OR [reasonCode]='161487006' OR [reasonCode]='161486002' OR [reasonCode]='161483005' OR [reasonCode]='161482000' OR [reasonCode]='161481007' OR [reasonCode]='161480008' OR [reasonCode]='161479005' OR [reasonCode]='161478002' OR [reasonCode]='161474000' OR [reasonCode]='161473006' OR [reasonCode]='161472001' OR [reasonCode]='161471008' OR [reasonCode]='161470009' OR [reasonCode]='161469008' OR [reasonCode]='161468000' OR [reasonCode]='161467005' OR [reasonCode]='161466001' OR [reasonCode]='161465002' OR [reasonCode]='161464003' OR [reasonCode]='161462004' OR [reasonCode]='161461006' OR [reasonCode]='161460007' OR [reasonCode]='161458005' OR [reasonCode]='161457000' OR [reasonCode]='161456009' OR [reasonCode]='161453001' OR [reasonCode]='161451004' OR [reasonCode]='161450003' OR [reasonCode]='161449003' OR [reasonCode]='161445009' OR [reasonCode]='161443002' OR [reasonCode]='161442007' OR [reasonCode]='161436008' OR [reasonCode]='161432005' OR [reasonCode]='161424002' OR [reasonCode]='161423008' OR [reasonCode]='161422003' OR [reasonCode]='161421005' OR [reasonCode]='161420006' OR [reasonCode]='161419000' OR [reasonCode]='161417003' OR [reasonCode]='161416007' OR [reasonCode]='161415006' OR [reasonCode]='161414005' OR [reasonCode]='161413004' OR [reasonCode]='161079000' OR [reasonCode]='161078008' OR [reasonCode]='161077003' OR [reasonCode]='161075006' OR [reasonCode]='161067000' OR [reasonCode]='161062006' OR [reasonCode]='160953001' OR [reasonCode]='160949003' OR [reasonCode]='160948006' OR [reasonCode]='160947001' OR [reasonCode]='160891002' OR [reasonCode]='160890001' OR [reasonCode]='160888002' OR [reasonCode]='160886003' OR [reasonCode]='160885004' OR [reasonCode]='160884000' OR [reasonCode]='160875000' OR [reasonCode]='160861007' OR [reasonCode]='160860008' OR [reasonCode]='160859003' OR [reasonCode]='160856005' OR [reasonCode]='160855009' OR [reasonCode]='160854008' OR [reasonCode]='160853002' OR [reasonCode]='160807009' OR [reasonCode]='160806000' OR [reasonCode]='160776008' OR [reasonCode]='160475008' OR [reasonCode]='160474007' OR [reasonCode]='160473001' OR [reasonCode]='160472006' OR [reasonCode]='160471004' OR [reasonCode]='160469004' OR [reasonCode]='160465005' OR [reasonCode]='160464009' OR [reasonCode]='160463003' OR [reasonCode]='160462008' OR [reasonCode]='160461001' OR [reasonCode]='160460000' OR [reasonCode]='160457007' OR [reasonCode]='160456003' OR [reasonCode]='160455004' OR [reasonCode]='160454000' OR [reasonCode]='160452001' OR [reasonCode]='160451008' OR [reasonCode]='160450009' OR [reasonCode]='160449009' OR [reasonCode]='160447006' OR [reasonCode]='160446002' OR [reasonCode]='160445003' OR [reasonCode]='160444004' OR [reasonCode]='160442000' OR [reasonCode]='160441007' OR [reasonCode]='160440008' OR [reasonCode]='160439006' OR [reasonCode]='160437008' OR [reasonCode]='160436004' OR [reasonCode]='160435000' OR [reasonCode]='160434001' OR [reasonCode]='160433007' OR [reasonCode]='160431009' OR [reasonCode]='160430005' OR [reasonCode]='160429000' OR [reasonCode]='160428008' OR [reasonCode]='160427003' OR [reasonCode]='160425006' OR [reasonCode]='160424005' OR [reasonCode]='160423004' OR [reasonCode]='160422009' OR [reasonCode]='160421002' OR [reasonCode]='160419007' OR [reasonCode]='160418004' OR [reasonCode]='160417009' OR [reasonCode]='160414002' OR [reasonCode]='160413008' OR [reasonCode]='160410006' OR [reasonCode]='160409001' OR [reasonCode]='160408009' OR [reasonCode]='160407004' OR [reasonCode]='160406008' OR [reasonCode]='160403000' OR [reasonCode]='160402005' OR [reasonCode]='160401003' OR [reasonCode]='160400002' OR [reasonCode]='160398001' OR [reasonCode]='160397006' OR [reasonCode]='160396002' OR [reasonCode]='160394004' OR [reasonCode]='160393005' OR [reasonCode]='160392000' OR [reasonCode]='160391007' OR [reasonCode]='160390008' OR [reasonCode]='160389004' OR [reasonCode]='160386006' OR [reasonCode]='160381001' OR [reasonCode]='160379003' OR [reasonCode]='160378006' OR [reasonCode]='160377001' OR [reasonCode]='160364005' OR [reasonCode]='160363004' OR [reasonCode]='160362009' OR [reasonCode]='160357008' OR [reasonCode]='160354001' OR [reasonCode]='160353007' OR [reasonCode]='160352002' OR [reasonCode]='160350005' OR [reasonCode]='160348002' OR [reasonCode]='160347007' OR [reasonCode]='160346003' OR [reasonCode]='160344000' OR [reasonCode]='160343006' OR [reasonCode]='160342001' OR [reasonCode]='160341008' OR [reasonCode]='160340009' OR [reasonCode]='160339007' OR [reasonCode]='160338004' OR [reasonCode]='160337009' OR [reasonCode]='160336000' OR [reasonCode]='160333008' OR [reasonCode]='160332003' OR [reasonCode]='160331005' OR [reasonCode]='160329001' OR [reasonCode]='160328009' OR [reasonCode]='160327004' OR [reasonCode]='160325007' OR [reasonCode]='160324006' OR [reasonCode]='160321003' OR [reasonCode]='160320002' OR [reasonCode]='160319008' OR [reasonCode]='160318000' OR [reasonCode]='160316001' OR [reasonCode]='160314003' OR [reasonCode]='160313009' OR [reasonCode]='160312004' OR [reasonCode]='160311006' OR [reasonCode]='160310007' OR [reasonCode]='160309002' OR [reasonCode]='160308005' OR [reasonCode]='160306009' OR [reasonCode]='160305008' OR [reasonCode]='160303001' OR [reasonCode]='160302006' OR [reasonCode]='160301004' OR [reasonCode]='160299006' OR [reasonCode]='160298003' OR [reasonCode]='160297008' OR [reasonCode]='160292002' OR [reasonCode]='160291009' OR [reasonCode]='160290005' OR [reasonCode]='160288009' OR [reasonCode]='160282005' OR [reasonCode]='160281003' OR [reasonCode]='160280002' OR [reasonCode]='160279000' OR [reasonCode]='160274005' OR [reasonCode]='160273004' OR [reasonCode]='160271002' OR [reasonCode]='160270001' OR [reasonCode]='160269002' OR [reasonCode]='160268005' OR [reasonCode]='160267000' OR [reasonCode]='160266009' OR [reasonCode]='160265008' OR [reasonCode]='160259008' OR [reasonCode]='160258000' OR [reasonCode]='160257005' OR [reasonCode]='160256001' OR [reasonCode]='160255002' OR [reasonCode]='160254003' OR [reasonCode]='160253009' OR [reasonCode]='160252004' OR [reasonCode]='160250007' OR [reasonCode]='160245001' OR [reasonCode]='160242003' OR [reasonCode]='160241005' OR [reasonCode]='160240006' OR [reasonCode]='150159003' OR [reasonCode]='149129005' OR [reasonCode]='148477008' OR [reasonCode]='148324002' OR [reasonCode]='148297000' OR [reasonCode]='148176006' OR [reasonCode]='147022006' OR [reasonCode]='146922001' OR [reasonCode]='135879003' OR [reasonCode]='135866007' OR [reasonCode]='135844000' OR [reasonCode]='135826008' OR [reasonCode]='135825007' OR [reasonCode]='135823000' OR [reasonCode]='135822005' OR [reasonCode]='135814003' OR [reasonCode]='135812004' OR [reasonCode]='135811006' OR [reasonCode]='135809002' OR [reasonCode]='135808005' OR [reasonCode]='135807000' OR [reasonCode]='135806009' OR [reasonCode]='135805008' OR [reasonCode]='135803001' OR [reasonCode]='135801004' OR [reasonCode]='135800003' OR [reasonCode]='135799002' OR [reasonCode]='135798005' OR [reasonCode]='135797000' OR [reasonCode]='135796009' OR [reasonCode]='135795008' OR [reasonCode]='135794007' OR [reasonCode]='134439009' OR [reasonCode]='134420004' OR [reasonCode]='134405005' OR [reasonCode]='134398004' OR [reasonCode]='134397009' OR [reasonCode]='134396000' OR [reasonCode]='134394002' OR [reasonCode]='134392003' OR [reasonCode]='134391005' OR [reasonCode]='134390006' OR [reasonCode]='134386009' OR [reasonCode]='134385008' OR [reasonCode]='129125009' OR [reasonCode]='127377003' OR [reasonCode]='124746006' OR [reasonCode]='124745005' OR [reasonCode]='124744009' OR [reasonCode]='124743003' OR [reasonCode]='117101009' OR [reasonCode]='117100005' OR [reasonCode]='117099002' OR [reasonCode]='117098005' OR [reasonCode]='117097000' OR [reasonCode]='117094007' OR [reasonCode]='117091004' OR [reasonCode]='117088004' OR [reasonCode]='117084002' OR [reasonCode]='117082003' OR [reasonCode]='117080006' OR [reasonCode]='117079008' OR [reasonCode]='117077005' OR [reasonCode]='117068003' OR [reasonCode]='117067008' OR [reasonCode]='116866007' OR [reasonCode]='116864005' OR [reasonCode]='116862009' OR [reasonCode]='116860001' OR [reasonCode]='116814003' OR [reasonCode]='116811006' OR [reasonCode]='116809002' OR [reasonCode]='116807000' OR [reasonCode]='116804007' OR [reasonCode]='116801004' OR [reasonCode]='116799002' OR [reasonCode]='116796009' OR [reasonCode]='116794007' OR [reasonCode]='116791004' OR [reasonCode]='116789007' OR [reasonCode]='111690007' OR [reasonCode]='109723000' OR [reasonCode]='109719008' OR [reasonCode]='109547005' OR [reasonCode]='105480006' OR [reasonCode]='103709008' OR [reasonCode]='103006007' OR [reasonCode]='102905003' OR [reasonCode]='95819006' OR [reasonCode]='95721006' OR [reasonCode]='95672008' OR [reasonCode]='95667004' OR [reasonCode]='95314009' OR [reasonCode]='95313003' OR [reasonCode]='95312008' OR [reasonCode]='95311001' OR [reasonCode]='91559009' OR [reasonCode]='91436001' OR [reasonCode]='90881001' OR [reasonCode]='90232009' OR [reasonCode]='90075008' OR [reasonCode]='89777000' OR [reasonCode]='88994001' OR [reasonCode]='88764002' OR [reasonCode]='88715005' OR [reasonCode]='88500006' OR [reasonCode]='87351004' OR [reasonCode]='87246008' OR [reasonCode]='86914005' OR [reasonCode]='86894005' OR [reasonCode]='86699002' OR [reasonCode]='85125009' OR [reasonCode]='82630002' OR [reasonCode]='82120007' OR [reasonCode]='81993002' OR [reasonCode]='81765008' OR [reasonCode]='81585005' OR [reasonCode]='79622006' OR [reasonCode]='78698008' OR [reasonCode]='77739005' OR [reasonCode]='77670007' OR [reasonCode]='77291009' OR [reasonCode]='76063002' OR [reasonCode]='75844008' OR [reasonCode]='75584009' OR [reasonCode]='75538004' OR [reasonCode]='75151002' OR [reasonCode]='73487002' OR [reasonCode]='73359007' OR [reasonCode]='72604007' OR [reasonCode]='72375002' OR [reasonCode]='72269009' OR [reasonCode]='71738007' OR [reasonCode]='71101001' OR [reasonCode]='70790008' OR [reasonCode]='68034005' OR [reasonCode]='66678007' OR [reasonCode]='66325000' OR [reasonCode]='65329004' OR [reasonCode]='63196005' OR [reasonCode]='62965008' OR [reasonCode]='62696001' OR [reasonCode]='62232005' OR [reasonCode]='62120000' OR [reasonCode]='61269006' OR [reasonCode]='61236006' OR [reasonCode]='60801006' OR [reasonCode]='60521000' OR [reasonCode]='60016005' OR [reasonCode]='59738006' OR [reasonCode]='59383005' OR [reasonCode]='58064004' OR [reasonCode]='57600009' OR [reasonCode]='57177007' OR [reasonCode]='56330003' OR [reasonCode]='56199006' OR [reasonCode]='55993003' OR [reasonCode]='55726006' OR [reasonCode]='55618006' OR [reasonCode]='55493009' OR [reasonCode]='54897008' OR [reasonCode]='54267006' OR [reasonCode]='52787007' OR [reasonCode]='52278004' OR [reasonCode]='52018002' OR [reasonCode]='51738008' OR [reasonCode]='51436006' OR [reasonCode]='51435005' OR [reasonCode]='50433005' OR [reasonCode]='48994000' OR [reasonCode]='48591001' OR [reasonCode]='47768001' OR [reasonCode]='47426000' OR [reasonCode]='47354006' OR [reasonCode]='46508005' OR [reasonCode]='46029008' OR [reasonCode]='45780005' OR [reasonCode]='45145000' OR [reasonCode]='44473003' OR [reasonCode]='44442002' OR [reasonCode]='44409003' OR [reasonCode]='43000004' OR [reasonCode]='41769001' OR [reasonCode]='41518004' OR [reasonCode]='41302009' OR [reasonCode]='40893006' OR [reasonCode]='40462002' OR [reasonCode]='40220006' OR [reasonCode]='38897008' OR [reasonCode]='37012003' OR [reasonCode]='34189007' OR [reasonCode]='33993005' OR [reasonCode]='33678008' OR [reasonCode]='33543001' OR [reasonCode]='33159007' OR [reasonCode]='32001009' OR [reasonCode]='31518001' OR [reasonCode]='30459002' OR [reasonCode]='29450001' OR [reasonCode]='29150008' OR [reasonCode]='28281004' OR [reasonCode]='27139003' OR [reasonCode]='26684009' OR [reasonCode]='25007007' OR [reasonCode]='24609004' OR [reasonCode]='23125004' OR [reasonCode]='22964006' OR [reasonCode]='20729004' OR [reasonCode]='20210009' OR [reasonCode]='19853007' OR [reasonCode]='18385005' OR [reasonCode]='18253009' OR [reasonCode]='17862002' OR [reasonCode]='17397008' OR [reasonCode]='15274006' OR [reasonCode]='14252008' OR [reasonCode]='13117000' OR [reasonCode]='11981004' OR [reasonCode]='11363007' OR [reasonCode]='8115005' OR [reasonCode]='7729001' OR [reasonCode]='7335003' OR [reasonCode]='7185004' OR [reasonCode]='6192003' OR [reasonCode]='5761001' OR [reasonCode]='5462009' OR [reasonCode]='3267003' OR [reasonCode]='2769005' OR [reasonCode]='2636002' OR [reasonCode]='1807002' OR [reasonCode]='1296007' OR [reasonCode]='837001' OR [reasonCode]='702005' OR [reasonCode]='6670003' OR [reasonCode]='6668007' OR [reasonCode]='6665005' OR [reasonCode]='6661001' OR [reasonCode]='6658002' OR [reasonCode]='6657007' OR [reasonCode]='6656003' OR [reasonCode]='6650009' OR [reasonCode]='6639006' OR [reasonCode]='6634001' OR [reasonCode]='6622009' OR [reasonCode]='6615001' OR [reasonCode]='6614002' OR [reasonCode]='6601003' OR [reasonCode]='6589005' OR [reasonCode]='6585004' OR [reasonCode]='6568001' OR [reasonCode]='6567006' OR [reasonCode]='6563005' OR [reasonCode]='6562000' OR [reasonCode]='6556005' OR [reasonCode]='6555009' OR [reasonCode]='6547002' OR [reasonCode]='6543003' OR [reasonCode]='6536009' OR [reasonCode]='6535008' OR [reasonCode]='6527005' OR [reasonCode]='6521006' OR [reasonCode]='6519001' OR [reasonCode]='6506000' OR [reasonCode]='6502003' OR [reasonCode]='6499002' OR [reasonCode]='6491004' OR [reasonCode]='6487009' OR [reasonCode]='6486000' OR [reasonCode]='6480006' OR [reasonCode]='6473009' OR [reasonCode]='6470007' OR [reasonCode]='6466004' OR [reasonCode]='6465000' OR [reasonCode]='6444006' OR [reasonCode]='6443000' OR [reasonCode]='6439004' OR [reasonCode]='6438007' OR [reasonCode]='6434009' OR [reasonCode]='6433003' OR [reasonCode]='6429005' OR [reasonCode]='6419003' OR [reasonCode]='6403005' OR [reasonCode]='6402000' OR [reasonCode]='6399001' OR [reasonCode]='6397004' OR [reasonCode]='6396008' OR [reasonCode]='6388003' OR [reasonCode]='6385000' OR [reasonCode]='6384001' OR [reasonCode]='6370006' OR [reasonCode]='6363006' OR [reasonCode]='6361008' OR [reasonCode]='6358007' OR [reasonCode]='6355005' OR [reasonCode]='6354009' OR [reasonCode]='6353003' OR [reasonCode]='6343004' OR [reasonCode]='6339003' OR [reasonCode]='6337001' OR [reasonCode]='6319002' OR [reasonCode]='6309008' OR [reasonCode]='6307005' OR [reasonCode]='6295005' OR [reasonCode]='6289009' OR [reasonCode]='6286002' OR [reasonCode]='6274000' OR [reasonCode]='6271008' OR [reasonCode]='6255008' OR [reasonCode]='6240004' OR [reasonCode]='6238009' OR [reasonCode]='6231003' OR [reasonCode]='6227009' OR [reasonCode]='6226000' OR [reasonCode]='6225001' OR [reasonCode]='6221005' OR [reasonCode]='6213004' OR [reasonCode]='6205000' OR [reasonCode]='6200005' OR [reasonCode]='6198004' OR [reasonCode]='6195001' OR [reasonCode]='6190006' OR [reasonCode]='6189002' OR [reasonCode]='6188005' OR [reasonCode]='6187000' OR [reasonCode]='6177004' OR [reasonCode]='6166005' OR [reasonCode]='6164008' OR [reasonCode]='6161000' OR [reasonCode]='6159009' OR [reasonCode]='6157006' OR [reasonCode]='6148000' OR [reasonCode]='6146001' OR [reasonCode]='6143009' OR [reasonCode]='6133006' OR [reasonCode]='6130009' OR [reasonCode]='6127002' OR [reasonCode]='6126006' OR [reasonCode]='6125005' OR [reasonCode]='6119006' OR [reasonCode]='6108008' OR [reasonCode]='6100001' OR [reasonCode]='6092000' OR [reasonCode]='6082008' OR [reasonCode]='6069000' OR [reasonCode]='6063004' OR [reasonCode]='6035001' OR [reasonCode]='6029001' OR [reasonCode]='6026008' OR [reasonCode]='6025007' OR [reasonCode]='6019008' OR [reasonCode]='6007000' OR [reasonCode]='6005008' OR [reasonCode]='5998008' OR [reasonCode]='5997003' OR [reasonCode]='5995006' OR [reasonCode]='5992009' OR [reasonCode]='5986003' OR [reasonCode]='5983006' OR [reasonCode]='5971009' OR [reasonCode]='5966002' OR [reasonCode]='5961007' OR [reasonCode]='5947002' OR [reasonCode]='5930003' OR [reasonCode]='5925002' OR [reasonCode]='5902003' OR [reasonCode]='5897004' OR [reasonCode]='5894006' OR [reasonCode]='5892005' OR [reasonCode]='5880005' OR [reasonCode]='5870006' OR [reasonCode]='5865004' OR [reasonCode]='5857002' OR [reasonCode]='5846007' OR [reasonCode]='5845006' OR [reasonCode]='5832007' OR [reasonCode]='5823005' OR [reasonCode]='5821007' OR [reasonCode]='5818005' OR [reasonCode]='5812006' OR [reasonCode]='5809008' OR [reasonCode]='5807005' OR [reasonCode]='5806001' OR [reasonCode]='5796001' OR [reasonCode]='5789003' OR [reasonCode]='5787001' OR [reasonCode]='5785009' OR [reasonCode]='5781000' OR [reasonCode]='5777000' OR [reasonCode]='5771004' OR [reasonCode]='5760000' OR [reasonCode]='5745003' OR [reasonCode]='5738003' OR [reasonCode]='5733007' OR [reasonCode]='5731009' OR [reasonCode]='5728008' OR [reasonCode]='5726007' OR [reasonCode]='5722009' OR [reasonCode]='5721002' OR [reasonCode]='5694008' OR [reasonCode]='5690004' OR [reasonCode]='5687005' OR [reasonCode]='5671007' OR [reasonCode]='5669007' OR [reasonCode]='5663008' OR [reasonCode]='5651003' OR [reasonCode]='5648005' OR [reasonCode]='5638008' OR [reasonCode]='5636007' OR [reasonCode]='5632009' OR [reasonCode]='5621009' OR [reasonCode]='5616006' OR [reasonCode]='5608002' OR [reasonCode]='5586008' OR [reasonCode]='5572009' OR [reasonCode]='5571002' OR [reasonCode]='5570001' OR [reasonCode]='5556001' OR [reasonCode]='5551006' OR [reasonCode]='5545001' OR [reasonCode]='5536002' OR [reasonCode]='5521000' OR [reasonCode]='5517007' OR [reasonCode]='5506006' OR [reasonCode]='5489004' OR [reasonCode]='5486006' OR [reasonCode]='5482008' OR [reasonCode]='5479003' OR [reasonCode]='5460001' OR [reasonCode]='5457008' OR [reasonCode]='5456004' OR [reasonCode]='5452002' OR [reasonCode]='5447007' OR [reasonCode]='5446003' OR [reasonCode]='5433008' OR [reasonCode]='5431005' OR [reasonCode]='5429001' OR [reasonCode]='5422005' OR [reasonCode]='5419008' OR [reasonCode]='5415002' OR [reasonCode]='5407000' OR [reasonCode]='5402006' OR [reasonCode]='5393006' OR [reasonCode]='5391008' OR [reasonCode]='5384005' OR [reasonCode]='5373003' OR [reasonCode]='5357009' OR [reasonCode]='5348003' OR [reasonCode]='5342002' OR [reasonCode]='5338000' OR [reasonCode]='5337005' OR [reasonCode]='5328005' OR [reasonCode]='5326009' OR [reasonCode]='5317006' OR [reasonCode]='5316002' OR [reasonCode]='5304008' OR [reasonCode]='5298004' OR [reasonCode]='5290006' OR [reasonCode]='5282006' OR [reasonCode]='5273000' OR [reasonCode]='5270002' OR [reasonCode]='5267001' OR [reasonCode]='5264008' OR [reasonCode]='5246001' OR [reasonCode]='5245002' OR [reasonCode]='5243009' OR [reasonCode]='5233006' OR [reasonCode]='5216004' OR [reasonCode]='5212002' OR [reasonCode]='5191001' OR [reasonCode]='5190000' OR [reasonCode]='5186002' OR [reasonCode]='5184004' OR [reasonCode]='5182000' OR [reasonCode]='5176003' OR [reasonCode]='5165002' OR [reasonCode]='5162004' OR [reasonCode]='5161006' OR [reasonCode]='5154007' OR [reasonCode]='5151004' OR [reasonCode]='5147001' OR [reasonCode]='5135007' OR [reasonCode]='5131003' OR [reasonCode]='5130002' OR [reasonCode]='5123008' OR [reasonCode]='5121005' OR [reasonCode]='5119000' OR [reasonCode]='5113004' OR [reasonCode]='5110001' OR [reasonCode]='5105000' OR [reasonCode]='5091004' OR [reasonCode]='5065000' OR [reasonCode]='5057003' OR [reasonCode]='5055006' OR [reasonCode]='5048009' OR [reasonCode]='5034009' OR [reasonCode]='5032008' OR [reasonCode]='5025004' OR [reasonCode]='5022001' OR [reasonCode]='5021008' OR [reasonCode]='5019003' OR [reasonCode]='5016005' OR [reasonCode]='4993009' OR [reasonCode]='4992004' OR [reasonCode]='4987001' OR [reasonCode]='4976009' OR [reasonCode]='4974007' OR [reasonCode]='4970003' OR [reasonCode]='4966006' OR [reasonCode]='4957007' OR [reasonCode]='4934001' OR [reasonCode]='4930005' OR [reasonCode]='4929000' OR [reasonCode]='4914002' OR [reasonCode]='4904006' OR [reasonCode]='4903000' OR [reasonCode]='4902005' OR [reasonCode]='4895001' OR [reasonCode]='4891005' OR [reasonCode]='4877004' OR [reasonCode]='4862007' OR [reasonCode]='4849008' OR [reasonCode]='4847005' OR [reasonCode]='4829004' OR [reasonCode]='4827002' OR [reasonCode]='4820000' OR [reasonCode]='4815000' OR [reasonCode]='4811009' OR [reasonCode]='4804005' OR [reasonCode]='4784000' OR [reasonCode]='4772002' OR [reasonCode]='4770005' OR [reasonCode]='4765003' OR [reasonCode]='4764004' OR [reasonCode]='4758006' OR [reasonCode]='4756005' OR [reasonCode]='4737000' OR [reasonCode]='4734007' OR [reasonCode]='4727005' OR [reasonCode]='4719001' OR [reasonCode]='4713000' OR [reasonCode]='4712005' OR [reasonCode]='4707009' OR [reasonCode]='4701005' OR [reasonCode]='4699005' OR [reasonCode]='4694000' OR [reasonCode]='4692001' OR [reasonCode]='4691008' OR [reasonCode]='4672008' OR [reasonCode]='4671001' OR [reasonCode]='4670000' OR [reasonCode]='4660002' OR [reasonCode]='4642002' OR [reasonCode]='4640005' OR [reasonCode]='4636001' OR [reasonCode]='4626009' OR [reasonCode]='4625008' OR [reasonCode]='4613005' OR [reasonCode]='4594007' OR [reasonCode]='4593001' OR [reasonCode]='4589007' OR [reasonCode]='4587009' OR [reasonCode]='4585001' OR [reasonCode]='4581005' OR [reasonCode]='4579008' OR [reasonCode]='4570007' OR [reasonCode]='4563007' OR [reasonCode]='4558008' OR [reasonCode]='4544006' OR [reasonCode]='4542005' OR [reasonCode]='4539004' OR [reasonCode]='4535005' OR [reasonCode]='4533003' OR [reasonCode]='4525004' OR [reasonCode]='4520009' OR [reasonCode]='4516005' OR [reasonCode]='4511000' OR [reasonCode]='4507006' OR [reasonCode]='4505003' OR [reasonCode]='4504004' OR [reasonCode]='4503005' OR [reasonCode]='4496006' OR [reasonCode]='4489009' OR [reasonCode]='4487006' OR [reasonCode]='4475004' OR [reasonCode]='4467005' OR [reasonCode]='4466001' OR [reasonCode]='4457000' OR [reasonCode]='4455008' OR [reasonCode]='4450003' OR [reasonCode]='4449003' OR [reasonCode]='4447001' OR [reasonCode]='4443002' OR [reasonCode]='4438009' OR [reasonCode]='4436008' OR [reasonCode]='4424002' OR [reasonCode]='4420006' OR [reasonCode]='4411002' OR [reasonCode]='4407008' OR [reasonCode]='4388000' OR [reasonCode]='4387005' OR [reasonCode]='4380007' OR [reasonCode]='4365001' OR [reasonCode]='4363008' OR [reasonCode]='4350002' OR [reasonCode]='4348005' OR [reasonCode]='4344007' OR [reasonCode]='4341004' OR [reasonCode]='4339000' OR [reasonCode]='4337003' OR [reasonCode]='4336007' OR [reasonCode]='4333004' OR [reasonCode]='4331002' OR [reasonCode]='4323007' OR [reasonCode]='4321009' OR [reasonCode]='4319004' OR [reasonCode]='4304000' OR [reasonCode]='4293000' OR [reasonCode]='4285000' OR [reasonCode]='4266003' OR [reasonCode]='4263006' OR [reasonCode]='4252008' OR [reasonCode]='4226002' OR [reasonCode]='4214007' OR [reasonCode]='4213001' OR [reasonCode]='4192000' OR [reasonCode]='4176005' OR [reasonCode]='4165006' OR [reasonCode]='4154001' OR [reasonCode]='4149005' OR [reasonCode]='4143006' OR [reasonCode]='4139007' OR [reasonCode]='4134002' OR [reasonCode]='4131005' OR [reasonCode]='4119008' OR [reasonCode]='4116001' OR [reasonCode]='4114003' OR [reasonCode]='4102006' OR [reasonCode]='4101004' OR [reasonCode]='4094001' OR [reasonCode]='4090005' OR [reasonCode]='4084006' OR [reasonCode]='4083000' OR [reasonCode]='4068005' OR [reasonCode]='4064007' OR [reasonCode]='4052004' OR [reasonCode]='4045001' OR [reasonCode]='4044002' OR [reasonCode]='4037006' OR [reasonCode]='4036002' OR [reasonCode]='4035003' OR [reasonCode]='4034004' OR [reasonCode]='4027001' OR [reasonCode]='4010009' OR [reasonCode]='4008007' OR [reasonCode]='4007002' OR [reasonCode]='3998005' OR [reasonCode]='3991004' OR [reasonCode]='3985001' OR [reasonCode]='3981005' OR [reasonCode]='3980006' OR [reasonCode]='3971006' OR [reasonCode]='3969006' OR [reasonCode]='3968003' OR [reasonCode]='3967008' OR [reasonCode]='3963007' OR [reasonCode]='3957003' OR [reasonCode]='3955006' OR [reasonCode]='3942005' OR [reasonCode]='3938007' OR [reasonCode]='3936006' OR [reasonCode]='3929005' OR [reasonCode]='3926003' OR [reasonCode]='3918006' OR [reasonCode]='3917001' OR [reasonCode]='3915009' OR [reasonCode]='3911000' OR [reasonCode]='3907006' OR [reasonCode]='3895009' OR [reasonCode]='3891000' OR [reasonCode]='3889008' OR [reasonCode]='3887005' OR [reasonCode]='3881006' OR [reasonCode]='3880007' OR [reasonCode]='3864002' OR [reasonCode]='3862003' OR [reasonCode]='3861005' OR [reasonCode]='3858009' OR [reasonCode]='3843001' OR [reasonCode]='3831002' OR [reasonCode]='3828003' OR [reasonCode]='3826004' OR [reasonCode]='3819004' OR [reasonCode]='3802001' OR [reasonCode]='3799005' OR [reasonCode]='3796003' OR [reasonCode]='3794000' OR [reasonCode]='3787003' OR [reasonCode]='3786007' OR [reasonCode]='3784005' OR [reasonCode]='3780001' OR [reasonCode]='3778007' OR [reasonCode]='3770000' OR [reasonCode]='3758004' OR [reasonCode]='3749006' OR [reasonCode]='3748003' OR [reasonCode]='3740005' OR [reasonCode]='3735002' OR [reasonCode]='3734003' OR [reasonCode]='3717006' OR [reasonCode]='3713005' OR [reasonCode]='3701000' OR [reasonCode]='3700004' OR [reasonCode]='3697003' OR [reasonCode]='3691002' OR [reasonCode]='3690001' OR [reasonCode]='3688002' OR [reasonCode]='3686003' OR [reasonCode]='3683006' OR [reasonCode]='3673007' OR [reasonCode]='3669009' OR [reasonCode]='3666002' OR [reasonCode]='3664004' OR [reasonCode]='3659003' OR [reasonCode]='3654008' OR [reasonCode]='3651000' OR [reasonCode]='3625002' OR [reasonCode]='3620007' OR [reasonCode]='3607009' OR [reasonCode]='3605001' OR [reasonCode]='3580004' OR [reasonCode]='3575008' OR [reasonCode]='3564009' OR [reasonCode]='3562008' OR [reasonCode]='3559005' OR [reasonCode]='3546002' OR [reasonCode]='3527003' OR [reasonCode]='3518004' OR [reasonCode]='3517009' OR [reasonCode]='3515001' OR [reasonCode]='3512003' OR [reasonCode]='3509001' OR [reasonCode]='3499006' OR [reasonCode]='3498003' OR [reasonCode]='3479000' OR [reasonCode]='3457005' OR [reasonCode]='3450007' OR [reasonCode]='3448004' OR [reasonCode]='3443008' OR [reasonCode]='3432000' OR [reasonCode]='3418002' OR [reasonCode]='3413006' OR [reasonCode]='3407002' OR [reasonCode]='3399007' OR [reasonCode]='3390006' OR [reasonCode]='3360004' OR [reasonCode]='3357006' OR [reasonCode]='3352000' OR [reasonCode]='3338002' OR [reasonCode]='3333006' OR [reasonCode]='3328007' OR [reasonCode]='3326006' OR [reasonCode]='3324009' OR [reasonCode]='3320000' OR [reasonCode]='3287002' OR [reasonCode]='3278006' OR [reasonCode]='3270004' OR [reasonCode]='3268008' OR [reasonCode]='3258003' OR [reasonCode]='3257008' OR [reasonCode]='3256004' OR [reasonCode]='3251009' OR [reasonCode]='3249005' OR [reasonCode]='3241008' OR [reasonCode]='3204007' OR [reasonCode]='3190002' OR [reasonCode]='3186004' OR [reasonCode]='3183007' OR [reasonCode]='3177009' OR [reasonCode]='3166003' OR [reasonCode]='3165004' OR [reasonCode]='3164000' OR [reasonCode]='3162001' OR [reasonCode]='3143004' OR [reasonCode]='3137001' OR [reasonCode]='3133002' OR [reasonCode]='3130004' OR [reasonCode]='3116009' OR [reasonCode]='3112006' OR [reasonCode]='3090000' OR [reasonCode]='3088001' OR [reasonCode]='3083005' OR [reasonCode]='3078002' OR [reasonCode]='3075004' OR [reasonCode]='3063009' OR [reasonCode]='3061006' OR [reasonCode]='3060007' OR [reasonCode]='3047001' OR [reasonCode]='3041000' OR [reasonCode]='3029007' OR [reasonCode]='3026000' OR [reasonCode]='3025001' OR [reasonCode]='3016007' OR [reasonCode]='3010001' OR [reasonCode]='3001009' OR [reasonCode]='2977001' OR [reasonCode]='2971000' OR [reasonCode]='2970004' OR [reasonCode]='2968008' OR [reasonCode]='2960001' OR [reasonCode]='2947007' OR [reasonCode]='2945004' OR [reasonCode]='2933008' OR [reasonCode]='2915002' OR [reasonCode]='2914003' OR [reasonCode]='2908005' OR [reasonCode]='2903001' OR [reasonCode]='2898000' OR [reasonCode]='2891006' OR [reasonCode]='2885009' OR [reasonCode]='2876009' OR [reasonCode]='2875008' OR [reasonCode]='2866006' OR [reasonCode]='2857007' OR [reasonCode]='2854000' OR [reasonCode]='2851008' OR [reasonCode]='2847006' OR [reasonCode]='2843005' OR [reasonCode]='2842000' OR [reasonCode]='2837008' OR [reasonCode]='2813008' OR [reasonCode]='2811005' OR [reasonCode]='2802005' OR [reasonCode]='2794006' OR [reasonCode]='2780005' OR [reasonCode]='2752008' OR [reasonCode]='2745006' OR [reasonCode]='2743004' OR [reasonCode]='2742009' OR [reasonCode]='2737001' OR [reasonCode]='2732007' OR [reasonCode]='2731000' OR [reasonCode]='2722000' OR [reasonCode]='2716009' OR [reasonCode]='2697008' OR [reasonCode]='2696004' OR [reasonCode]='2693007' OR [reasonCode]='2690005' OR [reasonCode]='2677003' OR [reasonCode]='2673004' OR [reasonCode]='2670001' OR [reasonCode]='2668005' OR [reasonCode]='2659008' OR [reasonCode]='2658000' OR [reasonCode]='2646000' OR [reasonCode]='2645001' OR [reasonCode]='2644002' OR [reasonCode]='2643008' OR [reasonCode]='2642003' OR [reasonCode]='2632000' OR [reasonCode]='2629003' OR [reasonCode]='2619005' OR [reasonCode]='2616003' OR [reasonCode]='2614000' OR [reasonCode]='2613006' OR [reasonCode]='2607002' OR [reasonCode]='2601001' OR [reasonCode]='2598006' OR [reasonCode]='2580007' OR [reasonCode]='2567009' OR [reasonCode]='2566000' OR [reasonCode]='2564002' OR [reasonCode]='2552005' OR [reasonCode]='2547000' OR [reasonCode]='2536007' OR [reasonCode]='2535006' OR [reasonCode]='2531002' OR [reasonCode]='2530001' OR [reasonCode]='2517002' OR [reasonCode]='2514009' OR [reasonCode]='2508002' OR [reasonCode]='2507007' OR [reasonCode]='2498008' OR [reasonCode]='2494005' OR [reasonCode]='2488002' OR [reasonCode]='2486003' OR [reasonCode]='2480009' OR [reasonCode]='2475000' OR [reasonCode]='2474001' OR [reasonCode]='2461007' OR [reasonCode]='2459003' OR [reasonCode]='2458006' OR [reasonCode]='2457001' OR [reasonCode]='2455009' OR [reasonCode]='2448007' OR [reasonCode]='2442008' OR [reasonCode]='2425002' OR [reasonCode]='2409007' OR [reasonCode]='2408004' OR [reasonCode]='2407009' OR [reasonCode]='2406000' OR [reasonCode]='2393003' OR [reasonCode]='2386002' OR [reasonCode]='2382000' OR [reasonCode]='2373006' OR [reasonCode]='2371008' OR [reasonCode]='2364003' OR [reasonCode]='2347001' OR [reasonCode]='2344008' OR [reasonCode]='2337004' OR [reasonCode]='2322003' OR [reasonCode]='2321005' OR [reasonCode]='2318008' OR [reasonCode]='2315006' OR [reasonCode]='2290003' OR [reasonCode]='2279008' OR [reasonCode]='2278000' OR [reasonCode]='2276001' OR [reasonCode]='2270007' OR [reasonCode]='2267008' OR [reasonCode]='2266004' OR [reasonCode]='2252009' OR [reasonCode]='2250001' OR [reasonCode]='2244006' OR [reasonCode]='2242005' OR [reasonCode]='2238007' OR [reasonCode]='2234009' OR [reasonCode]='2225004' OR [reasonCode]='2220009' OR [reasonCode]='2214008' OR [reasonCode]='2199005' OR [reasonCode]='2196003' OR [reasonCode]='2193006' OR [reasonCode]='2188008' OR [reasonCode]='2181002' OR [reasonCode]='2178007' OR [reasonCode]='2171001' OR [reasonCode]='2166008' OR [reasonCode]='2164006' OR [reasonCode]='2161003' OR [reasonCode]='2153008' OR [reasonCode]='2137005' OR [reasonCode]='2127000' OR [reasonCode]='2119009' OR [reasonCode]='2115003' OR [reasonCode]='2098004' OR [reasonCode]='2080003' OR [reasonCode]='2079001' OR [reasonCode]='2078009' OR [reasonCode]='2069003' OR [reasonCode]='2067001' OR [reasonCode]='2054004' OR [reasonCode]='2051007' OR [reasonCode]='2021001' OR [reasonCode]='2002009' OR [reasonCode]='1999007' OR [reasonCode]='1995001' OR [reasonCode]='1983001' OR [reasonCode]='1966005' OR [reasonCode]='1958001' OR [reasonCode]='1950008' OR [reasonCode]='1924009' OR [reasonCode]='1917008' OR [reasonCode]='1907003' OR [reasonCode]='1906007' OR [reasonCode]='1889001' OR [reasonCode]='1879000' OR [reasonCode]='1876007' OR [reasonCode]='1872009' OR [reasonCode]='1871002' OR [reasonCode]='1870001' OR [reasonCode]='1868005' OR [reasonCode]='1866009' OR [reasonCode]='1862006' OR [reasonCode]='1861004' OR [reasonCode]='1859008' OR [reasonCode]='1854003' OR [reasonCode]='1844002' OR [reasonCode]='1836002' OR [reasonCode]='1830008' OR [reasonCode]='1820004' OR [reasonCode]='1813006' OR [reasonCode]='1811008' OR [reasonCode]='1805005' OR [reasonCode]='1801001' OR [reasonCode]='1788001' OR [reasonCode]='1787006' OR [reasonCode]='1784004' OR [reasonCode]='1775004' OR [reasonCode]='1774000' OR [reasonCode]='1770009' OR [reasonCode]='1759002' OR [reasonCode]='1757000' OR [reasonCode]='1753001' OR [reasonCode]='1747001' OR [reasonCode]='1746005' OR [reasonCode]='1730002' OR [reasonCode]='1713004' OR [reasonCode]='1712009' OR [reasonCode]='1709006' OR [reasonCode]='1704001' OR [reasonCode]='1702002' OR [reasonCode]='1699009' OR [reasonCode]='1691007' OR [reasonCode]='1689004' OR [reasonCode]='1683003' OR [reasonCode]='1680000' OR [reasonCode]='1678006' OR [reasonCode]='1677001' OR [reasonCode]='1669000' OR [reasonCode]='1653007' OR [reasonCode]='1651009' OR [reasonCode]='1645004' OR [reasonCode]='1640009' OR [reasonCode]='1638004' OR [reasonCode]='1636000' OR [reasonCode]='1616001' OR [reasonCode]='1615002' OR [reasonCode]='1614003' OR [reasonCode]='1602006' OR [reasonCode]='1597004' OR [reasonCode]='1596008' OR [reasonCode]='1585000' OR [reasonCode]='1583007' OR [reasonCode]='1578004' OR [reasonCode]='1577009' OR [reasonCode]='1576000' OR [reasonCode]='1559004' OR [reasonCode]='1555005' OR [reasonCode]='1550000' OR [reasonCode]='1533002' OR [reasonCode]='1529009' OR [reasonCode]='1505002' OR [reasonCode]='1501006' OR [reasonCode]='1500007' OR [reasonCode]='1494008' OR [reasonCode]='1457004' OR [reasonCode]='1455007' OR [reasonCode]='1453000' OR [reasonCode]='1449002' OR [reasonCode]='1440003' OR [reasonCode]='1431002' OR [reasonCode]='1417002' OR [reasonCode]='1414009' OR [reasonCode]='1413003' OR [reasonCode]='1411001' OR [reasonCode]='1410000' OR [reasonCode]='1407007' OR [reasonCode]='1399002' OR [reasonCode]='1398005' OR [reasonCode]='1390003' OR [reasonCode]='1385001' OR [reasonCode]='1366004' OR [reasonCode]='1358008' OR [reasonCode]='1352009' OR [reasonCode]='1347004' OR [reasonCode]='1339004' OR [reasonCode]='1337002' OR [reasonCode]='1329005' OR [reasonCode]='1328002' OR [reasonCode]='1327007' OR [reasonCode]='1324000' OR [reasonCode]='1316005' OR [reasonCode]='1315009' OR [reasonCode]='1299000' OR [reasonCode]='1292009' OR [reasonCode]='1279006' OR [reasonCode]='1278003' OR [reasonCode]='1267006' OR [reasonCode]='1266002' OR [reasonCode]='1258006' OR [reasonCode]='1253002' OR [reasonCode]='1251000' OR [reasonCode]='1238005' OR [reasonCode]='1237000' OR [reasonCode]='1235008' OR [reasonCode]='1227005' OR [reasonCode]='1225002' OR [reasonCode]='1209007' OR [reasonCode]='1198000' OR [reasonCode]='1186005' OR [reasonCode]='1181000' OR [reasonCode]='1176009' OR [reasonCode]='1163003' OR [reasonCode]='1133007' OR [reasonCode]='1127003' OR [reasonCode]='1121002' OR [reasonCode]='1119007' OR [reasonCode]='1115001' OR [reasonCode]='1104006' OR [reasonCode]='1103000' OR [reasonCode]='1093006' OR [reasonCode]='1084005' OR [reasonCode]='1071001' OR [reasonCode]='1054002' OR [reasonCode]='1048003' OR [reasonCode]='1044001' OR [reasonCode]='1043007' OR [reasonCode]='1042002' OR [reasonCode]='1041009' OR [reasonCode]='1036001' OR [reasonCode]='1035002' OR [reasonCode]='1032004' OR [reasonCode]='1029002' OR [reasonCode]='1021004' OR [reasonCode]='1019009' OR [reasonCode]='1008006' OR [reasonCode]='1001000' OR [reasonCode]='971009' OR [reasonCode]='969009' OR [reasonCode]='967006' OR [reasonCode]='956005' OR [reasonCode]='951000' OR [reasonCode]='948007' OR [reasonCode]='945005' OR [reasonCode]='941001' OR [reasonCode]='935008' OR [reasonCode]='926001' OR [reasonCode]='913000' OR [reasonCode]='911003' OR [reasonCode]='910002' OR [reasonCode]='897004' OR [reasonCode]='893000' OR [reasonCode]='881009' OR [reasonCode]='879007' OR [reasonCode]='870006' OR [reasonCode]='867007' OR [reasonCode]='853003' OR [reasonCode]='851001' OR [reasonCode]='831000' OR [reasonCode]='817000' OR [reasonCode]='814007' OR [reasonCode]='807005' OR [reasonCode]='791006' OR [reasonCode]='789003' OR [reasonCode]='767002' OR [reasonCode]='764009' OR [reasonCode]='762008' OR [reasonCode]='759005' OR [reasonCode]='754000' OR [reasonCode]='753006' OR [reasonCode]='746002' OR [reasonCode]='741007' OR [reasonCode]='730005' OR [reasonCode]='726007' OR [reasonCode]='722009' OR [reasonCode]='721002' OR [reasonCode]='712003' OR [reasonCode]='710006' OR [reasonCode]='697001' OR [reasonCode]='695009' OR [reasonCode]='687005' OR [reasonCode]='680007' OR [reasonCode]='676002' OR [reasonCode]='674004' OR [reasonCode]='673005' OR [reasonCode]='671007' OR [reasonCode]='670008' OR [reasonCode]='665001' OR [reasonCode]='657004' OR [reasonCode]='647000' OR [reasonCode]='645008' OR [reasonCode]='642006' OR [reasonCode]='637003' OR [reasonCode]='633004' OR [reasonCode]='629006' OR [reasonCode]='628003' OR [reasonCode]='625000' OR [reasonCode]='618007' OR [reasonCode]='617002' OR [reasonCode]='603006' OR [reasonCode]='574005' OR [reasonCode]='570001' OR [reasonCode]='559008' OR [reasonCode]='550007' OR [reasonCode]='549007' OR [reasonCode]='545001' OR [reasonCode]='543008' OR [reasonCode]='540006' OR [reasonCode]='535003' OR [reasonCode]='533005' OR [reasonCode]='531007' OR [reasonCode]='503003' OR [reasonCode]='497006' OR [reasonCode]='494004' OR [reasonCode]='493005' OR [reasonCode]='489004' OR [reasonCode]='474008' OR [reasonCode]='468008' OR [reasonCode]='463004' OR [reasonCode]='459006' OR [reasonCode]='456004' OR [reasonCode]='445004' OR [reasonCode]='435001' OR [reasonCode]='417005' OR [reasonCode]='406009' OR [reasonCode]='401004' OR [reasonCode]='389000' OR [reasonCode]='388008' OR [reasonCode]='374009' OR [reasonCode]='353008' OR [reasonCode]='352003' OR [reasonCode]='351005' OR [reasonCode]='348003' OR [reasonCode]='346004' OR [reasonCode]='342002' OR [reasonCode]='334003' OR [reasonCode]='316002' OR [reasonCode]='306005' OR [reasonCode]='295001' OR [reasonCode]='294002' OR [reasonCode]='285008' OR [reasonCode]='267001' OR [reasonCode]='262007' OR [reasonCode]='245002' OR [reasonCode]='243009' OR [reasonCode]='230009' OR [reasonCode]='197002' OR [reasonCode]='189009' OR [reasonCode]='176003' OR [reasonCode]='174000' OR [reasonCode]='170009' OR [reasonCode]='166001' OR [reasonCode]='160007' OR [reasonCode]='153001' OR [reasonCode]='146005' OR [reasonCode]='142007' OR [reasonCode]='135007' OR [reasonCode]='133000' OR [reasonCode]='128004' OR [reasonCode]='121005' OR [reasonCode]='119000' OR [reasonCode]='115006' OR [reasonCode]='104001' OR [reasonCode]='4483005' OR [reasonCode]='4481007' OR [reasonCode]='4478002' OR [reasonCode]='4477007' OR [reasonCode]='4473006' OR [reasonCode]='4470009' OR [reasonCode]='4468000' OR [reasonCode]='4465002' OR [reasonCode]='4464003' OR [reasonCode]='4463009' OR [reasonCode]='4461006' OR [reasonCode]='4451004' OR [reasonCode]='4448006' OR [reasonCode]='4445009' OR [reasonCode]='4441000' OR [reasonCode]='4439001' OR [reasonCode]='4434006' OR [reasonCode]='4426000' OR [reasonCode]='4418008' OR [reasonCode]='4416007' OR [reasonCode]='4414005' OR [reasonCode]='4412009' OR [reasonCode]='4410001' OR [reasonCode]='4409006' OR [reasonCode]='4406004' OR [reasonCode]='4403007' OR [reasonCode]='4399003' OR [reasonCode]='4397001' OR [reasonCode]='4390004' OR [reasonCode]='4386001' OR [reasonCode]='4381006' OR [reasonCode]='4374004' OR [reasonCode]='4373005' OR [reasonCode]='4367009' OR [reasonCode]='4364002' OR [reasonCode]='4359001' OR [reasonCode]='4356008' OR [reasonCode]='4354006' OR [reasonCode]='4349002' OR [reasonCode]='4340003' OR [reasonCode]='4338008' OR [reasonCode]='4332009' OR [reasonCode]='4325000' OR [reasonCode]='4324001' OR [reasonCode]='4320005' OR [reasonCode]='4316006' OR [reasonCode]='4313003' OR [reasonCode]='4310000' OR [reasonCode]='4308002' OR [reasonCode]='4307007' OR [reasonCode]='4306003' OR [reasonCode]='4301008' OR [reasonCode]='4300009' OR [reasonCode]='4294006' OR [reasonCode]='4287008' OR [reasonCode]='4283007' OR [reasonCode]='4278004' OR [reasonCode]='4275001' OR [reasonCode]='4273008' OR [reasonCode]='4269005' OR [reasonCode]='4264000' OR [reasonCode]='4262001' OR [reasonCode]='4260009' OR [reasonCode]='4251001' OR [reasonCode]='4249000' OR [reasonCode]='4248008' OR [reasonCode]='4244005' OR [reasonCode]='4242009' OR [reasonCode]='4241002' OR [reasonCode]='4240001' OR [reasonCode]='4237001' OR [reasonCode]='4232007' OR [reasonCode]='4229009' OR [reasonCode]='4225003' OR [reasonCode]='4224004' OR [reasonCode]='4223005' OR [reasonCode]='4210003' OR [reasonCode]='4208000' OR [reasonCode]='4199009' OR [reasonCode]='4197006' OR [reasonCode]='4195003' OR [reasonCode]='4191007' OR [reasonCode]='4184009' OR [reasonCode]='4183003' OR [reasonCode]='4181001' OR [reasonCode]='4178006' OR [reasonCode]='4175009' OR [reasonCode]='4174008' OR [reasonCode]='4170004' OR [reasonCode]='4168008' OR [reasonCode]='4160001' OR [reasonCode]='4152002' OR [reasonCode]='4142001' OR [reasonCode]='4136000' OR [reasonCode]='4135001' OR [reasonCode]='4129001' OR [reasonCode]='4127004' OR [reasonCode]='4124006' OR [reasonCode]='4120002' OR [reasonCode]='4113009' OR [reasonCode]='4107000' OR [reasonCode]='4106009' OR [reasonCode]='4103001' OR [reasonCode]='4092002' OR [reasonCode]='4089001' OR [reasonCode]='4088009' OR [reasonCode]='4082005' OR [reasonCode]='4075006' OR [reasonCode]='4070001' OR [reasonCode]='4069002' OR [reasonCode]='4063001' OR [reasonCode]='4062006' OR [reasonCode]='4046000' OR [reasonCode]='4041005' OR [reasonCode]='4040006' OR [reasonCode]='4039009' OR [reasonCode]='4038001' OR [reasonCode]='4030008' OR [reasonCode]='4026005' OR [reasonCode]='4022007' OR [reasonCode]='4017007' OR [reasonCode]='4016003' OR [reasonCode]='4009004' OR [reasonCode]='4006006' OR [reasonCode]='4004009' OR [reasonCode]='4003003' OR [reasonCode]='3999002' OR [reasonCode]='3993001' OR [reasonCode]='3987009' OR [reasonCode]='3978000' OR [reasonCode]='3975002' OR [reasonCode]='3972004' OR [reasonCode]='3951002' OR [reasonCode]='3950001' OR [reasonCode]='3947004' OR [reasonCode]='3944006' OR [reasonCode]='3939004' OR [reasonCode]='3928002' OR [reasonCode]='3914008' OR [reasonCode]='3913002' OR [reasonCode]='3909009' OR [reasonCode]='3908001' OR [reasonCode]='3903005' OR [reasonCode]='3902000' OR [reasonCode]='3900008' OR [reasonCode]='3899003' OR [reasonCode]='3886001' OR [reasonCode]='3885002' OR [reasonCode]='3873005' OR [reasonCode]='3859001' OR [reasonCode]='3855007' OR [reasonCode]='3845008' OR [reasonCode]='3841004' OR [reasonCode]='3830001' OR [reasonCode]='3827008' OR [reasonCode]='3820005' OR [reasonCode]='3815005' OR [reasonCode]='3798002' OR [reasonCode]='3797007' OR [reasonCode]='3783004' OR [reasonCode]='3763000' OR [reasonCode]='3762005' OR [reasonCode]='3760002' OR [reasonCode]='3759007' OR [reasonCode]='3756000' OR [reasonCode]='3755001' OR [reasonCode]='3754002' OR [reasonCode]='3752003' OR [reasonCode]='3751005' OR [reasonCode]='3750006' OR [reasonCode]='3747008' OR [reasonCode]='3745000' OR [reasonCode]='3744001' OR [reasonCode]='3738000' OR [reasonCode]='3736001' OR [reasonCode]='3733009' OR [reasonCode]='3723001' OR [reasonCode]='3720003' OR [reasonCode]='3716002' OR [reasonCode]='3712000' OR [reasonCode]='3705009' OR [reasonCode]='3704008' OR [reasonCode]='3703002' OR [reasonCode]='3699000' OR [reasonCode]='3696007' OR [reasonCode]='3681008' OR [reasonCode]='3680009' OR [reasonCode]='3677008' OR [reasonCode]='3662000' OR [reasonCode]='3660008' OR [reasonCode]='3657001' OR [reasonCode]='3652007' OR [reasonCode]='3650004' OR [reasonCode]='3649004' OR [reasonCode]='3644009' OR [reasonCode]='3642008' OR [reasonCode]='3641001' OR [reasonCode]='3640000' OR [reasonCode]='3639002' OR [reasonCode]='3634007' OR [reasonCode]='3633001' OR [reasonCode]='3611003' OR [reasonCode]='3598000' OR [reasonCode]='3591006' OR [reasonCode]='3590007' OR [reasonCode]='3589003' OR [reasonCode]='3586005' OR [reasonCode]='3585009' OR [reasonCode]='3577000' OR [reasonCode]='3571004' OR [reasonCode]='3570003' OR [reasonCode]='3560000' OR [reasonCode]='3558002' OR [reasonCode]='3549009' OR [reasonCode]='3548001' OR [reasonCode]='3545003' OR [reasonCode]='3544004' OR [reasonCode]='3542000' OR [reasonCode]='3539006' OR [reasonCode]='3533007' OR [reasonCode]='3531009' OR [reasonCode]='3530005' OR [reasonCode]='3529000' OR [reasonCode]='3528008' OR [reasonCode]='3519007' OR [reasonCode]='3514002' OR [reasonCode]='3511005' OR [reasonCode]='3507004' OR [reasonCode]='3506008' OR [reasonCode]='3505007' OR [reasonCode]='3503000' OR [reasonCode]='3502005' OR [reasonCode]='3500002' OR [reasonCode]='3487004' OR [reasonCode]='3483000' OR [reasonCode]='3482005' OR [reasonCode]='3480002' OR [reasonCode]='3474005' OR [reasonCode]='3472009' OR [reasonCode]='3469002' OR [reasonCode]='3468005' OR [reasonCode]='3464007' OR [reasonCode]='3461004' OR [reasonCode]='3458000' OR [reasonCode]='3456001' OR [reasonCode]='3449007' OR [reasonCode]='3446000' OR [reasonCode]='3441005' OR [reasonCode]='3439009' OR [reasonCode]='3434004' OR [reasonCode]='3427001' OR [reasonCode]='3426005' OR [reasonCode]='3424008' OR [reasonCode]='3421000' OR [reasonCode]='3419005' OR [reasonCode]='3415004' OR [reasonCode]='3401001' OR [reasonCode]='3398004' OR [reasonCode]='3393008' OR [reasonCode]='3391005' OR [reasonCode]='3387000' OR [reasonCode]='3381004' OR [reasonCode]='3376008' OR [reasonCode]='3368006' OR [reasonCode]='3358001' OR [reasonCode]='3355003' OR [reasonCode]='3345002' OR [reasonCode]='3344003' OR [reasonCode]='3331008' OR [reasonCode]='3327002' OR [reasonCode]='3323003' OR [reasonCode]='3321001' OR [reasonCode]='3310005' OR [reasonCode]='3308008' OR [reasonCode]='3305006' OR [reasonCode]='3304005' OR [reasonCode]='3303004' OR [reasonCode]='3298001' OR [reasonCode]='3291007' OR [reasonCode]='3289004' OR [reasonCode]='3286006' OR [reasonCode]='3283003' OR [reasonCode]='3282008' OR [reasonCode]='3277001' OR [reasonCode]='3276005' OR [reasonCode]='3275009' OR [reasonCode]='3274008' OR [reasonCode]='3272007' OR [reasonCode]='3263004' OR [reasonCode]='3261002' OR [reasonCode]='3259006' OR [reasonCode]='3254001' OR [reasonCode]='3253007' OR [reasonCode]='3239007' OR [reasonCode]='3238004' OR [reasonCode]='3230006' OR [reasonCode]='3229001' OR [reasonCode]='3228009' OR [reasonCode]='3219008' OR [reasonCode]='3218000' OR [reasonCode]='3217005' OR [reasonCode]='3214003' OR [reasonCode]='3208005' OR [reasonCode]='3200003' OR [reasonCode]='3199001' OR [reasonCode]='3185000' OR [reasonCode]='3168002' OR [reasonCode]='3163006' OR [reasonCode]='3160009' OR [reasonCode]='3158007' OR [reasonCode]='3144005' OR [reasonCode]='3140001' OR [reasonCode]='3135009' OR [reasonCode]='3129009' OR [reasonCode]='3119002' OR [reasonCode]='3110003' OR [reasonCode]='3109008' OR [reasonCode]='3105002' OR [reasonCode]='3098007' OR [reasonCode]='3097002' OR [reasonCode]='3095005' OR [reasonCode]='3094009' OR [reasonCode]='3089009' OR [reasonCode]='3084004' OR [reasonCode]='3073006' OR [reasonCode]='3072001' OR [reasonCode]='3071008' OR [reasonCode]='3067005' OR [reasonCode]='3059002' OR [reasonCode]='3053001' OR [reasonCode]='3044008' OR [reasonCode]='3038009' OR [reasonCode]='3033000' OR [reasonCode]='3032005' OR [reasonCode]='3023008' OR [reasonCode]='3021005' OR [reasonCode]='3019000' OR [reasonCode]='3018008' OR [reasonCode]='3014005' OR [reasonCode]='3013004' OR [reasonCode]='3009006' OR [reasonCode]='3006004' OR [reasonCode]='3004001' OR [reasonCode]='3002002' OR [reasonCode]='2999009' OR [reasonCode]='2994004' OR [reasonCode]='2992000' OR [reasonCode]='2990008' OR [reasonCode]='2989004' OR [reasonCode]='2981001' OR [reasonCode]='2978006' OR [reasonCode]='2973002' OR [reasonCode]='2972007' OR [reasonCode]='2967003' OR [reasonCode]='2965006' OR [reasonCode]='2955000' OR [reasonCode]='2951009' OR [reasonCode]='2946003' OR [reasonCode]='2940009' OR [reasonCode]='2935001' OR [reasonCode]='2929001' OR [reasonCode]='2919008' OR [reasonCode]='2918000' OR [reasonCode]='2917005' OR [reasonCode]='2912004' OR [reasonCode]='2910007' OR [reasonCode]='2904007' OR [reasonCode]='2902006' OR [reasonCode]='2901004' OR [reasonCode]='2900003' OR [reasonCode]='2899008' OR [reasonCode]='2897005' OR [reasonCode]='2893009' OR [reasonCode]='2884008' OR [reasonCode]='2858002' OR [reasonCode]='2856003' OR [reasonCode]='2853006' OR [reasonCode]='2850009' OR [reasonCode]='2840008' OR [reasonCode]='2838003' OR [reasonCode]='2836004' OR [reasonCode]='2835000' OR [reasonCode]='2831009' OR [reasonCode]='2829000' OR [reasonCode]='2828008' OR [reasonCode]='2825006' OR [reasonCode]='2819007' OR [reasonCode]='2818004' OR [reasonCode]='2816000' OR [reasonCode]='2815001' OR [reasonCode]='2808009' OR [reasonCode]='2807004' OR [reasonCode]='2806008' OR [reasonCode]='2805007' OR [reasonCode]='2790002' OR [reasonCode]='2786004' OR [reasonCode]='2783007' OR [reasonCode]='2782002' OR [reasonCode]='2781009' OR [reasonCode]='2776000' OR [reasonCode]='2775001' OR [reasonCode]='2772003' OR [reasonCode]='2770006' OR [reasonCode]='2764000' OR [reasonCode]='2761008' OR [reasonCode]='2751001' OR [reasonCode]='2749000' OR [reasonCode]='2740001' OR [reasonCode]='2736005' OR [reasonCode]='2733002' OR [reasonCode]='2725003' OR [reasonCode]='2724004' OR [reasonCode]='2713001' OR [reasonCode]='2707005' OR [reasonCode]='2704003' OR [reasonCode]='2694001' OR [reasonCode]='2689001' OR [reasonCode]='2683000' OR [reasonCode]='2665008' OR [reasonCode]='2663001' OR [reasonCode]='2657005' OR [reasonCode]='2655002' OR [reasonCode]='2651006' OR [reasonCode]='2640006' OR [reasonCode]='2638001' OR [reasonCode]='2634004' OR [reasonCode]='2630008' OR [reasonCode]='2625009' OR [reasonCode]='2624008' OR [reasonCode]='2622007' OR [reasonCode]='2618002' OR [reasonCode]='2615004' OR [reasonCode]='2606006' OR [reasonCode]='2602008' OR [reasonCode]='2593002' OR [reasonCode]='2591000' OR [reasonCode]='2589008' OR [reasonCode]='2585002' OR [reasonCode]='2584003' OR [reasonCode]='2583009' OR [reasonCode]='2582004' OR [reasonCode]='2581006' OR [reasonCode]='2576002' OR [reasonCode]='2562003' OR [reasonCode]='2560006' OR [reasonCode]='2556008' OR [reasonCode]='2554006' OR [reasonCode]='2541004' OR [reasonCode]='2538008' OR [reasonCode]='2534005' OR [reasonCode]='2532009' OR [reasonCode]='2528003' OR [reasonCode]='2526004' OR [reasonCode]='2523007' OR [reasonCode]='2521009' OR [reasonCode]='2518007' OR [reasonCode]='2513003' OR [reasonCode]='2506003' OR [reasonCode]='2496007' OR [reasonCode]='2495006' OR [reasonCode]='2492009' OR [reasonCode]='2477008' OR [reasonCode]='2473007' OR [reasonCode]='2472002' OR [reasonCode]='2471009' OR [reasonCode]='2470005' OR [reasonCode]='2469009' OR [reasonCode]='2463005' OR [reasonCode]='2452007' OR [reasonCode]='2443003' OR [reasonCode]='2439002' OR [reasonCode]='2438005' OR [reasonCode]='2437000' OR [reasonCode]='2435008' OR [reasonCode]='2432006' OR [reasonCode]='2420007' OR [reasonCode]='2419001' OR [reasonCode]='2418009' OR [reasonCode]='2415007' OR [reasonCode]='2403008' OR [reasonCode]='2398007' OR [reasonCode]='2396006' OR [reasonCode]='2391001' OR [reasonCode]='2390000' OR [reasonCode]='2388001' OR [reasonCode]='2385003' OR [reasonCode]='2374000' OR [reasonCode]='2367005' OR [reasonCode]='2366001' OR [reasonCode]='2365002' OR [reasonCode]='2359002' OR [reasonCode]='2355008' OR [reasonCode]='2351004' OR [reasonCode]='2341000' OR [reasonCode]='2339001' OR [reasonCode]='2326000' OR [reasonCode]='2314005' OR [reasonCode]='2312009' OR [reasonCode]='2308003' OR [reasonCode]='2307008' OR [reasonCode]='2304001' OR [reasonCode]='2303007' OR [reasonCode]='2301009' OR [reasonCode]='2298005' OR [reasonCode]='2296009' OR [reasonCode]='2295008' OR [reasonCode]='2284002' OR [reasonCode]='2268003' OR [reasonCode]='2261009' OR [reasonCode]='2256007' OR [reasonCode]='2251002' OR [reasonCode]='2245007' OR [reasonCode]='2243000' OR [reasonCode]='2241003' OR [reasonCode]='2239004' OR [reasonCode]='2237002' OR [reasonCode]='2231001' OR [reasonCode]='2229005' OR [reasonCode]='2228002' OR [reasonCode]='2224000' OR [reasonCode]='2219003' OR [reasonCode]='2217001' OR [reasonCode]='2216005' OR [reasonCode]='2213002' OR [reasonCode]='2204004' OR [reasonCode]='2202000' OR [reasonCode]='2198002' OR [reasonCode]='2186007' OR [reasonCode]='2177002' OR [reasonCode]='2176006' OR [reasonCode]='2170000' OR [reasonCode]='2169001' OR [reasonCode]='2167004' OR [reasonCode]='2158004' OR [reasonCode]='2149006' OR [reasonCode]='2145000' OR [reasonCode]='2138000' OR [reasonCode]='2136001' OR [reasonCode]='2134003' OR [reasonCode]='2132004' OR [reasonCode]='2129002' OR [reasonCode]='2128005' OR [reasonCode]='2121004' OR [reasonCode]='2120003' OR [reasonCode]='2116002' OR [reasonCode]='2114004' OR [reasonCode]='2109003' OR [reasonCode]='2107001' OR [reasonCode]='2103002' OR [reasonCode]='2102007' OR [reasonCode]='2094002' OR [reasonCode]='2091005' OR [reasonCode]='2089002' OR [reasonCode]='2087000' OR [reasonCode]='2073000' OR [reasonCode]='2070002' OR [reasonCode]='2066005' OR [reasonCode]='2065009' OR [reasonCode]='2061000' OR [reasonCode]='2058001' OR [reasonCode]='2055003' OR [reasonCode]='2053005' OR [reasonCode]='2043009' OR [reasonCode]='2041006' OR [reasonCode]='2040007' OR [reasonCode]='2036003' OR [reasonCode]='2032001' OR [reasonCode]='2028007' OR [reasonCode]='2024009' OR [reasonCode]='2012002' OR [reasonCode]='2004005' OR [reasonCode]='1989002' OR [reasonCode]='1988005' OR [reasonCode]='1981004' OR [reasonCode]='1980003' OR [reasonCode]='1979001' OR [reasonCode]='1977004' OR [reasonCode]='1973000' OR [reasonCode]='1967001' OR [reasonCode]='1965009' OR [reasonCode]='1963002' OR [reasonCode]='1961000' OR [reasonCode]='1959009' OR [reasonCode]='1955003' OR [reasonCode]='1954004' OR [reasonCode]='1953005' OR [reasonCode]='1943009' OR [reasonCode]='1939005' OR [reasonCode]='1938002' OR [reasonCode]='1926006' OR [reasonCode]='1922008' OR [reasonCode]='1909000' OR [reasonCode]='1908008' OR [reasonCode]='1903004' OR [reasonCode]='1899006' OR [reasonCode]='1897008' OR [reasonCode]='1896004' OR [reasonCode]='1892002' OR [reasonCode]='1881003' OR [reasonCode]='1869002' OR [reasonCode]='1865008' OR [reasonCode]='1860003' OR [reasonCode]='1858000' OR [reasonCode]='1857005' OR [reasonCode]='1856001' OR [reasonCode]='1855002' OR [reasonCode]='1852004' OR [reasonCode]='1848004' OR [reasonCode]='1847009' OR [reasonCode]='1845001' OR [reasonCode]='1837006' OR [reasonCode]='1835003' OR [reasonCode]='1833005' OR [reasonCode]='1829003' OR [reasonCode]='1828006' OR [reasonCode]='1826005' OR [reasonCode]='1824008' OR [reasonCode]='1822007' OR [reasonCode]='1821000' OR [reasonCode]='1816003' OR [reasonCode]='1794009' OR [reasonCode]='1779005' OR [reasonCode]='1778002' OR [reasonCode]='1777007' OR [reasonCode]='1776003' OR [reasonCode]='1771008' OR [reasonCode]='1769008' OR [reasonCode]='1767005' OR [reasonCode]='1763009' OR [reasonCode]='1761006' OR [reasonCode]='1755008' OR [reasonCode]='1748006' OR [reasonCode]='1744008' OR [reasonCode]='1742007' OR [reasonCode]='1739001' OR [reasonCode]='1735007' OR [reasonCode]='1734006' OR [reasonCode]='1724002' OR [reasonCode]='1723008' OR [reasonCode]='1717003' OR [reasonCode]='1714005' OR [reasonCode]='1708003' OR [reasonCode]='1705000' OR [reasonCode]='1703007' OR [reasonCode]='1698001' OR [reasonCode]='1694004' OR [reasonCode]='1686006' OR [reasonCode]='1685005' OR [reasonCode]='1682008' OR [reasonCode]='1679003' OR [reasonCode]='1674008' OR [reasonCode]='1671000' OR [reasonCode]='1670004' OR [reasonCode]='1667003' OR [reasonCode]='1663004' OR [reasonCode]='1658003' OR [reasonCode]='1657008' OR [reasonCode]='1654001' OR [reasonCode]='1648002' OR [reasonCode]='1647007' OR [reasonCode]='1639007' OR [reasonCode]='1608005' OR [reasonCode]='1606009' OR [reasonCode]='1593000' OR [reasonCode]='1592005' OR [reasonCode]='1588003' OR [reasonCode]='1567007' OR [reasonCode]='1563006' OR [reasonCode]='1556006' OR [reasonCode]='1551001' OR [reasonCode]='1544005' OR [reasonCode]='1542009' OR [reasonCode]='1539003' OR [reasonCode]='1538006' OR [reasonCode]='1534008' OR [reasonCode]='1532007' OR [reasonCode]='1531000' OR [reasonCode]='1525003' OR [reasonCode]='1523005' OR [reasonCode]='1521007' OR [reasonCode]='1519002' OR [reasonCode]='1518005' OR [reasonCode]='1515008' OR [reasonCode]='1512006' OR [reasonCode]='1499003' OR [reasonCode]='1493002' OR [reasonCode]='1492007' OR [reasonCode]='1489008' OR [reasonCode]='1488000' OR [reasonCode]='1486001' OR [reasonCode]='1482004' OR [reasonCode]='1479009' OR [reasonCode]='1478001' OR [reasonCode]='1475003' OR [reasonCode]='1474004' OR [reasonCode]='1469007' OR [reasonCode]='1447000' OR [reasonCode]='1430001' OR [reasonCode]='1427008' OR [reasonCode]='1426004' OR [reasonCode]='1419004' OR [reasonCode]='1418007' OR [reasonCode]='1415005' OR [reasonCode]='1412008' OR [reasonCode]='1402001' OR [reasonCode]='1395008' OR [reasonCode]='1393001' OR [reasonCode]='1388004' OR [reasonCode]='1387009' OR [reasonCode]='1386000' OR [reasonCode]='1384002' OR [reasonCode]='1383008' OR [reasonCode]='1380006' OR [reasonCode]='1378000' OR [reasonCode]='1376001' OR [reasonCode]='1372004' OR [reasonCode]='1370007' OR [reasonCode]='1367008' OR [reasonCode]='1363007' OR [reasonCode]='1361009' OR [reasonCode]='1356007' OR [reasonCode]='1351002' OR [reasonCode]='1345007' OR [reasonCode]='1343000' OR [reasonCode]='1335005' OR [reasonCode]='1332008' OR [reasonCode]='1323006' OR [reasonCode]='1318006' OR [reasonCode]='1317001' OR [reasonCode]='1310004' OR [reasonCode]='1308001' OR [reasonCode]='1297003' OR [reasonCode]='1287007' OR [reasonCode]='1286003' OR [reasonCode]='1284000' OR [reasonCode]='1283006' OR [reasonCode]='1282001' OR [reasonCode]='1280009' OR [reasonCode]='1271009' OR [reasonCode]='1264004' OR [reasonCode]='1261007' OR [reasonCode]='1259003' OR [reasonCode]='1240000' OR [reasonCode]='1239002' OR [reasonCode]='1232006' OR [reasonCode]='1230003' OR [reasonCode]='1214006' OR [reasonCode]='1212005' OR [reasonCode]='1208004' OR [reasonCode]='1207009' OR [reasonCode]='1203008' OR [reasonCode]='1201005' OR [reasonCode]='1197005' OR [reasonCode]='1196001' OR [reasonCode]='1194003' OR [reasonCode]='1192004' OR [reasonCode]='1184008' OR [reasonCode]='1168007' OR [reasonCode]='1156003' OR [reasonCode]='1155004' OR [reasonCode]='1152001' OR [reasonCode]='1151008' OR [reasonCode]='1150009' OR [reasonCode]='1145003' OR [reasonCode]='1141007' OR [reasonCode]='1140008' OR [reasonCode]='1139006' OR [reasonCode]='1135000' OR [reasonCode]='1134001' OR [reasonCode]='1131009' OR [reasonCode]='1126007' OR [reasonCode]='1125006' OR [reasonCode]='1124005' OR [reasonCode]='1116000' OR [reasonCode]='1112003' OR [reasonCode]='1111005' OR [reasonCode]='1108009' OR [reasonCode]='1107004' OR [reasonCode]='1102005' OR [reasonCode]='1089000' OR [reasonCode]='1085006' OR [reasonCode]='1079004' OR [reasonCode]='1077002' OR [reasonCode]='1074009' OR [reasonCode]='1073003' OR [reasonCode]='1070000' OR [reasonCode]='1059007' OR [reasonCode]='1055001' OR [reasonCode]='1051005' OR [reasonCode]='1046004' OR [reasonCode]='1045000' OR [reasonCode]='1038000' OR [reasonCode]='1034003' OR [reasonCode]='1033009' OR [reasonCode]='1031006' OR [reasonCode]='1027000' OR [reasonCode]='1023001' OR [reasonCode]='1020003' OR [reasonCode]='1003002' OR [reasonCode]='998008' OR [reasonCode]='991002' OR [reasonCode]='987007' OR [reasonCode]='984000' OR [reasonCode]='981008' OR [reasonCode]='978003' OR [reasonCode]='975000' OR [reasonCode]='965003' OR [reasonCode]='964004' OR [reasonCode]='962000' OR [reasonCode]='961007' OR [reasonCode]='954008' OR [reasonCode]='943003' OR [reasonCode]='934007' OR [reasonCode]='932006' OR [reasonCode]='931004' OR [reasonCode]='928000' OR [reasonCode]='919001' OR [reasonCode]='908004' OR [reasonCode]='904002' OR [reasonCode]='903008' OR [reasonCode]='899001' OR [reasonCode]='890002' OR [reasonCode]='888003' OR [reasonCode]='875001' OR [reasonCode]='874002' OR [reasonCode]='871005' OR [reasonCode]='865004' OR [reasonCode]='862001' OR [reasonCode]='857002' OR [reasonCode]='849000' OR [reasonCode]='845006' OR [reasonCode]='844005' OR [reasonCode]='843004' OR [reasonCode]='842009' OR [reasonCode]='841002' OR [reasonCode]='834008' OR [reasonCode]='832007' OR [reasonCode]='827006' OR [reasonCode]='825003' OR [reasonCode]='818005' OR [reasonCode]='816009' OR [reasonCode]='815008' OR [reasonCode]='813001' OR [reasonCode]='811004' OR [reasonCode]='805002' OR [reasonCode]='801006' OR [reasonCode]='799008' OR [reasonCode]='792004' OR [reasonCode]='788006' OR [reasonCode]='787001' OR [reasonCode]='786005' OR [reasonCode]='781000' OR [reasonCode]='776009' OR [reasonCode]='775008' OR [reasonCode]='758002' OR [reasonCode]='756003' OR [reasonCode]='755004' OR [reasonCode]='750009' OR [reasonCode]='736004' OR [reasonCode]='734001' OR [reasonCode]='733007' OR [reasonCode]='718004' OR [reasonCode]='715001' OR [reasonCode]='714002' OR [reasonCode]='703000' OR [reasonCode]='701003' OR [reasonCode]='685002' OR [reasonCode]='682004' OR [reasonCode]='675003' OR [reasonCode]='666000' OR [reasonCode]='664002' OR [reasonCode]='663008' OR [reasonCode]='658009' OR [reasonCode]='655007' OR [reasonCode]='652005' OR [reasonCode]='651003' OR [reasonCode]='649002' OR [reasonCode]='646009' OR [reasonCode]='643001' OR [reasonCode]='640003' OR [reasonCode]='634005' OR [reasonCode]='631002' OR [reasonCode]='626004' OR [reasonCode]='616006' OR [reasonCode]='615005' OR [reasonCode]='613003' OR [reasonCode]='610000' OR [reasonCode]='607007' OR [reasonCode]='602001' OR [reasonCode]='600009' OR [reasonCode]='599006' OR [reasonCode]='596004' OR [reasonCode]='590005' OR [reasonCode]='586008' OR [reasonCode]='568005' OR [reasonCode]='563001' OR [reasonCode]='555002' OR [reasonCode]='554003' OR [reasonCode]='548004' OR [reasonCode]='547009' OR [reasonCode]='539009' OR [reasonCode]='536002' OR [reasonCode]='527001' OR [reasonCode]='520004' OR [reasonCode]='518002' OR [reasonCode]='517007' OR [reasonCode]='504009' OR [reasonCode]='496002' OR [reasonCode]='490008' OR [reasonCode]='488007' OR [reasonCode]='486006' OR [reasonCode]='479003' OR [reasonCode]='470004' OR [reasonCode]='467003' OR [reasonCode]='460001' OR [reasonCode]='452002' OR [reasonCode]='450005' OR [reasonCode]='447007' OR [reasonCode]='443006' OR [reasonCode]='442001' OR [reasonCode]='440009' OR [reasonCode]='437009' OR [reasonCode]='431005' OR [reasonCode]='426008' OR [reasonCode]='409002' OR [reasonCode]='408005' OR [reasonCode]='407000' OR [reasonCode]='398002' OR [reasonCode]='387003' OR [reasonCode]='385006' OR [reasonCode]='383004' OR [reasonCode]='382009' OR [reasonCode]='378007' OR [reasonCode]='369001' OR [reasonCode]='368009' OR [reasonCode]='366008' OR [reasonCode]='364006' OR [reasonCode]='360002' OR [reasonCode]='359007' OR [reasonCode]='358004' OR [reasonCode]='357009' OR [reasonCode]='355001' OR [reasonCode]='349006' OR [reasonCode]='341009' OR [reasonCode]='335002' OR [reasonCode]='330007' OR [reasonCode]='324007' OR [reasonCode]='320003' OR [reasonCode]='317006' OR [reasonCode]='313005' OR [reasonCode]='310008' OR [reasonCode]='308006' OR [reasonCode]='303002' OR [reasonCode]='299007' OR [reasonCode]='297009' OR [reasonCode]='292003' OR [reasonCode]='290006' OR [reasonCode]='282006' OR [reasonCode]='281004' OR [reasonCode]='279001' OR [reasonCode]='276008' OR [reasonCode]='264008' OR [reasonCode]='258001' OR [reasonCode]='257006' OR [reasonCode]='253005' OR [reasonCode]='242004' OR [reasonCode]='241006' OR [reasonCode]='228007' OR [reasonCode]='223003' OR [reasonCode]='222008' OR [reasonCode]='219006' OR [reasonCode]='216004' OR [reasonCode]='208008' OR [reasonCode]='199004' OR [reasonCode]='198007' OR [reasonCode]='195005' OR [reasonCode]='193003' OR [reasonCode]='192008' OR [reasonCode]='188001' OR [reasonCode]='184004' OR [reasonCode]='183005' OR [reasonCode]='181007' OR [reasonCode]='179005' OR [reasonCode]='177007' OR [reasonCode]='175004' OR [reasonCode]='172001' OR [reasonCode]='171008' OR [reasonCode]='168000' OR [reasonCode]='165002' OR [reasonCode]='162004' OR [reasonCode]='151004' OR [reasonCode]='150003' OR [reasonCode]='147001' OR [reasonCode]='144008' OR [reasonCode]='140004' OR [reasonCode]='134006' OR [reasonCode]='129007' OR [reasonCode]='127009' OR [reasonCode]='122003' OR [reasonCode]='109006'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_EncounterResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_EncounterResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[class] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[serviceType] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[priority] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[encounterStart] [datetimeoffset](7) NULL,
	[encounterEnd] [datetimeoffset](7) NULL,
	[length] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[dischargeDisposition] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([class]='VR' OR [class]='SS' OR [class]='PRENC' OR [class]='OBSENC' OR [class]='NONAC' OR [class]='ACUTE' OR [class]='IMP' OR [class]='HH' OR [class]='FLD' OR [class]='EMER' OR [class]='AMB')),
	CHECK (([dischargeDisposition]='oth' OR [dischargeDisposition]='snf' OR [dischargeDisposition]='rehab' OR [dischargeDisposition]='psy' OR [dischargeDisposition]='exp' OR [dischargeDisposition]='aadvice' OR [dischargeDisposition]='long' OR [dischargeDisposition]='hosp' OR [dischargeDisposition]='other-hcf' OR [dischargeDisposition]='alt-home' OR [dischargeDisposition]='home')),
	CHECK (([priority]='CSR' OR [priority]='CSP' OR [priority]='CS' OR [priority]='UR' OR [priority]='UD' OR [priority]='T' OR [priority]='S' OR [priority]='RR' OR [priority]='R' OR [priority]='PRN' OR [priority]='P' OR [priority]='EM' OR [priority]='EL' OR [priority]='CR' OR [priority]='A')),
	CHECK (([serviceType]='629' OR [serviceType]='628' OR [serviceType]='627' OR [serviceType]='626' OR [serviceType]='625' OR [serviceType]='624' OR [serviceType]='623' OR [serviceType]='622' OR [serviceType]='621' OR [serviceType]='620' OR [serviceType]='619' OR [serviceType]='618' OR [serviceType]='617' OR [serviceType]='616' OR [serviceType]='615' OR [serviceType]='614' OR [serviceType]='613' OR [serviceType]='612' OR [serviceType]='611' OR [serviceType]='610' OR [serviceType]='609' OR [serviceType]='608' OR [serviceType]='607' OR [serviceType]='606' OR [serviceType]='605' OR [serviceType]='604' OR [serviceType]='603' OR [serviceType]='602' OR [serviceType]='601' OR [serviceType]='600' OR [serviceType]='599' OR [serviceType]='593' OR [serviceType]='591' OR [serviceType]='590' OR [serviceType]='589' OR [serviceType]='585' OR [serviceType]='584' OR [serviceType]='583' OR [serviceType]='582' OR [serviceType]='581' OR [serviceType]='580' OR [serviceType]='577' OR [serviceType]='576' OR [serviceType]='575' OR [serviceType]='574' OR [serviceType]='573' OR [serviceType]='572' OR [serviceType]='571' OR [serviceType]='570' OR [serviceType]='569' OR [serviceType]='568' OR [serviceType]='567' OR [serviceType]='566' OR [serviceType]='565' OR [serviceType]='564' OR [serviceType]='563' OR [serviceType]='562' OR [serviceType]='561' OR [serviceType]='560' OR [serviceType]='559' OR [serviceType]='558' OR [serviceType]='557' OR [serviceType]='556' OR [serviceType]='555' OR [serviceType]='554' OR [serviceType]='553' OR [serviceType]='552' OR [serviceType]='551' OR [serviceType]='550' OR [serviceType]='548' OR [serviceType]='547' OR [serviceType]='546' OR [serviceType]='545' OR [serviceType]='544' OR [serviceType]='543' OR [serviceType]='542' OR [serviceType]='541' OR [serviceType]='540' OR [serviceType]='539' OR [serviceType]='538' OR [serviceType]='537' OR [serviceType]='536' OR [serviceType]='535' OR [serviceType]='534' OR [serviceType]='533' OR [serviceType]='532' OR [serviceType]='531' OR [serviceType]='530' OR [serviceType]='514' OR [serviceType]='513' OR [serviceType]='510' OR [serviceType]='509' OR [serviceType]='508' OR [serviceType]='507' OR [serviceType]='506' OR [serviceType]='505' OR [serviceType]='504' OR [serviceType]='503' OR [serviceType]='502' OR [serviceType]='501' OR [serviceType]='500' OR [serviceType]='498' OR [serviceType]='497' OR [serviceType]='496' OR [serviceType]='495' OR [serviceType]='494' OR [serviceType]='493' OR [serviceType]='492' OR [serviceType]='491' OR [serviceType]='490' OR [serviceType]='489' OR [serviceType]='488' OR [serviceType]='486' OR [serviceType]='485' OR [serviceType]='484' OR [serviceType]='483' OR [serviceType]='482' OR [serviceType]='481' OR [serviceType]='480' OR [serviceType]='479' OR [serviceType]='478' OR [serviceType]='477' OR [serviceType]='476' OR [serviceType]='475' OR [serviceType]='474' OR [serviceType]='473' OR [serviceType]='472' OR [serviceType]='471' OR [serviceType]='470' OR [serviceType]='469' OR [serviceType]='468' OR [serviceType]='467' OR [serviceType]='466' OR [serviceType]='465' OR [serviceType]='464' OR [serviceType]='463' OR [serviceType]='462' OR [serviceType]='461' OR [serviceType]='460' OR [serviceType]='459' OR [serviceType]='458' OR [serviceType]='457' OR [serviceType]='456' OR [serviceType]='455' OR [serviceType]='454' OR [serviceType]='453' OR [serviceType]='452' OR [serviceType]='451' OR [serviceType]='450' OR [serviceType]='449' OR [serviceType]='448' OR [serviceType]='447' OR [serviceType]='446' OR [serviceType]='445' OR [serviceType]='444' OR [serviceType]='443' OR [serviceType]='442' OR [serviceType]='441' OR [serviceType]='440' OR [serviceType]='439' OR [serviceType]='438' OR [serviceType]='437' OR [serviceType]='436' OR [serviceType]='435' OR [serviceType]='434' OR [serviceType]='433' OR [serviceType]='432' OR [serviceType]='431' OR [serviceType]='430' OR [serviceType]='429' OR [serviceType]='428' OR [serviceType]='427' OR [serviceType]='426' OR [serviceType]='425' OR [serviceType]='424' OR [serviceType]='423' OR [serviceType]='422' OR [serviceType]='421' OR [serviceType]='420' OR [serviceType]='419' OR [serviceType]='418' OR [serviceType]='417' OR [serviceType]='416' OR [serviceType]='415' OR [serviceType]='414' OR [serviceType]='413' OR [serviceType]='412' OR [serviceType]='411' OR [serviceType]='410' OR [serviceType]='409' OR [serviceType]='408' OR [serviceType]='407' OR [serviceType]='406' OR [serviceType]='405' OR [serviceType]='404' OR [serviceType]='403' OR [serviceType]='402' OR [serviceType]='401' OR [serviceType]='400' OR [serviceType]='399' OR [serviceType]='398' OR [serviceType]='397' OR [serviceType]='396' OR [serviceType]='395' OR [serviceType]='394' OR [serviceType]='393' OR [serviceType]='392' OR [serviceType]='391' OR [serviceType]='390' OR [serviceType]='389' OR [serviceType]='388' OR [serviceType]='387' OR [serviceType]='386' OR [serviceType]='385' OR [serviceType]='384' OR [serviceType]='383' OR [serviceType]='382' OR [serviceType]='381' OR [serviceType]='380' OR [serviceType]='379' OR [serviceType]='378' OR [serviceType]='377' OR [serviceType]='376' OR [serviceType]='375' OR [serviceType]='374' OR [serviceType]='373' OR [serviceType]='372' OR [serviceType]='371' OR [serviceType]='370' OR [serviceType]='369' OR [serviceType]='368' OR [serviceType]='367' OR [serviceType]='366' OR [serviceType]='365' OR [serviceType]='364' OR [serviceType]='362' OR [serviceType]='361' OR [serviceType]='360' OR [serviceType]='359' OR [serviceType]='358' OR [serviceType]='357' OR [serviceType]='356' OR [serviceType]='355' OR [serviceType]='354' OR [serviceType]='353' OR [serviceType]='352' OR [serviceType]='351' OR [serviceType]='350' OR [serviceType]='349' OR [serviceType]='348' OR [serviceType]='347' OR [serviceType]='346' OR [serviceType]='345' OR [serviceType]='344' OR [serviceType]='343' OR [serviceType]='342' OR [serviceType]='341' OR [serviceType]='340' OR [serviceType]='339' OR [serviceType]='338' OR [serviceType]='337' OR [serviceType]='336' OR [serviceType]='335' OR [serviceType]='334' OR [serviceType]='333' OR [serviceType]='332' OR [serviceType]='331' OR [serviceType]='330' OR [serviceType]='328' OR [serviceType]='327' OR [serviceType]='326' OR [serviceType]='325' OR [serviceType]='324' OR [serviceType]='323' OR [serviceType]='322' OR [serviceType]='321' OR [serviceType]='320' OR [serviceType]='319' OR [serviceType]='318' OR [serviceType]='317' OR [serviceType]='316' OR [serviceType]='315' OR [serviceType]='314' OR [serviceType]='313' OR [serviceType]='312' OR [serviceType]='311' OR [serviceType]='310' OR [serviceType]='309' OR [serviceType]='308' OR [serviceType]='307' OR [serviceType]='306' OR [serviceType]='305' OR [serviceType]='304' OR [serviceType]='303' OR [serviceType]='302' OR [serviceType]='301' OR [serviceType]='300' OR [serviceType]='299' OR [serviceType]='298' OR [serviceType]='297' OR [serviceType]='296' OR [serviceType]='295' OR [serviceType]='294' OR [serviceType]='293' OR [serviceType]='292' OR [serviceType]='291' OR [serviceType]='290' OR [serviceType]='289' OR [serviceType]='288' OR [serviceType]='287' OR [serviceType]='286' OR [serviceType]='285' OR [serviceType]='284' OR [serviceType]='283' OR [serviceType]='282' OR [serviceType]='281' OR [serviceType]='280' OR [serviceType]='279' OR [serviceType]='278' OR [serviceType]='277' OR [serviceType]='276' OR [serviceType]='275' OR [serviceType]='274' OR [serviceType]='273' OR [serviceType]='272' OR [serviceType]='271' OR [serviceType]='270' OR [serviceType]='269' OR [serviceType]='268' OR [serviceType]='267' OR [serviceType]='266' OR [serviceType]='265' OR [serviceType]='264' OR [serviceType]='263' OR [serviceType]='262' OR [serviceType]='261' OR [serviceType]='260' OR [serviceType]='259' OR [serviceType]='258' OR [serviceType]='257' OR [serviceType]='256' OR [serviceType]='255' OR [serviceType]='254' OR [serviceType]='253' OR [serviceType]='252' OR [serviceType]='251' OR [serviceType]='250' OR [serviceType]='249' OR [serviceType]='248' OR [serviceType]='247' OR [serviceType]='246' OR [serviceType]='245' OR [serviceType]='244' OR [serviceType]='243' OR [serviceType]='242' OR [serviceType]='241' OR [serviceType]='240' OR [serviceType]='239' OR [serviceType]='238' OR [serviceType]='237' OR [serviceType]='236' OR [serviceType]='235' OR [serviceType]='234' OR [serviceType]='233' OR [serviceType]='232' OR [serviceType]='231' OR [serviceType]='230' OR [serviceType]='229' OR [serviceType]='228' OR [serviceType]='227' OR [serviceType]='226' OR [serviceType]='225' OR [serviceType]='224' OR [serviceType]='223' OR [serviceType]='222' OR [serviceType]='221' OR [serviceType]='220' OR [serviceType]='219' OR [serviceType]='218' OR [serviceType]='217' OR [serviceType]='216' OR [serviceType]='215' OR [serviceType]='214' OR [serviceType]='213' OR [serviceType]='212' OR [serviceType]='211' OR [serviceType]='210' OR [serviceType]='209' OR [serviceType]='208' OR [serviceType]='207' OR [serviceType]='206' OR [serviceType]='205' OR [serviceType]='204' OR [serviceType]='203' OR [serviceType]='202' OR [serviceType]='201' OR [serviceType]='200' OR [serviceType]='199' OR [serviceType]='198' OR [serviceType]='197' OR [serviceType]='196' OR [serviceType]='195' OR [serviceType]='194' OR [serviceType]='193' OR [serviceType]='192' OR [serviceType]='191' OR [serviceType]='190' OR [serviceType]='189' OR [serviceType]='188' OR [serviceType]='187' OR [serviceType]='186' OR [serviceType]='185' OR [serviceType]='184' OR [serviceType]='183' OR [serviceType]='182' OR [serviceType]='181' OR [serviceType]='180' OR [serviceType]='179' OR [serviceType]='178' OR [serviceType]='177' OR [serviceType]='176' OR [serviceType]='175' OR [serviceType]='174' OR [serviceType]='173' OR [serviceType]='172' OR [serviceType]='171' OR [serviceType]='170' OR [serviceType]='169' OR [serviceType]='168' OR [serviceType]='167' OR [serviceType]='166' OR [serviceType]='165' OR [serviceType]='164' OR [serviceType]='163' OR [serviceType]='162' OR [serviceType]='161' OR [serviceType]='160' OR [serviceType]='159' OR [serviceType]='158' OR [serviceType]='157' OR [serviceType]='156' OR [serviceType]='155' OR [serviceType]='154' OR [serviceType]='153' OR [serviceType]='152' OR [serviceType]='151' OR [serviceType]='150' OR [serviceType]='149' OR [serviceType]='148' OR [serviceType]='147' OR [serviceType]='146' OR [serviceType]='145' OR [serviceType]='144' OR [serviceType]='143' OR [serviceType]='142' OR [serviceType]='141' OR [serviceType]='140' OR [serviceType]='139' OR [serviceType]='138' OR [serviceType]='137' OR [serviceType]='136' OR [serviceType]='135' OR [serviceType]='134' OR [serviceType]='133' OR [serviceType]='132' OR [serviceType]='131' OR [serviceType]='130' OR [serviceType]='129' OR [serviceType]='128' OR [serviceType]='127' OR [serviceType]='126' OR [serviceType]='125' OR [serviceType]='124' OR [serviceType]='123' OR [serviceType]='122' OR [serviceType]='121' OR [serviceType]='120' OR [serviceType]='119' OR [serviceType]='118' OR [serviceType]='117' OR [serviceType]='116' OR [serviceType]='115' OR [serviceType]='114' OR [serviceType]='113' OR [serviceType]='112' OR [serviceType]='111' OR [serviceType]='110' OR [serviceType]='109' OR [serviceType]='108' OR [serviceType]='107' OR [serviceType]='106' OR [serviceType]='105' OR [serviceType]='104' OR [serviceType]='103' OR [serviceType]='102' OR [serviceType]='101' OR [serviceType]='100' OR [serviceType]='99' OR [serviceType]='98' OR [serviceType]='97' OR [serviceType]='96' OR [serviceType]='95' OR [serviceType]='94' OR [serviceType]='93' OR [serviceType]='92' OR [serviceType]='91' OR [serviceType]='90' OR [serviceType]='89' OR [serviceType]='88' OR [serviceType]='87' OR [serviceType]='86' OR [serviceType]='85' OR [serviceType]='84' OR [serviceType]='83' OR [serviceType]='82' OR [serviceType]='81' OR [serviceType]='80' OR [serviceType]='79' OR [serviceType]='78' OR [serviceType]='77' OR [serviceType]='76' OR [serviceType]='75' OR [serviceType]='74' OR [serviceType]='73' OR [serviceType]='72' OR [serviceType]='71' OR [serviceType]='70' OR [serviceType]='69' OR [serviceType]='68' OR [serviceType]='67' OR [serviceType]='66' OR [serviceType]='65' OR [serviceType]='64' OR [serviceType]='63' OR [serviceType]='62' OR [serviceType]='61' OR [serviceType]='60' OR [serviceType]='59' OR [serviceType]='58' OR [serviceType]='57' OR [serviceType]='56' OR [serviceType]='55' OR [serviceType]='54' OR [serviceType]='53' OR [serviceType]='52' OR [serviceType]='51' OR [serviceType]='50' OR [serviceType]='49' OR [serviceType]='48' OR [serviceType]='47' OR [serviceType]='46' OR [serviceType]='45' OR [serviceType]='44' OR [serviceType]='43' OR [serviceType]='42' OR [serviceType]='41' OR [serviceType]='40' OR [serviceType]='39' OR [serviceType]='38' OR [serviceType]='37' OR [serviceType]='36' OR [serviceType]='35' OR [serviceType]='34' OR [serviceType]='33' OR [serviceType]='32' OR [serviceType]='31' OR [serviceType]='30' OR [serviceType]='29' OR [serviceType]='28' OR [serviceType]='27' OR [serviceType]='26' OR [serviceType]='25' OR [serviceType]='24' OR [serviceType]='23' OR [serviceType]='22' OR [serviceType]='21' OR [serviceType]='20' OR [serviceType]='19' OR [serviceType]='18' OR [serviceType]='17' OR [serviceType]='16' OR [serviceType]='15' OR [serviceType]='14' OR [serviceType]='13' OR [serviceType]='12' OR [serviceType]='11' OR [serviceType]='10' OR [serviceType]='9' OR [serviceType]='8' OR [serviceType]='7' OR [serviceType]='6' OR [serviceType]='5' OR [serviceType]='4' OR [serviceType]='3' OR [serviceType]='2' OR [serviceType]='1')),
	CHECK (([status]='unknown' OR [status]='entered-in-error' OR [status]='cancelled' OR [status]='finished' OR [status]='onleave' OR [status]='in-progress' OR [status]='triaged' OR [status]='arrived' OR [status]='planned'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_EncounterType' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_EncounterType] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[code] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[display] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='461231000124109' OR [code]='456201000124103' OR [code]='453701000124103' OR [code]='453131000124105' OR [code]='452081000124104' OR [code]='444971000124105' OR [code]='428931000124102' OR [code]='428921000124100' OR [code]='6061000124109' OR [code]='6051000124107' OR [code]='4141000175103' OR [code]='3391000175108' OR [code]='870194003' OR [code]='870191006' OR [code]='868184008' OR [code]='866204005' OR [code]='866203004' OR [code]='866149003' OR [code]='788543009' OR [code]='788542004' OR [code]='788339009' OR [code]='773298008' OR [code]='763184009' OR [code]='719410009' OR [code]='719407002' OR [code]='713776001' OR [code]='713281006' OR [code]='711532000' OR [code]='711458003' OR [code]='711420002' OR [code]='704126008' OR [code]='698704008' OR [code]='698314001' OR [code]='698313007' OR [code]='698312002' OR [code]='698311009' OR [code]='698310005' OR [code]='698309000' OR [code]='698308008' OR [code]='698307003' OR [code]='448337001' OR [code]='445450000' OR [code]='441244001' OR [code]='440696002' OR [code]='440611006' OR [code]='440568002' OR [code]='440168007' OR [code]='440146002' OR [code]='440085006' OR [code]='440068009' OR [code]='439887005' OR [code]='439740005' OR [code]='439708006' OR [code]='439058005' OR [code]='438516005' OR [code]='438515009' OR [code]='425604002' OR [code]='423861007' OR [code]='423215004' OR [code]='421946003' OR [code]='420650002' OR [code]='420454001' OR [code]='416520008' OR [code]='408487007' OR [code]='408483006' OR [code]='408482001' OR [code]='406547006' OR [code]='401271004' OR [code]='401267002' OR [code]='400979004' OR [code]='398228004' OR [code]='390906007' OR [code]='388977000' OR [code]='388975008' OR [code]='388970003' OR [code]='386473003' OR [code]='386472008' OR [code]='315205008' OR [code]='314849005' OR [code]='313183009' OR [code]='310588009' OR [code]='310587004' OR [code]='308720009' OR [code]='288836004' OR [code]='281036007' OR [code]='275693003' OR [code]='270430005' OR [code]='270427003' OR [code]='270425006' OR [code]='270424005' OR [code]='225929007' OR [code]='210098006' OR [code]='209099002' OR [code]='207195004' OR [code]='185470005' OR [code]='185469009' OR [code]='185468001' OR [code]='185467006' OR [code]='185466002' OR [code]='185465003' OR [code]='185464004' OR [code]='185463005' OR [code]='185462000' OR [code]='185389009' OR [code]='185387006' OR [code]='185349003' OR [code]='185348006' OR [code]='185347001' OR [code]='185346005' OR [code]='185345009' OR [code]='185321005' OR [code]='185320006' OR [code]='185318008' OR [code]='185317003' OR [code]='185316007' OR [code]='108221006' OR [code]='108220007' OR [code]='108219001' OR [code]='90526000' OR [code]='89291005' OR [code]='87790002' OR [code]='86181006' OR [code]='86013001' OR [code]='84251009' OR [code]='83362003' OR [code]='77965002' OR [code]='77406008' OR [code]='73575006' OR [code]='73007006' OR [code]='71387007' OR [code]='71318009' OR [code]='70495004' OR [code]='69399002' OR [code]='68341005' OR [code]='65981005' OR [code]='59000001' OR [code]='58400001' OR [code]='53923005' OR [code]='50687007' OR [code]='50357006' OR [code]='49569001' OR [code]='49463003' OR [code]='48550003' OR [code]='44340006' OR [code]='42423000' OR [code]='35755007' OR [code]='35437002' OR [code]='34043003' OR [code]='31108002' OR [code]='30274002' OR [code]='30078008' OR [code]='28191001' OR [code]='25028003' OR [code]='24882007' OR [code]='19681004' OR [code]='18170008' OR [code]='15301000' OR [code]='14736009' OR [code]='12843005' OR [code]='12566000' OR [code]='11429006' OR [code]='8502007' OR [code]='5947002' OR [code]='4525004' OR [code]='2530001' OR [code]='726007' OR [code]='680007' OR [code]='308335008'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Endpoint' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Endpoint] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[connectionType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[name] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[managingOrganization] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[payloadType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[payloadMIMEType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[address] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([connectionType]='direct-project' OR [connectionType]='secure-email' OR [connectionType]='hl7v2-mllp' OR [connectionType]='hl7-fhir-msg' OR [connectionType]='hl7-fhir-rest' OR [connectionType]='dicom-wado-uri' OR [connectionType]='dicom-stow-rs' OR [connectionType]='dicom-qido-rs' OR [connectionType]='dicom-wado-rs' OR [connectionType]='ihe-iid' OR [connectionType]='ihe-xds' OR [connectionType]='ihe-xdr' OR [connectionType]='ihe-xca' OR [connectionType]='ihe-xcpd')),
	CHECK (([payloadType]='urn:hl7-org:sdwg:ccda-nonXMLBody:1.1' OR [payloadType]='urn:hl7-org:sdwg:ccda-structuredBody:1.1' OR [payloadType]='urn:ihe:pharm:pml:2013' OR [payloadType]='urn:ihe:pharm:dis:2010' OR [payloadType]='urn:ihe:pharm:padv:2010' OR [payloadType]='urn:ihe:pharm:pre:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:larynx:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:salivary_gland:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:pharynx:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:lip_oral_cavity:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:urinary_bladder:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:testis:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:pancreas: 2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:liver:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:stomach: 2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:esophagus: 2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:ovary:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:endometrium:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:cervix:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:kidney:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:skin:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:lung:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:thyroid:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:prostate:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:colon:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:breast:2010' OR [payloadType]='urn:ihe:pat:apsr:cancer:all:2010' OR [payloadType]='urn:ihe:pat:apsr:all:2010' OR [payloadType]='urn:ihe:dent:CDA:ImagingReportStructuredHeadings:2013' OR [payloadType]='urn:ihe:dent:PDF' OR [payloadType]='urn:ihe:dent:TEXT' OR [payloadType]='urn:ihe:card:EPRC-IE:2014' OR [payloadType]='urn:ihe:card:CRC:2012' OR [payloadType]='urn:ihe:card:imaging:2011' OR [payloadType]='urn:ihe:rad:CDA:ImagingReportStructuredHeadings:2013' OR [payloadType]='urn:ihe:rad:PDF' OR [payloadType]='urn:ihe:rad:TEXT' OR [payloadType]='urn:ihe:lab:xd-lab:2008' OR [payloadType]='urn:ihe:iti:xds-sd:text:2008' OR [payloadType]='urn:ihe:iti:xds-sd:pdf:2008' OR [payloadType]='urn:ihe:iti:dsg:enveloping:2014' OR [payloadType]='urn:ihe:iti:dsg:detached:2014' OR [payloadType]='urn:ihe:iti:xdw:2011:workflowDoc' OR [payloadType]='urn:ihe:iti:bppc-sd:2007' OR [payloadType]='urn:ihe:iti:bppc:2007' OR [payloadType]='urn:ihe:pcc:its:2011' OR [payloadType]='urn:ihe:pcc:ets:2011' OR [payloadType]='urn:ihe:pcc:trs:2011' OR [payloadType]='urn:ihe:pcc:ppvs:2010' OR [payloadType]='urn:ihe:pcc:nds:2010' OR [payloadType]='urn:ihe:pcc:mds:2009' OR [payloadType]='urn:ihe:pcc:lds:2009' OR [payloadType]='urn:ihe:pcc:ldhp:2009' OR [payloadType]='urn:ihe:pcc:hp:2008' OR [payloadType]='urn:ihe:pcc:edpn:2007' OR [payloadType]='urn:ihe:pcc:ctn:2007' OR [payloadType]='urn:ihe:pcc:nn:2007' OR [payloadType]='urn:ihe:pcc:tn:2007' OR [payloadType]='urn:ihe:pcc:ic:2009' OR [payloadType]='urn:ihe:pcc:cm:2008' OR [payloadType]='urn:ihe:pcc:crc:2008' OR [payloadType]='urn:ihe:pcc:irc:2008' OR [payloadType]='urn:ihe:pcc:apr:edu:2008' OR [payloadType]='urn:ihe:pcc:apr:lab:2008' OR [payloadType]='urn:ihe:pcc:apr:handp:2008' OR [payloadType]='urn:ihe:pcc:edes:2007' OR [payloadType]='urn:ihe:pcc:edr:2007' OR [payloadType]='urn:ihe:pcc:xphr:2007' OR [payloadType]='urn:ihe:pcc:xds-ms:2007' OR [payloadType]='urn:ihe:pcc:aps:2007' OR [payloadType]='urn:ihe:pcc:xphr:2007' OR [payloadType]='urn:ihe:pcc:handp:2008')),
	CHECK (([status]='test' OR [status]='entered-in-error' OR [status]='off' OR [status]='error' OR [status]='suspended' OR [status]='active'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_GoalResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_GoalResource] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[lifeCycleStatus] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[achievementStatus] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[priority] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[description] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[startDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReason] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([achievementStatus]='not-attainable' OR [achievementStatus]='no-progress' OR [achievementStatus]='not-achieved' OR [achievementStatus]='sustaining' OR [achievementStatus]='achieved' OR [achievementStatus]='no-change' OR [achievementStatus]='worsening' OR [achievementStatus]='improving' OR [achievementStatus]='in-progress')),
	CHECK (([lifeCycleStatus]='rejected' OR [lifeCycleStatus]='entered-in-error' OR [lifeCycleStatus]='cancelled' OR [lifeCycleStatus]='completed' OR [lifeCycleStatus]='on-hold' OR [lifeCycleStatus]='active' OR [lifeCycleStatus]='accepted' OR [lifeCycleStatus]='planned' OR [lifeCycleStatus]='proposed')),
	CHECK (([priority]='low-priority' OR [priority]='medium-priority' OR [priority]='high-priority'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_GoalTargetOutcome' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_GoalTargetOutcome] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[measureCode] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[measureDescription] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[detailType] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[detailValue] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[detailCodeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[dueDate] [varchar](15) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([detailType]='Ratio' OR [detailType]='Integer' OR [detailType]='Boolean' OR [detailType]='String' OR [detailType]='Code' OR [detailType]='Range' OR [detailType]='Quantity'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Identifier' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Identifier] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[Type] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[system] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Value] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Type]='JHN' OR [Type]='FILL' OR [Type]='PLAC' OR [Type]='SB' OR [Type]='SNO' OR [Type]='UDI' OR [Type]='ACSN' OR [Type]='DR' OR [Type]='MD' OR [Type]='PRN' OR [Type]='NIIP' OR [Type]='TAX' OR [Type]='EN' OR [Type]='MCN' OR [Type]='MR' OR [Type]='BRN' OR [Type]='PPN' OR [Type]='DL'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ImmunizationEducationGiven' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ImmunizationEducationGiven] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[documentType] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[reference] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[publicationDate] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[presentationDate] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ImmunizationPerformer' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ImmunizationPerformer] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](36) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[function] [varchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([function]='AP' OR [function]='OP'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ImmunizationProgramEligibility' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ImmunizationProgramEligibility] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[codeDisplay] [varchar](15) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='uninsured' OR [code]='ineligible'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ImmunizationResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ImmunizationResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReason] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[occurrenceDateTime] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[recorded] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[primarySource] [varchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[reportOrigin] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[reportOriginDisplay] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[lotNumber] [varchar](15) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[expirationDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[site] [varchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[siteDisplay] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[route] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[routeDisplay] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[doseQuantity] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[isSubpotent] [bit] NULL,
	[fundingSource] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[doseNumber] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[seriesDoses] [varchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([primarySource]='false' OR [primarySource]='true')),
	CHECK (([reportOrigin]='school' OR [reportOrigin]='recall' OR [reportOrigin]='record' OR [reportOrigin]='provider')),
	CHECK (([route]='TRNSDERM' OR [route]='SQ' OR [route]='PO' OR [route]='IVINJ' OR [route]='NASINHLC' OR [route]='IM' OR [route]='IDINJ')),
	CHECK (([status]='not-done' OR [status]='entered-in-error' OR [status]='completed')),
	CHECK (([statusReason]='PATOBJ' OR [statusReason]='OSTOCK' OR [statusReason]='MEDPREC' OR [statusReason]='IMMUNE')),
	CHECK (([site]='RA' OR [site]='LA'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_LocationResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_LocationResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[name] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[description] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[physicalType] [varchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([physicalType]='jdn' OR [physicalType]='area' OR [physicalType]='rd' OR [physicalType]='ca' OR [physicalType]='ho' OR [physicalType]='ve' OR [physicalType]='bd' OR [physicalType]='ro' OR [physicalType]='co' OR [physicalType]='lvl' OR [physicalType]='wa' OR [physicalType]='wi' OR [physicalType]='bu' OR [physicalType]='si')),
	CHECK (([status]='inactive' OR [status]='suspended' OR [status]='active'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_MedicationRequestCategory' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_MedicationRequestCategory] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[code] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[codeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='discharge' OR [code]='community' OR [code]='outpatient' OR [code]='inpatient'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_MedicationRequestDosageInstruction' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_MedicationRequestDosageInstruction] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[sequence] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[text] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[patientInstruction] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[timing] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[asNeededBool] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[routeCode] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[routeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[methodCode] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[methodDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[maxDosePerPeriod] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[maxDosePerAdministration] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[maxDosePerLifetime] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([methodCode]='422327006' OR [methodCode]='422219000' OR [methodCode]='422152000' OR [methodCode]='422145002' OR [methodCode]='422114001' OR [methodCode]='422106007' OR [methodCode]='422033008' OR [methodCode]='421994004' OR [methodCode]='421984009' OR [methodCode]='421939007' OR [methodCode]='421832002' OR [methodCode]='421829000' OR [methodCode]='421805007' OR [methodCode]='421803000' OR [methodCode]='421769005' OR [methodCode]='421723005' OR [methodCode]='421718005' OR [methodCode]='421682005' OR [methodCode]='421612001' OR [methodCode]='421548005' OR [methodCode]='421538008' OR [methodCode]='421521009' OR [methodCode]='421484000' OR [methodCode]='421463005' OR [methodCode]='421399004' OR [methodCode]='421298005' OR [methodCode]='421286000' OR [methodCode]='421257003' OR [methodCode]='421206002' OR [methodCode]='421139008' OR [methodCode]='421134003' OR [methodCode]='421067001' OR [methodCode]='421066005' OR [methodCode]='421035004' OR [methodCode]='420974001' OR [methodCode]='420942008' OR [methodCode]='420883007' OR [methodCode]='420806001' OR [methodCode]='420771004' OR [methodCode]='420652005' OR [methodCode]='420620005' OR [methodCode]='420606003' OR [methodCode]='420604000' OR [methodCode]='420561004' OR [methodCode]='420503003' OR [methodCode]='420484009' OR [methodCode]='420360002' OR [methodCode]='420341009' OR [methodCode]='420295001' OR [methodCode]='420247005' OR [methodCode]='420246001' OR [methodCode]='420045007' OR [methodCode]='419747000' OR [methodCode]='419652001' OR [methodCode]='419582001' OR [methodCode]='419385000' OR [methodCode]='418283001' OR [methodCode]='417924000')),
	CHECK (([routeCode]='461657851000087101' OR [routeCode]='180677251000087104' OR [routeCode]='1611000175109' OR [routeCode]='718329006' OR [routeCode]='714743009' OR [routeCode]='711378007' OR [routeCode]='711360002' OR [routeCode]='697971008' OR [routeCode]='448598008' OR [routeCode]='448492006' OR [routeCode]='448491004' OR [routeCode]='448077001' OR [routeCode]='447964005' OR [routeCode]='447694001' OR [routeCode]='447229005' OR [routeCode]='447227007' OR [routeCode]='447122006' OR [routeCode]='447121004' OR [routeCode]='447081004' OR [routeCode]='447080003' OR [routeCode]='447052000' OR [routeCode]='447026006' OR [routeCode]='446540005' OR [routeCode]='446442000' OR [routeCode]='446435000' OR [routeCode]='446407004' OR [routeCode]='446105004' OR [routeCode]='445941009' OR [routeCode]='445913005' OR [routeCode]='445771006' OR [routeCode]='445769006' OR [routeCode]='445768003' OR [routeCode]='445767008' OR [routeCode]='445756007' OR [routeCode]='445755006' OR [routeCode]='445754005' OR [routeCode]='445752009' OR [routeCode]='429817007' OR [routeCode]='428191002' OR [routeCode]='420719007' OR [routeCode]='420287000' OR [routeCode]='420254004' OR [routeCode]='420218003' OR [routeCode]='420204005' OR [routeCode]='420201002' OR [routeCode]='420185003' OR [routeCode]='420168000' OR [routeCode]='420163009' OR [routeCode]='420047004' OR [routeCode]='419993007' OR [routeCode]='419954003' OR [routeCode]='419894000' OR [routeCode]='419874009' OR [routeCode]='419810008' OR [routeCode]='419778001' OR [routeCode]='419762003' OR [routeCode]='419684008' OR [routeCode]='419631009' OR [routeCode]='419601003' OR [routeCode]='419396008' OR [routeCode]='419320008' OR [routeCode]='419243002' OR [routeCode]='419231003' OR [routeCode]='419165009' OR [routeCode]='419021003' OR [routeCode]='418987007' OR [routeCode]='418947002' OR [routeCode]='418892005' OR [routeCode]='418887008' OR [routeCode]='418877009' OR [routeCode]='418851001' OR [routeCode]='418821007' OR [routeCode]='418813001' OR [routeCode]='418743005' OR [routeCode]='418730005' OR [routeCode]='418722009' OR [routeCode]='418664002' OR [routeCode]='418608002' OR [routeCode]='418586008' OR [routeCode]='418511008' OR [routeCode]='418441008' OR [routeCode]='418418000' OR [routeCode]='418401004' OR [routeCode]='418331006' OR [routeCode]='418321004' OR [routeCode]='418287000' OR [routeCode]='418204005' OR [routeCode]='418162004' OR [routeCode]='418136008' OR [routeCode]='418133000' OR [routeCode]='418114005' OR [routeCode]='418091004' OR [routeCode]='417989007' OR [routeCode]='417985001' OR [routeCode]='417950001' OR [routeCode]='417255000' OR [routeCode]='417070009' OR [routeCode]='416174007' OR [routeCode]='404820008' OR [routeCode]='404819002' OR [routeCode]='404818005' OR [routeCode]='404815008' OR [routeCode]='372476004' OR [routeCode]='372475000' OR [routeCode]='372474001' OR [routeCode]='372473007' OR [routeCode]='372471009' OR [routeCode]='372470005' OR [routeCode]='372469009' OR [routeCode]='372468001' OR [routeCode]='372467006' OR [routeCode]='372466002' OR [routeCode]='372465003' OR [routeCode]='372464004' OR [routeCode]='372463005' OR [routeCode]='372461007' OR [routeCode]='372460008' OR [routeCode]='372459003' OR [routeCode]='372458006' OR [routeCode]='372457001' OR [routeCode]='372454008' OR [routeCode]='372453002' OR [routeCode]='372452007' OR [routeCode]='372451000' OR [routeCode]='372450004' OR [routeCode]='372449004' OR [routeCode]='127492001' OR [routeCode]='127491008' OR [routeCode]='127490009' OR [routeCode]='90028008' OR [routeCode]='78421000' OR [routeCode]='72607000' OR [routeCode]='62226000' OR [routeCode]='60213007' OR [routeCode]='58100008' OR [routeCode]='54485002' OR [routeCode]='54471007' OR [routeCode]='47625008' OR [routeCode]='46713006' OR [routeCode]='45890007' OR [routeCode]='38239002' OR [routeCode]='37839007' OR [routeCode]='37737002' OR [routeCode]='37161004' OR [routeCode]='34206005' OR [routeCode]='26643006' OR [routeCode]='16857009' OR [routeCode]='12130007' OR [routeCode]='10547007' OR [routeCode]='6064005'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_MedicationRequestResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_MedicationRequestResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReason] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReasonDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[intent] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[priority] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[doNotPerform] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[reportedBoolean] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[authoredOn] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[groupIdentifier] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[courseOfTherapyType] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[courseOfTherapyTypeDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[initialFillQuantitiy] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[initialFillDuration] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[dispenseInterval] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[validityPeriodStart] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[validityPeriodEnd] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[numberOfRepeatsAllowed] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[quantity] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[expectedSupplyDuration] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[substitutionAllowed] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[substitutionAllowedReason] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[substitutionAllowedDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([courseOfTherapyType]='seasonal' OR [courseOfTherapyType]='acute' OR [courseOfTherapyType]='continuous')),
	CHECK (([intent]='option' OR [intent]='instance-order' OR [intent]='filler-order' OR [intent]='reflex-order' OR [intent]='original-order' OR [intent]='order' OR [intent]='plan' OR [intent]='proposal')),
	CHECK (([priority]='stat' OR [priority]='asap' OR [priority]='urgent' OR [priority]='routine')),
	CHECK (([status]='unknown' OR [status]='draft' OR [status]='stopped' OR [status]='entered-in-error' OR [status]='completed' OR [status]='cancelled' OR [status]='on-hold' OR [status]='active')),
	CHECK (([statusReason]='washout' OR [statusReason]='surg' OR [statusReason]='sintol' OR [statusReason]='sdupther' OR [statusReason]='sddi' OR [statusReason]='salg' OR [statusReason]='preg' OR [statusReason]='non-avail' OR [statusReason]='labint' OR [statusReason]='hospadm' OR [statusReason]='drughigh' OR [statusReason]='clarif' OR [statusReason]='altchoice')),
	CHECK (([substitutionAllowedReason]='RR' OR [substitutionAllowedReason]='OS' OR [substitutionAllowedReason]='FP' OR [substitutionAllowedReason]='CT'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ObservationCategory' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ObservationCategory] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[categoryCode] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[categoryCodeDisplay] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([categoryCode]='activity' OR [categoryCode]='therapy' OR [categoryCode]='exam' OR [categoryCode]='survey' OR [categoryCode]='procedure' OR [categoryCode]='laboratory' OR [categoryCode]='imaging' OR [categoryCode]='vital-signs' OR [categoryCode]='social-history'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ObservationComponent' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ObservationComponent] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [uniqueidentifier] NULL,
	[value] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[valueUnit] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[valueType] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[valueName] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ObservationInterpretation' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ObservationInterpretation] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[code] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[codeDisplay] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='WR' OR [code]='RR' OR [code]='NR' OR [code]='ReactivityObservationInterpretation' OR [code]='UNE' OR [code]='EXP' OR [code]='ObservationInterpretationExpectation' OR [code]='DET' OR [code]='POS' OR [code]='ND' OR [code]='NEG' OR [code]='E' OR [code]='IND' OR [code]='ObservationInterpretationDetection' OR [code]='LX' OR [code]='HX' OR [code]='EX' OR [code]='SYN-S' OR [code]='SDD' OR [code]='S' OR [code]='SYN-R' OR [code]='R' OR [code]='NS' OR [code]='NCL' OR [code]='I' OR [code]='_ObservationInterpretationSusceptibility' OR [code]='N' OR [code]='LU' OR [code]='L' OR [code]='HU' OR [code]='H' OR [code]='LL' OR [code]='HH' OR [code]='AA' OR [code]='A' OR [code]='_ObservationInterpretationNormality' OR [code]='IE' OR [code]='>' OR [code]='<' OR [code]='_ObservationInterpretationExceptions' OR [code]='W' OR [code]='U' OR [code]='D' OR [code]='B' OR [code]='_ObservationInterpretationChange' OR [code]='CAR' OR [code]='_GeneticObservationInterpretation'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ObservationReferenceRange' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ObservationReferenceRange] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [uniqueidentifier] NULL,
	[valueLow] [float] NULL,
	[valueHigh] [float] NULL,
	[type] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[ageLow] [smallint] NULL,
	[ageHigh] [smallint] NULL,
	[text] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([type]='postmenopausal' OR [type]='luteal' OR [type]='midcycle' OR [type]='follicular' OR [type]='pre-puberty' OR [type]='endocrine' OR [type]='post' OR [type]='pre' OR [type]='therapeutic' OR [type]='treatment' OR [type]='recommended' OR [type]='normal' OR [type]='type'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ObservationResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ObservationResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[effectiveDateTime] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[effectivePeriodStart] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[effectivePeriodEnd] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[issuedDateTime] [datetimeoffset](7) NULL,
	[code] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[value] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[valueUnit] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[valueType] [varchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[valueSystem] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[dataAbsentReason] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[resourceIDSuffix] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([dataAbsentReason]='not-permitted' OR [dataAbsentReason]='not-performed' OR [dataAbsentReason]='positive-infinity' OR [dataAbsentReason]='negative-infinity' OR [dataAbsentReason]='not-a-number' OR [dataAbsentReason]='error' OR [dataAbsentReason]='as-text' OR [dataAbsentReason]='unsupported' OR [dataAbsentReason]='not-applicable' OR [dataAbsentReason]='masked' OR [dataAbsentReason]='asked-declined' OR [dataAbsentReason]='not-asked' OR [dataAbsentReason]='temp-unknown' OR [dataAbsentReason]='asked-unknown' OR [dataAbsentReason]='unknown')),
	CHECK (([status]='unknown' OR [status]='entered-in-error' OR [status]='cancelled' OR [status]='corrected' OR [status]='amended' OR [status]='final' OR [status]='preliminary' OR [status]='registered'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_OrganizationResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_OrganizationResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[active] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[partOf] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonBirthSex' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonBirthSex] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[Code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='UNK' OR [Code]='OTH' OR [Code]='ASKU' OR [Code]='M' OR [Code]='F'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonEthnicity' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonEthnicity] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[Code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='unknown' OR [Code]='2184-0' OR [Code]='2182-4' OR [Code]='2180-8' OR [Code]='2178-2' OR [Code]='2176-6' OR [Code]='2175-8' OR [Code]='2174-1' OR [Code]='2173-3' OR [Code]='2172-5' OR [Code]='2171-7' OR [Code]='2170-9' OR [Code]='2169-1' OR [Code]='2168-3' OR [Code]='2167-5' OR [Code]='2166-7' OR [Code]='2165-9' OR [Code]='2163-4' OR [Code]='2162-6' OR [Code]='2161-8' OR [Code]='2160-0' OR [Code]='2159-2' OR [Code]='2158-4' OR [Code]='2157-6' OR [Code]='2156-8' OR [Code]='2155-0' OR [Code]='2153-5' OR [Code]='2152-7' OR [Code]='2151-9' OR [Code]='2150-1' OR [Code]='2149-3' OR [Code]='2148-5' OR [Code]='2146-9' OR [Code]='2145-1' OR [Code]='2144-4' OR [Code]='2143-6' OR [Code]='2142-8' OR [Code]='2141-0' OR [Code]='2140-2' OR [Code]='2139-4' OR [Code]='2138-6' OR [Code]='2137-8' OR [Code]='2186-5' OR [Code]='2135-2'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonGender' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonGender] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[Code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='unknown' OR [Code]='other' OR [Code]='female' OR [Code]='male'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonGenderIdentity' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonGenderIdentity] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[Code] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='407376001' OR [Code]='407377005' OR [Code]='OTH' OR [Code]='446131000124102' OR [Code]='ASKU' OR [Code]='446141000124107' OR [Code]='446151000124109'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonLanguage' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonLanguage] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[Code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='zh-TW' OR [Code]='zh-SG' OR [Code]='zh-HK' OR [Code]='zh-CN' OR [Code]='zh' OR [Code]='te' OR [Code]='sv-SE' OR [Code]='sv' OR [Code]='sr-RS' OR [Code]='sr' OR [Code]='ru-RU' OR [Code]='ru' OR [Code]='pt-BR' OR [Code]='pt' OR [Code]='pl' OR [Code]='pa' OR [Code]='no-NO' OR [Code]='no' OR [Code]='nl-NL' OR [Code]='nl-BE' OR [Code]='nl' OR [Code]='ko' OR [Code]='ja' OR [Code]='it-IT' OR [Code]='it-CH' OR [Code]='it' OR [Code]='hr' OR [Code]='hi' OR [Code]='fy-NL' OR [Code]='fy' OR [Code]='fr-FR' OR [Code]='fr-CH' OR [Code]='fr-BE' OR [Code]='fr' OR [Code]='fi' OR [Code]='es-UY' OR [Code]='es-ES' OR [Code]='es-AR' OR [Code]='es' OR [Code]='en-US' OR [Code]='en-SG' OR [Code]='en-NZ' OR [Code]='en-IN' OR [Code]='en-GB' OR [Code]='en-CA' OR [Code]='en-AU' OR [Code]='en' OR [Code]='el' OR [Code]='de-DE' OR [Code]='de-CH' OR [Code]='de-AT' OR [Code]='de' OR [Code]='da' OR [Code]='cs' OR [Code]='bn' OR [Code]='ar'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonMaritalStatus' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonMaritalStatus] AS TABLE(
	[personID] [uniqueidentifier] NULL,
	[Code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Name] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='UNK' OR [Code]='W' OR [Code]='U' OR [Code]='T' OR [Code]='S' OR [Code]='P' OR [Code]='M' OR [Code]='L' OR [Code]='I' OR [Code]='D' OR [Code]='A'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonName' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonName] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[fullName] [varchar](500) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[family] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[given] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[middle] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[prefix] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[suffix] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonPatient' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonPatient] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[id] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[birthDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[deathDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[active] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[multipleBirthOrder] [smallint] NULL,
	CHECK (([active]='false' OR [active]='true'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PersonRace' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PersonRace] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[Code] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Name] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([Code]='asked but unknown' OR [Code]='unknown' OR [Code]='2500-7' OR [Code]='2131-1' OR [Code]='2129-5' OR [Code]='2127-9' OR [Code]='2126-1' OR [Code]='2125-3' OR [Code]='2124-6' OR [Code]='2123-8' OR [Code]='2122-0' OR [Code]='2121-2' OR [Code]='2120-4' OR [Code]='2119-6' OR [Code]='2118-8' OR [Code]='2116-2' OR [Code]='2115-4' OR [Code]='2114-7' OR [Code]='2113-9' OR [Code]='2112-1' OR [Code]='2111-3' OR [Code]='2110-5' OR [Code]='2109-7' OR [Code]='2108-9' OR [Code]='2104-8' OR [Code]='2103-0' OR [Code]='2102-2' OR [Code]='2101-4' OR [Code]='2100-6' OR [Code]='2098-2' OR [Code]='2097-4' OR [Code]='2096-6' OR [Code]='2095-8' OR [Code]='2094-1' OR [Code]='2093-3' OR [Code]='2092-5' OR [Code]='2091-7' OR [Code]='2090-9' OR [Code]='2089-1' OR [Code]='2088-3' OR [Code]='2087-5' OR [Code]='2086-7' OR [Code]='2085-9' OR [Code]='2083-4' OR [Code]='2082-6' OR [Code]='2081-8' OR [Code]='2080-0' OR [Code]='2079-2' OR [Code]='2078-4' OR [Code]='2075-0' OR [Code]='2074-3' OR [Code]='2073-5' OR [Code]='2072-7' OR [Code]='2071-9' OR [Code]='2070-1' OR [Code]='2069-3' OR [Code]='2068-5' OR [Code]='2067-7' OR [Code]='2066-9' OR [Code]='2065-1' OR [Code]='2064-4' OR [Code]='2063-6' OR [Code]='2062-8' OR [Code]='2061-0' OR [Code]='2060-2' OR [Code]='2058-6' OR [Code]='2056-0' OR [Code]='2052-9' OR [Code]='2051-1' OR [Code]='2050-3' OR [Code]='2049-5' OR [Code]='2048-7' OR [Code]='2047-9' OR [Code]='2046-1' OR [Code]='2045-3' OR [Code]='2044-6' OR [Code]='2043-8' OR [Code]='2042-0' OR [Code]='2041-2' OR [Code]='2040-4' OR [Code]='2039-6' OR [Code]='2038-8' OR [Code]='2037-0' OR [Code]='2036-2' OR [Code]='2035-4' OR [Code]='2034-7' OR [Code]='2033-9' OR [Code]='2032-1' OR [Code]='2031-3' OR [Code]='2030-5' OR [Code]='2029-7' OR [Code]='2026-3' OR [Code]='2025-5' OR [Code]='2024-8' OR [Code]='2023-0' OR [Code]='2022-2' OR [Code]='2021-4' OR [Code]='2020-6' OR [Code]='2019-8' OR [Code]='2018-0' OR [Code]='2017-2' OR [Code]='2016-4' OR [Code]='2015-6' OR [Code]='2014-9' OR [Code]='2013-1' OR [Code]='2012-3' OR [Code]='2011-5' OR [Code]='2010-7' OR [Code]='2009-9' OR [Code]='2008-1' OR [Code]='2007-3' OR [Code]='2006-5' OR [Code]='2004-0' OR [Code]='2002-4' OR [Code]='2000-8' OR [Code]='1999-2' OR [Code]='1998-4' OR [Code]='1997-6' OR [Code]='1996-8' OR [Code]='1995-0' OR [Code]='1994-3' OR [Code]='1993-5' OR [Code]='1992-7' OR [Code]='1990-1' OR [Code]='1988-5' OR [Code]='1987-7' OR [Code]='1986-9' OR [Code]='1985-1' OR [Code]='1984-4' OR [Code]='1982-8' OR [Code]='1981-0' OR [Code]='1980-2' OR [Code]='1979-4' OR [Code]='1978-6' OR [Code]='1977-8' OR [Code]='1976-0' OR [Code]='1975-2' OR [Code]='1974-5' OR [Code]='1973-7' OR [Code]='1972-9' OR [Code]='1970-3' OR [Code]='1969-5' OR [Code]='1968-7' OR [Code]='1966-1' OR [Code]='1964-6' OR [Code]='1963-8' OR [Code]='1962-0' OR [Code]='1961-2' OR [Code]='1960-4' OR [Code]='1959-6' OR [Code]='1958-8' OR [Code]='1957-0' OR [Code]='1956-2' OR [Code]='1955-4' OR [Code]='1954-7' OR [Code]='1953-9' OR [Code]='1952-1' OR [Code]='1951-3' OR [Code]='1950-5' OR [Code]='1949-7' OR [Code]='1948-9' OR [Code]='1947-1' OR [Code]='1946-3' OR [Code]='1945-5' OR [Code]='1944-8' OR [Code]='1943-0' OR [Code]='1942-2' OR [Code]='1941-4' OR [Code]='1940-6' OR [Code]='1939-8' OR [Code]='1938-0' OR [Code]='1937-2' OR [Code]='1936-4' OR [Code]='1935-6' OR [Code]='1934-9' OR [Code]='1933-1' OR [Code]='1932-3' OR [Code]='1931-5' OR [Code]='1930-7' OR [Code]='1929-9' OR [Code]='1928-1' OR [Code]='1927-3' OR [Code]='1926-5' OR [Code]='1925-7' OR [Code]='1924-0' OR [Code]='1923-2' OR [Code]='1922-4' OR [Code]='1921-6' OR [Code]='1920-8' OR [Code]='1919-0' OR [Code]='1918-2' OR [Code]='1917-4' OR [Code]='1916-6' OR [Code]='1915-8' OR [Code]='1914-1' OR [Code]='1913-3' OR [Code]='1912-5' OR [Code]='1911-7' OR [Code]='1910-9' OR [Code]='1909-1' OR [Code]='1908-3' OR [Code]='1907-5' OR [Code]='1906-7' OR [Code]='1905-9' OR [Code]='1904-2' OR [Code]='1903-4' OR [Code]='1902-6' OR [Code]='1901-8' OR [Code]='1900-0' OR [Code]='1899-4' OR [Code]='1898-6' OR [Code]='1897-8' OR [Code]='1896-0' OR [Code]='1894-5' OR [Code]='1893-7' OR [Code]='1892-9' OR [Code]='1891-1' OR [Code]='1889-5' OR [Code]='1888-7' OR [Code]='1887-9' OR [Code]='1886-1' OR [Code]='1885-3' OR [Code]='1884-6' OR [Code]='1883-8' OR [Code]='1882-0' OR [Code]='1881-2' OR [Code]='1880-4' OR [Code]='1879-6' OR [Code]='1878-8' OR [Code]='1877-0' OR [Code]='1876-2' OR [Code]='1875-4' OR [Code]='1874-7' OR [Code]='1873-9' OR [Code]='1872-1' OR [Code]='1871-3' OR [Code]='1870-5' OR [Code]='1869-7' OR [Code]='1868-9' OR [Code]='1867-1' OR [Code]='1866-3' OR [Code]='1865-5' OR [Code]='1864-8' OR [Code]='1863-0' OR [Code]='1862-2' OR [Code]='1861-4' OR [Code]='1860-6' OR [Code]='1859-8' OR [Code]='1858-0' OR [Code]='1857-2' OR [Code]='1856-4' OR [Code]='1855-6' OR [Code]='1854-9' OR [Code]='1853-1' OR [Code]='1852-3' OR [Code]='1851-5' OR [Code]='1850-7' OR [Code]='1849-9' OR [Code]='1848-1' OR [Code]='1847-3' OR [Code]='1846-5' OR [Code]='1845-7' OR [Code]='1844-0' OR [Code]='1842-4' OR [Code]='1840-8' OR [Code]='1838-2' OR [Code]='1837-4' OR [Code]='1835-8' OR [Code]='1834-1' OR [Code]='1833-3' OR [Code]='1832-5' OR [Code]='1831-7' OR [Code]='1830-9' OR [Code]='1829-1' OR [Code]='1828-3' OR [Code]='1827-5' OR [Code]='1826-7' OR [Code]='1825-9' OR [Code]='1824-2' OR [Code]='1823-4' OR [Code]='1822-6' OR [Code]='1821-8' OR [Code]='1820-0' OR [Code]='1819-2' OR [Code]='1818-4' OR [Code]='1817-6' OR [Code]='1816-8' OR [Code]='1815-0' OR [Code]='1814-3' OR [Code]='1813-5' OR [Code]='1811-9' OR [Code]='1809-3' OR [Code]='1808-5' OR [Code]='1807-7' OR [Code]='1806-9' OR [Code]='1805-1' OR [Code]='1804-4' OR [Code]='1803-6' OR [Code]='1802-8' OR [Code]='1801-0' OR [Code]='1800-2' OR [Code]='1799-6' OR [Code]='1798-8' OR [Code]='1797-0' OR [Code]='1796-2' OR [Code]='1795-4' OR [Code]='1794-7' OR [Code]='1793-9' OR [Code]='1792-1' OR [Code]='1791-3' OR [Code]='1790-5' OR [Code]='1789-7' OR [Code]='1788-9' OR [Code]='1787-1' OR [Code]='1786-3' OR [Code]='1785-5' OR [Code]='1784-8' OR [Code]='1783-0' OR [Code]='1782-2' OR [Code]='1781-4' OR [Code]='1780-6' OR [Code]='1779-8' OR [Code]='1778-0' OR [Code]='1777-2' OR [Code]='1776-4' OR [Code]='1775-6' OR [Code]='1774-9' OR [Code]='1773-1' OR [Code]='1772-3' OR [Code]='1771-5' OR [Code]='1770-7' OR [Code]='1769-9' OR [Code]='1768-1' OR [Code]='1767-3' OR [Code]='1766-5' OR [Code]='1765-7' OR [Code]='1764-0' OR [Code]='1763-2' OR [Code]='1762-4' OR [Code]='1761-6' OR [Code]='1760-8' OR [Code]='1759-0' OR [Code]='1758-2' OR [Code]='1757-4' OR [Code]='1756-6' OR [Code]='1755-8' OR [Code]='1754-1' OR [Code]='1753-3' OR [Code]='1752-5' OR [Code]='1751-7' OR [Code]='1750-9' OR [Code]='1749-1' OR [Code]='1748-3' OR [Code]='1747-5' OR [Code]='1746-7' OR [Code]='1745-9' OR [Code]='1744-2' OR [Code]='1743-4' OR [Code]='1742-6' OR [Code]='1741-8' OR [Code]='1740-0' OR [Code]='1739-2' OR [Code]='1737-6' OR [Code]='1735-0' OR [Code]='1733-5' OR [Code]='1732-7' OR [Code]='1731-9' OR [Code]='1730-1' OR [Code]='1729-3' OR [Code]='1728-5' OR [Code]='1727-7' OR [Code]='1726-9' OR [Code]='1725-1' OR [Code]='1724-4' OR [Code]='1722-8' OR [Code]='1720-2' OR [Code]='1719-4' OR [Code]='1718-6' OR [Code]='1717-8' OR [Code]='1715-2' OR [Code]='1713-7' OR [Code]='1712-9' OR [Code]='1711-1' OR [Code]='1709-5' OR [Code]='1707-9' OR [Code]='1705-3' OR [Code]='1704-6' OR [Code]='1702-0' OR [Code]='1700-4' OR [Code]='1698-0' OR [Code]='1697-2' OR [Code]='1696-4' OR [Code]='1694-9' OR [Code]='1692-3' OR [Code]='1690-7' OR [Code]='1689-9' OR [Code]='1688-1' OR [Code]='1687-3' OR [Code]='1685-7' OR [Code]='1683-2' OR [Code]='1681-6' OR [Code]='1680-8' OR [Code]='1679-0' OR [Code]='1677-4' OR [Code]='1675-8' OR [Code]='1673-3' OR [Code]='1672-5' OR [Code]='1671-7' OR [Code]='1670-9' OR [Code]='1668-3' OR [Code]='1667-5' OR [Code]='1665-9' OR [Code]='1663-4' OR [Code]='1661-8' OR [Code]='1659-2' OR [Code]='1657-6' OR [Code]='1656-8' OR [Code]='1655-0' OR [Code]='1654-3' OR [Code]='1653-5' OR [Code]='1651-9' OR [Code]='1649-3' OR [Code]='1647-7' OR [Code]='1645-1' OR [Code]='1643-6' OR [Code]='1641-0' OR [Code]='1640-2' OR [Code]='1639-4' OR [Code]='1638-6' OR [Code]='1637-8' OR [Code]='1636-0' OR [Code]='1635-2' OR [Code]='1634-5' OR [Code]='1633-7' OR [Code]='1632-9' OR [Code]='1631-1' OR [Code]='1630-3' OR [Code]='1629-5' OR [Code]='1628-7' OR [Code]='1627-9' OR [Code]='1626-1' OR [Code]='1625-3' OR [Code]='1624-6' OR [Code]='1623-8' OR [Code]='1622-0' OR [Code]='1621-2' OR [Code]='1620-4' OR [Code]='1619-6' OR [Code]='1618-8' OR [Code]='1617-0' OR [Code]='1616-2' OR [Code]='1615-4' OR [Code]='1614-7' OR [Code]='1613-9' OR [Code]='1612-1' OR [Code]='1611-3' OR [Code]='1610-5' OR [Code]='1609-7' OR [Code]='1607-1' OR [Code]='1605-5' OR [Code]='1604-8' OR [Code]='1603-0' OR [Code]='1602-2' OR [Code]='1600-6' OR [Code]='1599-0' OR [Code]='1598-2' OR [Code]='1597-4' OR [Code]='1596-6' OR [Code]='1595-8' OR [Code]='1594-1' OR [Code]='1593-3' OR [Code]='1592-5' OR [Code]='1591-7' OR [Code]='1590-9' OR [Code]='1589-1' OR [Code]='1588-3' OR [Code]='1587-5' OR [Code]='1586-7' OR [Code]='1584-2' OR [Code]='1582-6' OR [Code]='1580-0' OR [Code]='1579-2' OR [Code]='1578-4' OR [Code]='1576-8' OR [Code]='1574-3' OR [Code]='1573-5' OR [Code]='1571-9' OR [Code]='1570-1' OR [Code]='1569-3' OR [Code]='1568-5' OR [Code]='1567-7' OR [Code]='1566-9' OR [Code]='1564-4' OR [Code]='1562-8' OR [Code]='1560-2' OR [Code]='1558-6' OR [Code]='1556-0' OR [Code]='1554-5' OR [Code]='1553-7' OR [Code]='1552-9' OR [Code]='1551-1' OR [Code]='1549-5' OR [Code]='1547-9' OR [Code]='1545-3' OR [Code]='1543-8' OR [Code]='1541-2' OR [Code]='1539-6' OR [Code]='1538-8' OR [Code]='1537-0' OR [Code]='1536-2' OR [Code]='1535-4' OR [Code]='1534-7' OR [Code]='1533-9' OR [Code]='1532-1' OR [Code]='1531-3' OR [Code]='1530-5' OR [Code]='1529-7' OR [Code]='1528-9' OR [Code]='1527-1' OR [Code]='1526-3' OR [Code]='1525-5' OR [Code]='1524-8' OR [Code]='1523-0' OR [Code]='1522-2' OR [Code]='1521-4' OR [Code]='1520-6' OR [Code]='1519-8' OR [Code]='1518-0' OR [Code]='1516-4' OR [Code]='1515-6' OR [Code]='1514-9' OR [Code]='1513-1' OR [Code]='1512-3' OR [Code]='1511-5' OR [Code]='1510-7' OR [Code]='1509-9' OR [Code]='1508-1' OR [Code]='1507-3' OR [Code]='1506-5' OR [Code]='1505-7' OR [Code]='1504-0' OR [Code]='1503-2' OR [Code]='1502-4' OR [Code]='1501-6' OR [Code]='1500-8' OR [Code]='1499-3' OR [Code]='1498-5' OR [Code]='1497-7' OR [Code]='1496-9' OR [Code]='1495-1' OR [Code]='1494-4' OR [Code]='1493-6' OR [Code]='1492-8' OR [Code]='1491-0' OR [Code]='1490-2' OR [Code]='1489-4' OR [Code]='1487-8' OR [Code]='1485-2' OR [Code]='1484-5' OR [Code]='1483-7' OR [Code]='1482-9' OR [Code]='1481-1' OR [Code]='1480-3' OR [Code]='1479-5' OR [Code]='1478-7' OR [Code]='1476-1' OR [Code]='1475-3' OR [Code]='1474-6' OR [Code]='1472-0' OR [Code]='1471-2' OR [Code]='1470-4' OR [Code]='1469-6' OR [Code]='1468-8' OR [Code]='1467-0' OR [Code]='1466-2' OR [Code]='1465-4' OR [Code]='1464-7' OR [Code]='1462-1' OR [Code]='1460-5' OR [Code]='1458-9' OR [Code]='1457-1' OR [Code]='1456-3' OR [Code]='1454-8' OR [Code]='1453-0' OR [Code]='1451-4' OR [Code]='1450-6' OR [Code]='1448-0' OR [Code]='1446-4' OR [Code]='1445-6' OR [Code]='1443-1' OR [Code]='1442-3' OR [Code]='1441-5' OR [Code]='1439-9' OR [Code]='1437-3' OR [Code]='1436-5' OR [Code]='1435-7' OR [Code]='1434-0' OR [Code]='1433-2' OR [Code]='1432-4' OR [Code]='1431-6' OR [Code]='1430-8' OR [Code]='1429-0' OR [Code]='1428-2' OR [Code]='1427-4' OR [Code]='1426-6' OR [Code]='1425-8' OR [Code]='1424-1' OR [Code]='1423-3' OR [Code]='1422-5' OR [Code]='1421-7' OR [Code]='1420-9' OR [Code]='1419-1' OR [Code]='1418-3' OR [Code]='1417-5' OR [Code]='1416-7' OR [Code]='1414-2' OR [Code]='1413-4' OR [Code]='1412-6' OR [Code]='1411-8' OR [Code]='1409-2' OR [Code]='1407-6' OR [Code]='1405-0' OR [Code]='1403-5' OR [Code]='1401-9' OR [Code]='1400-1' OR [Code]='1399-5' OR [Code]='1398-7' OR [Code]='1397-9' OR [Code]='1396-1' OR [Code]='1395-3' OR [Code]='1394-6' OR [Code]='1393-8' OR [Code]='1392-0' OR [Code]='1391-2' OR [Code]='1389-6' OR [Code]='1387-0' OR [Code]='1385-4' OR [Code]='1384-7' OR [Code]='1383-9' OR [Code]='1382-1' OR [Code]='1380-5' OR [Code]='1378-9' OR [Code]='1376-3' OR [Code]='1374-8' OR [Code]='1372-2' OR [Code]='1370-6' OR [Code]='1368-0' OR [Code]='1366-4' OR [Code]='1365-6' OR [Code]='1363-1' OR [Code]='1361-5' OR [Code]='1360-7' OR [Code]='1359-9' OR [Code]='1358-1' OR [Code]='1356-5' OR [Code]='1354-0' OR [Code]='1352-4' OR [Code]='1350-8' OR [Code]='1348-2' OR [Code]='1346-6' OR [Code]='1345-8' OR [Code]='1344-1' OR [Code]='1342-5' OR [Code]='1340-9' OR [Code]='1338-3' OR [Code]='1337-5' OR [Code]='1336-7' OR [Code]='1335-9' OR [Code]='1334-2' OR [Code]='1333-4' OR [Code]='1332-6' OR [Code]='1331-8' OR [Code]='1329-2' OR [Code]='1328-4' OR [Code]='1327-6' OR [Code]='1326-8' OR [Code]='1325-0' OR [Code]='1323-5' OR [Code]='1321-9' OR [Code]='1319-3' OR [Code]='1317-7' OR [Code]='1315-1' OR [Code]='1314-4' OR [Code]='1313-6' OR [Code]='1312-8' OR [Code]='1310-2' OR [Code]='1309-4' OR [Code]='1307-8' OR [Code]='1306-0' OR [Code]='1305-2' OR [Code]='1303-7' OR [Code]='1301-1' OR [Code]='1299-7' OR [Code]='1297-1' OR [Code]='1295-5' OR [Code]='1294-8' OR [Code]='1293-0' OR [Code]='1292-2' OR [Code]='1291-4' OR [Code]='1290-6' OR [Code]='1289-8' OR [Code]='1288-0' OR [Code]='1287-2' OR [Code]='1286-4' OR [Code]='1285-6' OR [Code]='1283-1' OR [Code]='1282-3' OR [Code]='1281-5' OR [Code]='1279-9' OR [Code]='1277-3' OR [Code]='1275-7' OR [Code]='1273-2' OR [Code]='1272-4' OR [Code]='1271-6' OR [Code]='1269-0' OR [Code]='1267-4' OR [Code]='1265-8' OR [Code]='1264-1' OR [Code]='1262-5' OR [Code]='1260-9' OR [Code]='1258-3' OR [Code]='1256-7' OR [Code]='1254-2' OR [Code]='1252-6' OR [Code]='1250-0' OR [Code]='1248-4' OR [Code]='1247-6' OR [Code]='1246-8' OR [Code]='1245-0' OR [Code]='1244-3' OR [Code]='1243-5' OR [Code]='1242-7' OR [Code]='1241-9' OR [Code]='1240-1' OR [Code]='1239-3' OR [Code]='1238-5' OR [Code]='1237-7' OR [Code]='1236-9' OR [Code]='1235-1' OR [Code]='1234-4' OR [Code]='1233-6' OR [Code]='1231-0' OR [Code]='1230-2' OR [Code]='1229-4' OR [Code]='1228-6' OR [Code]='1227-8' OR [Code]='1226-0' OR [Code]='1225-2' OR [Code]='1224-5' OR [Code]='1223-7' OR [Code]='1222-9' OR [Code]='1220-3' OR [Code]='1219-5' OR [Code]='1218-7' OR [Code]='1217-9' OR [Code]='1216-1' OR [Code]='1215-3' OR [Code]='1214-6' OR [Code]='1212-0' OR [Code]='1211-2' OR [Code]='1209-6' OR [Code]='1207-0' OR [Code]='1205-4' OR [Code]='1204-7' OR [Code]='1203-9' OR [Code]='1202-1' OR [Code]='1201-3' OR [Code]='1200-5' OR [Code]='1199-9' OR [Code]='1198-1' OR [Code]='1197-3' OR [Code]='1196-5' OR [Code]='1195-7' OR [Code]='1194-0' OR [Code]='1193-2' OR [Code]='1191-6' OR [Code]='1189-0' OR [Code]='1187-4' OR [Code]='1186-6' OR [Code]='1184-1' OR [Code]='1182-5' OR [Code]='1180-9' OR [Code]='1178-3' OR [Code]='1176-7' OR [Code]='1175-9' OR [Code]='1173-4' OR [Code]='1171-8' OR [Code]='1169-2' OR [Code]='1167-6' OR [Code]='1165-0' OR [Code]='1163-5' OR [Code]='1162-7' OR [Code]='1160-1' OR [Code]='1159-3' OR [Code]='1158-5' OR [Code]='1157-7' OR [Code]='1156-9' OR [Code]='1155-1' OR [Code]='1153-6' OR [Code]='1151-0' OR [Code]='1150-2' OR [Code]='1148-6' OR [Code]='1147-8' OR [Code]='1146-0' OR [Code]='1145-2' OR [Code]='1144-5' OR [Code]='1143-7' OR [Code]='1142-9' OR [Code]='1141-1' OR [Code]='1140-3' OR [Code]='1139-5' OR [Code]='1138-7' OR [Code]='1137-9' OR [Code]='1136-1' OR [Code]='1135-3' OR [Code]='1134-6' OR [Code]='1133-8' OR [Code]='1132-0' OR [Code]='1131-2' OR [Code]='1130-4' OR [Code]='1129-6' OR [Code]='1128-8' OR [Code]='1127-0' OR [Code]='1126-2' OR [Code]='1125-4' OR [Code]='1124-7' OR [Code]='1123-9' OR [Code]='1121-3' OR [Code]='1120-5' OR [Code]='1119-7' OR [Code]='1118-9' OR [Code]='1117-1' OR [Code]='1116-3' OR [Code]='1115-5' OR [Code]='1114-8' OR [Code]='1112-2' OR [Code]='1110-6' OR [Code]='1109-8' OR [Code]='1108-0' OR [Code]='1106-4' OR [Code]='1104-9' OR [Code]='1103-1' OR [Code]='1102-3' OR [Code]='1100-7' OR [Code]='1098-3' OR [Code]='1097-5' OR [Code]='1096-7' OR [Code]='1095-9' OR [Code]='1094-2' OR [Code]='1093-4' OR [Code]='1092-6' OR [Code]='1091-8' OR [Code]='1090-0' OR [Code]='1089-2' OR [Code]='1088-4' OR [Code]='1086-8' OR [Code]='1084-3' OR [Code]='1083-5' OR [Code]='1082-7' OR [Code]='1080-1' OR [Code]='1078-5' OR [Code]='1076-9' OR [Code]='1074-4' OR [Code]='1073-6' OR [Code]='1072-8' OR [Code]='1071-0' OR [Code]='1070-2' OR [Code]='1069-4' OR [Code]='1068-6' OR [Code]='1066-0' OR [Code]='1065-2' OR [Code]='1064-5' OR [Code]='1063-7' OR [Code]='1062-9' OR [Code]='1061-1' OR [Code]='1060-3' OR [Code]='1059-5' OR [Code]='1058-7' OR [Code]='1057-9' OR [Code]='1056-1' OR [Code]='1055-3' OR [Code]='1054-6' OR [Code]='1053-8' OR [Code]='1051-2' OR [Code]='1050-4' OR [Code]='1049-6' OR [Code]='1048-8' OR [Code]='1047-0' OR [Code]='1046-2' OR [Code]='1045-4' OR [Code]='1044-7' OR [Code]='1042-1' OR [Code]='1041-3' OR [Code]='1039-7' OR [Code]='1037-1' OR [Code]='1035-5' OR [Code]='1033-0' OR [Code]='1031-4' OR [Code]='1030-6' OR [Code]='1028-0' OR [Code]='1026-4' OR [Code]='1024-9' OR [Code]='1023-1' OR [Code]='1022-3' OR [Code]='1021-5' OR [Code]='1019-9' OR [Code]='1018-1' OR [Code]='1017-3' OR [Code]='1016-5' OR [Code]='1015-7' OR [Code]='1014-0' OR [Code]='1013-2' OR [Code]='1012-4' OR [Code]='1011-6' OR [Code]='1010-8' OR [Code]='1008-2' OR [Code]='1006-6' OR [Code]='1004-1' OR [Code]='2131-1' OR [Code]='2106-3' OR [Code]='2076-8' OR [Code]='2054-5' OR [Code]='2028-9' OR [Code]='1002-5'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PractitionerProviderRole' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PractitionerProviderRole] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[code] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[text] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='405300000X' OR [code]='390200000X' OR [code]='385HR2065X' OR [code]='385HR2060X' OR [code]='385HR2055X' OR [code]='385HR2050X' OR [code]='385H00000X' OR [code]='376K00000X' OR [code]='376J00000X' OR [code]='376G00000X' OR [code]='374U00000X' OR [code]='374T00000X' OR [code]='374K00000X' OR [code]='374J00000X' OR [code]='3747P1801X' OR [code]='3747A0650X' OR [code]='374700000X' OR [code]='373H00000X' OR [code]='372600000X' OR [code]='372500000X' OR [code]='367H00000X' OR [code]='367A00000X' OR [code]='367500000X' OR [code]='364SX0204X' OR [code]='364SX0200X' OR [code]='364SX0106X' OR [code]='364SW0102X' OR [code]='364ST0500X' OR [code]='364SS0200X' OR [code]='364SR0400X' OR [code]='364SP2800X' OR [code]='364SP1700X' OR [code]='364SP0813X' OR [code]='364SP0812X' OR [code]='364SP0811X' OR [code]='364SP0810X' OR [code]='364SP0809X' OR [code]='364SP0808X' OR [code]='364SP0807X' OR [code]='364SP0200X' OR [code]='364SN0800X' OR [code]='364SN0000X' OR [code]='364SM0705X' OR [code]='364SL0600X' OR [code]='364SI0800X' OR [code]='364SH1100X' OR [code]='364SH0200X' OR [code]='364SG0600X' OR [code]='364SF0001X' OR [code]='364SE1400X' OR [code]='364SE0003X' OR [code]='364SC2300X' OR [code]='364SC1501X' OR [code]='364SC0200X' OR [code]='364SA2200X' OR [code]='364SA2100X' OR [code]='364S00000X' OR [code]='363LX0106X' OR [code]='363LX0001X' OR [code]='363LW0102X' OR [code]='363LS0200X' OR [code]='363LP2300X' OR [code]='363LP1700X' OR [code]='363LP0808X' OR [code]='363LP0222X' OR [code]='363LP0200X' OR [code]='363LN0005X' OR [code]='363LN0000X' OR [code]='363LG0600X' OR [code]='363LF0000X' OR [code]='363LC1500X' OR [code]='363LC0200X' OR [code]='363LA2200X' OR [code]='363LA2100X' OR [code]='363L00000X' OR [code]='363AS0400X' OR [code]='363AM0700X' OR [code]='363A00000X' OR [code]='347E00000X' OR [code]='347D00000X' OR [code]='347C00000X' OR [code]='347B00000X' OR [code]='344800000X' OR [code]='344600000X' OR [code]='343900000X' OR [code]='343800000X' OR [code]='3418M1130X' OR [code]='3418M1120X' OR [code]='3418M1110X' OR [code]='341800000X' OR [code]='3416S0300X' OR [code]='3416L0300X' OR [code]='3416A0800X' OR [code]='341600000X' OR [code]='335V00000X' OR [code]='335U00000X' OR [code]='335G00000X' OR [code]='335E00000X' OR [code]='3336S0011X' OR [code]='3336N0007X' OR [code]='3336M0003X' OR [code]='3336M0002X' OR [code]='3336L0003X' OR [code]='3336I0012X' OR [code]='3336H0001X' OR [code]='3336C0004X' OR [code]='3336C0003X' OR [code]='3336C0002X' OR [code]='333600000X' OR [code]='333300000X' OR [code]='332U00000X' OR [code]='332S00000X' OR [code]='332H00000X' OR [code]='332G00000X' OR [code]='332BX2000X' OR [code]='332BP3500X' OR [code]='332BN1400X' OR [code]='332BD1200X' OR [code]='332BC3200X' OR [code]='332B00000X' OR [code]='332900000X' OR [code]='332800000X' OR [code]='332100000X' OR [code]='332000000X' OR [code]='331L00000X' OR [code]='3245S0500X' OR [code]='324500000X' OR [code]='323P00000X' OR [code]='322D00000X' OR [code]='320900000X' OR [code]='320800000X' OR [code]='320700000X' OR [code]='320600000X' OR [code]='315P00000X' OR [code]='315D00000X' OR [code]='3140N1450X' OR [code]='314000000X' OR [code]='313M00000X' OR [code]='311ZA0620X' OR [code]='311Z00000X' OR [code]='311500000X' OR [code]='310500000X' OR [code]='3104A0630X' OR [code]='3104A0625X' OR [code]='310400000X' OR [code]='305S00000X' OR [code]='305R00000X' OR [code]='302R00000X' OR [code]='302F00000X' OR [code]='293D00000X' OR [code]='292200000X' OR [code]='291U00000X' OR [code]='291900000X' OR [code]='2865X1600X' OR [code]='2865M2000X' OR [code]='286500000X' OR [code]='284300000X' OR [code]='283XC2000X' OR [code]='283X00000X' OR [code]='283Q00000X' OR [code]='282NW0100X' OR [code]='282NR1301X' OR [code]='282NC2000X' OR [code]='282NC0060X' OR [code]='282N00000X' OR [code]='282J00000X' OR [code]='282E00000X' OR [code]='281PC2000X' OR [code]='281P00000X' OR [code]='276400000X' OR [code]='275N00000X' OR [code]='273Y00000X' OR [code]='273R00000X' OR [code]='273100000X' OR [code]='261QX0203X' OR [code]='261QX0200X' OR [code]='261QX0100X' OR [code]='261QV0200X' OR [code]='261QU0200X' OR [code]='261QS1200X' OR [code]='261QS1000X' OR [code]='261QS0132X' OR [code]='261QS0112X' OR [code]='261QR1300X' OR [code]='261QR1100X' OR [code]='261QR0800X' OR [code]='261QR0405X' OR [code]='261QR0404X' OR [code]='261QR0401X' OR [code]='261QR0400X' OR [code]='261QR0208X' OR [code]='261QR0207X' OR [code]='261QR0206X' OR [code]='261QR0200X' OR [code]='261QP3300X' OR [code]='261QP2400X' OR [code]='261QP2300X' OR [code]='261QP2000X' OR [code]='261QP1100X' OR [code]='261QP0905X' OR [code]='261QP0904X' OR [code]='261QM3000X' OR [code]='261QM2800X' OR [code]='261QM2500X' OR [code]='261QM1300X' OR [code]='261QM1200X' OR [code]='261QM1103X' OR [code]='261QM1102X' OR [code]='261QM1101X' OR [code]='261QM1100X' OR [code]='261QM1000X' OR [code]='261QM0855X' OR [code]='261QM0850X' OR [code]='261QM0801X' OR [code]='261QL0400X' OR [code]='261QI0500X' OR [code]='261QH0700X' OR [code]='261QH0100X' OR [code]='261QG0250X' OR [code]='261QF0400X' OR [code]='261QF0050X' OR [code]='261QE0800X' OR [code]='261QE0700X' OR [code]='261QE0002X' OR [code]='261QD1600X' OR [code]='261QD0000X' OR [code]='261QC1800X' OR [code]='261QC1500X' OR [code]='261QC0050X' OR [code]='261QB0400X' OR [code]='261QA3000X' OR [code]='261QA1903X' OR [code]='261QA0900X' OR [code]='261QA0600X' OR [code]='261QA0006X' OR [code]='261QA0005X' OR [code]='261Q00000X' OR [code]='253Z00000X' OR [code]='253J00000X' OR [code]='252Y00000X' OR [code]='251X00000X' OR [code]='251V00000X' OR [code]='251T00000X' OR [code]='251S00000X' OR [code]='251K00000X' OR [code]='251J00000X' OR [code]='251G00000X' OR [code]='251F00000X' OR [code]='251E00000X' OR [code]='251C00000X' OR [code]='251B00000X' OR [code]='251300000X' OR [code]='247ZC0005X' OR [code]='2472V0600X' OR [code]='2472R0900X' OR [code]='2472E0500X' OR [code]='2472D0500X' OR [code]='2472B0301X' OR [code]='247200000X' OR [code]='2471V0106X' OR [code]='2471V0105X' OR [code]='2471S1302X' OR [code]='2471R0002X' OR [code]='2471Q0001X' OR [code]='2471N0900X' OR [code]='2471M2300X' OR [code]='2471M1202X' OR [code]='2471C3402X' OR [code]='2471C3401X' OR [code]='2471C1106X' OR [code]='2471C1101X' OR [code]='2471B0102X' OR [code]='247100000X' OR [code]='2470A2800X' OR [code]='247000000X' OR [code]='246ZX2200X' OR [code]='246ZS0410X' OR [code]='246ZN0300X' OR [code]='246ZI1000X' OR [code]='246ZG1000X' OR [code]='246ZG0701X' OR [code]='246ZE0600X' OR [code]='246ZE0500X' OR [code]='246ZC0007X' OR [code]='246ZB0600X' OR [code]='246ZB0500X' OR [code]='246ZB0302X' OR [code]='246ZB0301X' OR [code]='246ZA2600X' OR [code]='246Z00000X' OR [code]='246YR1600X' OR [code]='246YC3302X' OR [code]='246YC3301X' OR [code]='246Y00000X' OR [code]='246XS1301X' OR [code]='246XC2903X' OR [code]='246XC2901X' OR [code]='246X00000X' OR [code]='246W00000X' OR [code]='246RP1900X' OR [code]='246RM2200X' OR [code]='246RH0600X' OR [code]='246R00000X' OR [code]='246QM0900X' OR [code]='246QM0706X' OR [code]='246QL0901X' OR [code]='246QL0900X' OR [code]='246QI0000X' OR [code]='246QH0600X' OR [code]='246QH0401X' OR [code]='246QH0000X' OR [code]='246QC2700X' OR [code]='246QC1000X' OR [code]='246QB0000X' OR [code]='246Q00000X' OR [code]='243U00000X' OR [code]='242T00000X' OR [code]='237700000X' OR [code]='237600000X' OR [code]='235Z00000X' OR [code]='2355S0801X' OR [code]='2355A2700X' OR [code]='235500000X' OR [code]='231HA2500X' OR [code]='231HA2400X' OR [code]='231H00000X' OR [code]='229N00000X' OR [code]='2279S1500X' OR [code]='2279P4000X' OR [code]='2279P3900X' OR [code]='2279P3800X' OR [code]='2279P1006X' OR [code]='2279P1005X' OR [code]='2279P1004X' OR [code]='2279H0200X' OR [code]='2279G1100X' OR [code]='2279G0305X' OR [code]='2279E1000X' OR [code]='2279E0002X' OR [code]='2279C0205X' OR [code]='227900000X' OR [code]='2278S1500X' OR [code]='2278P4000X' OR [code]='2278P3900X' OR [code]='2278P3800X' OR [code]='2278P1006X' OR [code]='2278P1005X' OR [code]='2278P1004X' OR [code]='2278H0200X' OR [code]='2278G1100X' OR [code]='2278G0305X' OR [code]='2278E1000X' OR [code]='2278E0002X' OR [code]='2278C0205X' OR [code]='227800000X' OR [code]='226300000X' OR [code]='226000000X' OR [code]='225XR0403X' OR [code]='225XP0200X' OR [code]='225XP0019X' OR [code]='225XN1300X' OR [code]='225XM0800X' OR [code]='225XL0004X' OR [code]='225XH1300X' OR [code]='225XH1200X' OR [code]='225XG0600X' OR [code]='225XF0002X' OR [code]='225XE1200X' OR [code]='225XE0001X' OR [code]='225X00000X' OR [code]='225CX0006X' OR [code]='225CA2500X' OR [code]='225CA2400X' OR [code]='225C00000X' OR [code]='225B00000X' OR [code]='225A00000X' OR [code]='225800000X' OR [code]='225700000X' OR [code]='225600000X' OR [code]='2255R0406X' OR [code]='2255A2300X' OR [code]='225500000X' OR [code]='225400000X' OR [code]='225200000X' OR [code]='2251X0800X' OR [code]='2251S0007X' OR [code]='2251P0200X' OR [code]='2251N0400X' OR [code]='2251H1300X' OR [code]='2251H1200X' OR [code]='2251G0304X' OR [code]='2251E1300X' OR [code]='2251E1200X' OR [code]='2251C2600X' OR [code]='225100000X' OR [code]='225000000X' OR [code]='224ZR0403X' OR [code]='224ZL0004X' OR [code]='224ZF0002X' OR [code]='224ZE0001X' OR [code]='224Z00000X' OR [code]='224Y00000X' OR [code]='224P00000X' OR [code]='224L00000X' OR [code]='224900000X' OR [code]='222Z00000X' OR [code]='222Q00000X' OR [code]='221700000X' OR [code]='213ES0131X' OR [code]='213ES0103X' OR [code]='213ES0000X' OR [code]='213ER0200X' OR [code]='213EP1101X' OR [code]='213EP0504X' OR [code]='213E00000X' OR [code]='211D00000X' OR [code]='209800000X' OR [code]='208VP0014X' OR [code]='208VP0000X' OR [code]='208U00000X' OR [code]='208M00000X' OR [code]='208G00000X' OR [code]='208D00000X' OR [code]='208C00000X' OR [code]='2088P0231X' OR [code]='2088F0040X' OR [code]='208800000X' OR [code]='2086X0206X' OR [code]='2086S0129X' OR [code]='2086S0127X' OR [code]='2086S0122X' OR [code]='2086S0120X' OR [code]='2086S0105X' OR [code]='2086S0102X' OR [code]='2086H0002X' OR [code]='208600000X' OR [code]='2085U0001X' OR [code]='2085R0205X' OR [code]='2085R0204X' OR [code]='2085R0203X' OR [code]='2085R0202X' OR [code]='2085R0001X' OR [code]='2085P0229X' OR [code]='2085N0904X' OR [code]='2085N0700X' OR [code]='2085H0002X' OR [code]='2085D0003X' OR [code]='2085B0100X' OR [code]='2084V0102X' OR [code]='2084S0012X' OR [code]='2084S0010X' OR [code]='2084P2900X' OR [code]='2084P0805X' OR [code]='2084P0804X' OR [code]='2084P0802X' OR [code]='2084P0800X' OR [code]='2084P0301X' OR [code]='2084P0015X' OR [code]='2084P0005X' OR [code]='2084N0600X' OR [code]='2084N0402X' OR [code]='2084N0400X' OR [code]='2084N0008X' OR [code]='2084H0002X' OR [code]='2084F0202X' OR [code]='2084D0003X' OR [code]='2084B0040X' OR [code]='2084B0002X' OR [code]='2084A2900X' OR [code]='2084A0401X' OR [code]='2083X0100X' OR [code]='2083T0002X' OR [code]='2083S0010X' OR [code]='2083P0901X' OR [code]='2083P0500X' OR [code]='2083P0011X' OR [code]='2083C0008X' OR [code]='2083B0002X' OR [code]='2083A0300X' OR [code]='2083A0100X' OR [code]='2082S0105X' OR [code]='2082S0099X' OR [code]='208200000X' OR [code]='2081S0010X' OR [code]='2081P2900X' OR [code]='2081P0301X' OR [code]='2081P0010X' OR [code]='2081P0004X' OR [code]='2081N0008X' OR [code]='2081H0002X' OR [code]='208100000X' OR [code]='2080T0004X' OR [code]='2080T0002X' OR [code]='2080S0012X' OR [code]='2080S0010X' OR [code]='2080P0216X' OR [code]='2080P0214X' OR [code]='2080P0210X' OR [code]='2080P0208X' OR [code]='2080P0207X' OR [code]='2080P0206X' OR [code]='2080P0205X' OR [code]='2080P0204X' OR [code]='2080P0203X' OR [code]='2080P0202X' OR [code]='2080P0201X' OR [code]='2080P0008X' OR [code]='2080P0006X' OR [code]='2080N0001X' OR [code]='2080I0007X' OR [code]='2080H0002X' OR [code]='2080C0008X' OR [code]='2080B0002X' OR [code]='2080A0000X' OR [code]='208000000X' OR [code]='207ZP0213X' OR [code]='207ZP0105X' OR [code]='207ZP0104X' OR [code]='207ZP0102X' OR [code]='207ZP0101X' OR [code]='207ZP0007X' OR [code]='207ZN0500X' OR [code]='207ZM0300X' OR [code]='207ZI0100X' OR [code]='207ZH0000X' OR [code]='207ZF0201X' OR [code]='207ZD0900X' OR [code]='207ZC0500X' OR [code]='207ZC0008X' OR [code]='207ZC0006X' OR [code]='207ZB0001X' OR [code]='207YX0905X' OR [code]='207YX0901X' OR [code]='207YX0602X' OR [code]='207YX0007X' OR [code]='207YS0123X' OR [code]='207YS0012X' OR [code]='207YP0228X' OR [code]='207Y00000X' OR [code]='207XX0801X' OR [code]='207XX0005X' OR [code]='207XX0004X' OR [code]='207XS0117X' OR [code]='207XS0114X' OR [code]='207XS0106X' OR [code]='207XP3100X' OR [code]='207X00000X' OR [code]='207WX0200X' OR [code]='207WX0120X' OR [code]='207WX0110X' OR [code]='207WX0109X' OR [code]='207WX0108X' OR [code]='207WX0107X' OR [code]='207WX0009X' OR [code]='207W00000X' OR [code]='207VX0201X' OR [code]='207VX0000X' OR [code]='207VM0101X' OR [code]='207VH0002X' OR [code]='207VG0400X' OR [code]='207VF0040X' OR [code]='207VE0102X' OR [code]='207VC0200X' OR [code]='207VB0002X' OR [code]='207V00000X' OR [code]='207UN0903X' OR [code]='207UN0902X' OR [code]='207UN0901X' OR [code]='207U00000X' OR [code]='207T00000X' OR [code]='207SM0001X' OR [code]='207SG0205X' OR [code]='207SG0203X' OR [code]='207SG0202X' OR [code]='207SG0201X' OR [code]='207SC0300X' OR [code]='207RX0202X' OR [code]='207RT0003X' OR [code]='207RS0012X' OR [code]='207RS0010X' OR [code]='207RR0500X' OR [code]='207RP1001X' OR [code]='207RN0300X' OR [code]='207RM1200X' OR [code]='207RI0200X' OR [code]='207RI0011X' OR [code]='207RI0008X' OR [code]='207RI0001X' OR [code]='207RH0005X' OR [code]='207RH0003X' OR [code]='207RH0002X' OR [code]='207RH0000X' OR [code]='207RG0300X' OR [code]='207RG0100X' OR [code]='207RE0101X' OR [code]='207RC0200X' OR [code]='207RC0001X' OR [code]='207RC0000X' OR [code]='207RB0002X' OR [code]='207RA0401X' OR [code]='207RA0201X' OR [code]='207RA0002X' OR [code]='207RA0001X' OR [code]='207RA0000X' OR [code]='207R00000X' OR [code]='207QS1201X' OR [code]='207QS0010X' OR [code]='207QH0002X' OR [code]='207QG0300X' OR [code]='207QB0002X' OR [code]='207QA0505X' OR [code]='207QA0401X' OR [code]='207QA0000X' OR [code]='207Q00000X' OR [code]='207PT0002X' OR [code]='207PS0010X' OR [code]='207PP0204X' OR [code]='207PH0002X' OR [code]='207PE0005X' OR [code]='207PE0004X' OR [code]='207P00000X' OR [code]='207NS0135X' OR [code]='207NP0225X' OR [code]='207NI0002X' OR [code]='207ND0900X' OR [code]='207ND0101X' OR [code]='207N00000X' OR [code]='207LP3000X' OR [code]='207LP2900X' OR [code]='207LH0002X' OR [code]='207LC0200X' OR [code]='207LA0401X' OR [code]='207L00000X' OR [code]='207KI0005X' OR [code]='207KA0200X' OR [code]='207K00000X' OR [code]='204R00000X' OR [code]='204F00000X' OR [code]='204E00000X' OR [code]='204D00000X' OR [code]='204C00000X' OR [code]='202K00000X' OR [code]='202C00000X' OR [code]='193400000X' OR [code]='193200000X' OR [code]='183700000X' OR [code]='1835X0200X' OR [code]='1835P2201X' OR [code]='1835P1300X' OR [code]='1835P1200X' OR [code]='1835P0200X' OR [code]='1835P0018X' OR [code]='1835N1003X' OR [code]='1835N0905X' OR [code]='1835G0303X' OR [code]='1835C0205X' OR [code]='183500000X' OR [code]='177F00000X' OR [code]='176P00000X' OR [code]='176B00000X' OR [code]='175T00000X' OR [code]='175M00000X' OR [code]='175L00000X' OR [code]='175F00000X' OR [code]='174V00000X' OR [code]='174N00000X' OR [code]='174MM1900X' OR [code]='174M00000X' OR [code]='174H00000X' OR [code]='1744R1103X' OR [code]='1744R1102X' OR [code]='1744P3200X' OR [code]='1744G0900X' OR [code]='174400000X' OR [code]='174200000X' OR [code]='173F00000X' OR [code]='173C00000X' OR [code]='173000000X' OR [code]='172V00000X' OR [code]='172P00000X' OR [code]='172M00000X' OR [code]='172A00000X' OR [code]='171WV0202X' OR [code]='171WH0202X' OR [code]='171W00000X' OR [code]='171R00000X' OR [code]='171M00000X' OR [code]='171100000X' OR [code]='1710I1003X' OR [code]='1710I1002X' OR [code]='171000000X' OR [code]='170300000X' OR [code]='170100000X' OR [code]='167G00000X' OR [code]='164X00000X' OR [code]='164W00000X' OR [code]='163WX1500X' OR [code]='163WX1100X' OR [code]='163WX0800X' OR [code]='163WX0601X' OR [code]='163WX0200X' OR [code]='163WX0106X' OR [code]='163WX0003X' OR [code]='163WX0002X' OR [code]='163WW0101X' OR [code]='163WW0000X' OR [code]='163WU0100X' OR [code]='163WS0200X' OR [code]='163WS0121X' OR [code]='163WR1000X' OR [code]='163WR0400X' OR [code]='163WR0006X' OR [code]='163WP2201X' OR [code]='163WP1700X' OR [code]='163WP0809X' OR [code]='163WP0808X' OR [code]='163WP0807X' OR [code]='163WP0218X' OR [code]='163WP0200X' OR [code]='163WP0000X' OR [code]='163WN1003X' OR [code]='163WN0800X' OR [code]='163WN0300X' OR [code]='163WN0003X' OR [code]='163WN0002X' OR [code]='163WM1400X' OR [code]='163WM0705X' OR [code]='163WM0102X' OR [code]='163WL0100X' OR [code]='163WI0600X' OR [code]='163WI0500X' OR [code]='163WH1000X' OR [code]='163WH0500X' OR [code]='163WH0200X' OR [code]='163WG0600X' OR [code]='163WG0100X' OR [code]='163WG0000X' OR [code]='163WF0300X' OR [code]='163WE0900X' OR [code]='163WE0003X' OR [code]='163WD1100X' OR [code]='163WD0400X' OR [code]='163WC3500X' OR [code]='163WC2100X' OR [code]='163WC1600X' OR [code]='163WC1500X' OR [code]='163WC1400X' OR [code]='163WC0400X' OR [code]='163WC0200X' OR [code]='163WA2000X' OR [code]='163WA0400X' OR [code]='163W00000X' OR [code]='156FX1900X' OR [code]='156FX1800X' OR [code]='156FX1700X' OR [code]='156FX1202X' OR [code]='156FX1201X' OR [code]='156FX1101X' OR [code]='156FX1100X' OR [code]='156FC0801X' OR [code]='156FC0800X' OR [code]='156F00000X' OR [code]='152WX0102X' OR [code]='152WV0400X' OR [code]='152WS0006X' OR [code]='152WP0200X' OR [code]='152WL0500X' OR [code]='152WC0802X' OR [code]='152W00000X' OR [code]='146N00000X' OR [code]='146M00000X' OR [code]='146L00000X' OR [code]='146D00000X' OR [code]='136A00000X' OR [code]='133VN1501X' OR [code]='133VN1401X' OR [code]='133VN1301X' OR [code]='133VN1201X' OR [code]='133VN1101X' OR [code]='133VN1006X' OR [code]='133VN1005X' OR [code]='133VN1004X' OR [code]='133V00000X' OR [code]='133NN1002X' OR [code]='133N00000X' OR [code]='132700000X' OR [code]='126900000X' OR [code]='126800000X' OR [code]='125Q00000X' OR [code]='125K00000X' OR [code]='125J00000X' OR [code]='124Q00000X' OR [code]='122400000X' OR [code]='1223X2210X' OR [code]='1223X0400X' OR [code]='1223X0008X' OR [code]='1223S0112X' OR [code]='1223P0700X' OR [code]='1223P0300X' OR [code]='1223P0221X' OR [code]='1223P0106X' OR [code]='1223G0001X' OR [code]='1223E0200X' OR [code]='1223D0004X' OR [code]='1223D0001X' OR [code]='122300000X' OR [code]='111NX0800X' OR [code]='111NX0100X' OR [code]='111NT0100X' OR [code]='111NS0005X' OR [code]='111NR0400X' OR [code]='111NR0200X' OR [code]='111NP0017X' OR [code]='111NN1001X' OR [code]='111NN0400X' OR [code]='111NI0900X' OR [code]='111NI0013X' OR [code]='111N00000X' OR [code]='106S00000X' OR [code]='106H00000X' OR [code]='106E00000X' OR [code]='1041S0200X' OR [code]='1041C0700X' OR [code]='104100000X' OR [code]='103TS0200X' OR [code]='103TR0400X' OR [code]='103TP2701X' OR [code]='103TP0814X' OR [code]='103TP0016X' OR [code]='103TM1800X' OR [code]='103TH0100X' OR [code]='103TH0004X' OR [code]='103TF0200X' OR [code]='103TF0000X' OR [code]='103TE1100X' OR [code]='103TC2200X' OR [code]='103TC1900X' OR [code]='103TC0700X' OR [code]='103TB0200X' OR [code]='103TA0700X' OR [code]='103TA0400X' OR [code]='103T00000X' OR [code]='103K00000X' OR [code]='103G00000X' OR [code]='102X00000X' OR [code]='102L00000X' OR [code]='101YS0200X' OR [code]='101YP2500X' OR [code]='101YP1600X' OR [code]='101YM0800X' OR [code]='101YA0400X' OR [code]='101Y00000X' OR [code]='asked but unknown' OR [code]='unknown'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PractitionerResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PractitionerResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[active] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[birthDate] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([active]='false' OR [active]='true'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PractitionerRoleLocation' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PractitionerRoleLocation] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[LocationID] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PractitionerRoleResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PractitionerRoleResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[active] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodStart] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[periodEnd] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Practitioner] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[PractitionerDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Organization] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[OrganizationDisplay] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_PractitionerRoleSpecialty' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_PractitionerRoleSpecialty] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[code] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[name] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='405300000X' OR [code]='390200000X' OR [code]='385HR2065X' OR [code]='385HR2060X' OR [code]='385HR2055X' OR [code]='385HR2050X' OR [code]='385H00000X' OR [code]='376K00000X' OR [code]='376J00000X' OR [code]='376G00000X' OR [code]='374U00000X' OR [code]='374T00000X' OR [code]='374K00000X' OR [code]='374J00000X' OR [code]='3747P1801X' OR [code]='3747A0650X' OR [code]='374700000X' OR [code]='373H00000X' OR [code]='372600000X' OR [code]='372500000X' OR [code]='367H00000X' OR [code]='367A00000X' OR [code]='367500000X' OR [code]='364SX0204X' OR [code]='364SX0200X' OR [code]='364SX0106X' OR [code]='364SW0102X' OR [code]='364ST0500X' OR [code]='364SS0200X' OR [code]='364SR0400X' OR [code]='364SP2800X' OR [code]='364SP1700X' OR [code]='364SP0813X' OR [code]='364SP0812X' OR [code]='364SP0811X' OR [code]='364SP0810X' OR [code]='364SP0809X' OR [code]='364SP0808X' OR [code]='364SP0807X' OR [code]='364SP0200X' OR [code]='364SN0800X' OR [code]='364SN0000X' OR [code]='364SM0705X' OR [code]='364SL0600X' OR [code]='364SI0800X' OR [code]='364SH1100X' OR [code]='364SH0200X' OR [code]='364SG0600X' OR [code]='364SF0001X' OR [code]='364SE1400X' OR [code]='364SE0003X' OR [code]='364SC2300X' OR [code]='364SC1501X' OR [code]='364SC0200X' OR [code]='364SA2200X' OR [code]='364SA2100X' OR [code]='364S00000X' OR [code]='363LX0106X' OR [code]='363LX0001X' OR [code]='363LW0102X' OR [code]='363LS0200X' OR [code]='363LP2300X' OR [code]='363LP1700X' OR [code]='363LP0808X' OR [code]='363LP0222X' OR [code]='363LP0200X' OR [code]='363LN0005X' OR [code]='363LN0000X' OR [code]='363LG0600X' OR [code]='363LF0000X' OR [code]='363LC1500X' OR [code]='363LC0200X' OR [code]='363LA2200X' OR [code]='363LA2100X' OR [code]='363L00000X' OR [code]='363AS0400X' OR [code]='363AM0700X' OR [code]='363A00000X' OR [code]='347E00000X' OR [code]='347D00000X' OR [code]='347C00000X' OR [code]='347B00000X' OR [code]='344800000X' OR [code]='344600000X' OR [code]='343900000X' OR [code]='343800000X' OR [code]='3418M1130X' OR [code]='3418M1120X' OR [code]='3418M1110X' OR [code]='341800000X' OR [code]='3416S0300X' OR [code]='3416L0300X' OR [code]='3416A0800X' OR [code]='341600000X' OR [code]='335V00000X' OR [code]='335U00000X' OR [code]='335G00000X' OR [code]='335E00000X' OR [code]='3336S0011X' OR [code]='3336N0007X' OR [code]='3336M0003X' OR [code]='3336M0002X' OR [code]='3336L0003X' OR [code]='3336I0012X' OR [code]='3336H0001X' OR [code]='3336C0004X' OR [code]='3336C0003X' OR [code]='3336C0002X' OR [code]='333600000X' OR [code]='333300000X' OR [code]='332U00000X' OR [code]='332S00000X' OR [code]='332H00000X' OR [code]='332G00000X' OR [code]='332BX2000X' OR [code]='332BP3500X' OR [code]='332BN1400X' OR [code]='332BD1200X' OR [code]='332BC3200X' OR [code]='332B00000X' OR [code]='332900000X' OR [code]='332800000X' OR [code]='332100000X' OR [code]='332000000X' OR [code]='331L00000X' OR [code]='3245S0500X' OR [code]='324500000X' OR [code]='323P00000X' OR [code]='322D00000X' OR [code]='320900000X' OR [code]='320800000X' OR [code]='320700000X' OR [code]='320600000X' OR [code]='315P00000X' OR [code]='315D00000X' OR [code]='3140N1450X' OR [code]='314000000X' OR [code]='313M00000X' OR [code]='311ZA0620X' OR [code]='311Z00000X' OR [code]='311500000X' OR [code]='310500000X' OR [code]='3104A0630X' OR [code]='3104A0625X' OR [code]='310400000X' OR [code]='305S00000X' OR [code]='305R00000X' OR [code]='302R00000X' OR [code]='302F00000X' OR [code]='293D00000X' OR [code]='292200000X' OR [code]='291U00000X' OR [code]='291900000X' OR [code]='2865X1600X' OR [code]='2865M2000X' OR [code]='286500000X' OR [code]='284300000X' OR [code]='283XC2000X' OR [code]='283X00000X' OR [code]='283Q00000X' OR [code]='282NW0100X' OR [code]='282NR1301X' OR [code]='282NC2000X' OR [code]='282NC0060X' OR [code]='282N00000X' OR [code]='282J00000X' OR [code]='282E00000X' OR [code]='281PC2000X' OR [code]='281P00000X' OR [code]='276400000X' OR [code]='275N00000X' OR [code]='273Y00000X' OR [code]='273R00000X' OR [code]='273100000X' OR [code]='261QX0203X' OR [code]='261QX0200X' OR [code]='261QX0100X' OR [code]='261QV0200X' OR [code]='261QU0200X' OR [code]='261QS1200X' OR [code]='261QS1000X' OR [code]='261QS0132X' OR [code]='261QS0112X' OR [code]='261QR1300X' OR [code]='261QR1100X' OR [code]='261QR0800X' OR [code]='261QR0405X' OR [code]='261QR0404X' OR [code]='261QR0401X' OR [code]='261QR0400X' OR [code]='261QR0208X' OR [code]='261QR0207X' OR [code]='261QR0206X' OR [code]='261QR0200X' OR [code]='261QP3300X' OR [code]='261QP2400X' OR [code]='261QP2300X' OR [code]='261QP2000X' OR [code]='261QP1100X' OR [code]='261QP0905X' OR [code]='261QP0904X' OR [code]='261QM3000X' OR [code]='261QM2800X' OR [code]='261QM2500X' OR [code]='261QM1300X' OR [code]='261QM1200X' OR [code]='261QM1103X' OR [code]='261QM1102X' OR [code]='261QM1101X' OR [code]='261QM1100X' OR [code]='261QM1000X' OR [code]='261QM0855X' OR [code]='261QM0850X' OR [code]='261QM0801X' OR [code]='261QL0400X' OR [code]='261QI0500X' OR [code]='261QH0700X' OR [code]='261QH0100X' OR [code]='261QG0250X' OR [code]='261QF0400X' OR [code]='261QF0050X' OR [code]='261QE0800X' OR [code]='261QE0700X' OR [code]='261QE0002X' OR [code]='261QD1600X' OR [code]='261QD0000X' OR [code]='261QC1800X' OR [code]='261QC1500X' OR [code]='261QC0050X' OR [code]='261QB0400X' OR [code]='261QA3000X' OR [code]='261QA1903X' OR [code]='261QA0900X' OR [code]='261QA0600X' OR [code]='261QA0006X' OR [code]='261QA0005X' OR [code]='261Q00000X' OR [code]='253Z00000X' OR [code]='253J00000X' OR [code]='252Y00000X' OR [code]='251X00000X' OR [code]='251V00000X' OR [code]='251T00000X' OR [code]='251S00000X' OR [code]='251K00000X' OR [code]='251J00000X' OR [code]='251G00000X' OR [code]='251F00000X' OR [code]='251E00000X' OR [code]='251C00000X' OR [code]='251B00000X' OR [code]='251300000X' OR [code]='247ZC0005X' OR [code]='2472V0600X' OR [code]='2472R0900X' OR [code]='2472E0500X' OR [code]='2472D0500X' OR [code]='2472B0301X' OR [code]='247200000X' OR [code]='2471V0106X' OR [code]='2471V0105X' OR [code]='2471S1302X' OR [code]='2471R0002X' OR [code]='2471Q0001X' OR [code]='2471N0900X' OR [code]='2471M2300X' OR [code]='2471M1202X' OR [code]='2471C3402X' OR [code]='2471C3401X' OR [code]='2471C1106X' OR [code]='2471C1101X' OR [code]='2471B0102X' OR [code]='247100000X' OR [code]='2470A2800X' OR [code]='247000000X' OR [code]='246ZX2200X' OR [code]='246ZS0410X' OR [code]='246ZN0300X' OR [code]='246ZI1000X' OR [code]='246ZG1000X' OR [code]='246ZG0701X' OR [code]='246ZE0600X' OR [code]='246ZE0500X' OR [code]='246ZC0007X' OR [code]='246ZB0600X' OR [code]='246ZB0500X' OR [code]='246ZB0302X' OR [code]='246ZB0301X' OR [code]='246ZA2600X' OR [code]='246Z00000X' OR [code]='246YR1600X' OR [code]='246YC3302X' OR [code]='246YC3301X' OR [code]='246Y00000X' OR [code]='246XS1301X' OR [code]='246XC2903X' OR [code]='246XC2901X' OR [code]='246X00000X' OR [code]='246W00000X' OR [code]='246RP1900X' OR [code]='246RM2200X' OR [code]='246RH0600X' OR [code]='246R00000X' OR [code]='246QM0900X' OR [code]='246QM0706X' OR [code]='246QL0901X' OR [code]='246QL0900X' OR [code]='246QI0000X' OR [code]='246QH0600X' OR [code]='246QH0401X' OR [code]='246QH0000X' OR [code]='246QC2700X' OR [code]='246QC1000X' OR [code]='246QB0000X' OR [code]='246Q00000X' OR [code]='243U00000X' OR [code]='242T00000X' OR [code]='237700000X' OR [code]='237600000X' OR [code]='235Z00000X' OR [code]='2355S0801X' OR [code]='2355A2700X' OR [code]='235500000X' OR [code]='231HA2500X' OR [code]='231HA2400X' OR [code]='231H00000X' OR [code]='229N00000X' OR [code]='2279S1500X' OR [code]='2279P4000X' OR [code]='2279P3900X' OR [code]='2279P3800X' OR [code]='2279P1006X' OR [code]='2279P1005X' OR [code]='2279P1004X' OR [code]='2279H0200X' OR [code]='2279G1100X' OR [code]='2279G0305X' OR [code]='2279E1000X' OR [code]='2279E0002X' OR [code]='2279C0205X' OR [code]='227900000X' OR [code]='2278S1500X' OR [code]='2278P4000X' OR [code]='2278P3900X' OR [code]='2278P3800X' OR [code]='2278P1006X' OR [code]='2278P1005X' OR [code]='2278P1004X' OR [code]='2278H0200X' OR [code]='2278G1100X' OR [code]='2278G0305X' OR [code]='2278E1000X' OR [code]='2278E0002X' OR [code]='2278C0205X' OR [code]='227800000X' OR [code]='226300000X' OR [code]='226000000X' OR [code]='225XR0403X' OR [code]='225XP0200X' OR [code]='225XP0019X' OR [code]='225XN1300X' OR [code]='225XM0800X' OR [code]='225XL0004X' OR [code]='225XH1300X' OR [code]='225XH1200X' OR [code]='225XG0600X' OR [code]='225XF0002X' OR [code]='225XE1200X' OR [code]='225XE0001X' OR [code]='225X00000X' OR [code]='225CX0006X' OR [code]='225CA2500X' OR [code]='225CA2400X' OR [code]='225C00000X' OR [code]='225B00000X' OR [code]='225A00000X' OR [code]='225800000X' OR [code]='225700000X' OR [code]='225600000X' OR [code]='2255R0406X' OR [code]='2255A2300X' OR [code]='225500000X' OR [code]='225400000X' OR [code]='225200000X' OR [code]='2251X0800X' OR [code]='2251S0007X' OR [code]='2251P0200X' OR [code]='2251N0400X' OR [code]='2251H1300X' OR [code]='2251H1200X' OR [code]='2251G0304X' OR [code]='2251E1300X' OR [code]='2251E1200X' OR [code]='2251C2600X' OR [code]='225100000X' OR [code]='225000000X' OR [code]='224ZR0403X' OR [code]='224ZL0004X' OR [code]='224ZF0002X' OR [code]='224ZE0001X' OR [code]='224Z00000X' OR [code]='224Y00000X' OR [code]='224P00000X' OR [code]='224L00000X' OR [code]='224900000X' OR [code]='222Z00000X' OR [code]='222Q00000X' OR [code]='221700000X' OR [code]='213ES0131X' OR [code]='213ES0103X' OR [code]='213ES0000X' OR [code]='213ER0200X' OR [code]='213EP1101X' OR [code]='213EP0504X' OR [code]='213E00000X' OR [code]='211D00000X' OR [code]='209800000X' OR [code]='208VP0014X' OR [code]='208VP0000X' OR [code]='208U00000X' OR [code]='208M00000X' OR [code]='208G00000X' OR [code]='208D00000X' OR [code]='208C00000X' OR [code]='2088P0231X' OR [code]='2088F0040X' OR [code]='208800000X' OR [code]='2086X0206X' OR [code]='2086S0129X' OR [code]='2086S0127X' OR [code]='2086S0122X' OR [code]='2086S0120X' OR [code]='2086S0105X' OR [code]='2086S0102X' OR [code]='2086H0002X' OR [code]='208600000X' OR [code]='2085U0001X' OR [code]='2085R0205X' OR [code]='2085R0204X' OR [code]='2085R0203X' OR [code]='2085R0202X' OR [code]='2085R0001X' OR [code]='2085P0229X' OR [code]='2085N0904X' OR [code]='2085N0700X' OR [code]='2085H0002X' OR [code]='2085D0003X' OR [code]='2085B0100X' OR [code]='2084V0102X' OR [code]='2084S0012X' OR [code]='2084S0010X' OR [code]='2084P2900X' OR [code]='2084P0805X' OR [code]='2084P0804X' OR [code]='2084P0802X' OR [code]='2084P0800X' OR [code]='2084P0301X' OR [code]='2084P0015X' OR [code]='2084P0005X' OR [code]='2084N0600X' OR [code]='2084N0402X' OR [code]='2084N0400X' OR [code]='2084N0008X' OR [code]='2084H0002X' OR [code]='2084F0202X' OR [code]='2084D0003X' OR [code]='2084B0040X' OR [code]='2084B0002X' OR [code]='2084A2900X' OR [code]='2084A0401X' OR [code]='2083X0100X' OR [code]='2083T0002X' OR [code]='2083S0010X' OR [code]='2083P0901X' OR [code]='2083P0500X' OR [code]='2083P0011X' OR [code]='2083C0008X' OR [code]='2083B0002X' OR [code]='2083A0300X' OR [code]='2083A0100X' OR [code]='2082S0105X' OR [code]='2082S0099X' OR [code]='208200000X' OR [code]='2081S0010X' OR [code]='2081P2900X' OR [code]='2081P0301X' OR [code]='2081P0010X' OR [code]='2081P0004X' OR [code]='2081N0008X' OR [code]='2081H0002X' OR [code]='208100000X' OR [code]='2080T0004X' OR [code]='2080T0002X' OR [code]='2080S0012X' OR [code]='2080S0010X' OR [code]='2080P0216X' OR [code]='2080P0214X' OR [code]='2080P0210X' OR [code]='2080P0208X' OR [code]='2080P0207X' OR [code]='2080P0206X' OR [code]='2080P0205X' OR [code]='2080P0204X' OR [code]='2080P0203X' OR [code]='2080P0202X' OR [code]='2080P0201X' OR [code]='2080P0008X' OR [code]='2080P0006X' OR [code]='2080N0001X' OR [code]='2080I0007X' OR [code]='2080H0002X' OR [code]='2080C0008X' OR [code]='2080B0002X' OR [code]='2080A0000X' OR [code]='208000000X' OR [code]='207ZP0213X' OR [code]='207ZP0105X' OR [code]='207ZP0104X' OR [code]='207ZP0102X' OR [code]='207ZP0101X' OR [code]='207ZP0007X' OR [code]='207ZN0500X' OR [code]='207ZM0300X' OR [code]='207ZI0100X' OR [code]='207ZH0000X' OR [code]='207ZF0201X' OR [code]='207ZD0900X' OR [code]='207ZC0500X' OR [code]='207ZC0008X' OR [code]='207ZC0006X' OR [code]='207ZB0001X' OR [code]='207YX0905X' OR [code]='207YX0901X' OR [code]='207YX0602X' OR [code]='207YX0007X' OR [code]='207YS0123X' OR [code]='207YS0012X' OR [code]='207YP0228X' OR [code]='207Y00000X' OR [code]='207XX0801X' OR [code]='207XX0005X' OR [code]='207XX0004X' OR [code]='207XS0117X' OR [code]='207XS0114X' OR [code]='207XS0106X' OR [code]='207XP3100X' OR [code]='207X00000X' OR [code]='207WX0200X' OR [code]='207WX0120X' OR [code]='207WX0110X' OR [code]='207WX0109X' OR [code]='207WX0108X' OR [code]='207WX0107X' OR [code]='207WX0009X' OR [code]='207W00000X' OR [code]='207VX0201X' OR [code]='207VX0000X' OR [code]='207VM0101X' OR [code]='207VH0002X' OR [code]='207VG0400X' OR [code]='207VF0040X' OR [code]='207VE0102X' OR [code]='207VC0200X' OR [code]='207VB0002X' OR [code]='207V00000X' OR [code]='207UN0903X' OR [code]='207UN0902X' OR [code]='207UN0901X' OR [code]='207U00000X' OR [code]='207T00000X' OR [code]='207SM0001X' OR [code]='207SG0205X' OR [code]='207SG0203X' OR [code]='207SG0202X' OR [code]='207SG0201X' OR [code]='207SC0300X' OR [code]='207RX0202X' OR [code]='207RT0003X' OR [code]='207RS0012X' OR [code]='207RS0010X' OR [code]='207RR0500X' OR [code]='207RP1001X' OR [code]='207RN0300X' OR [code]='207RM1200X' OR [code]='207RI0200X' OR [code]='207RI0011X' OR [code]='207RI0008X' OR [code]='207RI0001X' OR [code]='207RH0005X' OR [code]='207RH0003X' OR [code]='207RH0002X' OR [code]='207RH0000X' OR [code]='207RG0300X' OR [code]='207RG0100X' OR [code]='207RE0101X' OR [code]='207RC0200X' OR [code]='207RC0001X' OR [code]='207RC0000X' OR [code]='207RB0002X' OR [code]='207RA0401X' OR [code]='207RA0201X' OR [code]='207RA0002X' OR [code]='207RA0001X' OR [code]='207RA0000X' OR [code]='207R00000X' OR [code]='207QS1201X' OR [code]='207QS0010X' OR [code]='207QH0002X' OR [code]='207QG0300X' OR [code]='207QB0002X' OR [code]='207QA0505X' OR [code]='207QA0401X' OR [code]='207QA0000X' OR [code]='207Q00000X' OR [code]='207PT0002X' OR [code]='207PS0010X' OR [code]='207PP0204X' OR [code]='207PH0002X' OR [code]='207PE0005X' OR [code]='207PE0004X' OR [code]='207P00000X' OR [code]='207NS0135X' OR [code]='207NP0225X' OR [code]='207NI0002X' OR [code]='207ND0900X' OR [code]='207ND0101X' OR [code]='207N00000X' OR [code]='207LP3000X' OR [code]='207LP2900X' OR [code]='207LH0002X' OR [code]='207LC0200X' OR [code]='207LA0401X' OR [code]='207L00000X' OR [code]='207KI0005X' OR [code]='207KA0200X' OR [code]='207K00000X' OR [code]='204R00000X' OR [code]='204F00000X' OR [code]='204E00000X' OR [code]='204D00000X' OR [code]='204C00000X' OR [code]='202K00000X' OR [code]='202C00000X' OR [code]='193400000X' OR [code]='193200000X' OR [code]='183700000X' OR [code]='1835X0200X' OR [code]='1835P2201X' OR [code]='1835P1300X' OR [code]='1835P1200X' OR [code]='1835P0200X' OR [code]='1835P0018X' OR [code]='1835N1003X' OR [code]='1835N0905X' OR [code]='1835G0303X' OR [code]='1835C0205X' OR [code]='183500000X' OR [code]='177F00000X' OR [code]='176P00000X' OR [code]='176B00000X' OR [code]='175T00000X' OR [code]='175M00000X' OR [code]='175L00000X' OR [code]='175F00000X' OR [code]='174V00000X' OR [code]='174N00000X' OR [code]='174MM1900X' OR [code]='174M00000X' OR [code]='174H00000X' OR [code]='1744R1103X' OR [code]='1744R1102X' OR [code]='1744P3200X' OR [code]='1744G0900X' OR [code]='174400000X' OR [code]='174200000X' OR [code]='173F00000X' OR [code]='173C00000X' OR [code]='173000000X' OR [code]='172V00000X' OR [code]='172P00000X' OR [code]='172M00000X' OR [code]='172A00000X' OR [code]='171WV0202X' OR [code]='171WH0202X' OR [code]='171W00000X' OR [code]='171R00000X' OR [code]='171M00000X' OR [code]='171100000X' OR [code]='1710I1003X' OR [code]='1710I1002X' OR [code]='171000000X' OR [code]='170300000X' OR [code]='170100000X' OR [code]='167G00000X' OR [code]='164X00000X' OR [code]='164W00000X' OR [code]='163WX1500X' OR [code]='163WX1100X' OR [code]='163WX0800X' OR [code]='163WX0601X' OR [code]='163WX0200X' OR [code]='163WX0106X' OR [code]='163WX0003X' OR [code]='163WX0002X' OR [code]='163WW0101X' OR [code]='163WW0000X' OR [code]='163WU0100X' OR [code]='163WS0200X' OR [code]='163WS0121X' OR [code]='163WR1000X' OR [code]='163WR0400X' OR [code]='163WR0006X' OR [code]='163WP2201X' OR [code]='163WP1700X' OR [code]='163WP0809X' OR [code]='163WP0808X' OR [code]='163WP0807X' OR [code]='163WP0218X' OR [code]='163WP0200X' OR [code]='163WP0000X' OR [code]='163WN1003X' OR [code]='163WN0800X' OR [code]='163WN0300X' OR [code]='163WN0003X' OR [code]='163WN0002X' OR [code]='163WM1400X' OR [code]='163WM0705X' OR [code]='163WM0102X' OR [code]='163WL0100X' OR [code]='163WI0600X' OR [code]='163WI0500X' OR [code]='163WH1000X' OR [code]='163WH0500X' OR [code]='163WH0200X' OR [code]='163WG0600X' OR [code]='163WG0100X' OR [code]='163WG0000X' OR [code]='163WF0300X' OR [code]='163WE0900X' OR [code]='163WE0003X' OR [code]='163WD1100X' OR [code]='163WD0400X' OR [code]='163WC3500X' OR [code]='163WC2100X' OR [code]='163WC1600X' OR [code]='163WC1500X' OR [code]='163WC1400X' OR [code]='163WC0400X' OR [code]='163WC0200X' OR [code]='163WA2000X' OR [code]='163WA0400X' OR [code]='163W00000X' OR [code]='156FX1900X' OR [code]='156FX1800X' OR [code]='156FX1700X' OR [code]='156FX1202X' OR [code]='156FX1201X' OR [code]='156FX1101X' OR [code]='156FX1100X' OR [code]='156FC0801X' OR [code]='156FC0800X' OR [code]='156F00000X' OR [code]='152WX0102X' OR [code]='152WV0400X' OR [code]='152WS0006X' OR [code]='152WP0200X' OR [code]='152WL0500X' OR [code]='152WC0802X' OR [code]='152W00000X' OR [code]='146N00000X' OR [code]='146M00000X' OR [code]='146L00000X' OR [code]='146D00000X' OR [code]='136A00000X' OR [code]='133VN1501X' OR [code]='133VN1401X' OR [code]='133VN1301X' OR [code]='133VN1201X' OR [code]='133VN1101X' OR [code]='133VN1006X' OR [code]='133VN1005X' OR [code]='133VN1004X' OR [code]='133V00000X' OR [code]='133NN1002X' OR [code]='133N00000X' OR [code]='132700000X' OR [code]='126900000X' OR [code]='126800000X' OR [code]='125Q00000X' OR [code]='125K00000X' OR [code]='125J00000X' OR [code]='124Q00000X' OR [code]='122400000X' OR [code]='1223X2210X' OR [code]='1223X0400X' OR [code]='1223X0008X' OR [code]='1223S0112X' OR [code]='1223P0700X' OR [code]='1223P0300X' OR [code]='1223P0221X' OR [code]='1223P0106X' OR [code]='1223G0001X' OR [code]='1223E0200X' OR [code]='1223D0004X' OR [code]='1223D0001X' OR [code]='122300000X' OR [code]='111NX0800X' OR [code]='111NX0100X' OR [code]='111NT0100X' OR [code]='111NS0005X' OR [code]='111NR0400X' OR [code]='111NR0200X' OR [code]='111NP0017X' OR [code]='111NN1001X' OR [code]='111NN0400X' OR [code]='111NI0900X' OR [code]='111NI0013X' OR [code]='111N00000X' OR [code]='106S00000X' OR [code]='106H00000X' OR [code]='106E00000X' OR [code]='1041S0200X' OR [code]='1041C0700X' OR [code]='104100000X' OR [code]='103TS0200X' OR [code]='103TR0400X' OR [code]='103TP2701X' OR [code]='103TP0814X' OR [code]='103TP0016X' OR [code]='103TM1800X' OR [code]='103TH0100X' OR [code]='103TH0004X' OR [code]='103TF0200X' OR [code]='103TF0000X' OR [code]='103TE1100X' OR [code]='103TC2200X' OR [code]='103TC1900X' OR [code]='103TC0700X' OR [code]='103TB0200X' OR [code]='103TA0700X' OR [code]='103TA0400X' OR [code]='103T00000X' OR [code]='103K00000X' OR [code]='103G00000X' OR [code]='102X00000X' OR [code]='102L00000X' OR [code]='101YS0200X' OR [code]='101YP2500X' OR [code]='101YP1600X' OR [code]='101YM0800X' OR [code]='101YA0400X' OR [code]='101Y00000X' OR [code]='asked but unknown' OR [code]='unknown'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ProcedureFocalDevice' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ProcedureFocalDevice] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[actionCode] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[actionDisplay] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([actionCode]='713295009' OR [actionCode]='702569007' OR [actionCode]='698798002' OR [actionCode]='698797007' OR [actionCode]='698796003' OR [actionCode]='698794000' OR [actionCode]='698793006' OR [actionCode]='698792001' OR [actionCode]='698790009' OR [actionCode]='698789000' OR [actionCode]='698788008' OR [actionCode]='445103003' OR [actionCode]='442837002' OR [actionCode]='441504007' OR [actionCode]='440647007' OR [actionCode]='440338007' OR [actionCode]='439513008' OR [actionCode]='439417007' OR [actionCode]='439315000' OR [actionCode]='439237009' OR [actionCode]='439054007' OR [actionCode]='430975009' OR [actionCode]='428381003' OR [actionCode]='428010000' OR [actionCode]='426865009' OR [actionCode]='426530000' OR [actionCode]='426413004' OR [actionCode]='425764006' OR [actionCode]='425704008' OR [actionCode]='425689005' OR [actionCode]='425362007' OR [actionCode]='424900004' OR [actionCode]='424832003' OR [actionCode]='424208002' OR [actionCode]='419988009' OR [actionCode]='419656003' OR [actionCode]='419652001' OR [actionCode]='419385000' OR [actionCode]='416677001' OR [actionCode]='415186003' OR [actionCode]='410820007' OR [actionCode]='410817004' OR [actionCode]='410814006' OR [actionCode]='410769003' OR [actionCode]='410759009' OR [actionCode]='410758001' OR [actionCode]='410757006' OR [actionCode]='410756002' OR [actionCode]='410467002' OR [actionCode]='410466006' OR [actionCode]='410465005' OR [actionCode]='410464009' OR [actionCode]='410463003' OR [actionCode]='410462008' OR [actionCode]='410461001' OR [actionCode]='410460000' OR [actionCode]='399155008' OR [actionCode]='399064001' OR [actionCode]='399035005' OR [actionCode]='399015009' OR [actionCode]='399009009' OR [actionCode]='386746003' OR [actionCode]='369242005' OR [actionCode]='367740008' OR [actionCode]='367642006' OR [actionCode]='367560003' OR [actionCode]='367559008' OR [actionCode]='367558000' OR [actionCode]='367529003' OR [actionCode]='363678002' OR [actionCode]='363659002' OR [actionCode]='362939006' OR [actionCode]='360393008' OR [actionCode]='360325005' OR [actionCode]='360324009' OR [actionCode]='360323003' OR [actionCode]='360315000' OR [actionCode]='360314001' OR [actionCode]='360273002' OR [actionCode]='360272007' OR [actionCode]='360270004' OR [actionCode]='360240009' OR [actionCode]='360239007' OR [actionCode]='360232003' OR [actionCode]='360231005' OR [actionCode]='360226008' OR [actionCode]='360223000' OR [actionCode]='360222005' OR [actionCode]='360220002' OR [actionCode]='360166003' OR [actionCode]='360165004' OR [actionCode]='360163006' OR [actionCode]='360161008' OR [actionCode]='360160009' OR [actionCode]='360154009' OR [actionCode]='360153003' OR [actionCode]='360152008' OR [actionCode]='360150000' OR [actionCode]='360149000' OR [actionCode]='360148008' OR [actionCode]='360147003' OR [actionCode]='360146007' OR [actionCode]='360087006' OR [actionCode]='360084004' OR [actionCode]='360082000' OR [actionCode]='360060007' OR [actionCode]='360051004' OR [actionCode]='360038009' OR [actionCode]='360037004' OR [actionCode]='360032005' OR [actionCode]='360029007' OR [actionCode]='360028004' OR [actionCode]='360027009' OR [actionCode]='360025001' OR [actionCode]='360021005' OR [actionCode]='360020006' OR [actionCode]='360018008' OR [actionCode]='360017003' OR [actionCode]='313029009' OR [actionCode]='312883004' OR [actionCode]='312421008' OR [actionCode]='312337001' OR [actionCode]='312336005' OR [actionCode]='312275004' OR [actionCode]='312254007' OR [actionCode]='312251004' OR [actionCode]='312250003' OR [actionCode]='312236008' OR [actionCode]='304904003' OR [actionCode]='304054006' OR [actionCode]='303998004' OR [actionCode]='303996000' OR [actionCode]='303955003' OR [actionCode]='303894001' OR [actionCode]='303893007' OR [actionCode]='302205006' OR [actionCode]='302204005' OR [actionCode]='302199004' OR [actionCode]='302196006' OR [actionCode]='302193003' OR [actionCode]='299893001' OR [actionCode]='299713009' OR [actionCode]='299712004' OR [actionCode]='298116000' OR [actionCode]='298053008' OR [actionCode]='297183000' OR [actionCode]='297179000' OR [actionCode]='290001001' OR [actionCode]='289938008' OR [actionCode]='289936007' OR [actionCode]='289930001' OR [actionCode]='289928003' OR [actionCode]='288468001' OR [actionCode]='288466002' OR [actionCode]='288324002' OR [actionCode]='287682008' OR [actionCode]='286792001' OR [actionCode]='286637000' OR [actionCode]='286553006' OR [actionCode]='282722008' OR [actionCode]='282089006' OR [actionCode]='282015008' OR [actionCode]='281839004' OR [actionCode]='281838007' OR [actionCode]='281767003' OR [actionCode]='281698007' OR [actionCode]='281615006' OR [actionCode]='281613004' OR [actionCode]='281609006' OR [actionCode]='278420002' OR [actionCode]='278313005' OR [actionCode]='278312000' OR [actionCode]='278292003' OR [actionCode]='278110001' OR [actionCode]='277852005' OR [actionCode]='277851003' OR [actionCode]='277763000' OR [actionCode]='277607009' OR [actionCode]='277261002' OR [actionCode]='276734006' OR [actionCode]='274392008' OR [actionCode]='272381008' OR [actionCode]='264947006' OR [actionCode]='264739002' OR [actionCode]='264730003' OR [actionCode]='264594007' OR [actionCode]='264592006' OR [actionCode]='263720003' OR [actionCode]='262143007' OR [actionCode]='261576000' OR [actionCode]='261569005' OR [actionCode]='261553003' OR [actionCode]='261545006' OR [actionCode]='261526002' OR [actionCode]='261520008' OR [actionCode]='261519002' OR [actionCode]='261518005' OR [actionCode]='261499003' OR [actionCode]='261498006' OR [actionCode]='261398005' OR [actionCode]='261391004' OR [actionCode]='261199008' OR [actionCode]='261198000' OR [actionCode]='261197005' OR [actionCode]='261191006' OR [actionCode]='261027000' OR [actionCode]='260222006' OR [actionCode]='258061005' OR [actionCode]='257940003' OR [actionCode]='257938008' OR [actionCode]='257937003' OR [actionCode]='257935006' OR [actionCode]='257933004' OR [actionCode]='257928003' OR [actionCode]='257926004' OR [actionCode]='257923007' OR [actionCode]='257918007' OR [actionCode]='257917002' OR [actionCode]='257916006' OR [actionCode]='257915005' OR [actionCode]='257914009' OR [actionCode]='257913003' OR [actionCode]='257912008' OR [actionCode]='257911001' OR [actionCode]='257907007' OR [actionCode]='257906003' OR [actionCode]='257905004' OR [actionCode]='257903006' OR [actionCode]='257897002' OR [actionCode]='257895005' OR [actionCode]='257894009' OR [actionCode]='257893003' OR [actionCode]='257890000' OR [actionCode]='257889009' OR [actionCode]='257886002' OR [actionCode]='257885003' OR [actionCode]='257884004' OR [actionCode]='257880008' OR [actionCode]='257878002' OR [actionCode]='257867005' OR [actionCode]='257863009' OR [actionCode]='257859002' OR [actionCode]='257857000' OR [actionCode]='257855008' OR [actionCode]='257850003' OR [actionCode]='257846005' OR [actionCode]='257825001' OR [actionCode]='257824002' OR [actionCode]='257822003' OR [actionCode]='257821005' OR [actionCode]='257817003' OR [actionCode]='257811002' OR [actionCode]='257808003' OR [actionCode]='257806004' OR [actionCode]='257805000' OR [actionCode]='257804001' OR [actionCode]='257803007' OR [actionCode]='257802002' OR [actionCode]='257791009' OR [actionCode]='257789001' OR [actionCode]='257788009' OR [actionCode]='257786008' OR [actionCode]='257785007' OR [actionCode]='257784006' OR [actionCode]='257783000' OR [actionCode]='257782005' OR [actionCode]='257781003' OR [actionCode]='257780002' OR [actionCode]='257778008' OR [actionCode]='257777003' OR [actionCode]='257768005' OR [actionCode]='257759008' OR [actionCode]='257751006' OR [actionCode]='257750007' OR [actionCode]='257749007' OR [actionCode]='257748004' OR [actionCode]='257747009' OR [actionCode]='257746000' OR [actionCode]='257745001' OR [actionCode]='257744002' OR [actionCode]='257743008' OR [actionCode]='257742003' OR [actionCode]='257741005' OR [actionCode]='257739009' OR [actionCode]='257730008' OR [actionCode]='257729003' OR [actionCode]='256644001' OR [actionCode]='255595002' OR [actionCode]='245855002' OR [actionCode]='245854003' OR [actionCode]='183648002' OR [actionCode]='129449000' OR [actionCode]='129445006' OR [actionCode]='129444005' OR [actionCode]='129443004' OR [actionCode]='129442009' OR [actionCode]='129441002' OR [actionCode]='129438006' OR [actionCode]='129437001' OR [actionCode]='129436005' OR [actionCode]='129435009' OR [actionCode]='129434008' OR [actionCode]='129433002' OR [actionCode]='129431000' OR [actionCode]='129430004' OR [actionCode]='129427006' OR [actionCode]='129426002' OR [actionCode]='129425003' OR [actionCode]='129424004' OR [actionCode]='129423005' OR [actionCode]='129421007' OR [actionCode]='129420008' OR [actionCode]='129419002' OR [actionCode]='129418005' OR [actionCode]='129416009' OR [actionCode]='129415008' OR [actionCode]='129414007' OR [actionCode]='129413001' OR [actionCode]='129412006' OR [actionCode]='129411004' OR [actionCode]='129410003' OR [actionCode]='129409008' OR [actionCode]='129408000' OR [actionCode]='129407005' OR [actionCode]='129406001' OR [actionCode]='129405002' OR [actionCode]='129404003' OR [actionCode]='129403009' OR [actionCode]='129402004' OR [actionCode]='129401006' OR [actionCode]='129400007' OR [actionCode]='129399000' OR [actionCode]='129398008' OR [actionCode]='129397003' OR [actionCode]='129396007' OR [actionCode]='129395006' OR [actionCode]='129394005' OR [actionCode]='129393004' OR [actionCode]='129392009' OR [actionCode]='129391002' OR [actionCode]='129390001' OR [actionCode]='129389005' OR [actionCode]='129388002' OR [actionCode]='129387007' OR [actionCode]='129386003' OR [actionCode]='129385004' OR [actionCode]='129384000' OR [actionCode]='129383006' OR [actionCode]='129382001' OR [actionCode]='129381008' OR [actionCode]='129380009' OR [actionCode]='129379006' OR [actionCode]='129378003' OR [actionCode]='129377008' OR [actionCode]='129376004' OR [actionCode]='129374001' OR [actionCode]='129373007' OR [actionCode]='129372002' OR [actionCode]='129371009' OR [actionCode]='129369009' OR [actionCode]='129368001' OR [actionCode]='129366002' OR [actionCode]='129360008' OR [actionCode]='129358006' OR [actionCode]='129357001' OR [actionCode]='129356005' OR [actionCode]='129355009' OR [actionCode]='129354008' OR [actionCode]='129353002' OR [actionCode]='129352007' OR [actionCode]='129351000' OR [actionCode]='129350004' OR [actionCode]='129349004' OR [actionCode]='129348007' OR [actionCode]='129347002' OR [actionCode]='129346006' OR [actionCode]='129345005' OR [actionCode]='129344009' OR [actionCode]='129340000' OR [actionCode]='129339002' OR [actionCode]='129337000' OR [actionCode]='129335008' OR [actionCode]='129334007' OR [actionCode]='129333001' OR [actionCode]='129332006' OR [actionCode]='129331004' OR [actionCode]='129330003' OR [actionCode]='129328000' OR [actionCode]='129327005' OR [actionCode]='129326001' OR [actionCode]='129325002' OR [actionCode]='129324003' OR [actionCode]='129323009' OR [actionCode]='129322004' OR [actionCode]='129321006' OR [actionCode]='129319001' OR [actionCode]='129318009' OR [actionCode]='129317004' OR [actionCode]='129316008' OR [actionCode]='129315007' OR [actionCode]='129314006' OR [actionCode]='129313000' OR [actionCode]='129312005' OR [actionCode]='129311003' OR [actionCode]='129310002' OR [actionCode]='129309007' OR [actionCode]='129308004' OR [actionCode]='129307009' OR [actionCode]='129306000' OR [actionCode]='129305001' OR [actionCode]='129304002' OR [actionCode]='129303008' OR [actionCode]='129301005' OR [actionCode]='129300006' OR [actionCode]='129299003' OR [actionCode]='129298006' OR [actionCode]='129297001' OR [actionCode]='129296005' OR [actionCode]='129295009' OR [actionCode]='129294008' OR [actionCode]='129293002' OR [actionCode]='129292007' OR [actionCode]='129291000' OR [actionCode]='129289008' OR [actionCode]='129288000' OR [actionCode]='129287005' OR [actionCode]='129286001' OR [actionCode]='129284003' OR [actionCode]='129283009' OR [actionCode]='129280007' OR [actionCode]='129279009' OR [actionCode]='129278001' OR [actionCode]='129277006' OR [actionCode]='129276002' OR [actionCode]='129275003' OR [actionCode]='129274004' OR [actionCode]='129273005' OR [actionCode]='129272000' OR [actionCode]='129271007' OR [actionCode]='129269007' OR [actionCode]='129268004' OR [actionCode]='129267009' OR [actionCode]='129266000' OR [actionCode]='129265001'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ProcedurePerformer' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ProcedurePerformer] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[id] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[performerFunction] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([performerFunction]='999480461000087104' OR [performerFunction]='999480451000087102' OR [performerFunction]='990928611000087105' OR [performerFunction]='984095901000087105' OR [performerFunction]='969118571000087109' OR [performerFunction]='956387501000087102' OR [performerFunction]='954544641000087107' OR [performerFunction]='926871431000087103' OR [performerFunction]='853827051000087104' OR [performerFunction]='847240411000087102' OR [performerFunction]='822410621000087104' OR [performerFunction]='813758161000087106' OR [performerFunction]='767205061000087108' OR [performerFunction]='766788081000087100' OR [performerFunction]='747936471000087102' OR [performerFunction]='724111801000087104' OR [performerFunction]='682131381000087105' OR [performerFunction]='673825031000087109' OR [performerFunction]='666997781000087107' OR [performerFunction]='623630151000087105' OR [performerFunction]='619197631000087102' OR [performerFunction]='494782281000087101' OR [performerFunction]='465511991000087105' OR [performerFunction]='450044741000087104' OR [performerFunction]='416186861000087101' OR [performerFunction]='398480381000087106' OR [performerFunction]='368890881000087105' OR [performerFunction]='341320851000087105' OR [performerFunction]='291705421000087106' OR [performerFunction]='285631911000087106' OR [performerFunction]='260767431000087107' OR [performerFunction]='258508741000087105' OR [performerFunction]='236749831000087105' OR [performerFunction]='231189271000087109' OR [performerFunction]='3981000175106' OR [performerFunction]='471302004' OR [performerFunction]='449161006' OR [performerFunction]='446701002' OR [performerFunction]='446050000' OR [performerFunction]='445451001' OR [performerFunction]='445313000' OR [performerFunction]='444912007' OR [performerFunction]='443090005' OR [performerFunction]='442867008' OR [performerFunction]='432100008' OR [performerFunction]='422234006' OR [performerFunction]='422140007' OR [performerFunction]='421841007' OR [performerFunction]='420678001' OR [performerFunction]='420409002' OR [performerFunction]='416160000' OR [performerFunction]='415506007' OR [performerFunction]='415075003' OR [performerFunction]='413854007' OR [performerFunction]='409975003' OR [performerFunction]='409974004' OR [performerFunction]='408799001' OR [performerFunction]='408798009' OR [performerFunction]='405685006' OR [performerFunction]='405684005' OR [performerFunction]='405623001' OR [performerFunction]='405279007' OR [performerFunction]='405278004' OR [performerFunction]='405277009' OR [performerFunction]='404940000' OR [performerFunction]='398238009' OR [performerFunction]='398130009' OR [performerFunction]='397908005' OR [performerFunction]='397903001' OR [performerFunction]='397897005' OR [performerFunction]='397824005' OR [performerFunction]='394618009' OR [performerFunction]='394572006' OR [performerFunction]='387619007' OR [performerFunction]='372102007' OR [performerFunction]='312485001' OR [performerFunction]='311441001' OR [performerFunction]='310512001' OR [performerFunction]='310194009' OR [performerFunction]='310193003' OR [performerFunction]='310192008' OR [performerFunction]='310191001' OR [performerFunction]='310190000' OR [performerFunction]='310189009' OR [performerFunction]='310188001' OR [performerFunction]='310187006' OR [performerFunction]='310186002' OR [performerFunction]='310185003' OR [performerFunction]='310184004' OR [performerFunction]='310183005' OR [performerFunction]='310182000' OR [performerFunction]='310181007' OR [performerFunction]='310180008' OR [performerFunction]='310179005' OR [performerFunction]='310178002' OR [performerFunction]='310177007' OR [performerFunction]='310176003' OR [performerFunction]='310175004' OR [performerFunction]='310174000' OR [performerFunction]='310173006' OR [performerFunction]='310172001' OR [performerFunction]='310171008' OR [performerFunction]='310170009' OR [performerFunction]='309460000' OR [performerFunction]='309459005' OR [performerFunction]='309455004' OR [performerFunction]='309454000' OR [performerFunction]='309453006' OR [performerFunction]='309452001' OR [performerFunction]='309450009' OR [performerFunction]='309446002' OR [performerFunction]='309445003' OR [performerFunction]='309444004' OR [performerFunction]='309443005' OR [performerFunction]='309442000' OR [performerFunction]='309441007' OR [performerFunction]='309440008' OR [performerFunction]='309439006' OR [performerFunction]='309437008' OR [performerFunction]='309436004' OR [performerFunction]='309435000' OR [performerFunction]='309434001' OR [performerFunction]='309429000' OR [performerFunction]='309428008' OR [performerFunction]='309427003' OR [performerFunction]='309423004' OR [performerFunction]='309422009' OR [performerFunction]='309421002' OR [performerFunction]='309420001' OR [performerFunction]='309419007' OR [performerFunction]='309418004' OR [performerFunction]='309417009' OR [performerFunction]='309416000' OR [performerFunction]='309415001' OR [performerFunction]='309414002' OR [performerFunction]='309413008' OR [performerFunction]='309412003' OR [performerFunction]='309411005' OR [performerFunction]='309410006' OR [performerFunction]='309409001' OR [performerFunction]='309404006' OR [performerFunction]='309403000' OR [performerFunction]='309402005' OR [performerFunction]='309401003' OR [performerFunction]='309400002' OR [performerFunction]='309399009' OR [performerFunction]='309398001' OR [performerFunction]='309397006' OR [performerFunction]='309396002' OR [performerFunction]='309395003' OR [performerFunction]='309394004' OR [performerFunction]='309393005' OR [performerFunction]='309392000' OR [performerFunction]='309391007' OR [performerFunction]='309390008' OR [performerFunction]='309389004' OR [performerFunction]='309388007' OR [performerFunction]='309386006' OR [performerFunction]='309385005' OR [performerFunction]='309384009' OR [performerFunction]='309383003' OR [performerFunction]='309382008' OR [performerFunction]='309381001' OR [performerFunction]='309380000' OR [performerFunction]='309379003' OR [performerFunction]='309378006' OR [performerFunction]='309377001' OR [performerFunction]='309376005' OR [performerFunction]='309375009' OR [performerFunction]='309374008' OR [performerFunction]='309373002' OR [performerFunction]='309372007' OR [performerFunction]='309371000' OR [performerFunction]='309369000' OR [performerFunction]='309368008' OR [performerFunction]='309367003' OR [performerFunction]='309366007' OR [performerFunction]='309365006' OR [performerFunction]='309364005' OR [performerFunction]='309363004' OR [performerFunction]='309362009' OR [performerFunction]='309361002' OR [performerFunction]='309360001' OR [performerFunction]='309359006' OR [performerFunction]='309358003' OR [performerFunction]='309357008' OR [performerFunction]='309356004' OR [performerFunction]='309355000' OR [performerFunction]='309354001' OR [performerFunction]='309353007' OR [performerFunction]='309352002' OR [performerFunction]='309351009' OR [performerFunction]='309350005' OR [performerFunction]='309349005' OR [performerFunction]='309348002' OR [performerFunction]='309347007' OR [performerFunction]='309346003' OR [performerFunction]='309345004' OR [performerFunction]='309343006' OR [performerFunction]='309342001' OR [performerFunction]='309341008' OR [performerFunction]='309340009' OR [performerFunction]='309339007' OR [performerFunction]='309338004' OR [performerFunction]='309337009' OR [performerFunction]='309336000' OR [performerFunction]='309335001' OR [performerFunction]='309334002' OR [performerFunction]='309333008' OR [performerFunction]='309332003' OR [performerFunction]='309331005' OR [performerFunction]='309330006' OR [performerFunction]='309329001' OR [performerFunction]='309328009' OR [performerFunction]='309327004' OR [performerFunction]='309326008' OR [performerFunction]='309324006' OR [performerFunction]='309323000' OR [performerFunction]='309322005' OR [performerFunction]='309296004' OR [performerFunction]='309295000' OR [performerFunction]='309294001' OR [performerFunction]='308002005' OR [performerFunction]='307988006' OR [performerFunction]='304292004' OR [performerFunction]='304291006' OR [performerFunction]='303134001' OR [performerFunction]='303133007' OR [performerFunction]='303129000' OR [performerFunction]='303124005' OR [performerFunction]='302211009' OR [performerFunction]='283875005' OR [performerFunction]='265939002' OR [performerFunction]='265937000' OR [performerFunction]='225727002' OR [performerFunction]='225726006' OR [performerFunction]='224936003' OR [performerFunction]='224626008' OR [performerFunction]='224625007' OR [performerFunction]='224624006' OR [performerFunction]='224623000' OR [performerFunction]='224622005' OR [performerFunction]='224621003' OR [performerFunction]='224620002' OR [performerFunction]='224615002' OR [performerFunction]='224614003' OR [performerFunction]='224610007' OR [performerFunction]='224609002' OR [performerFunction]='224608005' OR [performerFunction]='224607000' OR [performerFunction]='224606009' OR [performerFunction]='224605008' OR [performerFunction]='224604007' OR [performerFunction]='224603001' OR [performerFunction]='224602006' OR [performerFunction]='224601004' OR [performerFunction]='224600003' OR [performerFunction]='224599001' OR [performerFunction]='224598009' OR [performerFunction]='224597004' OR [performerFunction]='224596008' OR [performerFunction]='224595007' OR [performerFunction]='224594006' OR [performerFunction]='224593000' OR [performerFunction]='224592005' OR [performerFunction]='224591003' OR [performerFunction]='224590002' OR [performerFunction]='224589006' OR [performerFunction]='224588003' OR [performerFunction]='224587008' OR [performerFunction]='224586004' OR [performerFunction]='224585000' OR [performerFunction]='224584001' OR [performerFunction]='224583007' OR [performerFunction]='224581009' OR [performerFunction]='224580005' OR [performerFunction]='224579007' OR [performerFunction]='224578004' OR [performerFunction]='224577009' OR [performerFunction]='224576000' OR [performerFunction]='224575001' OR [performerFunction]='224574002' OR [performerFunction]='224573008' OR [performerFunction]='224572003' OR [performerFunction]='224571005' OR [performerFunction]='224570006' OR [performerFunction]='224569005' OR [performerFunction]='224567007' OR [performerFunction]='224566003' OR [performerFunction]='224565004' OR [performerFunction]='224564000' OR [performerFunction]='224563006' OR [performerFunction]='224562001' OR [performerFunction]='224561008' OR [performerFunction]='224560009' OR [performerFunction]='224559004' OR [performerFunction]='224558007' OR [performerFunction]='224557002' OR [performerFunction]='224556006' OR [performerFunction]='224555005' OR [performerFunction]='224554009' OR [performerFunction]='224553003' OR [performerFunction]='224552008' OR [performerFunction]='224551001' OR [performerFunction]='224550000' OR [performerFunction]='224549000' OR [performerFunction]='224548008' OR [performerFunction]='224547003' OR [performerFunction]='224546007' OR [performerFunction]='224545006' OR [performerFunction]='224544005' OR [performerFunction]='224543004' OR [performerFunction]='224542009' OR [performerFunction]='224541002' OR [performerFunction]='224540001' OR [performerFunction]='224538006' OR [performerFunction]='224537001' OR [performerFunction]='224536005' OR [performerFunction]='224535009' OR [performerFunction]='224534008' OR [performerFunction]='224533002' OR [performerFunction]='224532007' OR [performerFunction]='224531000' OR [performerFunction]='224530004' OR [performerFunction]='224529009' OR [performerFunction]='160008000' OR [performerFunction]='159972006' OR [performerFunction]='159141008' OR [performerFunction]='159041005' OR [performerFunction]='159040006' OR [performerFunction]='159039009' OR [performerFunction]='159038001' OR [performerFunction]='159037006' OR [performerFunction]='159036002' OR [performerFunction]='159035003' OR [performerFunction]='159034004' OR [performerFunction]='159033005' OR [performerFunction]='159028006' OR [performerFunction]='159027001' OR [performerFunction]='159026005' OR [performerFunction]='159025009' OR [performerFunction]='159022007' OR [performerFunction]='159021000' OR [performerFunction]='159019005' OR [performerFunction]='159018002' OR [performerFunction]='159017007' OR [performerFunction]='159016003' OR [performerFunction]='159014000' OR [performerFunction]='159013006' OR [performerFunction]='159012001' OR [performerFunction]='159011008' OR [performerFunction]='159010009' OR [performerFunction]='159007002' OR [performerFunction]='159006006' OR [performerFunction]='159005005' OR [performerFunction]='159004009' OR [performerFunction]='159003003' OR [performerFunction]='159002008' OR [performerFunction]='159001001' OR [performerFunction]='158999002' OR [performerFunction]='158998005' OR [performerFunction]='158997000' OR [performerFunction]='158996009' OR [performerFunction]='158995008' OR [performerFunction]='158994007' OR [performerFunction]='158993001' OR [performerFunction]='158992006' OR [performerFunction]='158990003' OR [performerFunction]='158989007' OR [performerFunction]='158988004' OR [performerFunction]='158987009' OR [performerFunction]='158986000' OR [performerFunction]='158985001' OR [performerFunction]='158984002' OR [performerFunction]='158983008' OR [performerFunction]='158980006' OR [performerFunction]='158979008' OR [performerFunction]='158978000' OR [performerFunction]='158977005' OR [performerFunction]='158975002' OR [performerFunction]='158974003' OR [performerFunction]='158973009' OR [performerFunction]='158972004' OR [performerFunction]='158971006' OR [performerFunction]='158970007' OR [performerFunction]='158969006' OR [performerFunction]='158968003' OR [performerFunction]='158967008' OR [performerFunction]='158966004' OR [performerFunction]='158965000' OR [performerFunction]='112247003' OR [performerFunction]='106330007' OR [performerFunction]='106296000' OR [performerFunction]='106294002' OR [performerFunction]='106293008' OR [performerFunction]='106292003' OR [performerFunction]='106291005' OR [performerFunction]='106289002' OR [performerFunction]='90655003' OR [performerFunction]='90201008' OR [performerFunction]='88475002' OR [performerFunction]='88189002' OR [performerFunction]='85733003' OR [performerFunction]='83685006' OR [performerFunction]='83273008' OR [performerFunction]='83189004' OR [performerFunction]='82296001' OR [performerFunction]='81464008' OR [performerFunction]='80933006' OR [performerFunction]='80584001' OR [performerFunction]='80546007' OR [performerFunction]='80409005' OR [performerFunction]='79898004' OR [performerFunction]='78729002' OR [performerFunction]='78703002' OR [performerFunction]='76899008' OR [performerFunction]='76231001' OR [performerFunction]='76166008' OR [performerFunction]='75271001' OR [performerFunction]='73265009' OR [performerFunction]='71838004' OR [performerFunction]='69280009' OR [performerFunction]='68950000' OR [performerFunction]='68867008' OR [performerFunction]='66862007' OR [performerFunction]='66476003' OR [performerFunction]='63098009' OR [performerFunction]='62247001' OR [performerFunction]='61894003' OR [performerFunction]='61345009' OR [performerFunction]='61246008' OR [performerFunction]='61207006' OR [performerFunction]='60008001' OR [performerFunction]='59944000' OR [performerFunction]='59169001' OR [performerFunction]='59058001' OR [performerFunction]='57654006' OR [performerFunction]='56545009' OR [performerFunction]='56542007' OR [performerFunction]='56466003' OR [performerFunction]='56397003' OR [performerFunction]='54503009' OR [performerFunction]='50149000' OR [performerFunction]='49993003' OR [performerFunction]='49203003' OR [performerFunction]='48740002' OR [performerFunction]='46255001' OR [performerFunction]='45956004' OR [performerFunction]='45544007' OR [performerFunction]='45440000' OR [performerFunction]='45419001' OR [performerFunction]='44652006' OR [performerFunction]='43702002' OR [performerFunction]='41904004' OR [performerFunction]='41672002' OR [performerFunction]='40570005' OR [performerFunction]='40204001' OR [performerFunction]='40127002' OR [performerFunction]='39677007' OR [performerFunction]='37504001' OR [performerFunction]='37154003' OR [performerFunction]='36682004' OR [performerFunction]='28544002' OR [performerFunction]='28411006' OR [performerFunction]='28229004' OR [performerFunction]='26369006' OR [performerFunction]='26042002' OR [performerFunction]='25961008' OR [performerFunction]='24590004' OR [performerFunction]='24430003' OR [performerFunction]='23278007' OR [performerFunction]='22983004' OR [performerFunction]='22731001' OR [performerFunction]='22515006' OR [performerFunction]='21450003' OR [performerFunction]='21365001' OR [performerFunction]='20145008' OR [performerFunction]='19244007' OR [performerFunction]='18850004' OR [performerFunction]='18803008' OR [performerFunction]='17561000' OR [performerFunction]='14698002' OR [performerFunction]='13580004' OR [performerFunction]='11935004' OR [performerFunction]='11911009' OR [performerFunction]='11661002' OR [performerFunction]='8724009' OR [performerFunction]='6868009' OR [performerFunction]='6816002' OR [performerFunction]='5275007' OR [performerFunction]='4162009' OR [performerFunction]='3842006' OR [performerFunction]='3430008' OR [performerFunction]='1421009'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ProcedureResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ProcedureResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[status] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[statusReason] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[category] [varchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[performedDateTime] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[outcome] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([category]='410606002' OR [category]='46947000' OR [category]='103693007' OR [category]='387713003' OR [category]='409073007' OR [category]='409063005' OR [category]='24642003')),
	CHECK (([outcome]='385670004' OR [outcome]='385671000' OR [outcome]='385669000')),
	CHECK (([status]='unknown' OR [status]='entered-in-error' OR [status]='completed' OR [status]='stopped' OR [status]='on-hold' OR [status]='not-done' OR [status]='in-progress' OR [status]='preparation')),
	CHECK (([statusReason]='708000007' OR [statusReason]='700110004' OR [statusReason]='698459008' OR [statusReason]='414120003' OR [statusReason]='397023003' OR [statusReason]='391021006' OR [statusReason]='288120003' OR [statusReason]='268521004' OR [statusReason]='180863000' OR [statusReason]='170929008' OR [statusReason]='170912005' OR [statusReason]='170904002' OR [statusReason]='170894006' OR [statusReason]='170882002' OR [statusReason]='170872003' OR [statusReason]='170863006' OR [statusReason]='170854009' OR [statusReason]='170843004' OR [statusReason]='170834008' OR [statusReason]='170826002' OR [statusReason]='170816009' OR [statusReason]='170800007' OR [statusReason]='170725006' OR [statusReason]='170712003' OR [statusReason]='170700002' OR [statusReason]='170687005' OR [statusReason]='170675003' OR [statusReason]='170621009' OR [statusReason]='170620005' OR [statusReason]='170588009' OR [statusReason]='170585007' OR [statusReason]='168533005' OR [statusReason]='9.14933391000087E+17' OR [statusReason]='3.14553311000087E+17' OR [statusReason]='116101000119100' OR [statusReason]='921000119109' OR [statusReason]='591000119102' OR [statusReason]='716048005' OR [statusReason]='715508000' OR [statusReason]='714747005' OR [statusReason]='713615000' OR [statusReason]='713068007' OR [statusReason]='708129006' OR [statusReason]='707746003' OR [statusReason]='707745004' OR [statusReason]='706890009' OR [statusReason]='705140004' OR [statusReason]='704097008' OR [statusReason]='704051006' OR [statusReason]='704049007' OR [statusReason]='704047009' OR [statusReason]='704046000' OR [statusReason]='703992006' OR [statusReason]='703991004' OR [statusReason]='703989007' OR [statusReason]='703427001' OR [statusReason]='700411009' OR [statusReason]='700359005' OR [statusReason]='699137009' OR [statusReason]='699128009' OR [statusReason]='699054003' OR [statusReason]='699053009' OR [statusReason]='699042003' OR [statusReason]='699034004' OR [statusReason]='698950001' OR [statusReason]='698758004' OR [statusReason]='698490005' OR [statusReason]='698484006' OR [statusReason]='698483000' OR [statusReason]='698473004' OR [statusReason]='698460003' OR [statusReason]='698451006' OR [statusReason]='698357006' OR [statusReason]='473149004' OR [statusReason]='444020006' OR [statusReason]='442444001' OR [statusReason]='442392002' OR [statusReason]='442324008' OR [statusReason]='440621003' OR [statusReason]='439495000' OR [statusReason]='438765003' OR [statusReason]='438370008' OR [statusReason]='429739001' OR [statusReason]='429726000' OR [statusReason]='429688007' OR [statusReason]='429284000' OR [statusReason]='428841003' OR [statusReason]='428650003' OR [statusReason]='428299008' OR [statusReason]='428073005' OR [statusReason]='428042006' OR [statusReason]='426544006' OR [statusReason]='417512003' OR [statusReason]='417114007' OR [statusReason]='417045009' OR [statusReason]='416888009' OR [statusReason]='416522000' OR [statusReason]='416126007' OR [statusReason]='415572005' OR [statusReason]='413756001' OR [statusReason]='413559006' OR [statusReason]='413312003' OR [statusReason]='413311005' OR [statusReason]='413310006' OR [statusReason]='413123006' OR [statusReason]='413122001' OR [statusReason]='412752009' OR [statusReason]='412725004' OR [statusReason]='412718006' OR [statusReason]='412713002' OR [statusReason]='408795007' OR [statusReason]='408791003' OR [statusReason]='408778004' OR [statusReason]='408572000' OR [statusReason]='408569007' OR [statusReason]='408567009' OR [statusReason]='408566000' OR [statusReason]='408559001' OR [statusReason]='408558009' OR [statusReason]='408551003' OR [statusReason]='408549002' OR [statusReason]='408548005' OR [statusReason]='407583007' OR [statusReason]='406149000' OR [statusReason]='401086001' OR [statusReason]='401084003' OR [statusReason]='401047000' OR [statusReason]='395703005' OR [statusReason]='395176007' OR [statusReason]='391015007' OR [statusReason]='390914001' OR [statusReason]='371138003' OR [statusReason]='315640000' OR [statusReason]='315023008' OR [statusReason]='315022003' OR [statusReason]='315021005' OR [statusReason]='315020006' OR [statusReason]='275936005' OR [statusReason]='185754009' OR [statusReason]='183962007' OR [statusReason]='183961000' OR [statusReason]='183960004' OR [statusReason]='183959009' OR [statusReason]='183958001' OR [statusReason]='183957006' OR [statusReason]='183956002' OR [statusReason]='183949008' OR [statusReason]='183948000' OR [statusReason]='183947005' OR [statusReason]='183946001' OR [statusReason]='183945002' OR [statusReason]='182903008' OR [statusReason]='182902003' OR [statusReason]='182901005' OR [statusReason]='182900006' OR [statusReason]='182899001' OR [statusReason]='182898009' OR [statusReason]='182897004' OR [statusReason]='182896008' OR [statusReason]='182895007' OR [statusReason]='168499009' OR [statusReason]='165376007' OR [statusReason]='165342003' OR [statusReason]='135826008' OR [statusReason]='135825007' OR [statusReason]='135814003' OR [statusReason]='135812004' OR [statusReason]='134398004' OR [statusReason]='134397009' OR [statusReason]='134396000' OR [statusReason]='134386009' OR [statusReason]='134385008' OR [statusReason]='105480006' OR [statusReason]='408505004' OR [statusReason]='184163005' OR [statusReason]='171152003' OR [statusReason]='171103002' OR [statusReason]='171034000' OR [statusReason]='170302007' OR [statusReason]='170292003' OR [statusReason]='170283001' OR [statusReason]='170274006' OR [statusReason]='170265009' OR [statusReason]='170256002' OR [statusReason]='170179005' OR [statusReason]='170170009' OR [statusReason]='170161006' OR [statusReason]='170152006' OR [statusReason]='170143002' OR [statusReason]='170134006' OR [statusReason]='170125001' OR [statusReason]='170116007' OR [statusReason]='169796005' OR [statusReason]='169795009' OR [statusReason]='169693009' OR [statusReason]='169687001' OR [statusReason]='169660000' OR [statusReason]='169649009' OR [statusReason]='169635000' OR [statusReason]='169609001' OR [statusReason]='712996005' OR [statusReason]='712872001' OR [statusReason]='712870009' OR [statusReason]='712869008' OR [statusReason]='712854007' OR [statusReason]='712852006' OR [statusReason]='712851004' OR [statusReason]='712812009' OR [statusReason]='712803007' OR [statusReason]='712790005' OR [statusReason]='444062004' OR [statusReason]='408506003' OR [statusReason]='170301000' OR [statusReason]='170291005' OR [statusReason]='170282006' OR [statusReason]='170273000' OR [statusReason]='170264008' OR [statusReason]='170255003' OR [statusReason]='170178002' OR [statusReason]='170169008' OR [statusReason]='170160007' OR [statusReason]='170151004' OR [statusReason]='170142007' OR [statusReason]='170133000' OR [statusReason]='170124002' OR [statusReason]='170115006' OR [statusReason]='169608009' OR [statusReason]='148477008' OR [statusReason]='148324002' OR [statusReason]='147022006' OR [statusReason]='146922001' OR [statusReason]='712740006' OR [statusReason]='709198003' OR [statusReason]='707853004' OR [statusReason]='707287001' OR [statusReason]='704096004' OR [statusReason]='704052004' OR [statusReason]='704033005' OR [statusReason]='704000000' OR [statusReason]='703996009' OR [statusReason]='703971006' OR [statusReason]='700384008' OR [statusReason]='699048004' OR [statusReason]='417434004' OR [statusReason]='417218000' OR [statusReason]='417013004' OR [statusReason]='416741000' OR [statusReason]='416678006' OR [statusReason]='416670004' OR [statusReason]='416664005' OR [statusReason]='415667005' OR [statusReason]='415570002' OR [statusReason]='415119001' OR [statusReason]='413812009' OR [statusReason]='413560001' OR [statusReason]='413167008' OR [statusReason]='408398007' OR [statusReason]='408397002' OR [statusReason]='408396006' OR [statusReason]='408339001' OR [statusReason]='407573008' OR [statusReason]='407572003' OR [statusReason]='407571005' OR [statusReason]='315214003' OR [statusReason]='183966005' OR [statusReason]='183965009' OR [statusReason]='183964008' OR [statusReason]='135808005' OR [statusReason]='135807000' OR [statusReason]='135806009' OR [statusReason]='135805008' OR [statusReason]='134394002' OR [statusReason]='134392003' OR [statusReason]='134391005' OR [statusReason]='134390006' OR [statusReason]='6051000175105' OR [statusReason]='6041000175108' OR [statusReason]='6031000175102' OR [statusReason]='6021000175100' OR [statusReason]='5991000175105' OR [statusReason]='4591000175100' OR [statusReason]='4551000175107' OR [statusReason]='4541000175105' OR [statusReason]='4501000175108' OR [statusReason]='4471000175100' OR [statusReason]='4461000175108' OR [statusReason]='4451000175106' OR [statusReason]='715622005' OR [statusReason]='715621003' OR [statusReason]='713207007' OR [statusReason]='712985002' OR [statusReason]='712751006' OR [statusReason]='703942005' OR [statusReason]='699231000' OR [statusReason]='698753008' OR [statusReason]='698569004' OR [statusReason]='443788002' OR [statusReason]='441989008' OR [statusReason]='439867009' OR [statusReason]='428348004' OR [statusReason]='418731009' OR [statusReason]='418014008' OR [statusReason]='416128008' OR [statusReason]='408837008' OR [statusReason]='408836004' OR [statusReason]='408504000' OR [statusReason]='401318002' OR [statusReason]='399538001' OR [statusReason]='397399004' OR [statusReason]='397004005' OR [statusReason]='396781004' OR [statusReason]='394965000' OR [statusReason]='391016008' OR [statusReason]='390848004' OR [statusReason]='373148008' OR [statusReason]='373147003' OR [statusReason]='371900001' OR [statusReason]='314374001' OR [statusReason]='310352003' OR [statusReason]='309846006' OR [statusReason]='266881002' OR [statusReason]='266756008' OR [statusReason]='183930009' OR [statusReason]='183929004' OR [statusReason]='183928007' OR [statusReason]='182849000' OR [statusReason]='170304008' OR [statusReason]='170293008' OR [statusReason]='170284007' OR [statusReason]='170275007' OR [statusReason]='170266005' OR [statusReason]='170257006' OR [statusReason]='170180008' OR [statusReason]='170171008' OR [statusReason]='170162004' OR [statusReason]='170153001' OR [statusReason]='170144008' OR [statusReason]='170135007' OR [statusReason]='170126000' OR [statusReason]='170117003' OR [statusReason]='170108003' OR [statusReason]='170100005' OR [statusReason]='169708002' OR [statusReason]='169704000' OR [statusReason]='169699008' OR [statusReason]='169611005' OR [statusReason]='169610006' OR [statusReason]='169607004' OR [statusReason]='168497006' OR [statusReason]='167728005' OR [statusReason]='167701000' OR [statusReason]='167594003' OR [statusReason]='167322008' OR [statusReason]='167317008' OR [statusReason]='167306007' OR [statusReason]='167296002' OR [statusReason]='167286006' OR [statusReason]='167272007' OR [statusReason]='167260001' OR [statusReason]='167219008' OR [statusReason]='165393007' OR [statusReason]='165377003' OR [statusReason]='165343008' OR [statusReason]='165139002' OR [statusReason]='165122004' OR [statusReason]='165104002' OR [statusReason]='165081006' OR [statusReason]='165074004' OR [statusReason]='165035006' OR [statusReason]='165026004' OR [statusReason]='165017002' OR [statusReason]='165008002' OR [statusReason]='164997006' OR [statusReason]='164985005' OR [statusReason]='164978006' OR [statusReason]='164964005' OR [statusReason]='164853006' OR [statusReason]='164831009' OR [statusReason]='164823004' OR [statusReason]='164808009' OR [statusReason]='164795007' OR [statusReason]='164786004' OR [statusReason]='164776000' OR [statusReason]='164766003' OR [statusReason]='164746007' OR [statusReason]='164725003' OR [statusReason]='164713001' OR [statusReason]='164503006' OR [statusReason]='164445005' OR [statusReason]='164321005' OR [statusReason]='164286000' OR [statusReason]='164176006' OR [statusReason]='163900009' OR [statusReason]='163628001' OR [statusReason]='163582008' OR [statusReason]='163348001' OR [statusReason]='163128002' OR [statusReason]='162980001' OR [statusReason]='162882008' OR [statusReason]='162675007' OR [statusReason]='162650008' OR [statusReason]='713248005' OR [statusReason]='713247000' OR [statusReason]='713246009' OR [statusReason]='710765004' OR [statusReason]='439516000' OR [statusReason]='438604008' OR [statusReason]='430279008' OR [statusReason]='427569000' OR [statusReason]='426999008' OR [statusReason]='426970003' OR [statusReason]='425921008' OR [statusReason]='425519007' OR [statusReason]='412782003' OR [statusReason]='395009001' OR [statusReason]='395008009' OR [statusReason]='395007004' OR [statusReason]='395006008' OR [statusReason]='394909009' OR [statusReason]='309841001' OR [statusReason]='274512008' OR [statusReason]='182846007' OR [statusReason]='182845006' OR [statusReason]='182844005' OR [statusReason]='182843004' OR [statusReason]='182842009' OR [statusReason]='182841002' OR [statusReason]='182840001' OR [statusReason]='170958006' OR [statusReason]='170919001' OR [statusReason]='170689008' OR [statusReason]='170688000' OR [statusReason]='170624001' OR [statusReason]='715166006' OR [statusReason]='715163003' OR [statusReason]='707298000' OR [statusReason]='703999002' OR [statusReason]='703997000' OR [statusReason]='699037006' OR [statusReason]='698521002' OR [statusReason]='698468005' OR [statusReason]='438833006' OR [statusReason]='438767006' OR [statusReason]='417128001' OR [statusReason]='417101006' OR [statusReason]='416996000' OR [statusReason]='416759002' OR [statusReason]='416704001' OR [statusReason]='416475003' OR [statusReason]='416091008' OR [statusReason]='415666001' OR [statusReason]='415571003' OR [statusReason]='414677003' OR [statusReason]='414159007' OR [statusReason]='414055003' OR [statusReason]='413558003' OR [statusReason]='407582002' OR [statusReason]='395675007' OR [statusReason]='395175006' OR [statusReason]='395174005' OR [statusReason]='394987009' OR [statusReason]='390910005' OR [statusReason]='390796006' OR [statusReason]='390795005' OR [statusReason]='315591006' OR [statusReason]='315364008' OR [statusReason]='315363002' OR [statusReason]='315062004' OR [statusReason]='315061006' OR [statusReason]='312451002' OR [statusReason]='275974002' OR [statusReason]='275935009' OR [statusReason]='268560002' OR [statusReason]='266758009' OR [statusReason]='266757004' OR [statusReason]='183936003' OR [statusReason]='183934000' OR [statusReason]='171284002' OR [statusReason]='171277005' OR [statusReason]='170954008' OR [statusReason]='169551000' OR [statusReason]='135823000' OR [statusReason]='135822005' OR [statusReason]='135811006' OR [statusReason]='135809002'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ProvenanceAgent' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ProvenanceAgent] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[code] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[who] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[OnBehalfOf] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([code]='transmitter' OR [code]='composer' OR [code]='assembler' OR [code]='custodian' OR [code]='informant' OR [code]='attester' OR [code]='legal' OR [code]='verifier' OR [code]='author' OR [code]='performer' OR [code]='enterer'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ProvenanceResource' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ProvenanceResource] AS TABLE(
	[resourceID] [uniqueidentifier] NULL,
	[provResourceId] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[div] [varchar](max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[target] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[occurred] [datetimeoffset](7) NULL,
	[recorded] [datetimeoffset](7) NULL,
	[location] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ProviderRole' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ProviderRole] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[value] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[modifier] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([value]='RT' OR [value]='CP' OR [value]='PP' OR [value]='RP'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_ReferenceList' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_ReferenceList] AS TABLE(
	[correlatedID] [uniqueidentifier] NULL,
	[resourceType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[resourceID] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[resourceName] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([resourceType]='VisionPrescription' OR [resourceType]='VerificationResult' OR [resourceType]='ValueSet' OR [resourceType]='TestScript' OR [resourceType]='TestReport' OR [resourceType]='TerminologyCapabilities' OR [resourceType]='Task' OR [resourceType]='SupplyRequest' OR [resourceType]='SupplyDelivery' OR [resourceType]='SubstanceSpecification' OR [resourceType]='SubstanceSourceMaterial' OR [resourceType]='SubstanceReferenceInformation' OR [resourceType]='SubstanceProtein' OR [resourceType]='SubstancePolymer' OR [resourceType]='SubstanceNucleicAcid' OR [resourceType]='Substance' OR [resourceType]='Subscription' OR [resourceType]='StructureMap' OR [resourceType]='StructureDefinition' OR [resourceType]='SpecimenDefinition' OR [resourceType]='Specimen' OR [resourceType]='Slot' OR [resourceType]='ServiceRequest' OR [resourceType]='SearchParameter' OR [resourceType]='Schedule' OR [resourceType]='RiskEvidenceSynthesis' OR [resourceType]='RiskAssessment' OR [resourceType]='Resource' OR [resourceType]='ResearchSubject' OR [resourceType]='ResearchStudy' OR [resourceType]='ResearchElementDefinition' OR [resourceType]='ResearchDefinition' OR [resourceType]='RequestGroup' OR [resourceType]='RelatedPerson' OR [resourceType]='QuestionnaireResponse' OR [resourceType]='Questionnaire' OR [resourceType]='Provenance' OR [resourceType]='Procedure' OR [resourceType]='PractitionerRole' OR [resourceType]='Practitioner' OR [resourceType]='PlanDefinition' OR [resourceType]='Person' OR [resourceType]='PaymentReconciliation' OR [resourceType]='PaymentNotice' OR [resourceType]='Patient' OR [resourceType]='Parameters' OR [resourceType]='OrganizationAffiliation' OR [resourceType]='Organization' OR [resourceType]='OperationOutcome' OR [resourceType]='OperationDefinition' OR [resourceType]='ObservationDefinition' OR [resourceType]='Observation' OR [resourceType]='NutritionOrder' OR [resourceType]='NamingSystem' OR [resourceType]='MolecularSequence' OR [resourceType]='MessageHeader' OR [resourceType]='MessageDefinition' OR [resourceType]='MedicinalProductUndesirableEffect' OR [resourceType]='MedicinalProductPharmaceutical' OR [resourceType]='MedicinalProductPackaged' OR [resourceType]='MedicinalProductManufactured' OR [resourceType]='MedicinalProductInteraction' OR [resourceType]='MedicinalProductIngredient' OR [resourceType]='MedicinalProductIndication' OR [resourceType]='MedicinalProductContraindication' OR [resourceType]='MedicinalProductAuthorization' OR [resourceType]='MedicinalProduct' OR [resourceType]='MedicationStatement' OR [resourceType]='MedicationRequest' OR [resourceType]='MedicationKnowledge' OR [resourceType]='MedicationDispense' OR [resourceType]='MedicationAdministration' OR [resourceType]='Medication' OR [resourceType]='Media' OR [resourceType]='MeasureReport' OR [resourceType]='Measure' OR [resourceType]='Location' OR [resourceType]='List' OR [resourceType]='Linkage' OR [resourceType]='Library' OR [resourceType]='Invoice' OR [resourceType]='InsurancePlan' OR [resourceType]='ImplementationGuide' OR [resourceType]='ImmunizationRecommendation' OR [resourceType]='ImmunizationEvaluation' OR [resourceType]='Immunization' OR [resourceType]='ImagingStudy' OR [resourceType]='HealthcareService' OR [resourceType]='GuidanceResponse' OR [resourceType]='Group' OR [resourceType]='GraphDefinition' OR [resourceType]='Goal' OR [resourceType]='Flag' OR [resourceType]='FamilyMemberHistory' OR [resourceType]='ExplanationOfBenefit' OR [resourceType]='ExampleScenario' OR [resourceType]='EvidenceVariable' OR [resourceType]='Evidence' OR [resourceType]='EventDefinition' OR [resourceType]='EpisodeOfCare' OR [resourceType]='EnrollmentResponse' OR [resourceType]='EnrollmentRequest' OR [resourceType]='Endpoint' OR [resourceType]='Encounter' OR [resourceType]='EffectEvidenceSynthesis' OR [resourceType]='DomainResource' OR [resourceType]='DocumentReference' OR [resourceType]='DocumentManifest' OR [resourceType]='DiagnosticReport' OR [resourceType]='DeviceUseStatement' OR [resourceType]='DeviceRequest' OR [resourceType]='DeviceMetric' OR [resourceType]='DeviceDefinition' OR [resourceType]='Device' OR [resourceType]='DetectedIssue' OR [resourceType]='CoverageEligibilityResponse' OR [resourceType]='CoverageEligibilityRequest' OR [resourceType]='Coverage' OR [resourceType]='Contract' OR [resourceType]='Consent' OR [resourceType]='Condition' OR [resourceType]='ConceptMap' OR [resourceType]='Composition' OR [resourceType]='CompartmentDefinition' OR [resourceType]='CommunicationRequest' OR [resourceType]='Communication' OR [resourceType]='CodeSystem' OR [resourceType]='ClinicalImpression' OR [resourceType]='ClaimResponse' OR [resourceType]='Claim' OR [resourceType]='ChargeItemDefinition' OR [resourceType]='ChargeItem' OR [resourceType]='CatalogEntry' OR [resourceType]='CareTeam' OR [resourceType]='CarePlan' OR [resourceType]='CapabilityStatement' OR [resourceType]='Bundle' OR [resourceType]='BodyStructure' OR [resourceType]='BiologicallyDerivedProduct' OR [resourceType]='Binary' OR [resourceType]='Basic' OR [resourceType]='AuditEvent' OR [resourceType]='AppointmentResponse' OR [resourceType]='Appointment' OR [resourceType]='AllergyIntolerance' OR [resourceType]='AdverseEvent' OR [resourceType]='ActivityDefinition' OR [resourceType]='Account'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Status' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Status] AS TABLE(
	[PersonID] [uniqueidentifier] NULL,
	[value] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	CHECK (([value]='entered-in-error' OR [value]='inactive' OR [value]='suspended' OR [value]='active' OR [value]='proposed'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_Telecom' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_Telecom] AS TABLE(
	[CorrelatedID] [uniqueidentifier] NULL,
	[system] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[type] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[value] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	CHECK (([system]='other' OR [system]='sms' OR [system]='url' OR [system]='pager' OR [system]='email' OR [system]='fax' OR [system]='phone'))
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'FHIR_UidList' AND ss.name = N'dbo')
CREATE TYPE [dbo].[FHIR_UidList] AS TABLE(
	[Uid] [uniqueidentifier] NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'MU_InterfaceDataMapping' AND ss.name = N'dbo')
CREATE TYPE [dbo].[MU_InterfaceDataMapping] AS TABLE(
	[PRMCode] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[PRMCodeBigInt] [bigint] NULL,
	[DataElementName] [varchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[TopicIndicator] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[QRDASection] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Rootid] [varchar](40) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
)
GO
IF NOT EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UidList' AND ss.name = N'dbo')
CREATE TYPE [dbo].[UidList] AS TABLE(
	[Uid] [uniqueidentifier] NULL
)
GO

