-- #84206 _VisitAddendumMigration.sql
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF EXISTS (select * from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'cus_VisitAddendum')
BEGIN
	insert into VisitAddendum
	select * from cus_VisitAddendum
END
GO

-- #90261   90261_ListFilter_V6_RxChange_Message.sql
IF NOT EXISTS(SELECT * FROM ListProductParameter WHERE ParameterName = 'eRx.MigratedMessageFilter')
BEGIN
   INSERT ListProductParameter(ProductParameterUid, ParameterName, BoolValue) VALUES('C67101E7-3498-4DD8-815F-45B2D04DFA58', 'eRx.MigratedMessageFilter', 1)
   
   -- Add V6 RxChange Message to any message filter that has RxRefill message
   UPDATE fil
   SET Criteria = aft.txt
   FROM ListFilter fil
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, 1, CHARINDEX('<Control Name="_findTextMessageType"', fil.Criteria) - 1)) pre
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + 1, CHARINDEX('/>', SUBSTRING(fil.Criteria, LEN(pre.txt), LEN(fil.Criteria))))) fmt
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + LEN(fmt.txt) + 1, LEN(fil.Criteria))) pst
   CROSS APPLY (SELECT elm = CONVERT(XML, fmt.txt)) elm
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + '"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + '"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + '"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + '"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') != ''
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + '"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) bef
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + ';2c259b74-444f-4f29-9634-5768dda9e572"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + ';Electronic Rx Change Request"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + ';"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + ';0"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') != ''
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + ';"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) aft
   WHERE Type = 'ControlMessageCenterFilter'
     AND fil.Criteria LIKE '%<Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="%eb31df6b-3685-4639-81f6-026f6278e1dc%" Value="%" Tag="%" ForeignKeyIndex="%" FindTableUid="0fb434e9-fc6c-418c-aa08-501f44d311db" ExternalId="%" Label="Message Type" />%'
     AND fil.Criteria NOT LIKE '%2c259b74-444f-4f29-9634-5768dda9e572%'
     AND fil.Criteria = bef.txt

   -- Add V6 Prior Authorization Message to any message filter that has RxRefill message
   UPDATE fil
   SET Criteria = aft.txt
   FROM ListFilter fil
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, 1, CHARINDEX('<Control Name="_findTextMessageType"', fil.Criteria) - 1)) pre
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + 1, CHARINDEX('/>', SUBSTRING(fil.Criteria, LEN(pre.txt), LEN(fil.Criteria))))) fmt
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + LEN(fmt.txt) + 1, LEN(fil.Criteria))) pst
   CROSS APPLY (SELECT elm = CONVERT(XML, fmt.txt)) elm
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + '"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + '"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + '"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + '"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') != ''
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + '"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) bef
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + ';61a96124-6977-491e-9390-ef506dbbc05f"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + ';Electronic Prior Authorization Info Request"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + ';"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + ';0"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') != ''
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + ';"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) aft
   WHERE Type = 'ControlMessageCenterFilter'
     AND fil.Criteria LIKE '%<Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="%eb31df6b-3685-4639-81f6-026f6278e1dc%" Value="%" Tag="%" ForeignKeyIndex="%" FindTableUid="0fb434e9-fc6c-418c-aa08-501f44d311db" ExternalId="%" Label="Message Type" />%'
     AND fil.Criteria NOT LIKE '%61a96124-6977-491e-9390-ef506dbbc05f%'
     AND fil.Criteria = bef.txt

   -- Complete RxChange Messages older than 7 days
   DECLARE @RxChangeMessages TABLE(MessageUid UNIQUEIDENTIFIER NOT NULL PRIMARY KEY, CompletedByUid UNIQUEIDENTIFIER NULL)

   -- Get Uids of messages to complete
   INSERT INTO @RxChangeMessages(MessageUid, CompletedByUid)
   SELECT msg.MessageUid, itm.ProviderUid
   FROM Message msg
   CROSS APPLY (SELECT ProviderUid = msg.MessageDataXML.value('(/ChangeRx/ChangeRxItems/ChangeRxItem/ProviderUid)[1]', 'UNIQUEIDENTIFIER')) itm
   WHERE msg.DateCompleted IS NULL
     AND msg.CompletedByUid IS NULL
     AND msg.LastReadByUid IS NULL
     AND msg.CreatedDateTime < DATEADD(DD, -7, GETUTCDATE())
     AND msg.MessageTypeUid IN('2c259b74-444f-4f29-9634-5768dda9e572', '61a96124-6977-491e-9390-ef506dbbc05f')

   -- If provider not found, then use assigned to user
   UPDATE tab
   SET CompletedByUid = mus.UserUid
   FROM @RxChangeMessages tab
   CROSS APPLY (
      SELECT TOP 1 mus.*
      FROM MessageUser mus
      INNER JOIN Person p ON p.PersonUid = mus.UserUid
      WHERE mus.MessageUid = tab.MessageUid
        AND mus.UserUid IS NOT NULL
      ORDER BY mus.MessageUserUid) mus
   WHERE tab.CompletedByUid IS NULL

   -- if no user, then don't complete it
   DELETE @RxChangeMessages WHERE CompletedByUid IS NULL

   IF EXISTS(SELECT * FROM @RxChangeMessages)
   BEGIN
      -- Complete the message
      UPDATE msg
      SET CompletedByUid   = tab.CompletedByUid,
          DateCompleted    = GETUTCDATE(),
          LastModifiedDate = GETUTCDATE()
      FROM @RxChangeMessages tab
      INNER JOIN Message msg ON msg.MessageUid = tab.MessageUid

      -- add an explanatory note
      INSERT INTO MessageNote(MessageUid, Note, CreatedByUid, CreatedDateTime, LastModifiedDate, LastModifiedByUid)
      SELECT
         MessageUid        = tab.MessageUid,
         Note              = 'Automated clean up of eRX messages older than 7 days.',
         CreatedByUid      = tab.CompletedByUid, 
         CreatedDateTime   = GETUTCDATE(),
         LastModifiedDate  = GETUTCDATE(),
         LastModifiedByUid = tab.CompletedByUid
      FROM @RxChangeMessages tab
   END
END
GO
-- #90261 end

-- #90261   90261_ListFilter_V6_RxChange_Message.sql
IF NOT EXISTS(SELECT * FROM ListProductParameter WHERE ParameterName = 'eRx.MigratedMessageFilter')
BEGIN
   INSERT ListProductParameter(ProductParameterUid, ParameterName, BoolValue) VALUES('C67101E7-3498-4DD8-815F-45B2D04DFA58', 'eRx.MigratedMessageFilter', 1)
   
   -- Add V6 RxChange Message to any message filter that has RxRefill message
   UPDATE fil
   SET Criteria = aft.txt
   FROM ListFilter fil
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, 1, CHARINDEX('<Control Name="_findTextMessageType"', fil.Criteria) - 1)) pre
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + 1, CHARINDEX('/>', SUBSTRING(fil.Criteria, LEN(pre.txt), LEN(fil.Criteria))))) fmt
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + LEN(fmt.txt) + 1, LEN(fil.Criteria))) pst
   CROSS APPLY (SELECT elm = CONVERT(XML, fmt.txt)) elm
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + '"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + '"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + '"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + '"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') IS NOT NULL
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + '"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) bef
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + ';2c259b74-444f-4f29-9634-5768dda9e572"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + ';Electronic Rx Change Request"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + ';"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + ';0"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') IS NOT NULL
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + ';"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) aft
   WHERE Type = 'ControlMessageCenterFilter'
     AND fil.Criteria LIKE '%<Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="%eb31df6b-3685-4639-81f6-026f6278e1dc%" Value="%" Tag="%" ForeignKeyIndex="%" FindTableUid="0fb434e9-fc6c-418c-aa08-501f44d311db" ExternalId="%" Label="Message Type" />%'
     AND fil.Criteria NOT LIKE '%2c259b74-444f-4f29-9634-5768dda9e572%'
     AND fil.Criteria = bef.txt

   -- Add V6 Prior Authorization Message to any message filter that has RxRefill message
   UPDATE fil
   SET Criteria = aft.txt
   FROM ListFilter fil
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, 1, CHARINDEX('<Control Name="_findTextMessageType"', fil.Criteria) - 1)) pre
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + 1, CHARINDEX('/>', SUBSTRING(fil.Criteria, LEN(pre.txt), LEN(fil.Criteria))))) fmt
   CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + LEN(fmt.txt) + 1, LEN(fil.Criteria))) pst
   CROSS APPLY (SELECT elm = CONVERT(XML, fmt.txt)) elm
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + '"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + '"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + '"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + '"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') IS NOT NULL
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + '"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) bef
   CROSS APPLY (
      SELECT txt = pre.txt
                 + '<Control'
                 + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
                 + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
                 + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + ';61a96124-6977-491e-9390-ef506dbbc05f"'
                 + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + ';Electronic Prior Authorization Info Request"'
                 + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + ';"'
                 + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + ';0"'
                 + CASE WHEN elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') IS NOT NULL
                        THEN ' ForeignKeyUid="'   + elm.value('(/Control/@ForeignKeyUid  )[1]', 'nvarchar(max)') + ';"'
                        ELSE ''
                   END
                 + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
                 + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
                 + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
                 + ' />'
                 + pst.txt) aft
   WHERE Type = 'ControlMessageCenterFilter'
     AND fil.Criteria LIKE '%<Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="%eb31df6b-3685-4639-81f6-026f6278e1dc%" Value="%" Tag="%" ForeignKeyIndex="%" FindTableUid="0fb434e9-fc6c-418c-aa08-501f44d311db" ExternalId="%" Label="Message Type" />%'
     AND fil.Criteria NOT LIKE '%61a96124-6977-491e-9390-ef506dbbc05f%'
     AND fil.Criteria = bef.txt

   -- Complete RxChange Messages older than 7 days
   DECLARE @RxChangeMessages TABLE(MessageUid UNIQUEIDENTIFIER NOT NULL PRIMARY KEY, CompletedByUid UNIQUEIDENTIFIER NULL)

   -- Get Uids of messages to complete
   INSERT INTO @RxChangeMessages(MessageUid, CompletedByUid)
   SELECT msg.MessageUid, itm.ProviderUid
   FROM Message msg
   CROSS APPLY (SELECT ProviderUid = msg.MessageDataXML.value('(/ChangeRx/ChangeRxItems/ChangeRxItem/ProviderUid)[1]', 'UNIQUEIDENTIFIER')) itm
   WHERE msg.DateCompleted IS NULL
     AND msg.CompletedByUid IS NULL
     AND msg.LastReadByUid IS NULL
     AND msg.CreatedDateTime < DATEADD(DD, -7, GETUTCDATE())
     AND msg.MessageTypeUid IN('2c259b74-444f-4f29-9634-5768dda9e572', '61a96124-6977-491e-9390-ef506dbbc05f')

   -- If provider not found, then use assigned to user
   UPDATE tab
   SET CompletedByUid = mus.UserUid
   FROM @RxChangeMessages tab
   CROSS APPLY (
      SELECT TOP 1 mus.*
      FROM MessageUser mus
      INNER JOIN Person p ON p.PersonUid = mus.UserUid
      WHERE mus.MessageUid = tab.MessageUid
        AND mus.UserUid IS NOT NULL
      ORDER BY mus.MessageUserUid) mus
   WHERE tab.CompletedByUid IS NULL

   -- if no user, then don't complete it
   DELETE @RxChangeMessages WHERE CompletedByUid IS NULL

   IF EXISTS(SELECT * FROM @RxChangeMessages)
   BEGIN
      -- Complete the message
      UPDATE msg
      SET CompletedByUid   = tab.CompletedByUid,
          DateCompleted    = GETUTCDATE(),
          LastModifiedDate = GETUTCDATE()
      FROM @RxChangeMessages tab
      INNER JOIN Message msg ON msg.MessageUid = tab.MessageUid

      -- add an explanatory note
      INSERT INTO MessageNote(MessageUid, Note, CreatedByUid, CreatedDateTime, LastModifiedDate, LastModifiedByUid)
      SELECT
         MessageUid        = tab.MessageUid,
         Note              = 'Automated clean up of eRX messages older than 7 days.',
         CreatedByUid      = tab.CompletedByUid, 
         CreatedDateTime   = GETUTCDATE(),
         LastModifiedDate  = GETUTCDATE(),
         LastModifiedByUid = tab.CompletedByUid
      FROM @RxChangeMessages tab
   END
END
GO
-- #90261 end

--#92127 POST SCRIPT FOR PRMHEAD
-- 78504_CDC_Vaccine_Code_Set_Aug_26_2021_PRMHead_PostScript.sql 
--Retire 4 seasonal influenza NDCs
Update VaccineUnitUse Set UseUnitEndDate = '20210701', Inactive=1 WHERE NDC11 IN 
('33332-0320-02','33332-0420-11','33332-0220-21','70461-0020-04') 

--Inactivate Novavax as of 08-01-2021
Update VaccineUnitUse Set UseUnitEndDate = '20210801', Inactive=1 WHERE VaccineUnitUseUid = '44D4B5B9-81F5-4D96-8BEA-E93C1BA5396F'
GO

-- #57481
-- =========================================================================
-- Post migration for table "ListMisc" 
-- created 05/25/2022
-- fix for bug #57481
-- =========================================================================
update ListFindTable set ShowInListEditor = 0, Inactive = 1 where FindTableUid = '70E75BB5-CD0D-42E9-AD77-A0292E6B30EA'
go
update ListMisc set ListType = 'Vitals BP Method', Inactive = 1 where MiscUid = '00000000-0000-0000-7777-000000000091'
go

if exists(select * from ListFindTable where FindTableUid = 'A3C284E3-1320-45DD-AF88-ED14C31CD81B')
begin
	update ListFindTable set ShowInListEditor = 1, Inactive = 0,
	Columns = '<FindColumn name="MiscUid" index="guid" visible="false" />
<FindColumn name="ExternalID" caption="ID" index="externalid" visible="true" width="50" />
<FindColumn name="Name" caption="Name" index="name" visible="true" width="120" />
<FindColumn name="Inactive" visible="false" index="inactive" />
<FindColumn name="Notes" caption="Notes" visible="true" width="250" />
<FindColumn name="UserDefined" index="userdefined" visible="false" />'
	where FindTableUid = 'A3C284E3-1320-45DD-AF88-ED14C31CD81B'
end
else begin
	INSERT INTO ListFindTable (FindTableUid, [Name], SecurityGroupUid,  [ID], 
		ShowInListEditor, LoadPriority, Prepopulate, HasSecurity, AllowMaintenance, AllowNew, 
		AllowDelete, AllowImport, AllowExport, AllowHide,
		LimitMaintenanceOnNonUserDefined, ExternalIdWildcard, BeginningWildcard, 
		SizableFindDialog, BusinessObjectRequired, LoadStoredProcedure, CustomDBAccessClassName,
		FindControlClass,
		EditFormType,
		BusinessObject, 
		EditBusinessObject, 
		AuditTableName,
		SaveAsBusinessObject,
		MaxRows,
		[Columns],
		Notes, Inactive, UserDefined, LastModifiedDate
	)
	VALUES ('A3C284E3-1320-45DD-AF88-ED14C31CD81B', 'Blood Pressure Methods', '48A699EF-CAD2-46D5-87E2-825EAD91058D', 'ListMiscBPMethods',
		0, 10, 1, 1, 1, 1,
		2, 1, 1, 0,
		1, 1, 0,
		0, 1, NULL, NULL,
		'iMedica.Prm.Client.UI.PrmGeneralControls.Find.Clinical.ControlFindBloodPressureMethods',
		'iMedica.Prm.Client.UI.PrmGeneralControls.Edit.Clinical.ControlEditBloodPressureMethods',
		'ListMisc',
		'ListMisc',
		'ListMisc',
		'ListMisc',
		100,
		'<FindColumn name="MiscUid" index="guid" visible="false" />
<FindColumn name="ExternalID" caption="ID" index="externalid" visible="true" width="50" />
<FindColumn name="Name" caption="Name" index="name" visible="true" width="120" />
<FindColumn name="Inactive" visible="false" index="inactive" />
<FindColumn name="Notes" caption="Notes" visible="true" width="250" />
<FindColumn name="UserDefined" index="userdefined" visible="false" />',
		NULL, 0, 0, '05/26/2022'
	)
end
go

-- add SecurityUserGroup for find control
if not exists(select * from SecurityUserGroup where SecurityUserGroupUid = '6B84BF20-D277-4BD0-BB97-667F331F9962')
begin
	INSERT INTO SecurityUserGroup
		([SecurityUserGroupUid], [SecurityUid], [ParentObjectUid], [ObjectName], 
					[ObjectUid], [UserPRMUid], [UserGroupUid], 
					[Permission], [UserDefined], [LastModifiedByUid], [LastModifiedDate]) 
		VALUES ('6B84BF20-D277-4BD0-BB97-667F331F9962','10101010-0000-0000-0000-000000000022', NULL, 'listeditorobjects', 
					'A3C284E3-1320-45DD-AF88-ED14C31CD81B', NULL, '00000101-0000-0000-0000-000000000001', 
					14, 0, NULL, '05/26/2022')
end
GO
-- #57481 end

-- #111349
UPDATE Person
	SET BirthGenderUid = GenderUid;
GO