-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- disable these triggers before updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] DISABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] DISABLE TRIGGER [BlockReportUpdates]
GO
-- #60294 Keep this at the top

-- #79741
--Migration script
--20210921 kculberth 79741 Reports: Deposit Analysis should correct display Payer Credit Distributions when split between different Providers/Financial Centers/Service Sites
--Deposit Analysis
--Delete ListUserDefinedControlGroup/ListUserDefinedControl entries
--ListUserDefinedControlGroup
UPDATE ListUserDefinedControlGroup 
SET [Name] = 'Deposit Analysis'
	,[Immunization] = 0
	,[Inactive] = 0
	,[UserDefined] = 0
	,[RDLDesigner] = 0
	,[LastModifiedDate] = '9/22/2021 00:00:00 AM'
WHERE [UserDefinedControlGroupUid] = '4df4253f-7ff6-46bd-9bcb-2bafd38edf17'

--ListUserDefinedControl
DELETE FROM ListUserDefinedControl WHERE  [UserDefinedControlGroupUid] = '4df4253f-7ff6-46bd-9bcb-2bafd38edf17'

--SortOrder = 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'54f8a84b-89db-482f-b6b5-d17053141352'
	,'Date'
	,0
	,'Dates'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>DepositByProvider</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,0
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'07d36587-bf0e-4fc5-b4e1-e6391aec495f'
	,'DateOption'
	,0
	,'Date Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Deposit Date</ButtonLabel><ButtonValue>Deposit</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,1
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'31150a2b-eee8-4820-b58c-90d8baab1954'
	,'ProviderUid'
	,0
	,'Providers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,2
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'7f7ff2e5-0e1b-47bd-8be2-018e51d3c249'
	,'ProviderOption'
	,0
	,'Provider Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Providers</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Providers</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,3
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'0a50742f-fcc5-458b-8b38-efd8f8eb8eff'
	,'FinancialCenterUid'
	,0
	,'Financial Centers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,4
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'd5acad02-cb77-4630-8d69-fc661eedf69d'
	,'ServiceSiteUid'
	,0
	,'Service Sites'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,5
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'8a239418-df85-45fa-b3fe-100d08f131ed'
	,'OwnerUid'
	,0
	,'Batch Owners'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>OwnerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>User</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindUser</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,6
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 7
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'852106a8-10df-4fce-8037-981a08ab870d'
	,'FinancialBatchUid'
	,0
	,'Batches'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialBatchUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Batch</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewARBatch</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,7
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 8
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'7329e5f6-f562-4e08-be36-00d30a71ffa7'
	,'GroupByUid'
	,0
	,'Group By'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>GroupBy</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Account Type Procedure</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>Account_Type_Procedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4df4253f-7ff6-46bd-9bcb-2bafd38edf17'
	,8
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--ListReport
UPDATE ListReport
SET NAME = 'Deposit Analysis'
WHERE ReportUid = 'b6275e6a-6da9-43cb-ae08-454b4dc614be'
GO

--ListReportRdl
UPDATE ListReportRdl
SET NAME = 'Deposit Analysis'
WHERE ReportUid = 'b6275e6a-6da9-43cb-ae08-454b4dc614be'
GO
-- #79741 end

-- #78742
--Migration Script
--20210921 kculberth 78742 Reports: Daily Transaction Summary should include all deposits for the timespan regardless of Provider/Financial Center/Service Site filters
--Daily Transaction Detail
UPDATE ListUserDefinedControlGroup 
SET [Name] = 'Daily Transaction Detail'
	,[Immunization] = 0
	,[Inactive] = 0
	,[UserDefined] = 0
	,[RDLDesigner] = 0
	,[LastModifiedDate] = '9/22/2021 00:00:00 AM'
WHERE [UserDefinedControlGroupUid] = '328da800-bdbb-4d86-b878-4dc85ff4d8a4'

--ListUserDefinedControl
DELETE FROM ListUserDefinedControl WHERE  [UserDefinedControlGroupUid] = '328da800-bdbb-4d86-b878-4dc85ff4d8a4'

--ListUserDefinedControl
--SortOrder = 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'458412c6-efdc-4e1c-bf30-d3c35a8ed565'
	,'Date'
	,0
	,'Dates'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Date</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>FALSE</Required></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,0
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'82f0df17-4cae-4871-bde0-30fd2e847035'
	,'DateOption'
	,0
	,'Date Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Deposit Dates</ButtonLabel><ButtonValue>Deposit</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Dates</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,1
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'e4b5f6b8-3d3f-4079-9d45-522199e7aecb'
	,'Provider'
	,0
	,'Providers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>Provider</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,2
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'd283a9ba-4207-4f7a-a253-54cfeaeb66f4'
	,'ProviderOption'
	,0
	,'Provider Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,3
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'538a950b-cb49-482c-a780-84583face189'
	,'FinancialCenterUid'
	,0
	,'Financial Centers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,4
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'c943f60e-81d8-40de-95f7-31fa4965a6bd'
	,'ServiceSiteUid'
	,0
	,'Service Sites'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,5
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'ff1cae1a-2758-4c99-981b-8aa939e8a71e'
	,'FinancialBatchUid'
	,0
	,'Batches'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialBatchUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Batch</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewARBatch</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,6
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 7
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'0fb0b198-9df7-4f5c-8b3b-e94058eb54b1'
	,'OwnerUid'
	,0
	,'Batch Owners'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>OwnerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>User</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindUser</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,7
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 8
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'60171db5-0ff6-43a0-ac06-1f89a4e8a1eb'
	,'IsIncomplete'
	,0
	,'Show Only Unallocated Deposits'
	,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IsIncomplete</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	,'328da800-bdbb-4d86-b878-4dc85ff4d8a4'
	,8
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--ListReport
UPDATE ListReport
SET NAME = 'Daily Transaction Detail'
WHERE ReportUid = 'a1eb2c50-66eb-4e28-8a22-073e000a9fa7'
GO

--ListReportRdl
UPDATE ListReportRdl
SET NAME = 'Daily Transaction Detail'
WHERE ReportUid = 'a1eb2c50-66eb-4e28-8a22-073e000a9fa7'
GO
-- #78742 end

-- #78741
--Migration script
--20210921 kculberth 78741 Reports: Monthly Transaction Summary report totals must match Daily Transaction Detail report totals
--Monthly Transaction Summary
UPDATE ListUserDefinedControlGroup 
SET [Name] = 'Monthly Transaction Summary'
	,[Immunization] = 0
	,[Inactive] = 0
	,[UserDefined] = 0
	,[RDLDesigner] = 0
	,[LastModifiedDate] = '9/22/2021 00:00:00 AM'
WHERE [UserDefinedControlGroupUid] = 'DB0BA0B8-6632-4725-860F-4198FD63D5CF'

--ListUserDefinedControl
DELETE FROM ListUserDefinedControl WHERE  [UserDefinedControlGroupUid] = 'DB0BA0B8-6632-4725-860F-4198FD63D5CF'

--ListUserDefinedControl
--SortOrder = 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'9a0aacc6-f142-466e-9560-c22e0d7b278a'
	,'Date'
	,0
	,'Dates'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>MDS</Name><Uid>3863338d-160f-45d8-81c7-62738f3114d0</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,0
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'15be1263-9618-46f1-a2aa-44eb77f586f5'
	,'DateOption'
	,0
	,'Date Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Deposit Date</ButtonLabel><ButtonValue>Deposit</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,1
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'fc67b515-324a-4ac2-b13c-cd0e9b4213d7'
	,'ProviderUid'
	,0
	,'Providers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,2
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'bf722f7c-830f-48b1-9ee3-e88bea8316fb'
	,'ProviderOption'
	,0
	,'Provider Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Providers</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Providers</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,3
	,0
	,0
	,'9/22/2021 11:35:29 AM'
	)

--SortOrder = 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'2f5207ae-f03f-43ba-8504-09b8567a9606'
	,'FinancialCenterUid'
	,0
	,'Financial Centers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FCUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,4
	,0
	,0
	,'9/22/2021 11:35:29 AM'
	)

--SortOrder = 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'7b4caa10-3325-428e-b373-747db8ee4fb7'
	,'ServiceSiteUid'
	,0
	,'Service Sites'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName></Control></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,5
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--SortOrder = 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'1b7c5e6e-f4fe-44e1-a7b5-ca959e1fedb2'
	,'OwnerUid'
	,0
	,'Batch Owners'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>OwnerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>User</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindUser</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'db0ba0b8-6632-4725-860f-4198fd63d5cf'
	,6
	,0
	,0
	,'9/22/2021 00:00:00 AM'
	)

--ListReport
UPDATE ListReport
SET NAME = 'Monthly Transaction Summary'
WHERE ReportUid = '27b461d3-a198-4dd2-a222-971d0128256a'
GO

--ListReportRdl
UPDATE ListReportRdl
SET NAME = 'Monthly Transaction Summary'
WHERE ReportUid = '27b461d3-a198-4dd2-a222-971d0128256a'
GO
-- #78741 end

-- #78331 Patient Aging ListUserDefinedControl Migration Script.sql
-- Migration Script for Patient Aging Detail/Summary
-- 20211012 kculberth 78331 Aging Reports Minimum and Maximum Balance Values   Patient Aging Reports
UPDATE ListUserDefinedControl 
SET Label = 'Patient Balance Min'
	,LastModifiedDate = '10/12/2021 00:00:00 AM'
WHERE UserDefinedControlUid = 'E2CA05B7-E9F4-434A-A567-CA70658D0375'

UPDATE ListUserDefinedControl 
SET Label = 'Patient Balance Max'
	,LastModifiedDate = '10/12/2021 00:00:00 AM'
WHERE UserDefinedControlUid = 'F2C5C12F-4164-4A7A-8F1D-48DBE0D70AE2'
GO

-- #78332 Responsible Party Aging ListUserDefinedControl Migration Script.sql
-- Migration Script for Responsible Party Aging Detail/Summary
-- 20211012 kculberth 78332 Aging Reports Minimum and Maximum Balance Values Responsible Party  Aging Reports
UPDATE ListUserDefinedControl 
SET Label = 'Responsible Party Balance Min'
	,LastModifiedDate = '10/12/2021 00:00:00 AM'
WHERE UserDefinedControlUid = 'DDBC4275-4D79-49C0-91F5-358726F8FE8F'

UPDATE ListUserDefinedControl 
SET Label = 'Responsible Party Balance Max'
	,LastModifiedDate = '10/12/2021 00:00:00 AM'
WHERE UserDefinedControlUid = '0ED1D475-F7D3-49F1-BC9B-8B558B6C20FB'
GO

-- #76439 Insurance Aging ListUserDefinedControl Migration Script.sql
-- Migration Script for Patient Aging Detail/Summary
-- 20211012 kculberth 76439 Aging Reports Minimum and Maximum Balance Values   Insurance Aging Reports
UPDATE ListUserDefinedControl 
SET Label = 'Superbill Balance Min'
	,LastModifiedDate = '10/12/2021 00:00:00 AM'
WHERE UserDefinedControlUid = 'EAED3D0F-0F01-4854-B9A1-1B6CFC7321D2'

UPDATE ListUserDefinedControl 
SET Label = 'Superbill Balance Max'
	,LastModifiedDate = '10/12/2021 00:00:00 AM'
WHERE UserDefinedControlUid = '94833070-E7DA-44FA-9206-5E8F3F00812F'
GO

-- #83798 Payment Reason Code MIGRATION script.sql
--Migration Script
-- 20211019 kculberth 83798 Rename Payment Reason Code Detail Excel to Payment Reason Code
IF EXISTS (SELECT ReportUid FROM ListReport WHERE ReportUid = '782368D2-675E-430D-86DF-EC59174B473E')
UPDATE listreport
SET UserDefined = 0
	,Name = 'Payment Reason Code'
	,Modifier = 5
WHERE ReportUid = '782368D2-675E-430D-86DF-EC59174B473E'

IF EXISTS (SELECT ReportRdlUid FROM ListReportRdl WHERE ReportRdlUid = 'B694962E-FCF8-4EEF-9923-A87547586452')
UPDATE listreportrdl
SET UserDefined = 0
	,Name = 'Payment Reason Code Excel'
	,ReportFormat = 'Excel'
	,ReportDefinition = 'MDOL_RPT2_PaymentReasonCode_Master'
WHERE ReportRdlUid = 'B694962E-FCF8-4EEF-9923-A87547586452'

-- #78276 Migration Script to Remove Checkbox.sql
DELETE ListUserDefinedControl where name = 'IncludeWithoutAppointment' and UserDefinedControlUid = '09EA9047-1EF5-4FAB-9703-8F00FA255283'
GO


-- #81101 
-- 11/1/2021 kculberth 81101 report cleanup -  Insurance productivity
DELETE FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = '3fa72192-5559-4848-8551-c81438549cbf'

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'7c051658-3b96-4d7a-815b-202bbcf0af65'
	,'InsuranceTimespan'
	,0
	,'Timespan'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>InsuranceTimespan</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,0
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'bc1e21be-0953-4901-b768-abfdd28e68c2'
	,'DateOption'
	,0
	,'Date Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>Service</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,1
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'2bdeedd2-bee1-4439-9d06-ab5343f7428f'
	,'InsurancePayerUID'
	,0
	,'Insurance Payers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>InsurancePayerUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Insurance Payer</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewInsuranceCarrier</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,2
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'64dd609f-0c5f-45d6-8e62-83da524db14e'
	,'CharacterFrom'
	,0
	,'First Char Payer Name'
	,'23d953d7-7438-48d0-9fd1-c950130cb558'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>CharacterFrom</Name><DefaultText></DefaultText><MaxLength></MaxLength><MultiLine>false</MultiLine><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,3
	,0
	,0
	,'10/29/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'06c72fcf-249a-4932-b1dd-483ea402e0e1'
	,'CharacterTo'
	,0
	,'Through'
	,'23d953d7-7438-48d0-9fd1-c950130cb558'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>CharacterTo</Name><DefaultText></DefaultText><MaxLength></MaxLength><MultiLine>false</MultiLine><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,4
	,0
	,0
	,'10/29/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'083523df-4963-406f-8fd3-5c9c9924f02c'
	,'AccountTypeUID'
	,0
	,'Plan Account Types'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AccountTypeUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Account Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAccountType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,5
	,0
	,0
	,'11/1/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'2a6a366e-0495-458a-9f21-10388e18795f'
	,'ProviderUID'
	,0
	,'Providers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,6
	,0
	,0
	,'11/1/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'0a49a281-0d5d-4373-ab8e-ce2d07a0bdf6'
	,'ProviderOption'
	,0
	,'Provider Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Provider</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,7
	,0
	,0
	,'11/1/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'e0a590ee-8e77-4088-9c3f-bbcc72bce08a'
	,'FinancialCenterUID'
	,0
	,'Financial Centers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,8
	,0
	,0
	,'11/1/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'3b6ed6f8-1887-4bdd-bb74-d25d1d4feba8'
	,'ServiceSiteUID'
	,0
	,'Service Sites'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,9
	,0
	,0
	,'11/1/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'4521886c-141c-4b71-897d-af5534ee4780'
	,'CodeUID'
	,0
	,'Codes'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CodeUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,10
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'a627d358-9977-47a5-b526-ec844db20e8f'
	,'GroupBy'
	,0
	,'Group By'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupBy</Name><ButtonLabel>Insurance Payer</ButtonLabel><ButtonValue>Insurance</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupBy</Name><ButtonLabel>Code</ButtonLabel><ButtonValue>Code</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,11
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'eeb686d3-03f1-4afd-8140-d3e025334832'
	,'ByProvider'
	,0
	,'Display by Provider'
	,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>ByProvider</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,12
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)
	
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'bbe50a18-4889-487d-9ea3-2a9579e9d6b8'
	,'IncludePatientAmount'
	,0
	,'Include Patient Responsibility'
	,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludePatientAmount</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,13
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'9e1e346b-a38d-4057-9dfd-b38caebdf9d9'
	,'SummaryOnly'
	,0
	,'Summary'
	,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>SummaryOnly</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	,'3fa72192-5559-4848-8551-c81438549cbf'
	,14
	,0
	,0
	,'10/27/2021 00:00:00 AM'
	)
GO
-- #81101 end

-- #86785 MigrationScript_CPCPlusRosterReportCHanges.sql
-- #104742 removed the previous script per this bug

-- #87219 Migration script 87219
--kculberth 20211104 New Report   Superbill Charge Analysis  Native Excel 
UPDATE ListReport
SET Modifier = 5
WHERE reportuid = '7D11242B-B892-43B9-9B6D-84078454BE3D'
GO

UPDATE ListReportRdl
SET name = 'Superbill Charge Analysis Report'
	,ReportFormat = 'Report'
WHERE reportrdluid = '50DAB463-4423-4D2D-BB6E-E2BE1D899C7B'
GO

-- #84425 20220202 kculberth 84425 ERA Reason Code Detail Excel and ERA Reason Code Summary Report to be removed from the database.   
--ERA Reason Code Detail Excel
if exists (select * from ListReport where reportuid = '5280762D-C46A-4B3A-A3E1-11E810337C78')
	delete from ListReport
	where reportuid = '5280762D-C46A-4B3A-A3E1-11E810337C78'

--ERA Reason Code Summary
if exists (select * from ListReport where reportuid = '15E0D665-4743-40AD-A4D4-58D6C903EEC7')
	delete from ListReport
	where reportuid = '15E0D665-4743-40AD-A4D4-58D6C903EEC7'
GO	

-- #89266 Delete Old Report_MIGRATION.sql
--Stored Procedure
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_PaymentsbyProcedureIncludingPatientLiability]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[MDOL_RPT2_PaymentsbyProcedureIncludingPatientLiability]
GO
--RDL
IF EXISTS (select * from ListReportrdl where ReportRdlUid = 'B4A62153-8EC5-4DF7-8E8B-6B9D8658688B')
BEGIN
DELETE from ListReportRdl where ReportRdlUid = 'B4A62153-8EC5-4DF7-8E8B-6B9D8658688B'
END
GO
--REPORT
IF EXISTS (select * from ListReport where ReportUid = '218C7F86-C9EB-4A76-9B59-56A728A35A18')
BEGIN
DELETE from ListReport where ReportUid = '218C7F86-C9EB-4A76-9B59-56A728A35A18'
END
GO
--UserDefinedControl
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = 'C3DF57FA-A2E6-4A18-92A0-735367257740')
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlGroupUid = 'C3DF57FA-A2E6-4A18-92A0-735367257740'
END
GO
--UserDefinedControlGroup
IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = 'C3DF57FA-A2E6-4A18-92A0-735367257740')
BEGIN
DELETE from ListUserDefinedControlGroup where UserDefinedControlGroupUid = 'C3DF57FA-A2E6-4A18-92A0-735367257740'
END
GO

-- #94426
-- kculberth 20220221 94426 Remove Case Authorization Tracking report
IF EXISTS (SELECT * FROM ListReport WHERE ReportUid = '76703917-1C83-47CC-80ED-71EF68D34E93')
DELETE FROM ListReport
WHERE ReportUid = '76703917-1C83-47CC-80ED-71EF68D34E93'

IF EXISTS (SELECT * FROM ListUserDefinedControlGroup WHERE UserDefinedControlGroupUid = 'E15D7A53-7B87-446B-80AB-3BAAE097C477')
DELETE
FROM listuserdefinedcontrol
WHERE userdefinedcontrolgroupuid = 'E15D7A53-7B87-446B-80AB-3BAAE097C477'
GO

-- #86118
--20220309 kculberth bug 86118 Error when running Payment Application report - out of memory error
IF EXISTS (
		SELECT *
		FROM ListUserDefinedControl
		WHERE UserDefinedControlUid = '88ed5a9a-5e2f-4c8a-b813-7246c124dfb2'
		)
	DELETE
	FROM ListUserDefinedControl
	WHERE UserDefinedControlUid = '88ed5a9a-5e2f-4c8a-b813-7246c124dfb2'

INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'88ed5a9a-5e2f-4c8a-b813-7246c124dfb2'
	,'GroupOption'
	,0
	,'Group By'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Financial Center</ButtonLabel><ButtonValue>Financial Center</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Service Site</ButtonLabel><ButtonValue>Service Site</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'c8d056af-342a-4c4d-9f81-12cc63aed5eb'
	,9
	,0
	,0
	,'3/9/2022 01:00:00 PM'
	)
GO

-- #86668 
-- 20220316 kculberth 86668 Responsible Party need to move report to Demographics report folder
IF EXISTS (SELECT ReportUid FROM ListReport WHERE NAME = 'Responsible Party' AND ReportUid = '4B0D5C21-17DB-4377-8B53-B195E9524984')
	UPDATE ListReport 
	SET ReportFolderUid = '0C392EF6-1BF6-49F0-B851-D3409E37DB67' --Demographics
	WHERE NAME = 'Responsible Party' AND ReportUid = '4B0D5C21-17DB-4377-8B53-B195E9524984'
GO	

-- #95115
-- 20220324 kculberth 95115 enhancements to Reimbursement analysis
-- Migration script
-- ListUserDefinedControlGroup
DELETE FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'ff99baab-16b3-4864-9d6a-49732bbac318'

-- ListUserDefinedControl
-- SortOrder 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'bcdc67f3-8ca9-4bfb-98fc-fea08a0ffeb7'
	,'Charge'
	,0
	,'Charge Dates'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Charge</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>FALSE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,0
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'96743618-9d9c-4dcf-9d21-a29b622c5b07'
	,'ChargeDateOption'
	,0
	,'Charge Date Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ChargeDateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ChargeDateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>Service</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,1
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'c54afc99-d974-4317-a71e-eaa6d37fe526'
	,'Transaction'
	,0
	,'Transaction Posting Dates'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Transaction</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,2
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'0d3c9640-7997-4c3b-8db6-3079e82045af'
	,'ProviderUid'
	,0
	,'Providers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,3
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'1d173ce6-b012-4fee-b3f6-d346428c5188'
	,'ProviderOption'
	,0
	,'Provider Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,4
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'bb7fb935-6d49-41a8-b865-15c6e9c88112'
	,'FinancialCenterUID'
	,0
	,'Financial Centers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,5
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'2bd1eb0a-7f40-410e-b8f6-d3ad6b3a5234'
	,'ServiceSiteUid'
	,0
	,'Service Sites'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,6
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 7
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'68231e5b-cbc2-405c-8f06-7564afef005a'
	,'InsurancePayerUID'
	,0
	,'Insurance Payers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>InsurancePayerUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Insurance Payer</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewInsuranceCarrier</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,7
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 8
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'2e8cdf05-be2a-435b-ad6c-0c4879b24601'
	,'ProcedureGroupUid'
	,0
	,'Procedure Groups'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureGroupUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedureGroup</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,8
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 9
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'bd062430-5395-401e-ad9d-eaac621daf31'
	,'GroupByUid'
	,0
	,'Group By'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>GroupByUid</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>ReImpAnalysisGroup</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ReImpAnalysisGroup</FindTableName></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,9
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 10
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'38cbe27a-c11b-492f-bdbb-158878c23745'
	,'IncludeZeroCharges'
	,0
	,'Include $0 Procedures'
	,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeZeroCharges</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>true</CheckedByDefault></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,10
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 11
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'82d5e70a-e89d-4d00-a6d0-703cadc51051'
	,'IncludeZeroPayments'
	,0
	,'Include Procedures with No Payments/Adjustments'
	,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeZeroPayments</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,11
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

-- SortOrder 12
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'f2aec726-70aa-4d4e-ad75-00875f434b78'
	,'ReportFormat'
	,0
	,'Report Format'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Excel</ButtonLabel><ButtonValue>Excel</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Detail</ButtonLabel><ButtonValue>Detail</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Summary</ButtonLabel><ButtonValue>Summary</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'ff99baab-16b3-4864-9d6a-49732bbac318'
	,12
	,0
	,0
	,'3/24/2022 00:00:00 AM'
	)

GO

UPDATE ListReportRdl 
SET Name = 'Reimbursement Analysis Detail'
	,ReportFormat = 'Detail'
	,LastModifiedByUid = NULL
	,LastModifiedDate = '3/24/2022 00:00:00 AM'
WHERE ReportRdlUid = '238cedce-f0ed-4ef4-a5b9-e3ebfd96ff0f'
GO
-- #95115 end

-- #98750 _paymentapplication_186ONLY.sql
IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = 'c8d056af-342a-4c4d-9f81-12cc63aed5eb')
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlGroupUid = 'c8d056af-342a-4c4d-9f81-12cc63aed5eb'
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '6de454f6-d8d2-4f98-bf7b-505992b4c62a') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('6de454f6-d8d2-4f98-bf7b-505992b4c62a','PostingDate',0,'Posting Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PostingDate</Name><Uid>b35a144b-b91e-4207-8e26-f7c9fcd06645</Uid><Required>TRUE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',0,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2e5ea18b-9510-4176-9ae2-07cc9184d5f8') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('2e5ea18b-9510-4176-9ae2-07cc9184d5f8','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',1,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'cb589b9c-7b30-4c95-9b61-bf3e23e6c476') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('cb589b9c-7b30-4c95-9b61-bf3e23e6c476','ProviderOption',0,'Type Of Providers','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing Provider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',2,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8cbdf5b7-d13c-4b5b-a55d-27d76e13d7b8') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('8cbdf5b7-d13c-4b5b-a55d-27d76e13d7b8','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',3,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b3bbb646-e159-480f-aca9-684bd87e334a') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b3bbb646-e159-480f-aca9-684bd87e334a','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',4,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'e2d088f6-b91e-4122-a2db-20573cc3d3f3') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e2d088f6-b91e-4122-a2db-20573cc3d3f3','BatchUid',0,'Batches','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>BatchUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Batch</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewARBatch</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',5,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '602f99a1-431e-48de-9633-1cc65d79dfba') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('602f99a1-431e-48de-9633-1cc65d79dfba','DepositUid',0,'Deposits','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>DepositUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Deposit</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewDeposit</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',6,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a979b5c3-0d3e-405b-b328-2e42f72a5c4d') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a979b5c3-0d3e-405b-b328-2e42f72a5c4d','PayerUid',0,'Payers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PayerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Person/Corporation</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewPersonCorporation</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',7,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3e922d67-2bf5-4327-81a0-28adb636d2c2') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('3e922d67-2bf5-4327-81a0-28adb636d2c2','ProcedureUid',0,'Procedures','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',8,0,0,'6/7/2021 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '88ed5a9a-5e2f-4c8a-b813-7246c124dfb2') -- 9
BEGIN
INSERT ListUserDefinedControl ([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
VALUES ('88ed5a9a-5e2f-4c8a-b813-7246c124dfb2','GroupOption',0,'Group By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Financial Center</ButtonLabel><ButtonValue>Financial Center</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Service Site</ButtonLabel><ButtonValue>Service Site</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',9,0,0,'3/9/2022 00:00:00 AM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'f7f3f570-4578-47a5-97e7-d6b048e66859') -- 10
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('f7f3f570-4578-47a5-97e7-d6b048e66859','ReportFormat',0,'Report Format','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Report</ButtonLabel><ButtonValue>Report</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Excel</ButtonLabel><ButtonValue>Excel</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',10,0,0,'6/7/2021 7:00:00 PM')
END
GO
-- #98750 end

-- #93030 
-- 20220411 kculberth 93030 Application error clicking hyperlinks in results for Superbill Status Review report
-- Migration script
UPDATE rdl
SET DefinitionSelected = 1
FROM ListReportRdl rdl 
WHERE ReportRdlUid in (SELECT rdl.ReportRdlUid
FROM ListReport r
INNER JOIN ListReportRdl rdl ON r.ReportUid = rdl.ReportUid
INNER JOIN ListReportFolder rf ON rf.ReportFolderUid = r.ReportFolderUid
WHERE DefinitionSelected = 0 AND r.name <> 'prescription' AND rdl.UserDefined = 0
)
GO

-- #99014 _PaymentApplication_MIGRATION.sql
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = 'c8d056af-342a-4c4d-9f81-12cc63aed5eb')
BEGIN
DELETE From ListUserDefinedControl where UserDefinedControlGroupUid = 'c8d056af-342a-4c4d-9f81-12cc63aed5eb'
END
GO
-----------------------------------------------------------------------
--ListUserDefinedControl

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '6de454f6-d8d2-4f98-bf7b-505992b4c62a') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('6de454f6-d8d2-4f98-bf7b-505992b4c62a','PostingDate',0,'Posting Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PostingDate</Name><Uid>b35a144b-b91e-4207-8e26-f7c9fcd06645</Uid><Required>TRUE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',0,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2e5ea18b-9510-4176-9ae2-07cc9184d5f8') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('2e5ea18b-9510-4176-9ae2-07cc9184d5f8','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',1,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'cb589b9c-7b30-4c95-9b61-bf3e23e6c476') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('cb589b9c-7b30-4c95-9b61-bf3e23e6c476','ProviderOption',0,'Type Of Providers','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing Provider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',2,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8cbdf5b7-d13c-4b5b-a55d-27d76e13d7b8') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('8cbdf5b7-d13c-4b5b-a55d-27d76e13d7b8','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',3,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b3bbb646-e159-480f-aca9-684bd87e334a') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b3bbb646-e159-480f-aca9-684bd87e334a','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',4,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'e2d088f6-b91e-4122-a2db-20573cc3d3f3') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e2d088f6-b91e-4122-a2db-20573cc3d3f3','BatchUid',0,'Batches','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>BatchUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Batch</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewARBatch</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',5,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '602f99a1-431e-48de-9633-1cc65d79dfba') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('602f99a1-431e-48de-9633-1cc65d79dfba','DepositUid',0,'Deposits','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>DepositUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Deposit</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewDeposit</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',6,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a979b5c3-0d3e-405b-b328-2e42f72a5c4d') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a979b5c3-0d3e-405b-b328-2e42f72a5c4d','PayerUid',0,'Payers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PayerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Person/Corporation</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewPersonCorporation</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',7,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3e922d67-2bf5-4327-81a0-28adb636d2c2') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('3e922d67-2bf5-4327-81a0-28adb636d2c2','ProcedureUid',0,'Procedures','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',8,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '1210560a-4b1a-4bbb-8d03-60fbeee513a7') -- 9
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('1210560a-4b1a-4bbb-8d03-60fbeee513a7','PaymentTypeUID',0,'Payment Types','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PaymentTypeUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Payment Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListPaymentType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',9,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '88ed5a9a-5e2f-4c8a-b813-7246c124dfb2') -- 10
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('88ed5a9a-5e2f-4c8a-b813-7246c124dfb2','GroupOption',0,'Group By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Financial Center</ButtonLabel><ButtonValue>Financial Center</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Service Site</ButtonLabel><ButtonValue>Service Site</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',10,0,0,'4/14/2022 7:00:00 PM')
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'f7f3f570-4578-47a5-97e7-d6b048e66859') -- 11
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('f7f3f570-4578-47a5-97e7-d6b048e66859','ReportFormat',0,'Report Format','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Report</ButtonLabel><ButtonValue>Report</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Excel</ButtonLabel><ButtonValue>Excel</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',11,0,0,'4/14/2022 7:00:00 PM')
END
GO
-- #99014 end

-- #99340 20220427 kculberth 99340 add report detail to Receipts Analysis
-- Receipts Analysis
-- ListReport
IF EXISTS (SELECT ReportUid FROM ListReport WHERE ReportUid = '07e9d808-cbfc-4e73-b721-1d265d81674d') 
UPDATE ListReport 
SET Modifier = 5
	,LastModifiedDate = '4/27/2022 00:00:00 AM'
WHERE ReportUid = '07e9d808-cbfc-4e73-b721-1d265d81674d'
GO

-- ListUserDefinedControl
IF NOT EXISTS (
		SELECT UserDefinedControlUid
		FROM ListUserDefinedControl
		WHERE UserDefinedControlUid = '170b57bc-4319-4900-85d4-4c2ef4edca93'
		)
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'170b57bc-4319-4900-85d4-4c2ef4edca93'
	,'ReportFormat'
	,0
	,'Report Format'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Summary</ButtonLabel><ButtonValue>Summary</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Detail</ButtonLabel><ButtonValue>Detail</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'417238df-d927-46b6-b689-d82a4b0c161a'
	,10
	,0
	,0
	,'4/27/2022 00:00:00 AM'
	)

-- Receipts Analysis Summary
IF EXISTS (SELECT ReportUid FROM ListReportRdl WHERE ReportRdlUid = 'C762DB1D-E16C-44EC-8F87-BB568A90330C') 
UPDATE ListReportRdl
SET Name = 'Receipts Analysis Summary'
	,ReportFormat = 'Summary'
	,LastModifiedDate = '4/27/2022 00:00:00 AM'
WHERE ReportRdlUid = 'C762DB1D-E16C-44EC-8F87-BB568A90330C'
GO
-- #99340 end	


-- #102767 _MIGRATION_Head ONLY.sql
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = '589fb238-4e1a-40ae-a48c-bc002cc8d565')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlGroupUid = '589fb238-4e1a-40ae-a48c-bc002cc8d565'
END
GO
----

--update report / rdl

UPDATE ListReport
Set ReportParameters='<ReportParameters />',
LastModifiedDate='2022-05-23 00:00:00.000',
LastModifiedByUid=null,
UserDefined=0,
Modifier=5
where reportuid='D12194D8-8EFB-443B-930E-3D4EB6B0DD21';

UPDATE ListReportRdl
Set LastModifiedDate='2022-05-23 00:00:00.000',
LastModifiedByUid=null,
UserDefined=0,
ReportFormat='REPORT'
where ReportRdlUid='90CE2279-1DF9-4589-A23A-80C7E4DC5566'; --REPORT

--ListUserDefinedControl

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'f3e26de7-18b4-4a70-933b-6f0584324af2') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('f3e26de7-18b4-4a70-933b-6f0584324af2','GLDate',0,'Date','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>GL</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',0,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'e5c4d451-3419-4423-b8c8-071dd7c065d6') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e5c4d451-3419-4423-b8c8-071dd7c065d6','DateOption',0,'Date Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>ServiceDate</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>PostingDate</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',1,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a94620e3-569e-42a6-bb4f-926af5121599') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a94620e3-569e-42a6-bb4f-926af5121599','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',2,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'bcbcab8d-4ea6-4b4e-b7ab-3336c4c5f245') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('bcbcab8d-4ea6-4b4e-b7ab-3336c4c5f245','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',3,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3dc42987-d780-4cf1-a8e8-d73b1ad058b3') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('3dc42987-d780-4cf1-a8e8-d73b1ad058b3','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',4,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'aff355a0-a122-47c4-8ee4-31834150fa23') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('aff355a0-a122-47c4-8ee4-31834150fa23','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',5,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '5509953f-7b93-478a-9052-4eec0a30a4a6') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('5509953f-7b93-478a-9052-4eec0a30a4a6','RVUScheduleUid',0,'RVU Schedule','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>RVUScheduleUid</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>RVU Schedule</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>RVUSchedule</FindTableName><Required>TRUE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',6,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '0e45e0c6-c4c3-4b6d-97b8-1e7f040d0acd') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('0e45e0c6-c4c3-4b6d-97b8-1e7f040d0acd','ProcedureGroupUid',0,'Procedure Groups','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureGroupUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedureGroup</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',7,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b51e3d12-035e-4ac5-b844-33d8f26acd3f') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b51e3d12-035e-4ac5-b844-33d8f26acd3f','ProcedureCodeUid',0,'Procedure Codes','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureCodeUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',8,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'f6c332f4-9062-4e72-9817-d0c779d18300') -- 9
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('f6c332f4-9062-4e72-9817-d0c779d18300','FirstLevelGroupBy',0,'First Level Group By','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FirstLevelGroupBy</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Work RVU Detail Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>Work_RVU_Detail_Group</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',9,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '5bb3812e-a64a-4c87-8800-a5806e9c11c0') -- 10
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('5bb3812e-a64a-4c87-8800-a5806e9c11c0','SecondLevelGroupBy',0,'Second Level Group By','8a957d7c-8b86-4a67-8336-b830c30fd123','<UserDefinedControls><Control><ControlType>FIND</ControlType><Name>SecondLevelGroupBy</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Work RVU Detail Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>Work_RVU_Detail_Group</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',10,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '0f4a1928-156d-4469-831b-285d7492f626') -- 11
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('0f4a1928-156d-4469-831b-285d7492f626','ThirdLevelGroupBy',0,'Third Level Group By','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ThirdLevelGroupBy</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Work RVU Detail Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>Work_RVU_Detail_Group</FindTableName></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',11,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '25072720-66dc-4bc1-bed5-42675c70a285') -- 12
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('25072720-66dc-4bc1-bed5-42675c70a285','Summary',0,'Summary Only','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>Summary</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',12,0,0,'5/22/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'e4a981b1-503c-40c4-92b0-0662f9eed920') -- 13
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e4a981b1-503c-40c4-92b0-0662f9eed920','ReportFormat',0,'Report Format','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Report</ButtonLabel><ButtonValue>REPORT</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Excel</ButtonLabel><ButtonValue>EXCEL</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','589fb238-4e1a-40ae-a48c-bc002cc8d565',13,0,0,'5/22/2022 7:00:00 PM')
END
GO
-- #102767 end

-- #103038 _DeleteRVU Report_MIGRATION.sql
--Stored Procedure
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_RVUReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[MDOL_RPT2_RVUReport]
GO

-------------------------------------------------------------------------
--ListReport

IF EXISTS (select * from ListReport where ReportUid = '98EBEC46-3AE6-46A7-B074-7AFD85507672')
BEGIN
DELETE from ListReport where ReportUid = '98EBEC46-3AE6-46A7-B074-7AFD85507672'
END
GO
-------------------------------------------------------------------------
--ListReportRDL

IF EXISTS (select * from ListReportRDL where ReportRDLUid = 'AB1AA1EE-D2B3-4062-86A4-02BDA23A7A54')
BEGIN
DELETE from ListReport where ReportUid = '98EBEC46-3AE6-46A7-B074-7AFD85507672'
END
GO
-------------------------------------------------------------------------
--ListuserDefinedControl

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = '35390AA3-8EA2-4E31-ADDB-DC1F71E11C32')
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlGroupUid = '35390AA3-8EA2-4E31-ADDB-DC1F71E11C32'
END
GO
-------------------------------------------------------------------------
--ListuserDefinedControlGroup

IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '35390AA3-8EA2-4E31-ADDB-DC1F71E11C32')
BEGIN
DELETE from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '35390AA3-8EA2-4E31-ADDB-DC1F71E11C32'
END
GO

-- #101662 _Migration.sql
update listreport
set modifier=5
where ReportUid='0BC422A7-25B7-4A5E-B842-C96E6761D092'
GO

-- #105835 _AppointmentReport_MIGRATION.sql
--DROP old user defined controls
delete from ListUserDefinedControl where  UserDefinedControlGroupUid = '5B8FD157-6C10-4922-8A2D-12FF2B96638A'
-----------------------------------------------------------------------
--ListUserDefinedControlGroup

IF  EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '5B8FD157-6C10-4922-8A2D-12FF2B96638A')
BEGIN

UPDATE ListUserDefinedControlGroup 
set UserDefined=0 
,LastModifiedByUid=null 
,LastModifiedDate='2022-08-09 00:00:00.000'
where UserDefinedControlGroupUid ='5B8FD157-6C10-4922-8A2D-12FF2B96638A';

END
GO

-------------------------------------------------------------------------
--ListUserDefinedControl

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '110fecff-68af-42e1-9150-b085be5b1f3d') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('110fecff-68af-42e1-9150-b085be5b1f3d','AppTimespan',0,'Appointment Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>AppTimespan</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',0,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '0bf0f032-c7cd-4546-aeeb-217f143d226d') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('0bf0f032-c7cd-4546-aeeb-217f143d226d','CalendarUID',0,'Calendars','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CalendarUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Calendar</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCalendar</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',1,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'c301d9df-a493-47b4-a424-46d1682e920f') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c301d9df-a493-47b4-a424-46d1682e920f','ProviderUID',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',2,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '05613b01-2a84-464f-8e1a-d24a10ef9d8f') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('05613b01-2a84-464f-8e1a-d24a10ef9d8f','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',3,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '82f734e9-a3f5-4a3d-ba22-41d2b272f1fa') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('82f734e9-a3f5-4a3d-ba22-41d2b272f1fa','FinancialCenterUID',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',4,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'e842ab9b-1b95-416f-800b-6fc453bf1775') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e842ab9b-1b95-416f-800b-6fc453bf1775','ServiceSiteUID',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',5,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '640c9a2f-f75e-44ee-bc81-fb9e50c8ef1d') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('640c9a2f-f75e-44ee-bc81-fb9e50c8ef1d','PatientUID',0,'Patients','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PatientUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindPatient</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',6,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9502fbe7-181c-467b-9741-389ef9229d61') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('9502fbe7-181c-467b-9741-389ef9229d61','AppointmentTypeUID',0,'Appointment Types','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AppointmentTypeUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Appointment Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAppointmentType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',7,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'c2bd8d62-e056-4d65-9dca-3e5f37cc7b92') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c2bd8d62-e056-4d65-9dca-3e5f37cc7b92','AppointmentStatusUID',0,'Appointment Statuses','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AppointmentStatusUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Appointment Status</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAppointmentStatus</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',8,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '952d4f94-956a-4141-b677-7647eea4de02') -- 9
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('952d4f94-956a-4141-b677-7647eea4de02','IncludeEvents',0,'Include Events','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeEvents</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',9,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '990f1c96-fcf9-40e9-8ecb-2136182307b3') -- 10
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('990f1c96-fcf9-40e9-8ecb-2136182307b3','IncludeAccountandPayerOption',0,'Include Account and Payer Information','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeAccountandPayerOption</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',10,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '7ad79d9a-bef4-412c-89f9-94568d2c2d7c') -- 11
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('7ad79d9a-bef4-412c-89f9-94568d2c2d7c','Sortby',0,'Sort by','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Patient</ButtonLabel><ButtonValue>Patient</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Calendar</ButtonLabel><ButtonValue>Calendar</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Date</ButtonLabel><ButtonValue>Date</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',11,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '706b7d99-ea56-4b1e-b6a6-c54c2f85eaee') -- 12
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('706b7d99-ea56-4b1e-b6a6-c54c2f85eaee','FromTime',0,'From Time','68cbe02c-d310-44ac-ae8d-faf93ce4d64b','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>FromTime</Name><MinValue>1</MinValue><MaxValue>12</MaxValue><DefaultValue>12</DefaultValue><DecimalPlaces>0</DecimalPlaces></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',12,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'cab13f88-78aa-449d-a1d2-b2e78ab41f3c') -- 13
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('cab13f88-78aa-449d-a1d2-b2e78ab41f3c','FromTimeOption',0,'From Time Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>FromTimeOption</Name><ButtonLabel>AM</ButtonLabel><ButtonValue>AM</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>FromTimeOption</Name><ButtonLabel>PM</ButtonLabel><ButtonValue>PM</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',13,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9d2817d3-7a6a-4293-9c32-fa7dc3391af1') -- 14
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('9d2817d3-7a6a-4293-9c32-fa7dc3391af1','ToTime',0,'To Time','68cbe02c-d310-44ac-ae8d-faf93ce4d64b','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>ToTime</Name><MinValue>1</MinValue><MaxValue>12</MaxValue><DefaultValue>12</DefaultValue><DecimalPlaces>0</DecimalPlaces></Control></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',14,0,0,'8/8/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ae8d9aef-bacf-4aa5-bda9-7b4be886dd3c') -- 15
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ae8d9aef-bacf-4aa5-bda9-7b4be886dd3c','ToTimeOption',0,'To Time Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ToTimeOption</Name><ButtonLabel>AM</ButtonLabel><ButtonValue>AM</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ToTimeOption</Name><ButtonLabel>PM</ButtonLabel><ButtonValue>PM</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','5b8fd157-6c10-4922-8a2d-12ff2b96638a',15,0,0,'8/8/2022 7:00:00 PM')
END
GO
-- #105835 end

-- #105836  _MDOL_RPT2_Appointment_EXCEL_MIGRATION.sql
--ListUserDefinedControlGroup
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = '190070D1-B8FD-4E4B-8C5D-B0E697988172')
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlGroupUid = '190070D1-B8FD-4E4B-8C5D-B0E697988172'
END
GO

-------------------------------------------------------------------------
--ListUserDefinedControl

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2bd93b70-c22e-4efb-b4ae-8add0ec593bd') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('2bd93b70-c22e-4efb-b4ae-8add0ec593bd','AppTimespan',0,'Appointment Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>AppTimespan</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',0,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '52531369-3351-43d8-a558-257c30249c54') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('52531369-3351-43d8-a558-257c30249c54','CalendarUID',0,'Calendars','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CalendarUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Calendar</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCalendar</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',1,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '7d34a2b4-09eb-4ce4-a3db-f23f12455d3b') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('7d34a2b4-09eb-4ce4-a3db-f23f12455d3b','ProviderUID',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',2,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ede1ac25-f99a-43d9-aa34-9b3bc0ef26ac') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ede1ac25-f99a-43d9-aa34-9b3bc0ef26ac','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',3,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8206d59f-d1be-401f-b5c9-65f2d069402b') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('8206d59f-d1be-401f-b5c9-65f2d069402b','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',4,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '6808f5f6-8791-49a0-b9f5-07d38e3c8463') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('6808f5f6-8791-49a0-b9f5-07d38e3c8463','ServiceSiteUID',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',5,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2b787864-d080-4372-83cb-87c2eebd05b3') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('2b787864-d080-4372-83cb-87c2eebd05b3','PatientUID',0,'Patients','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PatientUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindPatient</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',6,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '9b067b06-b7e8-4cf8-b5e6-2c5795e57d24') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('9b067b06-b7e8-4cf8-b5e6-2c5795e57d24','AppointmentTypeUID',0,'Appointment Types','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AppointmentTypeUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Appointment Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAppointmentType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',7,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '63fd06a0-746f-4950-9b2c-afe8276402b6') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('63fd06a0-746f-4950-9b2c-afe8276402b6','AppointmentStatusUID',0,'Appointment Statuses','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AppointmentStatusUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Appointment Status</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAppointmentStatus</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',8,0,0,'8/16/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '88aa4b02-df8f-479f-b1ac-57c842770746') -- 9
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('88aa4b02-df8f-479f-b1ac-57c842770746','IncludeEvents',0,'Include Events','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeEvents</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','190070d1-b8fd-4e4b-8c5d-b0e697988172',9,0,0,'8/16/2022 7:00:00 PM')
END
GO
-- #105836 end

-- #108346 _ServicesByProviderSummary_Migration.sql
--Drop Old Controls
IF EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = '1ACA2BE4-916A-46A2-8B2B-6B8E829E4765')
BEGIN
DELETE FROM ListUserDefinedControl where UserDefinedControlGroupUid = '1ACA2BE4-916A-46A2-8B2B-6B8E829E4765'
END
GO

-------------------------------------------------------------------------
--ListUserDefinedControl

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '5a4cedf7-d1ed-439c-88cd-85987ec0ac6e') -- 0
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('5a4cedf7-d1ed-439c-88cd-85987ec0ac6e','SBPS',0,'Timespan','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>SBPS</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid></Control></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',0,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '1a66df50-ba14-4152-95cc-e560f6aca1fc') -- 1
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('1a66df50-ba14-4152-95cc-e560f6aca1fc','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',1,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'd3f7134f-618a-41be-a326-540e25e6665d') -- 2
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('d3f7134f-618a-41be-a326-540e25e6665d','TypeofProviders',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>TypeofProviders</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing Providers</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>TypeofProviders</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering Providers</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',2,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'acbda7fd-3484-4ce4-917c-ba4356384a95') -- 3
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('acbda7fd-3484-4ce4-917c-ba4356384a95','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',3,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ca1705b6-e393-437a-94a8-f55bdbefa11b') -- 4
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ca1705b6-e393-437a-94a8-f55bdbefa11b','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>serviceSiteUIDs</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',4,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'ee13bc32-a67c-4998-855b-322cb9ce4902') -- 5
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('ee13bc32-a67c-4998-855b-322cb9ce4902','PatientUid',0,'Patient','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>patientsUIDs</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindPatient</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',5,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b2eb34e0-d37d-45f4-87fa-8b80b4b23878') -- 6
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b2eb34e0-d37d-45f4-87fa-8b80b4b23878','ProcedureCodes',0,'Procedures','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureCodes</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',6,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8ff20484-86b8-412f-a60b-73f3081e5141') -- 7
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('8ff20484-86b8-412f-a60b-73f3081e5141','Type',0,'Type','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Type</Name><ButtonLabel>Both</ButtonLabel><ButtonValue>Both</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Type</Name><ButtonLabel>Services Ordered</ButtonLabel><ButtonValue>ordered</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Type</Name><ButtonLabel>Services Performed</ButtonLabel><ButtonValue>performed</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',7,0,0,'8/28/2022 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'b9177b0a-7dba-4ca4-bbfe-c723fd357f32') -- 8
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b9177b0a-7dba-4ca4-bbfe-c723fd357f32','ReportFormat',0,'Report Format','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Report</ButtonLabel><ButtonValue>Report</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportFormat</Name><ButtonLabel>Excel</ButtonLabel><ButtonValue>Excel</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1aca2be4-916a-46a2-8b2b-6b8e829e4765',8,0,0,'8/28/2022 7:00:00 PM')
END
GO

--------------------------------------------------------------------
--ListReport
IF EXISTS (select * from ListReport where ReportUid = '4E969ED9-E2CA-4F4F-9283-280B500FFC4C')
BEGIN

Update ListReport
set Modifier=5
,UserDefined=0
,ReportParameters='<ReportParameters />'
,LastModifiedByUid=null
,LastModifiedDate='2022-08-29 00:00:00.000'
where reportuid='4E969ED9-E2CA-4F4F-9283-280B500FFC4C';

END
GO
------------------------------------------------------------------
--ListReportRdl
IF EXISTS (select * from ListReportRdl where ReportRdlUid = '78C3AEC8-DA84-40CF-8A13-7AD5C953CB4C')
BEGIN

Update ListReportRdl
set ReportFormat='Report'
,UserDefined=0
,LastModifiedByUid=null
,LastModifiedDate='2022-08-29 00:00:00.000'
where ReportRdlUid='78C3AEC8-DA84-40CF-8A13-7AD5C953CB4C';

END 
GO
-- #108346 end

-- #104926 _ActiveProviderNPI_MIGRATION.sql
Update ListReport
set Modifier=5
,ReportFolderUid='E9AF59F5-C455-417D-A572-F8E16994C9E8'
Where ReportUid='06218305-960C-4CA9-AB28-11F4405ED5A9'; 

Update ListReportRDL
set ReportFormat='Report'
Where ReportRDLUid='3526DCF4-0384-4089-A54F-A17660652E54'; -- REPORT
GO

-- #109132 _109134_patient aging add condition_MIGRATION.sql
UPDATE ListUserDefinedControl 
SET SortOrder=11
where UserDefinedControlUid = 'dbc4d17b-7567-469e-96f0-b5e3aca58936'

UPDATE ListUserDefinedControl 
SET SortOrder=12
where UserDefinedControlUid = '71dd6d82-5749-46f3-88d5-fa79af8d288a'

UPDATE ListUserDefinedControl 
SET SortOrder=13
where UserDefinedControlUid = 'a8244dc5-c4fa-4612-9238-dc94cd13e362'

UPDATE ListUserDefinedControl 
SET SortOrder=14
where UserDefinedControlUid = '44d6fff6-cc55-4b09-88a0-f400d4e619d3'

UPDATE ListUserDefinedControl 
SET SortOrder=15
where UserDefinedControlUid = 'b52d58f4-2820-48cb-b326-95c346df1bd9'

UPDATE ListUserDefinedControl 
SET SortOrder=16
where UserDefinedControlUid = '60276667-a80c-4672-b9d2-82a21c66d995'

UPDATE ListUserDefinedControl 
SET SortOrder=17
where UserDefinedControlUid = '8672616f-3274-4066-8283-3327f5050da4'

UPDATE ListUserDefinedControl 
SET SortOrder=18
where UserDefinedControlUid = '8aa3c025-6423-4031-ae64-0143a36d749a'

UPDATE ListUserDefinedControl 
SET SortOrder=19
where UserDefinedControlUid = 'e2ca05b7-e9f4-434a-a567-ca70658d0375'

UPDATE ListUserDefinedControl 
SET SortOrder=20
where UserDefinedControlUid = 'f2c5c12f-4164-4a7a-8f1d-48dbe0d70ae2'

update ListUserDefinedControl 
set UserDefined=0
,LastModifiedByUid=null
,LastModifiedDate='2022-09-22 00:00:00.000'
where UserDefinedControlGroupUid='43101AAB-B46E-46B1-AE6D-97E6D6D33D79';
GO
-- #109132 end

-- #99755 _ProviderApplicationLicenseList_MIGRATION.sql
UPDATE ListReport
set Modifier=5
where reportuid='8DE50DBF-3EA8-48D2-8598-2AA1C9C706A4';

UPDATE ListReportRdl
set ReportFormat='Report'
where ReportRdlUid='B52D1438-EF17-430C-80C5-8EB62636C233';
GO

-- #113128 _ChargeReviewExcel_MIGRATION.sql
UPDATE ListUserDefinedControl 
set SortOrder=6
where UserDefinedControlUid='cf6ff19d-12d2-4496-8a70-c558c55dc4f6' -- "ProcedureGroupUID"

UPDATE ListUserDefinedControl 
set SortOrder=7
where UserDefinedControlUid='f9185ae3-80bd-4b9c-83c5-332fd37a33a8'  -- "ProcedureUID"

UPDATE ListUserDefinedControl 
set SortOrder=8
where UserDefinedControlUid='d4fe49ab-b8c8-4914-83b5-39bc57a7e64b' -- "RVUScheduleUID"

UPDATE ListUserDefinedControl 
set SortOrder=9
where UserDefinedControlUid='7e08fdf1-01db-4e57-be58-45a9f1ba78bb' -- "PaidFlag"
GO


-- #112977 _AmountAllowedComparison_MIGRATION.sql
update ListUserDefinedControl
set sortorder=1
where UserDefinedControlUid='8CDE0B44-6F1E-4AF0-A03E-5F40C8EB9E8A' --aac

update ListUserDefinedControl
set sortorder=2
where UserDefinedControlUid='2DBDB62C-C208-4D1D-8595-AF1B0634CE2F' -- 	DateOption

update ListUserDefinedControl
set sortorder=3
where UserDefinedControlUid='74AC3DA3-645F-45E9-A8B2-B5E8B4835680' -- 	ProviderUid

update ListUserDefinedControl
set sortorder=4
where UserDefinedControlUid='1C0F1053-6B51-4E40-85BA-E17B794110C0' -- 	ProviderOption

update ListUserDefinedControl
set sortorder=5
where UserDefinedControlUid='DC10D63F-E397-4419-AC8E-D4E427CCBC32' --	FinancialCenterUid 

update ListUserDefinedControl
set sortorder=6
where UserDefinedControlUid='9A107BB5-981C-4DFD-86B1-D70FC33845D7' --	ServiceSiteUid 

update ListUserDefinedControl
set sortorder=7
where UserDefinedControlUid='D102D839-36CF-46C1-BF8A-9BB12333562D' --	FeeScheduleUid 

update ListUserDefinedControl
set sortorder=8
where UserDefinedControlUid='6E39D034-14A9-40B5-BBC7-B8C7B1854240' --	ARBatchUid 

update ListUserDefinedControl
set sortorder=9
where UserDefinedControlUid='1D63374B-8E4B-43DA-8F1D-1D28F05BD84F' --	InsurancePlanUid 

update ListUserDefinedControl
set sortorder=10
where UserDefinedControlUid='56615659-B509-4488-98E2-66125AEC2F8A' --	ProcedureUid 

update ListUserDefinedControl
set sortorder=11
where UserDefinedControlUid='38E5EC5F-7178-48B9-BFB0-4E2E88E1CBF0' --	PatientUid 

update ListUserDefinedControl
set sortorder=12
where UserDefinedControlUid='C7162337-241A-4FF9-9DB6-E12EB0901D99' --	IncludeOnlyDiscrepancies 

update ListUserDefinedControl
set sortorder=13
where UserDefinedControlUid='FAC0AEDC-687F-404C-9DD6-FBF6788AB113' -- 	ExcludeUnpaidProcedures

update ListUserDefinedControl
set sortorder=14
where UserDefinedControlUid='20BF4610-F64A-4595-A650-7EAE4AADBCD6' --	ReportFormat 
GO




--------------------------------------------------------------------------------
-- #60294 Keep this at the bottom
-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- enable these triggers after updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] ENABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] ENABLE TRIGGER [BlockReportUpdates]
GO
-- #60294 Keep this at the bottom

