--***#77047 POST MIGRATION SCRIPT FOR PRMHEAD***
--***REPLACED PREVIOUS DELETE STATEMENTS 10/04/2021****
--RETIRED 2021/2022 SEASONAL INFLUENZA NDCs
Update VaccineUnitUse Set Inactive = '1', UseUnitEndDate = '20210630' WHERE NDC11 in (
'70461-0120-04',
'58160-0885-41',
'49281-0720-88',
'19515-0816-41',
'49281-0120-88',
'49281-0420-88',
'49281-0420-58',
'49281-0520-00',
'49281-0633-78'
)
Update VaccineUnitUse Set Inactive = '1', UseUnitEndDate = '20210701' WHERE NDC11  in (
'70461-0420-11',
'70461-0320-04'
)

--DELETE DUPLICATE VAXELIS NDC11=63361-0243-58
--DELETE FROM VaccineUnitUse WHERE VaccineUnitUseUid = '7E5D5C6D-0F33-4BD6-834A-3C58F3B32385'

Update VaccineUnitUse  Set MVX = 'MSP' WHERE NDC11 in
('63361-0243-58', '63361-0243-88')

--CHANGE UseUnitLabelerName TO Emergent Travel, Inc FOR MVX = 'PAX'
UPDATE VaccineUnitUse SET UseUnitLabelerName = 'Emergent Travel Health, Inc' WHERE MVX = 'PAX'

--CHANGE ListVaccineMfr NOTES FOR PAX
UPDATE ListVaccineMfr SET Notes = 'Emergent Travel Health, Inc (Formerly PaxVax)' WHERE VaccineMfrUid = '1EC052AE-0C1E-4734-B219-CBDBBEABF580'

--CHANGE BCG VACCINE TO MVX=MSD
UPDATE VaccineUnitUse SET UseUnitLabelerName='Merck Sharpe & Dhome Corp.', MVX = 'MSD' 
WHERE MVX = 'OTC'
GO

-- #76695_ListMedicationPRNReason_Update_Snomed.sql
UPDATE ListMedicationPRNReason SET SnomedConceptID = '22253000' , DescriptionUid = '00000000-0000-0000-0000-000751640015' WHERE MedicationPRNReasonUid = 'C5E7E48B-04AE-48B4-B3F9-2FE9ECACBCD3' AND SnomedConceptID = '367206007' AND Name = 'for pain'
UPDATE ListMedicationPRNReason SET SnomedConceptID = '422587007', DescriptionUid = '00000000-0000-0000-0000-002639898010' WHERE MedicationPRNReasonUid = '8330FC19-D4DA-4A29-9768-802133903A9E' AND SnomedConceptID = '73879007'  AND Name = 'for nausea'
UPDATE ListMedicationPRNReason SET SnomedConceptID = '16331000' , DescriptionUid = '00000000-0000-0000-0000-000743336017' WHERE MedicationPRNReasonUid = 'C0B3EEA8-9FA9-46B5-B7E9-B018270910FA' AND SnomedConceptID = '139300004' AND Name = 'for heartburn'
GO

-- #77995_ListDataFormatter_FieldDefinition_Update.sql
update ListDataFormatter
set FieldDefinition = '<Fields>
  <DynamicFields Type="UserDefinedHistory" />
  <Field Name="UserDefinedHistory" />
  <Field Name="CompleteSocialHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteInfectionHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteSurgicalHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteFamilyHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteGeneticScreening" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteMedicationHistory" AllowsList="True" AllowsText="True" />
  <Field Name="CompleteFoodAllergy" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteDrugAllergy" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteEnvtAllergy" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteFunctionalAssessment" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CompleteSpecialtyQAndA" AllowsList="True" AllowsText="True" />
  <Field Name="HistoryComment" />
  <Field Name="ActiveDiagnosis" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ActiveDiagnosisNamesOnly" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="InfectionHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="SurgicalHistory" AllowsList="True" AllowsText="True" AllowsTable="True" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="OBSOLETE: Please use ProcedureHistory and select the appropriate procedure history type to display this information." />
  <Field Name="FamilyHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="GeneticScreening" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="SocialHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="MedicationHistory" AllowsList="True" AllowsText="True" />
  <Field Name="FoodAllergy" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="DrugAllergy" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="EnvtAllergy" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="FunctionalAssessment" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ImmunizationHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="MenstrualHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="PregnancyHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="SpecialtyQAndA" AllowsList="True" AllowsText="True" />
  <Field Name="StandingOrders" AllowsTable="True" />
  <Field Name="DiagnosisHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="DiagnosisHistoryNamesOnly" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ActiveProblems" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="HealthMaintenanceRules" AllowsTable="True" />
  <Field Name="VitalsFlow" Layout="Filter" ListTable="ObservationDefaultSettings" ListTableTitle="Vitals Layout" />
  <Field Name="VitalsFlowMetric" Layout="Filter" ListTable="ObservationDefaultSettings" ListTableTitle="Vitals Layout" />
  <Field Name="ProblemHistory" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="CurrentMedication" AllowsList="True" AllowsText="True" />
  <Field Name="CurrentMedicationShort" AllowsList="True" AllowsText="True" />
  <Field Name="HistoryCommentAddendumNotes" />
  <Field Name="ActiveDiagnosisBeforeVisit" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ActiveDiagnosisNamesOnlyBeforeVisit" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ActiveProblemsBeforeVisit" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ProblemHistoryBeforeVisit" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ActiveDiagnosisWithCodes" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="DiagnosisHistoryWithCodes" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="ActiveDiagnosisBeforeVisitWithCodes" AllowsList="True" AllowsText="True" AllowsTable="True" />
  <Field Name="FilteredMedicationHistory" Layout="Filter" ListTable="EditListFilter" ListTableTitle="Medication Hx Filter" />
  <Field Name="ComprehensiveOBPregnancies" AllowsTable="True" />
  <Field Name="ComprehensiveOBSummary" AllowsTable="True" />
  <Field Name="AddressHistory" AllowsTable="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Patient Address History includes all past addresses; Visit Address History includes past addresses up to the visit date." />
  <Field Name="ImplantableDeviceHistory" AllowsTable="True" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditHistory" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="A history group that is an implantable device history must be chosen. Can choose between: Summary - Shows the most current history of each type on the generated for date and will not show deleted history. Or Detail - Shows all history on or before the generated for date and will show deleted history." />
  <Field Name="DiabetesProcedureHistory" AllowsList="True" AllowsText="True" AllowsTable="True" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="OBSOLETE: Please use ProcedureHistory and select the appropriate procedure history type to display this information." />
  <Field Name="PreventativeCareHistory" AllowsList="True" AllowsText="True" AllowsTable="True" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="OBSOLETE: Please use ProcedureHistory and select the appropriate procedure history type to display this information." />
  <Field Name="ProcedureHistory" AllowsList="True" AllowsText="True" AllowsTable="True" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditProcedureHistory" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="A history group that is a procedure history must be chosen. Can choose between: Summary - Shows the most current history of each type on the generated for date and will not show deleted history. Or Detail - Shows all history on or before the generated for date and will show deleted history." />
  <Field Name="ProblemStory" AllowsText="True" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Obsolete, use ProblemStoryHistory, PatientProblemStoryHistory, or VisitProblemStoryHistory with the summary option." />
  <Field Name="ProblemStoryHistory" AllowsText="True" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditHistory" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Each problem has a permanent story that moves from Visit to Visit until changed by the Provider. Can choose between: Summary - Shows the most current history of each type on the generated for date and will not show deleted history. Or Detail - Shows all history on or before the generated for date and will show deleted history." />
</Fields>'
where DataFormatterUid = '613EA28C-45B0-4520-96B4-A5C512175312'
GO

-- #84550 _Post_Update_PRMHEAD_COVID19_AdultVaccine.sql
--**********************************************************************************************************
--84550_Post_Update_PRMHEAD_COVID19_AdultVaccine.sql
--Change existing Covid-19 to Covid-19 (Adult) & set the age range
--**********************************************************************************************************
--ListVaccine - Change Covid-19 to Covid-19 (Adult) & update other fields
Update ListVaccine Set Name = 'Covid-19 (Adult)', MinAge='12', MinAgeSpanUid='AA48382B-3F5F-484E-BC1F-B8F1C5CA297B', 
MaxAge='100',
MaxAgeSpanUid='AA48382B-3F5F-484E-BC1F-B8F1C5CA297B', RoutineDoses='2', 
Schedule='<Schedule><Routine doseNum="1" useAge="True" ageorIntervalVal="0" durationUid="00000000-0000-0000-0000-000000000000" /><Routine doseNum="2" useAge="True" ageorIntervalVal="0" durationUid="00000000-0000-0000-0000-000000000000" /></Schedule>',
DisplayOrder='0',
UserDefined='0',
LastModifiedByUid=NULL,
LastModifiedDate='2021-10-29 16:10:03.157'
WHERE VaccineUid = '22BB76DB-2AD5-49E2-B230-1F6EB3319E97'
GO

-- #76530 _Update_BMI_Note_Processor.sql  updated 11/9/2021
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF EXISTS (SELECT * FROM ListAddIn WHERE AddInUid='CCD7CB59-7995-4DB7-8567-37B9430C86B4')
BEGIN
UPDATE listaddin set LastModifiedDate = GETUTCDATE(), configurationdata='<?xml version="1.0" encoding="UTF-8"?>
<BmiProcessorConfiguration xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   <EnableCpt>true</EnableCpt>
   <EnableIcd>true</EnableIcd>
   <IsExclude>true</IsExclude>
   <InsurancePlans />
   <RequiredTabs>DX, SP</RequiredTabs>
   <UseDefaultCpt>false</UseDefaultCpt>
   <ListenerItems>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.1</DiagnosisCode10>
         <DiagnosisCode9>V85.0</DiagnosisCode9>
         <Description>Body mass index (BMI) 19.9 or less, adult</Description>
         <RangeStart>0</RangeStart>
         <RangeEnd>19.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.20</DiagnosisCode10>
         <DiagnosisCode9>V85.1</DiagnosisCode9>
         <Description>Body mass index (BMI) 20.0-20.9, adult</Description>
         <RangeStart>20</RangeStart>
         <RangeEnd>20.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.21</DiagnosisCode10>
         <DiagnosisCode9>V85.1</DiagnosisCode9>
         <Description>Body mass index (BMI) 21.0-21.9, adult</Description>
         <RangeStart>21</RangeStart>
         <RangeEnd>21.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.22</DiagnosisCode10>
         <DiagnosisCode9>V85.1</DiagnosisCode9>
         <Description>Body mass index (BMI) 22.0-22.9, adult</Description>
         <RangeStart>22</RangeStart>
         <RangeEnd>22.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.23</DiagnosisCode10>
         <DiagnosisCode9>V85.1</DiagnosisCode9>
         <Description>Body mass index (BMI) 23.0-23.9, adult</Description>
         <RangeStart>23</RangeStart>
         <RangeEnd>23.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.24</DiagnosisCode10>
         <DiagnosisCode9>V85.1</DiagnosisCode9>
         <Description>Body mass index (BMI) 24.0-24.9, adult</Description>
         <RangeStart>24</RangeStart>
         <RangeEnd>24.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.25</DiagnosisCode10>
         <DiagnosisCode9>V85.21</DiagnosisCode9>
         <Description>Body mass index (BMI) 25.0-25.9, adult</Description>
         <RangeStart>25</RangeStart>
         <RangeEnd>25.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.26</DiagnosisCode10>
         <DiagnosisCode9>V85.22</DiagnosisCode9>
         <Description>Body mass index (BMI) 26.0-26.9, adult</Description>
         <RangeStart>26</RangeStart>
         <RangeEnd>26.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.27</DiagnosisCode10>
         <DiagnosisCode9>V85.23</DiagnosisCode9>
         <Description>Body mass index (BMI) 27.0-27.9, adult</Description>
         <RangeStart>27</RangeStart>
         <RangeEnd>27.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.28</DiagnosisCode10>
         <DiagnosisCode9>V85.24</DiagnosisCode9>
         <Description>Body mass index (BMI) 28.0-28.9, adult</Description>
         <RangeStart>28</RangeStart>
         <RangeEnd>28.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.29</DiagnosisCode10>
         <DiagnosisCode9>V85.25</DiagnosisCode9>
         <Description>Body mass index (BMI) 29.0-29.9, adult</Description>
         <RangeStart>29</RangeStart>
         <RangeEnd>29.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.30</DiagnosisCode10>
         <DiagnosisCode9>V85.30</DiagnosisCode9>
         <Description>Body mass index (BMI) 30.0-30.9, adult</Description>
         <RangeStart>30</RangeStart>
         <RangeEnd>30.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.31</DiagnosisCode10>
         <DiagnosisCode9>V85.31</DiagnosisCode9>
         <Description>Body mass index (BMI) 31.0-31.9, adult</Description>
         <RangeStart>31</RangeStart>
         <RangeEnd>31.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.32</DiagnosisCode10>
         <DiagnosisCode9>V85.32</DiagnosisCode9>
         <Description>Body mass index (BMI) 32.0-32.9, adult</Description>
         <RangeStart>32</RangeStart>
         <RangeEnd>32.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.33</DiagnosisCode10>
         <DiagnosisCode9>V85.33</DiagnosisCode9>
         <Description>Body mass index (BMI) 33.0-33.9, adult</Description>
         <RangeStart>33</RangeStart>
         <RangeEnd>33.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.34</DiagnosisCode10>
         <DiagnosisCode9>V85.34</DiagnosisCode9>
         <Description>Body mass index (BMI) 34.0-34.9, adult</Description>
         <RangeStart>34</RangeStart>
         <RangeEnd>34.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.35</DiagnosisCode10>
         <DiagnosisCode9>V85.35</DiagnosisCode9>
         <Description>Body mass index (BMI) 35.0-35.9, adult</Description>
         <RangeStart>35</RangeStart>
         <RangeEnd>35.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.36</DiagnosisCode10>
         <DiagnosisCode9>V85.36</DiagnosisCode9>
         <Description>Body mass index (BMI) 36.0-36.9, adult</Description>
         <RangeStart>36</RangeStart>
         <RangeEnd>36.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.37</DiagnosisCode10>
         <DiagnosisCode9>V85.37</DiagnosisCode9>
         <Description>Body mass index (BMI) 37.0-37.9, adult</Description>
         <RangeStart>37</RangeStart>
         <RangeEnd>37.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.38</DiagnosisCode10>
         <DiagnosisCode9>V85.38</DiagnosisCode9>
         <Description>Body mass index (BMI) 38.0-38.9, adult</Description>
         <RangeStart>38</RangeStart>
         <RangeEnd>38.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.39</DiagnosisCode10>
         <DiagnosisCode9>V85.39</DiagnosisCode9>
         <Description>Body mass index (BMI) 39.0-39.9, adult</Description>
         <RangeStart>39</RangeStart>
         <RangeEnd>39.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.41</DiagnosisCode10>
         <DiagnosisCode9>V85.41</DiagnosisCode9>
         <Description>Body mass index (BMI) 40.0-44.9, adult</Description>
         <RangeStart>40</RangeStart>
         <RangeEnd>44.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.42</DiagnosisCode10>
         <DiagnosisCode9>V85.42</DiagnosisCode9>
         <Description>Body mass index (BMI) 45.0-49.9, adult</Description>
         <RangeStart>45</RangeStart>
         <RangeEnd>49.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.43</DiagnosisCode10>
         <DiagnosisCode9>V85.43</DiagnosisCode9>
         <Description>Body mass index (BMI) 50-59.9 , adult</Description>
         <RangeStart>50</RangeStart>
         <RangeEnd>59.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.44</DiagnosisCode10>
         <DiagnosisCode9>V85.44</DiagnosisCode9>
         <Description>Body mass index (BMI) 60.0-69.9, adult</Description>
         <RangeStart>60</RangeStart>
         <RangeEnd>69.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.45</DiagnosisCode10>
         <DiagnosisCode9>V85.45</DiagnosisCode9>
         <Description>Body mass index (BMI) 70 or greater, adult</Description>
         <RangeStart>70</RangeStart>
         <RangeEnd>999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.51</DiagnosisCode10>
         <DiagnosisCode9>V85.51</DiagnosisCode9>
         <Description>Body mass index (BMI) pediatric, less than 5th percentile for age</Description>
         <RangeStart>0</RangeStart>
         <RangeEnd>4.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.52</DiagnosisCode10>
         <DiagnosisCode9>V85.52</DiagnosisCode9>
         <Description>Body mass index (BMI) pediatric, 5th percentile to less than 85th percentile for age</Description>
         <RangeStart>5</RangeStart>
         <RangeEnd>84.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.53</DiagnosisCode10>
         <DiagnosisCode9>V85.53</DiagnosisCode9>
         <Description>Body mass index (BMI) pediatric, 85th percentile to less than 95th percentile for age</Description>
         <RangeStart>85</RangeStart>
         <RangeEnd>94.999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <DiagnosisCode10>Z68.54</DiagnosisCode10>
         <DiagnosisCode9>V85.54</DiagnosisCode9>
         <Description>Body mass index (BMI) pediatric, greater than or equal to 95th percentile for age</Description>
         <RangeStart>95</RangeStart>
         <RangeEnd>999</RangeEnd>
         <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
         <AgeStart xsi:nil="true" />
         <AgeEnd xsi:nil="true" />
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <CptCode>G8417</CptCode>
         <Description>BMI is documented above normal parameters and a follow-up plan is documented</Description>
         <RangeStart>25</RangeStart>
         <RangeEnd>999</RangeEnd>
         <AgeGroup xsi:nil="true" />
         <AgeStart>18</AgeStart>
         <AgeEnd>999</AgeEnd>
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <CptCode>G8418</CptCode>
         <Description>BMI is documented below normal parameters and a follow-up plan is documented</Description>
         <RangeStart>0.1</RangeStart>
         <RangeEnd>18.4</RangeEnd>
         <AgeGroup xsi:nil="true" />
         <AgeStart>18</AgeStart>
         <AgeEnd>999</AgeEnd>
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <CptCode>G8420</CptCode>
         <Description>BMI is documented within normal parameters and no follow-up plan is required</Description>
         <RangeStart>18.5</RangeStart>
         <RangeEnd>24.999</RangeEnd>
         <AgeGroup xsi:nil="true" />
         <AgeStart>18</AgeStart>
         <AgeEnd>999</AgeEnd>
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <CptCode>G8421</CptCode>
         <Description>Bmi not documented and no reason is given</Description>
         <RangeStart>0</RangeStart>
         <RangeEnd>0</RangeEnd>
         <AgeGroup xsi:nil="true" />
         <AgeStart>0</AgeStart>
         <AgeEnd>999</AgeEnd>
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <CptCode>G8422</CptCode>
         <Description>BMI not documented, documentation the patient is not eligible for BMI calculation</Description>
         <RangeStart>-1</RangeStart>
         <RangeEnd>-1</RangeEnd>
         <AgeGroup xsi:nil="true" />
         <AgeStart>0</AgeStart>
         <AgeEnd>999</AgeEnd>
      </BodyMassIndexListener>
      <BodyMassIndexListener>
         <CptCode>G8938</CptCode>
         <Description>BMI is documented as being outside of normal limits, follow-up plan is not documented, documentation the patient is not eligible</Description>
         <RangeStart>0</RangeStart>
         <RangeEnd>0</RangeEnd>
         <AgeGroup xsi:nil="true" />
         <AgeStart>0</AgeStart>
         <AgeEnd>999</AgeEnd>
      </BodyMassIndexListener>
   </ListenerItems>
</BmiProcessorConfiguration>' where addinuid='CCD7CB59-7995-4DB7-8567-37B9430C86B4';

END
GO
-- #76530 end

-- #85719 _ListMedicationRoute_Injection.sql
UPDATE ListMedicationRoute
SET SnomedConceptID = NULL, DescriptionUid = NULL, LastModifiedDate = '2021-11-09 22:15:07.957'
WHERE MedicationRouteUid = '9F4D3F03-6BAB-40D0-9537-777B099136AC'
  AND SnomedConceptID = '424109004'
  AND DescriptionUid = '00000000-0000-0000-0000-002642080011'
GO

-- #76837 
-- user story #76837 update ListFormTitle
update ListFormTitle set Columns = '<root>
  <default profile="user" prefix="[VisitDate]" tablename="ViewFormTitleVisit" uidname="VisitUid">
    <column name="FullName" prefix="" />
    <column name="ExternalID" prefix="/" />
    <column name="MedicalRecordNumber" prefix="/" />
    <column name="Age" prefix="/" />
    <column name="Birthdate" prefix="/DOB:" />
    <column name="Gender" prefix="/" />
    <column name="InsuranceCarrier" prefix="/" />
    <column name="InsurancePlan" prefix=" " />
    <column name="AppointmentStatus" prefix="/" />
    <column name="Weight" prefix="/" />
    <column name="Height" prefix="/" />
    <column name="Temperature" prefix="/T-" />
    <column name="RespiratoryRate" prefix="/RR-" />
    <column name="HeartRate" prefix="/HR-" />
    <column name="BloodPressure" prefix="/BP-" />
  </default>
  <master>
    <column name="Account" prefix="/" />
    <column name="Age" prefix="/" />
    <column name="AkaFirstName" prefix="/" />
    <column name="AkaLastName" prefix="/" />
    <column name="AkaFullName" prefix="/" />
    <column name="AppointmentStatus" prefix="/" />
    <column name="Birthdate" prefix="/DOB:" />
    <column name="BloodPressure" prefix="/BP-" />
    <column name="Bmi" prefix="/BMI-" />
    <column name="CheckinDateTime" prefix="/" />
    <column name="CompletedDate" prefix="/" />
    <column name="ClinicalNoteType" prefix="/" />
    <column name="DischargeDateTime" prefix="/" />
    <column name="DominantHand" prefix="/" />
    <column name="Ethnicity" prefix="/" />
    <column name="ExternalID" prefix="/" />
    <column name="FirstName" prefix="/" />
    <column name="Gender" prefix="/" />
    <column name="GenderIdentity" prefix="/" />
    <column name="FullName" prefix="/" />
    <column name="HeartRate" prefix="/HR-" />
    <column name="Height" prefix="/" />
    <column name="InsuranceCarrier" prefix="/" />
    <column name="InsurancePlan" prefix="/" />
    <column name="Language" prefix="/" />
    <column name="LastName" prefix="/" />
    <column name="MaritalStatus" prefix="/" />
    <column name="MedicalRecordNumber" prefix="/" />
    <column name="MiddleName" prefix="/" />
    <column name="PayerPlanName" prefix="/" />
    <column name="Race" prefix="/" />
    <column name="RenderingProviderFirstName" prefix="/" />
    <column name="RenderingProviderFullName" prefix="/" />
    <column name="RenderingProviderLastName" prefix="/" />
    <column name="RenderingProviderMiddleName" prefix="/" />
    <column name="RespiratoryRate" prefix="/RR-" />
    <column name="ServiceSite" prefix="/" />
	<column name="SexualOrientation" prefix="/" />
    <column name="Suffix" prefix="/" />
    <column name="Temperature" prefix="/T-" />
    <column name="Weight" prefix="/" />
    <column name="VisitDate" prefix="/" />
    <column name="VisitType" prefix="/" />
  </master>
</root>' 
where FormTitleUid = '99999999-0000-0000-0000-000000000001'
GO

-- #82002_Remove Find Table Entry from CQM Batch Search.sql
IF EXISTS (SELECT * FROM ListFindTable WHERE FindTableUid='0F4F0D54-0DB0-4DE7-AF8F-54E6EF8B65FC')
BEGIN
	UPDATE ListFindTable 
		SET FindControlClass='iMedica.Prm.Client.UI.PrmGeneralControls.Find.ControlFindGeneric'
		WHERE FindTableUid='0F4F0D54-0DB0-4DE7-AF8F-54E6EF8B65FC'
END
GO

-- #83754_eMEDIX_eLIGIBILITY_Clearinghouse_Aprima_URL.sql
DECLARE @AprimaUrl_PlugInSettingUid UniqueIdentifier = '29167448-8B82-45A3-9DA3-0234E698079D'
DECLARE @eMEDIXeLIGIBILITY_ClaimClearinghouseUid UniqueIdentifier = 'A0CBFAD3-D9F4-4792-BFD8-DC8B2F040AC2'
DECLARE @Name varchar(15) = 'AprimaUrl'
DECLARE @Value varchar(150) = 'https://cpeligibility.aprima.com/communityexchange/partner/PartnerService'

IF NOT EXISTS (Select 1 FROM PlugInSettings where PlugInSettingsUid = @AprimaUrl_PlugInSettingUid)
BEGIN
    INSERT INTO PlugInSettings (PlugInSettingsUid,           ClaimClearingHouseUid,                    Inactive,  Name,  Value,   LastModifiedDate,         UserDefined)
                        values (@AprimaUrl_PlugInSettingUid, @eMEDIXeLIGIBILITY_ClaimClearinghouseUid, 0,         @Name, @Value, '2021-11-12 00:00:00.000', 0)
END

IF EXISTS (Select 1 From PlugInSettings where PlugInSettingsUid <> @AprimaUrl_PlugInSettingUid AND ClaimClearingHouseUid = @eMEDIXeLIGIBILITY_ClaimClearinghouseUid and Name = @Name)
BEGIN
             DELETE FROM PlugInSettings where PlugInSettingsUid <> @AprimaUrl_PlugInSettingUid AND ClaimClearingHouseUid = @eMEDIXeLIGIBILITY_ClaimClearinghouseUid and Name = @Name
END
GO

-- #85165_ListDesktopControl_RemoveMMA.sql
UPDATE ListDesktopControl SET Name = 'Electronic Prior Authorization' 
WHERE DesktopControlUid = '29499A20-DDD2-4EFF-8826-82F920BB3D20' AND Name = 'Electronic Prior Authorization/Medication Management'
GO

-- #87960_ListDesktopControl_PrescriptionQueue.sql87960_ListDesktopControl_PrescriptionQueue.sql
UPDATE ListDesktopControl SET Name = 'Prescription Queue' 
WHERE DesktopControlUid = '27319965-6A9B-4ECE-A1AA-BCCEE0E7ADA2' AND Name = 'Unsent Prescriptions'
GO

-- #82892_Post_Script.sql
-- #82892 CDC VACCINE UPDATE Nov 19 2021 update
IF EXISTS(SELECT * from VaccineUnitUse where VaccineUnitUseUid = '5C347A1E-4F3B-4AE7-A44D-7B3FFD30D2BE')
BEGIN
	UPDATE VaccineUnitUse SET UseUnitstartDate = '20210716' WHERE VaccineUnitUseUid = '5C347A1E-4F3B-4AE7-A44D-7B3FFD30D2BE'
END
GO

-- #89891_ListMedication_StructuredSIG (1).sql
UPDATE ListMedicationUnit SET NCITCode = 'C25397' WHERE MedicationUnitUid = 'D266317D-D184-42DC-9322-B87CCAD92DDF' AND Name = 'Application'   AND (NCITCode IS NULL OR NCITCode <> 'C25397')
UPDATE ListMedicationUnit SET NCITCode = 'C48480' WHERE MedicationUnitUid = 'FC42EBE7-5C16-4F91-AA73-B6BC48B0A4AA' AND Name = 'Capsule(s)'    AND (NCITCode IS NULL OR NCITCode <> 'C48480')
UPDATE ListMedicationUnit SET NCITCode = 'C48155' WHERE MedicationUnitUid = '495C5E93-5C82-44BF-8AC0-423D83A29280' AND Name = 'Gram(s)'       AND (NCITCode IS NULL OR NCITCode <> 'C48155')
UPDATE ListMedicationUnit SET NCITCode = 'C48152' WHERE MedicationUnitUid = '708613A7-6AC4-4027-8DC9-ABA237F8C5CA' AND Name = 'Microgram(s)'  AND (NCITCode IS NULL OR NCITCode <> 'C48152')
UPDATE ListMedicationUnit SET NCITCode = 'C28253' WHERE MedicationUnitUid = 'D362ABC2-4661-4703-80E8-0D506937274C' AND Name = 'Milligram(s)'  AND (NCITCode IS NULL OR NCITCode <> 'C28253')
UPDATE ListMedicationUnit SET NCITCode = 'C28254' WHERE MedicationUnitUid = 'E9B15F0D-CB8F-4364-AC09-B86301B4D585' AND Name = 'Milliliter(s)' AND (NCITCode IS NULL OR NCITCode <> 'C28254')
UPDATE ListMedicationUnit SET NCITCode = 'C48519' WHERE MedicationUnitUid = 'CB31A6DC-E156-4F5B-9119-5F6D53ABCFB0' AND Name = 'Oz'            AND (NCITCode IS NULL OR NCITCode <> 'C48519')
UPDATE ListMedicationUnit SET NCITCode = 'C65060' WHERE MedicationUnitUid = '0ABA7D84-B35E-4EEE-B34B-AC3B9244C2D6' AND Name = 'Puff(s)'       AND (NCITCode IS NULL OR NCITCode <> 'C65060')
UPDATE ListMedicationUnit SET NCITCode = 'C48537' WHERE MedicationUnitUid = 'CE49BA3E-D8C8-4E14-A1E3-7A9B24EB14C8' AND Name = 'Spray'         AND (NCITCode IS NULL OR NCITCode <> 'C48537')
UPDATE ListMedicationUnit SET NCITCode = 'C48539' WHERE MedicationUnitUid = '1104D40F-33A8-44DD-9374-2B549F1D40F3' AND Name = 'Suppository'   AND (NCITCode IS NULL OR NCITCode <> 'C48539')
UPDATE ListMedicationUnit SET NCITCode = 'C48542' WHERE MedicationUnitUid = '944AE82B-8244-4553-9FDD-328FFFE901C7' AND Name = 'Tablet(s)'     AND (NCITCode IS NULL OR NCITCode <> 'C48542')
UPDATE ListMedicationUnit SET NCITCode = 'C44278' WHERE MedicationUnitUid = '0B19C36D-4C49-4887-B488-7ABCF4F73B77' AND Name = 'Unit Dose'     AND (NCITCode IS NULL OR NCITCode <> 'C44278')
UPDATE ListMedicationUnit SET NCITCode = 'C44278' WHERE MedicationUnitUid = '513BC21A-B348-43EA-A8B4-276D5E550F1E' AND Name = 'Unit(s)'       AND (NCITCode IS NULL OR NCITCode <> 'C44278')

UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '307165006', DescriptionUid = '00000000-0000-0000-0000-000703654012', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = 'CF31E947-D0BF-47FC-B9F6-D8C2653E8A6B' AND Name = 'AC'     AND (InstructionsType <> 4 OR SnomedConceptID IS NULL OR SnomedConceptID <> '307165006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000703654012' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 1, SnomedConceptID = '258703001', DescriptionUid = '00000000-0000-0000-0000-000650151014', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = 'FC88C21E-D187-484B-A82C-8F6C252A472C' AND Name = 'BID'    AND (InstructionsType <> 1 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258703001' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650151014' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258705008', DescriptionUid = '00000000-0000-0000-0000-000650153012', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '7B70630B-8CB1-45C7-9760-591903C9FB01' AND Name = 'BIW'    AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258705008' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650153012' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '21029003' , DescriptionUid = '00000000-0000-0000-0000-000750278017', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '75EE611A-E8C1-4301-8A89-6A5BDAB06722' AND Name = 'HS'     AND (InstructionsType <> 4 OR SnomedConceptID IS NULL OR SnomedConceptID <> '21029003'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000750278017' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '21029003' , DescriptionUid = '00000000-0000-0000-0000-000750278017', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = 'DEEF3976-2658-445C-9293-0AC4F1706E4E' AND Name = 'HS PRN' AND (InstructionsType <> 4 OR SnomedConceptID IS NULL OR SnomedConceptID <> '21029003'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000750278017' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = 'B79BFC09-756B-4EF7-A9EB-6C6C42D8A55B' AND Name = 'Q12H'   AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '17A0AD9F-62AC-427B-8101-2035DC7EF401' AND Name = 'Q2H'    AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '7C80D4ED-1D09-4CDE-B4F2-00E1BB45BD44' AND Name = 'Q4H'    AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '91F2B0EE-61BB-4267-B680-BA3D0C2CDAF3' AND Name = 'Q72H'   AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '307472001', DescriptionUid = '00000000-0000-0000-0000-000704000016', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '35CC9CD0-A27D-4723-9571-595A44835D1E' AND Name = 'QAM'    AND (InstructionsType <> 4 OR SnomedConceptID IS NULL OR SnomedConceptID <> '307472001' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000704000016' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 1, SnomedConceptID = '258703001', DescriptionUid = '00000000-0000-0000-0000-000650151014', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '1BFA015B-558C-4335-B452-9973956B40C4' AND Name = 'QD'     AND (InstructionsType <> 1 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258703001' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650151014' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '7EE92C9B-85BA-417A-9F1D-86EEC202ECB6' AND Name = 'QH'     AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 1, SnomedConceptID = '258703001', DescriptionUid = '00000000-0000-0000-0000-000650151014', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '8A4CB0BA-D1B8-4241-A6E8-15583AAC252F' AND Name = 'QID'    AND (InstructionsType <> 1 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258703001' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650151014' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '307473006', DescriptionUid = '00000000-0000-0000-0000-000704001017', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = 'BF38371C-D1CE-4CE3-8BA2-B4678EA7C26F' AND Name = 'QPM'    AND (InstructionsType <> 4 OR SnomedConceptID IS NULL OR SnomedConceptID <> '307473006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000704001017' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 2, SnomedConceptID = '258705008', DescriptionUid = '00000000-0000-0000-0000-000650153012', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = 'A57BA49D-8BF2-419A-9815-07B4CAA58D1D' AND Name = 'QW'     AND (InstructionsType <> 2 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258705008' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650153012' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 1, SnomedConceptID = '258703001', DescriptionUid = '00000000-0000-0000-0000-000650151014', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '4CABC388-F13C-4382-97E0-5339308BB957' AND Name = 'TID'    AND (InstructionsType <> 1 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258703001' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650151014' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 1, SnomedConceptID = '258705008', DescriptionUid = '00000000-0000-0000-0000-000650153012', RangeMinValue = NULL, RangeMaxValue = NULL WHERE MedicationFrequencyUid = '48C42B93-2645-4C5A-989D-01175A05CB7F' AND Name = 'TIW'    AND (InstructionsType <> 1 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258705008' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650153012' OR RangeMinValue IS NOT NULL OR RangeMaxValue IS NOT NULL)
UPDATE ListMedicationFrequency SET InstructionsType = 3, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = 3   , RangeMaxValue = 4    WHERE MedicationFrequencyUid = '9267ABF8-674C-428C-8F76-444252D21D58' AND Name = 'Q3-4H'  AND (InstructionsType <> 3 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NULL OR RangeMinValue <> 3 OR RangeMaxValue IS NULL OR RangeMaxValue <> 4)
UPDATE ListMedicationFrequency SET InstructionsType = 3, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = 4   , RangeMaxValue = 6    WHERE MedicationFrequencyUid = '363F63D1-2463-40E2-9382-9E4A9A1704AE' AND Name = 'Q4-6H'  AND (InstructionsType <> 3 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NULL OR RangeMinValue <> 4 OR RangeMaxValue IS NULL OR RangeMaxValue <> 6)
UPDATE ListMedicationFrequency SET InstructionsType = 3, SnomedConceptID = '258702006', DescriptionUid = '00000000-0000-0000-0000-000650150010', RangeMinValue = 6   , RangeMaxValue = 8    WHERE MedicationFrequencyUid = '660D323A-3609-4B7D-AEE5-D5EE9E62FA01' AND Name = 'Q6-8H'  AND (InstructionsType <> 3 OR SnomedConceptID IS NULL OR SnomedConceptID <> '258702006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000650150010' OR RangeMinValue IS NULL OR RangeMinValue <> 6 OR RangeMaxValue IS NULL OR RangeMaxValue <> 8)

UPDATE ListMedicationPRNReason SET SnomedConceptID = '48694002' , DescriptionUid = '00000000-0000-0000-0000-000786290018' WHERE MedicationPRNReasonUid = '03447F0A-FF0F-4E98-95F3-B2918CA68309' AND Name = 'for anxiety'        AND (SnomedConceptID IS NULL OR SnomedConceptID <> '48694002'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000786290018')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '161891005', DescriptionUid = '00000000-0000-0000-0000-002646370015' WHERE MedicationPRNReasonUid = '15B12136-6828-4B02-BC4C-453794D10F47' AND Name = 'for back pain'      AND (SnomedConceptID IS NULL OR SnomedConceptID <> '161891005' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002646370015')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '392570002', DescriptionUid = '00000000-0000-0000-0000-001466751013' WHERE MedicationPRNReasonUid = '207189A4-EBAC-44BB-9A13-10E36DC02C3B' AND Name = 'for blood pressure' AND (SnomedConceptID IS NULL OR SnomedConceptID <> '392570002' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-001466751013')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '14760008' , DescriptionUid = '00000000-0000-0000-0000-003654293015' WHERE MedicationPRNReasonUid = '3DB307A1-661A-44CD-ADD4-3DC7CC765605' AND Name = 'for constipation'   AND (SnomedConceptID IS NULL OR SnomedConceptID <> '14760008'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-003654293015')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '62315008' , DescriptionUid = '00000000-0000-0000-0000-000801474016' WHERE MedicationPRNReasonUid = 'A75FD18F-B3BA-4125-8D4A-1AE43ABC29CB' AND Name = 'for diarrhea'       AND (SnomedConceptID IS NULL OR SnomedConceptID <> '62315008'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000801474016')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '386661006', DescriptionUid = '00000000-0000-0000-0000-001460840012' WHERE MedicationPRNReasonUid = '67EC11ED-E291-438D-AB33-301F0CBBC3D0' AND Name = 'for fever'          AND (SnomedConceptID IS NULL OR SnomedConceptID <> '386661006' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-001460840012')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '25064002' , DescriptionUid = '00000000-0000-0000-0000-000755191011' WHERE MedicationPRNReasonUid = '7EED7E8C-FA6A-4241-B086-CE2EF52D2D39' AND Name = 'for headache'       AND (SnomedConceptID IS NULL OR SnomedConceptID <> '25064002'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000755191011')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '16331000' , DescriptionUid = '00000000-0000-0000-0000-000743336017' WHERE MedicationPRNReasonUid = 'C0B3EEA8-9FA9-46B5-B7E9-B018270910FA' AND Name = 'for heartburn'      AND (SnomedConceptID IS NULL OR SnomedConceptID <> '16331000'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000743336017')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '422587007', DescriptionUid = '00000000-0000-0000-0000-002639898010' WHERE MedicationPRNReasonUid = '8330FC19-D4DA-4A29-9768-802133903A9E' AND Name = 'for nausea'         AND (SnomedConceptID IS NULL OR SnomedConceptID <> '422587007' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002639898010')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '22253000' , DescriptionUid = '00000000-0000-0000-0000-000751640015' WHERE MedicationPRNReasonUid = 'C5E7E48B-04AE-48B4-B3F9-2FE9ECACBCD3' AND Name = 'for pain'           AND (SnomedConceptID IS NULL OR SnomedConceptID <> '22253000'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000751640015')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '65124004' , DescriptionUid = '00000000-0000-0000-0000-000804593018' WHERE MedicationPRNReasonUid = '15141F82-81EA-42BC-98CD-273197C59B83' AND Name = 'for swelling'       AND (SnomedConceptID IS NULL OR SnomedConceptID <> '65124004'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000804593018')
UPDATE ListMedicationPRNReason SET SnomedConceptID = '415709002', DescriptionUid = '00000000-0000-0000-0000-002572942017' WHERE MedicationPRNReasonUid = 'AE77B217-BFA6-48E3-BBAD-7EA1C21B36B5' AND Name = 'n/v'                AND (SnomedConceptID IS NULL OR SnomedConceptID <> '415709002' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002572942017')

UPDATE ListMedicationRoute SET SnomedConceptID = '54471007' , DescriptionUid = '00000000-0000-0000-0000-000792706016' WHERE MedicationRouteUid = 'FF25D572-B152-46BD-96B0-E2B31123E55C' AND Name = 'BUCC'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '54471007'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000792706016')
UPDATE ListMedicationRoute SET SnomedConceptID = '372449004', DescriptionUid = '00000000-0000-0000-0000-002153499019' WHERE MedicationRouteUid = 'DFFB1194-45D7-4355-A7D4-80A92D87FC41' AND Name = 'Dent'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '372449004' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002153499019')
UPDATE ListMedicationRoute SET SnomedConceptID = '404820008', DescriptionUid = '00000000-0000-0000-0000-002148650016' WHERE MedicationRouteUid = '6B46F8AC-B542-49E0-8669-86867EBE83E1' AND Name = 'Epid'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '404820008' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002148650016')
UPDATE ListMedicationRoute SET SnomedConceptID = '58100008' , DescriptionUid = '00000000-0000-0000-0000-000796794011' WHERE MedicationRouteUid = '76E48433-25F2-4517-A542-A3C0B73B457B' AND Name = 'IArt'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '58100008'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000796794011')
UPDATE ListMedicationRoute SET SnomedConceptID = '12130007' , DescriptionUid = '00000000-0000-0000-0000-000720047013' WHERE MedicationRouteUid = 'F68A6EE9-A16F-4CFA-9650-218E3D2CD5E5' AND Name = 'IAtc'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '12130007'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000720047013')
UPDATE ListMedicationRoute SET SnomedConceptID = '372464004', DescriptionUid = '00000000-0000-0000-0000-002153512010' WHERE MedicationRouteUid = '992A4EEB-A7F9-47BE-AB31-0D30C5F98127' AND Name = 'IDrm'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '372464004' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002153512010')
UPDATE ListMedicationRoute SET SnomedConceptID = '78421000' , DescriptionUid = '00000000-0000-0000-0000-000819360016' WHERE MedicationRouteUid = 'CB1157EF-EA3F-440F-A317-4FE70F434E51' AND Name = 'IM'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '78421000'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000819360016')
UPDATE ListMedicationRoute SET SnomedConceptID = '372469009', DescriptionUid = '00000000-0000-0000-0000-002153517016' WHERE MedicationRouteUid = '0159394A-D9F9-43F5-9089-3BD812C64770' AND Name = 'InPl'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '372469009' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002153517016')
UPDATE ListMedicationRoute SET SnomedConceptID = '404818005', DescriptionUid = '00000000-0000-0000-0000-002148648012' WHERE MedicationRouteUid = 'FE62DD1C-9607-4B89-834F-CD345286E4F5' AND Name = 'InTr'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '404818005' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002148648012')
UPDATE ListMedicationRoute SET SnomedConceptID = '372468001', DescriptionUid = '00000000-0000-0000-0000-002153516013' WHERE MedicationRouteUid = '3438D240-A6EB-47BE-B7CD-344B892BE863' AND Name = 'IO'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '372468001' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002153516013')
UPDATE ListMedicationRoute SET SnomedConceptID = '38239002' , DescriptionUid = '00000000-0000-0000-0000-000772389016' WHERE MedicationRouteUid = 'B8DB596A-7EF4-463A-A596-1CFD6ED4F084' AND Name = 'IP'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '38239002'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000772389016')
UPDATE ListMedicationRoute SET SnomedConceptID = '72607000' , DescriptionUid = '00000000-0000-0000-0000-000812903011' WHERE MedicationRouteUid = '8B43B162-4C62-4A1B-B4D7-D1ECF8863402' AND Name = 'IT'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '72607000'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000812903011')
UPDATE ListMedicationRoute SET SnomedConceptID = '62226000' , DescriptionUid = '00000000-0000-0000-0000-000801375019' WHERE MedicationRouteUid = '3000D8D4-2AC0-494D-B882-B9C4B2C38BD3' AND Name = 'IU'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '62226000'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000801375019')
UPDATE ListMedicationRoute SET SnomedConceptID = '47625008' , DescriptionUid = '00000000-0000-0000-0000-000785104019' WHERE MedicationRouteUid = '5743DBE5-9CB2-4966-A8AC-E649A072C710' AND Name = 'IV'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '47625008'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000785104019')
UPDATE ListMedicationRoute SET SnomedConceptID = '372471009', DescriptionUid = '00000000-0000-0000-0000-002153519018' WHERE MedicationRouteUid = '26CFBF45-0120-4827-9786-93E665CA241B' AND Name = 'IVes'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '372471009' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002153519018')
UPDATE ListMedicationRoute SET SnomedConceptID = '46713006' , DescriptionUid = '00000000-0000-0000-0000-000784093013' WHERE MedicationRouteUid = '1EC2204E-CC57-498D-8D03-129562B4B065' AND Name = 'NASAL' AND (SnomedConceptID IS NULL OR SnomedConceptID <> '46713006'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000784093013')
UPDATE ListMedicationRoute SET SnomedConceptID = '54485002' , DescriptionUid = '00000000-0000-0000-0000-000792721010' WHERE MedicationRouteUid = '457B51D4-A30A-4901-A158-16FABBF55D7F' AND Name = 'OPH'   AND (SnomedConceptID IS NULL OR SnomedConceptID <> '54485002'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000792721010')
UPDATE ListMedicationRoute SET SnomedConceptID = '10547007' , DescriptionUid = '00000000-0000-0000-0000-000572319011' WHERE MedicationRouteUid = 'BF34DCA1-3042-4A80-83B1-5DEE1F4CA7E1' AND Name = 'OTIC'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '10547007'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000572319011')
UPDATE ListMedicationRoute SET SnomedConceptID = '428191002', DescriptionUid = '00000000-0000-0000-0000-002691095014' WHERE MedicationRouteUid = '219687A0-529C-4598-85BA-0E178FA36149' AND Name = 'PCut'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '428191002' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002691095014')
UPDATE ListMedicationRoute SET SnomedConceptID = '447052000', DescriptionUid = '00000000-0000-0000-0000-002880883015' WHERE MedicationRouteUid = '4C586AD7-1C74-4325-A02D-7C75F5304BBE' AND Name = 'Pdnt'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '447052000' OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002880883015')
UPDATE ListMedicationRoute SET SnomedConceptID = '26643006' , DescriptionUid = '00000000-0000-0000-0000-000757099014' WHERE MedicationRouteUid = '13929DE8-2CE7-47DD-97A0-493BCC503316' AND Name = 'PO'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '26643006'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000757099014')
UPDATE ListMedicationRoute SET SnomedConceptID = '37161004' , DescriptionUid = '00000000-0000-0000-0000-002897281011' WHERE MedicationRouteUid = '0831BAE1-083D-4C93-8BFD-509D97FAEF22' AND Name = 'RTL'   AND (SnomedConceptID IS NULL OR SnomedConceptID <> '37161004'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002897281011')
UPDATE ListMedicationRoute SET SnomedConceptID = '37839007' , DescriptionUid = '00000000-0000-0000-0000-000769781016' WHERE MedicationRouteUid = '81D19653-E9B9-4266-8620-6018AA011EA5' AND Name = 'SL'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '37839007'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000769781016')
UPDATE ListMedicationRoute SET SnomedConceptID = '34206005' , DescriptionUid = '00000000-0000-0000-0000-000765702016' WHERE MedicationRouteUid = 'CB82D413-474F-4641-B53C-B06753DFF6BA' AND Name = 'SQ'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '34206005'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000765702016')
UPDATE ListMedicationRoute SET SnomedConceptID = '45890007' , DescriptionUid = '00000000-0000-0000-0000-000783178017' WHERE MedicationRouteUid = '05313EA4-504B-4C6B-9E9F-5A090343F393' AND Name = 'TD'    AND (SnomedConceptID IS NULL OR SnomedConceptID <> '45890007'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000783178017')
UPDATE ListMedicationRoute SET SnomedConceptID = '6064005'  , DescriptionUid = '00000000-0000-0000-0000-000799615015' WHERE MedicationRouteUid = '2CA0BF87-73C4-46CB-8F6E-AE43EBE51DA7' AND Name = 'TOP'   AND (SnomedConceptID IS NULL OR SnomedConceptID <> '6064005'   OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000799615015')
UPDATE ListMedicationRoute SET SnomedConceptID = '90028008' , DescriptionUid = '00000000-0000-0000-0000-000833046011' WHERE MedicationRouteUid = '75DF44CC-4AE0-4143-97DA-F1A9147EC619' AND Name = 'Urth'  AND (SnomedConceptID IS NULL OR SnomedConceptID <> '90028008'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-000833046011')
UPDATE ListMedicationRoute SET SnomedConceptID = '16857009' , DescriptionUid = '00000000-0000-0000-0000-002898183019' WHERE MedicationRouteUid = '72E00E64-6CB2-45DA-93E5-578F3DE3A330' AND Name = 'VAG'   AND (SnomedConceptID IS NULL OR SnomedConceptID <> '16857009'  OR DescriptionUid IS NULL OR DescriptionUid <> '00000000-0000-0000-0000-002898183019')
GO
-- #89891 end

-- #91323 _TransmissionConfiguration_eRxAuditSearch.sql
UPDATE TransmissionConfiguration
SET
   AprimaVaultURL = 'https://sm4.aprima.com',
   AprimaVaultSubmissionURL = 'https://integration4.aprima.com/eRXAudit',
   TestAprimaVaultURL = 'https://cpdev03:34100',
   TestAprimaVaultSubmissionURL = 'https://cpdev03:40015/communityexchange/partner/PartnerService'
WHERE TransmissionType = 'eRxAuditSearch'
  AND ISNULL(AprimaVaultURL, '') != 'https://sm4.aprima.com'
GO

-- #93632 _CDC_Vaccine_Code_Set_February_14_2022 Migration Script
--CDC Vaccine Code Set Update Publication Date: February 14, 2022
--Change PREHVBRIO CVX Code Short & Long Descriptions
Update ListCVXCode Set CVXShortDesc = 'HepB recombinant, 3-antigen, Al(OH)3',
CVXFullVaccineName='Hepatitis B vaccine (recombinant), 3-antigen, Al(OH)3 adjuvanted' 
Where CVXCodeUid='B6681CDD-048C-47C4-925D-802DD13ACBD2'

--Update the UseUnitGenericName column in VaccineUnitUse for PREHEVBRIO
Update VaccineUnitUse Set UseUnitGenericName='Hepatitis B vaccine (recombinant), 3-antigen, Al(OH)3 adjuvanted'
Where VaccineUnitUseUid = 'BCD5FD50-16EB-4542-BDF6-EA868FAE4AE0'

--Set CVX Code 35 to Inactive
Update ListCVXCode Set Inactive=1 Where CVXCodeUid = '325025A6-2613-4898-AE1B-E2A88EC75A6C'
 
--Update ListCVXCode 207
Update ListCVXCode Set CVXShortDesc='COVID-19, mRNA, LNP-S, PF, 100 mcg or 50 mcg dose', CVXFullVaccineName='SARS-COV-2 (COVID-19) vaccine, mRNA, spike protein, LNP, preservative free, 100 mcg or 50 mcg dose' WHERE CVXCodeUid='F000C05F-836E-43F8-9D26-8A9E150C7E33'
GO

-- #57190 _ListDisease_Pancratic_cancer.sql
UPDATE ListDisease  SET Name    = 'Pancreatic cancer' WHERE DiseaseUid     = 'A2AA5F99-88B8-446E-BC04-5F0278E2E74C' AND Name    = 'Pancratic cancer'
UPDATE ListAnswer   SET Name    = 'Pancreatic cancer' WHERE AnswerUid      = 'F506FD04-0DB9-4CFE-9261-110260751D70' AND Name    = 'Pancratic cancer'
UPDATE ListQuestion SET Name    = 'Pancreatic cancer' WHERE QuestionUid    = '1B27583E-E0B2-4D36-BEB4-4F22D8102839' AND Name    = 'Pancratic cancer'
UPDATE Translation  SET Name    = 'Pancreatic cancer' WHERE TranslationUid = 'D0DBA5C3-4AB6-E511-9C1B-4439C4196CC3' AND Name    = 'Pancratic cancer'
UPDATE Translation  SET Name    = 'Pancreatic cancer' WHERE TranslationUid = '57E2A5C3-4AB6-E511-9C1B-4439C4196CC3' AND Name    = 'Pancratic cancer'
UPDATE Translation  SET Name    = 'Pancreatic cancer' WHERE TranslationUid = '7136D8C4-4AB6-E511-9C1B-4439C4196CC3' AND Name    = 'Pancratic cancer'
UPDATE Translation  SET Spanish = 'Cáncer Pancreatic' WHERE TranslationUid = 'D0DBA5C3-4AB6-E511-9C1B-4439C4196CC3' AND Spanish = 'Cáncer Pancratic'
UPDATE Translation  SET Spanish = 'Cáncer Pancreatic' WHERE TranslationUid = '57E2A5C3-4AB6-E511-9C1B-4439C4196CC3' AND Spanish = 'Cáncer Pancratic'
UPDATE Translation  SET Spanish = 'Cáncer Pancreatic' WHERE TranslationUid = '7136D8C4-4AB6-E511-9C1B-4439C4196CC3' AND Spanish = 'Cáncer Pancratic'
GO

-- #88261 Update_Oxford_Health_Eligibility_Payers.sql
-- updated 3/28/2022
IF NOT EXISTS (Select 1/0 from ListElectronicPayer where ElectronicPayerUid = 'BAD8D980-2A45-4565-9FB7-62C6582B9A91' AND  ClearingHousePayerID = '06111' AND EligibilityID = '06111' and name = 'Oxford Health Plans')
  update ListElectronicPayer set ClearingHousePayerID = '06111', EligibilityID = '06111', name = 'Oxford Health Plans' where ElectronicPayerUid = 'BAD8D980-2A45-4565-9FB7-62C6582B9A91'
IF NOT EXISTS (Select 1/0 from ListElectronicPayer where ElectronicPayerUid = '2DC6F455-71E7-4088-907A-EE4244F38E5A' AND  ClearingHousePayerID = 'OXDLF' AND EligibilityID = 'OXDLF' and name = 'Oxford Life Insurance Company')
  update ListElectronicPayer set ClearingHousePayerID = 'OXDLF', EligibilityID = 'OXDLF', name = 'Oxford Life Insurance Company' where ElectronicPayerUid = '2DC6F455-71E7-4088-907A-EE4244F38E5A'
GO  

-- #57151 _ListAnswer_pruritus.sql
UPDATE ListAnswer  SET Name     = 'pruritus'                    WHERE AnswerUid      = '00000000-0000-0000-0000-000000108010' AND Name     = 'pruritis'
UPDATE Translation SET Name	    = 'pruritus'                    WHERE TranslationUid = '18DCA5C3-4AB6-E511-9C1B-4439C4196CC3' AND Name     = 'pruritis'
UPDATE ListEduForm SET Name     = 'Itching (Pruritus)_SP'       WHERE EduFormUid     = '0E23FD0F-01EF-497C-AF0D-23F914D6B9B6' AND Name     = 'Itching (Pruritis)_SP'
UPDATE ListEduForm SET Name     = 'Itching (Pruritus)'          WHERE EduFormUid     = '4F8F0897-65D8-4FF1-86B7-A367BBC0E0BD' AND Name     = 'Itching (Pruritis)'
UPDATE ListEduForm SET VendorID = 'PE_ITCHING_(PRURITUS)'       WHERE EduFormUid     = '0E23FD0F-01EF-497C-AF0D-23F914D6B9B6' AND VendorID = 'PE_ITCHING_(PRURITIS)'
UPDATE ListEduForm SET VendorID = 'PE_ITCHING_(PRURITUS)'       WHERE EduFormUid     = '4F8F0897-65D8-4FF1-86B7-A367BBC0E0BD' AND VendorID = 'PE_ITCHING_(PRURITIS)'
UPDATE Attachment  SET FileName = 'Itching (Pruritus).pdf'      WHERE AttachmentUid = '237E9C2F-E231-494E-9E1C-A618D57E7FA9'  AND FileName = 'Itching (Pruritis).pdf'
UPDATE Attachment  SET Name     = 'Itching (Pruritus)'          WHERE AttachmentUid = '237E9C2F-E231-494E-9E1C-A618D57E7FA9'  AND Name     = 'Itching (Pruritis)'
UPDATE Attachment  SET FileName = 'Itching (Pruritus) (ES).pdf' WHERE AttachmentUid = '76E67614-9693-407A-8AA7-AA4682A5BE9F'  AND FileName = 'Itching (Pruritis) (ES).pdf'
UPDATE Attachment  SET Name     = 'Itching (Pruritus)_SP'       WHERE AttachmentUid = '76E67614-9693-407A-8AA7-AA4682A5BE9F'  AND Name     = 'Itching (Pruritis)_SP'
UPDATE ListEduForm SET DocumentMetadata = REPLACE(CONVERT(VARCHAR(MAX), DocumentMetadata), '<Code>PE_ITCHING_(PRURITIS)_ES</Code>'   , '<Code>PE_ITCHING_(PRURITUS)_ES</Code>'   ) WHERE EduFormUid = '0E23FD0F-01EF-497C-AF0D-23F914D6B9B6' AND CHARINDEX('<Code>PE_ITCHING_(PRURITIS)_ES</Code>'   , CONVERT(VARCHAR(MAX), DocumentMetadata)) > 0
UPDATE ListEduForm SET DocumentMetadata = REPLACE(CONVERT(VARCHAR(MAX), DocumentMetadata), '<Name>Itching (Pruritis) (ES).pdf</Name>', '<Name>Itching (Pruritus) (ES).pdf</Name>') WHERE EduFormUid = '0E23FD0F-01EF-497C-AF0D-23F914D6B9B6' AND CHARINDEX('<Name>Itching (Pruritis) (ES).pdf</Name>', CONVERT(VARCHAR(MAX), DocumentMetadata)) > 0
UPDATE ListEduForm SET DocumentMetadata = REPLACE(CONVERT(VARCHAR(MAX), DocumentMetadata), '<Title>Itching (Pruritis)_SP</Title>'    , '<Title>Itching (Pruritus)_SP</Title>'    ) WHERE EduFormUid = '0E23FD0F-01EF-497C-AF0D-23F914D6B9B6' AND CHARINDEX('<Title>Itching (Pruritis)_SP</Title>'    , CONVERT(VARCHAR(MAX), DocumentMetadata)) > 0
UPDATE ListEduForm SET DocumentMetadata = REPLACE(CONVERT(VARCHAR(MAX), DocumentMetadata), '<Code>PE_ITCHING_(PRURITIS)</Code>'      , '<Code>PE_ITCHING_(PRURITUS)</Code>'      ) WHERE EduFormUid = '4F8F0897-65D8-4FF1-86B7-A367BBC0E0BD' AND CHARINDEX('<Code>PE_ITCHING_(PRURITIS)</Code>'      , CONVERT(VARCHAR(MAX), DocumentMetadata)) > 0
UPDATE ListEduForm SET DocumentMetadata = REPLACE(CONVERT(VARCHAR(MAX), DocumentMetadata), '<Name>Itching (Pruritis).pdf</Name>'     , '<Name>Itching (Pruritus).pdf</Name>'     ) WHERE EduFormUid = '4F8F0897-65D8-4FF1-86B7-A367BBC0E0BD' AND CHARINDEX('<Name>Itching (Pruritis).pdf</Name>'     , CONVERT(VARCHAR(MAX), DocumentMetadata)) > 0
UPDATE ListEduForm SET DocumentMetadata = REPLACE(CONVERT(VARCHAR(MAX), DocumentMetadata), '<Title>Itching (Pruritis)</Title>'       , '<Title>Itching (Pruritus)</Title>'       ) WHERE EduFormUid = '4F8F0897-65D8-4FF1-86B7-A367BBC0E0BD' AND CHARINDEX('<Title>Itching (Pruritis)</Title>'       , CONVERT(VARCHAR(MAX), DocumentMetadata)) > 0
GO

-- #82078 _MigrationScript.sql
update ListFindControlBehavior
set ColumnsConfig = '{
   "PrimaryKey":"FilterUid",
   "PrimaryDisplayName":"Name",
   "Columns":[
      {
         "ColumnName":"Name",
         "ColumnDisplayName":"Name",
         "Visible":"true",
         "CanFilter":"true",
         "CanSelect":"true",
         "Type":"string",
         "Width":"125",
		 "SortOrder": "1"
      },
	  {
         "ColumnName":"UserPRMUid",
         "ColumnDisplayName":"UserPRMUid",
         "Visible":"false",
         "CanFilter":"true",
         "CanSelect":"true",
         "Type":"string",
         "Width":"125"
      },
	  {
         "ColumnName":"ExternalID",
         "ColumnDisplayName":"ExternalID",
         "Visible":"false",
         "CanFilter":"true",
         "CanSelect":"true",
         "Type":"string",
         "Width":"125"
      },
	  {
         "ColumnName":"Type",
         "ColumnDisplayName":"Type",
         "Visible":"false",
         "CanFilter":"true",
         "CanSelect":"true",
         "Type":"string",
         "Width":"125"
      }
   ]
}',
Name = 'Message Center Filters',
SearchColumns = '[ "Name", "ExternalID" ]',
MaxRows = 100,
ServiceAQN = 'iMedica.FrameworkBO.FindControl.FindControlFilterByMultipleValuesService'
where FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'
GO

-- #97718 Migration
--Reactivate Novavax
UPDATE VaccineUnitUse SET Inactive='0'
WHERE VaccineUnitUseUid='44D4B5B9-81F5-4D96-8BEA-E93C1BA5396F'
GO

-- #97499 _AddSNOMEDCodesToBMIProcs.sql
DECLARE @ConceptID BIGINT
		,@DescriptionUid UNIQUEIDENTIFIER

SELECT TOP 1 @ConceptID = conceptId
				,@DescriptionUid = DescriptionUid
FROM MasterSnomedDescription m
WHERE conceptId = '443288003'
ORDER BY m.category DESC

IF EXISTS (SELECT 1 FROM ListProcedure WHERE Code IN ('G8417','G8418') AND (SnomedConceptID IS NULL OR SnomedConceptID2 IS NULL) AND (DescriptionUid IS NULL OR DescriptionUid2 IS NULL))
BEGIN
	UPDATE ListProcedure
	SET SnomedConceptID = CASE WHEN SnomedConceptID IS NULL THEN @ConceptID ELSE SnomedConceptID END
		,DescriptionUid = CASE WHEN DescriptionUid IS NULL THEN @DescriptionUid ELSE DescriptionUid END
		,SnomedConceptID2 = CASE WHEN COALESCE(SnomedConceptID,'') NOT IN (@ConceptID,'') AND SnomedConceptID2 IS NULL THEN @ConceptID ELSE SnomedConceptID2 END
		,DescriptionUid2 = CASE WHEN COALESCE(CONVERT(VARCHAR(50), DescriptionUid),'') NOT IN (@DescriptionUid,'') AND DescriptionUid2 IS NULL THEN @DescriptionUid ELSE DescriptionUid2 END
	FROM ListProcedure lp
	WHERE Code IN ('G8417','G8418') AND (SnomedConceptID IS NULL OR SnomedConceptID2 IS NULL) AND (DescriptionUid IS NULL OR DescriptionUid2 IS NULL)
END
GO

-- #91096 _MigrationScript.sql
update ListFindControlBehavior
set ColumnsConfig = '{
  "PrimaryKey": "GroupUIConfigurationUid",
  "PrimaryDisplayName": "Name",
  "Columns": [
    {
      "ColumnName": "Name",
      "ColumnDisplayName": "Name",
      "Visible": "true",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125",
      "SortOrder": "1"
    },
    {
        "ColumnName": "ExternalID",
        "ColumnDisplayName": "ExternalID",
        "Visible": "false",
        "CanFilter": "true",
        "CanSelect": "true",
        "Type": "string",
        "Width": "125"
    },
    {
        "ColumnName": "RestrictedToPersonUid",
        "ColumnDisplayName": "RestrictedToPersonUid",
        "Visible": "false",
        "CanFilter": "true",
        "CanSelect": "true",
        "Type": "string",
        "Width": "125"
    }
  ]
}
',
SearchColumns = '[ "Name", "ExternalID" ]',
MaxRows = 100,
ServiceAQN = 'iMedica.FrameworkBO.FindControl.FindControlFilterByMultipleValuesService',
RequiredSearchParameters = '{"RequiredSearchParameters":[{"ColumnName":"DataTypeId","Value": ""}]}'
where FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
GO

-- #99715 ListUiConfiguration_Update_Homepage_Default.sql
-- removed and replaced by #94313 94313_Combined_Update_Predefined_Default_Config.sql
 
-- #100132 
-- migration for story task 100592
update ListClinicalNoteType set LOINCUid = 'EB1F339C-166D-4AA3-BB89-2D484474C468' 
where ClinicalNoteTypeUid = '10101010-1111-0000-0000-000000000001'
GO

-- #101519 EDDLPP_Update.sql
update ListProductParameter Set Inactive = 0, BoolValue=0, XMLValue = 
'<EventDrivenDataFeatures>
  <Feature Name="Appointment" Inactive="false" />
  <Feature Name="Message" Inactive="false" />
  <Feature Name="HospitalRound" Inactive="false" />
  <Feature Name="Visit" Inactive="false" />
</EventDrivenDataFeatures>'
where ProductParameterUid = 'D770105F-2BEA-4220-8FBF-16ED3AACB1AE'
GO

-- #99999 99999_UpdateSearch_migration.sql
update ListFindControlBehavior set EndingWildcard=1, BeginningWildcard=1 where FindControlBehaviorUid='F1DC66BF-E920-4991-A6DB-0DE718364C78'
update ListFindControlBehavior set EndingWildcard=1, BeginningWildcard=1 where FindControlBehaviorUid='A8BC4FCC-9E9B-4CA9-9DB3-5D59A791BC9D'
update ListFindControlBehavior set EndingWildcard=1, BeginningWildcard=1 where FindControlBehaviorUid='13C9DED1-D67F-4C08-9552-BB6406EADB72'
update ListFindControlBehavior set EndingWildcard=1, BeginningWildcard=1 where FindControlBehaviorUid='796301BB-99E7-4BC1-9CAB-40E71EFC4F3C'

update  [dbo].[ListFindControlBehavior] set ColumnsConfig='
{
"PrimaryKey" : "RoomUid",
"PrimaryDisplayName": "Name",
"InactiveColumnName": "Inactive",
  "Columns": [
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ID",
      "Visible": "true",
         "CanFilter": "true",
         "CanSelect": "true",
         "Type": "string",
      "Width": "50"
    }, 
       {
      "ColumnName": "Name",
      "ColumnDisplayName": "Name",
      "Visible": "true",
         "CanFilter": "true",
         "CanSelect": "true",
         "Type": "string",
		 "Width": "50",
         "SortOrder": "1"
    },
       {
      "ColumnName": "ServiceSiteName",
      "ColumnDisplayName": "Service Site",
      "Visible": "true",
	  "CanFilter": "true",
	  "CanSelect": "true",
	  "Type": "string",
      "Width": "200"
    },
       {
      "ColumnName": "RoomTypeName",
      "ColumnDisplayName": "Room Type",
      "Visible": "true",
	  "CanFilter": "true",
	  "CanSelect": "true",
	  "Type": "string",
      "Width": "150"
    },
    {
        "ColumnName": "Notes",
        "ColumnDisplayName": "Notes",
        "Visible": "true",
        "CanFilter": "true",
        "Type": "string",
        "Width": "200"
    },
    {
      "ColumnName": "Inactive",
      "ColumnDisplayName": "Inactive",
      "Visible": "false",
         "CanFilter": "true",
         "Type": "bool"
    }
  ]
}'
where FindControlBehaviorUid='796301BB-99E7-4BC1-9CAB-40E71EFC4F3C'
update  [dbo].[ListFindControlBehavior] set SearchColumns='
[ "ExternalID", "Name",  "ServiceSiteName", "RoomTypeName", "Notes"]'
where FindControlBehaviorUid='796301BB-99E7-4BC1-9CAB-40E71EFC4F3C'
GO

-- #99355
/*
  Bug Number  : 99355
  Date        : 2022.May.05
*/
update ListFindControlBehavior set 

  BeginningWildcard = 1, 
  EndingWildcard = 1, 
  SearchColumns = '[ "ExternalID", "Name", "Notes" ]',
  ColumnsConfig = '{"PrimaryKey":"FilterUid","PrimaryDisplayName":"Name",
                    "Columns":[{"ColumnName":"ExternalID","ColumnDisplayName":"ID","Visible":"true","CanFilter":"true","CanSelect":"true","Type":"string","Width":"50"},
					           {"ColumnName":"Name","ColumnDisplayName":"Name","Visible":"true","CanFilter":"true","CanSelect":"true","Type":"string","Width":"125"},
							   {"ColumnName":"Notes","ColumnDisplayName":"Notes","Visible":"true","CanFilter":"true","Type":"string","Width":"250"},
							   {"ColumnName":"UserPRMUid","ColumnDisplayName":"UserPRMUid","Visible":"false","CanFilter":"true","CanSelect":"true","Type":"string","Width":"125"},
							   {"ColumnName":"ExternalID","ColumnDisplayName":"ExternalID","Visible":"false","CanFilter":"true","CanSelect":"true","Type":"string","Width":"125"},
							   {"ColumnName":"Type","ColumnDisplayName":"Type","Visible":"false","CanFilter":"true","CanSelect":"true","Type":"string","Width":"125"}]}'

where FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'  -- Message Center Filters (ListFilter)
GO

-- #100000 _ListFindControlBehavior_MinSearchCharsAndBeginWildChar_Update.sql
update ListFindControlBehavior
set MinimumSearchCharacters = 1, BeginningWildcard = 1
where FindControlBehaviorUid = '54090197-3FCC-49CD-99FB-E76423B32F5C'
GO

--
-- #100001 migration
UPDATE ListFindControlBehavior
	SET BeginningWildcard = 1
	WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0' -- ListGroupUIConfiguration
GO	

-- #99455 ListUiConfiguration_UpdateHomepageDefault.sql
-- removed and replaced by #94313 94313_Combined_Update_Predefined_Default_Config.sql

-- #101811 _MigrationScript.sql
update ListFindControlBehavior
set ColumnsConfig = '{
  "PrimaryKey": "FilterUid",
  "PrimaryDisplayName": "Name",
  "Columns": [
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ID",
      "Visible": "true",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "50"
    },
    {
      "ColumnName": "Name",
      "ColumnDisplayName": "Name",
      "Visible": "true",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125",
      "SortOrder": 0
    },
    {
      "ColumnName": "Notes",
      "ColumnDisplayName": "Notes",
      "Visible": "true",
      "CanFilter": "true",
      "Type": "string",
      "Width": "250"
    },
    {
      "ColumnName": "UserPRMUid",
      "ColumnDisplayName": "UserPRMUid",
      "Visible": "false",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125"
    },
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ExternalID",
      "Visible": "false",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125"
    },
    {
      "ColumnName": "Type",
      "ColumnDisplayName": "Type",
      "Visible": "false",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125"
    }
  ]
}
'
where FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'
GO

-- #101814 _Update_Calendar_ListFindControlBehavior.sql
update  [dbo].[ListFindControlBehavior] set ColumnsConfig='
{
	"PrimaryKey": "CalendarUid",
	"PrimaryDisplayName": "Name",
	"InactiveColumnName": "Inactive",
	"Columns": [
		{
			"ColumnName": "CalendarUid",
			"ColumnDisplayName": "CalendarUid",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": true,
			"Type": null,
			"Width": 0,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
		{
			"ColumnName": "ExternalID",
			"ColumnDisplayName": "ID",
			"Visible": true,
			"CanFilter": true,
			"CanSelect": true,
			"Type": "string",
			"Width": 50,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
		{
			"ColumnName": "Name",
			"ColumnDisplayName": "Name",
			"Visible": true,
			"CanFilter": true,
			"CanSelect": true,
			"Type": "string",
			"Width": 200,
			"SortOrder": 1,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
		{
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": "250"
        },
		{
			"ColumnName": "Inactive",
			"ColumnDisplayName": "Inactive",
			"Visible": false,
			"CanFilter": true,
			"CanSelect": false,
			"Type": "bool",
			"Width": 0,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
		{
			"ColumnName": "DefaultProviderUid",
			"ColumnDisplayName": "DefaultProviderUid",
			"Visible": false,
			"CanFilter": false,
			"CanSelect": true,
			"Type": null,
			"Width": 0,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
		{
			"ColumnName": "DisplayInterval",
			"ColumnDisplayName": "DisplayInterval",
			"Visible": false,
			"CanFilter": true,
			"CanSelect": true,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		},
		{
			"ColumnName": "TimeZone",
			"ColumnDisplayName": "Time Zone",
			"Visible": false,
			"CanFilter": true,
			"CanSelect": true,
			"Type": "string",
			"Width": 70,
			"SortOrder": 0,
			"SortDirection": "Ascending",
			"AdditionalInfoDto": null
		}
	]
}'
where FindControlBehaviorUid='F1DC66BF-E920-4991-A6DB-0DE718364C78'
update  [dbo].[ListFindControlBehavior] set SearchColumns='
["ExternalID" ,"Name", "Notes"]'
where FindControlBehaviorUid='F1DC66BF-E920-4991-A6DB-0DE718364C78'
GO

-- #101815 _Update_AppointmentStatus_ListFindControlBehavior.sql
update  [dbo].[ListFindControlBehavior] set SearchColumns='
["ExternalID" ,"Name", "Notes"]'
where FindControlBehaviorUid='A8BC4FCC-9E9B-4CA9-9DB3-5D59A791BC9D'
GO

-- #91969 _ListFindControlBehavior_SearchCols_MinSearchChars_BegWildCard_ColConfig_Update.sql
update ListFindControlBehavior set
SearchColumns = '[ "ExternalID", "LastName", "FirstName", "Notes" ]',
MinimumSearchCharacters = 1,
BeginningWildcard = 1,
ColumnsConfig = '{  "PrimaryKey" : "PersonUid",  "PrimaryDisplayName": "FormattedInternalName",    "Columns": [      {"ColumnName": "ExternalID","ColumnDisplayName": "ID","Visible": "true","CanFilter":"true","CanSelect":"true","Type":"string","Width":"50"},  {        "ColumnName": "FormattedInternalName",        "ColumnDisplayName": "Name",        "Visible": "true",     "CanFilter": "true",     "CanSelect": "true",     "Type": "string",        "Width": "125",      },    {        "ColumnName": "Notes",        "ColumnDisplayName": "Notes",        "Visible": "true",     "Type": "string",        "Width": "125"      },       {        "ColumnName": "PersonUid",        "Visible": "false"      },      {        "ColumnName": "Inactive",        "ColumnDisplayName": "Inactive",        "Visible": "false",     "CanFilter": "true",     "Type": "bool"      },   {        "ColumnName": "LastName",        "ColumnDisplayName": "Notes",        "Visible": "false",     "SortOrder": "1",      },     ]  }'
where FindControlBehaviorUid = '0883EAF3-C6B3-494A-A368-030289BE32F4'
GO

-- #101240 _CDC_VACCINE_UPDATES_APRIL_14_2022 Migration Script
--Retired NDC: NDC11 '66019-0308-01'
Update VaccineUnitUse Set Inactive = '1' where VaccineUnitUseUid = '821E4349-3C3E-42D5-B2C4-DAA08184EDF2'
GO

-- #102730 102730_Update_ListFIndTable_PatientCareMangement_06032022.sql
update ListFindTable set [Columns]='<FindColumn name="PatientCareManagementUid" index="guid" visible="false" />
<FindColumn name="Selected" caption=" " propertyname="" IsEditable="true" datatype="bool" width="20" />
<FindColumn name="PatientName" hyperlink="true" caption="Patient" visible="true" width="100" />
<FindColumn name="CareType" caption="Care Type" visible="true" width="50" />
<FindColumn name="ProviderNames" caption="Provider" visible="true" width="100" />
<FindColumn name="EffectiveDate" hyperlink="true" caption="Effective Date" datatype="date" visible="true" width="100" />
<FindColumn name="ExpirationDate" caption="Expiration Date" visible="true" width="100" datatype="date" />
<FindColumn name="MSPName" caption="MSP" visible="true" width="100" />
<FindColumn name="Location" caption="Location" visible="true" width="100" />
<FindColumn name="DiagnosisNames" caption="Diagnosis" visible="true" width="100" />
<FindColumn name="Notes" caption="Notes" visible="true" width="100" />' 
where FindTableUid='F5F924ED-49F3-413F-8575-DE494D62AE94'
UPDATE UserPRM SET Settings.modify('delete(//SpreadSheet/ViewPatientCCMCPO)') where Settings IS NOT NULL
GO

-- #101811 _MigrationScript.sql
update ListFindControlBehavior
set ColumnsConfig = '{
  "PrimaryKey": "FilterUid",
  "PrimaryDisplayName": "Name",
  "Columns": [
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ID",
      "Visible": "true",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "50"
    },
    {
      "ColumnName": "Name",
      "ColumnDisplayName": "Name",
      "Visible": "true",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125",
      "SortOrder": 1
    },
    {
      "ColumnName": "Notes",
      "ColumnDisplayName": "Notes",
      "Visible": "true",
      "CanFilter": "true",
      "Type": "string",
      "Width": "250"
    },
    {
      "ColumnName": "UserPRMUid",
      "ColumnDisplayName": "UserPRMUid",
      "Visible": "false",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125"
    },
    {
      "ColumnName": "ExternalID",
      "ColumnDisplayName": "ExternalID",
      "Visible": "false",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125"
    },
    {
      "ColumnName": "Type",
      "ColumnDisplayName": "Type",
      "Visible": "false",
      "CanFilter": "true",
      "CanSelect": "true",
      "Type": "string",
      "Width": "125"
    }
  ]
}
'
where FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'
GO

-- #101716 -ListFindControlBehavior-Populate-SecurityGroupUid.sql
-- Date      : 2022.June.03
-- Purpose   : Populate ListFindControlBehavior.SecurityGroupUid column.
--             For entries that have corresponding ListFindTable entries,
--             populate LicenseCode, AddInUid, AllowHide and SizableFindDialog, too.
-- Developer : djost
--
-- Following ListFindControlBehavior entries do not have corresponding ListFindTable entries
-- Find Control List/ListFindControlBehavior
--   Set security group id to System
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572')
BEGIN
  UPDATE ListFindControlBehavior
    SET SecurityGroupUid = '2EA2B900-6D9A-42B9-A0FC-E08C37B3E483'  
    WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572'
END

-- Homepage Configuration/ListGroupUIConfiguration
--   Set security group id to Integration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  UPDATE ListFindControlBehavior
    SET SecurityGroupUid = '634703A6-D85B-4B9A-9ADE-4FE1A9BF7E5B'  
    WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
END

-- External Patients Filter/ViewUserFilters
--   Set security group id to Filters
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '7813A16F-EFD7-44EA-B8E8-3D640733351C')
BEGIN
  UPDATE ListFindControlBehavior
    SET SecurityGroupUid = '44904EB2-BB48-4E98-B52A-218F8F026DD8'  
    WHERE FindControlBehaviorUid = '7813A16F-EFD7-44EA-B8E8-3D640733351C'
END


--
-- Following ListFindControlBehavior entries do have corresponding ListFindTable entries
--
-- Security Group/ListSecurityGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '321D087E-277E-49B8-B776-D4816C8266A4')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
    WHERE lfcb.FindTableUid = '321D087E-277E-49B8-B776-D4816C8266A4'
END  


-- Print Sets/ListPrintSet
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'CD590855-D6C2-4BBF-868A-67714BC6AA05')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
    WHERE lfcb.FindTableUid = 'CD590855-D6C2-4BBF-868A-67714BC6AA05'
END  


-- Message Center Filters/ListFilter
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '8A838031-568C-4D5A-88DC-2BAF54765779')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
    WHERE lfcb.FindTableUid = '8A838031-568C-4D5A-88DC-2BAF54765779'
END  


-- Appointment Type/ListAppointmentType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A8095F31-3966-45CD-B643-7C5694016336')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
    WHERE lfcb.FindTableUid = 'A8095F31-3966-45CD-B643-7C5694016336'
END  


-- Document Linking Folder Type/ListDocumentLinkingFolderType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '38994050-6CDD-42A1-8541-F5303B609C93')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '38994050-6CDD-42A1-8541-F5303B609C93'
END  


-- Waiting List/WaitingList
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '1850CBF3-395E-412B-963F-D605DEDD739E')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '1850CBF3-395E-412B-963F-D605DEDD739E'
END  


-- Replication Client/ListCacheMachine
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'AAB80EC7-269B-48C2-ACDE-75DB71B5267C')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'AAB80EC7-269B-48C2-ACDE-75DB71B5267C'
END  


-- External Patients Filter/ViewUserFilters
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '932E3D68-232D-4B35-8063-5A99D89DEB55')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '932E3D68-232D-4B35-8063-5A99D89DEB55'
END  


-- User, UserGroup, FacilityPortalGroups, PersonWeb/ViewFindUserUserGroupFacilityPortalPersonWeb
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'C0482FFB-95DB-4067-86D0-ADE38623F669')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'C0482FFB-95DB-4067-86D0-ADE38623F669'
END  


-- User, User Group and Facility Portal Groups/ViewFindUserAndUserGroupAndFacilityPortalGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '20901AC1-6603-43ED-AF9C-EB00AACBEDC0')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '20901AC1-6603-43ED-AF9C-EB00AACBEDC0'
END  


-- Message Urgency/ListMessageUrgency
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4F9D2BB0-40A4-48D5-AF8A-B5B8BF90759F')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '4F9D2BB0-40A4-48D5-AF8A-B5B8BF90759F'
END  


-- Find Provider/ViewFindVideoPatientProvider
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32'
END  


-- Find Qualified Contact/ViewFindVideoAllowedPersonContact
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5'
END  


-- Calendar/ListCalendar
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '101B22CF-9E7C-410F-96F7-9ABEEB5FD9E7')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '101B22CF-9E7C-410F-96F7-9ABEEB5FD9E7'
END  


-- Visit Tracking Room/ListRoom
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4FF48066-41D6-4E1E-B372-122BBDB9C556')
BEGIN
UPDATE lfcb
  SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
  FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
  WHERE lfcb.FindTableUid = '4FF48066-41D6-4E1E-B372-122BBDB9C556'
END  


-- Service Site/ListServiceSite
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84'
END  


-- Date Timespan/ListTimespan
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E262FC31-04EB-4845-94BA-665A179D4385')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'E262FC31-04EB-4845-94BA-665A179D4385'
END  


-- Patient Program/ListPatientProgram
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7FE26214-3851-481E-9A90-8844664DE96D')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '7FE26214-3851-481E-9A90-8844664DE96D'
END  


-- Appointment Booking/ViewBookingTime
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '0BB40A7D-CF56-4EC8-B403-96FC4F0A3F43')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '0BB40A7D-CF56-4EC8-B403-96FC4F0A3F43'
END  


-- VaccineFiltered/ViewFindVaccineFiltered
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307'
END  


-- Immunization Refusal/ListImmzRefusal
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'F9B9C5C3-E532-4D09-8A67-D91F855703C1')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'F9B9C5C3-E532-4D09-8A67-D91F855703C1'
END  


-- VFC Eligibility/ListVFCEligibility
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '929E1134-121F-4441-A978-BCDEC0F3D44B')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '929E1134-121F-4441-A978-BCDEC0F3D44B'
END  


-- Immunization Completion/ListImmzCompletion
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '816164C5-B6A6-4ABF-AEFB-2A03390D5309')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '816164C5-B6A6-4ABF-AEFB-2A03390D5309'
END  


-- Immunization Historical Information/ListImmzHistorySource
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '90A03EB5-8BB6-448C-B642-8F1EA61B52FF')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '90A03EB5-8BB6-448C-B642-8F1EA61B52FF'
END  


-- Vaccine Funding Source/ListVaccineFundingSource
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4EE4936A-EC2E-42C6-AA25-54395C72C3AD')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '4EE4936A-EC2E-42C6-AA25-54395C72C3AD'
END  


-- Vaccine Mfr/ListVaccineMfr
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E107D0AE-BD51-4541-B8E6-09871CB95935')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'E107D0AE-BD51-4541-B8E6-09871CB95935'
END  


-- Vaccine Route/ListVaccineRoute
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D947F31C-1213-4BF4-90E1-814D55389A44')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'D947F31C-1213-4BF4-90E1-814D55389A44'
END  


-- Vaccine Site/ListVaccineSite
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D1751136-DC33-40E3-A21E-88EDAB02E3A5')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'D1751136-DC33-40E3-A21E-88EDAB02E3A5'
END  


-- Type of Vaccine/ListTypeofVaccine
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B6C27018-1991-46EE-ACA3-C50C4226B947')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'B6C27018-1991-46EE-ACA3-C50C4226B947'
END  


-- Vaccine/ViewFindVaccine
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307'
END  


-- Vaccine Administration/ListVaccineAdmin
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A7D30FF8-8563-4B30-8C61-1C7B5AC1CE5C')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'A7D30FF8-8563-4B30-8C61-1C7B5AC1CE5C'
END  


-- Hx Relationship/ListHxRelationship
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E0E56839-03E2-4E1D-A4C9-95A4E6B49A72')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'E0E56839-03E2-4E1D-A4C9-95A4E6B49A72'
END  


-- Problem Status/ProblemStatus
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E2007DF5-70FD-4216-8113-2161A8221D6E')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'E2007DF5-70FD-4216-8113-2161A8221D6E'
END  


-- Relationship/ListRelationship
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '00081F54-E657-484D-8D70-F7CE223F6095')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '00081F54-E657-484D-8D70-F7CE223F6095'
END  


-- Procedure History Result/ProcedureHistoryStatus
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E'
END  


-- Health Care Service Location/HealthCareServiceLocation
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E'
END  


-- History Group/ListHistoryGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B'
END  


-- Edu Form/ListEduForm
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '9B3192E0-5629-4D4F-A2EE-D344D385A6D1')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '9B3192E0-5629-4D4F-A2EE-D344D385A6D1'
END  


-- Provider Supervisor/ViewProviderSupervisor
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4C8089BA-EEA5-4151-848B-EBB68D8BC500')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '4C8089BA-EEA5-4151-848B-EBB68D8BC500'
END  


-- Formatting Model/ListFormattingTemplate
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B4DBFC5A-00F3-4BFA-8C6A-26E0EB1BBECB')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'B4DBFC5A-00F3-4BFA-8C6A-26E0EB1BBECB'
END  


-- Appointment Status/ListAppointmentStatus
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A37FB63B-78D7-46D7-B533-8F5B3F0C493C')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'A37FB63B-78D7-46D7-B533-8F5B3F0C493C'
END  


-- Service Orders/SO_DST
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF'
END  


-- Services Performed/SP_DST
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'
END  


-- Weight Conditions/ListWeightConditions
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '2785DD16-4D97-45CB-853D-0A8F6F26F5A2')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '2785DD16-4D97-45CB-853D-0A8F6F26F5A2'
END  


-- Service Performed/SP
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'
END  

-- Service Ordered/SO
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF'
END  


-- User and User Group/ViewFindUserAndUserGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '86EB1989-ED06-47BA-8562-667D77C89874')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '86EB1989-ED06-47BA-8562-667D77C89874'
END  


-- Message SubType/ListMessageSubType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '3D7443BF-161F-4D42-A774-1EF502CD239B')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '3D7443BF-161F-4D42-A774-1EF502CD239B'
END  


-- Laboratory/ListLaboratory
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '91716D23-9FED-4E35-8169-2FF1B4360C96')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '91716D23-9FED-4E35-8169-2FF1B4360C96'
END  


-- Procedure History Group/FindProcedureGroupOnly
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B'
END  


-- Negation Reason/NegationReason
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'CE5A4EFD-3A06-44E5-96D1-7416DC439644')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'CE5A4EFD-3A06-44E5-96D1-7416DC439644'
END  


-- Procedure Modifier/ListProcedureModifier
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '249DFE42-6359-408E-B76D-63B3A0D7228D')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '249DFE42-6359-408E-B76D-63B3A0D7228D'
END  


-- Message Type/ListMessageType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '0FB434E9-FC6C-418C-AA08-501F44D311DB')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '0FB434E9-FC6C-418C-AA08-501F44D311DB'
END  


-- Gender/ListGender
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '8BB7A012-33CD-400A-BCFA-7BB322D393E1')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = '8BB7A012-33CD-400A-BCFA-7BB322D393E1'
END  


-- Observation Default Settings/ObservationDefaultSettings
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'BBA9ED1D-B77F-4779-B7A8-8B863C394556')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'BBA9ED1D-B77F-4779-B7A8-8B863C394556'
END  


-- Provider/ViewProvider
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A9F8B8CD-9FF4-4DC7-8C52-40CCB1B89B66')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'A9F8B8CD-9FF4-4DC7-8C52-40CCB1B89B66'
END  


-- Observation Item/ListObservationItem
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A01CFADF-D7DB-4AA6-AF55-F130825E6C1A')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'A01CFADF-D7DB-4AA6-AF55-F130825E6C1A'
END  


-- Problem/ListDisease
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D61D54BC-A2B4-47AF-A677-A64357F6BCAC')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'D61D54BC-A2B4-47AF-A677-A64357F6BCAC'
END  


-- Attachment Types/ListAttachmentType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'DB3A3A50-8A67-439E-AE58-212EC2F68D99')
BEGIN
  UPDATE lfcb
    SET lfcb.SecurityGroupUid = lft.SecurityGroupUid, lfcb.LicenseCode = lft.LicenseCode, lfcb.AddInUid = lft.AddInUid
	FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid
	WHERE lfcb.FindTableUid = 'DB3A3A50-8A67-439E-AE58-212EC2F68D99'
END  
GO

-- #101716 part 2
-- Date           : 2022.June.22
-- Bug/User Story : 104830 
--                  QA ISSUE: Quick Search > FND Configurations > Information Tab: 
--                  Max Items set to 50 - should be set to 100
-- Developer      : djost
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A')
BEGIN
  update ListFindControlBehavior set MaxRows = 100  where FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'
END
-- #101716 end

-- #94313 _Predefined_Default_Configuration.sql
-- removed and replaced by #94313 94313_Combined_Update_Predefined_Default_Config.sql

-- #94530 _MigrationScript.sql
-- Migration Script for bug 94530
update ListUIControl set Name = 'SureScripts RLE', AQN = 'iMedica.Prm.Client.UI.Mobile.RoutingClasses.Surescripts.SurescriptsRLE' 
		where UIControlUid = '4567BD5E-86C5-457F-8B78-E367B6C4B5AD'
go

-- #103227 _resp party ledger.sql
update ListUserDefinedControl
SET ControlProperties='<UserDefinedControls>
  <Control>
    <ControlType>FIND</ControlType>
    <Name>ResponsiblePartyUID</Name>
    <SelectType>Single</SelectType>
    <Conjunction>none</Conjunction>
    <EntryNameInFindTable>Responsible Party</EntryNameInFindTable>
    <ColumnName>Name</ColumnName>
    <ControlContextKey>Name</ControlContextKey>
    <FindTableName>ViewResponsibleParty</FindTableName>
    <Required>TRUE</Required>
  </Control>
</UserDefinedControls>'
where UserDefinedControlUid = '37AE5278-3FAC-4378-B5FD-93ED657F9146'
GO

-- #101796 -ListFindControlBehavior-SyncHasSecurityAndAllowMaintenance.sql
-- Date      : 2022.June.17
-- Purpose   : Populate ListFindControlBehavior.HasSecurity and AllowMantenance from corresponding ListFindTable row.
--
-- Following ListFindControlBehavior entries do not have corresponding ListFindTable entries
--
-- Find Control List/ListFindControlBehavior
--   Set security group id to System
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572')
BEGIN
  UPDATE ListFindControlBehavior
    SET HasSecurity = 1, AllowMaintenance = 1  
    WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572'
END

-- Homepage Configuration/ListGroupUIConfiguration
--   Set security group id to Integration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  UPDATE ListFindControlBehavior
    SET HasSecurity = 1, AllowMaintenance = 1 
    WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
END

-- External Patients Filter/ViewUserFilters
--   Set security group id to Filters
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '7813A16F-EFD7-44EA-B8E8-3D640733351C')
BEGIN
  UPDATE ListFindControlBehavior
    SET HasSecurity = 1, AllowMaintenance = 1   
    WHERE FindControlBehaviorUid = '7813A16F-EFD7-44EA-B8E8-3D640733351C'
END
--
-- Following ListFindControlBehavior entries do have corresponding ListFindTable entries
--
-- Add In/ListAddIn
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E8923569-3B61-4745-BC38-10E7DDF0E018')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E8923569-3B61-4745-BC38-10E7DDF0E018'  END  

-- Appointment Booking/ViewBookingTime
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '0BB40A7D-CF56-4EC8-B403-96FC4F0A3F43')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '0BB40A7D-CF56-4EC8-B403-96FC4F0A3F43'  END  

-- Appointment Status/ListAppointmentStatus
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A37FB63B-78D7-46D7-B533-8F5B3F0C493C')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A37FB63B-78D7-46D7-B533-8F5B3F0C493C'  END  

-- Appointment Type/ListAppointmentType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A8095F31-3966-45CD-B643-7C5694016336')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A8095F31-3966-45CD-B643-7C5694016336'  END  

-- Attachment Types/ListAttachmentType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'DB3A3A50-8A67-439E-AE58-212EC2F68D99')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'DB3A3A50-8A67-439E-AE58-212EC2F68D99'  END  

-- Calendar/ListCalendar
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '101B22CF-9E7C-410F-96F7-9ABEEB5FD9E7')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '101B22CF-9E7C-410F-96F7-9ABEEB5FD9E7'  END  

-- Date Timespan/ListTimespan
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E262FC31-04EB-4845-94BA-665A179D4385')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E262FC31-04EB-4845-94BA-665A179D4385'  END  

-- Document Linking Folder Type/ListDocumentLinkingFolderType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '38994050-6CDD-42A1-8541-F5303B609C93')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '38994050-6CDD-42A1-8541-F5303B609C93'  END  

-- Edu Form/ListEduForm
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '9B3192E0-5629-4D4F-A2EE-D344D385A6D1')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '9B3192E0-5629-4D4F-A2EE-D344D385A6D1'  END  

-- External Patients Filter/ViewUserFilters
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '932E3D68-232D-4B35-8063-5A99D89DEB55')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '932E3D68-232D-4B35-8063-5A99D89DEB55'  END  

-- Find Provider/ViewFindVideoPatientProvider
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32'  END  

-- Find Qualified Contact/ViewFindVideoAllowedPersonContact
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5'  END  

-- Formatting Model/ListFormattingTemplate
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B4DBFC5A-00F3-4BFA-8C6A-26E0EB1BBECB')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'B4DBFC5A-00F3-4BFA-8C6A-26E0EB1BBECB'  END  

-- Gender/ListGender
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '8BB7A012-33CD-400A-BCFA-7BB322D393E1')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '8BB7A012-33CD-400A-BCFA-7BB322D393E1'  END  

-- Health Care Service Location/HealthCareServiceLocation
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E'  END  

-- History Group/ListHistoryGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B'  END  

-- Hx Relationship/ListHxRelationship
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E0E56839-03E2-4E1D-A4C9-95A4E6B49A72')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E0E56839-03E2-4E1D-A4C9-95A4E6B49A72'  END  

-- Immunization Completion/ListImmzCompletion
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '816164C5-B6A6-4ABF-AEFB-2A03390D5309')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '816164C5-B6A6-4ABF-AEFB-2A03390D5309'  END  

-- Immunization Historical Information/ListImmzHistorySource
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '90A03EB5-8BB6-448C-B642-8F1EA61B52FF')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '90A03EB5-8BB6-448C-B642-8F1EA61B52FF'  END  

-- Immunization Refusal/ListImmzRefusal
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'F9B9C5C3-E532-4D09-8A67-D91F855703C1')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'F9B9C5C3-E532-4D09-8A67-D91F855703C1'  END  

-- Laboratory/ListLaboratory
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '91716D23-9FED-4E35-8169-2FF1B4360C96')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '91716D23-9FED-4E35-8169-2FF1B4360C96'  END  

-- Message Center Filters/ListFilter
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '8A838031-568C-4D5A-88DC-2BAF54765779')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '8A838031-568C-4D5A-88DC-2BAF54765779'  END  

-- Message SubType/ListMessageSubType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '3D7443BF-161F-4D42-A774-1EF502CD239B')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '3D7443BF-161F-4D42-A774-1EF502CD239B'  END  

-- Message Type/ListMessageType
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '0FB434E9-FC6C-418C-AA08-501F44D311DB')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '0FB434E9-FC6C-418C-AA08-501F44D311DB'  END  

-- Message Urgency/ListMessageUrgency
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4F9D2BB0-40A4-48D5-AF8A-B5B8BF90759F')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4F9D2BB0-40A4-48D5-AF8A-B5B8BF90759F'  END  

-- Negation Reason/NegationReason
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'CE5A4EFD-3A06-44E5-96D1-7416DC439644')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'CE5A4EFD-3A06-44E5-96D1-7416DC439644'  END  

-- Observation Default Settings/ObservationDefaultSettings
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'BBA9ED1D-B77F-4779-B7A8-8B863C394556')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'BBA9ED1D-B77F-4779-B7A8-8B863C394556'  END  

-- Observation Item/ListObservationItem
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A01CFADF-D7DB-4AA6-AF55-F130825E6C1A')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A01CFADF-D7DB-4AA6-AF55-F130825E6C1A'  END  

-- Patient Program/ListPatientProgram
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7FE26214-3851-481E-9A90-8844664DE96D')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '7FE26214-3851-481E-9A90-8844664DE96D'  END  

-- Print Sets/ListPrintSet
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'CD590855-D6C2-4BBF-868A-67714BC6AA05')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'CD590855-D6C2-4BBF-868A-67714BC6AA05'  END  

-- Problem/ListDisease
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D61D54BC-A2B4-47AF-A677-A64357F6BCAC')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'D61D54BC-A2B4-47AF-A677-A64357F6BCAC'  END  

-- Problem Status/ProblemStatus
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E2007DF5-70FD-4216-8113-2161A8221D6E')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E2007DF5-70FD-4216-8113-2161A8221D6E'  END  

-- Procedure History Group/FindProcedureGroupOnly
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B'  END  

-- Procedure History Result/ProcedureHistoryStatus
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E'  END  

-- Procedure Modifier/ListProcedureModifier
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '249DFE42-6359-408E-B76D-63B3A0D7228D')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '249DFE42-6359-408E-B76D-63B3A0D7228D'  END  

-- Provider/ViewProvider
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A9F8B8CD-9FF4-4DC7-8C52-40CCB1B89B66')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A9F8B8CD-9FF4-4DC7-8C52-40CCB1B89B66'  END  

-- Provider Supervisor/ViewProviderSupervisor
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4C8089BA-EEA5-4151-848B-EBB68D8BC500')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4C8089BA-EEA5-4151-848B-EBB68D8BC500'  END  

-- Relationship/ListRelationship
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '00081F54-E657-484D-8D70-F7CE223F6095')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '00081F54-E657-484D-8D70-F7CE223F6095'  END  

-- Replication Client/ListCacheMachine
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'AAB80EC7-269B-48C2-ACDE-75DB71B5267C')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'AAB80EC7-269B-48C2-ACDE-75DB71B5267C'  END  

-- Security Group/ListSecurityGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '321D087E-277E-49B8-B776-D4816C8266A4')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '321D087E-277E-49B8-B776-D4816C8266A4'  END  

-- Service Ordered/SO
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

-- Service Orders/SO_DST
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

-- Service Performed/SP
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

-- Service Site/ListServiceSite
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84'  END  

-- Services Performed/SP_DST
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

-- Type of Vaccine/ListTypeofVaccine
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B6C27018-1991-46EE-ACA3-C50C4226B947')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'B6C27018-1991-46EE-ACA3-C50C4226B947'  END  

-- User and User Group/ViewFindUserAndUserGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '86EB1989-ED06-47BA-8562-667D77C89874')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '86EB1989-ED06-47BA-8562-667D77C89874'  END  

-- User, User Group and Facility Portal Groups/ViewFindUserAndUserGroupAndFacilityPortalGroup
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '20901AC1-6603-43ED-AF9C-EB00AACBEDC0')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '20901AC1-6603-43ED-AF9C-EB00AACBEDC0'  END  

-- User, UserGroup, FacilityPortalGroups, PersonWeb/ViewFindUserUserGroupFacilityPortalPersonWeb
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'C0482FFB-95DB-4067-86D0-ADE38623F669')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'C0482FFB-95DB-4067-86D0-ADE38623F669'  END  

-- Vaccine/ViewFindVaccine
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307'  END  

-- Vaccine Administration/ListVaccineAdmin
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A7D30FF8-8563-4B30-8C61-1C7B5AC1CE5C')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A7D30FF8-8563-4B30-8C61-1C7B5AC1CE5C'  END  

-- Vaccine Funding Source/ListVaccineFundingSource
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4EE4936A-EC2E-42C6-AA25-54395C72C3AD')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4EE4936A-EC2E-42C6-AA25-54395C72C3AD'  END  

-- Vaccine Mfr/ListVaccineMfr
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E107D0AE-BD51-4541-B8E6-09871CB95935')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E107D0AE-BD51-4541-B8E6-09871CB95935'  END  

-- Vaccine Route/ListVaccineRoute
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D947F31C-1213-4BF4-90E1-814D55389A44')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'D947F31C-1213-4BF4-90E1-814D55389A44'  END  

-- Vaccine Site/ListVaccineSite
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D1751136-DC33-40E3-A21E-88EDAB02E3A5')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'D1751136-DC33-40E3-A21E-88EDAB02E3A5'  END  

-- VaccineFiltered/ViewFindVaccineFiltered
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307'  END  

-- VFC Eligibility/ListVFCEligibility
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '929E1134-121F-4441-A978-BCDEC0F3D44B')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '929E1134-121F-4441-A978-BCDEC0F3D44B'  END  

-- Visit Tracking Room/ListRoom
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4FF48066-41D6-4E1E-B372-122BBDB9C556')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4FF48066-41D6-4E1E-B372-122BBDB9C556'  END  

-- Waiting List/WaitingList
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '1850CBF3-395E-412B-963F-D605DEDD739E')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '1850CBF3-395E-412B-963F-D605DEDD739E'  END  

-- Weight Conditions/ListWeightConditions
IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '2785DD16-4D97-45CB-853D-0A8F6F26F5A2')  BEGIN    UPDATE lfcb    SET lfcb.HasSecurity = lft.HasSecurity, lfcb.AllowMaintenance = lft.AllowMaintenance    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '2785DD16-4D97-45CB-853D-0A8F6F26F5A2'  END  
GO
-- #101796 end

-- #81508 81508_Hide_DesktopControls_From_ListEditors.sql
update ListFindTable set ShowInListEditor = 0 where FindTableUid = 'FA7D79B5-ADEB-4A3E-B5AB-96391D575122'
GO

-- #94313 94313_Combined_Update_Predefined_Default_Config.sql
-- #94313 94313_Update_Predefined_Default_Config.sql
-- reset config back to an empty object
update ListUIConfiguration
set Data = '{}'
where UIConfigurationUid = '4756D0C8-B9E2-4C9B-BFF2-D69113573B7F'

-- delete the old entries that are clogging up the default
delete from ListTileConfiguration
where TileConfigurationUid in ('7D52DD6E-5EAD-4211-85C7-490C8CFA8D88', 'FFEB326A-E46C-4941-96C3-8EB15E1EA748')

-- set user defined back to system
update ListUIConfiguration
set UserDefined = 0
where UIConfigurationUid = '4756D0C8-B9E2-4C9B-BFF2-D69113573B7F'

update ListTileConfiguration
set data = '{
  "TileTypeId": "72214A6B-49C5-4D11-8303-D08B23FF58F5",
  "TileTypeName": "Appointment Queue",
  "TileType": 0,
  "CustomName": "Appointment Queue",
  "Description": "",
  "ShortName": "Appointment Queue",
  "MaxHeight": 500,
  "DefaultState": 0,
  "Width": 2,
  "TileInstanceId": "e2ca3885-c114-4f9b-ac94-86ec1be026cf",
  "canLoad": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": true,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "isCollapsible": true,
  "isLoaded": false,
  "isRequired": false,
  "isUnique": false,
  "isConfigurable": false,
  "refreshTimer": 5,
  "canPrint": true,
  "calendarFilterIds": [],
  "calendarFilterNames": [],
  "roomFilterIds": [],
  "roomFilterNames": [],
  "appointmentTypeFilterIds": [],
  "appointmentTypesFilterNames": [],
  "appointmentStatusFilterIds": [],
  "appointmentStatusFilterNames": [],
  "displayApptType": true,
  "displayApptReason": true,
  "displayInsurance": true,
  "displayInfoIcons": true,
  "displayCalendar": true,
  "sortOrderings": {
    "SortType": "AppointmentQueueSort",
    "SortOrderingsDetails": [
      {
        "Id": "0AD174FE-014E-496C-8BE1-3ECEDFEBE6D8",
        "Name": "Appointment Time",
        "ParameterValue": "StartDateTime",
        "IsAscending": true
      }
    ]
  }
}'
where TileConfigurationUid = 'E2CA3885-C114-4F9B-AC94-86EC1BE026CF'

update ListTileConfiguration
set data = '{
  "TileTypeId": "4EED7F56-6A65-41E5-B568-80A4701C33E1",
  "TileTypeName": "Messages",
  "TileType": 0,
  "CustomName": "Messages",
  "Description": "",
  "ShortName": "",
  "MaxHeight": 500,
  "DefaultState": 0,
  "Width": 2,
  "TileInstanceId": "a86aedec-7322-49b9-9e25-d18d5190025e",
  "canLoad": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canMaximize": true,
  "isConfigurable": false,
  "refreshTimer": 5,
  "canSort": true,
  "displayHeader": true,
  "displayFooter": true,
  "isCollapsible": true,
  "isLoaded": false,
  "isRequired": false,
  "isUnique": false,
  "canPrint": true,
  "filterIds": []
}'
where TileConfigurationUid = 'A86AEDEC-7322-49B9-9E25-D18D5190025E'
-- #94313 end

-- #82143 _ListFindControlBehaviour_update.sql
update  [dbo].[ListFindControlBehavior] set ColumnsConfig='
{
    "PrimaryKey": "PersonUid",
    "PrimaryDisplayName": "FullName",
    "Columns": [
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "true",
            "Type": "string",
            "Width": "50"
        },
        {
            "ColumnName": "FullName",
            "ColumnDisplayName": "Name",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "true",
            "Type": "string",
            "Width": "125"
        },
        {
            "ColumnName": "Specialty",
            "Visible": "false"
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": "false",
            "CanFilter": "true",
            "Type": "bool"
        }
    ]
}'
where FindControlBehaviorUid='54090197-3FCC-49CD-99FB-E76423B32F5C'
GO

-- #87438 _MoveFindControlAqn.sql
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'D1B82CB7-4445-45AE-8F52-7A584E6E80F4' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.StoredProcedureFindControlService' WHERE FindControlBehavioruid = 'D1B82CB7-4445-45AE-8F52-7A584E6E80F4'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '96CF16B3-264F-4D49-9C38-B2B5529B1274' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.StoredProcedureFindControlService' WHERE FindControlBehavioruid = '96CF16B3-264F-4D49-9C38-B2B5529B1274'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'A5BCBD73-E78A-4264-ABC7-55A22674EE82' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.StoredProcedureFindControlService' WHERE FindControlBehavioruid = 'A5BCBD73-E78A-4264-ABC7-55A22674EE82'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'F5FBECE0-9FAC-4FEA-81B5-83D533070B66' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.StoredProcedureFindControlService' WHERE FindControlBehavioruid = 'F5FBECE0-9FAC-4FEA-81B5-83D533070B66'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '473D86E5-B138-436D-83FA-7BE09B5A7065' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFNDHistoryGroupService' WHERE FindControlBehavioruid = '473D86E5-B138-436D-83FA-7BE09B5A7065'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '85E6CDCE-62A9-4EB2-A1DE-96AE2A508687' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlInternalProvidersService' WHERE FindControlBehavioruid = '85E6CDCE-62A9-4EB2-A1DE-96AE2A508687'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService' WHERE FindControlBehavioruid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'FB05615B-DD10-42D6-B6F9-BB6B4D5697D4' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService' WHERE FindControlBehavioruid = 'FB05615B-DD10-42D6-B6F9-BB6B4D5697D4'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '9A2582B0-9C27-45FE-8E55-5554789091D1' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlPatientHistoryService' WHERE FindControlBehavioruid = '9A2582B0-9C27-45FE-8E55-5554789091D1'		
END

IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '8F45137C-12DF-4F97-86E3-C14DD8CD3BDE' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService' WHERE FindControlBehavioruid = '8F45137C-12DF-4F97-86E3-C14DD8CD3BDE'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '54090197-3FCC-49CD-99FB-E76423B32F5C' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlProviderWorklistService' WHERE FindControlBehavioruid = '54090197-3FCC-49CD-99FB-E76423B32F5C'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '02DA4051-E3B5-48F4-BF14-78E80899EBA0' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlRxProviderService' WHERE FindControlBehavioruid = '02DA4051-E3B5-48F4-BF14-78E80899EBA0'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '7C6ADC2E-5962-43F3-8FCB-7D42DC5A6F50' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService' WHERE FindControlBehavioruid = '7C6ADC2E-5962-43F3-8FCB-7D42DC5A6F50'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = 'B741ECF4-3F6A-4A31-8703-3AA1B323169C' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService' WHERE FindControlBehavioruid = 'B741ECF4-3F6A-4A31-8703-3AA1B323169C'		
END
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '60FDB299-887B-4530-B979-9EFC5C3105F0' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlFilterByMultipleValuesService' WHERE FindControlBehavioruid = '60FDB299-887B-4530-B979-9EFC5C3105F0'		
END
-- #87438 end

-- #107555 107555-NewModifyDeleteBoxesRemainSelected.sql
-- 1.  Add Security Group Configuration.  Includes New, Modify, Delete, UserDefinedOnly permissions
IF NOT EXISTS(SELECT * FROM ListSecurityGroup WHERE SecurityGroupUid = '22AE848E-D0F3-4C07-9DFF-D4A883444309')
BEGIN
  INSERT INTO ListSecurityGroup (SecurityGroupUid, ExternalID, Inactive, Name, Permission, Notes, UserDefined, ShowInFindList)
  VALUES (
    '22AE848E-D0F3-4C07-9DFF-D4A883444309',  -- SecurityGroupUid
    NULL,                                    -- ExternalID
    0,                                       -- Inactive
    'Configuration',                         -- Name
    46,                                      -- Permission
    'FND and Homepage Configurations',       -- Notes
    0,                                       -- UserDefined
    1)                                       -- ShowInFindList
END

-- 2.  Update ListFindControlBehavior entries FND Configuration and Homepage Configuration to use 
--     Configuration Security Group.
-- FND Configuration
IF EXISTS (SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A')
BEGIN
  UPDATE ListFindControlBehavior
    SET SecurityGroupUid = '22AE848E-D0F3-4C07-9DFF-D4A883444309'
    WHERE FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'  -- FND Configuration
END

-- Homepage Configuration
IF EXISTS (SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  UPDATE ListFindControlBehavior
    SET SecurityGroupUid = '22AE848E-D0F3-4C07-9DFF-D4A883444309'
    WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'  -- Homepage Configuration
END
-- 3.  Update SecurityUserGroup for FND Configuration and Homepage Configuration and set Permission
--     to New, Modify, and Delete.
-- FBD Configuration
IF EXISTS (SELECT * FROM SecurityUserGroup WHERE ObjectUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A')
BEGIN
  UPDATE SecurityUserGroup 
    SET Permission = 14
    WHERE ObjectUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'
END

-- Homepage Configuration
IF EXISTS (SELECT * FROM SecurityUserGroup WHERE ObjectUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  UPDATE SecurityUserGroup 
    SET Permission = 14
    WHERE ObjectUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
END
GO
-- #107555 end

-- #106554 _Formatting_Model_Alphabetical_Order.sql
update ListFindControlBehavior
set ColumnsConfig = '{"PrimaryKey":"FormattingTemplateUid","PrimaryDisplayName":"Name","InactiveColumnName":"Inactive","Columns":[{"ColumnName":"ExternalID","ColumnDisplayName":"ID","Visible":"true","CanFilter":"true","Type":"string","Width":"50"},{"ColumnName":"Name","ColumnDisplayName":"Name","Visible":"true","CanFilter":"true","CanSelect":"true","Type":"string","Width":"120","SortOrder":"1"},{"ColumnName":"FormattingTemplateUid","Visible":"false"},{"ColumnName":"Inactive","ColumnDisplayName":"Inactive","Visible":"false","CanFilter":"true","Type":"bool"},{"ColumnName":"RootObjectType","ColumnDisplayName":"Origin for Content","Visible":"true","CanFilter":"true","Type":"string","Width":"50"},{"ColumnName":"Notes","ColumnDisplayName":"Notes","Visible":"true","CanFilter":"true","Type":"string","Width":"250"}]}'
where FindControlBehaviorUid = 'FB05615B-DD10-42D6-B6F9-BB6B4D5697D4'
GO

-- #106683  Migration script for Bug 106683
Update ListFindControlBehavior Set RequiredSearchParameters = NULL 
WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
GO

-- #107945 -OnlyAllowDeleteModifyNewOnItemsThatHaveBeenImplemented.sql
-- Bug/User Story : 107945 
--                  Angular Homepage: Only allow delete, modify, new on items implemented
-- Popuplate EditBusinessObject for FND and Homepage configurations 
--
-- Update EditBusinessObject for FND Configuration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A')
BEGIN
  update ListFindControlBehavior set EditBusinessObject = 'ListUIConfiguration'  where FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'
END

-- Update EditBusinessObject for Homepage Configuration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  update ListFindControlBehavior set EditBusinessObject = 'ListGroupUIConfiguration'  where FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
END
-- Update AllowDelete to Delete for FND and Homepage configurations.  Previous setting was Merge.
-- 
-- Update AllowDelete for FND Configuration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A')
BEGIN
  update ListFindControlBehavior set AllowDelete = 1  where FindControlBehaviorUid = '01A60C01-DBB6-405E-9CF1-14A9F56B6F7A'
END

-- Update AllowDelete for Homepage Configuration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  update ListFindControlBehavior set AllowDelete = 1  where FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
END
GO

-- #108453 -Add-The-Field-ShowInListEditor-Into-The-ListFindControlBehavior-Table.sql
-- User Story : 108453
--              Add the field ShowInListEditor into the ListFindControlBehavior table.
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'ListFindControlBehavior' AND column_name = 'ShowInListEditor')
BEGIN
	-- Find Control List/ListFindControlBehavior returns list of all find controls.
	--   Set ShowInListEditor to false.
	IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572')
	BEGIN
	  UPDATE ListFindControlBehavior
		SET ShowInListEditor = 0
		WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572'
	END

	-- Name: Add In / Id: ListAddIn   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E8923569-3B61-4745-BC38-10E7DDF0E018')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E8923569-3B61-4745-BC38-10E7DDF0E018'  END  

	-- Name: Appointment Booking / Id: ViewBookingTime   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '0BB40A7D-CF56-4EC8-B403-96FC4F0A3F43')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '0BB40A7D-CF56-4EC8-B403-96FC4F0A3F43'  END  

	-- Name: Appointment Status / Id: ListAppointmentStatus   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A37FB63B-78D7-46D7-B533-8F5B3F0C493C')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A37FB63B-78D7-46D7-B533-8F5B3F0C493C'  END  

	-- Name: Appointment Type / Id: ListAppointmentType   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A8095F31-3966-45CD-B643-7C5694016336')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A8095F31-3966-45CD-B643-7C5694016336'  END  

	-- Name: Attachment Types / Id: ListAttachmentType   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'DB3A3A50-8A67-439E-AE58-212EC2F68D99')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'DB3A3A50-8A67-439E-AE58-212EC2F68D99'  END  

	-- Name: Calendar / Id: ListCalendar   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '101B22CF-9E7C-410F-96F7-9ABEEB5FD9E7')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '101B22CF-9E7C-410F-96F7-9ABEEB5FD9E7'  END  

	-- Name: Date Timespan / Id: ListTimespan   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E262FC31-04EB-4845-94BA-665A179D4385')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E262FC31-04EB-4845-94BA-665A179D4385'  END  

	-- Name: Document Linking Folder Type / Id: ListDocumentLinkingFolderType   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '38994050-6CDD-42A1-8541-F5303B609C93')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '38994050-6CDD-42A1-8541-F5303B609C93'  END  

	-- Name: Edu Form / Id: ListEduForm   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '9B3192E0-5629-4D4F-A2EE-D344D385A6D1')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '9B3192E0-5629-4D4F-A2EE-D344D385A6D1'  END  

	-- Name: External Patients Filter / Id: ViewUserFilters   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '932E3D68-232D-4B35-8063-5A99D89DEB55')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '932E3D68-232D-4B35-8063-5A99D89DEB55'  END  

	-- Name: Find Provider / Id: ViewFindVideoPatientProvider   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E11146AE-CFE6-47C5-99DE-6B908824FB32'  END  

	-- Name: Find Qualified Contact / Id: ViewFindVideoAllowedPersonContact   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'B133BAF2-B8AA-46E5-B19F-0B4FED946EF5'  END  

	-- Name: Formatting Model / Id: ListFormattingTemplate   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B4DBFC5A-00F3-4BFA-8C6A-26E0EB1BBECB')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'B4DBFC5A-00F3-4BFA-8C6A-26E0EB1BBECB'  END  

	-- Name: Gender / Id: ListGender   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '8BB7A012-33CD-400A-BCFA-7BB322D393E1')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '8BB7A012-33CD-400A-BCFA-7BB322D393E1'  END  

	-- Name: Health Care Service Location / Id: HealthCareServiceLocation   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E'  END  

	-- Name: History Group / Id: ListHistoryGroup   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B'  END  

	-- Name: Hx Relationship / Id: ListHxRelationship   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E0E56839-03E2-4E1D-A4C9-95A4E6B49A72')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E0E56839-03E2-4E1D-A4C9-95A4E6B49A72'  END  

	-- Name: Immunization Completion / Id: ListImmzCompletion   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '816164C5-B6A6-4ABF-AEFB-2A03390D5309')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '816164C5-B6A6-4ABF-AEFB-2A03390D5309'  END  

	-- Name: Immunization Historical Information / Id: ListImmzHistorySource   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '90A03EB5-8BB6-448C-B642-8F1EA61B52FF')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '90A03EB5-8BB6-448C-B642-8F1EA61B52FF'  END  

	-- Name: Immunization Refusal / Id: ListImmzRefusal   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'F9B9C5C3-E532-4D09-8A67-D91F855703C1')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'F9B9C5C3-E532-4D09-8A67-D91F855703C1'  END  

	-- Name: Laboratory / Id: ListLaboratory   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '91716D23-9FED-4E35-8169-2FF1B4360C96')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '91716D23-9FED-4E35-8169-2FF1B4360C96'  END  

	-- Name: Message Center Filters / Id: ListFilter   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '8A838031-568C-4D5A-88DC-2BAF54765779')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '8A838031-568C-4D5A-88DC-2BAF54765779'  END  

	-- Name: Message SubType / Id: ListMessageSubType   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '3D7443BF-161F-4D42-A774-1EF502CD239B')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '3D7443BF-161F-4D42-A774-1EF502CD239B'  END  

	-- Name: Message Type / Id: ListMessageType   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '0FB434E9-FC6C-418C-AA08-501F44D311DB')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '0FB434E9-FC6C-418C-AA08-501F44D311DB'  END  

	-- Name: Message Urgency / Id: ListMessageUrgency   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4F9D2BB0-40A4-48D5-AF8A-B5B8BF90759F')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4F9D2BB0-40A4-48D5-AF8A-B5B8BF90759F'  END  

	-- Name: Negation Reason / Id: NegationReason   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'CE5A4EFD-3A06-44E5-96D1-7416DC439644')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'CE5A4EFD-3A06-44E5-96D1-7416DC439644'  END  

	-- Name: Observation Default Settings / Id: ObservationDefaultSettings   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'BBA9ED1D-B77F-4779-B7A8-8B863C394556')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'BBA9ED1D-B77F-4779-B7A8-8B863C394556'  END  

	-- Name: Observation Item / Id: ListObservationItem   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A01CFADF-D7DB-4AA6-AF55-F130825E6C1A')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A01CFADF-D7DB-4AA6-AF55-F130825E6C1A'  END  

	-- Name: Patient Program / Id: ListPatientProgram   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7FE26214-3851-481E-9A90-8844664DE96D')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '7FE26214-3851-481E-9A90-8844664DE96D'  END  

	-- Name: Print Sets / Id: ListPrintSet   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'CD590855-D6C2-4BBF-868A-67714BC6AA05')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'CD590855-D6C2-4BBF-868A-67714BC6AA05'  END  

	-- Name: Problem / Id: ListDisease   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D61D54BC-A2B4-47AF-A677-A64357F6BCAC')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'D61D54BC-A2B4-47AF-A677-A64357F6BCAC'  END  

	-- Name: Problem Status / Id: ProblemStatus   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E2007DF5-70FD-4216-8113-2161A8221D6E')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E2007DF5-70FD-4216-8113-2161A8221D6E'  END  

	-- Name: Procedure History Group / Id: FindProcedureGroupOnly   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'ED7604C9-704F-4BBD-8212-C67297D5683B'  END  

	-- Name: Procedure History Result / Id: ProcedureHistoryStatus   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '060A592F-0A55-4A83-9399-D3B8F3CAE90E'  END  

	-- Name: Procedure Modifier / Id: ListProcedureModifier   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '249DFE42-6359-408E-B76D-63B3A0D7228D')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '249DFE42-6359-408E-B76D-63B3A0D7228D'  END  

	-- Name: Provider / Id: ViewProvider   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A9F8B8CD-9FF4-4DC7-8C52-40CCB1B89B66')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A9F8B8CD-9FF4-4DC7-8C52-40CCB1B89B66'  END  

	-- Name: Provider Supervisor / Id: ViewProviderSupervisor   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4C8089BA-EEA5-4151-848B-EBB68D8BC500')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4C8089BA-EEA5-4151-848B-EBB68D8BC500'  END  

	-- Name: Relationship / Id: ListRelationship   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '00081F54-E657-484D-8D70-F7CE223F6095')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '00081F54-E657-484D-8D70-F7CE223F6095'  END  

	-- Name: Replication Client / Id: ListCacheMachine   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'AAB80EC7-269B-48C2-ACDE-75DB71B5267C')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'AAB80EC7-269B-48C2-ACDE-75DB71B5267C'  END  

	-- Name: Security Group / Id: ListSecurityGroup   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '321D087E-277E-49B8-B776-D4816C8266A4')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '321D087E-277E-49B8-B776-D4816C8266A4'  END  

	-- Name: Service Ordered / Id: SO   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

	-- Name: Service Orders / Id: SO_DST   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '21C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

	-- Name: Service Performed / Id: SP   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

	-- Name: Service Site / Id: ListServiceSite   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '558EE4B7-7042-4E44-A82D-993C7D71CB84'  END  

	-- Name: Services Performed / Id: SP_DST   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'  END  

	-- Name: Type of Vaccine / Id: ListTypeofVaccine   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'B6C27018-1991-46EE-ACA3-C50C4226B947')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'B6C27018-1991-46EE-ACA3-C50C4226B947'  END  

	-- Name: User and User Group / Id: ViewFindUserAndUserGroup   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '86EB1989-ED06-47BA-8562-667D77C89874')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '86EB1989-ED06-47BA-8562-667D77C89874'  END  

	-- Name: User, User Group and Facility Portal Groups / Id: ViewFindUserAndUserGroupAndFacilityPortalGroup   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '20901AC1-6603-43ED-AF9C-EB00AACBEDC0')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '20901AC1-6603-43ED-AF9C-EB00AACBEDC0'  END  

	-- Name: User, UserGroup, FacilityPortalGroups, PersonWeb / Id: ViewFindUserUserGroupFacilityPortalPersonWeb   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'C0482FFB-95DB-4067-86D0-ADE38623F669')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'C0482FFB-95DB-4067-86D0-ADE38623F669'  END  

	-- Name: Vaccine / Id: ViewFindVaccine   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307'  END  

	-- Name: Vaccine Administration / Id: ListVaccineAdmin   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'A7D30FF8-8563-4B30-8C61-1C7B5AC1CE5C')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'A7D30FF8-8563-4B30-8C61-1C7B5AC1CE5C'  END  

	-- Name: Vaccine Funding Source / Id: ListVaccineFundingSource   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4EE4936A-EC2E-42C6-AA25-54395C72C3AD')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4EE4936A-EC2E-42C6-AA25-54395C72C3AD'  END  

	-- Name: Vaccine Mfr / Id: ListVaccineMfr   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'E107D0AE-BD51-4541-B8E6-09871CB95935')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'E107D0AE-BD51-4541-B8E6-09871CB95935'  END  

	-- Name: Vaccine Route / Id: ListVaccineRoute   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D947F31C-1213-4BF4-90E1-814D55389A44')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'D947F31C-1213-4BF4-90E1-814D55389A44'  END  

	-- Name: Vaccine Site / Id: ListVaccineSite   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = 'D1751136-DC33-40E3-A21E-88EDAB02E3A5')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = 'D1751136-DC33-40E3-A21E-88EDAB02E3A5'  END  

	-- Name: VaccineFiltered / Id: ViewFindVaccineFiltered   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '7EAB769E-BA8E-4202-AB66-862B89C53307'  END  

	-- Name: VFC Eligibility / Id: ListVFCEligibility   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '929E1134-121F-4441-A978-BCDEC0F3D44B')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '929E1134-121F-4441-A978-BCDEC0F3D44B'  END  

	-- Name: Visit Tracking Room / Id: ListRoom   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '4FF48066-41D6-4E1E-B372-122BBDB9C556')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '4FF48066-41D6-4E1E-B372-122BBDB9C556'  END  

	-- Name: Waiting List / Id: WaitingList   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '1850CBF3-395E-412B-963F-D605DEDD739E')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '1850CBF3-395E-412B-963F-D605DEDD739E'  END  

	-- Name: Weight Conditions / Id: ListWeightConditions   
	IF EXISTS(SELECT * FROM ListFindTable WHERE FindTableUid = '2785DD16-4D97-45CB-853D-0A8F6F26F5A2')  BEGIN    UPDATE lfcb    SET lfcb.ShowInListEditor = lft.ShowInListEditor    FROM ListFindControlBehavior as lfcb INNER JOIN ListFindTable as lft ON lfcb.FindTableUid = lft.FindTableUid    WHERE lfcb.FindTableUid = '2785DD16-4D97-45CB-853D-0A8F6F26F5A2'  END  
END
ELSE 
BEGIN
	SELECT 'The column ShowInListEditor does not exist on ListFindControlBehavior table.'
END
GO
-- #108453 end

-- #109537 -Implement-ShowInListEditor-For-Quick-Search.sql
-- Implement ShowInListEditor value from Quick Search modal - only show items where value is true
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572')
BEGIN
	UPDATE ListFindControlBehavior
		SET ServiceAQN = 'FrameworkBO.Server.FindControl.ListFindControlBehaviorService'
		WHERE FindControlBehaviorUid = '6CF2B96A-DE25-4959-924C-7CDBA9EA7572'
END
GO

-- #107235 --              Update ListFindControlBehavior.ServiceAQN for Homepage Configuration
IF EXISTS(SELECT * FROM ListFindControlBehavior WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0')
BEGIN
  UPDATE ListFindControlBehavior
    SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlHomepageConfigurationService'
    WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'  -- ViewHomepageConfiguration
END
GO

-- #94342 _ListDataFormatter_FieldDefinition_Update.sql
Update ListDataFormatter
Set FieldDefinition = '<Fields>
  <CustomFormatter Type="Internal" Origin="Visit" />
  <CustomFormatter Name="Custom Patient Data" Origin="Patient" />
  <CalledDataFormatter Uid="18667128-46B9-4648-B436-0C7A412DFFD5" Prefix="Visit" />
  <CalledDataFormatter Uid="8516DA6B-40B2-4DD7-A728-54B40DE960D0" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="Rendering" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferredBy" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferTo" />
  <CalledDataFormatter Uid="161530C1-4D46-467A-96EA-E7234658231D" Prefix="" />
  <CalledDataFormatter Uid="613EA28C-45B0-4520-96B4-A5C512175312" Prefix="Visit" />
  <CalledDataFormatter Uid="613EA28C-45B0-4520-96B4-A5C512175312" Prefix="Patient" />
  <CalledDataFormatter Uid="AD31E16F-3298-4C77-9805-AA5CE115A338" Prefix="" />
  <CalledDataFormatter Uid="161530C1-4D46-467A-96EA-E7234658231D" Prefix="Next" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="NextAppointment" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="PrimaryCare" />
  <Field Name="VisitDate" Layout="Date" />
  <Field Name="VisitStatus" />
  <Field Name="VisitSavedDate" Layout="Date" />
  <Field Name="VisitCompletedDate" Layout="Date" />
  <Field Name="VisitProviderSignature" AllowsSizing="True" PermitsText="False" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Provider''s signature for this visit - will only print when the note is complete/signed" />
  <Field Name="CCHPI" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmParagraphBullet" MaxLevel="1" />
  <Field Name="CCComment" />
  <Field Name="HPIComment" />
  <Field Name="ROSParagraph" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmParagraphBullet" MaxLevel="0" />
  <Field Name="ROSComment" />
  <Field Name="PE" AllowsList="True" AllowsText="True" />
  <Field Name="PEComment" />
  <Field Name="DXComment" />
  <Field Name="DX" AllowsList="True" AllowsText="True" />
  <Field Name="RXComment" />
  <Field Name="RX" AllowsList="True" AllowsText="True" />
  <Field Name="RXAdministeredDetail" />
  <Field Name="RXDetail" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Rx information as well as addendums made" />
  <Field Name="ServicesOrderedComment" />
  <Field Name="ServicesOrdered" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedComment" />
  <Field Name="ServicesPerformed" AllowsList="True" AllowsText="True" />
  <Field Name="ReviewOfHistoryParagraph" />
  <Field Name="PlanComment" />
  <Field Name="PlanParagraph" />
  <Field Name="CCPhrase" />
  <Field Name="CCPhraseNotes" />
  <Field Name="CCHPIClause" />
  <Field Name="OtherCC" />
  <Field Name="ReturnVisitTime" />
  <Field Name="SOResults" />
  <Field Name="SPResults" />
  <Field Name="ServicesOrderedWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="VitalsWeight" />
  <Field Name="VitalsHeight" />
  <Field Name="VitalsBMI" />
  <Field Name="VitalsHeadCircumference" />
  <Field Name="VitalsTemperature" />
  <Field Name="VitalsRespirationRate" />
  <Field Name="VitalsSpO2" />
  <Field Name="VitalsSittingHeartRate" />
  <Field Name="VitalsStandingHeartRate" />
  <Field Name="VitalsSupineHeartRate" />
  <Field Name="VitalsBloodPressure" />
  <Field Name="VitalsBloodPressure2" />
  <Field Name="VitalsBloodPressure3" />
  <Field Name="VitalsBloodPressure4" />
  <Field Name="DXAssociationParagraph" />
  <Field Name="PatientInstruction" />
  <Field Name="PEAbnormalParagraph" />
  <Field Name="RXNoAssociation" />
  <Field Name="VitalsComment" />
  <Field Name="AttachmentsToVisitList" />
  <Field Name="ROSParagraphDeniesOnly" />
  <Field Name="ROSParagraphComplaintsOnly" />
  <Field Name="DXWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="DXCodesOnly" AllowsList="True" AllowsText="True" />
  <Field Name="DXCode1" />
  <Field Name="DXCode2" />
  <Field Name="DXCode3" />
  <Field Name="DXCode4" />
  <Field Name="CCAddendumNotes" />
  <Field Name="HPIAddendumNotes" />
  <Field Name="ROSAddendumNotes" />
  <Field Name="DxAddendumNotes" />
  <Field Name="PEAddendumNotes" />
  <Field Name="RxAddendumNotes" />
  <Field Name="SODxAssociations" />
  <Field Name="SOAddendumNotes" />
  <Field Name="SPEandMComment" />
  <Field Name="SPDxAssociations" />
  <Field Name="SPAddendumNotes" />
  <Field Name="ReimbursementRuleServicesParagraph" />
  <Field Name="ReimbursementRuleServicesCodesAndReasons" />
  <Field Name="ObservationValues" AllowsList="True" AllowsTable="True" />
  <Field Name="VisitServiceSiteName" />
  <Field Name="VisitServiceSiteAddresses" Layout="Address" />
  <Field Name="VisitServiceSitePhones" Layout="Phone" />
  <Field Name="VisitApprovalStatus" />
  <Field Name="ReferralProvidersList" />
  <Field Name="NextAppointmentsList" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Obsolete, use the NextAppointmentsListAll field" />
  <Field Name="FaxToReferringProvider" />
  <Field Name="FaxToReferralProvider" />
  <Field Name="FaxToPatient" />
  <Field Name="FaxToPrimaryCareProvider" />
  <Field Name="VisitCosignSignature" AllowsSizing="True" PermitsText="False" />
  <Field Name="VisitCosignStatus" />
  <Field Name="RXShort" AllowsList="True" AllowsText="True" />
  <Field Name="RXShortWithAssociation" AllowsList="True" AllowsText="True" />
  <Field Name="ClinicalNoteType" />
  <Field Name="ResultsAssociatedThisVisit" AllowsList="True" AllowsText="True" />
  <Field Name="ResultsAssociatedThisVisitFullComments" AllowsList="True" AllowsText="True" />
  <Field Name="AssessmentForms" />
  <Field Name="ActiveMedicationBeforeVisit" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitShort" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitWithAssociations" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitShortWithAssociations" AllowsList="True" AllowsText="True" />
  <Field Name="CCCommentAddendumNotes" />
  <Field Name="HPICommentAddendumNotes" />
  <Field Name="ROSCommentAddendumNotes" />
  <Field Name="PECommentAddendumNotes" />
  <Field Name="DXCommentAddendumNotes" />
  <Field Name="RXCommentAddendumNotes" />
  <Field Name="ServicesOrderedCommentAddendumNotes" />
  <Field Name="ServicesPerformedCommentAddendumNotes" />
  <Field Name="PlanCommentAddendumNotes" />
  <Field Name="VitalsCommentAddendumNotes" />
  <Field Name="PatientInstructionAddendumNotes" />
  <Field Name="ServicesOrderedByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesOrderedWithCodeByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedWithCodeByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesOrderedHistory" AllowsList="True" AllowsTable="True" />
  <Field Name="ServicesPerformedHistory" AllowsList="True" AllowsTable="True" />
  <Field Name="DSMIVDX" AllowsList="True" AllowsText="True" />
  <Field Name="DSMIVDXWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="RXWithTracking" AllowsList="True" AllowsText="True" />
  <Field Name="VitalsAddendumNotes" />
  <Field Name="MedicationDiscontinuedInVisit" AllowsList="True" AllowsText="True" />
  <Field Name="GeneralComment" />
  <Field Name="InternalNotes" />
  <Field Name="InternalNotesAddendumNotes" />
  <Field Name="Historian" />
  <Field Name="MedicalDecisionMaking" />
  <Field Name="VisitAccountName" />
  <Field Name="VisitAccountTotalBalance" />
  <Field Name="VisitAccountType" />
  <Field Name="VisitAccountFundType" />
  <Field Name="VisitAccountEligibilityFund" />
  <Field Name="VisitAccountRegion" />
  <Field Name="VisitAccountPatientBalance" />
  <Field Name="VisitConfidentialNote" />
  <Field Name="ABNProcedures" AllowsTable="True" />
  <Field Name="ABNProceduresSpanish" AllowsTable="True" />
  <Field Name="VisitReferredTo" AllowsList="True" AllowsTable="True" />
  <Field Name="ArticulatedPlanText" />
  <Field Name="ArticulatedPlanTextAddendumNotes" />
  <Field Name="StartTime" Layout="Date" Definition="Start time of the visit." />
  <Field Name="EndTime" Layout="Date" Definition="End time of the visit." />
  <Field Name="VisitActionItem" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Reminders or notes to yourself or another provider for something you need to talk about when the patient comes back in the office for the next visit." />
  <Field Name="ActivitySinceLastVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Notes about patient activity since last visit that remain with the patient until any of the patient''s notes are closed on FND." />
  <Field Name="NextAppointmentsListAll" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditFutureAppointments" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Use Next Appointment List to display all upcoming appointments for patient based on the days or amount selected." />
</Fields>'
Where DataFormatterUid = '60CD5640-0B0F-4A76-92D7-164978F9C557'
GO
-- #94342 end

-- #110192 _ListDataFormatter_FieldDefinition_Update_StatementDerivedData_StatementDetailDerivedData.sql
UPDATE ListDataFormatter
SET FieldDefinition = CASE DataFormatterUid
WHEN 'A2576B40-67C1-437E-83DE-68A58C3F80F6' THEN '<Fields>
  <Field Name="CustomerName" />
  <Field Name="CustomerAddress1" />
  <Field Name="CustomerAddress2" />
  <Field Name="CustomerCity" />
  <Field Name="CustomerState" />
  <Field Name="CustomerZip" />
  <Field Name="CustomerPhone" />
  <Field Name="ReferralSource" />
  <Field Name="RemitToName" />
  <Field Name="RemitToAddress1" />
  <Field Name="RemitToAddress2" />
  <Field Name="RemitToCity" />
  <Field Name="RemitToState" />
  <Field Name="RemitToZip" />
  <Field Name="RPName" />
  <Field Name="RPID" />
  <Field Name="RPAddress1" />
  <Field Name="RPAddress2" />
  <Field Name="RPCity" />
  <Field Name="RPState" />
  <Field Name="RPZip" />
  <Field Name="RPEmail1" />
  <Field Name="RPPhone1" />
  <Field Name="RPLanguage" />
  <Field Name="StatementDate" FormatString="M/d/yyyy" />
  <Field Name="DueDate" FormatString="M/d/yyyy" />
  <Field Name="AmountDue" FormatString="F2" />
  <Field Name="TotalBalance" FormatString="F2" />
  <Field Name="InsuranceBalance" FormatString="F2" />
  <Field Name="DunningMsg" />
  <Field Name="SuperbillIDs" />
  <Field Name="StatementDetail" Layout="DerivedTable" DataItem="LineItem" TypeAttribute="Type" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditTemplateOverrides" />
  <Field Name="StatementFooter" />
  <Field Name="MinimumPaymentDue" FormatString="F2" />
  <Field Name="PaymentTypes" />
  <Field Name="PayerCredits" FormatString="F2" />
  <Field Name="RPFormattedAddress" />
</Fields>'
WHEN 'F8CAAE4A-9CF4-4591-B92D-E80290BE9658' THEN '<Fields>
  <Field Name="ItemDate" />
  <Field Name="Description" />
  <Field Name="Insurance" SuppressIf="0.0000" FormatString="F2" />
  <Field Name="Patient" SuppressIf="0.0000" FormatString="F2" />
  <Field Name="Charge" SuppressIf="0.0000" FormatString="F2" />
  <Field Name="SuperbillID" />
  <Field Name="ReferralSource" />
</Fields>'
ELSE FieldDefinition
END
GO
-- #110192 end

-- #110987  _ListDataFormatter_FieldDefinition_Update_StatementDerivedData.sql
-- updated 09/14/2022
UPDATE ListDataFormatter
SET FieldDefinition = '<Fields>
  <Field Name="CustomerName" />
  <Field Name="CustomerAddress1" />
  <Field Name="CustomerAddress2" />
  <Field Name="CustomerCity" />
  <Field Name="CustomerState" />
  <Field Name="CustomerZip" />
  <Field Name="CustomerPhone" />
  <Field Name="PayToPhone" />
  <Field Name="BillingQuestionPhone" />
  <Field Name="RemitToName" />
  <Field Name="RemitToAddress1" />
  <Field Name="RemitToAddress2" />
  <Field Name="RemitToCity" />
  <Field Name="RemitToState" />
  <Field Name="RemitToZip" />
  <Field Name="RPName" />
  <Field Name="RPID" />
  <Field Name="RPAddress1" />
  <Field Name="RPAddress2" />
  <Field Name="RPCity" />
  <Field Name="RPState" />
  <Field Name="RPZip" />
  <Field Name="RPEmail1" />
  <Field Name="RPPhone1" />
  <Field Name="RPLanguage" />
  <Field Name="StatementDate" FormatString="M/d/yyyy" />
  <Field Name="DueDate" FormatString="M/d/yyyy" />
  <Field Name="AmountDue" FormatString="F2" />
  <Field Name="TotalBalance" FormatString="F2" />
  <Field Name="InsuranceBalance" FormatString="F2" />
  <Field Name="DunningMsg" />
  <Field Name="SuperbillIDs" />
  <Field Name="StatementDetail" Layout="DerivedTable" DataItem="LineItem" TypeAttribute="Type" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditTemplateOverrides" />
  <Field Name="StatementFooter" />
  <Field Name="MinimumPaymentDue" FormatString="F2" />
  <Field Name="PaymentTypes" />
  <Field Name="PayerCredits" FormatString="F2" />
  <Field Name="RPFormattedAddress" />
</Fields>'
Where DataFormatterUid = 'A2576B40-67C1-437E-83DE-68A58C3F80F6'
GO
-- #110987 end

-- #110127 Migration script 
Update ListCVXCode 
SET CVXShortDesc = 'Vaccinia, smallpox monkeypox vaccine live, PF, SQ or ID injection',
CVXFullVaccineName = 'Vaccinia, smallpox monkeypox vaccine, live attenuated, preservative free, subcutaneous or intradermal injection',
Notes = 'Associated to FDA US Licensed product JYNNEOS, non-US tradenames IMVANEX, IMVAMUNE. Review CDC & FDA guidance for updates regarding administration'
WHERE CVXCodeUid = 'F98DF0BC-E2EA-4F16-89F9-B56FE2395D9B'

Update ListVaccine 
Set Name = 'Orthopoxvirus'
WHERE VaccineUid = 'FCA55643-7AFB-4EDC-A900-557428A89627'
GO

-- #111813 
update ListFindControlBehavior set SearchColumns='["Name" ,"URL", "ExternalID"]' where FindControlBehaviorUid='4E5CCA6A-96DB-4E34-8013-6ABF94DE2DE9'
update  [dbo].[ListFindControlBehavior] set ColumnsConfig='
{  "PrimaryKey" : "CacheMachineUid",  
	"PrimaryDisplayName": "URL",    
	"Columns": [ 
			{    
				"ColumnName": "ExternalID",        
				"ColumnDisplayName": "ID",        
				"Visible": "true",     
				"CanFilter": "true",     
				"CanSelect": "true",     
				"Type": "string",        
				"Width": "30",     }, 	   
			{
				"ColumnName": "Name",        
				"ColumnDisplayName": "Name",        
				"Visible": "true",     
				"CanFilter": "true",     
				"CanSelect": "true",     
				"Type": "string",        
				"Width": "50", 
				"SortOrder": "1",
			}, 		
			{    
				"ColumnName": "URL",        
				"ColumnDisplayName": "Machine Name",        
				"Visible": "true",     
				"CanFilter": "true",     
				"CanSelect": "true",     
				"Type": "string",        
				"Width": "50",     },   
			{        
				"ColumnName": "Inactive",        
				"ColumnDisplayName": "Inactive",        
				"Visible": "false",     
				"CanFilter": "true",     
				"Type": "bool"      },     
		]  
}'
where FindControlBehaviorUid='4E5CCA6A-96DB-4E34-8013-6ABF94DE2DE9'
GO

-- #111467 _SetCMS157ToActive.sql
IF (SELECT Inactive FROM ListCQM WHERE CMS = 'CMS157') = 1
BEGIN
	UPDATE ListCQM
	SET Inactive = 0
	WHERE CMS = 'CMS157'
END
GO

-- #111362 _ListDataFormatter_FieldDefinition_Update_StatementDerivedData.sql
UPDATE ListDataFormatter
SET FieldDefinition = '<Fields>
  <Field Name="CustomerName" />
  <Field Name="CustomerAddress1" />
  <Field Name="CustomerAddress2" />
  <Field Name="CustomerCity" />
  <Field Name="CustomerState" />
  <Field Name="CustomerZip" />
  <Field Name="CustomerPhone" />
  <Field Name="PayToPhone" />
  <Field Name="BillingQuestionPhone" />
  <Field Name="RemitToName" />
  <Field Name="RemitToAddress1" />
  <Field Name="RemitToAddress2" />
  <Field Name="RemitToCity" />
  <Field Name="RemitToState" />
  <Field Name="RemitToZip" />
  <Field Name="RPName" />
  <Field Name="RPID" />
  <Field Name="RPAddress1" />
  <Field Name="RPAddress2" />
  <Field Name="RPCity" />
  <Field Name="RPState" />
  <Field Name="RPZip" />
  <Field Name="RPEmail1" />
  <Field Name="RPPhone1" />
  <Field Name="RPLanguage" />
  <Field Name="StatementDate" FormatString="M/d/yyyy" />
  <Field Name="DueDate" FormatString="M/d/yyyy" />
  <Field Name="AmountDue" FormatString="F2" />
  <Field Name="TotalBalance" FormatString="F2" />
  <Field Name="InsuranceBalance" FormatString="F2" />
  <Field Name="DunningMsg" />
  <Field Name="SuperbillIDs" />
  <Field Name="StatementDetail" Layout="DerivedTable" DataItem="LineItem" TypeAttribute="Type" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditTemplateOverrides" />
  <Field Name="StatementFooter" />
  <Field Name="MinimumPaymentDue" FormatString="F2" />
  <Field Name="PaymentTypes" />
  <Field Name="PayerCredits" FormatString="F2" />
  <Field Name="RPFormattedAddress" />
  <Field Name="PortalPaymentAccessCode" />
  <Field Name="PortalPaymentURL" />
</Fields>'
Where DataFormatterUid = 'A2576B40-67C1-437E-83DE-68A58C3F80F6'
GO

-- #110136 _Update_ListFindControlBehavior_To_Update_HomepageConfiguration.sql
update ListFindControlBehavior
set ColumnsConfig = '{
    "PrimaryKey": "GroupUIConfigurationUid",
    "PrimaryDisplayName": "Name",
    "Columns": [
        {
            "ColumnName": "ExternalID",
            "ColumnDisplayName": "ID",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": "30"
        },
        {
            "ColumnName": "Name",
            "ColumnDisplayName": "Name",
            "Visible": "true",
            "CanFilter": "true",
            "CanSelect": "true",
            "Type": "string",
            "Width": "125",
            "SortOrder": "1"
        },
        {
            "ColumnName": "Notes",
            "ColumnDisplayName": "Notes",
            "Visible": "true",
            "CanFilter": "true",
            "Type": "string",
            "Width": "125"
        },
        {
            "ColumnName": "Inactive",
            "ColumnDisplayName": "Inactive",
            "Visible": "false",
            "CanFilter": "true",
            "Type": "bool"
        },
        {
            "ColumnName": "RestrictedToPersonUid",
            "ColumnDisplayName": "RestrictedToPersonUid",
            "Visible": "false",
            "CanFilter": "true",
            "CanSelect": "true",
            "Type": "string",
            "Width": "125"
        }
    ]
}'
where FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'
GO

-- #111362 _ListDataFormatter_FieldDefinition_Update_StatementDerivedData.sql
UPDATE ListDataFormatter
SET FieldDefinition = '<Fields>
  <Field Name="CustomerName" />
  <Field Name="CustomerAddress1" />
  <Field Name="CustomerAddress2" />
  <Field Name="CustomerCity" />
  <Field Name="CustomerState" />
  <Field Name="CustomerZip" />
  <Field Name="CustomerPhone" />
  <Field Name="PayToPhone" />
  <Field Name="BillingQuestionPhone" />
  <Field Name="RemitToName" />
  <Field Name="RemitToAddress1" />
  <Field Name="RemitToAddress2" />
  <Field Name="RemitToCity" />
  <Field Name="RemitToState" />
  <Field Name="RemitToZip" />
  <Field Name="RPName" />
  <Field Name="RPID" />
  <Field Name="RPAddress1" />
  <Field Name="RPAddress2" />
  <Field Name="RPCity" />
  <Field Name="RPState" />
  <Field Name="RPZip" />
  <Field Name="RPEmail1" />
  <Field Name="RPPhone1" />
  <Field Name="RPLanguage" />
  <Field Name="StatementDate" FormatString="M/d/yyyy" />
  <Field Name="DueDate" FormatString="M/d/yyyy" />
  <Field Name="AmountDue" FormatString="F2" />
  <Field Name="TotalBalance" FormatString="F2" />
  <Field Name="InsuranceBalance" FormatString="F2" />
  <Field Name="DunningMsg" />
  <Field Name="SuperbillIDs" />
  <Field Name="StatementDetail" Layout="DerivedTable" DataItem="LineItem" TypeAttribute="Type" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditTemplateOverrides" />
  <Field Name="StatementFooter" />
  <Field Name="MinimumPaymentDue" FormatString="F2" />
  <Field Name="PaymentTypes" />
  <Field Name="PayerCredits" FormatString="F2" />
  <Field Name="RPFormattedAddress" />
  <Field Name="PortalPaymentAccessCode" />
  <Field Name="PortalPaymentURL" />
</Fields>'
Where DataFormatterUid = 'A2576B40-67C1-437E-83DE-68A58C3F80F6'
GO

-- #113264 
-- Appointment Queue 
-- ====================
update ListTileConfiguration 
  set Data = 
  '
    {    "TileTypeId": "72214A6B-49C5-4D11-8303-D08B23FF58F5",    "TileTypeName": "Appointment Queue",    "TileType": 0,    "CustomName": "Appointment Queue",    "Description": "",    "ShortName": "Appointment Queue",    "MaxHeight": 500,    "DefaultState": 0,    "Width": 0,    "TileInstanceId": "e2ca3885-c114-4f9b-ac94-86ec1be026cf",    "canLoad": false,    "canMoreVert": false,    "canRefresh": true,    "canSort": true,    "canMaximize": true,    "displayHeader": true,    "displayFooter": true,    "isCollapsible": true,    "isLoaded": false,    "isRequired": false,    "isUnique": false,    "isConfigurable": false,    "refreshTimer": 5,    "canPrint": true,    "calendarFilterIds": [],    "calendarFilterNames": [],    "roomFilterIds": [],    "roomFilterNames": [],    "appointmentTypeFilterIds": [],    "appointmentTypesFilterNames": [],    "appointmentStatusFilterIds": [],    "appointmentStatusFilterNames": [],    "displayApptType": true,    "displayApptReason": true,    "displayInsurance": true,    "displayInfoIcons": true,    "displayCalendar": true,    "sortOrderings": {      "SortType": "AppointmentQueueSort",      "SortOrderingsDetails": [        {          "Id": "0AD174FE-014E-496C-8BE1-3ECEDFEBE6D8",          "Name": "Appointment Time",          "ParameterValue": "StartDateTime",          "IsAscending": true        }      ]    }  }    
  '
where UIConfigurationUid = '4756D0C8-B9E2-4C9B-BFF2-D69113573B7F' -- GroupUIConfigurationUid:4756D0C8-B9E2-4C9B-BFF2-D69113573B7F  (Default)
      and 
	  TileTypeUid = '72214A6B-49C5-4D11-8303-D08B23FF58F5' -- Hd Appointment Queue Tile Type
-- Messages 
-- ========
update ListTileConfiguration
  set Data = 
  '
    {    "TileTypeId": "4EED7F56-6A65-41E5-B568-80A4701C33E1",    "TileTypeName": "Messages",    "TileType": 0,    "CustomName": "Messages",    "Description": "",    "ShortName": "",    "MaxHeight": 500,    "DefaultState": 0,    "Width": 0,    "TileInstanceId": "a86aedec-7322-49b9-9e25-d18d5190025e",    "refreshTimer": 5,    "canLoad": false,    "canMoreVert": false,    "canRefresh": true,    "canMaximize": true,    "isConfigurable": false,    "canSort": true,    "displayHeader": true,    "displayFooter": true,    "isCollapsible": true,    "isLoaded": false,    "isRequired": false,    "isUnique": false,    "canPrint": true,    "filterIds": []  }    
  '
where UIConfigurationUid = '4756D0C8-B9E2-4C9B-BFF2-D69113573B7F' -- GroupUIConfigurationUid:4756D0C8-B9E2-4C9B-BFF2-D69113573B7F (Default)
      and 
	  TileTypeUid = '4EED7F56-6A65-41E5-B568-80A4701C33E1' -- Hd Messages Tile Type
GO

-- #113303
-- Appointment Queue 
-- ====================
update ListTileConfiguration 
  set Data = 
  '
    {    "TileTypeId": "72214A6B-49C5-4D11-8303-D08B23FF58F5",    "TileTypeName": "Appointment Queue",    "TileType": 0,    "CustomName": "Appointment Queue",    "Description": "",    "ShortName": "Appointment Queue",    "MaxHeight": 500,    "DefaultState": 0,    "Width": 0,    "TileInstanceId": "32c78597-8510-43be-beab-32537b7455d6",    "canLoad": false,    "canMoreVert": false,    "canRefresh": true,    "canSort": true,    "canMaximize": true,    "displayHeader": true,    "displayFooter": true,    "isCollapsible": true,    "isLoaded": false,    "isRequired": false,    "isUnique": false,    "isConfigurable": false,    "refreshTimer": 5,    "canPrint": true,    "calendarFilterIds": [],    "calendarFilterNames": [],    "roomFilterIds": [],    "roomFilterNames": [],    "appointmentTypeFilterIds": [],    "appointmentTypesFilterNames": [],    "appointmentStatusFilterIds": [],    "appointmentStatusFilterNames": [],    "displayApptType": true,    "displayApptReason": true,    "displayInsurance": true,    "displayInfoIcons": true,    "displayCalendar": true,    "sortOrderings": {      "SortType": "AppointmentQueueSort",      "SortOrderingsDetails": [        {          "Id": "0AD174FE-014E-496C-8BE1-3ECEDFEBE6D8",          "Name": "Appointment Time",          "ParameterValue": "StartDateTime",          "IsAscending": true        }      ]    }  }  
  '
where UIConfigurationUid = '9935E63F-5985-4938-B16D-5781F002A0B9' -- GroupUIConfigurationUid:9935E63F-5985-4938-B16D-5781F002A0B9  (Clinical)
      and 
	  TileTypeUid = '72214A6B-49C5-4D11-8303-D08B23FF58F5' -- Hd Appointment Queue Tile Type
-- Unsent Prescriptions 
-- ====================
update ListTileConfiguration
  set Data = 
  '
    {    "TileTypeId": "DAD2A405-8AF3-4831-8BC6-52B5C8959558",    "TileTypeName": "Prescription Queue",    "TileType": 0,    "CustomName": "Prescription Queue",    "Description": "",    "ShortName": "",    "MaxHeight": 500,    "DefaultState": 0,    "Width": 0,    "TileInstanceId": "1e8f7b96-c4a2-4120-bb85-ecea19fc8366",    "canLoad": false,    "canMoreVert": false,    "canRefresh": true,    "canSort": false,    "canMaximize": true,    "displayHeader": true,    "displayFooter": false,    "isCollapsible": true,    "isLoaded": false,    "isRequired": false,    "isUnique": false,    "isConfigurable": false,    "changeRequests": true,    "refillRequests": true,    "unsentPrescriptions": true,    "providers": [],    "refreshTimer": 5  }
  '
where UIConfigurationUid = '9935E63F-5985-4938-B16D-5781F002A0B9' -- GroupUIConfigurationUid:9935E63F-5985-4938-B16D-5781F002A0B9 (Clinical)
      and 
	  TileTypeUid = 'DAD2A405-8AF3-4831-8BC6-52B5C8959558' -- Hd Unsent Prescriptions Type Type
GO

-- #113302
-- Appointment Queue 
-- ====================
update ListTileConfiguration 
  set Data = 
  '
    {    "TileTypeId": "72214A6B-49C5-4D11-8303-D08B23FF58F5",    "TileTypeName": "Appointment Queue",    "TileType": 0,    "CustomName": "Appointment Queue",    "Description": "",    "ShortName": "Appointment Queue",    "MaxHeight": 500,    "DefaultState": 0,    "Width": 0,    "TileInstanceId": "52849a43-9300-478f-8704-693f92b0a1b9",    "canLoad": false,    "canMoreVert": false,    "canRefresh": true,    "canSort": true,    "canMaximize": true,    "displayHeader": true,    "displayFooter": true,    "isCollapsible": true,    "isLoaded": false,    "isRequired": false,    "isUnique": false,    "isConfigurable": false,    "refreshTimer": 5,    "canPrint": true,    "calendarFilterIds": [],    "calendarFilterNames": [],    "roomFilterIds": [],    "roomFilterNames": [],    "appointmentTypeFilterIds": [],    "appointmentTypesFilterNames": [],    "appointmentStatusFilterIds": [],    "appointmentStatusFilterNames": [],    "displayApptType": true,    "displayApptReason": true,    "displayInsurance": true,    "displayInfoIcons": true,    "displayCalendar": true,    "sortOrderings": {      "SortType": "AppointmentQueueSort",      "SortOrderingsDetails": [        {          "Id": "0AD174FE-014E-496C-8BE1-3ECEDFEBE6D8",          "Name": "Appointment Time",          "ParameterValue": "StartDateTime",          "IsAscending": true        }      ]    }  }
  '
where UIConfigurationUid = '96776D57-E0C9-4DC8-ABC3-4DC9A864FD5A' -- GroupUIConfigurationUid:816B8EDD-3243-4C17-A151-47CA1E1D02F8  (Administrator)
      and 
	  TileTypeUid = '72214A6B-49C5-4D11-8303-D08B23FF58F5' -- Hd Appointment Queue Tile Type
-- Messages 
-- ========
update ListTileConfiguration
  set Data = 
  '
    {      "TileTypeId": "4EED7F56-6A65-41E5-B568-80A4701C33E1",      "TileTypeName": "Messages",      "TileType": 0,      "CustomName": "Messages",      "Description": "",      "ShortName": "",      "MaxHeight": 500,      "DefaultState": 0,      "Width": 0,      "TileInstanceId": "c67baee9-c5ed-4c4c-9c3c-73e5024e7f5b",      "canLoad": false,      "canMoreVert": false,      "canRefresh": true,      "canMaximize": true,      "isConfigurable": false,      "canSort": true,      "displayHeader": true,      "displayFooter": true,      "isCollapsible": true,      "isLoaded": false,      "isRequired": false,      "isUnique": false,      "canPrint": true,      "filterIds": [],      "refreshTimer": 5    }
  '
where UIConfigurationUid = '96776D57-E0C9-4DC8-ABC3-4DC9A864FD5A' -- GroupUIConfigurationUid:816B8EDD-3243-4C17-A151-47CA1E1D02F8 (Administrator)
      and 
	  TileTypeUid = '4EED7F56-6A65-41E5-B568-80A4701C33E1' -- Hd Messages Tile Type
GO

-- #112800 _ListDataFormatter_FieldDefinition_Update_ProviderPermanentSignature.sql
UPDATE ListDataFormatter SET
FieldDefinition = '<Fields>
  <Field EmailPersonNotification="True" Name="ProviderNames" Layout="Name" />
  <Field Name="ProviderPrimaryAddresses" Layout="Address" />
  <Field Name="ProviderSecondaryAddresses" Layout="Address" />
  <Field Name="ProviderPrimaryEmail" />
  <Field Name="ProviderSecondaryEmail" />
  <Field Name="ProviderPermanentSignature" AllowsSizing="True" PermitsText="False" AllowsSignature="True" AllowsSignatureIfCompleted="True" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Provider''s permanent signature which will print if the note is open or complete" DefinitionIfCompleted="Provider''s permanent signature which will print if the note is in a complete status" />
  <Field Name="ProviderIdentifierNPI" />
  <Field Name="ProviderIdentifierUPIN" />
  <Field Name="ProviderDEA" />
  <Field Name="ProviderNotes" />
  <Field Name="ProviderPracticeName" />
  <Field Name="ProviderPhones" Layout="Phone" />
  <Field Name="ProviderSpecialty" />
  <Field Name="ProviderPersonNotes" />
</Fields>'
WHERE DataFormatterUid = '9D7520C3-B507-463F-9CFD-18BDE5A74677'
GO

-- #112487 _UpdateListFilterFindControl.sql
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ServiceAQN = 'FrameworkBO.Server.FindControl.FindControlListFilterService', NAME = 'Filter' WHERE FindControlBehaviorUid = '0AF90199-6D9D-4D52-9721-7D7F663B7A6C'		
END
GO

-- #113335 _UpdateHomepageConfigFindControl.sql
IF EXISTS(
	SELECT * FROM ListFindControlBehavior WHERE FindControlBehavioruid = '60FDB299-887B-4530-B979-9EFC5C3105F0' 
)
BEGIN
	UPDATE ListFindControlBehavior SET ColumnsConfig = '{    "PrimaryKey": "GroupUIConfigurationUid",    "PrimaryDisplayName": "Name", "InactiveColumnName": "Inactive", "Columns": [{"ColumnName":"ExternalID","ColumnDisplayName":"ID","Visible":"true","CanFilter":"true","Type":"string","Width":"30"},{"ColumnName":"Name","ColumnDisplayName":"Name","Visible":"true","CanFilter":"true","CanSelect":"true","Type":"string","Width":"125","SortOrder":"1"},{"ColumnName":"Notes","ColumnDisplayName":"Notes","Visible":"true","CanFilter":"true","Type":"string","Width":"125"}, {"ColumnName":"Inactive","ColumnDisplayName":"Inactive","Visible":"false","CanFilter":"true","Type":"bool"}, {"ColumnName": "RestrictedToPersonUid",          "ColumnDisplayName": "RestrictedToPersonUid",  "Visible": "false",          "CanFilter": "true",          "CanSelect": "true",          "Type": "string",          "Width": "125"      }    ]  } '
	WHERE FindControlBehaviorUid = '60FDB299-887B-4530-B979-9EFC5C3105F0'		
END
GO

-- #114541
UPDATE ListGenderIdentity
SET ExternalID = CASE WHEN GenderIdentityUid = '27E95378-9496-4A36-9663-B555130CDF1B' THEN '446151000124109'
	WHEN GenderIdentityUid = 'F65CA760-9075-4F57-AE9E-4FC9B5D49795' THEN '446141000124107'
	WHEN GenderIdentityUid = '4DA8BED2-1666-4332-BF62-09A852DA327C' THEN 'ASKU'
	WHEN GenderIdentityUid = 'A7A7C23A-5B49-4D57-A7DA-657E661C392B' THEN '446131000124102'
	WHEN GenderIdentityUid = '78A0E432-3D9D-4530-9551-93CBBAD1C142' THEN 'OTH'
	WHEN GenderIdentityUid = '841ABACC-E0CD-4595-B258-BD5EBDB76659' THEN '407377005'
	WHEN GenderIdentityUid = '58130847-1C29-46A1-AE36-BE6D8D056C76' THEN '407376001'
	ELSE 'OTH'
END

UPDATE ListGender
SET ExternalID = CASE WHEN GenderUid = '8202FCB6-C28D-4985-9FC4-0C92E35C2DFD' THEN 'male'
	WHEN GenderUid = 'E5DED511-EE8A-4B47-AA68-8FF9F74741A1' THEN 'female'
	WHEN GenderUid = '9EF147F5-0265-4611-A9C7-D4005D306FD6' THEN 'unknown'
	ELSE 'other'
	END
GO

-- #114646 #114638
delete from ExternalMaterialSource  where ExternalMaterialSourceUid='A36ACBDA-D664-4397-8BF7-B4BD2101324C'
update ExternalMaterialSource set URL='https://help.emdscloud.com/Aprima/quick-start/guide/index-guide.html' where ExternalMaterialSourceUid='95316267-E614-4B73-8F66-CDA1695A71BF'
GO

-- #112445
declare @tempTable table( pk uniqueidentifier , tileIndex int, rowNumber int)
declare @tempTableRowCnt int = 0;
declare @counter int = 1;
declare @tileIndex int = 0;
declare @pk uniqueidentifier;

insert into @tempTable 
SELECT UIConfigurationUid,[key] , rowNumber = ROW_NUMBER() over(order by lastmodifiedDate) FROM ListUIConfiguration AS UIconfig
    CROSS APPLY OPENJSON( data, '$.TileConfigs') AS Config 
    WHERE
		DataTypeId = 1 and UserDefined = 1 and (
		JSON_VALUE( Config.value, '$.TileTypeId' ) = '983A37AE-290C-4C42-98B9-30B1067E1F52')

select @tempTableRowCnt = count(*) from @tempTable

while @tempTableRowCnt >= @counter
begin
select @tileIndex = tileIndex, @pk = pk from @tempTable
where rowNumber = @counter

Declare @sqlcommn nvarchar(600);
set @sqlcommn = 
'UPDATE UIconfig
set data = JSON_MODIFY(data, ''$.TileConfigs['+ convert(varchar,@tileIndex) +'].TileTypeName'',''Problems & Diagnoses'')
FROM ListUIConfiguration AS UIconfig
where UIConfigurationUid ='''+ convert(varchar(50), @pk) +''''

exec sp_executesql  @sqlcommn

set @counter = @counter + 1;
end
GO

