﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <html>
      <head>
        <title>Session List</title>
        <link href="ActivityMonitor.css" type="text/css" rel="stylesheet"/>
        <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE" />
        <script src="ClientScripts.js" type="text/javascript"></script>
      </head>
      <body>
        <center>
          <h2>Session List</h2>
        </center>
        <table width="100%">
          <thead>
            <tr>
              <td width="20%">
                User Name
              </td>
              <td width="20%">
                Host Name
              </td>
              <td width="15%">
                State
              </td>
              <td width="10%">
                Date
              </td>
              <td width="10%">
                Duration
              </td>
              <td width="30%">
                ID
              </td>
            </tr>
          </thead>
          <tbody>
            <xsl:for-each select="sessions/session">
              <tr>
                <xsl:if test="position() mod 2 = 0">
                  <xsl:attribute name="class">oddrow</xsl:attribute>
                </xsl:if>
                <xsl:if test="position() mod 2 = 1">
                  <xsl:attribute name="class">evenrow</xsl:attribute>
                </xsl:if>
                <td>
                  <xsl:attribute name="title">SID = <xsl:value-of select="@sid"/></xsl:attribute>
                  <xsl:if test="@domain != ''"><xsl:value-of select="@domain" />/</xsl:if><xsl:value-of select="@name" />
                </td>
                <td>
                  <xsl:value-of select="@host" />
                </td>
                <TD valign="top">
                  <xsl:value-of select="@state" />
                </TD>
                <TD valign="top">
                  <xsl:value-of select="@date" />
                </TD>
                <TD valign="top">
                  <xsl:value-of select="@duration" />
                </TD>
                <TD valign="top">
                  <xsl:value-of select="@id" />
                </TD>
              </tr>
              <xsl:if test="@statusMessage != ''">
                <tr>
                  <xsl:if test="position() mod 2 = 0">
                    <xsl:attribute name="class">oddrow</xsl:attribute>
                  </xsl:if>
                  <xsl:if test="position() mod 2 = 1">
                    <xsl:attribute name="class">evenrow</xsl:attribute>
                  </xsl:if>
                  <td style="border-top-width: 0px" colspan="6">
                    Status: <xsl:value-of select="@statusMessage" />
                  </td>
                </tr>
              </xsl:if>
            </xsl:for-each>
          </tbody>
        </table>
        <xsl:for-each select="sessions">
          <B>
            Total Sessions: <xsl:value-of select="@count" />
          </B>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>