IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateDatabaseCLR]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [dbo].[CreateDatabaseCLR]
END
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROC [dbo].[CreateDatabaseCLR] AS
BEGIN
	EXEC sp_executesql N'
		BEGIN
			exec sp_changedbowner ''sa''

			EXEC sp_configure @configname = ''clr enabled'', @configvalue = 1
			RECONFIGURE WITH OVERRIDE
			
			DECLARE @dbname varchar(255) = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				
				PRINT ''Dropping Assembly [PRMDatabaseCLR]''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
		END
		'
	EXEC sp_executesql N'
			USE [master];  -- this will automatically reset to the PRM DB
			DECLARE @dbname varchar(255) = db_name()
		
			IF NOT EXISTS (select name from sys.certificates where name = ''PRMCLRCodeCert2023'')
			BEGIN
				IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
				BEGIN
					If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
						exec UninstallDatabaseCLR
					DROP ASSEMBLY [PRMDatabaseCLR];
				END
				EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')
			
				PRINT ''Create temporary [PRMDatabaseCLR] in master''
				-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
				CREATE ASSEMBLY [PRMDatabaseCLR]
				AUTHORIZATION [dbo]
				FROM 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
				WITH PERMISSION_SET = SAFE;

				PRINT ''Create certificate PRMCLRCodeCert2023 from [PRMDatabaseCLR]''
				CREATE CERTIFICATE PRMCLRCodeCert2023 FROM 	ASSEMBLY [PRMDatabaseCLR]
				-- CREATE CERTIFICATE PRMCLRCodeCert2023 FROM EXECUTABLE FILE = ''\Installation\DBScript\Assemblies\PRMDatabaseCLR.dll''   
			END
			
			IF NOT EXISTS (SELECT name FROM sys.server_principals WHERE name = ''PRMCLRCodeLogin2023'')
			BEGIN
				PRINT ''Create Login PRMCLRCodeLogin2023 from PRMCLRCodeCert2023''
				CREATE LOGIN PRMCLRCodeLogin2023 FROM CERTIFICATE PRMCLRCodeCert2023
				GRANT UNSAFE ASSEMBLY TO PRMCLRCodeLogin2023
			END
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				PRINT ''Drop temporary Assembly [PRMDatabaseCLR] from master''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
			IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CreateDatabaseCLR]'') AND type in (N''P'', N''PC''))
			BEGIN
				DROP PROCEDURE [dbo].[CreateDatabaseCLR]
			END
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY OFF'')
		'

	EXEC sp_executesql N'
			-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
			CREATE ASSEMBLY [PRMDatabaseCLR]
			AUTHORIZATION [dbo]
			FROM 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
			WITH PERMISSION_SET = UNSAFE;
		'
	EXEC sp_executesql N'
			CREATE PROCEDURE [UninstallDatabaseCLR] AS EXTERNAL NAME [PRMDatabaseCLR].[Registration].[UninstallDatabaseCLR]
		'
	EXEC sp_executesql N'
			CREATE PROCEDURE [InstallDatabaseCLR] AS EXTERNAL NAME [PRMDatabaseCLR].[Registration].[InstallDatabaseCLR]
		'
	EXEC sp_executesql N'
			EXEC [InstallDatabaseCLR];
		'
	EXEC sp_executesql N'
			DECLARE @dbname varchar(255) = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname  + ''] SET TRUSTWORTHY OFF'')
		'
	/*
		-- 2019 code certificate in the PRM DB run this to verify the certificate and login exist. Login should be in both, cert only in Master
		-- 2021 code certificate in the PRM DB run this to verify the certificate and login exist. Login should be in both, cert only in Master
		-- 2023 code certificate in the PRM DB run this to verify the certificate and login exist. Login should be in both, cert only in Master
		SELECT name [PRM Cert] from sys.certificates where name like 'PRMCLRCodeCert%'
		SELECT name [PRM Login] FROM sys.server_principals WHERE name like 'PRMCLRCodeLogin%'
		SELECT name [master Cert] from master.sys.certificates where name like 'PRMCLRCodeCert%'
		SELECT name [master Login] FROM master.sys.server_principals WHERE name like 'PRMCLRCodeLogin%'
		-- This will remove the cert and login so we can create new ones
		USE master; 
		DROP LOGIN PRMCLRCodeLogin2023
		DROP CERTIFICATE PRMCLRCodeCert2023 
		DROP LOGIN PRMCLRCodeLogin2023
		DROP CERTIFICATE PRMCLRCodeCert2023

		once the CLR has been installed, the following should be run to verify
		that clr strict security is ON and trustworthy is OFF
		EXEC sp_configure 'show advanced options', 1
		RECONFIGURE;
		EXEC sp_configure 'clr strict security'
		select name, is_trustworthy_on from sys.databases

		-- test with this
		exec HelloWorld 'howdy'
	*/
END
GO

EXEC sp_executesql N'
		EXEC [CreateDatabaseCLR];
	'
GO
