SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CMSCodeXml]') AND type in (N'U'))
BEGIN
CREATE TABLE [CMSCodeXml](
	[FilePath] [varchar](max) NULL,
	[Measure] [varchar](10) NULL,
	[Content] [varbinary](max) NULL,
	[XMLContent] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CQMCodes2020]') AND type in (N'U'))
BEGIN
CREATE TABLE [CQMCodes2020](
	[CMS ID] [varchar](max) NULL,
	[NQF Number] [varchar](max) NULL,
	[Value Set Name] [varchar](max) NULL,
	[Value Set OID] [varchar](max) NULL,
	[QDM Category] [varchar](max) NULL,
	[Definition Version] [varchar](max) NULL,
	[Expansion Version] [varchar](max) NULL,
	[Clinical Focus    ] [varchar](max) NULL,
	[Data Element Scope] [varchar](max) NULL,
	[Inclusion Criteria] [varchar](max) NULL,
	[Exclusion Criteria] [varchar](max) NULL,
	[Code] [varchar](max) NULL,
	[Description] [varchar](max) NULL,
	[Code System] [varchar](max) NULL,
	[Code System OID] [varchar](max) NULL,
	[Code System Version] [varchar](max) NULL,
	[Expansion ID] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HEDISMeasureToValueSet2015]') AND type in (N'U'))
BEGIN
CREATE TABLE [HEDISMeasureToValueSet2015](
	[HEDISMeasureToValueSet2015Uid] [uniqueidentifier] NULL,
	[MeasureID] [varchar](10) NULL,
	[MeasureName] [varchar](255) NULL,
	[ValueSetName] [varchar](255) NULL,
	[ValueSetOID] [varchar](50) NULL,
	[LastModifiedDate] [smalldatetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HEDISValueSetToCode2015]') AND type in (N'U'))
BEGIN
CREATE TABLE [HEDISValueSetToCode2015](
	[HEDISValueSetToCode2015uID] [uniqueidentifier] NULL,
	[ValueSetName] [varchar](255) NULL,
	[ValueSetOID] [varchar](50) NULL,
	[ValueSetVersion] [varchar](50) NULL,
	[Code] [varchar](50) NULL,
	[Definition] [varchar](512) NULL,
	[CodeSystem] [varchar](50) NULL,
	[CodeSystemOID] [varchar](50) NULL,
	[CodeSystemVersion] [varchar](50) NULL,
	[LastModifiedDate] [smalldatetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ICD]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ICD](
	[ICD_UID] [uniqueidentifier] NOT NULL,
	[ICD_LEXICALS_TEXT_IMO_CODE] [int] NULL,
	[ICD_IMO_CODE] [int] NULL,
	[ICD_BASE_TEXT_CODE] [varchar](10) NULL,
	[PREF_BASE_FLAG] [tinyint] NULL,
	[PREF_LEXICALS_TEXT_IMO_FLAG] [bit] NULL,
	[ICD_LONG_FORM] [bit] NULL,
	[ICD_SHORT_FORM] [bit] NULL,
	[PATIENT_TRANSLATION_FLAG] [bit] NULL,
	[CLINICIAN_TRANSLATION_FLAG] [bit] NULL,
	[ICD_GLOBAL_CODE] [int] NOT NULL,
	[REFERENCE_FLAG] [varchar](12) NULL,
	[REAL_REF_FLAG] [varchar](12) NULL,
	[POST_COORD_MAP_FLAG] [tinyint] NULL,
	[POST_COORD_LEX_TEXT_IMO_CODE] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDeleted] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ICD_BASE_TEXT_TERMINATED]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ICD_BASE_TEXT_TERMINATED](
	[ICD_BASE_TEXT_CODE] [varchar](10) NOT NULL,
	[TERM_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ICD_MODIFIER]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ICD_MODIFIER](
	[ICD_MODIFIER_UID] [uniqueidentifier] NOT NULL,
	[ICD_MODIFIER_IMO_CODE] [int] NULL,
	[MODIFIER_TYPE] [varchar](255) NULL,
	[MODIFIER_ITEM] [varchar](255) NULL,
	[MODIFIER_ITEM_ORDER] [tinyint] NULL,
	[MODIFIER_ITEM_DEFAULT] [tinyint] NULL,
	[ICD_GLOBAL_CODE] [int] NULL,
	[MODIFIER_TYPE_TEXT] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDeleted] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ICD_MODIFIER_MAP]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ICD_MODIFIER_MAP](
	[ICD_MODIFIER_MAP_UID] [uniqueidentifier] NOT NULL,
	[ICD_IMO_CODE] [int] NULL,
	[ICD_MODIFIER_IMO_CODE] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDeleted] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ICD_NOTES]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ICD_NOTES](
	[ICD_NOTES_UID] [uniqueidentifier] NOT NULL,
	[SEQUENCE_ORDER] [int] NOT NULL,
	[NOTE_TYPE] [varchar](1) NOT NULL,
	[NOTE_TEXT] [varchar](max) NOT NULL,
	[RANGE_LOW] [varchar](10) NOT NULL,
	[RANGE_HIGH] [varchar](10) NOT NULL,
	[ICD_GLOBAL_CODE] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDeleted] [bit] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ICD9]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ICD9](
	[ICD9_UID] [uniqueidentifier] NOT NULL,
	[ICD_LEXICALS_TEXT_IMO_CODE] [int] NULL,
	[ICD_IMO_CODE] [int] NOT NULL,
	[ICD9_BASE_TEXT_CODE] [varchar](10) NULL,
	[PREF_BASE_FLAG] [tinyint] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDeleted] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_Keywords]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_Keywords](
	[Code] [int] NOT NULL,
	[WORD_TEXT] [nvarchar](75) NOT NULL,
	[WORD_POS] [int] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_Lexicals]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_Lexicals](
	[Code] [int] NOT NULL,
	[Title] [nvarchar](500) NOT NULL,
	[ICD10_Code] [nvarchar](15) NULL,
	[SCT_CONCEPT_ID] [bigint] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_SearchResult_Base]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_SearchResult_Base](
	[Code10] [varchar](10) NOT NULL,
	[CodeDescription10] [varchar](500) NOT NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LexCode] [int] NOT NULL,
	[LexText] [varchar](512) NOT NULL,
	[LexCodeForCodeDescription10] [int] NOT NULL,
	[ManifestationCode10] [bit] NOT NULL,
	[Billable10] [bit] NOT NULL,
	[Specific10] [bit] NOT NULL,
	[Primary10] [bit] NOT NULL,
	[Code09] [varchar](10) NOT NULL,
	[CodeDescription09] [varchar](500) NOT NULL,
	[SnoMedCodeList] [varchar](max) NULL,
	[ModifierCodeList] [varchar](500) NULL,
	[ModifiersExistInSubCodes] [bit] NOT NULL,
	[Syn] [bit] NOT NULL,
	[Code09PrefBase] [int] NOT NULL,
	[Code10PrefBase] [int] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProductCommon]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProductCommon](
	[ProductCommonUid] [uniqueidentifier] NOT NULL,
	[ParameterName] [varchar](250) NOT NULL,
	[StringValue] [varchar](max) NULL,
	[GuidValue] [uniqueidentifier] NULL,
	[BoolValue] [bit] NULL,
	[IntegerValue] [int] NULL,
	[DateValue] [date] NULL,
	[DateTimeValue] [datetime] NULL,
	[DecimalValue] [decimal](18, 0) NULL,
	[RealValue] [real] NULL,
	[BinaryValue] [varbinary](max) NULL,
	[XMLValue] [xml] NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MASTER_MU2_InterfaceDataMapping]') AND type in (N'U'))
BEGIN
CREATE TABLE [MASTER_MU2_InterfaceDataMapping](
	[InterfaceDataMappingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MASTER_MU2_InterfaceDataMapping1_InterfaceDataMappingUid]  DEFAULT (newsequentialid()),
	[Rootid] [varchar](40) NOT NULL,
	[Name] [varchar](100) NULL,
	[CCDCode] [varchar](25) NOT NULL,
	[PRMCode] [varchar](25) NULL,
	[CCDPrintName] [varchar](250) NULL,
	[IsDefault] [bit] NULL CONSTRAINT [DF_MASTER_MU2_InterfaceDataMapping1_Default]  DEFAULT ((0)),
	[Inactive] [bit] NULL CONSTRAINT [DF_MASTER_MU2_InterfaceDataMapping1_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MASTER_MU2_InterfaceDataMapping1_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_MASTER_MU2_InterfaceDataMapping1_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[NCQMeasure] [varchar](10) NULL,
	[TopicIndicator] [varchar](50) NULL,
	[NQFNumber] [varchar](10) NULL,
	[DataElementName] [varchar](100) NULL,
	[Modifier] [varchar](25) NULL,
	[EndDate] [varchar](25) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_MASTERMU2Interface_DisplayOrder]  DEFAULT ((0)),
	[QRDASection] [varchar](50) NULL,
	[CQMVersion] [varchar](7) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterDiagnosis](
	[MasterDiagnosisUid] [uniqueidentifier] NOT NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[Specificity] [char](1) NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[ShortDescription] [varchar](75) NOT NULL,
	[LongDescription] [varchar](255) NULL,
	[Complete] [bit] NOT NULL,
	[CCFlag] [bit] NOT NULL,
	[AgeEdit] [char](1) NULL,
	[SexEdit] [char](1) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[DSMAxis] [varchar](250) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterDiagnosisSnomed]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterDiagnosisSnomed](
	[MasterDiagnosisSnomedUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DiagnosisCode9] [varchar](6) NULL,
	[SnomedCTConceptId] [varchar](25) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterExtendedGrowthChart]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterExtendedGrowthChart](
	[MasterExtendedGrowthChartUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MasterExtendedGrowthChart_MasterExtendedGrowthChartUid]  DEFAULT (newid()),
	[DataType] [varchar](30) NULL,
	[Gender] [smallint] NULL,
	[Agemos] [float] NULL,
	[L] [float] NULL,
	[M] [float] NULL,
	[S] [float] NULL,
	[sigma] [float] NULL,
	[P2] [float] NULL,
	[P3] [float] NULL,
	[P5] [float] NULL,
	[P10] [float] NULL,
	[P25] [float] NULL,
	[P50] [float] NULL,
	[P75] [float] NULL,
	[P85] [float] NULL,
	[P90] [float] NULL,
	[P95] [float] NULL,
	[P97] [float] NULL,
	[P98] [float] NULL,
	[P99] [float] NULL,
	[P99_9] [float] NULL,
	[P99_99] [float] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_MasterExtendedGrowthChart_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MasterExtendedGrowthChart_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MasterExtendedGrowthChart_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterGrowthChart]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterGrowthChart](
	[MasterGrowthChartUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MasterGrowthChart_MasterGrowthChartUid]  DEFAULT (newid()),
	[DataType] [varchar](30) NULL,
	[Gender] [smallint] NULL,
	[Agemos] [float] NULL,
	[L] [float] NULL,
	[M] [float] NULL,
	[S] [float] NULL,
	[P2] [float] NULL,
	[P3] [float] NULL,
	[P5] [float] NULL,
	[P10] [float] NULL,
	[P25] [float] NULL,
	[P50] [float] NULL,
	[P75] [float] NULL,
	[P85] [float] NULL,
	[P90] [float] NULL,
	[P95] [float] NULL,
	[P97] [float] NULL,
	[P98] [float] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_MasterGrowthChart_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MasterGrowthChart_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MasterGrowthChart_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterLoinc]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterLoinc](
	[MasterLoincUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LOINC_NUM] [varchar](7) NULL,
	[COMPONENT] [varchar](150) NULL,
	[PROPERTY] [varchar](30) NULL,
	[TIME_ASPCT] [varchar](15) NULL,
	[SYSTEM] [varchar](100) NULL,
	[SCALE_TYP] [varchar](30) NULL,
	[METHOD_TYP] [varchar](50) NULL,
	[RELAT_NMS] [varchar](254) NULL,
	[CLASS] [varchar](20) NULL,
	[SOURCE] [varchar](8) NULL,
	[EUCLIDE_CD] [varchar](10) NULL,
	[ASTM_CD] [varchar](9) NULL,
	[IUPAC_CD] [varchar](8) NULL,
	[DT_LAST_CH] [varchar](8) NULL,
	[CHNG_REAS] [varchar](254) NULL,
	[CHNG_TYPE] [varchar](3) NULL,
	[COMMENTS] [varchar](254) NULL,
	[ANSWERLIST] [varchar](max) NULL,
	[STATUS] [varchar](3) NULL,
	[MAP_TO] [varchar](7) NULL,
	[SCOPE] [varchar](20) NULL,
	[SNOWMED_CD] [varchar](10) NULL,
	[VA_CD] [varchar](8) NULL,
	[METPATH_CD] [varchar](10) NULL,
	[HCFA_CD] [varchar](12) NULL,
	[CDC_CD] [varchar](6) NULL,
	[NORM_RANGE] [varchar](30) NULL,
	[EX_US_UNITS] [varchar](30) NULL,
	[IPCC_UNITS] [varchar](30) NULL,
	[GPI_CD] [varchar](100) NULL,
	[REFERENCE] [varchar](max) NULL,
	[EXACT_CMP_SY] [varchar](50) NULL,
	[MOLAR_MASS] [varchar](13) NULL,
	[IUPC_ANLT_CD] [varchar](13) NULL,
	[CLASSTYPE] [int] NULL,
	[FORMULA] [varchar](255) NULL,
	[MULTUM_CD] [varchar](6) NULL,
	[DEEDS_CD] [varchar](7) NULL,
	[CSCQ_FRNCH_NM] [varchar](255) NULL,
	[CSCQ_GRMN_NM] [varchar](255) NULL,
	[SPNSH_NM] [varchar](255) NULL,
	[CSCQ_ITLN_NM] [varchar](255) NULL,
	[SPECIES] [varchar](20) NULL,
	[EXMPL_ANSWERS] [varchar](max) NULL,
	[ACSSYM] [varchar](max) NULL,
	[MOLEID] [varchar](15) NULL,
	[BASE_NAME] [varchar](50) NULL,
	[FINAL] [varchar](1) NULL,
	[GENE_ID] [varchar](20) NULL,
	[NAACCR_ID] [varchar](20) NULL,
	[CODE_TABLE] [varchar](10) NULL,
	[SetRoot] [bit] NOT NULL,
	[PanelElements] [varchar](max) NULL,
	[SURVEY_QUEST_TEXT] [varchar](255) NULL,
	[SURVEY_QUEST_SRC] [varchar](50) NULL,
	[UnitsRequired] [varchar](1) NULL,
	[SUBMITTED_UNITS] [varchar](30) NULL,
	[RelatedNames2] [varchar](max) NULL,
	[SHORTNAME] [varchar](40) NULL,
	[ORDER_OBS] [varchar](15) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterProcedure](
	[MasterProcedureUid] [uniqueidentifier] NOT NULL,
	[Code] [varchar](25) NULL,
	[ProcedureCodeTypeUid] [uniqueidentifier] NOT NULL,
	[ProcedureServiceTypeUid] [uniqueidentifier] NULL,
	[ShortDescription] [varchar](750) NOT NULL,
	[LongDescription] [varchar](4000) NULL,
	[Star] [bit] NOT NULL,
	[RVU] [real] NULL,
	[TotalFacilityRVU] [real] NULL,
	[IsEM] [bit] NOT NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Unit] [money] NULL,
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MasterProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MasterProcedure_UserDefined]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_COPYRIGHT_INFO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_COPYRIGHT_INFO](
	[Uid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_NDD_COPYRIGHT_INFO_Uid]  DEFAULT (newid()),
	[Copyright] [varchar](512) NOT NULL,
	[IsCurrentRow] [bit] NOT NULL CONSTRAINT [DF_NDD_COPYRIGHT_INFO_IsCurrentRow]  DEFAULT ((0)),
	[IsBulkLoad] [bit] NOT NULL CONSTRAINT [DF_NDD_COPYRIGHT_INFO_IsBulkLoad]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_COPYRIGHT_INFO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_COPYRIGHT_INFO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_PRODUCT_INFO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_PRODUCT_INFO](
	[Uid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_NDD_PRODUCT_INFO_Uid]  DEFAULT (newid()),
	[PRODUCTION_DATE] [datetime] NOT NULL,
	[IsCurrentRow] [bit] NOT NULL CONSTRAINT [DF_NDD_PRODUCT_INFO_IsCurrentRow]  DEFAULT ((0)),
	[IsBulkLoad] [bit] NOT NULL CONSTRAINT [DF_NDD_PRODUCT_INFO_IsBulkLoad]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_PRODUCT_INFO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_PRODUCT_INFO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIDA0_DISPLAY_ACTION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIDA0_DISPLAY_ACTION](
	[DDI_DISPLAY_ACTION_ID] [numeric](8, 0) NOT NULL,
	[DDI_DISPLAY_ACTION_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RADIDA0_DISPLAY_ACTION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RADIDA0_DISPLAY_ACTION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIDC0_DDI_DC_GCNSEQNO_SCREEN]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIDC0_DDI_DC_GCNSEQNO_SCREEN](
	[DDI_MONOX] [numeric](5, 0) NOT NULL,
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DDI_DC_DAYS_SCREEN_AMOUNT] [numeric](5, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RADIDC0_DDI_DC_GCNSEQNO_SCREEN_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RADIDC0_DDI_DC_GCNSEQNO_SCREEN_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIGE0_DDI_GCNSEQNO_EXCEPT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIGE0_DDI_GCNSEQNO_EXCEPT](
	[DDI_MONOX] [numeric](5, 0) NOT NULL,
	[SIDE_A_GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[SIDE_B_GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DDI_SL] [char](1) NOT NULL,
	[DDI_DISPLAY_ACTION_ID] [numeric](8, 0) NOT NULL,
	[COADMIN_DOSING_TEXT] [varchar](255) NULL,
	[DDI_EXCEPT_ADD_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RADIGE0_DDI_GCNSEQNO_EXCEPT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RADIGE0_DDI_GCNSEQNO_EXCEPT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMEF0_CLIN_EFFECT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMEF0_CLIN_EFFECT](
	[ADI_EFFTC] [varchar](3) NOT NULL,
	[ADI_EFFTXT] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RADIMEF0_CLIN_EFFECT_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RADIMEF0_CLIN_EFFECT_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMGC4_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMGC4_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RADIMGC4_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RADIMGC4_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMIE4_CLIN_EFFECTS_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMIE4_CLIN_EFFECTS_LINK](
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[ADI_EFFTC] [varchar](3) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RADIMIE4_CLIN_EFFECTS_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RADIMIE4_CLIN_EFFECTS_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMM0_MONOX_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMM0_MONOX_MSTR](
	[DDI_MONOX] [numeric](5, 0) NOT NULL,
	[MONOX_TITLE] [varchar](255) NOT NULL,
	[DDI_SL] [char](1) NOT NULL,
	[DDI_DISPLAY_ACTION_ID] [numeric](8, 0) NOT NULL,
	[SIDE_A_DDI_CODEX] [numeric](5, 0) NOT NULL,
	[SIDE_B_DDI_CODEX] [numeric](5, 0) NOT NULL,
	[DDI_PHARMACODYNAMIC_IND] [char](1) NOT NULL,
	[DDI_PHARMACOKINETIC_IND] [char](1) NOT NULL,
	[MONOX_END_DT] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RADIMM0_MONOX_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RADIMM0_MONOX_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMMA5_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMMA5_MSTR](
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[DDI_DES] [varchar](60) NULL,
	[DDI_SL] [varchar](1) NULL,
	[DDI_MONOX] [numeric](5, 0) NULL,
	[DDI_PGEDI] [varchar](9) NULL,
	[DDI_TREE] [numeric](5, 0) NULL,
	[DDI_MFGI] [varchar](1) NULL,
	[DDI_TRIALI] [varchar](1) NULL,
	[DDI_CASEI] [varchar](1) NULL,
	[DDI_ABSI] [varchar](1) NULL,
	[DDI_IVASI] [varchar](1) NULL,
	[DDI_REVI] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RADIMMA5_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RADIMMA5_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMMO5_MONO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMMO5_MONO](
	[DDI_MONOX] [numeric](5, 0) NOT NULL,
	[ADI_MONOSN] [numeric](3, 0) NOT NULL,
	[IAMIDENTN] [varchar](1) NULL,
	[IAMTEXTN] [varchar](76) NULL,
	[IAMREFCAT] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RADIMMO5_MONO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RADIMMO5_MONO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIMSL1_SEVER_LEVEL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIMSL1_SEVER_LEVEL](
	[DDI_SL] [varchar](1) NOT NULL,
	[DDI_SLSN] [numeric](2, 0) NOT NULL,
	[DDI_SLTXT] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RADIMSL1_SEVER_LEVEL_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RADIMSL1_SEVER_LEVEL_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIRGE0_DDI_RTD_GEN_EXCEPT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIRGE0_DDI_RTD_GEN_EXCEPT](
	[DDI_MONOX] [numeric](5, 0) NOT NULL,
	[SIDE_A_ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[SIDE_B_ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[DDI_SL] [char](1) NOT NULL,
	[DDI_DISPLAY_ACTION_ID] [numeric](8, 0) NOT NULL,
	[COADMIN_DOSING_TEXT] [varchar](255) NULL,
	[DDI_EXCEPT_ADD_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RADIRGE0_DDI_RTD_GEN_EXCEPT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RADIRGE0_DDI_RTD_GEN_EXCEPT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RADIRME0_DDI_RTD_MED_EXCEPT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RADIRME0_DDI_RTD_MED_EXCEPT](
	[DDI_MONOX] [numeric](5, 0) NOT NULL,
	[SIDE_A_ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[SIDE_B_ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[DDI_SL] [char](1) NOT NULL,
	[DDI_DISPLAY_ACTION_ID] [numeric](8, 0) NOT NULL,
	[COADMIN_DOSING_TEXT] [varchar](255) NULL,
	[DDI_EXCEPT_ADD_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RADIRME0_DDI_RTD_MED_EXCEPT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RADIRME0_DDI_RTD_MED_EXCEPT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAHFSD1_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAHFSD1_DESC](
	[AHFS8] [numeric](8, 0) NOT NULL,
	[AHFS_DESC] [varchar](40) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RAHFSD1_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RAHFSD1_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAHFSGC1_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAHFSGC1_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[AHFS8] [numeric](8, 0) NOT NULL,
	[AHFS_REL] [numeric](2, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RAHFSGC1_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RAHFSGC1_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAPLR0_APPL_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAPLR0_APPL_RELATION](
	[APPL_RELATION_ID] [numeric](8, 0) NOT NULL,
	[APPL_RELATION_TYPE_ID] [numeric](4, 0) NOT NULL,
	[APPL_NBR1] [varchar](20) NOT NULL,
	[APPL_TYPE_ID1] [numeric](4, 0) NOT NULL,
	[APPL_NBR2] [varchar](20) NOT NULL,
	[APPL_TYPE_ID2] [numeric](4, 0) NOT NULL,
	[APPL_RELATION_START_DT] [datetime] NOT NULL,
	[APPL_RELATION_END_DT] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RAPLR0_APPL_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RAPLR0_APPL_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAPLRT0_APPL_RELATION_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAPLRT0_APPL_RELATION_TYPE](
	[APPL_RELATION_TYPE_ID] [numeric](4, 0) NOT NULL,
	[APPL_RELATION_TYPE_DESC] [varchar](40) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RAPLRT0_APPL_RELATION_TYPE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RAPLRT0_APPL_RELATION_TYPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAPPLNA0_FDA_NDC_APPL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAPPLNA0_FDA_NDC_APPL](
	[NDC] [varchar](11) NOT NULL,
	[APPL_NO] [varchar](25) NOT NULL,
	[APPL_TYPE_CD] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RAPPLNA0_FDA_NDC_APPL_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RAPPLNA0_FDA_NDC_APPL_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAPPLSL0_FDA_NDC_NDA_ANDA]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAPPLSL0_FDA_NDC_NDA_ANDA](
	[NDC] [varchar](11) NOT NULL,
	[NDA_IND] [numeric](1, 0) NOT NULL,
	[ANDA_IND] [numeric](1, 0) NOT NULL,
	[LISTING_SEQ_NO] [numeric](7, 0) NULL,
	[TRADENAME] [varchar](125) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RAPPLSL0_FDA_NDC_NDA_ANDA_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RAPPLSL0_FDA_NDC_NDA_ANDA_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RAPPLTD0_FDA_APPL_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RAPPLTD0_FDA_APPL_TYPE](
	[APPL_TYPE_CD] [numeric](4, 0) NOT NULL,
	[APPL_TYPE_CD_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RAPPLTD0_FDA_APPL_TYPE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RAPPLTD0_FDA_APPL_TYPE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RATCD0_ATC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RATCD0_ATC_DESC](
	[ATC] [varchar](7) NOT NULL,
	[ATC_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RATCD0_ATC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RATCD0_ATC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RATCGC0_ATC_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RATCGC0_ATC_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[ATC] [varchar](7) NOT NULL,
	[ATC_VER] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RATCGC0_ATC_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RATCGC0_ATC_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RCMMD0_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RCMMD0_DESC](
	[CMMC] [numeric](4, 0) NOT NULL,
	[CMRPH1] [varchar](34) NULL,
	[CMRPH2] [varchar](34) NULL,
	[CMPAT1] [varchar](25) NULL,
	[CMPAT2] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RCMMD0_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RCMMD0_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RCMMGC0_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RCMMGC0_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[CMMC] [numeric](4, 0) NOT NULL,
	[CMMC_RN] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RCMMGC0_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RCMMGC0_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RCQDNDC0_DISP_CLNQTY_NDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RCQDNDC0_DISP_CLNQTY_NDC](
	[NDC] [varchar](11) NOT NULL,
	[CLNQTY_SUBUNIT_QTY] [numeric](34, 17) NULL,
	[CLNQTY_SUBUOM_DESC] [varchar](70) NOT NULL,
	[CLNQTY_PKG_DESC] [varchar](50) NULL,
	[CLNQTY_DESC] [varchar](255) NOT NULL,
	[ERX_QTY] [numeric](34, 17) NOT NULL,
	[ERX_SCRIPT_UOM_DESC] [varchar](50) NOT NULL,
	[ERX_SCRIPT_POTUNIT_CD] [varchar](10) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RCQDNDC0_DISP_CLNQTY_NDC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RCQDNDC0_DISP_CLNQTY_NDC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RCQMED0_CLNQTY_MEDID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RCQMED0_CLNQTY_MEDID](
	[MEDID] [numeric](8, 0) NOT NULL,
	[MEDID_SN] [numeric](8, 0) NOT NULL,
	[CLNQTY_SUBUNIT_QTY] [numeric](18, 7) NULL,
	[CLNQTY_SUBUOM_DESC] [varchar](70) NOT NULL,
	[CLNQTY_PKG_DESC] [varchar](50) NULL,
	[CLNQTY_DESC] [varchar](255) NOT NULL,
	[ERX_QTY] [numeric](18, 7) NOT NULL,
	[ERX_SCRIPT_UOM_DESC] [varchar](50) NOT NULL,
	[ERX_SCRIPT_POTUNIT_CD] [varchar](10) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RCQMED0_CLNQTY_MEDID_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RCQMED0_CLNQTY_MEDID_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RCQNDC0_CLNQTY_NDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RCQNDC0_CLNQTY_NDC](
	[NDC] [varchar](11) NOT NULL,
	[MEDID] [numeric](8, 0) NOT NULL,
	[CLNQTY_SUBUNIT_QTY] [numeric](18, 7) NULL,
	[CLNQTY_SUBUOM_DESC] [varchar](70) NOT NULL,
	[CLNQTY_PKG_DESC] [varchar](50) NULL,
	[CLNQTY_DESC] [varchar](255) NOT NULL,
	[ERX_QTY] [numeric](18, 7) NOT NULL,
	[ERX_SCRIPT_UOM_DESC] [varchar](50) NOT NULL,
	[ERX_SCRIPT_POTUNIT_CD] [varchar](10) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RCQNDC0_CLNQTY_NDC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RCQNDC0_CLNQTY_NDC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMAGD1_ALRGN_GRP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMAGD1_ALRGN_GRP_DESC](
	[DAM_ALRGN_GRP] [numeric](6, 0) NOT NULL,
	[DAM_ALRGN_GRP_DESC] [varchar](50) NULL,
	[DAM_GRP_POTENTIALLY_INACTV_IND] [numeric](1, 0) NULL,
	[DAM_ALRGN_GRP_STATUS_CD] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMAGD1_ALRGN_GRP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMAGD1_ALRGN_GRP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMAPM0_ALRGN_PICKLIST_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMAPM0_ALRGN_PICKLIST_MSTR](
	[DAM_CONCEPT_ID] [numeric](8, 0) NOT NULL,
	[DAM_CONCEPT_ID_TYP] [numeric](3, 0) NOT NULL,
	[DAM_CONCEPT_ID_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMAPM0_ALRGN_PICKLIST_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMAPM0_ALRGN_PICKLIST_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMCA0_CONCEPT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMCA0_CONCEPT](
	[DAM_CONCEPT_ID] [numeric](8, 0) NOT NULL,
	[DAM_CONCEPT_ID_TYP] [numeric](3, 0) NOT NULL,
	[DAM_CONCEPT_ID_DESC] [varchar](50) NOT NULL,
	[DAM_PICKLIST_IND] [varchar](1) NOT NULL,
	[DAM_MED_IND] [varchar](1) NOT NULL,
	[DAM_FOOD_IND] [varchar](1) NOT NULL,
	[DAM_ENVIRON_AGENT_IND] [varchar](1) NOT NULL,
	[DAM_NON_ALRGN_IND] [varchar](1) NOT NULL,
	[DAM_CONCEPT_STATUS_CD] [varchar](1) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RDAMCA0_CONCEPT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RDAMCA0_CONCEPT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMCAS0_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMCAS0_STATUS_DESC](
	[DAM_CONCEPT_STATUS_CD] [varchar](1) NOT NULL,
	[DAM_CONCEPT_STATUS_CD_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RDAMCAS0_STATUS_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RDAMCAS0_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMCD0_PICKLIST_CON_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMCD0_PICKLIST_CON_TYP_DESC](
	[DAM_CONCEPT_ID_TYP] [numeric](3, 0) NOT NULL,
	[DAM_CONCEPT_ID_TYP_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMCD0_PICKLIST_CON_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMCD0_PICKLIST_CON_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMCSD1_XSENSIT_ALLERGY_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMCSD1_XSENSIT_ALLERGY_DESC](
	[DAM_ALRGN_XSENSE] [numeric](4, 0) NOT NULL,
	[DAM_ALRGN_XSENSE_DESC] [varchar](50) NULL,
	[DAM_XSENSE_POTENTIAL_INCTV_IND] [numeric](1, 0) NULL,
	[DAM_ALRGN_XSENSE_STATUS_CD] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMCSD1_XSENSIT_ALLERGY_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMCSD1_XSENSIT_ALLERGY_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[DAM_ALRGN_GRP] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMGHC0_HIC_ALRGN_GRP_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMGHC0_HIC_ALRGN_GRP_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMGRH0_ALRGN_GRP_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMGRH0_ALRGN_GRP_HIST](
	[REPL_DAM_ALRGN_GRP] [numeric](6, 0) NOT NULL,
	[PREV_DAM_ALRGN_GRP] [numeric](6, 0) NOT NULL,
	[DAM_ALRGN_GRP_REPL_EFF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMGRH0_ALRGN_GRP_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMGRH0_ALRGN_GRP_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMGSD0_GRP_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMGSD0_GRP_STATUS_DESC](
	[DAM_ALRGN_GRP_STATUS_CD] [numeric](1, 0) NOT NULL,
	[DAM_ALRGN_GRP_STATUS_CD_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMGSD0_GRP_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMGSD0_GRP_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMGX0_ALRGN_GRP_XSENSE_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMGX0_ALRGN_GRP_XSENSE_LINK](
	[DAM_ALRGN_GRP] [numeric](6, 0) NOT NULL,
	[DAM_ALRGN_XSENSE] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMGX0_ALRGN_GRP_XSENSE_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMGX0_ALRGN_GRP_XSENSE_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMHHA0_HIC_HICL_ALG_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMHHA0_HIC_HICL_ALG_LINK](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[DAM_ALRGN_HIC_SEQN] [numeric](6, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RDAMHHA0_HIC_HICL_ALG_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RDAMHHA0_HIC_HICL_ALG_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMXHC0_HIC_ALRGN_XSENSE_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMXHC0_HIC_ALRGN_XSENSE_LINK](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[DAM_ALRGN_XSENSE] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMXHC0_HIC_ALRGN_XSENSE_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMXHC0_HIC_ALRGN_XSENSE_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMXSD0_XSENSE_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMXSD0_XSENSE_STATUS_DESC](
	[DAM_ALRGN_XSENSE_STATUS_CD] [numeric](1, 0) NOT NULL,
	[DAM_ALRGN_XSENSE_STATUS_CD_DSC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMXSD0_XSENSE_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMXSD0_XSENSE_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDAMXSH0_ALRGN_XSENSE_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDAMXSH0_ALRGN_XSENSE_HIST](
	[REPL_DAM_ALRGN_XSENSE] [numeric](4, 0) NOT NULL,
	[PREV_DAM_ALRGN_XSENSE] [numeric](4, 0) NOT NULL,
	[DAM_ALRGN_XSENSE_REPL_EFF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDAMXSH0_ALRGN_XSENSE_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDAMXSH0_ALRGN_XSENSE_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDCCD0_DRUG_CAT_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDCCD0_DRUG_CAT_DESC](
	[DCC] [varchar](1) NOT NULL,
	[DCC_DESC] [varchar](40) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDCCD0_DRUG_CAT_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDCCD0_DRUG_CAT_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDCMDD0_CONTRA_DRUG_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDCMDD0_CONTRA_DRUG_DESC](
	[DDXCN] [numeric](5, 0) NOT NULL,
	[DDXCN_DRUG_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDCMDD0_CONTRA_DRUG_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDCMDD0_CONTRA_DRUG_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DDXCN] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDCMGC0_CONTRA_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDCMGC0_CONTRA_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDCMMA1_CONTRA_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDCMMA1_CONTRA_MSTR](
	[DDXCN] [numeric](5, 0) NOT NULL,
	[DDXCN_SN] [numeric](2, 0) NOT NULL,
	[FDBDX] [varchar](9) NULL,
	[DDXCN_SL] [varchar](1) NULL,
	[DDXCN_REF] [varchar](26) NULL,
	[DXID] [numeric](8, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDCMMA1_CONTRA_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDCMMA1_CONTRA_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDCMRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDCMRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[DDXCN] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDCMRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDCMRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDCMRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDCMRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[DDXCN] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDCMRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDCMRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDCMSL0_SEVER_LEVEL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDCMSL0_SEVER_LEVEL](
	[DDXCN_SL] [varchar](1) NOT NULL,
	[DDXCN_SL_DESC] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RDDCMSL0_SEVER_LEVEL_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RDDCMSL0_SEVER_LEVEL_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDIMAG0_AGENT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDIMAG0_AGENT](
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[DDI_AGSN] [numeric](3, 0) NOT NULL,
	[DDI_AGD] [varchar](41) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDIMAG0_AGENT_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDIMAG0_AGENT_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDIMIN0_NDC_INACTV_DDIM_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDIMIN0_NDC_INACTV_DDIM_LINK](
	[DDI_NDC] [varchar](11) NOT NULL,
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[DDI_NDC_HICSEQN] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDIMIN0_NDC_INACTV_DDIM_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDIMIN0_NDC_INACTV_DDIM_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDIMRD0_REF_CATEGORY]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDIMRD0_REF_CATEGORY](
	[IAMREFCAT] [varchar](1) NOT NULL,
	[IAMREFCATD] [varchar](40) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDIMRD0_REF_CATEGORY_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDIMRD0_REF_CATEGORY_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDIMRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDIMRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDIMRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDIMRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDDIMRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDDIMRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[DDI_CODEX] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDDIMRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDDIMRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDFIMGC0_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDFIMGC0_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[FDCDE] [numeric](3, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDFIMGC0_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDFIMGC0_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDFIMMA0_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDFIMMA0_MSTR](
	[FDCDE] [numeric](3, 0) NOT NULL,
	[DNAME] [varchar](21) NULL,
	[FD_SL] [varchar](1) NULL,
	[RESULT] [varchar](45) NULL,
	[FDMSG1] [varchar](27) NULL,
	[FDMSG2] [varchar](27) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDFIMMA0_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDFIMMA0_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDFIMMO0_MONO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDFIMMO0_MONO](
	[FDCDE] [numeric](3, 0) NOT NULL,
	[FDCDE_SN] [numeric](3, 0) NOT NULL,
	[TXTCDE] [varchar](1) NULL,
	[FDTXT] [varchar](76) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDFIMMO0_MONO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDFIMMO0_MONO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDFIMRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDFIMRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[FDCDE] [numeric](3, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDFIMRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDFIMRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDFIMRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDFIMRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[FDCDE] [numeric](3, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDFIMRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDFIMRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMCR0_CLIN_REVIEW_STATUS]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMCR0_CLIN_REVIEW_STATUS](
	[DLIM_DRUG_ID] [numeric](8, 0) NOT NULL,
	[DLIM_DRUG_ID_TYP_CODE] [varchar](2) NOT NULL,
	[DLIM_STATUS_CODE] [varchar](2) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMCR0_CLIN_REVIEW_STATUS_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMCR0_CLIN_REVIEW_STATUS_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMDD0_DOC_LEVEL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMDD0_DOC_LEVEL_DESC](
	[DLIM_DOC_LEVEL_CODE] [varchar](2) NOT NULL,
	[DLIM_DOC_LEVEL_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMDD0_DOC_LEVEL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMDD0_DOC_LEVEL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMDI0_DRUG_GRP_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMDI0_DRUG_GRP_ID](
	[DLIM_DRUG_GRP_ID] [numeric](5, 0) NOT NULL,
	[DLIM_DRUG_GRP_ID_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMDI0_DRUG_GRP_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMDI0_DRUG_GRP_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMDR0_DRUG_ID_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMDR0_DRUG_ID_TYP_DESC](
	[DLIM_DRUG_ID_TYP_CODE] [varchar](2) NOT NULL,
	[DLIM_DRUG_ID_TYP_CODE_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMDR0_DRUG_ID_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMDR0_DRUG_ID_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMGC1_GCNSEQNO_DRUG_GROUP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMGC1_GCNSEQNO_DRUG_GROUP](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DLIM_DRUG_GRP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMGC1_GCNSEQNO_DRUG_GROUP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMGC1_GCNSEQNO_DRUG_GROUP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMID0_INTERFERENCE_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMID0_INTERFERENCE_TYP_DESC](
	[DLIM_INTER_TYP_CODE] [varchar](2) NOT NULL,
	[DLIM_INTER_TYP_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMID0_INTERFERENCE_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMID0_INTERFERENCE_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMMA1_LAB_INTERFERENCE_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMMA1_LAB_INTERFERENCE_MSTR](
	[DLIM_DRUG_GRP_ID] [numeric](5, 0) NOT NULL,
	[MTL_SPEC_LAB_ID] [numeric](8, 0) NOT NULL,
	[DLIM_INTER_TYP_CODE] [varchar](2) NOT NULL,
	[DLIM_DOC_LEVEL_CODE] [varchar](2) NOT NULL,
	[DLIM_MONOGRAPH_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMMA1_LAB_INTERFERENCE_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMMA1_LAB_INTERFERENCE_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMMI0_MONO_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMMI0_MONO_ID](
	[DLIM_MONOGRAPH_ID] [numeric](8, 0) NOT NULL,
	[DLIM_MONOGRAPH_TITLE] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMMI0_MONO_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMMI0_MONO_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMMO1_MONO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMMO1_MONO](
	[DLIM_MONOGRAPH_ID] [numeric](8, 0) NOT NULL,
	[DLIM_TEXT_SEQNO] [numeric](5, 0) NOT NULL,
	[DLIM_TXT_TYP_CODE] [varchar](2) NULL,
	[DLIM_TEXT] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMMO1_MONO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMMO1_MONO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[DLIM_DRUG_GRP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMRM0_ROUTED_MED_DRUG_GROUP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMRM0_ROUTED_MED_DRUG_GROUP](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[DLIM_DRUG_GRP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMRM0_ROUTED_MED_DRUG_GROUP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMRM0_ROUTED_MED_DRUG_GROUP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMSD0_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMSD0_STATUS_DESC](
	[DLIM_STATUS_CODE] [varchar](2) NOT NULL,
	[DLIM_STATUS_CODE_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMSD0_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMSD0_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDLIMTD0_MONO_TXT_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDLIMTD0_MONO_TXT_TYP_DESC](
	[DLIM_TXT_TYP_CODE] [varchar](2) NOT NULL,
	[DLIM_TXT_TYP_CODE_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDLIMTD0_MONO_TXT_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDLIMTD0_MONO_TXT_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDOSED2_DOSE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDOSED2_DOSE_DESC](
	[GCDF] [varchar](2) NOT NULL,
	[DOSE] [varchar](10) NULL,
	[GCDF_DESC] [varchar](40) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDOSED2_DOSE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDOSED2_DOSE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDOSSRC0_DOSING_AGE_SOURCE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDOSSRC0_DOSING_AGE_SOURCE](
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[DOSING_AGE_SOURCE_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDOSSRC0_DOSING_AGE_SOURCE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDOSSRC0_DOSING_AGE_SOURCE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDPTCL0_CLASS_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDPTCL0_CLASS_ID](
	[DPT_CLASS_ID] [numeric](8, 0) NOT NULL,
	[DPT_CLASS_DESC] [varchar](60) NULL,
	[DPT_ALLOWANCE] [numeric](2, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDPTCL0_CLASS_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDPTCL0_CLASS_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDPTGC0_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDPTGC0_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DPT_CLASS_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDPTGC0_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDPTGC0_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDPTRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDPTRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[DPT_CLASS_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDPTRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDPTRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDPTRTM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDPTRTM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[DPT_CLASS_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDPTRTM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDPTRTM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCAE0_AGE_EXCLUSION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCAE0_AGE_EXCLUSION](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DR2_RT] [varchar](3) NOT NULL,
	[EXCLUSION_LOAGED] [numeric](5, 0) NOT NULL,
	[EXCLUSION_HIAGED] [numeric](5, 0) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DR2_DOSTPI] [varchar](2) NOT NULL,
	[NEOM_LOW_GEST_BIRTH_AGE_WEEKS] [numeric](2, 0) NOT NULL,
	[NEOM_HIGH_GEST_BIRTH_AGE_WEEKS] [numeric](2, 0) NOT NULL,
	[NEOM_LOW_CURRENT_WEIGHT_GRAMS] [numeric](5, 0) NOT NULL,
	[NEOM_HIGH_CURRENT_WEIGHT_GRAMS] [numeric](5, 0) NOT NULL,
	[EXCLUSION_REASON_CD] [numeric](8, 0) NOT NULL,
	[DR2_SL] [varchar](1) NOT NULL,
	[DXID] [numeric](8, 0) NOT NULL,
	[AVAILABLE_PRECAUTION_IND] [numeric](1, 0) NOT NULL,
	[EXCLUSION_MESSAGE_TEXT] [varchar](750) NOT NULL,
	[NEXT_SCREENING_DOSE_TEXT] [varchar](510) NULL,
	[NEXT_SCREENING_DOSE_AGE_TEXT] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCAE0_AGE_EXCLUSION_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCAE0_AGE_EXCLUSION_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCAR0_EXCLUSION_REASON]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCAR0_EXCLUSION_REASON](
	[EXCLUSION_REASON_CD] [numeric](8, 0) NOT NULL,
	[EXCLUSION_REASON_TEXT_LONG] [varchar](750) NOT NULL,
	[EXCLUSION_REASON_TEXT_SHORT] [varchar](255) NOT NULL,
	[EXCLUSION_STATUS_CD] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCAR0_EXCLUSION_REASON_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCAR0_EXCLUSION_REASON_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCAT0_ADJ_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCAT0_ADJ_TYPE](
	[DOSING_ADJ_TYPE_CD] [numeric](4, 0) NOT NULL,
	[DOSING_ADJ_TYPE_DESC] [varchar](70) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCAT0_ADJ_TYPE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCAT0_ADJ_TYPE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCCD0_CALC_REQ_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCCD0_CALC_REQ_TYPE_DESC](
	[UNITS_CTYP] [numeric](1, 0) NOT NULL,
	[UNITS_CTYP_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCCD0_CALC_REQ_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCCD0_CALC_REQ_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCCVU0_UNITS_CONVERSION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCCVU0_UNITS_CONVERSION](
	[DCNV_PUI] [varchar](2) NOT NULL,
	[UNITS_RUI] [varchar](2) NOT NULL,
	[DCNV_MTHI] [varchar](1) NULL,
	[DCNV_CNVF] [numeric](15, 5) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCCVU0_UNITS_CONVERSION_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCCVU0_UNITS_CONVERSION_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCDD0_DOSE_CALC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCDD0_DOSE_CALC_DESC](
	[UNITS_DCC] [varchar](1) NOT NULL,
	[UNITS_DCC_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCDD0_DOSE_CALC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCDD0_DOSE_CALC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCDTD0_DOSE_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCDTD0_DOSE_TYPE_DESC](
	[DR2_DOSTPI] [varchar](2) NOT NULL,
	[DOSTPI_DES] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCDTD0_DOSE_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCDTD0_DOSE_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCEX0_EXCLUSIONS]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCEX0_EXCLUSIONS](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[EXCLUSION_CODE] [numeric](1, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCEX0_EXCLUSIONS_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCEX0_EXCLUSIONS_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCMA2_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCMA2_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DR2_RT] [varchar](3) NOT NULL,
	[DR2_LOAGED] [numeric](5, 0) NOT NULL,
	[DR2_HIAGED] [numeric](5, 0) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DR2_DOSTPI] [varchar](2) NOT NULL,
	[DR2_LODOSD] [numeric](8, 3) NULL,
	[DR2_LODOSU] [varchar](2) NULL,
	[DR2_HIDOSD] [numeric](8, 3) NULL,
	[DR2_HIDOSU] [varchar](2) NULL,
	[DR2_MXDOSD] [numeric](8, 3) NULL,
	[DR2_MXDOSU] [varchar](2) NULL,
	[DR2_LOFREQ] [numeric](4, 2) NULL,
	[DR2_HIFREQ] [numeric](4, 2) NULL,
	[DR2_RENIMP] [varchar](1) NULL,
	[DR2_CRCLTH] [numeric](3, 0) NULL,
	[DR2_CRCLU] [varchar](2) NULL,
	[DR2_LODOTX] [numeric](5, 0) NULL,
	[DR2_HIDOTX] [numeric](5, 0) NULL,
	[DR2_MXDOTX] [numeric](5, 0) NULL,
	[DR2_HEPIMP] [varchar](1) NULL,
	[DR2_THAFLO] [numeric](5, 2) NULL,
	[DR2_THAFHI] [numeric](5, 2) NULL,
	[DR2_THAFU] [varchar](2) NULL,
	[DR2_MX1DOS] [numeric](8, 3) NULL,
	[DR2_MX1DSU] [varchar](2) NULL,
	[DR2_MXLIFD] [numeric](8, 3) NULL,
	[DR2_MXLIFU] [varchar](2) NULL,
	[DXID] [numeric](8, 0) NULL,
	[NTE_SINGLE_DOSE] [numeric](8, 3) NOT NULL,
	[NTE_SINGLE_DOSE_UNIT_CODE] [varchar](2) NOT NULL,
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCMA2_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCMA2_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCMD0_MATH_PROCESS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCMD0_MATH_PROCESS_DESC](
	[DCNV_MTHI] [varchar](1) NOT NULL,
	[DCNV_MTHI_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCMD0_MATH_PROCESS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCMD0_MATH_PROCESS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCMF0_MONO_FORMAT_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCMF0_MONO_FORMAT_DESC](
	[DRC_MONO_FORMAT_CD] [numeric](4, 0) NOT NULL,
	[DRC_MONO_FORMAT_CD_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCMF0_MONO_FORMAT_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCMF0_MONO_FORMAT_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCMS0_MONO_SECTION_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCMS0_MONO_SECTION_DESC](
	[DRC_MONO_SECTION_CD] [numeric](4, 0) NOT NULL,
	[DRC_MONO_SECTION_CD_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCMS0_MONO_SECTION_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCMS0_MONO_SECTION_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCNMA1_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCNMA1_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DR2_RT] [varchar](3) NOT NULL,
	[DR2_LOAGED] [numeric](5, 0) NOT NULL,
	[DR2_HIAGED] [numeric](5, 0) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DR2_DOSTPI] [varchar](2) NOT NULL,
	[NEOM_LOW_GEST_BIRTH_AGE_WEEKS] [numeric](2, 0) NOT NULL,
	[NEOM_HIGH_GEST_BIRTH_AGE_WEEKS] [numeric](2, 0) NOT NULL,
	[NEOM_LOW_CURRENT_WEIGHT_GRAMS] [numeric](5, 0) NOT NULL,
	[NEOM_HIGH_CURRENT_WEIGHT_GRAMS] [numeric](5, 0) NOT NULL,
	[NEOM_GEST_BIRTH_AGE_REQ_IND] [varchar](1) NULL,
	[NEOM_WEIGHT_REQ_IND] [varchar](1) NULL,
	[DR2_LODOSD] [numeric](8, 3) NULL,
	[DR2_LODOSU] [varchar](2) NULL,
	[DR2_HIDOSD] [numeric](8, 3) NULL,
	[DR2_HIDOSU] [varchar](2) NULL,
	[DR2_MXDOSD] [numeric](8, 3) NULL,
	[DR2_MXDOSU] [varchar](2) NULL,
	[DR2_LOFREQ] [numeric](4, 2) NULL,
	[DR2_HIFREQ] [numeric](4, 2) NULL,
	[DR2_RENIMP] [varchar](1) NULL,
	[DR2_CRCLTH] [numeric](3, 0) NULL,
	[DR2_CRCLU] [varchar](2) NULL,
	[DR2_LODOTX] [numeric](5, 0) NULL,
	[DR2_HIDOTX] [numeric](5, 0) NULL,
	[DR2_MXDOTX] [numeric](5, 0) NULL,
	[DR2_HEPIMP] [varchar](1) NULL,
	[DR2_THAFLO] [numeric](5, 2) NULL,
	[DR2_THAFHI] [numeric](5, 2) NULL,
	[DR2_THAFU] [varchar](2) NULL,
	[DR2_MX1DOS] [numeric](8, 3) NULL,
	[DR2_MX1DSU] [varchar](2) NULL,
	[DR2_MXLIFD] [numeric](8, 3) NULL,
	[DR2_MXLIFU] [varchar](2) NULL,
	[DXID] [numeric](8, 0) NULL,
	[NTE_SINGLE_DOSE] [numeric](8, 3) NOT NULL,
	[NTE_SINGLE_DOSE_UNIT_CODE] [varchar](2) NOT NULL,
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCNMA1_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCNMA1_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCNMA2_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCNMA2_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DR2_RT] [varchar](3) NOT NULL,
	[DR2_LOAGED] [numeric](5, 0) NOT NULL,
	[DR2_HIAGED] [numeric](5, 0) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DR2_DOSTPI] [varchar](2) NOT NULL,
	[NEOM_LOW_GEST_BIRTH_AGE_WEEKS] [numeric](2, 0) NOT NULL,
	[NEOM_HIGH_GEST_BIRTH_AGE_WEEKS] [numeric](2, 0) NOT NULL,
	[LOW_CURRENT_WEIGHT_GRAMS] [numeric](6, 0) NOT NULL,
	[HIGH_CURRENT_WEIGHT_GRAMS] [numeric](6, 0) NOT NULL,
	[NEOM_GEST_BIRTH_AGE_REQ_IND] [varchar](1) NULL,
	[WEIGHT_REQ_IND] [varchar](1) NULL,
	[DR2_LODOSD] [numeric](8, 3) NULL,
	[DR2_LODOSU] [varchar](2) NULL,
	[DR2_HIDOSD] [numeric](8, 3) NULL,
	[DR2_HIDOSU] [varchar](2) NULL,
	[DR2_MXDOSD] [numeric](8, 3) NULL,
	[DR2_MXDOSU] [varchar](2) NULL,
	[DR2_LOFREQ] [numeric](5, 3) NULL,
	[DR2_HIFREQ] [numeric](5, 3) NULL,
	[DR2_RENIMP] [varchar](1) NULL,
	[DR2_CRCLTH] [numeric](3, 0) NULL,
	[DR2_CRCLU] [varchar](2) NULL,
	[DR2_LODOTX] [numeric](5, 0) NULL,
	[DR2_HIDOTX] [numeric](5, 0) NULL,
	[DR2_MXDOTX] [numeric](5, 0) NULL,
	[DR2_HEPIMP] [varchar](1) NULL,
	[DR2_THAFLO] [numeric](5, 2) NULL,
	[DR2_THAFHI] [numeric](5, 2) NULL,
	[DR2_THAFU] [varchar](2) NULL,
	[DR2_MX1DOS] [numeric](8, 3) NULL,
	[DR2_MX1DSU] [varchar](2) NULL,
	[DR2_MXLIFD] [numeric](8, 3) NULL,
	[DR2_MXLIFU] [varchar](2) NULL,
	[DXID] [numeric](8, 0) NULL,
	[NTE_SINGLE_DOSE] [numeric](8, 3) NOT NULL,
	[NTE_SINGLE_DOSE_UNIT_CODE] [varchar](2) NOT NULL,
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RDRCNMA2_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RDRCNMA2_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCRL0_RENAL_MONO_LINE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCRL0_RENAL_MONO_LINE](
	[REN_MONO_ID] [numeric](8, 0) NOT NULL,
	[REN_MONO_LINE_NUMBER] [numeric](8, 0) NOT NULL,
	[REN_MONO_SECTION_CD] [numeric](4, 0) NOT NULL,
	[REN_MONO_FORMAT_CD] [numeric](4, 0) NOT NULL,
	[REN_MONO_LINE_TEXT] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCRL0_RENAL_MONO_LINE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCRL0_RENAL_MONO_LINE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCRM0_RENAL_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCRM0_RENAL_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DR2_RT] [varchar](3) NOT NULL,
	[REN_LOAGED] [numeric](5, 0) NOT NULL,
	[REN_HIAGED] [numeric](5, 0) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DR2_DOSTPI] [varchar](2) NOT NULL,
	[REN_LOCRCL] [numeric](3, 0) NOT NULL,
	[REN_HICRCL] [numeric](3, 0) NOT NULL,
	[REN_SORT_ORDER] [numeric](3, 0) NOT NULL,
	[DOSING_ADJ_TYPE_CD] [numeric](4, 0) NOT NULL,
	[REN_LODOSD] [numeric](8, 3) NULL,
	[REN_LODOSU] [varchar](2) NULL,
	[REN_HIDOSD] [numeric](8, 3) NULL,
	[REN_HIDOSU] [varchar](2) NULL,
	[REN_MXDOSD] [numeric](8, 3) NULL,
	[REN_MXDOSU] [varchar](2) NULL,
	[REN_LOFREQ] [numeric](4, 2) NULL,
	[REN_HIFREQ] [numeric](4, 2) NULL,
	[REN_MX1DOS] [numeric](8, 3) NULL,
	[REN_MX1DSU] [varchar](2) NULL,
	[DXID] [numeric](8, 0) NOT NULL,
	[REN_NTE_SINGLE_DOSE] [numeric](8, 3) NULL,
	[REN_NTE_SINGLE_DOSE_UNIT_CODE] [varchar](2) NULL,
	[REN_FOOTNOTE] [varchar](255) NULL,
	[REN_MONO_ID] [numeric](8, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCRM0_RENAL_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCRM0_RENAL_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCRTD0_ROUTE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCRTD0_ROUTE_DESC](
	[DR2_RT] [varchar](3) NOT NULL,
	[ROUTES_DES] [varchar](22) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCRTD0_ROUTE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCRTD0_ROUTE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCSCD0_EXCLUSION_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCSCD0_EXCLUSION_STATUS_DESC](
	[EXCLUSION_STATUS_CD] [numeric](8, 0) NOT NULL,
	[EXCLUSION_STATUS_CD_DESC] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCSCD0_EXCLUSION_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCSCD0_EXCLUSION_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCSD0_SEVER_LEVEL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCSD0_SEVER_LEVEL_DESC](
	[DR2_SL] [varchar](1) NOT NULL,
	[DR2_SL_DESC] [varchar](255) NOT NULL,
	[DR2_SL_MESSAGE_TEXT] [varchar](255) NOT NULL,
	[GERI_SL] [varchar](1) NULL,
	[PEDI_SL] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCSD0_SEVER_LEVEL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCSD0_SEVER_LEVEL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCUND0_UNITS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCUND0_UNITS_DESC](
	[DR2_UNITS] [varchar](2) NOT NULL,
	[UNITS_DESC] [varchar](12) NULL,
	[UNITS_CTYP] [varchar](1) NULL,
	[UNITS_DCC] [varchar](1) NULL,
	[UNITS_RUI] [varchar](2) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCUND0_UNITS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCUND0_UNITS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RDRCXRT0_XREF]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RDRCXRT0_XREF](
	[GCRT2] [varchar](2) NOT NULL,
	[DR2_RT] [varchar](3) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RDRCXRT0_XREF_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RDRCXRT0_XREF_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCCTD0_ETC_CHANGE_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCCTD0_ETC_CHANGE_TYPE_DESC](
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NOT NULL,
	[ETC_CHANGE_TYPE_CODE_DESC] [varchar](90) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCCTD0_ETC_CHANGE_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCCTD0_ETC_CHANGE_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCGC0_ETC_GCNSEQNO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCGC0_ETC_GCNSEQNO](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_COMMON_USE_IND] [varchar](1) NULL,
	[ETC_DEFAULT_USE_IND] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCGC0_ETC_GCNSEQNO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCGC0_ETC_GCNSEQNO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCGCH0_ETC_GCNSEQNO_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCGCH0_ETC_GCNSEQNO_HIST](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_REVISION_SEQNO] [numeric](5, 0) NOT NULL,
	[ETC_COMMON_USE_IND] [varchar](1) NULL,
	[ETC_DEFAULT_USE_IND] [varchar](1) NULL,
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NULL,
	[ETC_EFFECTIVE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCGCH0_ETC_GCNSEQNO_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCGCH0_ETC_GCNSEQNO_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCHCH0_ETC_HICSEQN_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCHCH0_ETC_HICSEQN_HIST](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_REVISION_SEQNO] [numeric](5, 0) NOT NULL,
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NULL,
	[ETC_EFFECTIVE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCHCH0_ETC_HICSEQN_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCHCH0_ETC_HICSEQN_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCHCL0_ETC_HICLSEQNO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCHCL0_ETC_HICLSEQNO](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCHCL0_ETC_HICLSEQNO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCHCL0_ETC_HICLSEQNO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCHIC0_ETC_HICSEQN]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCHIC0_ETC_HICSEQN](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCHIC0_ETC_HICSEQN_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCHIC0_ETC_HICSEQN_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCHLH0_ETC_HICLSEQNO_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCHLH0_ETC_HICLSEQNO_HIST](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_REVISION_SEQNO] [numeric](5, 0) NOT NULL,
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NULL,
	[ETC_EFFECTIVE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCHLH0_ETC_HICLSEQNO_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCHLH0_ETC_HICLSEQNO_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCMDH0_ETC_MEDID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCMDH0_ETC_MEDID_HIST](
	[MEDID] [numeric](8, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_REVISION_SEQNO] [numeric](5, 0) NOT NULL,
	[ETC_COMMON_USE_IND] [varchar](1) NULL,
	[ETC_DEFAULT_USE_IND] [varchar](1) NULL,
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NULL,
	[ETC_EFFECTIVE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCMDH0_ETC_MEDID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCMDH0_ETC_MEDID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCMED0_ETC_MEDID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCMED0_ETC_MEDID](
	[MEDID] [numeric](8, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_COMMON_USE_IND] [varchar](1) NULL,
	[ETC_DEFAULT_USE_IND] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCMED0_ETC_MEDID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCMED0_ETC_MEDID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCMNM0_ETC_MED_NAME_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCMNM0_ETC_MED_NAME_ID](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCMNM0_ETC_MED_NAME_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCMNM0_ETC_MED_NAME_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCNDC0_ETC_NDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCNDC0_ETC_NDC](
	[NDC] [varchar](11) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_COMMON_USE_IND] [varchar](1) NULL,
	[ETC_DEFAULT_USE_IND] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCNDC0_ETC_NDC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCNDC0_ETC_NDC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCNDH0_ETC_NDC_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCNDH0_ETC_NDC_HIST](
	[NDC] [varchar](11) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_REVISION_SEQNO] [numeric](5, 0) NOT NULL,
	[ETC_COMMON_USE_IND] [varchar](1) NULL,
	[ETC_DEFAULT_USE_IND] [varchar](1) NULL,
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NULL,
	[ETC_EFFECTIVE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCNDH0_ETC_NDC_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCNDH0_ETC_NDC_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCNMH0_ETC_MED_NAME_ID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCNMH0_ETC_MED_NAME_ID_HIST](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_REVISION_SEQNO] [numeric](5, 0) NOT NULL,
	[ETC_CHANGE_TYPE_CODE] [varchar](1) NULL,
	[ETC_EFFECTIVE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCNMH0_ETC_MED_NAME_ID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCNMH0_ETC_MED_NAME_ID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCSCH0_ETC_SEARCH]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCSCH0_ETC_SEARCH](
	[ETC_SEARCH_ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_PRODUCT_RELATED_ETC_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCSCH0_ETC_SEARCH_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCSCH0_ETC_SEARCH_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCTBL0_ETC_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCTBL0_ETC_ID](
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[ETC_NAME] [varchar](70) NULL,
	[ETC_ULTIMATE_CHILD_IND] [varchar](1) NULL,
	[ETC_DRUG_CONCEPT_LINK_IND] [varchar](1) NULL,
	[ETC_PARENT_ETC_ID] [numeric](8, 0) NULL,
	[ETC_FORMULARY_LEVEL_IND] [varchar](1) NULL,
	[ETC_PRESENTATION_SEQNO] [numeric](5, 0) NULL,
	[ETC_ULTIMATE_PARENT_ETC_ID] [numeric](8, 0) NULL,
	[ETC_HIERARCHY_LEVEL] [numeric](2, 0) NULL,
	[ETC_SORT_NUMBER] [numeric](5, 0) NULL,
	[ETC_RETIRED_IND] [varchar](1) NULL,
	[ETC_RETIRED_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCTBL0_ETC_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCTBL0_ETC_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RETCXRF0_ETC_HIC3_ETC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RETCXRF0_ETC_HIC3_ETC](
	[ETC_ID] [numeric](8, 0) NOT NULL,
	[HIC3_SEQN] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RETCXRF0_ETC_HIC3_ETC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RETCXRF0_ETC_HIC3_ETC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDCD0_RXN_CONCEPT_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDCD0_RXN_CONCEPT_DESC](
	[EVD_RXN_CONCEPT_DESC_KEY] [numeric](8, 0) NOT NULL,
	[EVD_RXN_SEQ_SN] [numeric](4, 0) NOT NULL,
	[EVD_RXN_CONCEPT_SOURCE_KEY] [numeric](8, 0) NOT NULL,
	[EVD_RXN_STR] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDCD0_RXN_CONCEPT_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDCD0_RXN_CONCEPT_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDCM0_CVX_MVX_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDCM0_CVX_MVX_LINK](
	[EVD_CVX_CD] [varchar](10) NOT NULL,
	[EVD_MVX_CD] [varchar](10) NOT NULL,
	[EVD_CVX_CD_DESC_SHORT] [varchar](100) NOT NULL,
	[EVD_CVX_CD_DESC_LONG] [varchar](255) NOT NULL,
	[EVD_CVX_CD_USAGE] [numeric](2, 0) NOT NULL,
	[EVD_CVX_CD_USAGE_DESC_SHORT] [varchar](100) NOT NULL,
	[EVD_CVX_CD_STATUS] [varchar](30) NULL,
	[EVD_MVX_CD_DESC] [varchar](100) NOT NULL,
	[EVD_MVX_CD_STATUS] [varchar](30) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDCM0_CVX_MVX_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDCM0_CVX_MVX_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDCPT0_EXT_CPT_CVX_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDCPT0_EXT_CPT_CVX_LINK](
	[EVD_CPT_CD] [varchar](10) NOT NULL,
	[EVD_CVX_CD] [varchar](10) NOT NULL,
	[EVD_CPT_CD_DESC] [varchar](255) NULL,
	[EVD_VACCINE_NAME] [varchar](100) NULL,
	[EVD_CPT_STATUS] [varchar](30) NULL,
	[EVD_CPT_CVX_NOTE] [varchar](255) NULL,
	[EVD_CPT_CVX_LAST_UPDATE_DT] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDCPT0_EXT_CPT_CVX_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDCPT0_EXT_CPT_CVX_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDCS0_RXN_CONCEPT_SOURCE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDCS0_RXN_CONCEPT_SOURCE](
	[EVD_RXN_CONCEPT_SOURCE_KEY] [numeric](8, 0) NOT NULL,
	[EVD_RXN_RXCUI] [varchar](8) NOT NULL,
	[EVD_RXN_SAB] [varchar](20) NOT NULL,
	[EVD_RXN_TTY] [varchar](20) NOT NULL,
	[EVD_RXN_CODE] [varchar](50) NOT NULL,
	[EVD_RXN_CODE_NO] [numeric](8, 0) NULL,
	[EVD_RXN_SUPPRESS] [varchar](1) NULL,
	[EVD_FDB_EXCLUDE_RXCUI_IND] [varchar](1) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDCS0_RXN_CONCEPT_SOURCE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDCS0_RXN_CONCEPT_SOURCE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDCVX0_EXT_VOCAB_CVX_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDCVX0_EXT_VOCAB_CVX_DESC](
	[EVD_CVX_CD] [varchar](10) NOT NULL,
	[EVD_CVX_CD_DESC_SHORT] [varchar](100) NOT NULL,
	[EVD_CVX_CD_DESC_LONG] [varchar](255) NOT NULL,
	[EVD_CVX_CD_USAGE] [numeric](2, 0) NOT NULL,
	[EVD_CVX_CD_STATUS] [varchar](30) NOT NULL,
	[EVD_CVX_CD_NONVACCINE] [varchar](30) NULL,
	[EVD_CVX_CD_ADD_DT] [datetime] NOT NULL,
	[EVD_CVX_CD_OBS_DT] [datetime] NULL,
	[EVD_CVX_LAST_UPDATE_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDCVX0_EXT_VOCAB_CVX_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDCVX0_EXT_VOCAB_CVX_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDEL0_EXT_VOCAB_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDEL0_EXT_VOCAB_LINK](
	[EVD_FDB_VOCAB_ID] [varchar](20) NOT NULL,
	[EVD_FDB_VOCAB_TYPE_ID] [numeric](4, 0) NOT NULL,
	[EVD_EXT_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_VOCAB_TYPE_ID] [numeric](4, 0) NOT NULL,
	[EVD_LINK_TYPE_ID] [numeric](4, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDEL0_EXT_VOCAB_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDEL0_EXT_VOCAB_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDEV0_EXT_VOCAB_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDEV0_EXT_VOCAB_DESC](
	[EVD_EXT_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_VOCAB_TYPE_ID] [numeric](4, 0) NOT NULL,
	[EVD_SEQ_SN] [numeric](4, 0) NOT NULL,
	[EVD_EXT_VOCAB_DESC] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDEV0_EXT_VOCAB_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDEV0_EXT_VOCAB_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDEVN0_EXT_VOCAB_NOTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDEVN0_EXT_VOCAB_NOTE](
	[EVD_EXT_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_VOCAB_TYPE_ID] [numeric](4, 0) NOT NULL,
	[EVD_SEQ_SN] [numeric](4, 0) NOT NULL,
	[EVD_EXT_VOCAB_NOTE] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDEVN0_EXT_VOCAB_NOTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDEVN0_EXT_VOCAB_NOTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDLT0_LINK_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDLT0_LINK_TYPE_DESC](
	[EVD_LINK_TYPE_ID] [numeric](4, 0) NOT NULL,
	[EVD_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[EVD_LINK_TYPE_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDLT0_LINK_TYPE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDLT0_LINK_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDMVX0_EXT_VOCAB_MVX_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDMVX0_EXT_VOCAB_MVX_DESC](
	[EVD_MVX_CD] [varchar](10) NOT NULL,
	[EVD_MVX_CD_DESC] [varchar](100) NOT NULL,
	[EVD_MVX_CD_STATUS] [varchar](30) NULL,
	[EVD_MVX_LAST_UPDATE_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDMVX0_EXT_VOCAB_MVX_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDMVX0_EXT_VOCAB_MVX_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDNCM0_NDC_CVX_MVX_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDNCM0_NDC_CVX_MVX_LINK](
	[NDC] [varchar](11) NOT NULL,
	[LBLRID] [varchar](6) NOT NULL,
	[MFG] [varchar](15) NOT NULL,
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[BN] [varchar](30) NOT NULL,
	[NDCFI] [varchar](1) NOT NULL,
	[OBSDTEC] [datetime] NULL,
	[REPACK] [varchar](1) NOT NULL,
	[LN60] [varchar](60) NOT NULL,
	[MEDID] [numeric](8, 0) NOT NULL,
	[MED_MEDID_DESC] [varchar](70) NOT NULL,
	[GENERIC_MEDID] [numeric](8, 0) NOT NULL,
	[GENERIC_MEDID_DESC] [varchar](70) NOT NULL,
	[EVD_CVX_CD] [varchar](10) NOT NULL,
	[EVD_CVX_CD_DESC_SHORT] [varchar](100) NOT NULL,
	[EVD_CVX_CD_DESC_LONG] [varchar](255) NOT NULL,
	[EVD_CVX_CD_USAGE] [numeric](2, 0) NOT NULL,
	[EVD_CVX_CD_USAGE_DESC_SHORT] [varchar](100) NOT NULL,
	[EVD_CVX_CD_STATUS] [varchar](30) NULL,
	[EVD_MVX_CD] [varchar](10) NOT NULL,
	[EVD_MVX_CD_DESC] [varchar](100) NOT NULL,
	[EVD_MVX_CD_STATUS] [varchar](30) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDNCM0_NDC_CVX_MVX_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDNCM0_NDC_CVX_MVX_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDRC0_RXN_CONCEPT_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDRC0_RXN_CONCEPT_MSTR](
	[EVD_RXN_RXCUI] [varchar](8) NOT NULL,
	[EVD_SHARED_RXCUI_IND] [varchar](1) NOT NULL,
	[EVD_PRESCRIBABLE_RXCUI_IND] [varchar](1) NOT NULL,
	[UNII_CODE] [varchar](10) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDRC0_RXN_CONCEPT_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDRC0_RXN_CONCEPT_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDRH0_RXCUI_REP_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDRH0_RXCUI_REP_HIST](
	[EVD_EXT_PREV_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_CHANGE_DT] [datetime] NOT NULL,
	[EVD_EXT_REP_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_ULT_REP_VOCAB_ID] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDRH0_RXCUI_REP_HIST_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDRH0_RXCUI_REP_HIST_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDRHD0_RXCUI_REP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDRHD0_RXCUI_REP_DESC](
	[EVD_EXT_PREV_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_CHANGE_DT] [datetime] NOT NULL,
	[EVD_EXT_SEQ_SN] [numeric](4, 0) NOT NULL,
	[EVD_EXT_REP_VOCAB_DESC] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDRHD0_RXCUI_REP_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDRHD0_RXCUI_REP_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDUR0_RXCUI_ULT_REPL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDUR0_RXCUI_ULT_REPL](
	[EVD_EXT_VOCAB_ID] [varchar](50) NOT NULL,
	[EVD_EXT_ULT_REP_VOCAB_ID] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDUR0_RXCUI_ULT_REPL_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDUR0_RXCUI_ULT_REPL_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDUSE0_EXT_VOCAB_CVX_USAGE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDUSE0_EXT_VOCAB_CVX_USAGE](
	[EVD_CVX_CD_USAGE] [numeric](2, 0) NOT NULL,
	[EVD_CVX_CD_USAGE_DESC_SHORT] [varchar](100) NOT NULL,
	[EVD_CVX_CD_USAGE_DESC_LONG] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDUSE0_EXT_VOCAB_CVX_USAGE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDUSE0_EXT_VOCAB_CVX_USAGE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDVB0_CDC_VIS_LOOKUP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDVB0_CDC_VIS_LOOKUP](
	[CDC_VIS_GDTI_DOCUMENT_CD] [varchar](13) NOT NULL,
	[CDC_VIS_FULLY_ENCODED_TEXT] [varchar](24) NOT NULL,
	[CDC_VIS_EDITION_DT] [datetime] NOT NULL,
	[CDC_VIS_DOCUMENT_TYPE_DESC] [varchar](100) NOT NULL,
	[CDC_VIS_EDITION_STATUS] [varchar](30) NULL,
	[CDC_VIS_LAST_UPDATED_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDVB0_CDC_VIS_LOOKUP_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDVB0_CDC_VIS_LOOKUP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDVD0_VOCAB_DATA_VERSION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDVD0_VOCAB_DATA_VERSION](
	[EVD_DATA_ID] [numeric](4, 0) NOT NULL,
	[EVD_DATA_DESC] [varchar](50) NOT NULL,
	[EVD_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[EVD_SOURCE_DESC] [varchar](50) NOT NULL,
	[EVD_DATA_VERSION_DT] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDVD0_VOCAB_DATA_VERSION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDVD0_VOCAB_DATA_VERSION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDVG0_CDC_CVX_VG_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDVG0_CDC_CVX_VG_LINK](
	[CDC_DATA_ID] [numeric](8, 0) NOT NULL,
	[CDC_CVX_CD] [varchar](10) NOT NULL,
	[CDC_SHORT_DESC] [varchar](100) NOT NULL,
	[CDC_VACCINE_STATUS] [varchar](30) NULL,
	[CDC_VACCINE_GROUP_NAME] [varchar](100) NULL,
	[CDC_UNCERTAIN_FORM_CVX] [varchar](10) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDVG0_CDC_CVX_VG_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDVG0_CDC_CVX_VG_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDVL0_CDC_CVX_VIS_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDVL0_CDC_CVX_VIS_LINK](
	[CDC_CVX_CD] [varchar](10) NOT NULL,
	[CDC_VIS_FULLY_ENCODED_TEXT] [varchar](24) NOT NULL,
	[CDC_CVX_VACCINE_DESC] [varchar](100) NOT NULL,
	[CDC_VIS_DOCUMENT_NAME] [varchar](100) NOT NULL,
	[CDC_VIS_EDITION_DT] [datetime] NOT NULL,
	[CDC_VIS_EDITION_STATUS] [varchar](30) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDVL0_CDC_CVX_VIS_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDVL0_CDC_CVX_VIS_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDVS0_SOURCE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDVS0_SOURCE_DESC](
	[EVD_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[EVD_SOURCE_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDVS0_SOURCE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDVS0_SOURCE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_REVDVT0_VOCAB_TYPE_DEF]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_REVDVT0_VOCAB_TYPE_DEF](
	[EVD_VOCAB_TYPE_ID] [numeric](4, 0) NOT NULL,
	[EVD_VOCAB_TYPE_DESC] [varchar](50) NOT NULL,
	[EVD_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_REVDVT0_VOCAB_TYPE_DEF_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_REVDVT0_VOCAB_TYPE_DEF_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLCMD0_CLIN_MOD_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLCMD0_CLIN_MOD_DESC](
	[FML_CLIN_CODE] [varchar](2) NOT NULL,
	[FML_CLIN_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLCMD0_CLIN_MOD_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLCMD0_CLIN_MOD_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLCSD0_ICD_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLCSD0_ICD_STATUS_DESC](
	[ICD_STATUS_CD] [varchar](1) NOT NULL,
	[ICD_STATUS_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLCSD0_ICD_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLCSD0_ICD_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLDDD0_DX_DURATION_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLDDD0_DX_DURATION_DESC](
	[DXID_DISEASE_DURATION_CD] [varchar](1) NOT NULL,
	[DXID_DISEASE_DURATION_CD_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLDDD0_DX_DURATION_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLDDD0_DX_DURATION_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLDRH0_DXID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLDRH0_DXID_HIST](
	[FMLPRVDXID] [numeric](8, 0) NOT NULL,
	[FMLREPDXID] [numeric](8, 0) NOT NULL,
	[FMLDXREPDT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLDRH0_DXID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLDRH0_DXID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLDSR0_DXID_SEARCH]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLDSR0_DXID_SEARCH](
	[SEARCH_DXID] [numeric](8, 0) NOT NULL,
	[RELATED_DXID] [numeric](8, 0) NOT NULL,
	[FML_CLIN_CODE] [varchar](2) NOT NULL,
	[FML_NAV_CODE] [varchar](2) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLDSR0_DXID_SEARCH_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLDSR0_DXID_SEARCH_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLDX0_DXID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLDX0_DXID](
	[DXID] [numeric](8, 0) NOT NULL,
	[DXID_DESC56] [varchar](56) NULL,
	[DXID_DESC100] [varchar](100) NULL,
	[DXID_STATUS] [varchar](1) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DXID_DISEASE_DURATION_CD] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLDX0_DXID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLDX0_DXID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLIAD0_ICD_ALL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLIAD0_ICD_ALL_DESC](
	[ICD_CD] [varchar](10) NOT NULL,
	[ICD_CD_TYPE] [varchar](2) NOT NULL,
	[ICD_DESC_SOURCE_CD] [varchar](2) NOT NULL,
	[ICD_DESC] [varchar](500) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLIAD0_ICD_ALL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLIAD0_ICD_ALL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLIBD0_ICD_BILLABLE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLIBD0_ICD_BILLABLE_DESC](
	[ICD_BILLABLE_IND] [numeric](1, 0) NOT NULL,
	[ICD_BILLABLE_IND_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLIBD0_ICD_BILLABLE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLIBD0_ICD_BILLABLE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLIBH0_ICD_BILLABLE_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLIBH0_ICD_BILLABLE_HIST](
	[ICD_CD] [varchar](10) NOT NULL,
	[ICD_CD_TYPE] [varchar](2) NOT NULL,
	[ICD_FIRST_BILLABLE_DT] [datetime] NOT NULL,
	[ICD_LAST_BILLABLE_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLIBH0_ICD_BILLABLE_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLIBH0_ICD_BILLABLE_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLINM1_ICD_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLINM1_ICD_DESC](
	[ICD_CD] [varchar](10) NOT NULL,
	[ICD_CD_TYPE] [varchar](2) NOT NULL,
	[ICD_DESC] [varchar](500) NOT NULL,
	[ICD_DESC_SOURCE_CD] [varchar](2) NOT NULL,
	[ICD_STATUS_CD] [varchar](1) NOT NULL,
	[ICD_FIRST_DT] [datetime] NULL,
	[ICD_LAST_DT] [datetime] NULL,
	[ICD_BILLABLE_IND] [numeric](1, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLINM1_ICD_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLINM1_ICD_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLISD1_ICD_DESC_SOURCE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLISD1_ICD_DESC_SOURCE_DESC](
	[ICD_DESC_SOURCE_CD] [varchar](2) NOT NULL,
	[ICD_DESC_SOURCE_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLISD1_ICD_DESC_SOURCE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLISD1_ICD_DESC_SOURCE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLISR1_ICD_SEARCH]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLISR1_ICD_SEARCH](
	[SEARCH_ICD_CD] [varchar](10) NOT NULL,
	[ICD_CD_TYPE] [varchar](2) NOT NULL,
	[RELATED_DXID] [numeric](8, 0) NOT NULL,
	[FML_CLIN_CODE] [varchar](2) NOT NULL,
	[FML_NAV_CODE] [varchar](2) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLISR1_ICD_SEARCH_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLISR1_ICD_SEARCH_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLISX0_ICD_SEARCH_EXCLUSION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLISX0_ICD_SEARCH_EXCLUSION](
	[SEARCH_ICD_CD] [varchar](10) NOT NULL,
	[ICD_CD_TYPE] [varchar](2) NOT NULL,
	[RELATED_DXID] [numeric](8, 0) NOT NULL,
	[FML_CLIN_CODE] [varchar](2) NOT NULL,
	[CLIN_DRUG_GROUP] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLISX0_ICD_SEARCH_EXCLUSION_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLISX0_ICD_SEARCH_EXCLUSION_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLITD1_ICD_CD_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLITD1_ICD_CD_TYPE_DESC](
	[ICD_CD_TYPE] [varchar](2) NOT NULL,
	[ICD_CD_TYPE_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLITD1_ICD_CD_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLITD1_ICD_CD_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLNAV0_DXID_NAVIGATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLNAV0_DXID_NAVIGATION](
	[DXID] [numeric](8, 0) NOT NULL,
	[BROADER_DXID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLNAV0_DXID_NAVIGATION_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLNAV0_DXID_NAVIGATION_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLNVD0_NAVIGATION_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLNVD0_NAVIGATION_DESC](
	[FML_NAV_CODE] [varchar](2) NOT NULL,
	[FML_NAV_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLNVD0_NAVIGATION_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLNVD0_NAVIGATION_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLSCD0_DXID_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLSCD0_DXID_STATUS_DESC](
	[DXID_STATUS] [varchar](1) NOT NULL,
	[DXID_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLSCD0_DXID_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLSCD0_DXID_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLSND0_SYN_NAME_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLSND0_SYN_NAME_TYPE_DESC](
	[DXID_SYN_NMTYP] [varchar](2) NOT NULL,
	[DXID_SYN_NMTYP_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLSND0_SYN_NAME_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLSND0_SYN_NAME_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLSSD0_SYN_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLSSD0_SYN_STATUS_DESC](
	[DXID_SYN_STATUS] [varchar](1) NOT NULL,
	[DXID_SYN_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLSSD0_SYN_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLSSD0_SYN_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RFMLSYN0_DXID_SYN]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RFMLSYN0_DXID_SYN](
	[DXID_SYNID] [numeric](8, 0) NOT NULL,
	[DXID] [numeric](8, 0) NOT NULL,
	[DXID_SYN_NMTYP] [varchar](2) NOT NULL,
	[DXID_SYN_DESC56] [varchar](56) NULL,
	[DXID_SYN_DESC100] [varchar](100) NULL,
	[DXID_SYN_STATUS] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RFMLSYN0_DXID_SYN_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RFMLSYN0_DXID_SYN_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGCN0_GCN_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGCN0_GCN_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[GCN] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGCN0_GCN_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGCN0_GCN_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGCNINH0_GCNSEQNO_INACTV_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGCNINH0_GCNSEQNO_INACTV_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[INACTV_NOT_PRES_CNT] [numeric](6, 0) NULL,
	[INACTV_PRES_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGCNINH0_GCNSEQNO_INACTV_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGCNINH0_GCNSEQNO_INACTV_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGCNINS0_STUDY_TABLE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGCNINS0_STUDY_TABLE](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[TOTAL_PRODUCTS_CNT] [numeric](6, 0) NULL,
	[PRODUCTS_RESEARCHED_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGCNINS0_STUDY_TABLE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGCNINS0_STUDY_TABLE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGCNSEQ4_GCNSEQNO_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[HIC3] [varchar](3) NULL,
	[HICL_SEQNO] [numeric](6, 0) NULL,
	[GCDF] [varchar](2) NULL,
	[GCRT] [varchar](1) NULL,
	[STR] [varchar](10) NULL,
	[GTC] [numeric](2, 0) NULL,
	[TC] [numeric](2, 0) NULL,
	[DCC] [varchar](1) NULL,
	[GCNSEQ_GI] [varchar](1) NULL,
	[GENDER] [varchar](1) NULL,
	[HIC3_SEQN] [numeric](6, 0) NULL,
	[STR60] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGCNSEQ4_GCNSEQNO_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGCNSEQ4_GCNSEQNO_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGCNSTR0_INGREDIENT_STRENGTH]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGCNSTR0_INGREDIENT_STRENGTH](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[STRENGTH_STATUS_CODE] [numeric](1, 0) NULL,
	[STRENGTH] [numeric](19, 6) NULL,
	[STRENGTH_UOM_ID] [numeric](8, 0) NULL,
	[STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[VOLUME] [numeric](19, 6) NULL,
	[VOLUME_UOM_ID] [numeric](8, 0) NULL,
	[ALT_STRENGTH] [numeric](19, 6) NULL,
	[ALT_STRENGTH_UOM_ID] [numeric](8, 0) NULL,
	[ALT_STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[TIME_VALUE] [numeric](6, 3) NULL,
	[TIME_UOM_ID] [numeric](8, 0) NULL,
	[RANGE_MAX] [numeric](19, 6) NULL,
	[RANGE_MIN] [numeric](19, 6) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGCNSTR0_INGREDIENT_STRENGTH_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGCNSTR0_INGREDIENT_STRENGTH_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGERIGC0_GERI_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGERIGC0_GERI_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[GERI_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGERIGC0_GERI_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGERIGC0_GERI_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGERIMA1_GERI_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGERIMA1_GERI_MSTR](
	[GERI_CODE] [numeric](6, 0) NOT NULL,
	[GERI_DESC] [varchar](41) NOT NULL,
	[GERI_SL] [varchar](1) NOT NULL,
	[GERI_RNL] [varchar](1) NOT NULL,
	[GERI_HEP] [varchar](1) NOT NULL,
	[GERI_CARD] [varchar](1) NOT NULL,
	[GERI_PULM] [varchar](1) NOT NULL,
	[GERI_NEUR] [varchar](1) NOT NULL,
	[GERI_END] [varchar](1) NOT NULL,
	[GERI_BEERS_IND] [varchar](1) NOT NULL,
	[GERI_HEDIS_IND] [varchar](1) NOT NULL,
	[GERI_STOPP_IND] [varchar](1) NOT NULL,
	[GERI_NARRATIVE] [varchar](500) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGERIMA1_GERI_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGERIMA1_GERI_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGERIRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGERIRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[GERI_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGERIRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGERIRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGERIRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGERIRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[GERI_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGERIRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGERIRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGERISD0_GERI_SEVER_LEVEL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGERISD0_GERI_SEVER_LEVEL_DESC](
	[GERI_SL] [varchar](1) NOT NULL,
	[GERI_SL_DESC] [varchar](255) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGERISD0_GERI_SEVER_LEVEL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGERISD0_GERI_SEVER_LEVEL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RGTCD0_GEN_THERAP_CLASS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RGTCD0_GEN_THERAP_CLASS_DESC](
	[GTC] [numeric](2, 0) NOT NULL,
	[GTC_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RGTCD0_GEN_THERAP_CLASS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RGTCD0_GEN_THERAP_CLASS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHIC1D2_HIC_ORGAN_SYS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHIC1D2_HIC_ORGAN_SYS_DESC](
	[HIC1_SEQN] [numeric](6, 0) NOT NULL,
	[HIC1] [varchar](1) NOT NULL,
	[HIC1_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHIC1D2_HIC_ORGAN_SYS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHIC1D2_HIC_ORGAN_SYS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHIC2D3_HIC_RX_CLASS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHIC2D3_HIC_RX_CLASS_DESC](
	[HIC2_SEQN] [numeric](6, 0) NOT NULL,
	[HIC2] [varchar](2) NOT NULL,
	[HIC2_DESC] [varchar](50) NULL,
	[HIC2_ROOT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHIC2D3_HIC_RX_CLASS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHIC2D3_HIC_RX_CLASS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHIC3D3_HIC_THERAP_CLASS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHIC3D3_HIC_THERAP_CLASS_DESC](
	[HIC3_SEQN] [numeric](6, 0) NOT NULL,
	[HIC3] [varchar](3) NOT NULL,
	[HIC3_DESC] [varchar](50) NULL,
	[HIC3_GRPN] [numeric](6, 0) NULL,
	[HIC3_ROOT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHIC3D3_HIC_THERAP_CLASS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHIC3D3_HIC_THERAP_CLASS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHIC3L2_HIC3_HICLSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHIC3L2_HIC3_HICLSEQNO_LINK](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[HIC3_SEQN] [numeric](6, 0) NOT NULL,
	[HIC3] [varchar](3) NULL,
	[HIC3_RELNO] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHIC3L2_HIC3_HICLSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHIC3L2_HIC3_HICLSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHIC4D2_HIC_BASE_ING_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHIC4D2_HIC_BASE_ING_DESC](
	[HIC4_SEQN] [numeric](6, 0) NOT NULL,
	[HIC4] [varchar](4) NULL,
	[HIC4_DESC] [varchar](50) NULL,
	[HIC4_ROOT] [numeric](6, 0) NULL,
	[HIC4_POTENTIALLY_INACTV_IND] [numeric](1, 0) NULL,
	[ING_STATUS_CD] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHIC4D2_HIC_BASE_ING_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHIC4D2_HIC_BASE_ING_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICCAS1_HIC_CAS_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICCAS1_HIC_CAS_LINK](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[CAS9_TBL] [numeric](9, 0) NULL,
	[HIC] [varchar](6) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICCAS1_HIC_CAS_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICCAS1_HIC_CAS_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICD5_HIC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICD5_HIC_DESC](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[HIC] [varchar](6) NULL,
	[HIC_DESC] [varchar](50) NULL,
	[HIC_ROOT] [numeric](6, 0) NULL,
	[HIC_POTENTIALLY_INACTV_IND] [numeric](1, 0) NULL,
	[ING_STATUS_CD] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICD5_HIC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICD5_HIC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICHCR0_HIC_HIC_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICHCR0_HIC_HIC_LINK](
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[RELATED_HIC_SEQN] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICHCR0_HIC_HIC_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICHCR0_HIC_HIC_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICL1_HIC_HICLSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICL1_HIC_HICLSEQNO_LINK](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[HIC_REL_NO] [numeric](1, 0) NULL,
	[HIC] [varchar](6) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICL1_HIC_HICLSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICL1_HIC_HICLSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICLSQ1_HICLSEQNO_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICLSQ1_HICLSEQNO_MSTR](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[GNN] [varchar](30) NULL,
	[GNN60] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICLSQ1_HICLSEQNO_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICLSQ1_HICLSEQNO_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICLSQ2_HICLSEQNO_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICLSQ2_HICLSEQNO_MSTR](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[GNN] [varchar](30) NOT NULL,
	[GNN60] [varchar](60) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RHICLSQ2_HICLSEQNO_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RHICLSQ2_HICLSEQNO_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICRH0_ING_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICRH0_ING_HIST](
	[REPL_HIC_SEQN] [numeric](6, 0) NOT NULL,
	[PREV_HIC_SEQN] [numeric](6, 0) NOT NULL,
	[HIC_REPL_EFF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICRH0_ING_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICRH0_ING_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RHICSCD0_ING_STAT_CD_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RHICSCD0_ING_STAT_CD_DESC](
	[ING_STATUS_CD] [numeric](1, 0) NOT NULL,
	[ING_STATUS_CD_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RHICSCD0_ING_STAT_CD_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RHICSCD0_ING_STAT_CD_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMDD0_INDCTS_DRUG_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMDD0_INDCTS_DRUG_DESC](
	[INDCTS] [numeric](5, 0) NOT NULL,
	[INDCTS_DRUG_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMDD0_INDCTS_DRUG_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMDD0_INDCTS_DRUG_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMGC0_INDCTS_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMGC0_INDCTS_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[INDCTS] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMGC0_INDCTS_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMGC0_INDCTS_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMLD0_LABELED_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMLD0_LABELED_DESC](
	[INDCTS_LBL] [varchar](1) NOT NULL,
	[INDLBLDESC] [varchar](90) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMLD0_LABELED_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMLD0_LABELED_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMMA2_INDCTS_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMMA2_INDCTS_MSTR](
	[INDCTS] [numeric](5, 0) NOT NULL,
	[INDCTS_SN] [numeric](2, 0) NOT NULL,
	[INDCTS_LBL] [varchar](1) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[DXID] [numeric](8, 0) NULL,
	[PROXY_IND] [varchar](1) NULL,
	[PRED_CODE] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMMA2_INDCTS_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMMA2_INDCTS_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMPD0_PREDICTOR_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMPD0_PREDICTOR_DESC](
	[PRED_CODE] [varchar](1) NOT NULL,
	[PREDDESC] [varchar](90) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMPD0_PREDICTOR_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMPD0_PREDICTOR_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[INDCTS] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RINDMRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RINDMRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[INDCTS] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RINDMRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RINDMRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMACO0_ADMXTR_COMP_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMACO0_ADMXTR_COMP_LINK](
	[IVMADMIX] [varchar](6) NOT NULL,
	[IVMCOMP] [varchar](6) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMACO0_ADMXTR_COMP_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMACO0_ADMXTR_COMP_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMAMA0_ADMXTR_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMAMA0_ADMXTR_MSTR](
	[IVMADMIX] [varchar](6) NOT NULL,
	[IVMCCNT] [numeric](1, 0) NULL,
	[IVMTPNCNT] [numeric](1, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMAMA0_ADMXTR_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMAMA0_ADMXTR_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMCDS0_COMP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMCDS0_COMP_DESC](
	[IVMCOMP] [varchar](6) NOT NULL,
	[IVMCOMPDSC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMCDS0_COMP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMCDS0_COMP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMCGC0_COMP_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMCGC0_COMP_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[IVMCOMP] [varchar](6) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMCGC0_COMP_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMCGC0_COMP_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMMFG0_MANUFACTURER_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMMFG0_MANUFACTURER_DESC](
	[IVMMFG] [varchar](3) NOT NULL,
	[IVMMFGD] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMMFG0_MANUFACTURER_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMMFG0_MANUFACTURER_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMRMK0_REMARKS]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMRMK0_REMARKS](
	[IVMRMK] [varchar](6) NOT NULL,
	[IVMRMKSEQ] [numeric](3, 0) NOT NULL,
	[IVMRMKTYP] [varchar](1) NULL,
	[IVMREMARK] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMRMK0_REMARKS_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMRMK0_REMARKS_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMSAD0_STDY_GRP_ADMXTR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMSAD0_STDY_GRP_ADMXTR_LINK](
	[IVMSGRP] [varchar](6) NOT NULL,
	[IVMADMIX] [varchar](6) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMSAD0_STDY_GRP_ADMXTR_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMSAD0_STDY_GRP_ADMXTR_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMSMA0_STDY_GRP_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMSMA0_STDY_GRP_MSTR](
	[IVMSGRP] [varchar](6) NOT NULL,
	[IVMADCNT] [numeric](2, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMSMA0_STDY_GRP_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMSMA0_STDY_GRP_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT](
	[IVMSGRP] [varchar](6) NOT NULL,
	[IVMTESTSN] [numeric](3, 0) NOT NULL,
	[IVMADMIX] [varchar](6) NOT NULL,
	[IVMCOMP] [varchar](6) NOT NULL,
	[IVMSTR] [numeric](11, 3) NULL,
	[IVMSTRU] [varchar](3) NULL,
	[IVMVOL] [numeric](11, 3) NULL,
	[IVMVOLU] [varchar](3) NULL,
	[IVMMFG] [varchar](3) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMTCO0_STDY_GRP_TST_COMP_DT_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMTCO0_STDY_GRP_TST_COMP_DT_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMTMA0_STDY_GRP_TST_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMTMA0_STDY_GRP_TST_MSTR](
	[IVMSGRP] [varchar](6) NOT NULL,
	[IVMTESTSN] [numeric](3, 0) NOT NULL,
	[IVMTTYPE] [varchar](1) NULL,
	[IVMRSLT] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMTMA0_STDY_GRP_TST_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMTMA0_STDY_GRP_TST_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMTPI0_TPN_ING_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMTPI0_TPN_ING_DESC](
	[IVMCOMP] [varchar](6) NOT NULL,
	[IVMTPNINGR] [varchar](50) NOT NULL,
	[IVMSTR] [numeric](11, 3) NULL,
	[IVMSTRU] [varchar](3) NULL,
	[IVMVOL] [numeric](11, 3) NULL,
	[IVMVOLU] [varchar](3) NULL,
	[IVMMFG] [varchar](3) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMTPI0_TPN_ING_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMTPI0_TPN_ING_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMTPN0_TPN_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMTPN0_TPN_DESC](
	[IVMCOMP] [varchar](6) NOT NULL,
	[IVMTPNDSC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMTPN0_TPN_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMTPN0_TPN_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RIVMTRM0_STDY_GRP_TST_REMARK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RIVMTRM0_STDY_GRP_TST_REMARK](
	[IVMSGRP] [varchar](6) NOT NULL,
	[IVMTESTSN] [numeric](3, 0) NOT NULL,
	[IVMRMKSN] [numeric](2, 0) NOT NULL,
	[IVMRMK] [varchar](6) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RIVMTRM0_STDY_GRP_TST_REMARK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RIVMTRM0_STDY_GRP_TST_REMARK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTED0_EXCRT_POTENTIAL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTED0_EXCRT_POTENTIAL_DESC](
	[LACT_EXCRT] [varchar](1) NOT NULL,
	[LACT_EXCRTSN] [numeric](2, 0) NOT NULL,
	[LACT_EXCRT_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTED0_EXCRT_POTENTIAL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTED0_EXCRT_POTENTIAL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTGC0_LACT_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTGC0_LACT_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[LACT_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTGC0_LACT_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTGC0_LACT_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTID0_EFFECTS_INFANTS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTID0_EFFECTS_INFANTS_DESC](
	[LACT_LCTN] [varchar](1) NOT NULL,
	[LACT_LCTNSN] [numeric](2, 0) NOT NULL,
	[LACT_LCTN_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTID0_EFFECTS_INFANTS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTID0_EFFECTS_INFANTS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTMA0_LACT_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTMA0_LACT_MSTR](
	[LACT_CODE] [numeric](6, 0) NOT NULL,
	[LACT_DESC] [varchar](40) NULL,
	[LACT_SL] [varchar](1) NULL,
	[LACT_EXCRT] [varchar](1) NULL,
	[LACT_LCTN] [varchar](1) NULL,
	[LACT_PRCTN] [varchar](77) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTMA0_LACT_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTMA0_LACT_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[LACT_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[LACT_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLACTSD0_SEVER_LEVEL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLACTSD0_SEVER_LEVEL_DESC](
	[LACT_SL] [varchar](1) NOT NULL,
	[LACT_SLSN] [numeric](2, 0) NOT NULL,
	[LACT_SL_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLACTSD0_SEVER_LEVEL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLACTSD0_SEVER_LEVEL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLBLRID3_LBLR_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLBLRID3_LBLR_DESC](
	[LBLRID] [varchar](6) NOT NULL,
	[MFG] [varchar](15) NULL,
	[LBLRIND] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLBLRID3_LBLR_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLBLRID3_LBLR_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLBLWD0_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLBLWD0_DESC](
	[LBL_WARN] [varchar](4) NOT NULL,
	[LBL_TEXTSN] [numeric](2, 0) NOT NULL,
	[LBL_DESC] [varchar](55) NULL,
	[LBLGNDR] [varchar](1) NULL,
	[LBLAGE] [varchar](1) NULL,
	[LBLPREG] [varchar](1) NULL,
	[LBLINFO] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLBLWD0_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLBLWD0_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLBLWGC0_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLBLWGC0_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[LBL_WARN] [varchar](4) NOT NULL,
	[LBL_PRTY] [numeric](2, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLBLWGC0_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLBLWGC0_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLBLWV0_VENDOR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLBLWV0_VENDOR_LINK](
	[LBL_WARN] [varchar](4) NOT NULL,
	[LBLW_VTYPE] [numeric](3, 0) NOT NULL,
	[LBLW_VCODE] [varchar](10) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLBLWV0_VENDOR_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLBLWV0_VENDOR_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RLBLWVD0_VENDOR_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RLBLWVD0_VENDOR_TYPE_DESC](
	[LBLW_VTYPE] [numeric](3, 0) NOT NULL,
	[LBLW_VDESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RLBLWVD0_VENDOR_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RLBLWVD0_VENDOR_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDCD0_MED_CONCEPT_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDCD0_MED_CONCEPT_TYP_DESC](
	[MED_CONCEPT_ID_TYP] [numeric](1, 0) NOT NULL,
	[MED_CONCEPT_ID_TYP_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDCD0_MED_CONCEPT_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDCD0_MED_CONCEPT_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDDIN0_RDFMID_INACTV_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDDIN0_RDFMID_INACTV_LINK](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[INACTV_NOT_PRES_CNT] [numeric](6, 0) NULL,
	[INACTV_PRES_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDDIN0_RDFMID_INACTV_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDDIN0_RDFMID_INACTV_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDDIS0_ROUTED_DF_STUDY_TABLE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDDIS0_ROUTED_DF_STUDY_TABLE](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[TOTAL_PRODUCTS_CNT] [numeric](6, 0) NULL,
	[PRODUCTS_RESEARCHED_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDDIS0_ROUTED_DF_STUDY_TABLE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDDIS0_ROUTED_DF_STUDY_TABLE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDIN0_MEDID_INACTV_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDIN0_MEDID_INACTV_LINK](
	[MEDID] [numeric](8, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[INACTV_NOT_PRES_CNT] [numeric](6, 0) NULL,
	[INACTV_PRES_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDIN0_MEDID_INACTV_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDIN0_MEDID_INACTV_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDIS0_MEDID_STUDY_TABLE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDIS0_MEDID_STUDY_TABLE](
	[MEDID] [numeric](8, 0) NOT NULL,
	[TOTAL_PRODUCTS_CNT] [numeric](6, 0) NULL,
	[PRODUCTS_RESEARCHED_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDIS0_MEDID_STUDY_TABLE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDIS0_MEDID_STUDY_TABLE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDMGL0_MED_GENERIC_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDMGL0_MED_GENERIC_MED_LINK](
	[MED_CONCEPT_ID] [numeric](8, 0) NOT NULL,
	[MED_CONCEPT_ID_TYP] [numeric](1, 0) NOT NULL,
	[GENERIC_MED_CONCEPT_ID] [numeric](8, 0) NOT NULL,
	[MED_CONCEPT_OBSDATEC] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDMGL0_MED_GENERIC_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDMGL0_MED_GENERIC_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDMHL0_MED_HICLSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDMHL0_MED_HICLSEQNO_LINK](
	[MED_CONCEPT_ID] [numeric](8, 0) NOT NULL,
	[MED_CONCEPT_ID_TYP] [numeric](1, 0) NOT NULL,
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[MED_CONCEPT_HICL_SRC_CD] [numeric](1, 0) NOT NULL,
	[MED_CONCEPT_OBSDATEC] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDMHL0_MED_HICLSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDMHL0_MED_HICLSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDMRD0_MOVE_REASON_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDMRD0_MOVE_REASON_DESC](
	[MOVE_REASON_CD] [numeric](4, 0) NOT NULL,
	[MOVE_REASON_CD_DESC] [varchar](100) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDMRD0_MOVE_REASON_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDMRD0_MOVE_REASON_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNGH0_NDC_GEN_MEDID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNGH0_NDC_GEN_MEDID_HIST](
	[NDC] [varchar](11) NOT NULL,
	[PRODUCTION_DATE] [datetime] NOT NULL,
	[PREV_MEDID] [numeric](8, 0) NOT NULL,
	[PREV_MEDID_NAME_SOURCE_CD] [varchar](1) NOT NULL,
	[PREV_MEDID_OLD_STATUS_CD] [varchar](1) NOT NULL,
	[PREV_MEDID_NEW_STATUS_CD] [varchar](1) NOT NULL,
	[PREV_MEDID_DESC] [varchar](70) NOT NULL,
	[CURR_MEDID] [numeric](8, 0) NOT NULL,
	[CURR_MEDID_NAME_SOURCE_CD] [varchar](1) NOT NULL,
	[CURR_MEDID_OLD_STATUS_CD] [varchar](1) NULL,
	[CURR_MEDID_NEW_STATUS_CD] [varchar](1) NOT NULL,
	[CURR_MEDID_DESC] [varchar](70) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNGH0_NDC_GEN_MEDID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNGH0_NDC_GEN_MEDID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNGM0_NDC_GEN_MEDID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNGM0_NDC_GEN_MEDID](
	[NDC] [varchar](11) NOT NULL,
	[MEDID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNGM0_NDC_GEN_MEDID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNGM0_NDC_GEN_MEDID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNGR0_NDC_GEN_MEDID_REASON]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNGR0_NDC_GEN_MEDID_REASON](
	[NDC] [varchar](11) NOT NULL,
	[PRODUCTION_DATE] [datetime] NOT NULL,
	[MOVE_REASON_CD] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNGR0_NDC_GEN_MEDID_REASON_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNGR0_NDC_GEN_MEDID_REASON_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNIN0_MNID_INACTV_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNIN0_MNID_INACTV_LINK](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[INACTV_NOT_PRES_CNT] [numeric](6, 0) NULL,
	[INACTV_PRES_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNIN0_MNID_INACTV_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNIN0_MNID_INACTV_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNIS0_MED_NAME_STUDY_TABLE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNIS0_MED_NAME_STUDY_TABLE](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[TOTAL_PRODUCTS_CNT] [numeric](6, 0) NULL,
	[PRODUCTS_RESEARCHED_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNIS0_MED_NAME_STUDY_TABLE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNIS0_MED_NAME_STUDY_TABLE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNMH0_NDC_MEDID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNMH0_NDC_MEDID_HIST](
	[NDC] [varchar](11) NOT NULL,
	[PRODUCTION_DATE] [datetime] NOT NULL,
	[PREV_MEDID] [numeric](8, 0) NOT NULL,
	[PREV_MEDID_NAME_SOURCE_CD] [varchar](1) NOT NULL,
	[PREV_MEDID_OLD_STATUS_CD] [varchar](1) NOT NULL,
	[PREV_MEDID_NEW_STATUS_CD] [varchar](1) NOT NULL,
	[PREV_MEDID_DESC] [varchar](70) NOT NULL,
	[CURR_MEDID] [numeric](8, 0) NOT NULL,
	[CURR_MEDID_NAME_SOURCE_CD] [varchar](1) NOT NULL,
	[CURR_MEDID_OLD_STATUS_CD] [varchar](1) NULL,
	[CURR_MEDID_NEW_STATUS_CD] [varchar](1) NOT NULL,
	[CURR_MEDID_DESC] [varchar](70) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNMH0_NDC_MEDID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNMH0_NDC_MEDID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDNMR0_NDC_MEDID_REASON]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDNMR0_NDC_MEDID_REASON](
	[NDC] [varchar](11) NOT NULL,
	[PRODUCTION_DATE] [datetime] NOT NULL,
	[MOVE_REASON_CD] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDNMR0_NDC_MEDID_REASON_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDNMR0_NDC_MEDID_REASON_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDRIN0_RMID_INACTV_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDRIN0_RMID_INACTV_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[INACTV_NOT_PRES_CNT] [numeric](6, 0) NULL,
	[INACTV_PRES_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDRIN0_RMID_INACTV_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDRIN0_RMID_INACTV_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDRIS0_ROUTED_MED_STDY_TBL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDRIS0_ROUTED_MED_STDY_TBL](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[TOTAL_PRODUCTS_CNT] [numeric](6, 0) NULL,
	[PRODUCTS_RESEARCHED_CNT] [numeric](6, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMEDRIS0_ROUTED_MED_STDY_TBL_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMEDRIS0_ROUTED_MED_STDY_TBL_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDST0_MEDID_SEARCH_TERM]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDST0_MEDID_SEARCH_TERM](
	[MEDID] [numeric](8, 0) NOT NULL,
	[SEARCH_TERM_TYPE_CD] [numeric](4, 0) NOT NULL,
	[SEARCH_TERM_TEXT] [varchar](150) NOT NULL,
	[MED_MEDID_DESC] [varchar](70) NOT NULL,
	[MEDICAL_SUPPLY_IND] [numeric](1, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RMEDST0_MEDID_SEARCH_TERM_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RMEDST0_MEDID_SEARCH_TERM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMEDSTD0_SEARCH_TERM_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMEDSTD0_SEARCH_TERM_TYPE_DESC](
	[SEARCH_TERM_TYPE_CD] [numeric](4, 0) NOT NULL,
	[SEARCH_TERM_TYPE_CD_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RMEDSTD0_SEARCH_TERM_TYPE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RMEDSTD0_SEARCH_TERM_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIDE2D1_REF_DESI2_IND_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIDE2D1_REF_DESI2_IND_DESC](
	[MED_REF_DESI2_IND] [varchar](1) NOT NULL,
	[MED_REF_DESI2_IND_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIDE2D1_REF_DESI2_IND_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIDE2D1_REF_DESI2_IND_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIDEAD1_REF_FED_DEA_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIDEAD1_REF_FED_DEA_DESC](
	[MED_REF_DEA_CD] [varchar](1) NOT NULL,
	[MED_REF_DEA_CD_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIDEAD1_REF_FED_DEA_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIDEAD1_REF_FED_DEA_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIDESD1_REF_DESI_IND_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIDESD1_REF_DESI_IND_DESC](
	[MED_REF_DESI_IND] [varchar](1) NOT NULL,
	[MED_REF_DESI_IND_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIDESD1_REF_DESI_IND_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIDESD1_REF_DESI_IND_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIDFD1_DOSE_FORM]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIDFD1_DOSE_FORM](
	[MED_DOSAGE_FORM_ID] [numeric](5, 0) NOT NULL,
	[MED_DOSAGE_FORM_ABBR] [varchar](4) NOT NULL,
	[MED_DOSAGE_FORM_DESC] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIDFD1_DOSE_FORM_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIDFD1_DOSE_FORM_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIDFID1_ROUTED_DOSE_FORM_MED](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_DOSAGE_FORM_ID] [numeric](5, 0) NOT NULL,
	[MED_ROUTED_DF_MED_ID_DESC] [varchar](60) NOT NULL,
	[MED_STATUS_CD] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIDFID1_ROUTED_DOSE_FORM_MED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIDFID1_ROUTED_DOSE_FORM_MED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIDFRH1_ROUTED_DOSE_FORM_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIDFRH1_ROUTED_DOSE_FORM_HIST](
	[MED_REPL_ROUTED_DF_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_PREV_ROUTED_DF_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_ROUTED_DF_MED_ID_REP_EF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIDFRH1_ROUTED_DOSE_FORM_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIDFRH1_ROUTED_DOSE_FORM_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIGC1_MEDID_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIGC1_MEDID_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[MEDID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIGC1_MEDID_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIGC1_MEDID_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIGCND1_GCNSEQNO_ASSGN_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIGCND1_GCNSEQNO_ASSGN_DESC](
	[MED_GCNSEQNO_ASSIGN_CD] [varchar](1) NOT NULL,
	[MED_GCNSEQNO_ASSIGN_CD_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIGCND1_GCNSEQNO_ASSGN_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIGCND1_GCNSEQNO_ASSGN_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIGECD1_REF_GEN_THERAP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIGECD1_REF_GEN_THERAP_DESC](
	[MED_REF_GEN_THERA_EQU_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_THERA_EQU_CD_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIGECD1_REF_GEN_THERAP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIGECD1_REF_GEN_THERAP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIGNCD1_REF_GEN_NAME_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIGNCD1_REF_GEN_NAME_DESC](
	[MED_REF_GEN_DRUG_NAME_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_DRUG_NAME_CD_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIGNCD1_REF_GEN_NAME_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIGNCD1_REF_GEN_NAME_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIGPCD1_REF_GEN_PRC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIGPCD1_REF_GEN_PRC_DESC](
	[MED_REF_GEN_COMP_PRICE_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_COMP_PRICE_CD_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIGPCD1_REF_GEN_PRC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIGPCD1_REF_GEN_PRC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIGSCD1_REF_GEN_PRC_SPRD_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIGSCD1_REF_GEN_PRC_SPRD_DESC](
	[MED_REF_GEN_SPREAD_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_SPREAD_CD_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIGSCD1_REF_GEN_PRC_SPRD_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIGSCD1_REF_GEN_PRC_SPRD_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIID1_MED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIID1_MED](
	[MEDID] [numeric](8, 0) NOT NULL,
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_STRENGTH] [varchar](15) NULL,
	[MED_STRENGTH_UOM] [varchar](15) NULL,
	[MED_MEDID_DESC] [varchar](70) NOT NULL,
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[MED_GCNSEQNO_ASSIGN_CD] [varchar](1) NOT NULL,
	[MED_NAME_SOURCE_CD] [varchar](1) NOT NULL,
	[MED_REF_FED_LEGEND_IND] [varchar](1) NOT NULL,
	[MED_REF_DEA_CD] [varchar](1) NOT NULL,
	[MED_REF_MULTI_SOURCE_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_DRUG_NAME_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_COMP_PRICE_CD] [varchar](1) NOT NULL,
	[MED_REF_GEN_SPREAD_CD] [varchar](1) NOT NULL,
	[MED_REF_INNOV_IND] [varchar](1) NOT NULL,
	[MED_REF_GEN_THERA_EQU_CD] [varchar](1) NOT NULL,
	[MED_REF_DESI_IND] [varchar](1) NOT NULL,
	[MED_REF_DESI2_IND] [varchar](1) NOT NULL,
	[MED_STATUS_CD] [varchar](1) NOT NULL,
	[GENERIC_MEDID] [numeric](8, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIID1_MED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIID1_MED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIINND1_REF_INNOV_IND_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIINND1_REF_INNOV_IND_DESC](
	[MED_REF_INNOV_IND] [varchar](1) NOT NULL,
	[MED_REF_INNOV_IND_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIINND1_REF_INNOV_IND_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIINND1_REF_INNOV_IND_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMILGND1_REF_FED_LGND_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMILGND1_REF_FED_LGND_DESC](
	[MED_REF_FED_LEGEND_IND] [varchar](1) NOT NULL,
	[MED_REF_FED_LEGEND_IND_DESC] [varchar](60) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMILGND1_REF_FED_LGND_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMILGND1_REF_FED_LGND_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIMLTD1_REF_MULTI_SRC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIMLTD1_REF_MULTI_SRC_DESC](
	[MED_REF_MULTI_SOURCE_CD] [varchar](1) NOT NULL,
	[MED_REF_MULTI_SOURCE_CD_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIMLTD1_REF_MULTI_SRC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIMLTD1_REF_MULTI_SRC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMINAMD1_NAME_SRC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMINAMD1_NAME_SRC_DESC](
	[MED_NAME_SOURCE_CD] [varchar](1) NOT NULL,
	[MED_NAME_SOURCE_CD_DESC] [varchar](90) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMINAMD1_NAME_SRC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMINAMD1_NAME_SRC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMINDC1_NDC_MEDID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMINDC1_NDC_MEDID](
	[NDC] [varchar](11) NOT NULL,
	[MEDID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMINDC1_NDC_MEDID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMINDC1_NDC_MEDID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMINMD1_MED_NAME_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMINMD1_MED_NAME_TYPE_DESC](
	[MED_NAME_TYPE_CD] [varchar](1) NOT NULL,
	[MED_NAME_TYPE_CD_DESC] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMINMD1_MED_NAME_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMINMD1_MED_NAME_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMINMID1_MED_NAME]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMINMID1_MED_NAME](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[MED_NAME] [varchar](30) NOT NULL,
	[MED_NAME_TYPE_CD] [varchar](1) NOT NULL,
	[MED_STATUS_CD] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMINMID1_MED_NAME_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMINMID1_MED_NAME_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMINMRH1_MED_NAME_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMINMRH1_MED_NAME_HIST](
	[MED_REPL_NAME_ID] [numeric](8, 0) NOT NULL,
	[MED_PREV_NAME_ID] [numeric](8, 0) NOT NULL,
	[MED_NAME_ID_REPL_EFF_DT] [datetime] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMINMRH1_MED_NAME_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMINMRH1_MED_NAME_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIRH1_MED_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIRH1_MED_HIST](
	[MED_REPL_MEDID] [numeric](8, 0) NOT NULL,
	[MED_PREV_MEDID] [numeric](8, 0) NOT NULL,
	[MED_MEDID_REPL_EFF_DT] [datetime] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIRH1_MED_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIRH1_MED_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIRMID1_ROUTED_MED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIRMID1_ROUTED_MED](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[MED_ROUTE_ID] [numeric](5, 0) NOT NULL,
	[MED_ROUTED_MED_ID_DESC] [varchar](60) NOT NULL,
	[MED_STATUS_CD] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIRMID1_ROUTED_MED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIRMID1_ROUTED_MED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIRMRH1_ROUTED_MED_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIRMRH1_ROUTED_MED_HIST](
	[MED_REPL_ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_PREV_ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[MED_ROUTED_MED_ID_REPL_EFF_DT] [datetime] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIRMRH1_ROUTED_MED_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIRMRH1_ROUTED_MED_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMIRTD1_ROUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMIRTD1_ROUTE](
	[MED_ROUTE_ID] [numeric](5, 0) NOT NULL,
	[MED_ROUTE_ABBR] [varchar](4) NOT NULL,
	[MED_ROUTE_DESC] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMIRTD1_ROUTE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMIRTD1_ROUTE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMISCD1_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMISCD1_STATUS_DESC](
	[MED_STATUS_CD] [varchar](1) NOT NULL,
	[MED_STATUS_CD_DESC] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMISCD1_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMISCD1_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMMADMA1_ADULT_DOSE_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMMADMA1_ADULT_DOSE_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[MMA_MND] [numeric](9, 3) NULL,
	[MMA_MNDU] [varchar](3) NULL,
	[MMA_MNU] [numeric](7, 3) NULL,
	[MMA_MNUF] [varchar](2) NULL,
	[MMA_MXD] [numeric](9, 3) NULL,
	[MMA_MXDU] [varchar](3) NULL,
	[MMA_MXU] [numeric](7, 3) NULL,
	[MMA_MXUF] [varchar](2) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMMADMA1_ADULT_DOSE_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMMADMA1_ADULT_DOSE_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMMARMA0_ADULT_RANGE_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMMARMA0_ADULT_RANGE_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[MMAR_MND] [numeric](9, 3) NULL,
	[MMAR_MNDU] [varchar](3) NULL,
	[MMAR_MNU] [numeric](7, 3) NULL,
	[MMAR_MNUF] [varchar](2) NULL,
	[MMAR_MXD] [numeric](9, 3) NULL,
	[MMAR_MXDU] [varchar](3) NULL,
	[MMAR_MXU] [numeric](7, 3) NULL,
	[MMAR_MXUF] [varchar](2) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMMARMA0_ADULT_RANGE_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMMARMA0_ADULT_RANGE_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMMGDMA1_GERI_DOSE_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMMGDMA1_GERI_DOSE_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[MMG_MND] [numeric](9, 3) NULL,
	[MMG_MNDU] [varchar](3) NULL,
	[MMG_MNU] [numeric](7, 3) NULL,
	[MMG_MNUF] [varchar](2) NULL,
	[MMG_MXD] [numeric](9, 3) NULL,
	[MMG_MXDU] [varchar](3) NULL,
	[MMG_MXU] [numeric](7, 3) NULL,
	[MMG_MXUF] [varchar](2) NULL,
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMMGDMA1_GERI_DOSE_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMMGDMA1_GERI_DOSE_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMMGRMA1_GERI_RANGE_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMMGRMA1_GERI_RANGE_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[MMGR_MND] [numeric](9, 3) NULL,
	[MMGR_MNDU] [varchar](3) NULL,
	[MMGR_MNU] [numeric](7, 3) NULL,
	[MMGR_MNUF] [varchar](2) NULL,
	[MMGR_MXD] [numeric](9, 3) NULL,
	[MMGR_MXDU] [varchar](3) NULL,
	[MMGR_MXU] [numeric](7, 3) NULL,
	[MMGR_MXUF] [varchar](2) NULL,
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMMGRMA1_GERI_RANGE_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMMGRMA1_GERI_RANGE_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMMSRC0_DOSING_AGE_SOURCE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMMSRC0_DOSING_AGE_SOURCE](
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[DOSING_AGE_SOURCE_DESC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMMSRC0_DOSING_AGE_SOURCE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMMSRC0_DOSING_AGE_SOURCE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLAID0_ANALYTE_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLAID0_ANALYTE_ID](
	[MTL_ANALYTE_ID] [numeric](8, 0) NOT NULL,
	[MTL_ANALYTE_ID_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLAID0_ANALYTE_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLAID0_ANALYTE_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLEVL0_EXT_VOCAB_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLEVL0_EXT_VOCAB_LINK](
	[MTL_EXTRN_VOCAB_TYP_CODE] [varchar](2) NOT NULL,
	[MTL_EXTRN_VOCAB_CODE] [varchar](20) NOT NULL,
	[MTL_FDB_ID_TYP_CODE] [varchar](2) NOT NULL,
	[MTL_FDB_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLEVL0_EXT_VOCAB_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLEVL0_EXT_VOCAB_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLITD0_FDB_ID_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLITD0_FDB_ID_TYP_DESC](
	[MTL_FDB_ID_TYP_CODE] [varchar](2) NOT NULL,
	[MTL_FDB_ID_TYP_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLITD0_FDB_ID_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLITD0_FDB_ID_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLLAB0_LAB_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLLAB0_LAB_ID](
	[LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_LAB_ID_DESC] [varchar](100) NULL,
	[MTL_ANALYTE_ID] [numeric](8, 0) NOT NULL,
	[MTL_SPECIMEN_ID] [numeric](5, 0) NOT NULL,
	[MTL_LAB_ID_STATUS] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLLAB0_LAB_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLLAB0_LAB_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLLRH0_LAB_ID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLLRH0_LAB_ID_HIST](
	[MTL_PREV_LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_REPL_LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_LAB_ID_REPL_EFF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLLRH0_LAB_ID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLLRH0_LAB_ID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLLSD0_LAB_ID_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLLSD0_LAB_ID_STATUS_DESC](
	[MTL_LAB_ID_STATUS] [char](1) NOT NULL,
	[MTL_LAB_ID_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLLSD0_LAB_ID_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLLSD0_LAB_ID_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLMID0_METHODOLOGY_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLMID0_METHODOLOGY_ID](
	[MTL_METHOD_ID] [numeric](5, 0) NOT NULL,
	[MTL_METHOD_ID_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLMID0_METHODOLOGY_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLMID0_METHODOLOGY_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLPID0_PANEL_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLPID0_PANEL_ID](
	[MTL_PANEL_ID] [numeric](5, 0) NOT NULL,
	[MTL_PANEL_ID_DESC] [varchar](50) NULL,
	[MTL_PANEL_ID_STATUS] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLPID0_PANEL_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLPID0_PANEL_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLPLB0_PANEL_LABID_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLPLB0_PANEL_LABID_LINK](
	[MTL_PANEL_ID] [numeric](5, 0) NOT NULL,
	[LAB_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLPLB0_PANEL_LABID_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLPLB0_PANEL_LABID_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLPRH0_PANEL_ID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLPRH0_PANEL_ID_HIST](
	[MTL_PREV_PANEL_ID] [numeric](5, 0) NOT NULL,
	[MTL_REPL_PANEL_ID] [numeric](5, 0) NOT NULL,
	[MTL_PANEL_ID_REPL_EFF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLPSD0_PANEL_ID_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLPSD0_PANEL_ID_STATUS_DESC](
	[MTL_PANEL_ID_STATUS] [char](1) NOT NULL,
	[MTL_PANEL_ID_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLPSD0_PANEL_ID_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLPSD0_PANEL_ID_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSCD0_SPEC_LAB_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSCD0_SPEC_LAB_STATUS_DESC](
	[MTL_SPEC_LAB_ID_STATUS] [char](1) NOT NULL,
	[MTL_SPEC_LAB_ID_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSCD0_SPEC_LAB_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSCD0_SPEC_LAB_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSID0_SPECIMEN_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSID0_SPECIMEN_ID](
	[MTL_SPECIMEN_ID] [numeric](5, 0) NOT NULL,
	[MTL_SPECIMEN_ID_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSID0_SPECIMEN_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSID0_SPECIMEN_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSLT0_SPECIFIC_LAB_ID]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSLT0_SPECIFIC_LAB_ID](
	[MTL_SPEC_LAB_ID] [numeric](8, 0) NOT NULL,
	[LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_METHOD_ID] [numeric](5, 0) NOT NULL,
	[MTL_SPEC_LAB_ID_DESC] [varchar](100) NULL,
	[MTL_SPEC_LAB_ID_STATUS] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSLT0_SPECIFIC_LAB_ID_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSLT0_SPECIFIC_LAB_ID_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSND0_LAB_ID_SYN_NMTYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSND0_LAB_ID_SYN_NMTYP_DESC](
	[MTL_LAB_ID_SYN_NMTYP_CODE] [varchar](2) NOT NULL,
	[MTL_LAB_ID_SYN_NMTYP_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSND0_LAB_ID_SYN_NMTYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSND0_LAB_ID_SYN_NMTYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSRH0_SPECIFIC_LAB_ID_HIST]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSRH0_SPECIFIC_LAB_ID_HIST](
	[MTL_PREV_SPEC_LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_REPL_SPEC_LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_SPEC_LAB_ID_REPL_EFF_DT] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSRH0_SPECIFIC_LAB_ID_HIST_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSRH0_SPECIFIC_LAB_ID_HIST_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSSD0_LABID_SYN_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSSD0_LABID_SYN_STATUS_DESC](
	[MTL_LAB_ID_SYN_STATUS] [char](1) NOT NULL,
	[MTL_LAB_ID_SYN_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSSD0_LABID_SYN_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSSD0_LABID_SYN_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLSYN0_LAB_ID_SYN]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLSYN0_LAB_ID_SYN](
	[MTL_LAB_ID_SYNID] [numeric](8, 0) NOT NULL,
	[LAB_ID] [numeric](8, 0) NOT NULL,
	[MTL_LAB_ID_SYN_NMTYP_CODE] [varchar](2) NOT NULL,
	[MTL_LAB_ID_SYN_CODE_DESC] [varchar](100) NULL,
	[MTL_LAB_ID_SYN_STATUS] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLSYN0_LAB_ID_SYN_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLSYN0_LAB_ID_SYN_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RMTLVTD0_EXT_VOCAB_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RMTLVTD0_EXT_VOCAB_TYP_DESC](
	[MTL_EXTRN_VOCAB_TYP_CODE] [varchar](2) NOT NULL,
	[MTL_EXTRN_VOCAB_TYP_CODE_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RMTLVTD0_EXT_VOCAB_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RMTLVTD0_EXT_VOCAB_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDC14_NDC_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDC14_NDC_MSTR](
	[NDC] [varchar](11) NOT NULL,
	[LBLRID] [varchar](6) NULL,
	[GCN_SEQNO] [numeric](6, 0) NULL,
	[PS] [numeric](11, 3) NULL,
	[DF] [varchar](1) NULL,
	[AD] [varchar](20) NULL,
	[LN] [varchar](30) NULL,
	[BN] [varchar](30) NULL,
	[PNDC] [varchar](11) NULL,
	[REPNDC] [varchar](11) NULL,
	[NDCFI] [varchar](1) NULL,
	[DADDNC] [datetime] NULL,
	[DUPDC] [datetime] NULL,
	[DESI] [varchar](1) NULL,
	[DESDTEC] [datetime] NULL,
	[DESI2] [varchar](1) NULL,
	[DES2DTEC] [datetime] NULL,
	[DEA] [varchar](1) NULL,
	[CL] [varchar](1) NULL,
	[GPI] [varchar](1) NULL,
	[HOSP] [varchar](1) NULL,
	[INNOV] [varchar](1) NULL,
	[IPI] [varchar](1) NULL,
	[MINI] [varchar](1) NULL,
	[MAINT] [varchar](1) NULL,
	[OBC] [varchar](2) NULL,
	[OBSDTEC] [datetime] NULL,
	[PPI] [varchar](1) NULL,
	[STPK] [varchar](1) NULL,
	[REPACK] [varchar](1) NULL,
	[TOP200] [varchar](3) NULL,
	[UD] [varchar](1) NULL,
	[CSP] [numeric](7, 0) NULL,
	[NDL_GDGE] [numeric](5, 3) NULL,
	[NDL_LNGTH] [numeric](5, 3) NULL,
	[SYR_CPCTY] [numeric](5, 3) NULL,
	[SHLF_PCK] [numeric](7, 0) NULL,
	[SHIPPER] [numeric](7, 0) NULL,
	[HCFA_FDA] [varchar](2) NULL,
	[HCFA_UNIT] [varchar](3) NULL,
	[HCFA_PS] [numeric](11, 3) NULL,
	[HCFA_APPC] [datetime] NULL,
	[HCFA_MRKC] [datetime] NULL,
	[HCFA_TRMC] [datetime] NULL,
	[HCFA_TYP] [varchar](1) NULL,
	[HCFA_DESC1] [datetime] NULL,
	[HCFA_DESI1] [varchar](1) NULL,
	[UU] [varchar](1) NULL,
	[PD] [varchar](10) NULL,
	[LN25] [varchar](25) NULL,
	[LN25I] [varchar](1) NULL,
	[GPIDC] [datetime] NULL,
	[BBDC] [datetime] NULL,
	[HOME] [varchar](1) NULL,
	[INPCKI] [varchar](1) NULL,
	[OUTPCKI] [varchar](1) NULL,
	[OBC_EXP] [varchar](2) NULL,
	[PS_EQUIV] [numeric](11, 3) NULL,
	[PLBLR] [varchar](1) NULL,
	[TOP50GEN] [varchar](2) NULL,
	[OBC3] [varchar](3) NULL,
	[GMI] [varchar](1) NULL,
	[GNI] [varchar](1) NULL,
	[GSI] [varchar](1) NULL,
	[GTI] [varchar](1) NULL,
	[NDCGI1] [varchar](1) NULL,
	[HCFA_DC] [varchar](1) NULL,
	[LN60] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNDC14_NDC_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNDC14_NDC_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDCAT0_NDC_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDCAT0_NDC_ATTRIBUTE](
	[NDC] [varchar](11) NOT NULL,
	[NDC_ATTRIBUTE_TYPE_CD] [numeric](4, 0) NOT NULL,
	[NDC_ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[NDC_ATTRIBUTE_VALUE] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNDCAT0_NDC_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNDCAT0_NDC_ATTRIBUTE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDCDR0_NDC_DELETION_REASON]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDCDR0_NDC_DELETION_REASON](
	[FDB_PRODUCT_ID] [numeric](11, 0) NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[DADDNC] [datetime] NOT NULL,
	[LBLRID] [varchar](6) NOT NULL,
	[MFG] [varchar](15) NOT NULL,
	[OBSDTEC] [datetime] NULL,
	[NDC_DELETE_DATE] [datetime] NULL,
	[NDC_DELETE_REASON] [varchar](200) NULL,
	[BN] [varchar](30) NOT NULL,
	[LN60] [varchar](60) NOT NULL,
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[GENERIC_MEDID] [numeric](8, 0) NOT NULL,
	[GENERIC_MEDID_DESC] [varchar](70) NOT NULL,
	[MEDID] [numeric](8, 0) NOT NULL,
	[MED_MEDID_DESC] [varchar](70) NOT NULL,
	[REPLACEMENT_FDB_PRODUCT_ID] [numeric](11, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RNDCDR0_NDC_DELETION_REASON_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RNDCDR0_NDC_DELETION_REASON_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDCINH0_NDC_INACTV_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDCINH0_NDC_INACTV_LINK](
	[NDC] [varchar](11) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNDCINH0_NDC_INACTV_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNDCINH0_NDC_INACTV_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDCINR0_INACTV_REVIEWED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDCINR0_INACTV_REVIEWED](
	[NDC] [varchar](11) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNDCINR0_INACTV_REVIEWED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNDCINR0_INACTV_REVIEWED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDCTD0_NDC_ATTRIBUTE_TYP_DSC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDCTD0_NDC_ATTRIBUTE_TYP_DSC](
	[NDC_ATTRIBUTE_TYPE_CD] [numeric](4, 0) NOT NULL,
	[NDC_ATTRIBUTE_TYPE_DSC] [varchar](100) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNDCTD0_NDC_ATTRIBUTE_TYP_DSC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNDCTD0_NDC_ATTRIBUTE_TYP_DSC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNDCVD0_NDC_ATTRIBUTE_VALU_DSC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNDCVD0_NDC_ATTRIBUTE_VALU_DSC](
	[NDC_ATTRIBUTE_TYPE_CD] [numeric](4, 0) NOT NULL,
	[NDC_ATTRIBUTE_VALUE] [varchar](50) NOT NULL,
	[NDC_ATTRIBUTE_VALUE_DSC] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNDCVD0_NDC_ATTRIBUTE_VALU_DSC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNDCVD0_NDC_ATTRIBUTE_VALU_DSC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNP2_NDC_PRICE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNP2_NDC_PRICE](
	[NDC] [varchar](11) NOT NULL,
	[NPT_TYPE] [varchar](2) NOT NULL,
	[NPT_DATEC] [datetime] NOT NULL,
	[NPT_PRICEX] [numeric](11, 5) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNP2_NDC_PRICE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNP2_NDC_PRICE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RNPTYPD0_NDC_PRICE_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RNPTYPD0_NDC_PRICE_TYPE_DESC](
	[NPT_TYPE] [varchar](2) NOT NULL,
	[NPT_DESC] [varchar](6) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RNPTYPD0_NDC_PRICE_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RNPTYPD0_NDC_PRICE_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_ROBCD0_OBC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_ROBCD0_OBC_DESC](
	[OBC] [varchar](2) NOT NULL,
	[OBC_SN] [numeric](2, 0) NOT NULL,
	[OBC_DESC] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ROBCD0_OBC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_ROBCD0_OBC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_ROBCNDC0_OBC_NDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_ROBCNDC0_OBC_NDC](
	[NDC] [varchar](11) NOT NULL,
	[OBC3] [varchar](3) NOT NULL,
	[GCN] [numeric](5, 0) NOT NULL,
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[GTI] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ROBCNDC0_OBC_NDC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_ROBCNDC0_OBC_NDC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPDMMA1_PEDI_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPDMMA1_PEDI_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[PDM_MNAGE] [numeric](4, 0) NOT NULL,
	[PDM_MXAGE] [numeric](4, 0) NOT NULL,
	[PDM_MND] [numeric](12, 6) NULL,
	[PDM_MNDU] [varchar](2) NULL,
	[PDM_MNU] [numeric](12, 6) NULL,
	[PDM_MNUF] [varchar](2) NULL,
	[PDM_MXD] [numeric](12, 6) NULL,
	[PDM_MXDU] [varchar](2) NULL,
	[PDM_MXU] [numeric](12, 6) NULL,
	[PDM_MXUF] [varchar](2) NULL,
	[PDM_NTED] [numeric](12, 6) NULL,
	[PDM_NTEDU] [varchar](2) NULL,
	[PDM_NTEU] [numeric](12, 6) NULL,
	[PDM_NTEUF] [varchar](2) NULL,
	[DOSING_AGE_SOURCE_ID] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPDMMA1_PEDI_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPDMMA1_PEDI_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC](
	[PDM_UNIT] [varchar](2) NOT NULL,
	[PDM_UNDESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPDMUND0_PEDI_DOSE_UNIT_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPDMUND0_PEDI_DOSE_UNIT_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPDMWT1_PEDI_WEIGHT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPDMWT1_PEDI_WEIGHT](
	[PDM_MNAGE] [numeric](4, 0) NOT NULL,
	[PDM_MXAGE] [numeric](4, 0) NOT NULL,
	[PDM_AGEDSC] [varchar](30) NULL,
	[PDM_M05WT] [numeric](5, 2) NULL,
	[PDM_M25WT] [numeric](5, 2) NULL,
	[PDM_M50WT] [numeric](5, 2) NULL,
	[PDM_M75WT] [numeric](5, 2) NULL,
	[PDM_M95WT] [numeric](5, 2) NULL,
	[PDM_F05WT] [numeric](5, 2) NULL,
	[PDM_F25WT] [numeric](5, 2) NULL,
	[PDM_F50WT] [numeric](5, 2) NULL,
	[PDM_F75WT] [numeric](5, 2) NULL,
	[PDM_F95WT] [numeric](5, 2) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPDMWT1_PEDI_WEIGHT_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPDMWT1_PEDI_WEIGHT_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[PEDI_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEDIGC0_PEDI_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEDIGC0_PEDI_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEDIMA1_PEDI_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEDIMA1_PEDI_MSTR](
	[PEDI_CODE] [numeric](6, 0) NOT NULL,
	[PEDI_DESC] [varchar](34) NOT NULL,
	[PEDI_SL] [varchar](1) NOT NULL,
	[PEDI_MINAG] [numeric](4, 0) NOT NULL,
	[PEDI_MAXAG] [numeric](4, 0) NOT NULL,
	[PEDI_NARRATIVE] [varchar](500) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEDIMA1_PEDI_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEDIMA1_PEDI_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEDIRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEDIRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[PEDI_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEDIRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEDIRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEDIRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEDIRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[PEDI_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEDIRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEDIRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEDISD0_PEDI_SEVER_LEVEL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEDISD0_PEDI_SEVER_LEVEL_DESC](
	[PEDI_SL] [varchar](1) NOT NULL,
	[PEDI_SL_DESC] [varchar](255) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEDISD0_PEDI_SEVER_LEVEL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEDISD0_PEDI_SEVER_LEVEL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIAD0_ATTRIBUTE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIAD0_ATTRIBUTE_DESC](
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_DESC] [varchar](100) NOT NULL,
	[ATTRIBUTE_TYPE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_GROUP_CODE] [numeric](8, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIAD0_ATTRIBUTE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIAD0_ATTRIBUTE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIAL0_DF_ATTRIBUTE_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIAL0_DF_ATTRIBUTE_LINK](
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_ATTRIBUTE_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIAL0_DF_NDD_ATTRIBUTE_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIAL0_DF_NDD_ATTRIBUTE_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIAT0_ATTRIBUTE_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIAT0_ATTRIBUTE_TYPE_DESC](
	[ATTRIBUTE_TYPE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_TYPE_DESC] [varchar](100) NOT NULL,
	[ATTRIBUTE_TYPE_LENGTH] [numeric](8, 0) NULL,
	[ATTRIBUTE_TYPE_PRECISION] [numeric](8, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIAT0_ATTRIBUTE_TYPE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIAT0_ATTRIBUTE_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIAV0_ATTRIBUTE_VALUE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIAV0_ATTRIBUTE_VALUE_DESC](
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_VALUE] [varchar](100) NOT NULL,
	[ATTRIBUTE_VALUE_DESC] [varchar](100) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIAV0_ATTRIBUTE_VALUE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIAV0_ATTRIBUTE_VALUE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIDFA0_DOSAGE_FORM_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIDFA0_DOSAGE_FORM_ATTRIBUTE](
	[DOSAGE_FORM_ATTRIBUTE_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_ATTRIBUTE_DESC] [varchar](100) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIDFA0_DOSAGE_FORM_ATTRIBUTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIDFA0_DOSAGE_FORM_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIDM0_DOSAGE_FORM_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIDM0_DOSAGE_FORM_MSTR](
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_DESC_SHORT] [varchar](40) NULL,
	[DOSAGE_FORM_DESC_LONG] [varchar](75) NOT NULL,
	[DOSAGE_FORM_RETIRE_DT] [datetime] NULL,
	[UOM_MSTR_ID] [numeric](6, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIDM0_DOSAGE_FORM_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIDM0_DOSAGE_FORM_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIDT0_DOSAGE_FORM_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIDT0_DOSAGE_FORM_TYPE](
	[DOSAGE_FORM_TYPE_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_TYPE_DESC] [varchar](100) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIDT0_DOSAGE_FORM_TYPE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIDT0_DOSAGE_FORM_TYPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIGA0_GCNSEQNO_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIGA0_GCNSEQNO_ATTRIBUTE](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[ATTRIBUTE_VALUE] [varchar](100) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIGA0_GCNSEQNO_ATTRIBUTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIGA0_GCNSEQNO_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIGD0_GCNSEQNO_DF_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIGD0_GCNSEQNO_DF_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_TYPE_ID] [numeric](8, 0) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIGD0_GCNSEQNO_DF_NDD_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIGD0_GCNSEQNO_DF_NDD_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIGL0_GEN_DF_MSTR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIGL0_GEN_DF_MSTR_LINK](
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[GCDF] [varchar](2) NOT NULL,
	[PREFERRED_DOSAGE_FORM_IND] [numeric](1, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIGL0_GEN_DF_NDD_MSTR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIGL0_GEN_DF_NDD_MSTR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIGR0_GCNSEQNO_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIGR0_GCNSEQNO_RT_RELATION](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RELATION_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIGR0_GCNSEQNO_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIGR0_GCNSEQNO_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIGRR0_GCNSEQNO_REP_RT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIGRR0_GCNSEQNO_REP_RT](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[REPRESENTATIVE_RT_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIGRR0_GCNSEQNO_REP_RT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIGRR0_GCNSEQNO_REP_RT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIGS0_GCNSEQNO_STR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIGS0_GCNSEQNO_STR_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[STR_CONC_TYPE_ID] [numeric](8, 0) NOT NULL,
	[STR_SEQ] [numeric](4, 0) NOT NULL,
	[STRENGTH_STATUS_CODE] [numeric](1, 0) NOT NULL,
	[INGREDIENT_STR] [numeric](19, 6) NULL,
	[INGREDIENT_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[VOLUME] [numeric](19, 6) NULL,
	[VOLUME_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[ALT_STR] [numeric](19, 6) NULL,
	[ALT_STR_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[ALT_STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[TIME_VALUE] [numeric](6, 3) NULL,
	[TIME_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[RANGE_MAX] [numeric](19, 6) NULL,
	[RANGE_MIN] [numeric](19, 6) NULL,
	[DOSAGE_FORM_ATTRIBUTE_ID] [numeric](8, 0) NULL,
	[INGREDIENT_SORT_ORDER] [numeric](4, 0) NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIGS0_GCNSEQNO_STR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIGS0_GCNSEQNO_STR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIHR0_HICLSEQNO_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIHR0_HICLSEQNO_RT_RELATION](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RELATION_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIHR0_HICLSEQNO_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIHR0_HICLSEQNO_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIMA0_MED_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIMA0_MED_ATTRIBUTE](
	[MEDID] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[ATTRIBUTE_VALUE] [varchar](100) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIMA0_MED_ATTRIBUTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIMA0_MED_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIMD0_MED_DF_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIMD0_MED_DF_LINK](
	[MEDID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_TYPE_ID] [numeric](8, 0) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIMD0_MED_DF_NDD_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIMD0_MED_DF_NDD_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIML0_MED_DF_MSTR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIML0_MED_DF_MSTR_LINK](
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[MED_DOSAGE_FORM_ID] [numeric](5, 0) NOT NULL,
	[PREFERRED_DOSAGE_FORM_IND] [numeric](1, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIML0_MED_DF_NDD_MSTR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIML0_MED_DF_NDD_MSTR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIMNR0_MED_NAME_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIMNR0_MED_NAME_RT_RELATION](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RELATION_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIMNR0_MED_NAME_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIMNR0_MED_NAME_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIMRR0_MED_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIMRR0_MED_RT_RELATION](
	[MEDID] [numeric](8, 0) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RELATION_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIMRR0_MED_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIMRR0_MED_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIMS0_MED_STR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIMS0_MED_STR_LINK](
	[MEDID] [numeric](8, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[STR_CONC_TYPE_ID] [numeric](8, 0) NOT NULL,
	[STR_SEQ] [numeric](4, 0) NOT NULL,
	[STRENGTH_STATUS_CODE] [numeric](1, 0) NOT NULL,
	[INGREDIENT_STR] [numeric](19, 6) NULL,
	[INGREDIENT_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[VOLUME] [numeric](19, 6) NULL,
	[VOLUME_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[ALT_STR] [numeric](19, 6) NULL,
	[ALT_STR_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[ALT_STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[TIME_VALUE] [numeric](6, 3) NULL,
	[TIME_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[RANGE_MAX] [numeric](19, 6) NULL,
	[RANGE_MIN] [numeric](19, 6) NULL,
	[DOSAGE_FORM_ATTRIBUTE_ID] [numeric](8, 0) NULL,
	[INGREDIENT_SORT_ORDER] [numeric](4, 0) NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIMS0_MED_STR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIMS0_MED_STR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEINA0_MED_NAME_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEINA0_MED_NAME_ATTRIBUTE](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[ATTRIBUTE_VALUE] [varchar](100) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEINA0_MED_NAME_ATTRIBUTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEINA0_MED_NAME_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIND0_NDC_DF_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIND0_NDC_DF_LINK](
	[NDC] [varchar](11) NOT NULL,
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_TYPE_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIND0_NDC_DF_NDD_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIND0_NDC_DF_NDD_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEINR0_NDC_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEINR0_NDC_RT_RELATION](
	[NDC] [varchar](11) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RT_LABELED_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEINR0_NDC_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEINR0_NDC_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEINS0_NDC_STR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEINS0_NDC_STR_LINK](
	[NDC] [varchar](11) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[STR_CONC_TYPE_ID] [numeric](8, 0) NOT NULL,
	[STRENGTH_STATUS_CODE] [numeric](1, 0) NOT NULL,
	[INGREDIENT_STR] [numeric](19, 6) NULL,
	[INGREDIENT_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[VOLUME] [numeric](19, 6) NULL,
	[VOLUME_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[ALT_STR] [numeric](19, 6) NULL,
	[ALT_STR_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[ALT_STRENGTH_TYP_CODE] [numeric](1, 0) NULL,
	[TIME_VALUE] [numeric](6, 3) NULL,
	[TIME_UOM_MSTR_ID] [numeric](8, 0) NULL,
	[RANGE_MAX] [numeric](19, 6) NULL,
	[RANGE_MIN] [numeric](19, 6) NULL,
	[DOSAGE_FORM_ATTRIBUTE_ID] [numeric](8, 0) NULL,
	[INGREDIENT_SORT_ORDER] [numeric](4, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEINS0_NDC_STR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEINS0_NDC_STR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIOL0_OVW_DF_MSTR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIOL0_OVW_DF_MSTR_LINK](
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[OVW_DOSAGE_FORM_ID] [numeric](4, 0) NOT NULL,
	[PREFERRED_DOSAGE_FORM_IND] [numeric](1, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIOL0_OVW_DF_NDD_MSTR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIOL0_OVW_DF_NDD_MSTR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIPF0_POEM_DF_MSTR_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIPF0_POEM_DF_MSTR_LINK](
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[POEUNITCDE] [numeric](4, 0) NOT NULL,
	[PREFERRED_DOSAGE_FORM_IND] [numeric](1, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIPF0_POEM_DF_NDD_MSTR_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIPF0_POEM_DF_NDD_MSTR_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIPP0_PATIENT_PARAM_REQ_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIPP0_PATIENT_PARAM_REQ_DESC](
	[PATIENT_PARAM_REQ_CD] [numeric](4, 0) NOT NULL,
	[PATIENT_PARAM_REQ_CD_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIPP0_PATIENT_PARAM_REQ_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIPP0_PATIENT_PARAM_REQ_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRA0_RT_DF_MED_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRA0_RT_DF_MED_ATTRIBUTE](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[ATTRIBUTE_VALUE] [varchar](100) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRA0_RT_DF_NDD_MED_ATTRIBUTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRA0_RT_DF_NDD_MED_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRD0_RTD_DF_MED_DF_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRD0_RTD_DF_MED_DF_LINK](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_TYPE_ID] [numeric](8, 0) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRD0_RTD_DF_NDD_MED_DF_NDD_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRD0_RTD_DF_NDD_MED_DF_NDD_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRER0_RELATED_RT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRER0_RELATED_RT](
	[CONTINUOUS_RT_ID] [numeric](8, 0) NOT NULL,
	[INTERMITTENT_RT_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRER0_RELATED_RT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRER0_RELATED_RT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRH0_RT_HIERARCHY]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRH0_RT_HIERARCHY](
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRH0_RT_HIERARCHY_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRH0_RT_HIERARCHY_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRL0_RT_LABELED_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRL0_RT_LABELED_DESC](
	[RT_LABELED_ID] [numeric](8, 0) NOT NULL,
	[RT_LABELED_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRL0_RT_LABELED_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRL0_RT_LABELED_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRM0_RT_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRM0_RT_MSTR](
	[RT_ID] [numeric](8, 0) NOT NULL,
	[RT_DESC_SHORT] [varchar](50) NOT NULL,
	[RT_DESC_LONG] [varchar](50) NOT NULL,
	[RT_ADVERB] [varchar](50) NULL,
	[DR2_RT] [varchar](3) NULL,
	[DRCM_SCREEN_RT_ID] [varchar](3) NULL,
	[POEM_RT_ID] [numeric](4, 0) NULL,
	[MED_ROUTE_ID] [numeric](5, 0) NULL,
	[OVW_CLINICAL_RT_ID] [numeric](8, 0) NULL,
	[GCRT] [varchar](1) NULL,
	[DISC_RT_IND] [numeric](1, 0) NOT NULL,
	[DISC_RT_ADMIN_TEXT] [varchar](80) NULL,
	[VALID_CNS_RT_IND] [numeric](1, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRM0_RT_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRM0_RT_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRMA0_RTD_MED_ATTRIBUTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRMA0_RTD_MED_ATTRIBUTE](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_CODE] [numeric](8, 0) NOT NULL,
	[ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[ATTRIBUTE_VALUE] [varchar](100) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRMA0_RTD_MED_ATTRIBUTE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRMA0_RTD_MED_ATTRIBUTE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRMD0_RTD_MED_DF_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRMD0_RTD_MED_DF_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_ID] [numeric](8, 0) NOT NULL,
	[DOSAGE_FORM_TYPE_ID] [numeric](8, 0) NOT NULL,
	[LINK_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRMD0_RTD_MED_DF_NDD_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRMD0_RTD_MED_DF_NDD_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRMR0_RTD_MED_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRMR0_RTD_MED_RT_RELATION](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RELATION_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRMR0_RTD_MED_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRMR0_RTD_MED_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIRR0_RTD_DF_MED_RT_RELATION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIRR0_RTD_DF_MED_RT_RELATION](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[PARENT_RT_ID] [numeric](8, 0) NOT NULL,
	[CLINICAL_RT_ID] [numeric](8, 0) NOT NULL,
	[RELATION_INACTIVE_DATE] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIRR0_RTD_DF_NDD_MED_RT_RELATION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIRR0_RTD_DF_NDD_MED_RT_RELATION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIST0_STR_CONC_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIST0_STR_CONC_TYPE](
	[STR_CONC_TYPE_ID] [numeric](8, 0) NOT NULL,
	[STR_CONC_TYPE_DESC] [varchar](100) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIST0_STR_CONC_TYPE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIST0_STR_CONC_TYPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIUC0_UOM_CONVERSION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIUC0_UOM_CONVERSION](
	[FROM_UOM_MSTR_ID] [numeric](8, 0) NOT NULL,
	[TO_UOM_MSTR_ID] [numeric](8, 0) NOT NULL,
	[UOM_CONVERSION_FACTOR] [numeric](16, 6) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIUC0_UOM_CONVERSION_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIUC0_UOM_CONVERSION_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIUM0_UOM_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIUM0_UOM_MSTR](
	[UOM_MSTR_ID] [numeric](8, 0) NOT NULL,
	[UOM_MSTR_DESC] [varchar](80) NOT NULL,
	[UOM_MSTR_PLURAL_DESC] [varchar](80) NOT NULL,
	[UOM_MSTR_ABBR] [varchar](80) NOT NULL,
	[UOM_MSTR_PLURAL_ABBR] [varchar](80) NOT NULL,
	[UOM_MSTR_PREFERRED_DESC] [varchar](80) NOT NULL,
	[UOM_MSTR_PLURAL_PREFERRED_DESC] [varchar](80) NOT NULL,
	[UOM_STDS_ORG_DESC] [varchar](80) NOT NULL,
	[UOM_PLURAL_STDS_ORG_DESC] [varchar](80) NOT NULL,
	[UOM_STDS_ORG_ABBR] [varchar](80) NOT NULL,
	[UOM_PLURAL_STDS_ORG_ABBR] [varchar](80) NOT NULL,
	[UOM_MSTR_COMPONENT1_ID] [numeric](8, 0) NOT NULL,
	[UOM_MSTR_COMPONENT2_ID] [numeric](8, 0) NULL,
	[UOM_MSTR_COMPONENT3_ID] [numeric](8, 0) NULL,
	[UOM_TYPE_CD] [numeric](4, 0) NULL,
	[RATIO_IND] [numeric](1, 0) NOT NULL,
	[RATE_IND] [numeric](1, 0) NOT NULL,
	[DOSE_IND] [numeric](1, 0) NOT NULL,
	[INTERVAL_IND] [numeric](1, 0) NOT NULL,
	[PATIENT_PARAM_REQ_CD] [numeric](4, 0) NULL,
	[PARAM_INCORP_UOM_ID] [numeric](8, 0) NULL,
	[PEDIATRIC_DOSE_TEXT_IND] [numeric](1, 0) NOT NULL,
	[COMPARISON_UOM_ID] [numeric](8, 0) NULL,
	[DR2_UNITS] [varchar](2) NULL,
	[POEUNITCDE] [numeric](4, 0) NULL,
	[UOM_ID] [numeric](8, 0) NULL,
	[OVW_UOM_ID] [numeric](8, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIUM0_UOM_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIUM0_UOM_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEIUT0_UOM_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEIUT0_UOM_TYPE_DESC](
	[UOM_TYPE_CD] [numeric](4, 0) NOT NULL,
	[UOM_TYPE_CD_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPEIUT0_UOM_TYPE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPEIUT0_UOM_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEMGC0_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEMGC0_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[PEC] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEMGC0_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEMGC0_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEMMA5_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEMMA5_MSTR](
	[PEC] [numeric](6, 0) NOT NULL,
	[DGNAME] [varchar](30) NULL,
	[LBLMSG1] [varchar](27) NULL,
	[LBLMSG2] [varchar](27) NULL,
	[PEMONO] [numeric](4, 0) NULL,
	[AMACDE] [varchar](3) NULL,
	[PHMXCDE] [varchar](3) NULL,
	[USPCDE] [varchar](4) NULL,
	[NARDCDE] [varchar](3) NULL,
	[ASHPCDE3] [numeric](6, 0) NULL,
	[PEMONOS] [numeric](4, 0) NULL,
	[PEMONOFRA] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEMMA5_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEMMA5_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEMMOE2_MONO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEMMOE2_MONO](
	[PEMONO] [numeric](4, 0) NOT NULL,
	[PEMONOE_SN] [numeric](3, 0) NOT NULL,
	[PEMTXTEI] [varchar](1) NULL,
	[PEMTXTE] [varchar](76) NULL,
	[PEMGNDR] [varchar](1) NULL,
	[PEMAGE] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEMMOE2_MONO_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEMMOE2_MONO_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEMOGC0_MONO_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEMOGC0_MONO_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[PEMONO] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEMOGC0_MONO_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEMOGC0_MONO_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEMORG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEMORG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[PEMONO] [numeric](4, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEMORG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEMORG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPEMRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPEMRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[PEC] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPEMRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPEMRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEAR1_ADMINISTRATION_RATE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEAR1_ADMINISTRATION_RATE](
	[POEOSTRID] [numeric](10, 0) NOT NULL,
	[POEADMINSQ] [numeric](2, 0) NOT NULL,
	[POEADRT] [numeric](8, 3) NULL,
	[POEADRTUNT] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEAR1_ADMINISTRATION_RATE_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEAR1_ADMINISTRATION_RATE_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOECD1_DEFINITION]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOECD1_DEFINITION](
	[POEUNITCDE] [numeric](4, 0) NOT NULL,
	[POELANGCDE] [numeric](2, 0) NOT NULL,
	[POECOCDE] [numeric](2, 0) NOT NULL,
	[POEUNITTYP] [numeric](1, 0) NOT NULL,
	[POEDESC1] [varchar](30) NULL,
	[POEDESC2] [varchar](20) NULL,
	[POEDESC3] [varchar](20) NULL,
	[POEPERDAYC] [numeric](8, 4) NULL,
	[POEDISPQTY] [numeric](1, 0) NULL,
	[POEMLCNVRS] [numeric](4, 0) NULL,
	[POECALCRTC] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOECD1_DEFINITION_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOECD1_DEFINITION_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOECL1_CLIN_CONTEXT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOECL1_CLIN_CONTEXT](
	[POECLINID] [numeric](6, 0) NOT NULL,
	[POECLINTYP] [numeric](2, 0) NOT NULL,
	[POECLINVAL] [varchar](2) NOT NULL,
	[POEMINRANG] [numeric](8, 2) NULL,
	[POEMAXRANG] [numeric](8, 2) NULL,
	[POERANGUNT] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOECL1_CLIN_CONTEXT_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOECL1_CLIN_CONTEXT_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOECOD0_COUNTRY_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOECOD0_COUNTRY_DESC](
	[POECOCDE] [numeric](2, 0) NOT NULL,
	[POECOCDE_DESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOECOD0_COUNTRY_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOECOD0_COUNTRY_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOECRD0_CALC_REQ_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOECRD0_CALC_REQ_TYPE_DESC](
	[POECALCRTC] [varchar](1) NOT NULL,
	[POECALCRTC_DESC] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOECRD0_CALC_REQ_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOECRD0_CALC_REQ_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOECTD0_CLIN_CONTEXT_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOECTD0_CLIN_CONTEXT_TYP_DESC](
	[POECLINTYP] [numeric](2, 0) NOT NULL,
	[POECLINTYP_DESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOECTD0_CLIN_CONTEXT_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOECTD0_CLIN_CONTEXT_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOECVD0_CLIN_CONTEXT_VAL_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOECVD0_CLIN_CONTEXT_VAL_DESC](
	[POECLINVAL] [varchar](2) NOT NULL,
	[POECLINVAL_DESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOECVD0_CLIN_CONTEXT_VAL_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOECVD0_CLIN_CONTEXT_VAL_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEDTD0_DOSE_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEDTD0_DOSE_TYPE_DESC](
	[POEDOSETYP] [varchar](2) NOT NULL,
	[POEDOSETYP_DESC] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEDTD0_DOSE_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEDTD0_DOSE_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEGCS1_STANDARD_ORDER]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEGCS1_STANDARD_ORDER](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[POECLINID] [numeric](6, 0) NOT NULL,
	[POEOSETID] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEGCS1_STANDARD_ORDER_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEGCS1_STANDARD_ORDER_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEGSQ2_GCNSEQNO_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEGSQ2_GCNSEQNO_MSTR](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[FDBDX] [varchar](9) NOT NULL,
	[POEOSETID] [numeric](6, 0) NOT NULL,
	[POECLINID] [numeric](6, 0) NOT NULL,
	[DXID] [numeric](8, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEGSQ2_GCNSEQNO_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEGSQ2_GCNSEQNO_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOELGD0_LANGUAGE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOELGD0_LANGUAGE_DESC](
	[POELANGCDE] [numeric](2, 0) NOT NULL,
	[POELANGCDE_DESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOELGD0_LANGUAGE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOELGD0_LANGUAGE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEOS1_ORDER_SET]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEOS1_ORDER_SET](
	[POEOSETID] [numeric](6, 0) NOT NULL,
	[POEOSTRSEQ] [numeric](2, 0) NOT NULL,
	[POEOSTRID] [numeric](10, 0) NOT NULL,
	[POEDOSETYP] [varchar](2) NOT NULL,
	[POECALCREQ] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEOS1_ORDER_SET_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEOS1_ORDER_SET_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEOSR1_ORDER_STRING]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEOSR1_ORDER_STRING](
	[POEOSTRID] [numeric](10, 0) NOT NULL,
	[POEROUTE] [numeric](4, 0) NULL,
	[POEROUTE_D] [numeric](1, 0) NOT NULL,
	[POELOWD] [numeric](12, 4) NULL,
	[POELOWDU] [numeric](4, 0) NULL,
	[POEHIGHD] [numeric](12, 4) NULL,
	[POEHIGHDU] [numeric](4, 0) NULL,
	[POELOWDFA] [numeric](6, 2) NULL,
	[POELOWDFU] [numeric](4, 0) NULL,
	[POEHIGHDFA] [numeric](6, 2) NULL,
	[POEHIGHDFU] [numeric](4, 0) NULL,
	[POELOWF] [numeric](3, 0) NULL,
	[POELOWI] [numeric](3, 0) NULL,
	[POELOWIU] [numeric](4, 0) NULL,
	[POEHIGHF] [numeric](3, 0) NULL,
	[POEHIGHI] [numeric](3, 0) NULL,
	[POEHIGHIU] [numeric](4, 0) NULL,
	[POESLOWF] [numeric](3, 0) NULL,
	[POESLOWI] [numeric](3, 0) NULL,
	[POESLOWIU] [numeric](4, 0) NULL,
	[POESHIGHF] [numeric](3, 0) NULL,
	[POESHIGHI] [numeric](3, 0) NULL,
	[POESHIGHIU] [numeric](4, 0) NULL,
	[POELOWDR] [numeric](3, 0) NULL,
	[POELOWDRU] [numeric](4, 0) NULL,
	[POEHIGHDR] [numeric](3, 0) NULL,
	[POEHIGHDRU] [numeric](4, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEOSR1_ORDER_STRING_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEOSR1_ORDER_STRING_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEOSX1_TEXT_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEOSX1_TEXT_LINK](
	[POEOSTRID] [numeric](10, 0) NOT NULL,
	[POETEXTTYP] [numeric](2, 0) NOT NULL,
	[POETXTSTRL] [numeric](1, 0) NOT NULL,
	[POETEXTCDE] [numeric](10, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEOSX1_TEXT_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEOSX1_TEXT_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOERDD0_ROUTE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOERDD0_ROUTE_DESC](
	[POEROUTE_D] [numeric](1, 0) NOT NULL,
	[POEROUTE_D_DESC] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOERDD0_ROUTE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOERDD0_ROUTE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOETSD0_TEXT_STR_LOC_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOETSD0_TEXT_STR_LOC_DESC](
	[POETXTSTRL] [numeric](1, 0) NOT NULL,
	[POETXTSTRL_DESC] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOETSD0_TEXT_STR_LOC_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOETSD0_TEXT_STR_LOC_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOETTD0_TEXT_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOETTD0_TEXT_TYPE_DESC](
	[POETEXTTYP] [numeric](2, 0) NOT NULL,
	[POETEXTTYP_DESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOETTD0_TEXT_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOETTD0_TEXT_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOETXT1_TEXT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOETXT1_TEXT](
	[POETEXTCDE] [numeric](10, 0) NOT NULL,
	[POELANGCDE] [numeric](2, 0) NOT NULL,
	[POECOCDE] [numeric](2, 0) NOT NULL,
	[POETXTNUM] [numeric](3, 0) NOT NULL,
	[POETXLINE] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOETXT1_TEXT_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOETXT1_TEXT_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPOEUTD0_UNIT_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPOEUTD0_UNIT_TYPE_DESC](
	[POEUNITTYP] [numeric](1, 0) NOT NULL,
	[POEUNITTYP_DESC] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPOEUTD0_UNIT_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPOEUTD0_UNIT_TYPE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRD0_PRODUCT]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRD0_PRODUCT](
	[FDB_PRODUCT_ID] [numeric](11, 0) NOT NULL,
	[FDB_PRODUCT_STATUS_CD] [varchar](8) NOT NULL,
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[LBLRID] [varchar](6) NOT NULL,
	[LABEL_NAME] [varchar](255) NOT NULL,
	[FDB_PRODUCT_FIRST_DELIVERY_DT] [datetime] NOT NULL,
	[FDB_PRODUCT_OBSOLETE_DT] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRD0_PRODUCT_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRD0_PRODUCT_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDCC0_CURRENCY_CD_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDCC0_CURRENCY_CD_DESC](
	[CURRENCY_CD] [varchar](3) NOT NULL,
	[CURRENCY_CD_DESC] [varchar](100) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDCC0_CURRENCY_CD_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDCC0_CURRENCY_CD_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPA0_PRICE_ATTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPA0_PRICE_ATTR](
	[FDB_PRODUCT_ID] [numeric](11, 0) NOT NULL,
	[PRICE_TYPE_ID] [numeric](3, 0) NOT NULL,
	[PRICE_EFFECTIVE_DT] [datetime] NOT NULL,
	[PRICE_ATTRIBUTE_CD] [varchar](8) NOT NULL,
	[PRICE_ATTRIBUTE_SN] [numeric](4, 0) NOT NULL,
	[PRICE_ATTRIBUTE_VALUE_SN] [numeric](4, 0) NOT NULL,
	[PRICE_ATTRIBUTE_VALUE] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPA0_PRICE_ATTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPA0_PRICE_ATTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPAD0_PRICE_ATTR_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPAD0_PRICE_ATTR_DESC](
	[PRICE_ATTRIBUTE_CD] [varchar](8) NOT NULL,
	[PRICE_ATTRIBUTE_DESC] [varchar](100) NOT NULL,
	[PRICE_ATTRIBUTE_TYPE_CD] [varchar](8) NOT NULL,
	[PRICE_ATTRIBUTE_GROUP_CD] [varchar](8) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPAD0_PRICE_ATTR_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPAD0_PRICE_ATTR_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPAT0_PRICE_ATTR_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPAT0_PRICE_ATTR_TYPE_DESC](
	[PRICE_ATTRIBUTE_TYPE_CD] [varchar](8) NOT NULL,
	[PRICE_ATTRIBUTE_TYPE_DESC] [varchar](100) NOT NULL,
	[PRICE_ATTRIBUTE_TYPE_LENGTH] [numeric](8, 0) NULL,
	[PRICE_ATTRIBUTE_TYPE_PRECISION] [numeric](8, 0) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPAT0_PRICE_ATTR_TYPE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPAT0_PRICE_ATTR_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPAV0_PRICE_ATTR_VALUE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPAV0_PRICE_ATTR_VALUE_DESC](
	[PRICE_ATTRIBUTE_CD] [varchar](8) NOT NULL,
	[PRICE_ATTRIBUTE_VALUE] [varchar](255) NOT NULL,
	[PRICE_ATTRIBUTE_VALUE_DESC] [varchar](500) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPAV0_PRICE_ATTR_VALUE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPAV0_PRICE_ATTR_VALUE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPC0_EXT_PRODUCT_CD]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPC0_EXT_PRODUCT_CD](
	[FDB_PRODUCT_ID] [numeric](11, 0) NOT NULL,
	[EXT_PRODUCT_CD_TYPE_ID] [numeric](8, 0) NOT NULL,
	[EXT_PRODUCT_CD_START_DT] [datetime] NOT NULL,
	[EXT_PRODUCT_CD] [varchar](100) NOT NULL,
	[EXT_PRODUCT_CD_END_DT] [datetime] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPC0_EXT_PRODUCT_CD_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPC0_EXT_PRODUCT_CD_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPCD0_EXT_PRODUCT_CD_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPCD0_EXT_PRODUCT_CD_DESC](
	[EXT_PRODUCT_CD_TYPE_ID] [numeric](8, 0) NOT NULL,
	[EXT_PRODUCT_CD_DESC] [varchar](50) NOT NULL,
	[EXT_PRODUCT_CD_DATA_TYPE] [varchar](20) NOT NULL,
	[EXT_PRODUCT_CD_FIELD_LENGTH] [numeric](8, 0) NOT NULL,
	[EXT_PRODUCT_CD_DEFINITION] [varchar](2000) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPCD0_EXT_PRODUCT_CD_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPCD0_EXT_PRODUCT_CD_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPKD0_PACKAGE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPKD0_PACKAGE_DESC](
	[PACKAGE_TYPE_ID] [numeric](8, 0) NOT NULL,
	[PKG_TYPE_LONG_DESC] [varchar](50) NOT NULL,
	[PKG_TYPE_SHORT_DESC] [varchar](10) NOT NULL,
	[ACTIVELY_USED_IND] [varchar](1) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPKD0_PACKAGE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPKD0_PACKAGE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPP0_PRODUCT_PRICE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPP0_PRODUCT_PRICE](
	[FDB_PRODUCT_ID] [numeric](11, 0) NOT NULL,
	[PRICE_TYPE_ID] [numeric](3, 0) NOT NULL,
	[PRICE_EFFECTIVE_DT] [datetime] NOT NULL,
	[PRICE] [numeric](18, 7) NOT NULL,
	[PRICE_QTY] [numeric](18, 7) NOT NULL,
	[PRICE_UOM_ID] [numeric](8, 0) NOT NULL,
	[CURRENCY_CD] [varchar](3) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPP0_PRODUCT_PRICE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPP0_PRODUCT_PRICE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDPTD0_PRICE_TYPE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDPTD0_PRICE_TYPE_DESC](
	[PRICE_TYPE_ID] [numeric](3, 0) NOT NULL,
	[PRICE_TYPE_SHORT_DESC] [varchar](10) NOT NULL,
	[PRICE_TYPE_LONG_DESC] [varchar](50) NULL,
	[NPT_TYPE] [varchar](2) NULL,
	[PRICE_TYPE_DEFINITION] [varchar](2000) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDPTD0_PRICE_TYPE_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDPTD0_PRICE_TYPE_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDSD0_PRODUCT_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDSD0_PRODUCT_STATUS_DESC](
	[FDB_PRODUCT_STATUS_CD] [varchar](8) NOT NULL,
	[FDB_PRODUCT_STATUS_DESC] [varchar](50) NOT NULL,
	[FDB_PRODUCT_STATUS_DEFINITION] [varchar](2000) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDSD0_PRODUCT_STATUS_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDSD0_PRODUCT_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPRDUOM0_PRICE_QTY_UOM]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPRDUOM0_PRICE_QTY_UOM](
	[PRICE_UOM_ID] [numeric](8, 0) NOT NULL,
	[PRICE_UOM_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPRDUOM0_PRICE_QTY_UOM_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPRDUOM0_PRICE_QTY_UOM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGGC0_PREG_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGGC0_PREG_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPREGGC0_PREG_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPREGGC0_PREG_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGMA0_PREG_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGMA0_PREG_MSTR](
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[PREG_DESC] [varchar](41) NULL,
	[PREG_SL] [varchar](1) NULL,
	[PREG_PRCTN] [varchar](80) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPREGMA0_PREG_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPREGMA0_PREG_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGMA1_PREG_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGMA1_PREG_MSTR](
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[PREG_DESC] [varchar](41) NOT NULL,
	[PREG_SL] [varchar](1) NOT NULL,
	[PREG_BOXED_WARNING_IND] [varchar](1) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGMA1_PREG_MSTR_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGMA1_PREG_MSTR_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGMS0_MONO_SECTION_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGMS0_MONO_SECTION_DESC](
	[PREG_MONO_SECTION_CD] [numeric](4, 0) NOT NULL,
	[PREG_MONO_SECTION_CD_DESC] [varchar](50) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGMS0_MONO_SECTION_DESC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGMS0_MONO_SECTION_DESC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGPL0_PREG_MONO_LINE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGPL0_PREG_MONO_LINE](
	[PREG_MONO_ID] [numeric](8, 0) NOT NULL,
	[PREG_MONO_SECTION_CD] [numeric](4, 0) NOT NULL,
	[PREG_MONO_SN] [numeric](2, 0) NOT NULL,
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[PREG_MONO_LINE] [varchar](500) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGPL0_PREG_MONO_LINE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGPL0_PREG_MONO_LINE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGRE0_PREG_REFERENCE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGRE0_PREG_REFERENCE](
	[PREG_REFERENCE_ID] [numeric](8, 0) NOT NULL,
	[PREG_REFERNCE_TYPE_ID] [numeric](8, 0) NOT NULL,
	[PREG_REFERENCE_TITLE] [varchar](255) NOT NULL,
	[PREG_REFERENCE_AUTHOR] [varchar](255) NULL,
	[PREG_REFERENCE_NAME] [varchar](255) NULL,
	[PREG_REFERENCE_ISSUE_DT_TXT] [varchar](25) NULL,
	[PREG_REFERENCE_VOLUME] [varchar](80) NULL,
	[PREG_REFERENCE_SUPPLEMENT_NBR] [varchar](80) NULL,
	[PREG_REFERENCE_EDITION] [varchar](80) NULL,
	[PREG_REFERENCE_LOCATION] [varchar](80) NULL,
	[PREG_REFERENCE_ACCESSED_DT] [numeric](8, 0) NULL,
	[PREG_REFERENCE_ISSUE] [varchar](80) NULL,
	[PREG_REFERENCE_PAGE] [varchar](80) NULL,
	[PREG_REFERENCE_PUBMED_ID] [varchar](50) NULL,
	[PREG_REFERENCE_URL_TEXT] [varchar](500) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGRE0_PREG_REFERENCE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGRE0_PREG_REFERENCE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGRG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGRG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPREGRG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPREGRG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGRL0_PREG_REFERENCE_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGRL0_PREG_REFERENCE_LINK](
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[PREG_REFERENCE_ID] [numeric](8, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGRL0_PREG_REFERENCE_LINK_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGRL0_PREG_REFERENCE_LINK_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGRM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGRM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[PREG_CODE] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPREGRM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPREGRM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGRT0_PREG_REFERENCE_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGRT0_PREG_REFERENCE_TYPE](
	[PREG_REFERENCE_TYPE_ID] [numeric](8, 0) NOT NULL,
	[PREG_REFERENCE_TYPE_DESC] [varchar](255) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGRT0_PREG_REFERENCE_TYPE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGRT0_PREG_REFERENCE_TYPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGSL0_PREG_SEVER_LEVEL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGSL0_PREG_SEVER_LEVEL](
	[PREG_SL] [varchar](1) NOT NULL,
	[PREG_SLSN] [numeric](2, 0) NOT NULL,
	[PREG_SLD] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RPREGSL0_PREG_SEVER_LEVEL_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RPREGSL0_PREG_SEVER_LEVEL_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RPREGSL1_PREG_SEVER_LEVEL]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RPREGSL1_PREG_SEVER_LEVEL](
	[PREG_SL] [varchar](1) NOT NULL,
	[PREG_SLSN] [numeric](2, 0) NOT NULL,
	[PREG_SLD] [varchar](60) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RPREGSL1_PREG_SEVER_LEVEL_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RPREGSL1_PREG_SEVER_LEVEL_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RROUTED3_ROUTE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RROUTED3_ROUTE_DESC](
	[GCRT] [varchar](1) NOT NULL,
	[RT] [varchar](10) NULL,
	[GCRT2] [varchar](2) NULL,
	[GCRT_DESC] [varchar](40) NULL,
	[SYSTEMIC] [varchar](1) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RROUTED3_ROUTE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RROUTED3_ROUTE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RRTGN0_ROUTED_GEN_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RRTGN0_ROUTED_GEN_MSTR](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[ROUTED_GEN_DESC] [varchar](100) NOT NULL,
	[GCRT] [varchar](1) NOT NULL,
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[ROUTED_GEN_STATUS_CD] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RRTGN0_ROUTED_GEN_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RRTGN0_ROUTED_GEN_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RRTGNGC0_RTD_GEN_GCNSEQNO_LNK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RRTGNGC0_RTD_GEN_GCNSEQNO_LNK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RRTGNGC0_RTD_GEN_GCNSEQNO_LNK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RRTGNGC0_RTD_GEN_GCNSEQNO_LNK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RRTGNND0_ROUTED_GEN_NDC_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RRTGNND0_ROUTED_GEN_NDC_LINK](
	[NDC] [varchar](11) NOT NULL,
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RRTGNND0_ROUTED_GEN_NDC_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RRTGNND0_ROUTED_GEN_NDC_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RRTGNSD0_RTD_GEN_STATUS_DSC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RRTGNSD0_RTD_GEN_STATUS_DSC](
	[ROUTED_GEN_STATUS_CD] [varchar](1) NOT NULL,
	[ROUTED_GEN_STATUS_CD_DESC] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RRTGNSD0_RTD_GEN_STATUS_DSC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RRTGNSD0_RTD_GEN_STATUS_DSC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSIDEDD0_DRUG_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSIDEDD0_DRUG_DESC](
	[SIDE] [numeric](5, 0) NOT NULL,
	[SIDE_DRUG_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSIDEDD0_DRUG_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSIDEDD0_DRUG_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSIDEGC0_GCNSEQNO_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSIDEGC0_GCNSEQNO_LINK](
	[GCN_SEQNO] [numeric](6, 0) NOT NULL,
	[SIDE] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSIDEGC0_GCNSEQNO_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSIDEGC0_GCNSEQNO_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSIDEMA3_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSIDEMA3_MSTR](
	[SIDE] [numeric](5, 0) NOT NULL,
	[SIDE_SN] [numeric](2, 0) NOT NULL,
	[FDBDX] [varchar](9) NULL,
	[SIDE_FREQ] [varchar](1) NULL,
	[SIDE_SEV] [varchar](1) NULL,
	[SIDE_VISCD] [varchar](1) NULL,
	[SIDE_LABCD] [varchar](1) NULL,
	[SIDE_PHYS] [varchar](1) NULL,
	[SIDE_HYPER] [varchar](1) NULL,
	[DXID] [numeric](8, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSIDEMA3_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSIDEMA3_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSIDERG0_ROUTED_GEN_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSIDERG0_ROUTED_GEN_LINK](
	[ROUTED_GEN_ID] [numeric](8, 0) NOT NULL,
	[SIDE] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSIDERG0_ROUTED_GEN_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSIDERG0_ROUTED_GEN_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSIDERM0_ROUTED_MED_LINK]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSIDERM0_ROUTED_MED_LINK](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[SIDE] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSIDERM0_ROUTED_MED_LINK_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSIDERM0_ROUTED_MED_LINK_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSTR1_STRNGTH_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSTR1_STRNGTH_DESC](
	[STR60] [varchar](60) NOT NULL,
	[STRNUM] [numeric](11, 3) NULL,
	[VOLNUM] [numeric](7, 3) NULL,
	[STRUN50] [varchar](50) NULL,
	[VOLUN50] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSTR1_STRNGTH_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSTR1_STRNGTH_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSTRSCD0_STRENGTH_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSTRSCD0_STRENGTH_STATUS_DESC](
	[STRENGTH_STATUS_CODE] [numeric](1, 0) NOT NULL,
	[STRENGTH_STATUS_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSTRSCD0_STRENGTH_STATUS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSTRSCD0_STRENGTH_STATUS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSTRTD0_STRENGTH_TYP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSTRTD0_STRENGTH_TYP_DESC](
	[STRENGTH_TYP_CODE] [numeric](1, 0) NOT NULL,
	[STRENGTH_TYP_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSTRTD0_STRENGTH_TYP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSTRTD0_STRENGTH_TYP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RSTRUOM0_STRENGTH_UOM]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RSTRUOM0_STRENGTH_UOM](
	[UOM_ID] [numeric](8, 0) NOT NULL,
	[UOM_DESC] [varchar](50) NULL,
	[UOM_ABBR] [varchar](10) NULL,
	[UOM_PREFERRED_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RSTRUOM0_STRENGTH_UOM_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RSTRUOM0_STRENGTH_UOM_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTCD0_STD_THERAP_CLASS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTCD0_STD_THERAP_CLASS_DESC](
	[TC] [numeric](2, 0) NOT NULL,
	[TC_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTCD0_STD_THERAP_CLASS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTCD0_STD_THERAP_CLASS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMDFCG0_TM_RTD_DF_CNFSN_GRP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMDFCG0_TM_RTD_DF_CNFSN_GRP](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[TM_GROUP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMDFCG0_TM_RTD_DF_CNFSN_GRP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMDFCG0_TM_RTD_DF_CNFSN_GRP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMDFID1_TM_ROUTED_DF_MED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMDFID1_TM_ROUTED_DF_MED](
	[ROUTED_DOSAGE_FORM_MED_ID] [numeric](8, 0) NOT NULL,
	[TM_SOURCE_ID] [numeric](5, 0) NULL,
	[TM_IND] [numeric](1, 0) NULL,
	[TM_ALT_ROUTED_DF_MED_ID_DESC] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMDFID1_TM_ROUTED_DF_MED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMDFID1_TM_ROUTED_DF_MED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMDT0_TM_NAME_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMDT0_TM_NAME_TYPE](
	[TM_NAME_TYPE_ID] [numeric](5, 0) NOT NULL,
	[TM_NAME_TYPE_DESC] [varchar](30) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RTMDT0_TM_NAME_TYPE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RTMDT0_TM_NAME_TYPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMGRPD1_TM_GROUP_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMGRPD1_TM_GROUP_DESC](
	[TM_GROUP_ID] [numeric](5, 0) NOT NULL,
	[TM_GROUP_DESC] [varchar](250) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMGRPD1_TM_GROUP_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMGRPD1_TM_GROUP_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMMICG0_TM_MED_CNFSN_GRP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMMICG0_TM_MED_CNFSN_GRP](
	[MEDID] [numeric](8, 0) NOT NULL,
	[TM_GROUP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMMICG0_TM_MED_CNFSN_GRP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMMICG0_TM_MED_CNFSN_GRP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMMID1_TM_MED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMMID1_TM_MED](
	[MEDID] [numeric](8, 0) NOT NULL,
	[TM_SOURCE_ID] [numeric](5, 0) NULL,
	[TM_IND] [numeric](1, 0) NULL,
	[TM_ALT_MEDID_DESC] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMMID1_TM_MED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMMID1_TM_MED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMNCG0_TM_NDC_CNFSN_GRP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMNCG0_TM_NDC_CNFSN_GRP](
	[NDC] [varchar](11) NOT NULL,
	[TM_GROUP_ID] [numeric](5, 0) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RTMNCG0_TM_NDC_CNFSN_GRP_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RTMNCG0_TM_NDC_CNFSN_GRP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMNGN0_TM_GNN]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMNGN0_TM_GNN](
	[HICL_SEQNO] [numeric](6, 0) NOT NULL,
	[TM_GNN_TYPE_ID] [numeric](5, 0) NOT NULL,
	[TM_SOURCE_ID] [numeric](5, 0) NOT NULL,
	[TM_IND] [numeric](1, 0) NOT NULL,
	[TM_ALT_GNN_DESC] [varchar](60) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RTMNGN0_TM_GNN_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RTMNGN0_TM_GNN_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMNGT0_TM_GNN_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMNGT0_TM_GNN_TYPE](
	[TM_GNN_TYPE_ID] [numeric](5, 0) NOT NULL,
	[TM_GNN_TYPE_DESC] [varchar](30) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RTMNGT0_TM_GNN_TYPE_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RTMNGT0_TM_GNN_TYPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMNID0_TM_NDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMNID0_TM_NDC](
	[NDC] [varchar](11) NOT NULL,
	[TM_NAME_TYPE_ID] [numeric](5, 0) NOT NULL,
	[TM_SOURCE_ID] [numeric](5, 0) NULL,
	[TM_IND] [numeric](1, 0) NOT NULL,
	[TM_ALT_NDC_DESC] [varchar](60) NOT NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_RTMNID0_TM_NDC_IsDelete]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_RTMNID0_TM_NDC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMNMCG0_TM_MED_NAME_CNFSN_GRP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMNMCG0_TM_MED_NAME_CNFSN_GRP](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[TM_GROUP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMNMCG0_TM_MED_NAME_CNFSN_GRP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMNMCG0_TM_MED_NAME_CNFSN_GRP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMNMID1_TM_MED_NAME]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMNMID1_TM_MED_NAME](
	[MED_NAME_ID] [numeric](8, 0) NOT NULL,
	[TM_SOURCE_ID] [numeric](5, 0) NULL,
	[TM_IND] [numeric](1, 0) NULL,
	[TM_ALT_MED_NAME_DESC] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMNMID1_TM_MED_NAME_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMNMID1_TM_MED_NAME_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMRMCG0_TM_RTD_MED_CNFSN_GRP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMRMCG0_TM_RTD_MED_CNFSN_GRP](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[TM_GROUP_ID] [numeric](5, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMRMCG0_TM_RTD_MED_CNFSN_GRP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMRMCG0_TM_RTD_MED_CNFSN_GRP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMRMID1_TM_ROUTED_MED]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMRMID1_TM_ROUTED_MED](
	[ROUTED_MED_ID] [numeric](8, 0) NOT NULL,
	[TM_SOURCE_ID] [numeric](5, 0) NULL,
	[TM_IND] [numeric](1, 0) NULL,
	[TM_ALT_ROUTED_MED_ID_DESC] [varchar](70) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMRMID1_TM_ROUTED_MED_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMRMID1_TM_ROUTED_MED_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RTMSRCD1_TM_SOURCE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RTMSRCD1_TM_SOURCE_DESC](
	[TM_SOURCE_ID] [numeric](5, 0) NOT NULL,
	[TM_SOURCE_DESC] [varchar](120) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RTMSRCD1_TM_SOURCE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RTMSRCD1_TM_SOURCE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RUNITSD0_UNITS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RUNITSD0_UNITS_DESC](
	[DOSING_MODULE_UNIT_ABBREV] [varchar](30) NOT NULL,
	[UNIT_DESC_ABBREV] [varchar](30) NULL,
	[UNIT_DESC_EXPANDED] [varchar](60) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RUNITSD0_UNITS_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RUNITSD0_UNITS_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRFAHX0_AGCSP_HICSEQN]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRFAHX0_AGCSP_HICSEQN](
	[DAM_AGCSP] [numeric](6, 0) NOT NULL,
	[HIC_SEQN] [numeric](6, 0) NOT NULL,
	[HIC] [varchar](6) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRFAHX0_AGCSP_HICSEQN_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRFAHX0_AGCSP_HICSEQN_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRFDDX0_DACN_AGCSP]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRFDDX0_DACN_AGCSP](
	[DACN] [varchar](2) NOT NULL,
	[DAM_AGCSP] [numeric](6, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRFDDX0_DACN_AGCSP_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRFDDX0_DACN_AGCSP_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRFHCX0_HICSEQN_CHEMNO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRFHCX0_HICSEQN_CHEMNO](
	[HIC_SEQN] [numeric](6, 0) NULL,
	[CHEMNO] [varchar](4) NULL,
	[CHEMSE] [varchar](2) NULL,
	[HIC] [varchar](6) NULL,
	[XRF_STATUS] [varchar](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRFPCX0_PIF_ALG_CHEMNO]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRFPCX0_PIF_ALG_CHEMNO](
	[PIF_ALG] [numeric](5, 0) NOT NULL,
	[PIF_ALGSUB] [varchar](2) NOT NULL,
	[CHEMNO] [varchar](4) NOT NULL,
	[CHEMSE] [varchar](2) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRFSCD0_STATUS_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRFSCD0_STATUS_DESC](
	[XRF_STATUS] [varchar](1) NOT NULL,
	[XRF_STATUS_DESC] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsDelete] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRGDFQ0_GCDF_SCRIPT_QQ]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRGDFQ0_GCDF_SCRIPT_QQ](
	[GCDF] [varchar](2) NOT NULL,
	[SCRIPT_QQ_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRGDFQ0_GCDF_SCRIPT_QQ_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRGDFQ0_GCDF_SCRIPT_QQ_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRMDFQ0_MEDDOSFM_SCRIPT_QQ]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRMDFQ0_MEDDOSFM_SCRIPT_QQ](
	[MED_DOSAGE_FORM_ID] [numeric](5, 0) NOT NULL,
	[SCRIPT_QQ_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRMDFQ0_MEDDOSFM_SCRIPT_QQ_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRMDFQ0_MEDDOSFM_SCRIPT_QQ_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRNCQQ0_QQ_MSTR]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRNCQQ0_QQ_MSTR](
	[SCRIPT_QQ_ID] [numeric](8, 0) NOT NULL,
	[SCRIPT_QQ_CD] [varchar](10) NULL,
	[SCRIPT_QQ_DESC] [varchar](50) NULL,
	[XRF_SOURCE_ID] [numeric](4, 0) NULL,
	[OBSOLETE_DATE] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRNCQQ0_QQ_MSTR_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRNCQQ0_QQ_MSTR_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRNSRC0_SOURCE_DESC]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRNSRC0_SOURCE_DESC](
	[XRF_SOURCE_ID] [numeric](4, 0) NOT NULL,
	[XRF_SOURCE_DESC] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRNSRC0_SOURCE_DESC_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRNSRC0_SOURCE_DESC_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_RXRPDFQ0_POEMDOSFM_SCRIPT_QQ]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_RXRPDFQ0_POEMDOSFM_SCRIPT_QQ](
	[POEUNITCDE] [numeric](4, 0) NOT NULL,
	[SCRIPT_QQ_ID] [numeric](8, 0) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RXRPDFQ0_POEMDOSFM_SCRIPT_QQ_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RXRPDFQ0_POEMDOSFM_SCRIPT_QQ_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_SearchDispensable]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_SearchDispensable](
	[medid] [int] NOT NULL,
	[gcnseqno] [int] NOT NULL,
	[GENERIC_MEDID] [int] NULL,
	[MED_STRENGTH] [varchar](15) NULL,
	[MED_STRENGTH_UOM] [varchar](15) NULL,
	[STRENGTH_UOM] [varchar](10) NULL,
	[VOLUME_UOM] [varchar](10) NULL,
	[MedDesc] [varchar](70) NOT NULL,
	[SearchMedDesc] [varchar](72) NOT NULL,
	[StatusCode] [varchar](1) NOT NULL,
	[StatusCodeDescription] [varchar](30) NOT NULL,
	[IsMedicalDevice] [bit] NULL,
	[NameSourceCode] [varchar](1) NOT NULL,
	[RefFederalLegendCode] [varchar](1) NOT NULL,
	[RefMultiSourceCode] [varchar](1) NOT NULL,
	[RefGenericDrugNameCode] [varchar](1) NULL,
	[IsSingleIngredient] [bit] NULL,
	[rdfmid] [int] NULL,
	[rmid] [int] NULL,
	[rtid] [int] NULL,
	[RouteAbbr] [varchar](4) NULL,
	[RouteDesc] [varchar](30) NULL,
	[dfid] [int] NULL,
	[DosageFormAbbr] [varchar](4) NULL,
	[DosageFormDesc] [varchar](30) NULL,
	[hicl] [int] NULL,
	[RefFederalDEAClassCode] [varchar](1) NOT NULL,
	[classid] [int] NULL,
	[ClassName] [varchar](70) NULL,
	[RxNormCode] [varchar](50) NULL,
	[RxNormQualifier] [varchar](20) NULL,
	[NDC] [varchar](11) NULL,
	[mnid] [int] NULL,
	[DrugName] [varchar](30) NULL,
	[DrugNameTypeCode] [varchar](1) NULL,
	[DrugNameType] [varchar](30) NULL,
	[DrugNameRxNormCode] [varchar](50) NULL,
	[DrugNameRxNormQualifier] [varchar](10) NULL,
	[GenericMedDesc] [varchar](70) NULL,
	[GenericRMID] [int] NULL,
	[GenericMNID] [int] NULL,
	[GenericDrugName] [varchar](30) NULL,
	[GenericRxNormCode] [varchar](50) NULL,
	[GenericRxNormQualifier] [varchar](10) NULL,
	[GenericNDC] [varchar](11) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_SearchDispensable_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_SearchDispensable_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_SearchDrugName]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_SearchDrugName](
	[mnid] [int] NOT NULL,
	[hicl] [int] NULL,
	[DrugName] [varchar](30) NOT NULL,
	[SearchDrugName] [varchar](32) NOT NULL,
	[DrugNameTypeCode] [varchar](1) NULL,
	[DrugNameType] [varchar](30) NULL,
	[StatusCode] [varchar](1) NOT NULL,
	[StatusCodeDescription] [varchar](30) NOT NULL,
	[classid] [int] NULL,
	[ClassName] [varchar](70) NULL,
	[DrugNameRxNormCode] [varchar](50) NULL,
	[DrugNameRxNormQualifier] [varchar](10) NULL,
	[IsMedicalDevice] [bit] NULL,
	[GenericMNID] [int] NULL,
	[GenericDrugName] [varchar](30) NULL,
	[GenericNameRxNormCode] [varchar](50) NULL,
	[GenericNameRxNormQualifier] [varchar](10) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_SearchDrugName_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_SearchDrugName_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_SearchRouted]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_SearchRouted](
	[rmid] [int] NOT NULL,
	[hicl] [int] NULL,
	[RoutedMedDesc] [varchar](60) NOT NULL,
	[SearchRoutedMedDesc] [varchar](62) NOT NULL,
	[StatusCode] [varchar](1) NOT NULL,
	[StatusCodeDescription] [varchar](30) NOT NULL,
	[classid] [int] NULL,
	[ClassName] [varchar](70) NULL,
	[mnid] [int] NULL,
	[DrugName] [varchar](30) NULL,
	[DrugNameTypeCode] [varchar](1) NULL,
	[DrugNameType] [varchar](30) NULL,
	[DrugNameRxNormCode] [varchar](50) NULL,
	[DrugNameRxNormQualifier] [varchar](10) NULL,
	[GenericMNID] [int] NULL,
	[GenericDrugName] [varchar](30) NULL,
	[GenericNameRxNormCode] [varchar](50) NULL,
	[GenericNameRxNormQualifier] [varchar](10) NULL,
	[rtid] [int] NULL,
	[RouteAbbr] [varchar](4) NULL,
	[RouteDesc] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_SearchRouted_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_SearchRouted_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NDD_SearchRxNorm]') AND type in (N'U'))
BEGIN
CREATE TABLE [NDD_SearchRxNorm](
	[PK_HASH] [varbinary](64) NOT NULL,
	[RxNormCode] [varchar](50) NOT NULL,
	[RxNormTermType] [varchar](20) NULL,
	[RxNormQualifier] [varchar](20) NULL,
	[IsBrandName] [bit] NOT NULL,
	[medid] [int] NULL,
	[mnid] [int] NULL,
	[NDC] [varchar](11) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NDD_SearchRxNorm_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_NDD_SearchRxNorm_IsDelete]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VersionCommon]') AND type in (N'U'))
BEGIN
CREATE TABLE [VersionCommon](
	[PRMVersion] [varchar](24) NOT NULL,
	[PRMSeq] [int] NOT NULL,
	[PRMBuild] [varchar](24) NULL,
	[ReleaseName] [varchar](50) NULL,
	[Vendor] [varchar](50) NULL,
	[Status] [int] NOT NULL CONSTRAINT [DF_VersionPRM_Status]  DEFAULT ((0)),
	[Message] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VersionPRM_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VersionPRM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'IMO_ICD_MODIFIER', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ICD_MODIFIER'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'IMO_ICD_MODIFIER', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ICD_MODIFIER'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'IMO_ICD_MODIFIER_MAP', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ICD_MODIFIER_MAP'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'IMO_ICD_MODIFIER_MAP', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ICD_MODIFIER_MAP'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductCommon', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductCommon'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MASTER_MU2_InterfaceDataMapping', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MASTER_MU2_InterfaceDataMapping'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MASTER_MU2_InterfaceDataMapping', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MASTER_MU2_InterfaceDataMapping'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MasterDiagnosis', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterDiagnosis'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MasterDiagnosis', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterDiagnosis'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MasterDiagnosisSnomed', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterDiagnosisSnomed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverCache' , N'SCHEMA',N'dbo', N'TABLE',N'MasterDiagnosisSnomed', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterDiagnosisSnomed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MasterDiagnosisSnomed', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterDiagnosisSnomed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'DataType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key, growth chart type, like BMI,Weight_for_Age_2_20' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'DataType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'Gender'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key; 1 = Male, 2 = Female' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'Gender'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'Agemos'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'Agemos'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'L'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'L'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'M'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'M'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'S'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'S'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'sigma'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'sigma'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P2'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P2'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P3'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P3'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P5'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P5'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P10'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P10'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P25'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P25'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P50'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P50'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P75'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P75'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P85'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P85'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P90'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P90'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P95'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P95'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P97'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P97'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P98'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P98'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P99'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P99'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P99_9'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P99_9'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'P99_99'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of a growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'P99_99'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Child a growth chart statistic data' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MasterExtendedGrowthChart', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterExtendedGrowthChart'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'DataType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key, growth chart type, like BMI,Weight_for_Age_2_20' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'DataType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'Gender'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key; 1 = Male, 2 = Female' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'Gender'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'Agemos'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key; data downloaded from CDC to draw the curve of g' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'Agemos'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'L'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'L'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'M'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'M'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'S'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'S'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P3'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P3'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P5'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P5'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P10'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P10'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P25'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P25'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P50'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P50'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P75'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P75'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P85'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P85'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P90'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P90'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P95'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P95'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'P97'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data downloaded from CDC to draw the curve of growth chart' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'P97'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Child Growth Chart statistic data' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MasterGrowthChart', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterGrowthChart'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterLoinc', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterLoinc', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterLoinc', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterLoinc', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'MasterLoinc', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Master LOINC' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterLoinc'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MasterLoinc', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterLoinc'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverCache' , N'SCHEMA',N'dbo', N'TABLE',N'MasterLoinc', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterLoinc'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MasterLoinc', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterLoinc'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'MasterProcedure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterProcedure'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'MasterProcedure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MasterProcedure'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommon', N'COLUMN',N'PRMVersion'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'3 digit version number, e.g., 5.0.0' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommon', @level2type=N'COLUMN',@level2name=N'PRMVersion'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommon', N'COLUMN',N'PRMSeq'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'sequence number under Version. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommon', @level2type=N'COLUMN',@level2name=N'PRMSeq'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommon', N'COLUMN',N'PRMBuild'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'YYYYMMDD format. Optional info for the build.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommon', @level2type=N'COLUMN',@level2name=N'PRMBuild'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommon', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommon'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommon', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommon'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommon', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommon'
GO

