-- copied from ReportUpdates.sql to fix unique index migration issue
-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- disable these triggers before updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] DISABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] DISABLE TRIGGER [BlockReportUpdates]
GO

-- #123865 Update ListReport ListReportRdl Patient Aging PRE-MIGRATION.sql
-- Set Patient Aging Summary to point to Patient Aging report, not Patient Aging Summary
UPDATE ListReportRdl 
SET ReportUid = '6A544119-CA00-4D3A-AC39-098C700E8C0C' -- Patient Aging
WHERE ReportRdlUid = 'C32A9E49-6440-4AF0-B73D-6CD417CA62CE' -- Patient Aging Summary
GO
-- Delete Patient Aging Summary Report
IF EXISTS (SELECT * FROM ListReport WHERE ReportUid = 'EDD56C27-4DC3-4474-8FFA-13915263DE3E') 
	DELETE 
	FROM ListReport
	WHERE ReportUid = 'EDD56C27-4DC3-4474-8FFA-13915263DE3E' -- Patient Aging Summary
GO
-- #127498 _PRE_UIConfiguration_Changes.sql
IF OBJECT_ID('cus_ListUIConfiguration', 'U') IS NULL
	SELECT *
	INTO cus_ListUIConfiguration
	FROM ListUIConfiguration

IF OBJECT_ID('cus_ListGroupUIConfiguration', 'U') IS NULL
	SELECT *
	INTO cus_ListGroupUIConfiguration
	FROM ListGroupUIConfiguration
GO

-- #149101  PreMigrationScript_VisitsWithoutSuperbillForGenerationJob.sql
IF EXISTS(SELECT * FROM ListJob WHERE JobUid = '02222391-AA94-4570-9AAB-0066FD334E1D' AND UserDefined = 1)
	UPDATE ListJob SET UserDefined = 0 WHERE JobUid = '02222391-AA94-4570-9AAB-0066FD334E1D'
IF EXISTS(SELECT * FROM JobSchedule WHERE JobScheduleUid = 'D0BB4EF7-5F6B-4F47-B4C9-966961DEEAA4' AND UserDefined = 1)
	UPDATE JobSchedule SET UserDefined = 0 WHERE JobScheduleUid = 'D0BB4EF7-5F6B-4F47-B4C9-966961DEEAA4'
GO

-- 159327 _PRE_Migration.sql
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'aa2c1f7c-dfe4-4fd8-be5c-3799918708cf') --User / User Group
BEGIN
DELETE FROM ListUserDefinedControl where UserDefinedControlUid = 'aa2c1f7c-dfe4-4fd8-be5c-3799918708cf'
END
GO
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '572d82ff-8d55-4366-b330-821a26857de8') -- Security / Security Group
BEGIN
DELETE FROM  ListUserDefinedControl where UserDefinedControlUid = '572d82ff-8d55-4366-b330-821a26857de8'
END
GO




--------------------------------------------------------------------------------
-- no need to enable the trigger above as it will enable in ReportUpdates.sql
-- Keep this at the bottom
-- cleanup lingering FK references
DELETE PSD
FROM   PrintSetDetail PSD
WHERE  ReportUid NOT IN (SELECT ReportUid FROM ListReport)
GO

