-- #127498 _POST_UIConfiguration_Changes.sql
-- Insert or update into ListUIConfiguration
MERGE INTO ListUIConfiguration AS target
USING (
    SELECT 
        UIConfigurationUid,  
        (CASE DataTypeId
            WHEN 1 THEN '54980156-422F-496B-9929-75AAFDABE25A'
            WHEN 2 THEN 'A79BA35A-FB35-4064-AD76-7EBBD7334655'
            ELSE NULL
        END) AS UIConfigurationDataTypeUid,
        ExternalID,
        Name,
        Notes,
        Data,
        Inactive,
        UserDefined,
        LastModifiedByUid,
        LastModifiedDate
    FROM cus_ListUIConfiguration
) AS source
ON (target.UIConfigurationUid = source.UIConfigurationUid)
WHEN MATCHED THEN
    UPDATE SET 
        target.UIConfigurationDataTypeUid = source.UIConfigurationDataTypeUid
WHEN NOT MATCHED BY TARGET THEN
    INSERT (
        UIConfigurationUid, 
        UIConfigurationDataTypeUid, 
        ExternalID, 
        Name, 
        Notes, 
        Data, 
        Inactive, 
        UserDefined, 
        LastModifiedByUid, 
        LastModifiedDate
    )
    VALUES (
        source.UIConfigurationUid, 
        source.UIConfigurationDataTypeUid, 
        source.ExternalID, 
        source.Name, 
        source.Notes, 
        source.Data, 
        source.Inactive, 
        source.UserDefined, 
        source.LastModifiedByUid, 
        source.LastModifiedDate
    );
GO
-- Insert or update into ListGroupUIConfiguration
MERGE INTO ListGroupUIConfiguration AS target
USING (
    SELECT 
        GroupUIConfigurationUid,
        (CASE DataTypeId
            WHEN 1 THEN 'A79BA35A-FB35-4064-AD76-7EBBD7334655'
            ELSE NULL
        END) AS UIConfigurationDataTypeUid,
        ExternalID,
        Name,
        RestrictedToPersonUid,
        Notes,
        Inactive,
        UserDefined,
        LastModifiedByUid,
        LastModifiedDate
    FROM cus_ListGroupUIConfiguration
) AS source
ON (target.GroupUIConfigurationUid = source.GroupUIConfigurationUid)
WHEN MATCHED THEN
    UPDATE SET 
        target.UIConfigurationDataTypeUid = source.UIConfigurationDataTypeUid
WHEN NOT MATCHED BY TARGET THEN
    INSERT (
        GroupUIConfigurationUid, 
        UIConfigurationDataTypeUid, 
        ExternalID, 
        Name, 
        RestrictedToPersonUid, 
        Notes, 
        Inactive, 
        UserDefined, 
        LastModifiedByUid, 
        LastModifiedDate
    )
    VALUES (
        source.GroupUIConfigurationUid, 
        source.UIConfigurationDataTypeUid, 
        source.ExternalID, 
        source.Name, 
        source.RestrictedToPersonUid, 
        source.Notes, 
        source.Inactive, 
        source.UserDefined, 
        source.LastModifiedByUid, 
        source.LastModifiedDate
    );
GO
-- #127498 end

-- #133566 _Migrate_ListDpnGroup_From_ListProductParameter.sql
UPDATE dpn
SET LockNodes = 1
FROM ListProductParameter lpp
CROSS APPLY lpp.XMLValue.nodes('/DpnConfiguration/LockNodes') AS mdx(nod)
CROSS APPLY (SELECT DpnGroupUid = mdx.nod.value('@DpnGroupUid[1]', 'VARCHAR(MAX)')) uid
INNER JOIN ListDpnGroup dpn ON dpn.DpnGroupUid = uid.DpnGroupUid
WHERE lpp.ParameterName = 'DpnConfiguration' AND lpp.ProductParameterUid = 'EDB3AC2D-8E3B-497B-ABBA-147AAB06B684'

DELETE ListProductParameter WHERE ParameterName = 'DpnConfiguration' AND ProductParameterUid = 'EDB3AC2D-8E3B-497B-ABBA-147AAB06B684'
GO

-- #142533_DeactivateTestMetricsExportJob .sql
IF EXISTS(SELECT *
          FROM ListProductParameter lpp
          WHERE ParameterName = 'RegistrationCustomerLicense'
            AND 'true' = lpp.XMLValue.value('(/License/@test)[1]', 'VARCHAR(10)')
            AND LastModifiedDate = (SELECT MAX(LastModifiedDate) FROM ListProductParameter WHERE ParameterName = 'RegistrationCustomerLicense'))
 AND NOT EXISTS(SELECT * FROM ListProductParameter WHERE ProductParameterUid = '216E07EB-37D0-43DC-8C5F-57C243B789E7' AND ParameterName = 'MetricsExportJob.DeactiveTest')
 AND EXISTS(SELECT * FROM JobSchedule WHERE Inactive = 0 AND JobScheduleUid = 'F4BCAD57-A310-4DE7-A500-0BC88CF60FE4')
 BEGIN
   BEGIN
      UPDATE JobSchedule 
      SET Inactive = 1
      WHERE JobScheduleUid in ('F4BCAD57-A310-4DE7-A500-0BC88CF60FE4')

      INSERT INTO ListProductParameter(ProductParameterUid, ParameterName, BoolValue) 
      VALUES('216E07EB-37D0-43DC-8C5F-57C243B789E7', 'MetricsExportJob.DeactiveTest', 1)
   END
END
GO

-- #152269 _QAUpdateForAppointmentCancellations.sql
update ListIcPollingProcessor
set SendablePayload = 'PollAppointmentCancelRequests', WebApiDirectory = 'api/Polling/PollAppointmentCancelRequests', MessageName = 'PollAppointmentCancelRequests'
where IcPollingProcessorUid = 'E396831B-E95C-4A5A-BB01-22CB4A76E76B'
GO