-- #55793 _migration_insert_default_facilityportal_formattingmodal.sql
-- ===========================================================
-- User Story: 55793 - Facility Portal: Add a Column in 
--                     User Setting Clinical Note Type Tab
--
-- Description: For each clinical note type in ListUserSettings,
--              insert a default visit formatting modal for 
--              Facility Portal.
--
-- Developer: djost
--
-- History: 2023.02.20 - Script created.
-- =========================================================== 
BEGIN TRY
  BEGIN TRANSACTION 
    WHILE EXISTS(SELECT * 
                 FROM ListUserSetting 
                 WHERE 1 = ClinicalNoteTypes.exist('/items/item[not(facilityportal)]'))
    BEGIN
      UPDATE ListUserSetting
        SET ClinicalNoteTypes.modify('insert <facilityportal Uid="872b2d51-4402-40ff-ab9f-bee133bb913f" Name="RPN Visit Form version 2.0" /> into (/items/item[not(facilityportal)])[1]') 
        WHERE 1 = ClinicalNoteTypes.exist('/items/item[not(facilityportal)]')
    END 
  COMMIT TRANSACTION
  -- SELECT 'ListUserSetting updated successfully.'
  -- SELECT * FROM ListUserSetting ORDER BY Name
END TRY
BEGIN CATCH
  DECLARE @ErrorMessage NVARCHAR(4000)
  DECLARE @ErrorSeverity INT
  DECLARE @ErrorState INT

  SELECT @ErrorMessage = ERROR_MESSAGE(),
         @ErrorSeverity = ERROR_SEVERITY(),
         @ErrorState = ERROR_STATE()

	ROLLBACK TRANSACTION
	SELECT 'Exception thrown updating ListUSerSetting.  Rolled back db transaction.'
	SELECT @ErrorMessage 
	SELECT @ErrorSeverity
	SELECT @ErrorState
END CATCH