-- items required for both New Install and Migration
-- 111723 - Homepage migration needs COMPATIBILITY_LEVEL = 130 for OPENJSON
DECLARE @dbname SYSNAME = db_name (), @sql NVARCHAR (MAX), @SQLVersion varchar(24), @Level varchar(4)
SELECT @SQLVersion = CONVERT(varchar(24),SERVERPROPERTY('productversion'))
IF (@SQLVersion like '13%')  -- 2016
	SET  @Level = '130'
ELSE IF (@SQLVersion like '14%')  -- 2017
	SET  @Level = '140'
ELSE IF (@SQLVersion like '15%')  -- 2019
	SET  @Level = '150'
ELSE IF (@SQLVersion like '16%')  -- 2022
	SET  @Level = '160'
SET @sql = N'ALTER DATABASE ' + QUOTENAME(@dbname) + N' SET COMPATIBILITY_LEVEL = '+ @Level +'; ' +
	N'ALTER DATABASE ' + QUOTENAME(@dbname + N'_Attachment') + N' SET COMPATIBILITY_LEVEL = '+ @Level +'; '
exec sp_executesql @sql

-- #92687 Event Driven Delivery: enable Service Broker
SET @sql = N'IF ((Select is_broker_enabled FROM sys.databases WHERE name = ''' + @dbname + N''') = 0)' + CHAR (10) +
	N'ALTER DATABASE ' + QUOTENAME(@dbname) + N' SET NEW_BROKER WITH ROLLBACK IMMEDIATE;'
exec sp_executesql @sql

---  Keep the items above regardless of the version of the db.


-- #116600 19.0 migration fixes due to 18.6 table changes
/*
	71557 - Appointment Connection Tracking for CGM Connect
	2022-03-30   BRoy  Moved from 18.7 to 18.6
*/
IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelAppointmentConnect]') AND type in (N'U'))
BEGIN
	CREATE TABLE [dbo].[RelAppointmentConnect](
		[RelAppointmentConnectUid] [uniqueidentifier] NOT NULL,
		[AppointmentUid] [uniqueidentifier] NOT NULL,
		[OptOut] [bit] NOT NULL,
		[RecordXml] [varchar](max) NULL,
		[CreatedDate] [datetime] NOT NULL,
		[LastModifiedDate] [datetime] NOT NULL,
		[LastModifiedByUid] [uniqueidentifier] NULL,
	 CONSTRAINT [PK_RelAppointmentConnect] PRIMARY KEY CLUSTERED 
	(
		[RelAppointmentConnectUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	ALTER TABLE [dbo].[RelAppointmentConnect] ADD  CONSTRAINT [DF_RelAppointmentConnect_RelAppointmentConnectUid]  DEFAULT (newid()) FOR [RelAppointmentConnectUid]
	ALTER TABLE [dbo].[RelAppointmentConnect] ADD  CONSTRAINT [DF_RelAppointmentConnect_OptOut]  DEFAULT ((0)) FOR [OptOut]
	ALTER TABLE [dbo].[RelAppointmentConnect] ADD  CONSTRAINT [DF_RelAppointmentConnect_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDate]
	ALTER TABLE [dbo].[RelAppointmentConnect] ADD  CONSTRAINT [DF_RelAppointmentConnect_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	ALTER TABLE [dbo].[RelAppointmentConnect]  WITH CHECK ADD  CONSTRAINT [FK_RelAppointmentConnect_Appointment] FOREIGN KEY([AppointmentUid])
		REFERENCES [dbo].[Appointment] ([AppointmentUid])
	ALTER TABLE [dbo].[RelAppointmentConnect] CHECK CONSTRAINT [FK_RelAppointmentConnect_Appointment]
END
/*
	71557 - Communication Preferences for CGM Connect
	2022-03-30   BRoy  Moved from 18.7 to 18.6
*/
IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CommunicationPreference]') AND type in (N'U'))
BEGIN
	CREATE TABLE [dbo].[CommunicationPreference](
		[CommunicationPreferenceUid] [uniqueidentifier] NOT NULL,
		[PersonUid] [uniqueidentifier] NOT NULL,
		[IntegrationPartnerUid] [uniqueidentifier] NULL,
		[OptOut] [bit] NULL,
		[EmailAddress] [varchar](100) NULL,
		[VoiceNumber] [varchar](100) NULL,
		[SmsNumber] [varchar](100) NULL,
		[LastModifiedByUid] [uniqueidentifier] NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CommunicationPreference] PRIMARY KEY CLUSTERED 
	(
		[CommunicationPreferenceUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
	ALTER TABLE [dbo].[CommunicationPreference] ADD  CONSTRAINT [DF_CommunicationPreference_CommunicationPreferencesUid]  DEFAULT (newid()) FOR [CommunicationPreferenceUid]
	ALTER TABLE [dbo].[CommunicationPreference] ADD  CONSTRAINT [DF_CommunicationPreference_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	ALTER TABLE [dbo].[CommunicationPreference]  WITH CHECK ADD  CONSTRAINT [FK_CommunicationPreference_ListIntegrationPartner] FOREIGN KEY([IntegrationPartnerUid])
		REFERENCES [dbo].[ListIntegrationPartner] ([IntegrationPartnerUid])
	ALTER TABLE [dbo].[CommunicationPreference] CHECK CONSTRAINT [FK_CommunicationPreference_ListIntegrationPartner]
	ALTER TABLE [dbo].[CommunicationPreference]  WITH CHECK ADD  CONSTRAINT [FK_CommunicationPreference_Person] FOREIGN KEY([PersonUid])
		REFERENCES [dbo].[Person] ([PersonUid])
	ALTER TABLE [dbo].[CommunicationPreference] CHECK CONSTRAINT [FK_CommunicationPreference_Person]
END
-- #110183 eMEDIX Statements-Database  Changes for Financial Center to Add Pay To Address and phone numbers for statements
	IF NOT EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'PayToAddress' AND Object_ID = Object_ID(N'dbo.FinancialCenter')) 
		BEGIN ALTER TABLE dbo.FinancialCenter ADD PayToAddress XML(dbo.Address) null END
	IF NOT EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'PayToPhone1'  AND Object_ID = Object_ID(N'dbo.FinancialCenter')) 
		BEGIN ALTER TABLE dbo.FinancialCenter ADD PayToPhone1  XML(dbo.Phone)   null END
	IF NOT EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'PayToPhone2'  AND Object_ID = Object_ID(N'dbo.FinancialCenter')) 
		BEGIN ALTER TABLE dbo.FinancialCenter ADD PayToPhone2  XML(dbo.Phone)   null END
	IF NOT EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'PayToPhone3'  AND Object_ID = Object_ID(N'dbo.FinancialCenter')) 
		BEGIN ALTER TABLE dbo.FinancialCenter ADD PayToPhone3  XML(dbo.Phone)   null END
	IF NOT EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'PayToPhone4'  AND Object_ID = Object_ID(N'dbo.FinancialCenter')) 
		BEGIN ALTER TABLE dbo.FinancialCenter ADD PayToPhone4  XML(dbo.Phone)   null END

-- 110184 eMEDIX Statements-  Database Changes for Practice Settings  Add Phone 2, Phone 3, and Phone 4 to Billing Address Phone Numbers
	IF NOT EXISTS(SELECT * FROM   INFORMATION_SCHEMA.COLUMNS WHERE  TABLE_NAME = 'PracticeSettings' AND COLUMN_NAME = 'Phone2') 
		BEGIN ALTER TABLE practiceSettings ADD Phone2 XML(dbo.Phone) NULL END
	IF NOT EXISTS(SELECT * FROM   INFORMATION_SCHEMA.COLUMNS WHERE  TABLE_NAME = 'PracticeSettings' AND COLUMN_NAME = 'Phone3')
		BEGIN ALTER TABLE practiceSettings ADD Phone3 XML(dbo.Phone) NULL END
	IF NOT EXISTS(SELECT * FROM   INFORMATION_SCHEMA.COLUMNS WHERE  TABLE_NAME = 'PracticeSettings' AND COLUMN_NAME = 'Phone4')
		BEGIN ALTER TABLE practiceSettings ADD Phone4 XML(dbo.Phone) NULL END
-- #113200 _FINANCIALCENTER_COPY_PAYTOADDRESS_FROM_ADDRESS_WHERE_PAYTOADDRESS_ISNULL.sql
	IF EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'PayToAddress' AND Object_ID = Object_ID(N'dbo.FinancialCenter'))
	BEGIN
	  DECLARE @SqlStatement VarChar(500) = 'Update FinancialCenter set PayToAddress = Address where PayToAddress is null and Address is not null'
	  EXEC(@SqlStatement)
	END	


-- 19.0 migration added unique index and there were dups
;WITH DuplicateCTE AS
(
SELECT PersonUid, IntegrationPartnerUid, RowNumber = ROW_NUMBER() OVER(PARTITION 	
	BY PersonUid, IntegrationPartnerUid ORDER BY LastModifiedDate DESC) FROM CommunicationPreference
)  
delete from DuplicateCTE WHERE RowNumber > 1
GO
-- #116600 end