<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-physicianaccess.com:paweb" >
  <xsl:strip-space elements="*"/>
  <xsl:param name="ForPrinting" select="0" />
  <xsl:output method="html" version="4.0"/>
  <xsl:template match="ViewFindWaitingListDetails">
    <xsl:for-each select="ViewFindWaitingListDetail">
      <table cellpadding="1" cellspacing="0" width="100%" style="table-layout: fixed">
        <xsl:if test="$ForPrinting = 0">
          <xsl:attribute name="onmouseover">EnableAlphaFilter(this);</xsl:attribute>
          <xsl:attribute name="onmouseout">DisableAlphaFilter(this);</xsl:attribute>
        </xsl:if>
        <xsl:attribute name="id">
          a<xsl:value-of select="position()"/>b<xsl:value-of select="user:convertXMLDateTimeToMins(string(@StartDateTime))"/>
        </xsl:attribute>
        <xsl:attribute name="bgcolor">
          <xsl:choose>
            <xsl:when test="position() mod 2 = 0">whitesmoke</xsl:when>
            <xsl:otherwise>white</xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <col width="65"/>
        <col width="15"/>
        <col/>
        <tr valign="top">
          <td>
            <xsl:choose>
              <xsl:when test="$ForPrinting = 0">
                <a href="#" class="std" title="Click here to edit this waiting list detail">
                  <xsl:attribute name="onclick">
                    iMedica.WaitingList.Edit('<xsl:value-of select="@RelWaitingListWaitingListDetailUid"/>');
                  </xsl:attribute>
                  <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@StartDateTime))"/>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <span class="std">
                  <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@StartDateTime))"/>
                </span>
              </xsl:otherwise>
            </xsl:choose>
            <br/>
            <xsl:choose>
              <xsl:when test="$ForPrinting = 0">
                <xsl:choose>
                  <xsl:when test="@Color">
                    <span style="COLOR:{user:convertXMLColorHex (string (@Color))};" class="small">
                      <xsl:value-of select="string(@PriorityDescription)"/>
                      <xsl:text> </xsl:text>
                    </span>
                  </xsl:when>
                  <xsl:otherwise>
                    <span class="small">
                      <xsl:value-of select="string(@PriorityDescription)"/>
                      <xsl:text> </xsl:text>
                    </span>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <span class="small">
                  <xsl:value-of select="string(@PriorityDescription)"/>
                  <xsl:text> </xsl:text>
                </span>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td>
            <xsl:if test="@isCommitted = '1'">
              <img src="../images/smlock.gif" width="11" height="11" border="0" alt="Medical record complete"/>
            </xsl:if>
          </td>
          <td class="std">
            <xsl:choose>
              <!-- this is an event waiting list detail -->
              <xsl:when test="string(@PatientUid) = ''">

                <xsl:if test="string(@AppointmentTypeUid) != ''">
                  <span style="COLOR:{user:convertXMLColorHex(string(@ApptTypeColor))};">
                    <xsl:value-of select="string(@AppointmentType)"/>
                  </span>:<xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="@Notes"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="$ForPrinting = 0">
                    <a href="#" title="Click here to view this patient's demographics">
                      <xsl:attribute name="onclick">
                        iMedica.Common.NavigateToDemographic("<xsl:value-of select="@PatientUid"/>");
                      </xsl:attribute>
                      <xsl:value-of select="@PatientName"/>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@PatientName"/>
                  </xsl:otherwise>
                </xsl:choose> (<xsl:choose>
                  <xsl:when test="string(@Birthdate) = ''">?</xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="user:convertXMLDateTimeToDateStr(string(@Birthdate))"/>
                  </xsl:otherwise>
                </xsl:choose>, <xsl:choose>
                  <xsl:when test="string(@MedicalRecordNumber) = ''">?</xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@MedicalRecordNumber"/>
                  </xsl:otherwise>
                </xsl:choose>) <xsl:if test="string(@PhoneNumber) != ''">
                  ,<xsl:text> </xsl:text><xsl:value-of select="@PhoneNumber"/><xsl:text> </xsl:text>
                </xsl:if>
                <xsl:if test="$ForPrinting = 0">
                  <img src="../images/moreArrow.gif" width="19" height="13" class="handcursor" title="Click here for more options">
                    <xsl:attribute name="onclick">
                      showContextMenu('<xsl:value-of select="@RelWaitingListWaitingListDetailUid"/>', 'a<xsl:value-of select="position()"/>b<xsl:value-of select="user:convertXMLDateTimeToMins(string(@StartDateTime))"/>')
                    </xsl:attribute>
                  </img>
                </xsl:if>
                <br/>
                <xsl:if test="string(@AppointmentTypeUid) != ''">
                  <span style="COLOR:{user:convertXMLColorHex(string(@ApptTypeColor))};">
                    <xsl:value-of select="string(@AppointmentType)"/>
                    <xsl:text> </xsl:text>
                  </span>:<xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="@Notes"/>
              </xsl:otherwise>
            </xsl:choose>
            <br/>
            <xsl:if test="string(@ProviderUid) != ''">
              <span class="std">
                Provider:<xsl:text> </xsl:text>
              </span>
              <span>
                <xsl:value-of select="string(@ProviderName)"/>
              </span>:<xsl:text> </xsl:text>
            </xsl:if>
            <br/>
            <xsl:if test="string(@ServiceSiteUid) != ''">
              <span class="std">
                Service Site:<xsl:text> </xsl:text>
              </span>
              <span>
                <xsl:value-of select="string(@ServiceSiteName)"/>
              </span>:<xsl:text> </xsl:text>
            </xsl:if>
          </td>
        </tr>
        <tr height='5'>
          <td/>
        </tr>
      </table>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="error">
    <table class="std" border="0" cellpadding="1" cellspacing="0" width="100%" style="table-layout: fixed">
      <tr>
        <td>
          <b>Server Error: </b>
          <xsl:value-of select="."/>
          <br/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <msxsl:script language="Jscript" implements-prefix="user">
    <![CDATA[
function convertXMLDateTimeTo12HRTime(strDate)
{
  if ((strDate.length == 0) || (strDate == "null") || (strDate == "undefined"))
    return 'N/A'
	var oDate = new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
	var hour = parseInt(oDate.getHours(), 10);
	var mins = parseInt(oDate.getMinutes(), 10);
	return '' + (hour == 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + ':' +  (mins < 10 ? ('0' + mins) : mins) + (hour < 12 ? ' AM' : ' PM');
}

function convertXMLDateTimeToDateStr(strDate)
{
  if ((strDate.length == 0) || (strDate == "null") || (strDate == "undefined"))
    return 'N/A'
	var oDate = new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
	return '' + (oDate.getMonth() + 1) + '/' + oDate.getDate() + '/' + oDate.getFullYear();
}

function convertXMLDateTimeToMins(strDate)
{
  if ((strDate.length == 0) || (strDate == "null") || (strDate == "undefined"))
    return 'N/A'
	var oDate = new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
	var hour = parseInt(oDate.getHours(), 10);
	var mins = parseInt(oDate.getMinutes(), 10);
	return hour * 60 + mins;
}
function convertXMLColorHex (strColor)
{
  if (strColor == "FFFFFF")
    return "#000000"
  return '#' + strColor;
}
]]>
  </msxsl:script>

</xsl:stylesheet>