﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
    <xsl:output method="xml" indent="yes"/>

    <xsl:variable name="itmCount" select="0" />

    <xsl:template match="/">
      <xsl:element name="claim">
        <!--xsl:attribute name="seq">
          <xsl:text>1</xsl:text>
        </xsl:attribute -->
        <xsl:attribute name="controlnumber">
          <xsl:value-of select="Superbill/@SuperbillUid" />
        </xsl:attribute>
        <xsl:call-template name="fld-00" />
        <xsl:call-template name="fld-01" />
          <xsl:apply-templates select="Superbill/PatientNames" />
          <xsl:call-template name="fld-03" />
          <fld-04 last="" first="" middle="" />
          <xsl:call-template name="fld-05" />
          <xsl:call-template name="fld-06" />
          <fld-07 addr="" city="" state="" zip="" phone="" />
          <fld-08 single="" married="" other="" full-time="" part-time="" />
          <xsl:call-template name="fld-09" />
          <fld-10 employ-yes="" employ-no="" auto-yes="" auto-no="" auto-state="" oth-yes="" oth-no="" />
          <xsl:call-template name="fld-11" />
          <fld-12 signed="" m="" d="" y="" />
          <fld-13 signed="" />
          <xsl:call-template name="fld-14" />
          <fld-15 m="" d="" y="" qual="" />
          <fld-16 fm="" fd="" fy="" tm="" td="" ty="" />
          <xsl:call-template name="fld-17" />
          <fld-18 fm="" fd="" fy="" tm="" td="" ty="" />
          <fld-19 area1="" area2="" />
          <fld-20 out-yes="" out-no="" charges="" />
          <xsl:call-template name="fld-21" />
          <fld-22 resub="" org="" />
          <fld-23 prior="" />
          <xsl:call-template name="fld-24" />
          <fld-25 taxid="" ssn="" ein="" />
          <fld-26 acct-num="" />
          <fld-27 asg-yes="" asg-no="" />
          <fld-28 total="" />
          <fld-29 paid="" />
          <fld-30 due="" />
          <fld-31 signed="" m="" d="" y="" name="" />
          <xsl:call-template name="fld-32" />
          <xsl:call-template name="fld-33" />
      </xsl:element>
  </xsl:template>

  <xsl:template name="fld-00">
    <xsl:element name="fld-00">
      <xsl:attribute name="payer">
        <xsl:value-of select="Superbill/InsurancePayerName"/>
      </xsl:attribute>
      <xsl:attribute name="addr" />
      <xsl:attribute name="city" />
      <xsl:attribute name="state" />
      <xsl:attribute name="zip" />
      <xsl:attribute name="payer-id">
        <xsl:value-of select="Superbill/InsurancePayerExternalId"/>
      </xsl:attribute>
    </xsl:element>
  </xsl:template>

  <xsl:template name="fld-01">
        <xsl:element name="fld-01">
            <xsl:choose>
                <xsl:when test="Superbill/InsuranceAccountType = 'MA' or Superbill/InsuranceAccountType = 'MB'">
                    <xsl:attribute name="medicare">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="medicaid" />
                    <xsl:attribute name="champus" />
                    <xsl:attribute name="champva" />
                    <xsl:attribute name="group" />
                    <xsl:attribute name="feca" />
                    <xsl:attribute name="oth" />
                </xsl:when>
                <xsl:when test="Superbill/InsuranceAccountType = 'MC'">
                    <xsl:attribute name="medicare" />
                    <xsl:attribute name="medicaid">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="champus" />
                    <xsl:attribute name="champva" />
                    <xsl:attribute name="group" />
                    <xsl:attribute name="feca" />
                    <xsl:attribute name="oth" />
                </xsl:when>
                <xsl:when test="Superbill/InsuranceAccountType = 'CH'">
                    <xsl:attribute name="medicare" />
                    <xsl:attribute name="medicaid" />
                    <xsl:attribute name="champus">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="champva" />
                    <xsl:attribute name="group" />
                    <xsl:attribute name="feca" />
                    <xsl:attribute name="oth" />
                </xsl:when>
                <xsl:when test="Superbill/InsuranceAccountType = 'VA'">
                    <xsl:attribute name="medicare" />
                    <xsl:attribute name="medicaid" />
                    <xsl:attribute name="champus" />
                    <xsl:attribute name="champva">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="group" />
                    <xsl:attribute name="feca" />
                    <xsl:attribute name="oth" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="medicare" />
                    <xsl:attribute name="medicaid" />
                    <xsl:attribute name="champus" />
                    <xsl:attribute name="champva" />
                    <xsl:attribute name="group" />
                    <xsl:attribute name="feca" />
                    <xsl:attribute name="oth">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:attribute name="ins-id">
                <xsl:value-of select="Superbill/InsurancePlanMemberID"/>
            </xsl:attribute>
            <xsl:attribute name="auto" />
            <xsl:attribute name="wc" />
            <xsl:attribute name="com" />
            <xsl:attribute name="fbcs" />
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="fld-03">
        <xsl:element name="fld-03">
          <xsl:choose>
            <xsl:when test="count(Superbill/PatientDOB) > 0">
              <xsl:apply-templates select="Superbill/PatientDOB" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="m" />
              <xsl:attribute name="d" />
              <xsl:attribute name="y" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Superbill/PatientCurrentSexInitial) > 0">
              <xsl:apply-templates select="Superbill/PatientCurrentSexInitial" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="sex-m" />
              <xsl:attribute name="sex-f" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-05">
        <xsl:element name="fld-05">
            <xsl:choose>
                <xsl:when test="count(Superbill/PatientPrimaryAddresses) > 0">
                    <xsl:apply-templates select="Superbill/PatientPrimaryAddresses" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="addr" />
                    <xsl:attribute name="city" />
                    <xsl:attribute name="state" />
                    <xsl:attribute name="zip" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:attribute name="phone" />
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-06">
        <xsl:element name="fld-06">
            <xsl:choose>
                <xsl:when test="/Superbill/RelationToInsured = 'self'">
                    <xsl:attribute name="self">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="spouse" />
                    <xsl:attribute name="child" />
                    <xsl:attribute name="other" />
                </xsl:when>
                <xsl:when test="/Superbill/RelationToInsured = 'spouse'">
                    <xsl:attribute name="self" />
                    <xsl:attribute name="spouse">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="child" />
                    <xsl:attribute name="other" />
                </xsl:when>
                <xsl:when test="/Superbill/RelationToInsured = 'child'">
                    <xsl:attribute name="self" />
                    <xsl:attribute name="spouse" />
                    <xsl:attribute name="child">
                        <xsl:text>1</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="other" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="self" />
                    <xsl:attribute name="spouse" />
                    <xsl:attribute name="child" />
                    <xsl:choose>
                        <xsl:when test="string-length(/Superbill/RelationToInsured) > 0">
                            <xsl:attribute name="other">
                                <xsl:text>1</xsl:text>
                            </xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:attribute name="other" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
    </xsl:template>

    <xsl:template name="fld-09">
        <fld-09 last="" first="" middle="" policy="" dobm="" dobd="" doby="" sex-m="" sex-f="" />
    </xsl:template>

    <xsl:template name="fld-11">
        <xsl:element name="fld-11">
            <xsl:attribute name="policy" />
          <xsl:choose>
            <xsl:when test="count(Superbill/AccountResponsibleDOB) > 0">
              <xsl:apply-templates select="Superbill/AccountResponsibleDOB" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="m" />
              <xsl:attribute name="d" />
              <xsl:attribute name="y" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Superbill/AccountResponsibleGenderInitial) > 0">
              <xsl:apply-templates select="Superbill/AccountResponsibleGenderInitial" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="sex-m" />
              <xsl:attribute name="sex-f" />
            </xsl:otherwise>
          </xsl:choose>
            <xsl:attribute name="emp-name" />
            <xsl:attribute name="plan-name">
                <xsl:value-of select="Superbill/InsurancePlanName"/>
            </xsl:attribute>
            <xsl:attribute name="oth-yes" />
            <xsl:attribute name="oth-no" />
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="fld-14">
        <xsl:element name="fld-14">
            <xsl:apply-templates select="Superbill/ServiceDate" />
            <xsl:attribute name="illness" />
            <xsl:attribute name="accident" />
            <xsl:attribute name="lmp" />
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-17">
        <xsl:element name="fld-17">
            <xsl:attribute name="name" />
            <xsl:attribute name="id-qual" />
            <xsl:attribute name="id-num" />
            <xsl:attribute name="npi" />
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-21">
        <xsl:element name="fld-21">
          
          <xsl:choose>
            <xsl:when test="Superbill/Diagnoses[@ICD10Payer = 'True']">
              <xsl:attribute name="dx-version">ABK</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx-version">BK</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
                <xsl:when test="count(Superbill/Diagnoses) > 0">
                    <xsl:apply-templates select="Superbill/Diagnoses" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="dx1" />
                    <xsl:attribute name="dx2" />
                    <xsl:attribute name="dx3" />
                    <xsl:attribute name="dx4" />
                    <xsl:attribute name="dx5" />
                    <xsl:attribute name="dx6" />
                    <xsl:attribute name="dx7" />
                    <xsl:attribute name="dx8" />
                    <xsl:attribute name="dx9" />
                    <xsl:attribute name="dx10" />
                    <xsl:attribute name="dx11" />
                    <xsl:attribute name="dx12" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-24">
        <fld-24>
            <xsl:apply-templates select="Superbill/Procedures" />
            <xsl:choose>
                <xsl:when test="count(Superbill/Procedures/Procedure) = 1">
                    <itm02 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm03 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm04 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm05 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm06 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                </xsl:when>
                <xsl:when test="count(Superbill/Procedures/Procedure) = 2">
                    <itm03 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm04 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm05 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm06 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                </xsl:when>
                <xsl:when test="count(Superbill/Procedures/Procedure) = 3">
                    <itm04 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm05 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm06 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                </xsl:when>
                <xsl:when test="count(Superbill/Procedures/Procedure) = 4">
                    <itm05 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                    <itm06 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                </xsl:when>
                <xsl:when test="count(Superbill/Procedures) = 5">
                    <itm06 fm="" fd="" fy="" tm="" td="" ty="" pos="" cpt="" m1="" m2="" m3="" m4="" ptr="" charge="" unit="" epsdt="" emg="" id-qual="" id-num="" npi="" />
                </xsl:when>
            </xsl:choose>
        </fld-24>
    </xsl:template>

    <xsl:template name="fld-32">
        <xsl:element name="fld-32">
            <xsl:attribute name="name">
              <xsl:value-of select ="Superbill/ServiceSiteName" />
            </xsl:attribute>
            <xsl:attribute name="addr" />
            <xsl:attribute name="city" />
            <xsl:attribute name="state" />
            <xsl:attribute name="zip">
                <xsl:value-of select="Superbill/ServiceSiteAddresses/ServiceSiteAddressZip" />
            </xsl:attribute>
          <xsl:attribute name="npi" />
            <xsl:attribute name="id-num" />
            <xsl:attribute name="clia" />
            <xsl:attribute name="mammo" />
        </xsl:element>
    </xsl:template>

  <xsl:template name="fld-33">
    <xsl:element name="fld-33">
      <xsl:attribute name="name" />
      <xsl:attribute name="addr" />
      <xsl:attribute name="city" />
      <xsl:attribute name="state" />
      <xsl:attribute name="zip" />
      <xsl:attribute name="phone" />
      <xsl:attribute name="npi">
        <xsl:value-of select="/Superbill/ClaimingProviderIdentifierNPI"/>
      </xsl:attribute>
      <xsl:attribute name="id-num" />
    </xsl:element>

  </xsl:template>
  
    <xsl:template match="Superbill/PatientNames">
        <xsl:element name="fld-02">
            <xsl:attribute name="last" >
                <!--xsl:value-of select="PatientLastName"/ -->
            </xsl:attribute>
            <xsl:attribute name="first" >
                <!--xsl:value-of select="PatientFirstName"/ -->
            </xsl:attribute>
            <xsl:attribute name="middle" >
                <!--xsl:value-of select="PatientMiddleName"/ -->
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="Superbill/PatientDOB">
        <xsl:apply-templates select="MonthDayYear" />
    </xsl:template>

    <xsl:template match="Superbill/AccountResponsibleDOB">
        <xsl:apply-templates select="MonthDayYear" />
    </xsl:template>

    <xsl:template match="Superbill/PatientCurrentSexInitial">
        <xsl:attribute name="sex-m">
            <xsl:choose>
                <xsl:when test="../PatientCurrentSexInitial = 'M'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="sex-f">
            <xsl:choose>
                <xsl:when test="../PatientCurrentSexInitial = 'F'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Superbill/AccountResponsibleGenderInitial">
        <xsl:attribute name="sex-m">
            <xsl:choose>
                <xsl:when test="../AccountResponsibleGenderInitial = 'M'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="sex-f">
            <xsl:choose>
                <xsl:when test="../AccountResponsibleGenderInitial = 'F'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Superbill/PatientPrimaryAddresses">
        <xsl:attribute name="addr">
            <!--xsl:value-of select="PatientPrimaryAddressLine1" />
            <xsl:value-of select="PatientPrimaryAddressLine2" / -->
        </xsl:attribute>
        <xsl:attribute name="city">
            <!--xsl:value-of select="PatientPrimaryAddressCity" / -->
        </xsl:attribute>
        <xsl:attribute name="state">
            <!--xsl:value-of select="PatientPrimaryAddressState" / -->
        </xsl:attribute>
        <xsl:attribute name="zip">
            <xsl:value-of select="PatientPrimaryAddressZip" />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Superbill/PatientPhones">
        <xsl:attribute name="phone">
            <xsl:value-of select="PatientMainPhone" />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Superbill/ServiceDate">
        <xsl:apply-templates select="MonthDayYear" />
    </xsl:template>

    <xsl:template match="MonthDayYear">
        <xsl:param name="prefix" />
        <xsl:choose>
            <xsl:when test="string-length($prefix) > 0">
                <xsl:attribute name="{concat($prefix, 'm')}">
                    <xsl:value-of select="substring(., 1, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="{concat($prefix, 'd')}">
                    <xsl:value-of select="substring(., 4, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="{concat($prefix, 'y')}">
                    <xsl:value-of select="substring(., 7, 4)"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="m">
                    <xsl:value-of select="substring(., 1, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="d">
                    <xsl:value-of select="substring(., 4, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="y">
                    <xsl:value-of select="substring(., 7, 4)"/>
                </xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="Superbill/Diagnoses">
        <xsl:apply-templates select="Diagnosis" />
        <xsl:if test="count(Diagnosis) = 1">
            <xsl:attribute name="dx2" />
            <xsl:attribute name="dx3" />
            <xsl:attribute name="dx4" />
            <xsl:attribute name="dx5" />
            <xsl:attribute name="dx6" />
            <xsl:attribute name="dx7" />
            <xsl:attribute name="dx8" />
            <xsl:attribute name="dx9" />
            <xsl:attribute name="dx10" />
            <xsl:attribute name="dx11" />
            <xsl:attribute name="dx12" />
        </xsl:if>
        <xsl:if test="count(Diagnosis) = 2">
            <xsl:attribute name="dx3" />
            <xsl:attribute name="dx4" />
            <xsl:attribute name="dx5" />
            <xsl:attribute name="dx6" />
            <xsl:attribute name="dx7" />
            <xsl:attribute name="dx8" />
            <xsl:attribute name="dx9" />
            <xsl:attribute name="dx10" />
            <xsl:attribute name="dx11" />
            <xsl:attribute name="dx12" />
        </xsl:if>
        <xsl:if test="count(Diagnosis) = 3">
            <xsl:attribute name="dx4" />
            <xsl:attribute name="dx5" />
            <xsl:attribute name="dx6" />
            <xsl:attribute name="dx7" />
            <xsl:attribute name="dx8" />
            <xsl:attribute name="dx9" />
            <xsl:attribute name="dx10" />
            <xsl:attribute name="dx11" />
            <xsl:attribute name="dx12" />
        </xsl:if>
      <xsl:if test="count(Diagnosis) = 4">
        <xsl:attribute name="dx5" />
        <xsl:attribute name="dx6" />
        <xsl:attribute name="dx7" />
        <xsl:attribute name="dx8" />
        <xsl:attribute name="dx9" />
        <xsl:attribute name="dx10" />
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 5">
        <xsl:attribute name="dx6" />
        <xsl:attribute name="dx7" />
        <xsl:attribute name="dx8" />
        <xsl:attribute name="dx9" />
        <xsl:attribute name="dx10" />
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 6">
        <xsl:attribute name="dx7" />
        <xsl:attribute name="dx8" />
        <xsl:attribute name="dx9" />
        <xsl:attribute name="dx10" />
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 7">
        <xsl:attribute name="dx8" />
        <xsl:attribute name="dx9" />
        <xsl:attribute name="dx10" />
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 8">
        <xsl:attribute name="dx9" />
        <xsl:attribute name="dx10" />
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 9">
        <xsl:attribute name="dx10" />
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 10">
        <xsl:attribute name="dx11" />
        <xsl:attribute name="dx12" />
      </xsl:if>
      <xsl:if test="count(Diagnosis) = 11">
        <xsl:attribute name="dx12" />
      </xsl:if>
    </xsl:template>
    
    <xsl:template match="Diagnosis">
        <xsl:choose>
            <xsl:when test="position() &lt; 13" >
                <xsl:attribute name="{concat('dx', position())}">
                    <xsl:value-of select="." />
                </xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="Superbill/ProviderNames">
        <xsl:attribute name="name">
            <xsl:value-of select="ProviderFullName"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Procedures">
        <xsl:apply-templates select="Procedure" />
    </xsl:template>
    
    <xsl:template match="Procedure">
        <xsl:element name="{concat('itm0', position())}">
            <xsl:choose>
                <xsl:when test="count(@DoNotClaim) > 0">
                    <xsl:attribute name="fm" />
                    <xsl:attribute name="fd" />
                    <xsl:attribute name="fy" />
                    <xsl:attribute name="tm" />
                    <xsl:attribute name="td" />
                    <xsl:attribute name="ty" />
                    <xsl:attribute name="pos" />
                    <xsl:attribute name="cpt" />
                    <xsl:attribute name="m1" />
                    <xsl:attribute name="m2" />
                    <xsl:attribute name="m3" />
                    <xsl:attribute name="m4" />
                    <xsl:attribute name="ptr" />
                    <xsl:attribute name="charge" />
                    <xsl:attribute name="unit" />
                    <xsl:attribute name="epsdt" />
                    <xsl:attribute name="emg" />
                    <xsl:attribute name="id-qual" />
                    <xsl:attribute name="id-num" />
                    <xsl:attribute name="npi" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="FromDate/MonthDayYear" >
                        <xsl:with-param name="prefix" select="'f'" />
                    </xsl:apply-templates>
                    <xsl:apply-templates select="ToDate/MonthDayYear" >
                        <xsl:with-param name="prefix" select="'t'" />
                    </xsl:apply-templates>
                    <xsl:attribute name="pos" >
                        <xsl:value-of select="ServiceSitePOS" />
                    </xsl:attribute>
                    <xsl:attribute name="cpt" >
                        <xsl:value-of select="CPT"/>
                    </xsl:attribute>
                    <xsl:call-template name="Modifier" >
                        <xsl:with-param name="nameof" select="'m1'" />
                        <xsl:with-param name="valueof" select="Modifiers/Modifier1" />
                    </xsl:call-template>
                    <xsl:call-template name="Modifier" >
                        <xsl:with-param name="nameof" select="'m2'" />
                        <xsl:with-param name="valueof" select="Modifiers/Modifier2" />
                    </xsl:call-template>
                    <xsl:call-template name="Modifier" >
                        <xsl:with-param name="nameof" select="'m3'" />
                        <xsl:with-param name="valueof" select="Modifiers/Modifier3" />
                    </xsl:call-template>
                    <xsl:call-template name="Modifier" >
                        <xsl:with-param name="nameof" select="'m4'" />
                        <xsl:with-param name="valueof" select="Modifiers/Modifier4"  />
                    </xsl:call-template>
                    <xsl:attribute name="ptr">
                        <xsl:apply-templates select="RelatedDiagnoses" />
                    </xsl:attribute>
                    <xsl:attribute name="charge">
                        <xsl:value-of select="ProcedureCharge" />
                    </xsl:attribute>
                    <xsl:attribute name="unit">
                        <xsl:value-of select="Unit"/>
                    </xsl:attribute>
                    <xsl:attribute name="epsdt">
                        <xsl:choose>
                            <xsl:when test="count(EPSDT) > 0">
                              <xsl:text>1</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:attribute name="emg">
                        <xsl:choose>
                            <xsl:when test="count(Emergency) > 0">
                              <xsl:text>1</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:attribute name="id-qual">
                    </xsl:attribute>
                    <xsl:attribute name="id-num">
                    </xsl:attribute>
                    <xsl:attribute name="npi">
                        <xsl:value-of select="/Superbill/ClaimingProviderIdentifierNPI"/>
                    </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template match="RelatedDiagnoses">
        <xsl:apply-templates select="RelatedDiagnosis[. &lt; 13]" />
    </xsl:template>

    <xsl:template match="RelatedDiagnosis">
        <xsl:choose>
            <xsl:when test="position() = 1">
                <xsl:value-of select="."/>
            </xsl:when>
          <xsl:otherwise>
            <xsl:text>,</xsl:text><xsl:value-of select="."/>
          </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="Modifier">
        <xsl:param name="nameof" />
        <xsl:param name="valueof" />
        <xsl:choose>
            <xsl:when test="string-length($valueof) > 0">
                <xsl:attribute name="{$nameof}">
                    <xsl:value-of select="$valueof"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="{$nameof}" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>

